'use strict';
function search(SearchText, inHeading) {
(function () {
var Page = [];

/* Generated with Author-it 23.4.1.30004  12/3/2025 5:47:53 PM */
Page[0]=new Array("Title and Copyright Information","Copyright   2025, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information","46576.htm");
Page[1]=new Array("Scope","Oracle WebLogic server is an application server you can use to deploy your P6 EPPM applications. This guide describes how to manage and configure WebLogic settings to optimize the performance of your P6 EPPM applications:","P6","P6 Team Member","P6 Professional Cloud Connect","P6 EPPM Web Services, and P6 Integration API)","It also describes how to configure eventing for P6.","Audience","System and network administrators should use this guide.","Using This Guide","This guide assumes that you have already installed a supported version of WebLogic and a JDK. For more information, see the Tested Configurations document.","About This Guide","93096.htm");
Page[2]=new Array("To delete your P6 EPPM and help from WebLogic:","Launch the WebLogic Administration Console using the following URL:","http://serverIP:listenport/console","In the Domain Structure&nbsp;pane, click Deployments.","In the Control tab, in the Summary of Deployments&nbsp;pane, complete the following:","Select the following applications:","p6","p6procloudconnect","p6tm","p6ws","pr","PrimaveraAPI","p6help.war","p6tmhelp.war","prhelp.war","Click Stop and then click Force Stop Now.","In the Force Stop Application Assistant pane, click Yes.","For each application and help, ensure that the State column shows Prepared.","Select the applications and help that you stopped.","Click Delete.","In the Delete Application Assistant pane, click Yes.","Tip If you plan to use the same home directory for the new help or tutorial deployments, delete the existing WAR or EAR&nbsp;file from that directory to avoid conflict with the new files.","Deleting Applications and Help from WebLogic","93098.htm");
Page[3]=new Array("If you are upgrading your P6 EPPM applications to the latest version, you must uninstall all earlier versions of your P6 EPPM applications. You can uninstall your P6 EPPM applications using Oracle Universal Installer.","To uninstall your P6 EPPM applications:","Delete your Applications from WebLogic. For more information, see Deleting Applications and Help from WebLogic.","From the P6 EPPM installation folder, do one of the following:","With Windows, navigate to the win\\Disk1\\install folder, and double-click setup.exe.","With UNIX or Linux, enter the following commands:","cd &lt;Operating System&gt;/Disk1/install<br />chmod 755 runInstaller<br />chmod 755 unzip<br />./runInstaller","where &lt;Operating System&gt; is linux, or solaris_64.","On the Welcome screen, click Deinstall Products.","In the Inventory dialog box, select the following:","P6 &lt;Release_Level&gt;","P6 Professional Cloud Connect &lt;Release_Level&gt;","P6 Integration API &lt;Release_Level&gt;","P6 Web Services &lt;Release_Level&gt;","P6 Team Member &lt;Release_Level&gt;","P6 Progress Reporter &lt;Release_Level&gt;","Click Remove.","On the Confirmation dialog box, click Yes.","Click Close then Cancel to exit the dialog box and Oracle Universal Installer.","Uninstalling P6 EPPM Applications","93091.htm");
Page[4]=new Array("You must uninstall any previous versions of P6 before upgrading to the latest version of P6.","Cautions","Before upgrading P6, you should upgrade the P6 EPPM database to the current version. See P6 EPPM Upgrade and Configuration Guide or P6 EPPM Manual Upgrade Guide for your database for details on how to upgrade your database and for information on potential impact areas to your environment. For the full list of tested configurations for P6, go to the \\Documentation\\&lt;language&gt;\\Tested_Configurations folder of the P6 EPPM physical media or download.","If you are a current Apache JackRabbit user and want to upgrade to the latest version of P6 EPPM, JackRabbit documents data will not migrate automatically. Refer to My Oracle Support's Knowledge Articles for information on manually migrating JackRabbit documents to Oracle Universal Content Management. Oracle recommends that you migrate the data before upgrading.","If you are a current jBPM user and want to upgrade P6 EPPM, workflows and reviews data will not be available. You should close all workflows and reviews that are in progress before upgrading. You cannot migrate any of this data to the latest version of P6 EPPM.","Starting with P6 EPPM R8, all recurring job service functions are hosted by P6. Due to this change, after upgrading to P6 EPPM R8 or later, you must configure Scheduled Services settings in the Primavera P6 Administrator to use this functionality. Also, if you're upgrading from version 7.0 or earlier, you must RESUMMARIZE ALL PROJECTS to accurately reflect your summary data. See the P6 EPPM System Administration Guide for information on Scheduled Services and configuring separate servers for job services.","Tip","For security reasons, Oracle strongly recommends that on-premises users replace the default Admin Superuser (admin) immediately after a manual database installation or an upgrade from P6 version 7.0 and earlier. See information on the default Admin Superuser in the P6 EPPM Application Administration Guide for guidelines on this process. See information about the Admin Superuser in the P6 EPPM Application Administration Guide.","P6 EPPM does not support Summary-Only projects. During the P6 EPPM database upgrade, existing Summary-Only projects convert to standard projects, but lose all summary data. You can import the summary project from Microsoft Project into the converted blank project, then summarize the data. See the P6 Professional Help or the P6 Help.","During the upgrade to the latest version of P6 EPPM, some P6 Activity Views settings will reset. After the upgrade, use the Customize Detail Windows feature to modify the settings that should appear for each view. See the P6 Help for information on how to edit Activity Views.","Starting with P6 EPPM R8, P6 saves filter definitions globally. Filters still work for Activity Views, but all standard filter assignments reset during the upgrade. Due to this change, views that had Standard Filters applied will show all activities after the upgrade. Reapply filters after the upgrade finishes. See the P6 Help for information on how to edit Activity Views.","Uninstalling Previous Versions of P6","7165.htm");
Page[5]=new Array("For information about how to install the P6 EPPM applications, see the P6 EPPM Installation and Configuration Guide.","Installing P6 EPPM Applications","98204.htm");
Page[6]=new Array("You have two options for accessing Help:","Use the Default P6 Help URL (Recommended)","The default URL will take you to the version hosted by Oracle, and is the most up-to-date documentation. ","The default help URLs are in the Primavera P6 Administrator.","Note You can choose not to use the default help URL, but you will have to ensure you deploy it in your application server and enter the server URL into the Primavera P6 Administrator. If any updates are made to the help, these will not be visible if you are using the p6help.war file. ","Use the P6 Help WAR File","You can download the online help WAR files from the following URLs:","P6 Help: https://docs.oracle.com/cd/G18294_01/p6help/war/P6_Help.zip","P6 Team Member Help: https://docs.oracle.com/cd/G18294_01/team_member/web/help/war/TM_Help.zip","Note For the Helps to launch, you must enter the server URLs in the Primavera P6 Administrator. See the P6 EPPM System Administration Guide for more information.","Tip","If you receive a &quot;server not found&quot; or a similar error when accessing the help in the application, it means one of the following:","The application server cannot access the Internet.","The help site is not available.","If the application server cannot access the Internet, check your Primavera P6 Administrator settings and ensure they are configured to the correct URL.","If the URL is configured correctly, but you still cannot access the application help, you will need to deploy the help using the WAR file.","Help Directory Installation","32720.htm");
Page[7]=new Array("This section details the basic configuration steps for P6 EPPM applications in a WebLogic environment when opting for an Admin Server and Managed Server deployment. ","Oracle recommends you create a Managed Server deployment. Each managed server requires exclusive access to its own rotating logfiles. If your managed and clustered servers are on the same machine, you must create a different P6 home folder for each managed server and then copy the BREBootstrap file into each folder. You must edit the BREBootstrap file to ensure the logDir setting is set to the folder unique to each managed server. If your Admin, Managed, and clustered servers are all on the same machine, you do not need to copy the BREBootstrap file. This section assumes that you set up separate domains for your applications; however, you can create one domain and configure all P6 EPPM applications to run in this domain.","Although not required for the P6 EPPM server setup, WebLogic has additional settings that can be used to enhance your environment. For example, when using clustering, enabling the session replication setting will seamlessly transfer users to another server if a server shuts down unexpectedly.","See the official WebLogic documentation for more information on setting up WebLogic Windows Services and all available WebLogic configuration and deployment options. ","Configuring WebLogic for P6 EPPM","12890.htm");
Page[8]=new Array("A domain can include multiple WebLogic Server clusters and non-clustered WebLogic Server instances. A minimal domain can contain only one WebLogic Server instance, which functions as both an Administration Server and as a Managed server. This domain can be useful while developing applications, but it is not recommended for use in a production environment. Although the scope and purpose of a domain can vary significantly, most WebLogic Server domains contain the components described in this section.","By default, the WebLogic domain created by the P6 EPPM Configuration Wizard creates a domain with an Administration Server (AdminServer) and a Managed Server for each application that you deploy. If you are installing P6 EPPM manually, Oracle recommends you create a managed server for each P6 EPPM application you deploy, similar to the P6 EPPM Configuration Wizard. For example:","P6","P6 Team Member","P6 Professional Cloud Connect","P6 EPPM Web Services","P6 Integration API","Note If you plan to enable Oracle Web Services Manager Authentication, skip the following procedure and refer to Creating a Domain for Oracle Web Services Manager Authentication for instructions on creating a domain.","To create a domain:","To create a WebLogic Domain:","Run the WebLogic Configuration Wizard.","In the Create Domain&nbsp;window:","Select Create a new WebLogic domain.","In the Domain Location field, enter the location that you want to create the domain.","Click Next.","In the Templates&nbsp;window, select the templates that you want to apply to the domain and click Next.","In the Administrator Account&nbsp;window:","Enter the user name and password information.","Click Next.","In the Domain Mode&nbsp;window: ","Select Production Mode. ","Select a JDK. ","Click Next.","In the Advanced Configuration window:","Select the Administration Server, Managed Servers, and Managed Servers, Clusters and Coherence.","Click Next.","In the Administration Server window: ","(Optional) Select Enable SSL and set the SSL listen port if you are enabling Secure Sockets Layer communication.","Click Next.","See https://docs.oracle.com/middleware/1221/core/ASADM/sslconfig.htm for more details on setting SSL for WebLogic.","In the Node Manager window:","Select a Node Manager Type.","In the Username and Password fields, enter the credentials for the Node Manager.","Click Next.","In the Managed Servers window:","Click Add.","Enter the Name and select the Listen address information.","(Optional) Select the SSL enabled option and set the SSL listen port.","(Optional) Add or delete other managed servers.","Click Next.","In the Clusters window:","Note Do not add clusters if you are not using multiple WebLogic server instances for scalability.","(Optional) Click Add.","(Optional) Enter the name of the cluster.","(Optional) Enter the following information: Cluster messaging mode, Multicast address, Multicast port, and Cluster address.","(Optional) Add or delete other configured clusters.","Click Next.","Note For information on setting up clusters, use Oracle's WebLogic Server documentation: https://docs.oracle.com/middleware/1221/wls/CLUST/setup.htm.","(Optional) In the Assign Servers to Clusters window, assign a server to a cluster and then click Next.","Note Select the Cluster in the right pane, then select the Server in the left pane. Assign the server to the cluster by clicking the right arrow button.","In the Machines window, select Machine (with Windows) and then complete the following:","Click Add.","Enter a machine name.","(Optional) Select the Node manager listen address from the list.","Note If you specify an address for a machine that hosts the Administration Server and you need to access the WebLogic Server Node Manager, you must disable the host name verification.","(Optional) Enter the Node manager listen port.","(Optional) Add or delete configured machines.","(Optional) Click Next.","In the Machines window, select Unix Machine (with UNIX) and the complete the following:","Click Add.","Enter a machine name.","(Optional) Select the Post bind GID enabled option to enable a server running on this machine to bind to a UNIX group ID (GID) after it finishes all privileged startup actions.","(Optional) Enter the Post bind GID where a server on this machine will run after it finishes all privileged startup actions. If you do not enter a GID, the server will continue to run under the group where it was started. For this setting to work, you must select the Post bind GID enabled option.","(Optional) Select the Post bind UID enabled option to enable a server running on this machine to bind to a UNIX user ID (UID) after it finishes all privileged startup actions.","(Optional) Enter Post bind UID where a server on this machine will run after it finishes all privileged startup actions. If you do not enter a UID, the server will continue to run under the account where it was started. For this setting to work, you must select the Post bind UID enabled option.","(Optional) Add or delete configured machines.","Click Next.","Note","You might want to create machine definitions for the following situations: (1) The Administration Server uses the machine definition (along with the Node Manager application) to start remote servers. (2) WebLogic Server uses configured machine names when determining the server in a cluster that can handle certain tasks, such as HTTP session replication. The WebLogic Server then delegates those tasks to the identified server.","You must configure machines for each product installation that runs a Node Manager process. The machine configuration must include values for the listen address and port number parameters.","In the Assign Servers to Machines window:","Note A machine is a physical server that will host a WebLogic managed server. Depending on your resource needs and data load, the machines may be in the same physical server where the WebLogic Admin Server is installed or in separate physical servers.","In the Machine list, select the machine where you want to assign a WebLogic Server instance.","Assign the managed and administrative servers that you created to the selected machine.","Review the machine assignments.","Click Next.","In the Configuration Summary window, click Create.","If given the option, you can click Done now. Otherwise, continue to the next step.","If you are using Windows, in the Creating Domain window:","Select Start Admin Server.","Click Done.","When prompted, enter the administrator user name and password that you entered above.","Repeat this procedure for each new domain.","Creating a Domain with Servers","93090.htm");
Page[9]=new Array("You can choose from several methods for authenticating P6 EPPM Web Services calls when you configure P6 EPPM Web Services in Primavera P6 Administrator. Oracle Web Services Manager (OWSM) is among the supported methods. ","Note If you select OWSM as the authentication mode for P6 EPPM Web Services, only OWSM authentication can be used. OWSM receives the authentication request and will perform the authentication instead of passing the authentication request to P6 EPPM Web Services.","To create a domain and administration server for P6 EPPM Web Services:","Open the Fusion Middleware Configuration Wizard by completing the following:","Navigate to &lt;Oracle_Home&gt;\\oracle_common\\common\\bin.","Run config.cmd (if Windows) or config.sh (if UNIX).","On the Configuration Type screen, complete the following:","Select Create a new domain.","Browse to the location at which the new domain will be created.","On the Template screen, complete the following:","Select Create Domain Using Product Templates:","In the Template Categories menu, select All Templates.","Select the following from the Available Templates window:","Basic WebLogic Server Domain","Oracle Enterprise Manager","Oracle WSM Policy Manager","Oracle JRF","WebLogic Coherence Cluster Extension","On the Administrator Account screen, complete the following:","In the Name field, enter a name for the domain administrator.","In the Password field, enter a password for the domain administrator.","In the Confirm Password field, enter the password that you entered in the Password field.","On the Domain Mode and JDK screen, complete the following:","Under Domain Mode, select one of the following:","Development","Production","Under JDK, select a supported JDK. For supported JDKs, see Tested Configurations.","On the Database Configuration Type screen, complete the following:","Under Specify AutoConfiguration Options Using:, select RCU Data.","Fill in each field, using the connection information that you specified for the Service Table component in the Repository Creation Utility (RCU).","Click Get RCU Configuration to retrieve the schema information.","In the Schema Password field, enter the password for the schema owner.","On the JDBC Components Schema screen, complete the following:","Fill in each field, using the connection information that you specified for the Service Table component in the Repository Creation Utility (RCU).","In the Schema Password fields of the table, enter the password for each component schema.","Select the schema in the table.","Click Test Selected Connections to ensure that the credentials for each schema are valid.","On the Advanced Configuration screen, select Administration Server.","On the Administration Server screen, complete the following:","In the Server Name field, enter a name for the administration server.","In the Listen Address field menu, select the appropriate listen address.","In the Listen Port field, enter the listen port number.","In the Server Groups menu, select the following:","WSM-CACHE-SVR","WSMPM-MAN-SVR","On the Configuration Summary screen, click Create.","After the domain has been created, complete the tasks in the Using Oracle Web Services Manager for Authentication section.","Creating a Domain for Oracle Web Services Manager Authentication","91756.htm");
Page[10]=new Array("After creating your WebLogic domains, you must add your P6 EPPM applications to your WebLogic domains.","To add P6 EPPM applications to WebLogic:","In the Change Center pane, click Lock &amp; Edit.","In the Domain Structure pane, click Deployments.","In the Configuration tab on the Summary of Deployments page, click Install.","In the Install Application Assistant&nbsp;window, complete the following:","Select the EAR or WAR file for the application or Help that you want to deploy. For each application and Help, you can find the EAR and WAR files at the following locations:","For P6, &lt;P6_EPPM_Home&gt;\\p6\\p6.ear","For P6 Team Member, &lt;P6_EPPM_Home&gt;\\tmws\\p6tm.ear","For P6 Professional Cloud Connect, &lt;P6_EPPM_Home&gt;\\p6procloudconnect\\p6procloudconnect.war","For P6 Integration API, &lt;P6_EPPM_Home&gt;\\api\\applications\\PrimaveraAPI.war","For P6 EPPM Web Services, &lt;P6_EPPM_Home&gt;\\ws\\server\\p6ws.ear","For P6 and P6 Team Member helps:","Go to https://docs.oracle.com/en/industries/construction-engineering/primavera-p6-project/index.html.","Click the 25 Documentation Library link.","Navigate to the Using page.","Click the Downloadable P6_Help link and the Downloadable TM_Help link.","Note For the Help to launch, you must enter the server URL in the Primavera P6 Administrator. See the P6 EPPM System Administration Guide for more information. Oracle recommends that you do not deploy the P6 or P6 Team Member Help because the default URL will take you to the version hosted by Oracle. The hosted version contains the most up-to-date documentation. ","Click Next.","On the Install Application Assistant&nbsp;page: ","Select Install this deployment as an application.","Click Next.","On the Install Application Assistant&nbsp;page:","Select the managed server.","Click Next.","In the Install Application Assistant&nbsp;pane, click Next&nbsp;to accept the default options.","Review the configuration settings you have chosen and then click Finish&nbsp;to complete the installation.","Repeat this procedure for each application on each domain.","In the Change Center pane, click Activate Changes.","Adding Applications and Help to Managed Servers","93093.htm");
Page[11]=new Array("Use these instructions for each P6 EPPM application that you deploy in a managed or clustered server. To continue configuring WebLogic for P6, you must add the following arguments to your managed or clustered server in the WebLogic Administration console.","To set WebLogic Server arguments: ","In the Change Center pane of the Administration Console, click Lock &amp; Edit.","On the Domain Structure pane, expand Environment and then click Servers.","In the Summary of Servers page, click the managed server on which you deployed your application or Help.","In Configuration tab, on the Settings for &lt;managed server name&gt; page, navigate to the Server Start tab.","In the Arguments field, enter the following arguments as necessary in the order that they appear:","-server","-Dprimavera.bootstrap.home=&lt;P6_EPPM_BootStrap_Home&gt;","where &lt;P6_EPPM_BootStrap_Home&gt; is the home directory of BREBootStrap.xml. If you do not have a BREBootStrap.xml file for your P6 EPPM implementation, you can create one by creating a P6 EPPM configuration using the Database Configuration wizard. For more information about using the Database Configuration wizard, see the P6 EPPM Database Administration Guide.","-Ddatabase.instance=db_id","Include this argument to establish a default database connection for P6 Team Member, P6 EPPM Web Services, and P6 Integration API if you use more than one database instance. You do not need to set this argument for P6.","-Dweblogic.webservice.i18n.charset=utf-8","(Optional) Include this argument to allow WebLogic to process UTF-8 characters.","-Djava.awt.headless=true","(With UNIX only) Include this argument if you are deploying P6 EPPM on a non-graphical UNIX environment. This argument sets the server's JVM to bypass server-side rendering optimizations. If you do not add the argument, you may not be able to see graphics on pages and the server logs will report NoClassDefFoundError errors.","-Djavax.xml.stream.XMLInputFactory=com.ctc.wstx.stax.WstxInputFactory","(Optional) Include this argument for improved performance when starting the WebLogic domain.","-XX:MaxPermSize=","(Optional) Include this argument to set the new generation heap size. The MaxPermSize setting should be set to at least 256m. You can modify memory settings to maximize performance.","-XX:NewSize=","(Optional) Include this argument to set the maximum size of the new generation heap size. As a general rule, set -XX:NewSize to be one-fourth the size of the heap size. Increase the value of this option for larger numbers of short-lived objects. Be sure to increase the new generation as you increase the number of processors. Memory allocation can be parallel, but garbage collection is not parallel.","-XX:MaxNewSize=","(Optional) Include this argument to set the maximum size of the new generation heap size.","-XX:SurvivorRatio=","(Optional) Include this argument to set new heap size ratios.","The New generation area is divided into three sub-areas: Eden, and two survivor spaces that are equal in size. Configure the ratio of the Eden/survivor space size. Try setting this value to 8, and then monitor your garbage collection.","-Xms -Xmx","(Optional) Include this argument to set the initial and maximum heap size. ","As a general rule, set the initial heap size (-Xms) equal to the maximum heap size (-Xmx) to minimize garbage collection.","-XX:+UseParallelGC -XX:+UseParallelOldGC -XX:GCTimeRatio=19","(Optional) Include this argument if you are running Publication Services on a larger database.","-Xloggc:&lt;Log_Path&gt;","Include this argument to collect garbage logs if you have memory issues on JVM.","For example:","(With Windows)","-server -Dprimavera.bootstrap.home=&lt;P6_EPPM_Home&gt; -Djavax.xml.stream.XMLInputFactory=com.ctc.wstx.stax.WstxInputFactory -XX:MaxPermSize=256m -XX:NewSize=256m -XX:MaxNewSize=256m -XX:SurvivorRatio=8 -Xms2048m -Xmx2048m -XX:+UseParallelGC -XX:+UseParallelOldGC -XX:GCTimeRatio=19 -Xloggc:&lt;Log_Path&gt;","(With UNIX)","-server -Dprimavera.bootstrap.home=&lt;P6_EPPM_Home&gt; -Djava.awt.headless=true -Djavax.xml.stream.XMLInputFactory=com.ctc.wstx.stax.WstxInputFactory -XX:MaxPermSize=256m -XX:NewSize=256m -XX:MaxNewSize=256m -XX:SurvivorRatio=8 -Xms2048m -Xmx2048m -XX:+UseParallelGC -XX:+UseParallelOldGC -XX:GCTimeRatio=19 -Xloggc:&lt;path to the log file&gt;","Note If you use additional arguments that are not listed here, be sure to list them in the correct sequence for your environment.","Click Save.","Add arguments to the managed servers on which applications or Help are deployed.","In the Change Center pane, click Activate Changes.","Restart your managed servers.","Setting Arguments","93150.htm");
Page[12]=new Array("Use these instructions for each P6 EPPM application that you deploy on an administration server.","To edit the setDomainEnv file:","Navigate to &lt;WebLogic_Home&gt;/user_projects/&lt;Domain_Home&gt;/bin and make a backup copy of the setDomainEnv.cmd (on Windows) setDomainEnv.sh (for UNIX).","Edit the setDomainEnv file.","After %WL_HOME%/common/bin/commEnv.cmd&quot; (on Windows) ${WL_HOME}/common/bin/commEnv.sh (on UNIX), enter the following arguments as necessary in the order that they appear:","-server","-Dprimavera.bootstrap.home=&lt;P6_EPPM_BootStrap_Home&gt;","where &lt;P6_EPPM_BootStrap_Home&gt; is the home directory of BREBootStrap.xml. If you do not have a BREBootStrap.xml file for your P6 EPPM implementation, you can create one by creating a P6 EPPM configuration using the Database Configuration wizard. For more information about using the Database Configuration wizard, see the P6 EPPM Database Administration Guide.","-Ddatabase.instance=db_id","Include this argument to establish a default database connection for P6 Team Member, P6 EPPM Web Services, and P6 Integration API if you use more than one database instance. You do not need to set this argument for P6.","-Dweblogic.webservice.i18n.charset=utf-8","(Optional) Include this argument to allow WebLogic to process UTF-8 characters.","-Djava.awt.headless=true","(With UNIX only) Include this argument if you are deploying P6 EPPM on a non-graphical UNIX environment. This argument sets the server's JVM to bypass server-side rendering optimizations. If you do not add the argument, you may not be able to see graphics on pages and the server logs will report NoClassDefFoundError errors.","-Djavax.xml.stream.XMLInputFactory=com.ctc.wstx.stax.WstxInputFactory","(Optional) Include this argument for improved performance when starting the WebLogic domain.","-XX:MaxPermSize=","(Optional) Include this argument to set the new generation heap size. The MaxPermSize setting should be set to at least 256m. You can modify memory settings to maximize performance.","-XX:NewSize=","(Optional) Include this argument to set the maximum size of the new generation heap size. As a general rule, set -XX:NewSize to be one-fourth the size of the heap size. Increase the value of this option for larger numbers of short-lived objects. Be sure to increase the new generation as you increase the number of processors. Memory allocation can be parallel, but garbage collection is not parallel.","-XX:MaxNewSize=","(Optional) Include this argument to set the maximum size of the new generation heap size.","-XX:SurvivorRatio=","(Optional) Include this argument to set new heap size ratios.","The New generation area is divided into three sub-areas: Eden, and two survivor spaces that are equal in size. Configure the ratio of the Eden/survivor space size. Try setting this value to 8, and then monitor your garbage collection.","-Xms -Xmx","(Optional) Include this argument to set the initial and maximum heap size. ","As a general rule, set the initial heap size (-Xms) equal to the maximum heap size (-Xmx) to minimize garbage collection.","-XX:+UseParallelGC -XX:+UseParallelOldGC -XX:GCTimeRatio=19","(Optional) Include this argument if you are running Publication Services on a larger database.","-Xloggc:&lt;Log_Path&gt;","Include this argument to collect garbage logs if you have memory issues on JVM.","For example:","(With Windows)","-server -Dprimavera.bootstrap.home=&lt;P6_EPPM_Home&gt; -Djavax.xml.stream.XMLInputFactory=com.ctc.wstx.stax.WstxInputFactory -XX:MaxPermSize=256m -XX:NewSize=256m -XX:MaxNewSize=256m -XX:SurvivorRatio=8 -Xms2048m -Xmx2048m -XX:+UseParallelGC -XX:+UseParallelOldGC -XX:GCTimeRatio=19 -Xloggc:&lt;Log_Path&gt;","(With UNIX)","-server -Dprimavera.bootstrap.home=&lt;P6_EPPM_Home&gt; -Djava.awt.headless=true -Djavax.xml.stream.XMLInputFactory=com.ctc.wstx.stax.WstxInputFactory -XX:MaxPermSize=256m -XX:NewSize=256m -XX:MaxNewSize=256m -XX:SurvivorRatio=8 -Xms2048m -Xmx2048m -XX:+UseParallelGC -XX:+UseParallelOldGC -XX:GCTimeRatio=19 -Xloggc:&lt;path to the log file&gt;","Note If you use additional arguments that are not listed here, be sure to list them in the correct sequence for your environment.","Save and Close the file.","Restart the admin server.","Modifying setDomainEnv for Applications Deployed on Administration Servers","32722.htm");
Page[13]=new Array("Use the steps in the related topics to begin using P6 mobile.","Finalizing P6 mobile","54132.htm");
Page[14]=new Array("To download the P6 mobile apps, do one of the following:","If you are using an iOS device, go to the Apple App Store to download the mobile application. ","If you are using an Android device, go to the Google Play Store to download the mobile application.","Note If you are in a region without access to the Google Play Store, or your organization is using a Content Security Service or Mobile Device Management solution and requires that users do not download P6 mobile from the Apple App Store or Google Play Store, submit a Service Request in My Oracle Support to request versions of the P6 mobile apps for those scenarios.","Downloading P6 mobile Apps","49001.htm");
Page[15]=new Array("Follow these steps to start the app for the first time. When you return to the app after working in other apps, the last page you were on will appear. Once you configure these settings, you won't need to perform these steps again unless your SSO cookies expire. If your cookies expire, you will need to enter your user name and password again.","Note You may need to activate your device's VPN feature to access your company's deployment of P6. Contact your administrator for more information.","To start the app:","On your device's Home screen, tap @ P6.","On the Welcome to P6 Team Member page, slide the Single Sign On (SSO) switch to either ON or OFF.","Note Team Member Web Services supports LDAP, Native, or SSO mode. Your administrator will select the authentication mode when they configure P6.","If you turn SSO on:","Tap the URL field and enter the URL to your server (for example, http://server:port/p6tmws). ","Note You will need to specify the server name and port number in the URL.","Tap Authenticate.","Enter your SSO username and password.","If you turn SSO off:","Tap the URL field and enter the URL to your server (for example, https://server:port/p6tmws). ","Enter your P6 username.","Enter your P6 password.","Tap Sign In.","Note","You will need to configure Email Statusing Service separately. See the P6 EPPM System Administration Guide.","P6 for iOS supports SSL (https) or HTTP only when it has a certificate signed by a trusted authority.","P6 for Android requires SSL (https) when you are not using SSO authentication. If you are using SSO authentication, you can use HTTP or HTTPs protocols. HTTPS requires a valid certificate from an Android trusted certifying authority.","Tip","To access server information in the app&#8212;which includes the SSO setting, the URL to access the server, and your user name&#8212;navigate to the app menu, and then tap Settings.","For more information on the different types of authentication modes (Single Sign-On, Native, or LDAP), see &quot;Authentication Modes in P6 EPPM&quot; in the P6 EPPM System Administration Guide.","You can modify the settings for the app from the Settings page on your iPhone. See the P6 Team Member User's Guide for more information.","Configuring Login and Authentication Settings to Use P6 for iOS","49002.htm");
Page[16]=new Array("Follow these steps to start the app for the first time. When you return to the app after working in other apps, the last page you were on will appear. Once you configure these settings, you won't need to perform these steps again unless your SSO cookies expire. If your cookies expire, you will need to enter your user name and password again.","Note You may need to activate your device's VPN feature to access your company's deployment of P6. Contact your administrator for more information.","P6 for Android only accepts SSL certificates from a certifying authority and must use an HTTPS connection.","To start the app:","On your device's Home screen, tap @ P6.","On the Welcome to P6 Team Member page, slide the Single Sign On (SSO) switch to either ON or OFF.","Note Team Member Web Services supports LDAP, Native, or SSO mode. Your administrator will select the authentication mode when they configure P6.","If you turn SSO on:","Tap the URL field and enter the URL to your server (for example, http://server:port/p6tmws). ","Note You will need to specify the server name and port number in the URL.","Tap Authenticate.","Enter your SSO username and password.","If you turn SSO off:","Tap the URL field and enter the URL to your server (for example, https://server:port/p6tmws). ","Enter your P6 username.","Enter your P6 password.","Tap Sign In.","Note","You will need to configure Email Statusing Service separately. See the P6 EPPM System Administration Guide.","P6 for iOS supports SSL (https) or HTTP only when it has a certificate signed by a trusted authority.","P6 for Android requires SSL (https) when you are not using SSO authentication. If you are using SSO authentication, you can use HTTP or HTTPs protocols. HTTPS requires a valid certificate from an Android trusted certifying authority.","Tip","To access server information in the app&#8212;which includes the SSO setting, the URL to access the server, and your user name&#8212;navigate to the app menu, and then tap Settings.","For more information on the different types of authentication modes (Single Sign-On, Native, or LDAP), see &quot;Authentication Modes in P6 EPPM&quot; in the P6 EPPM System Administration Guide.","You can modify the settings for the app from the Settings button in the app. See the P6 Team Member User's Guide for more information.","Configuring Login and Authentication Settings to Use P6 for Android","87134.htm");
Page[17]=new Array("Use the steps in the related topics to begin using P6 Team Member Web.","Finalizing P6 Team Member Web","55087.htm");
Page[18]=new Array("To configure the settings for P6 Team Member Web, you must have a P6 Team Member Admin Configuration. See Installing and Configuring P6 EPPM for more information on how to create this configuration during a new installation of P6 Team Member Web or P6 EPPM.","To configure the settings for P6 Team Member Web:","Launch Primavera P6 Administrator.","Navigate to your P6 Team Member configuration, and then expand it.","Expand Application:","Set the Help server URL to one of the following:","http://localhost:listenport/ContextRoot","where localhost is your server's host name, listenport is your P6 Team Member port number, and ContextRoot is the root for your Help.","https://docs.oracle.com/cd/E90746_01/team_member/web/help/","Note Oracle recommends that you use the second URL option because it ensures that you always access the latest version of the P6 Team Member Help, including critical corrections and enhancements.","Expand Team Member:","Expand Connection Pool if you want to alter the following default values:","Initial connection pool size: 10","Maximum active database connections: 150","Maximum idle database connections: -0","Minimum idle database connections: 10","Expand Logging if you want to alter the following default values:","Enable: enabled","Severity Level: Error","Log File Name: p6tmweb.log","Note","The primavera.bootstrap.home property determines the location of the log file.","Configuring P6 Team Member Web Settings","55075.htm");
Page[19]=new Array("To configure Email Statusing Service for P6:","From the P6 Team Member home directory (for example, C:\\P6EPPM_1\\tmws), extract the files from the p6tm-email-service.zip to any location on the application server. (That location will be referred to as EMAIL_HOME).","Make a backup copy of the config.properties file before you edit it.","Edit the config.properties file to configure the settings for the email application.","Note When you are finished editing the config.properties file, move it to a secure location.","In the P6 Configuration section, locate and specify the following:","In the p6.admin.user = line, specify a P6 user who is assigned to at least one module access and has resource access.","In the p6.notify.user= line, specify the email addresses, separated by commas, of users who can send Notify Task lists to other users. As you see the P6 Help for more information on sending team members their tasks.","In the p6.max.tmusers = line, specify the maximum number of email recipients that can receive notification emails at one time. You should keep the number below 500 to avoid performance problems.","In the p6.bootstrap = line, specify the location of the BREBootstrap.xml file.","For example, the location could be one of the following: C:/P6EPPM_1/p6, C:/EMAIL_HOME, /usr/P6EPPM_1/p6, or /usr/EMAIL_HOME or you can use the following: C:\\\\P6EPPM_1\\p6, C:\\\\EMAIL_HOME.","In the mail.read.schedule = line, specify how often your email should process new messages. Use cron expressions for your formatting. For example:","0 */5 * * * ?","will process new messages every five minutes.","Note For more information on cron expressions, see https://docs.oracle.com/cd/E12058_01/doc/doc.1014/e12030/cron_expressions.htm.","In the Outgoing mail (SMTP Settings) section, locate and specify the following:","In the send.host = line, specify the SMTP server hostname or IP address that you will use to send emails.","In the send.port = line, specify the port number that connects to the SMTP server.","In the send.ssl = line, specify true to use SSL or false if you will not use SSL.","Note Oracle recommends that you always use SSL in a production environment for secure communications.","In the send.starttls = line, specify true to use TLS or false if you will not use TLS.","In the send.email = line, specify the email address or User Principal Name (UPN) where team members will send their status update requests.","In the send.replyto = line, specify an email address for team members to respond to when they receive emails. If this field is left blank, the reply address will be the send.email address you specified above.","In the send.password = line, specify the password for the email address or UPN you just specified. ","Note","If you do not specify a password now, the email application prompts you to specify one when it runs. ","You can also specify a password by running the following parameter when you run the 'run.bat' or 'run.sh' file:<br />-Dsend.password=YOUR_PASSWORD<br />where Your_Password is the password for your status email address.<br />For example: <br />In Windows: ./run.bat -Dsend.password=YOUR_PASSWORD<br />In UNIX: ./run.sh -Dsend.password=YOUR_PASSWORD","Oracle recommends using the option in the config.properties file and then moving that file to a secure location when you are finished modifying it.","If you want to set up anonymous authentication for an SMTP server, comment this field out.","In the Incoming Mail (IMAP Settings) section, locate and specify the following:","In the imap.host = line, specify the IMAP protocol host to read emails.","In the imap.port = line, specify the IMAP port number.","In the imap.ssl= line, specify true to use SSL or false if you will not use SSL.","NoteOracle recommends that you always use SSL in a production environment for secure communications.","In the imap.username = line, specify the IMAP user name (which will be your email address) or User Principal Name (UPN).","In the imap.password = line, specify the password for the user name you just specified.","Note","If you do not specify a password now, the email application will ask you to specify one when it runs. ","You can also specify a password by running the following parameter when you run the 'run.bat' or 'run.sh' file:<br />-Dimap.password=YOUR_PASSWORD<br />where Your_Password is the password for your status email address.<br />For example: <br />In Windows: ./run.bat -Dimap.password=YOUR_PASSWORD<br />In UNIX: ./run.sh -Dimap.password=YOUR_PASSWORD","Oracle recommends using the option in the config.properties file and then moving that file to a secure location when you are finished modifying it.","If you want to setup anonymous authentication for an SMTP server, comment this field out.","In the imap.search.folder = line, specify the folder to use for processing incoming emails. For example:","imap.search.folder = inbox","Note The email application will use this folder to search for incoming mail. Oracle recommends you use the inbox for this folder. If you select another folder, you must ensure that all emails get filtered there, or the email application will not be able to detect the messages.","In the IMAP Folder configuration section, locate and specify the following:","In the imap.success.folder = line, specify the folder where messages that process successfully will go. For example:","imap.success.folder = P6Success","Note The email application will automatically create this folder if you do not create it now.","In the imap.failure.folder = line, specify the folder where messages that failed will go. For example:","imap.failure.folder = P6Fail","Note The email application will automatically create this folder if you do not create it now.","In the imap.temp.folder = line, specify the folder where messages that are being processed will go. For example: ","imap.temp.folder = P6Temp","Note The email application will automatically create this folder if you do not create it now.","In the Task update options section, locate and specify the following:","In the reply.label.cleanup field, enter true if you want to remove HTML tags attached to the task field labels. Enter false if you don't want to remove the tags.","In the reply.label.tag.search field, enter the regular expression to remove unexpected HTML tags during reply message parsing.","Note See information on &quot;regular expression&quot; for more details on this field. For example, see https://developer.mozilla.org/en-US/docs/JavaScript/Guide/Regular_Expressions#Writing_a_Regular_Expression_Pattern.","In the update.debug field, enter true if you want to output the contents of the email message as it is parsed for updates. Enter false if you don't want to output the contents of the email message as it is parsed for updates. You should only enter true when you are troubleshooting issues with updating tasks. ","In the Message Format options section, locate and specify the following:","In the update.task.search.term = line, specify the text that the email application should search for in the subject line of incoming messages. For example:","update.task.search.term = Your Requested P6 Tasks","In the notify.update.task.search.term = line, specify the text that the email application should search for in the subject line of incoming messages that originated from a Notify message. For example:","update.task.search.term = Your P6 Tasks","If the EMAIL_HOME is on a different server from your P6 home, copy the BREBootstrap.xml from your P6 home to your EMAIL_HOME.","If the EMAIL_HOME is on the same server as your P6 home, you will use the BREBootstrap.xml that is in your P6 home folder.","Run one of the following:","In Windows, launch the run.bat file.","In UNIX, launch the run.sh file.","When you launch the run file, you may have to complete the following steps depending on how you configured your Email Statusing Service:","If the config.properties file and the run file are in different folders, you will need to specify the config.properties location with the -Dconfig.file parameter.","In Windows (add a space between run.bat and -Dconfig):","run.bat -Dconfig.file=C:\\home\\auser\\somelocation\\config.properties","In UNIX (add a space between run.sh and -Dconfig): ","./run.sh -Dconfig.file=/home/auser/somelocation/config.properties","If you didn't specify the send.password= or imap.password=, you can specify them now. If you do not specify them now, the email application will prompt you to do so when it runs.","In Windows: ","run.bat -Dsend.password=YOUR_PASSWORD","In UNIX:","./run.sh -Dsend.password=YOUR_PASSWORD","In Windows:","run.bat -Dimap.password=YOUR_PASSWORD","In UNIX:","./run.sh -Dimap.password=YOUR_PASSWORD","where Your_Password is the password for your status email address","If your bootstrap file contains more than one database, you need to clarify which database you are using when you launch the run file.","In Windows:","run.bat -Ddatabase.instance=db_id","where db_id is your database instance (for example, -Ddatabase.instance=2).","In UNIX: ","./run.sh -Ddatabase.instance=db_id","where db_id is your database instance (for example, -Ddatabase.instance=2).","Once the run file finishes, you can verify that the email status application works. See Verifying Email Statusing Service.","Note Anonymous SMTP authentication is supported.","Configuring Email Statusing Service for P6","49980.htm");
Page[20]=new Array("Once you have installed the email status application, you can send an email to verify that the server is setup properly.","To verify your Email Statusing Service setup:","Enter an email address that P6 recognizes in the 'From' line.","Enter the email address you specified in Configuring Email Statusing Service for P6 in the 'To' line.","Enter Ping in the subject line.","Send the message.","If the message is successful, you will receive a message containing the status of the email service. The message will tell you how many users have a blank email address in the database.","If the message failed, you will not receive a message. The failed message will appear in the failure folder that you specified in the config.properties file. See Configuring Email Statusing Service for P6.","Verifying Email Statusing Service","49982.htm");
Page[21]=new Array("Follow the instructions to deploy P6 Integration API into the WebLogic domain.","Note","Consult WebLogic's documentation for additional methods of deploying a Web application, such as using a Managed Server or Clustering.","P6 EPPM Web Services supports the HTTPS communication protocol. See the application server documentation for instructions on configuring HTTPS on your application server.","Deploying P6 EPPM Web Services in WebLogic","35676.htm");
Page[22]=new Array("If you do not have a JDK Home folder specified, you must create an endorsed folder to deploy P6 EPPM Web Services in WebLogic.","To create an endorsed folder:","Locate the folder that contains the JDK you used when you created the WebLogic domain. This folder is known as &lt;JDK_HOME&gt;.","If it does not already exist, create an endorsed folder: &lt;JDK_HOME&gt;/jre/lib/endorsed.","In the &lt;WS_INSTALL_HOME&gt;/endorsed folder, locate the saaj-impl.jar file.","Copy the saaj-impl.jar file to the endorsed folder you created (&lt;JDK_HOME&gt;/jre/lib/endorsed).","Restart the WebLogic domain.","Creating an Endorsed Folder","47316.htm");
Page[23]=new Array("Before starting P6 EPPM Web Services, add the following JVM option to the startWeblogic startup script:","Make a backup copy of the startWebLogic&nbsp;file in case you need to undo any changes.","In Windows, the file is named &quot;startWebLogic.cmd&quot; and is located in:<br />weblogic_home\\user_projects\\domains\\your_domain\\bin\\","In Unix, the file is named &quot;startWebLogic.sh&quot; and is located in:<br />weblogic_home/user_projects/domains/your_domain/bin/","Right-click the startWebLogic file and select Edit.","Locate the line that begins with &quot;set JAVA_OPTIONS=&quot; and add these variables (as all one line with no space between &quot;-&quot; and &quot;Dprimavera&quot; or &quot;-&quot; and &quot;Djavax&quot;).","On Windows:","set JAVA_OPTIONS=%SAVE_JAVA_OPTIONS% -Djavax.xml.soap.MessageFactory=com.sun.xml.messaging.saaj.soap.ver1_1.SOAPMessageFactory1_1Impl -Djavax.xml.soap.SOAPConnectionFactory=weblogic.wsee.saaj.SOAPConnectionFactoryImpl<br />-Dprimavera.bootstrap.home=&lt;WS_INSTALL_HOME&gt;","where &lt;WS_INSTALL_HOME&gt; is the P6 EPPM Web Services home directory the you set during installation","On Linux:","JAVA_OPTIONS=&quot;${SAVE_JAVA_OPTIONS} -Djavax.xml.soap.MessageFactory=com.sun.xml.messaging.saaj.soap.ver1_1.SOAPMessageFactory1_1Impl -Djavax.xml.soap.SOAPConnectionFactory=weblogic.wsee.saaj.SOAPConnectionFactoryImpl<br />-Dprimavera.bootstrap.home=&lt;WS_INSTALL_HOME&gt;&quot;","where &lt;WS_INSTALL_HOME&gt; is the P6 EPPM Web Services home directory the you set during installation","Adding a JVM Option to the startWeblogic Script","53292.htm");
Page[24]=new Array("Oracle Web Services Manager (OWSM) provides the business agility to respond to security threats and security breaches by allowing policy changes to be enforced in real time without interrupting running business processes.","The benefits of using OWSM with P6 EPPM include:","Centrally define and store security policies applied to P6 EPPM Web Services.","Monitor run time security events such as failed authentication or authorization.","Avoid the need for developers to understand security specifications and security implementation details.","Visibility and control of the policies through a centralized administration interface offered by Oracle Enterprise Manager.","Note If you select OWSM as the authentication mode for P6 EPPM Web Services, only OWSM authentication can be used. OWSM receives the authentication request and will perform the authentication instead of passing the authentication request to P6 EPPM Web Services.","To configure the server to authenticate user credentials using OWSM:","Launch the Primavera P6 Administrator and log in.","In the Primavera P6 Administrator, click the Configurations tab, and expand Web Services/Security.","In the Security node, click Authentication:","On the Authentication page, select OWSM - SOAP.","Click Save.","Using Oracle Web Services Manager for Authentication","91745.htm");
Page[25]=new Array("Ensure that you have installed Oracle Fusion Middleware SOA Suite and have created the Oracle MDS and OPSS schema. Oracle MDS schema is a prerequisite for the Oracle Fusion Middleware SOA Suite. Oracle OPPS schema is needed to extend the P6 EPPM Web Services domain to work with the Fusion MIddleware SOA Suite. ","For information on how to create the Oracle MDS and OPSS schema, see the Oracle Fusion Middleware Creating Schemas with the Repository Creation Utility guide on Oracle Technical Network.","Prerequisites for Oracle Web Services Manager Authentication","91747.htm");
Page[26]=new Array("To enable OWSM authentication using WebLogic Enterprise Manager:","Create a user in security realms of the Weblogic Administration Console.","Log in to the WebLogic Administration Console as an administrative user using the following URL:","http://&lt;Host_Name&gt;:&lt;Port&gt;/console","In the Change Center pane, select Lock &amp; Edit.","In the Domain Structure pane, select Security Realms.","Select myrealm in the security realm list. ","In the Settings for myream page, select Users and Groups.","Note The name of the tab reflects the name of the security realm that you selected.","In the Users toolbar, click New and then complete the following:","In the Name field, enter a name for the user.","In the Password field, enter a password for the user.","In the Confirm Password field, re-enter the password from the previous field.","Click OK.","Note The user added in security realms should also exist in the P6 EPPM database.","Log in to WebLogic Enterprise Manager using the following URL:","http://&lt;Host_Name&gt;:&lt;Port&gt;/em","Navigate to the P6 EPPM domain using the Target Navigation directory.","Deploy P6 EPPM Web Services, using p6ws.ear, in WebLogic Enterprise Manager. ","For information on how to deploy P6 EPPM Web Services in WebLogic Enterprise Manager, refer to the Deploying ADF Applications Using Fusion Middleware Control section of the Oracle Fusion Middleware Administering Oracle Fusion Middleware guide.","Create a WSM Policy Set using the following settings:","On the Create Policy Set: Enter Resource Scope page, in the Type of Resources menu, select SOAP Web Service.","On the Create Policy Set: Enter Resource Scope page, complete the following:","In the Domain Name field, enter the name of the domain on which &lt;0P_ProdName_P6_WS is deployed.","In the Application Module Name or Connection Name field, enter p6ws.war.","On the Edit Policy Set: Add PolicyReferences page, attach an OWSM policy to the Policy Set.","Note For detailed instructions on how to create a WSM Policy Set, refer to the instructions in Using Fusion Middleware Control section under Creating a Policy Set in the Fusion Middleware Security and Administrator's Guide for Web Services guide.","Select OWSM as the authentication mode in Primavera P6 Administrator.","Log in to Primavera P6 Administrator using the following URL:","http://&lt;Host_Name&gt;:&lt;Port&gt;/p6/action/adminconfig","Expand your P6 EPPM configuration.","Expand Web Services/Security/Authentication.","In the Mode field, select Owsm.","Click Save.","Restart the P6 EPPM Web Services server.","Enabling Oracle Web Services Manager Authentication Using WebLogic Enterprise Manager","91746.htm");
Page[27]=new Array("To enable OWSM authentication for P6 Team Member using WebLogic Enterprise Manager:","Log in to WebLogic Enterprise Manager using the following URL:","http://&lt;Host_Name&gt;:&lt;Port&gt;/em","Navigate to the P6 Team Member domain using the Target Navigation directory.","Right-click the P6 Team Member domain and then select Web Services and WSM Policy Sets.","Click Create.","Create a WSM Policy Set using the following settings:","On the Create Policy Set: Enter Resource Scope page, in the Type of Resources menu, select SOAP Web Service.","On the Create Policy Set: Enter Resource Scope page, complete the following:","In the Domain Name field, enter the name of the domain on which P6 EPPM Web Services is deployed.","In the Application Module Name or Connection Name field, enter p6tm.war.","On the Edit Policy Set: Add PolicyReferences page, select oracle/multi_token_rest_service_policy.","Note For detailed instructions on how to create a WSM Policy Set, refer to the instructions in Using Fusion Middleware Control section under Creating a Policy Set in the Fusion Middleware Security and Administrator's Guide for Web Services guide.","Create a user in security realms of the Weblogic Administration Console.","Log in to the WebLogic Administration Console as an administrative user using the following URL:","http://&lt;Host_Name&gt;:&lt;Port&gt;/console","In the Change Center pane, select Lock &amp; Edit.","In the Domain Structure pane, select Security Realms.","Select myrealm in the security realm list. ","In the Settings for myream page, select Users and Groups.","Note The name of the tab reflects the name of the security realm that you selected.","Restart WebLogic and ensure that you can see the LDAP users in Users and Groups.","Note The user added in security realms should also exist in the P6 EPPM database.","Navigate to the Provider tab.","Click New.","In the Create a New Authentication Provider window, complete the following:","In the Name field, enter a name for the authentication provider.","In the Type list, select LDAPAuthenticator.","Click OK.","In the Provider tab, select the provider that you just created.","In the Control Flag list, select SUFFICIENT and then click Save.","Navigate to the Provider Specific tab.","Enter the details for your LDAP server in the Connection and Users sections.","Restart the WebLogic server.","Enabling Oracle Web Services Manager Authentication for P6 Team Member Using WebLogic Enterprise Manager","92944.htm");
Page[28]=new Array("This chapter describes how to install the P6 Integration API.","Installing P6 Integration API","38133.htm");
Page[29]=new Array("When P6 or p6service.jar runs on a server other than a P6 Integration API Remote Mode server and the &quot;Job Service Shared Folder Location&quot; configuration in the Primavera P6 Administrator is set to null, attempting an XML import from a P6 Professional deployment that uses Cloud Connect will cause the XML import process to fail. The import process fails because the temporary XML file for the project import is created under the P6 Integration API home directory but not the P6 or p6services.jar server, which runs the import code.","Setting the Job Service Shared Folder Location configuration to a shared directory that can be utilized by all P6 modules allows the temporary XML file to be stored in a common location that can be accessed by P6 Integration API Remote Mode server as well as the modules which have potential to run services, such as XML import.","For more information about when you must create a shared folder for P6 Integration API and P6, see the following article on My Oracle Support:","Primavera P6 XML Import Error &quot;Cannot Schedule job. Please contact administrator to correct the problem&quot; or &quot;The job request you submitted did not complete successfully&quot; And The Log File Displays &quot;$path\\importer_RMI_####.xml (No such file or directory)&quot; (Doc ID 1987004.1)","To ensure that you can successfully implement an XML import when P6 Integration API Remote Mode and P6 or p6service.jar resides on different servers:","Add a shared mount (if Linux) or commonly mapped drive (if Windows) to the following locations:","The P6 application servers","The P6 Integration API application servers","The P6 EPPM Web Services application servers","The server that runs p6services.jar","Note If you are using Windows, the drive letter that you use for the mapping must be the same across all servers.","Create a directory on the mount or drive on which temporary files can be created (for example, /P6EPPM/Temp). ","Log in to Primavera P6 Administrator.","Expand Services and then click Job Service Shared File Location.","In the Job Service Shared File Location field, enter the location of the shared directory.","Click Save Changes.","Restart the application servers that are associated with the changes.","Creating a Shared Folder for P6 Integration API and P6","90013.htm");
Page[30]=new Array("This section describes how to start and stop server instances in WebLogic Server. The method you choose depends on whether you prefer using the WebLogic Server Administration Console or a command line, and on whether you are using Node Manager to manage the server's life cycle.","Starting and Stopping Servers","93156.htm");
Page[31]=new Array("A domain can include multiple WebLogic Server clusters and non-clustered WebLogic Server instances. A minimal domain can contain only one WebLogic Server instance, which functions both as an Administration Server, and as a Managed server&#8212;such a domain can be useful while developing applications, but is not recommended for use in a production environment. Although the scope and purpose of a domain can vary significantly, most WebLogic Server domains contain the components described in this section.","By default, the WebLogic domain created by the P6 EPPM Configuration Wizard creates a domain with an administration server (AdminServer) and a managed server for each application that you deploy.","Starting and Stopping the Domain","93157.htm");
Page[32]=new Array("To start WebLogic:","Navigate to the weblogic_home/user_projects/domains/your_domain directory.","Run startWeblogic.cmd (with Windows) startWeblogic.sh (with UNIX).","If prompted for a user name and password in the WebLogic console window, enter the administrative user name and password you specified when creating the domain.","Note If you enabled the WebLogic precompile option, the WebLogic console displays &quot;Server started in RUNNING mode&quot; when precompiling finishes. For detailed information about enabling precompilation, see your WebLogic Server documentation.","Starting the Domain","41666.htm");
Page[33]=new Array("To stop WebLogic:","Navigate to &lt;WebLogic_Home&gt;/user_projects/domain/&lt;P6_EPPM_Domain&gt;/bin.","Where:","&lt;WebLogic_Home&gt; is the WebLogic home directory. The default is Oracle/Middleware/Oracle_Home. ","&lt;P6_EPPM_Domain&gt; is the WebLogic domain for P6 EPPM that was set during configuration.","Run stopWeblogic.sh.","If prompted for a user name and password in the WebLogic console window, enter  the administrative user name and password you specified when creating the domain.","Stopping the Domain","93076.htm");
Page[34]=new Array("You have several options for starting and stopping managed servers. Oracle recommends that you use the startNodeManager file and start the server in the WebLogic Administration Console (see Starting a Managed Server). However, you can view other ways to stop and start managed servers at &quot;Managing Server Startup and Shutdown for Oracle WebLogic Server&quot; at https://docs.oracle.com/middleware/1221/wls/START/overview.htm.","Note You can use different ways to start the managed servers, but you must ensure that the managed servers recognize the arguments required for your application (for example, the argument for where the bootstrap is located) and how the application environment will start.","Starting and Stopping Managed Servers","48157.htm");
Page[35]=new Array("Note When starting/stopping an environment using the node manager, the StartScriptEnabled setting in the nodemanager.properties file must equal true. Example: StartScriptEnabled=true","To start a managed server in the WebLogic Administration Console:","Run one of the following:","(with Windows)","&lt;weblogic_home&gt;\\server\\bin\\startNodeManager.cmd","(with UNIX or Linux)","&lt;weblogic_home&gt;\\server\\bin\\startNodeManager.sh","Launch the WebLogic Administration Console.","Note You can open the Administration Console via a web browser at http://&lt;serverIP&gt;:&lt;listenport&gt;/console. The default &lt;listenport&gt; is 7001.","In the Welcome&nbsp;window, log in using the user name and password that you created when you created your WebLogic domain.","On the Change Center pane of the Administration Console, click Lock &amp; Edit.","In the Domain Structure pane:","Expand Environment.","Click Servers.","In the Summary of Servers pane:","Select the Control tab.","Select the option for your managed server.","Click Start.","In the Server Life Cycle Assistant pane, click Yes.","In the Summary of Servers pane, click the 'Start Refresh' icon in the middle of the pane to see when the State column says 'RUNNING.'","Starting a Managed Server","50104.htm");
Page[36]=new Array("To stop a managed server:","In the Change Center pane, click Lock &amp; Edit.","In the Domain Structure&nbsp;pane, click Deployments.","In the Summary of Deployments&nbsp;pane, select the managed server that you want to stop.","In the Summary of Deployments&nbsp;pane, navigate to the Control tab and then complete the following:","Click the down arrow to the right of the Stop&nbsp;button.","Click one of the options to stop the managed server.","In the Start Application Assistant&nbsp;pane, click Yes.","In the Change Center pane, click Release Configuration.","Stopping a Managed Server","50105.htm");
Page[37]=new Array("Node Manager is a Java utility that runs as a separate process from WebLogic Server and allows you to perform common operations for a managed server regardless of its location to the Administration Server. The WebLogic Scripting Tool (WLST) is a command-line scripting interface that system administrators use to monitor and manage WebLogic Server instances and domains.","Using the node manager and WLST is optional, but it provides benefits if your WebLogic Server environment hosts applications with high availability requirements. If you run the node manager on a machine that hosts managed servers, you can start and stop the managed servers remotely using the WebLogic Console or from the command line using WLST as a node manager client. Using the node manager and WLST to control a WebLogic domain will ensure you do not need to manually modify the domain file to pass customized application java parameters, which eliminates the risk of distorting the files.","Oracle recommends controlling a WebLogic Domain through the node manager for the P6 EPPM WebLogic domain, instead of using individual Windows services per administration and managed server. ","Note A node manager process is not associated with a specific WebLogic domain but with a machine. You can use the same node manager process to control server instances in any WebLogic Server domain as long as the server instances reside on the same machine as the node manager process. The node manager must run on each computer that hosts WebLogic server instances -- whether administration server or managed server -- that you want to control with the node manager.","Follow the steps in the following sections to control a WebLogic domain with the node manager. If you intend to control the node manager with Windows, refer to Using the WebLogic Scripting Tool on Windows. If you intend to control the node manager with Linux or UNIX, refer to Using the WebLogic Scripting Tool on Linux or UNIX.","For more information on the node manager and WLST, refer to the Oracle WebLogic server documentation.","Configuring the Node Manager to Start and Stop Servers","65779.htm");
Page[38]=new Array("Refer to the following sections to configure the node manager with Windows.","Using the WebLogic Scripting Tool on Windows","88383.htm");
Page[39]=new Array("In previous releases of WebLogic, a node manager process was not associated with a specific WebLogic domain but with a host machine. You used the same node manager process to control server instances in any WebLogic domain as long as the server instances resided on the same machine, a machine-scoped, per host node manager. In this release of WebLogic Server, the node manager is now configured individually, per domain, and each domain will contain a unique node manager process.","To install the node manager as a Windows service:","Log in to the WebLogic server with administrative privileges.","Modify the installNodeMgrSvc.cmd file so that it does not hard code the node manager hostname and port in the registry.","Browse to &lt;WebLogic_Server_Home&gt;\\server\\bin.","Open installNodeMgrSvc.cmd in a text editor.","Locate the following lines in the file:","set NODEMGR_HOST=localhost","set NODEMGR_PORT=5556","Note","If lines set NODEMGR_HOST=localhost and set NODEMGR_PORT=5556 do not exist, close the file and skip steps 2d and 2e.","Comment out the lines by adding @rem to the beginning of the lines. For example:","@rem set NODEMGR_HOST=localhost","@rem set NODEMGR_PORT=5556","Save the changes, and then close the file.","Browse to &lt;WebLogic_domain_home&gt;\\bin.","Open installNodeMgrSvc.cmd in a text editor.","Locate the following lines in the file:","set NODEMGR_HOST=localhost","set NODEMGR_PORT=5556","Comment out the lines by adding @rem to the beginning of the lines. For example:","@rem set NODEMGR_HOST=localhost","@rem set NODEMGR_PORT=5556","Save the changes, and then close the file.","Open the command window, and then complete the following steps:","Change the directory to &lt;WebLogic_domain_home&gt;\\bin.","Enter the following command:","installNodeMgrSvc.cmd","Close the command window.","Browse to Windows Services, and then start the Oracle WebLogic &lt;domain_name&gt; NodeManager service.","Starting the Node Manager with WebLogic","89007.htm");
Page[40]=new Array("To automate the startup of the Admin and managed server using WLST:","Note If you are using P6 EPPM R8.2 or higher and you used the P6 EPPM Configuration Wizard to create the WebLogic domain, steps 1-6 below have already been completed.","Create a userConfigFile and userKeyFile:","Start the WebLogic Domain's AdminServer by launching weblogic_home\\user_projects\\domains\\your_domain\\bin\\startWebLogic.cmd.","Browse to the P6 home directory and create a new directory called scripts.","Open the command prompt.","Change the directory to weblogic_home\\user_projects\\domains\\your_domain\\bin. ","Run the following commands:","call ","setDomainEnv.cmd","java_home\\bin\\java.exe weblogic.WLST ","where java_home is the path to the JDK installed and being used by WebLogic.","Note If the &quot;java_home&quot; directory contains a space in the path, it should include quotations around the full path and executable being called. For example: &quot;C:\\Program Files\\Java\\jdk1.6.0_27\\bin\\java.exe&quot; weblogic.WLST","At the wls:/offline&gt; prompt, enter the following command:  ","connect('weblogic','password','AdminServerHostName:AdminServerPort')","where:","weblogic is the weblogic admin user for the domain","password is the password for the weblogic admin user for the domain","AdminServerHostName is the host name where administration server was installed","AdminServerPort is the port number of administration server","At the wls:/mydomain/serverConfig&gt; prompt, enter the following command:  ","storeUserConfig('p6home/scripts/primaveraConfig.secure', 'p6home/scripts/primaveraKeyfile.secure')","where p6home is the P6 home directory the you set during installation (for example, C:/p6home).","Enter y at the following prompt:","Creating the key file can reduce the security of your system if it is not kept in a secured location after it is created. Do you want to create the key file? y or n","Note Confirm that the following two files were created under the p6home/scripts directory: primaveraConfig.secure and primaveraKeyfile.secure. If these files were not created, repeat the previous steps.","Stop the WebLogic Domain's administration server from running by launching weblogic_home\\user_projects\\domains\\your_domain\\bin\\stopWebLogic.cmd.","Ensure that AdminServer is assigned to the machine created for the WebLogic Domain:","Browse to the weblogic_home\\user_projects\\domains\\your_domain\\config directory.","Make a copy of the config.xml file to back up the existing file.","Open the config.xml file with a text editor.","Search for the following: ","&lt;name&gt;AdminServer&lt;/name&gt;","Locate the &lt;/ssl&gt; element and add the following line under the element:","&lt;machine&gt;&lt;!--NameOfMachine--&gt;&lt;/machine&gt;","where &lt;!--NameOfMachine--&gt; is the name of the logical machine created for the WebLogic domain.","Note","If an &lt;/ssl&gt; element does not exist, locate and add the line &lt;machine&gt;&lt;!--NameOfMachine--&gt;&lt;/machine&gt; above the &lt;listen-address&gt; element.","If a &lt;machine&gt; element already exists for AdminServer, this step can be skipped.","Save and close the config.xml file.","Ensure the administration server and managed servers in the weblogic domain are configured with a boot.properties file for node manager startup:","Browse to the weblogic_home\\user_projects\\domains\\your_domain\\servers\\AdminServer\\data directory.","Check if you have a directory called nodemanager. If you do not, create a directory called nodemanager.","Create a text file in the nodemanager directory called boot.properties.","Open boot.properties using a text editor and add:","usename=&lt;werblogic&gt;","where &lt;weblogic&gt; is the Administrator user created for the WebLogic domain.","password=&lt;password&gt;","where &lt;password&gt; is the password for the Administrator user created for the WebLogic domain","Save and close the file.","Repeat steps a &#8211; e for every managed server in the domain.","Example path: ","weblogic_home\\user_projects\\domains\\your_domain\\servers\\&lt;NameOfManagedServer&gt;\\data","Note The username and password variables will become encrypted in the boot.properties file the first time the servers start using the node manager.","Create a text file in the p6home/scripts directory called start_primavera.py (this is also known as a python file).","Open start_primavera.py using a text editor and add the following 6 lines (each line should be entered as a single line):","nmConnect(userConfigFile='p6home/scripts/primaveraConfig.secure',userKeyFile='p6home/scripts/primaveraKeyfile.secure',host='NodeMangerHost',port='5556',domainName='Mydomain',domainDir='DomainLocation',nmType='ssl')","arg = &quot;Arguments=\\&quot; -server -Xms128m -Xmx512m -XX:MaxPermSize=256m \\&quot;&quot;","prps = makePropertiesObject (arg)","nmStart('AdminServer',props=prps)","connect(userConfigFile='p6home/scripts/primaveraConfig.secure',userKeyFile='p6home/scripts/primaveraKeyfile.secure',url='t3://Adminserverhost:Adminserverport')","start('myManagedServer')","where: ","p6home is the home directory for one of the P6 EPPM applications. For example:  C:/p6home","NodeManagerHost is the hostname where the node manager is installed","Adminserverhost is the hostname where the administration server is running","Adminserverport is the port number of the administration server (default is 7001)","Mydomain is the name of the WebLogic domain","DomainLocation is the path to the WebLogic domain (C:/Oracle/Middleware/user_projects/domains/your_domain)","AdminServer is the Logical Name of the administration server","myManagedServer is the Logical Name of the managed server","Note If multiple managed servers exist, repeat the line &#8216;start(&#8216;myManagedServer')' with the name of each managed server.","Save and close the file.","Create a command file that will call the Python script you created above:","Open a text editor and enter the following lines:","SETLOCAL","SET CLASSPATH=","call weblogic_home\\user_projects\\domains\\your_domain\\bin\\setDomainEnv.cmd","call java_home\\bin\\java.exe weblogic.WLST p6home\\scripts\\start_primavera.py","where:","weblogic_home is the WebLogic Server home directory. The default is C:\\Oracle\\Middleware","your_domain is the domain name directory in your environment","java_home is the path to the JDK installed and being used by WebLogic","p6home is the home directory for the P6 EPPM folder containing the scripts directory. For example: C:\\p6home","Note If the &quot;java_home&quot;, &quot;p6home&quot; or &quot;weblogic_home&quot; directories contain a space in the path, it should include quotations around the full path and executable/command file being called. For example: call &quot;C:\\Program Files\\Java\\jdk1.6.0_27\\bin\\java.exe&quot; weblogic.WLST C:\\P6WebAccess\\scripts\\start_primavera.py","Save the file in the p6home\\scripts directory with the following name: start_primavera.bat.","Starting an Administration and Managed Servers Using WLST With Node Manager","65782.htm");
Page[41]=new Array("To add the start_primavera.bat file to the Windows Task Scheduler:","Browse to Start, All Programs, Accessories, System Tools, Task Scheduler.","Under Actions, select Create Task.","Under the Create Task, General tab:","Provide a name for the Scheduled Task.","Provide a description of the Scheduled Task","Select Change User or Group.","Under Security Options in the Enter the object name to select field, enter System and click OK.","Select Run with the highest privileges.","Under the Create Task, Trigger tab:","Select New.","In the Begin the task list, select At Startup.","Under Advanced Settings, select Enabled.","Select OK.","Under the Create Task, Actions tab:","In the Action list, select Start a program. ","In the program/script field, browse to the start_primavera.bat file.","Select OK.","View the scheduled task by selecting Task Scheduler Library.","Adding the start_primavera.bat to the Windows Task Scheduler","65807.htm");
Page[42]=new Array("Oracle recommends executing the start_primavera.bat file using the command prompt before running it through the scheduled task window so you can identify and resolve issues that occur after you create the batch file and python script. See Troubleshooting for common issues that can occur after you create the batch file and python script.","To run start_primavera.bat:","Browse to Start, Run.","In the Run window, enter cmd.","Select OK to open the command prompt.","Enter the following:  ","p6home\\scripts\\start_primavera.bat","where p6home is the home directory for one of the P6 EPPM applications. For example: C:\\p6home","Note","Each Java process that loads should run under the SYSTEM account. ","Later, if the start_primavera.bat file is not run automatically through the scheduled task, you can run it directly or run it manually using the Windows Task Scheduler.","Executing the start_primavera.bat file","65870.htm");
Page[43]=new Array("To stop the WebLogic domain with WebLogic Scripting:","Create a text file in the p6home/scripts directory called stop_primavera.py.","Open stop_primavera.py using a text editor and enter the following lines:","Note You must indent the commands under &quot;try&quot; and &quot;except&quot;.","print('PRM-Stopping Primavera administration server, managed servers, and deployments')","print('PRM-This will NOT attempt to stop the node manager as it may be')","print('PRM-needed for other servers on this machine.')","connect(userConfigFile= ' p6home/scripts/primaveraConfig.secure',userKeyFile='p6home/scripts/primaveraKeyfile.secure',url='t3://Adminserverhost:Adminserverport') ","try:","   print('PRM-Shutting down managed server myManagedServer') ","   shutdown('myManagedServer','Server','true',100,'true')","except:","   print('PRM-Failed to stop managed server myManagedServer')","try:","   print('PRM-Shutting down AdminServer') ","   shutdown('AdminServer','Server','true',100,'true')","except:","   print('PRM-Failed to stop AdminServer')","print('PRM-Shutdown Complete')","exit() ","where: ","p6home is the home directory for one of the P6 EPPM applications. For example: C:\\p6home ","Adminserverhost is the hostname where the administration server is running ","Adminserverport is the port number of the administration server (default is 7001) ","myManagedServer is the Logical Name of the managed server","AdminServer is the Logical Name of the administration server ","If multiple managed servers exist, repeat the following lines from above with the name of each managed server:","Note You must indent the commands under &quot;try&quot; and &quot;except&quot;.","try:","   print('PRM-Shutting down managed server myManagedServer') ","   shutdown('myManagedServer','Server','true',100,'true')","except:","   print('PRM-Failed to stop managed server myManagedServer')","Save and close the file.","Browse to &lt;P6_EPPM_Home&gt;\\scripts and then create a text file called stop_primavera.bat.","Edit stop_primavera.bat and then add the following lines:  ","SETLOCAL","SET CLASSPATH=","call weblogic_home\\user_projects\\domains\\your_domain\\bin\\setDomainEnv.cmd ","call java_home\\bin\\java.exe weblogic.WLST p6home\\scripts\\stop_primavera.py ","where: ","weblogic_home is the WebLogic Server home directory. The default is C:\\Oracle\\Middleware ","your_domain is the domain name directory in your environment ","java_home is the path to the JDK installed and being used by WebLogic ","p6home is the home directory for the P6 EPPM folder containing the scripts directory. For example: C:\\p6home ","Note If the &quot;java_home&quot;, &quot;p6home&quot; or &quot;weblogic_home&quot; directories contain a space in the path, it should include quotations around the full path and executable/command file being called. For example: call &quot;C:\\Program Files\\Java\\jdk1.6.0_27\\bin\\java.exe&quot; weblogic.WLST C:\\P6WebAccess\\scripts\\start_primavera.py","Save and close the file.","Using WebLogic Scripting to Stop the WebLogic Domain for P6 EPPM","65834.htm");
Page[44]=new Array("To troubleshoot the following start_primavera.bat error: ","WLSTException: Error occured while performing nmConnect : Cannot connect to Node Manager. : Access to domain '&lt;domainName&gt;' for user &#8216;&lt;username&gt;' denied.","Ensure that the userConfigFile and userKeyFile variables entered in the start_primavera.py file point to a valid path and file name for the primaveraConfig.secure and primaveraKeyfile.secure files.","Ensure that the node manager username and password are correct:","Start the AdminServer for the WebLogic Domain.","Launch the WebLogic Administrative Console.","In the Change Center&nbsp;pane of the Administration Console, click Lock &amp; Edit.","Under the Domain Structure pane, select the link for your domain name.","Select the Security tab and then select the Advanced Options link.","Enter the valid credentials in the console for NodeManager username and NodeManager password.","Activate the changes. ","Logout of the WebLogic Administrative Console.","Stop the AdminServer for the WebLogic Domain.","Retry executing the start_primavera.bat file.","For the following error, the managed server did not start using the Node Manager and you need to create a startup.properties file before you can start the managed server using WLST Scripting.","weblogic.management.ManagementException: Booting as administration server, but servername, &lt;ManagedServerName&gt;, does not match the administration server name, AdminServer.","To create a startup.properties file:","Start the AdminServer for the WebLogic Domain.","Launch the WebLogic Administrative Console.","Under the Domain Structure pane, select 'servers' link.","On the Servers page, select the Control tab.","Select Startup.","Once the server is in a running state, on the Servers page, select the Control tab.","Select Shutdown.","Verify the startup.properties file is in the weblogic_home\\user_projects\\domains\\&lt;domain&gt;\\servers\\&lt;managedServer&gt;\\data\\nodemanager directory. You can now startup through the WebLogic scripting files.","Troubleshooting","65860.htm");
Page[45]=new Array("Refer to the following sections to configure the node manager with Linux or UNIX.","Using the WebLogic Scripting Tool on Linux or UNIX","88384.htm");
Page[46]=new Array("In order to automate the startup of the administration server and managed servers of your P6 EPPM deployment, you must create a configuration (userConfigFile) and key (userKeyFile) file. For more information about configuration and key files, refer to the Oracle Fusion Middleware Command Reference for Oracle WebLogic Server guide.","To create a configuration and key file:","Start the WebLogic Domain's Administration Server by launching startWebLogic.shfrom &lt;WebLogic_Home&gt;/user_projects/domains/&lt;P6_EPPM_Domain&gt;/bin/","Where:","&lt;WebLogic_Home&gt; is the WebLogic home directory. The default is Oracle/Middleware/Oracle_Home.","&lt;P6_EPPM_Domain&gt; is the WebLogic domain for P6 EPPM that was set during configuration.","Browse to the P6 home directory and create a new directory called scripts.","Open the terminal console and run the following commands:","cd &lt;WebLogic_Home&gt;/user_projects/domains/&lt;P6_EPPM_Domain&gt;/bin","source setDomainEnv.sh","&lt;Java_Home&gt;/bin/java.exe weblogic.WLST","Note If the &lt;Java_Home&gt; directory contains a space in the path, it should include quotations around the full path and executable being called.","Where:","&lt;Java_Home&gt; is the path to the JDK that is used by WebLogic.","&lt;WebLogic_Home&gt; is the WebLogic home directory. The default is Oracle/Middleware/Oracle_Home.","&lt;P6_EPPM_Domain&gt; is the WebLogic domain for P6 EPPM that was set during configuration.","At the wls:/offline&gt; prompt, enter the following command:  ","connect('&lt;WebLogic_Username&gt;','&lt;WebLogic_User_Password&gt;','&lt;Admin_Server_Hostname&gt;:&lt;Admin_Server_Port&gt;')","Where:","&lt;WebLogic_Username&gt; is the name of the WebLogic administrator user for the domain.","&lt;WebLogic_Password&gt; is the password for the weblogic administrator.","&lt;Admin_Server_Hostname&gt; is the hostname where the administration server was installed.","&lt;Admin_Server_Port&gt; is the port number of administration server.","At the wls:/mydomain/serverConfig&gt; prompt, enter the following command:  ","storeUserConfig('&lt;P6_EPPM_Home&gt;/scripts/primaveraConfig.secure', '&lt;P6_EPPM_Home&gt;/scripts/primaveraKeyfile.secure') ","Where: &lt;P6_EPPM_Home&gt; is the P6 EPPM home directory that was set during installation.","Enter y at the following prompt:","Creating the key file can reduce the security of your system if it is not kept in a secured location after it is created. Do you want to create the key file? y or n","Confirm that the following two files were created under the &lt;P6_EPPM_Home&gt;/scripts directory: ","primaveraConfig.secure and primaveraKeyfile.secure","If these files were not created, repeat the previous steps.","Creating a Configuration and Key File","93026.htm");
Page[47]=new Array("If a &lt;machine&gt; element already exists for AdminServer, this procedure can be skipped.","To associate the administration server with machines on the P6 EPPM domain:","Browse to the &lt;Weblogic_Home&gt;\\user_projects\\domains\\&lt;P6_EPPM_Domain&gt;\\config.","Make a copy of config.xml as a back up of the existing file.","Open config.xml with a text editor.","Search for &lt;name&gt;AdminServer&lt;/name&gt;.","Locate the &lt;/ssl&gt; element and then add the following line beneath it:","&lt;machine&gt;&lt;!--Machine_Name--&gt;&lt;/machine&gt;","Note If an &lt;/ssl&gt; element does not exist, locate and add the line &lt;machine&gt;&lt;Machine_Name&gt;&lt;/machine&gt; above the &lt;listen-address&gt; element.","Where:&lt;!--Machine_Name--&gt; is the logical name of the machine created for the WebLogic domain.","Save and close the file.","Associating the Administration Server with Machines on a P6 EPPM Domain","93028.htm");
Page[48]=new Array("Ensure that the administration server and managed servers in the WebLogic domain are configured with a boot.properties file.","To create a boot.properties file for the administration and managed servers:","Browse the data directory of either the administration server or a managed server.","For example, &lt;Weblogic_Home&gt;\\user_projects\\domains\\&lt;P6_EPPM_Domain&gt;\\servers\\AdminServer\\data.","Check if you have a directory called nodemanager. If you do not, create a directory called nodemanager beneath the data directory.","Create a text file in the nodemanager directory called boot.properties.","Edit boot.properties and then add the following lines:","username=&lt;WebLogic_Username&gt;","password=&lt;WebLogic_Password&gt;","Note","&lt;WebLogic_Username&gt; is the name of the WebLogic administrator for the domain.","&lt;WebLogic_Password&gt; is the password for the weblogic administrator.","Save and close the file.","Repeat this procedure for the administration server and every managed server at &lt;WebLogic_Home&gt;\\user_projects\\domains\\&lt;P6_EPPM_Domain&gt;\\servers\\.","Note The username and password variables are encrypted in the boot.properties file the first time the servers start using the Node Manager.","Where:","&lt;WebLogic_Home&gt; is the WebLogic home directory. The default is Oracle/Middleware/Oracle_Home. ","&lt;P6_EPPM_Domain&gt; is the WebLogic domain for P6 EPPM.","Configure a boot.properties File for the Administration and Managed Servers","93029.htm");
Page[49]=new Array("To automate the startup of the Admin and managed server using WLST:","Browse to &lt;P6_EPPM_Home&gt;\\scripts and then create a text file called start_primavera.py.","Note &lt;P6_EPPM_Home&gt; is the P6 EPPM home directory that was set during installation.","Edit start_primavera.py and then add the following lines:","nmConnect(userConfigFile='&lt;P6_EPPM_Home&gt;/scripts/primaveraConfig.secure',userKeyFile='&lt;P6_EPPM_Home&gt;/scripts/primaveraKeyfile.secure',host='&lt;Node_Manager_Hostname&gt;',port='5556',domainName='&lt;P6_EPPM_Domain&gt;',domainDir='&lt;Domain_Path&gt;',nmType='ssl')","arg = &quot;Arguments=\\&quot; -server -Xms128m -Xmx512m -XX:MaxPermSize=256m \\&quot;&quot;","prps = makePropertiesObject (arg)","nmStart('AdminServer',props=prps)","connect(userConfigFile='&lt;P6_EPPM_Home&gt;/scripts/primaveraConfig.secure',userKeyFile='&lt;P6_EPPM_Home&gt;/scripts/primaveraKeyfile.secure',url='t3://&lt;Admin_Server_Hostname&gt;:&lt;Admin_Server_Port&gt;')","start('&lt;Managed_Server_Name&gt;')","#If multiple managed servers exist, repeat the previous line for each managed server.","Where:","&lt;P6_EPPM_Home&gt; is the P6 EPPM home directory that was set during installation.","&lt;Node_Manager_Hostname&gt; is the name of the host where the Node Manager is running.","&lt;Admin_Server_Hostname&gt; is the name of the host where the administration server was installed.","&lt;Admin_Server_Port&gt; is the port number of administration server. The default is 7001.","&lt;P6_EPPM_Domain&gt; is the WebLogic domain for P6 EPPM that was set during configuration.","&lt;Domain_Path&gt; is the full path to the P6 EPPM domain. For example, &lt;WebLogic_Home&gt;\\user_projects\\domains\\&lt;P6_EPPM_Domain&gt;","&lt;Managed_Server_Name&gt; is the logical name of the managed server. The default managed server names for P6 EPPM are P6, P6IntegrationAPI, p6procloudconnect, P6WebServices, and TeamMember.","Save and close the file.","Browse to &lt;P6_EPPM_Home&gt;\\scripts and then create a text file called start_primavera.sh.","Edit start_primavera.sh and then add the following lines:","export CLASSPATH=","&lt;weblogic_home&gt;/wlserver/server/bin/setWLSEnv.sh","&lt;Java_Home&gt;/bin/java weblogic.WLST &lt;P6_EPPM_Home&gt;/scripts/start_primavera.py ","Where:","&lt;WebLogic_Home&gt; is the WebLogic home directory. The default is Oracle/Middleware/Oracle_Home. ","&lt;Java_Home&gt; is the path to the JDK that is used by WebLogic.","&lt;P6_EPPM_Home&gt; is the P6 EPPM home directory that was set during installation.","Save and close the file.","Using WebLogic Scripting to Start the P6 EPPM WebLogic Domain","93022.htm");
Page[50]=new Array("To stop the WebLogic domain with WebLogic Scripting:","Browse to &lt;P6_EPPM_Home&gt;\\scripts and then create a text file called stop_primavera.py.","Note &lt;P6_EPPM_Home&gt; is the P6 home directory that was set during installation.","Edit stop_primavera.py and then add the following lines:","print('Stopping Primavera servers. This will not stop the Node Manager because it may be needed for other servers.')","scripts_dir='&lt;P6_EPPM_Home&gt;/scripts'","adminserver_host='&lt;Admin_Server_Hostname&gt;'","adminserver_port='&lt;Admin_Server_Port&gt;'","&lt;Managed_Server_Variable&gt;='&lt;Managed_Server_Name&gt;'","# Create a variable, similar to the one above, for each managed server in the P6 EPPM domain.","connect(userConfigFile=scripts_dir+'/primaveraConfig.secure',userKeyFile=scripts_dir+'/primaveraKeyfile.secure',url='t3://'+adminserver_host+':'+adminserver_port)","# The following section of the script tries to shutdown a managed server. Copy and modify this section of the script for each managed server in the P6 EPPM domain.","try:","  print('PRM-Shutting down the managed server for &lt;Managed_Server_Variable&gt;')  ","  shutdown(&lt;Managed_Server_Variable&gt;,'Server','true',100,'true')","except:","  print('PRM-Failed to stop managed server: ' + &lt;Managed_Server_Variable&gt;)","# The following section of the script tries to shutdown the administration server.","try:","  print('PRM-Shutting down &lt;Admin_Server_Name&gt;.')","  shutdown('&lt;Admin_Server_Name&gt;','Server','true',100,'true')","except:","  print('PRM-Failed to stop &lt;Admin_Server_Name&gt;.')","print('PRM-Shutdown Complete')","exit()","Note","&lt;P6_EPPM_Home&gt; is the P6 EPPM home directory that was set during installation.","&lt;Admin_Server_Hostname&gt; is the name of the host where the administration server was installed. ","&lt;Admin_Server_Port&gt; is the port number of administration server. The default is 7001.","&lt;Managed_Server_Variable&gt; is the variable that you created for a P6 EPPM application.","&lt;Managed_Server_Name&gt; is the logical name of the managed server. The default managed server names for P6 EPPM are P6, P6IntegrationAPI, p6procloudconnect, P6WebServices, and TeamMember.","&lt;Admin_Server_Name&gt;is the logical name of the administration server. The default is AdminServer.","Save and close the file.","Browse to &lt;P6_EPPM_Home&gt;\\scripts and then create a text file called stop_primavera.sh.","Edit stop_primavera.sh and then add the following lines:","export CLASSPATH=","&lt;WebLogic_Home&gt;/wlserver/server/bin/setWLSEnv.sh &lt;Java_Home&gt;/bin/java weblogic.WLST &lt;P6_EPPM_Home&gt;/scripts/stop_primavera.py","Note","&lt;WebLogic_Home&gt; is the WebLogic home directory. The default is Oracle/Middleware/Oracle_Home. ","&lt;Java_Home&gt; is the path to the JDK that is used by WebLogic.","&lt;P6_EPPM_Home&gt; is the P6 EPPM home directory that was set during installation..","Save and close the file.","Using WebLogic Scripting to Stop the WebLogic Domain for P6 EPPM","88386.htm");
Page[51]=new Array("This section explains how to configure the P6 EPPM domain, when installed on Linux, as a daemon process through systemd. If your WebLogic server implementation already includes a Node Manager daemon process, uninstall it prior to completing this instruction. For more information about systemd, refer to your operating system documentation.","To daemonize the Node Manager and your P6 EPPM applications:","Open a terminal and log in to the system as a super user (root user) or as a user with sudo access.","Change the directory to the following location: ","/etc/systemd/system","Create a service file called wlsnodemgr.service.","Edit wlsnodemgr.service and add the following lines:","[Unit]","Description=WebLogic nodemanager service","After=network.target nss-lookup.target remote-fs.target","Wants=nss-lookup.target remote-fs.target","Before=p6eppm.service","[Service]","Type=simple","Environment=WebLogic_Home=&lt;WebLogic_Home_Path&gt;","Environment=P6_EPPM_Domain=${WebLogic_Home}/user_projects/domains/&lt;P6_EPPM_Domain_Name&gt;","Environment=NodeMgr_Log_File=&lt;NodeMgr_Log_Path&gt;/wlsnodemgr.log","ExecStart=/bin/bash -c './${P6_EPPM_Domain}/bin/startNodeManager.sh &gt; $NodeMgr_Log_File'","ExecStop=/bin/bash -c './${P6_EPPM_Domain}/bin/stopNodeManager.sh &gt; $NodeMgr_Log_File'","RemainAfterExit=yes","User=&lt;Linux_User&gt;","Group=&lt;Linux_Group&gt;","KillMode=process","LimitNOFILE=65535","TimeoutStartSec=120","[Install]","WantedBy=multi-user.target","Where:","&lt;WebLogic_Home_Path&gt; is the WebLogic home directory.","&lt;P6_EPPM_Domain_Name&gt; is the WebLogic domain name for P6 EPPM that was set during configuration/installation of Primavera P6","&lt;NodeMgr_Log_Path&gt; is the log path where the start and stop processes write their logs. You can use any location. ","&lt;Linux_User&gt; is the Linux user to associate with and run the daemon process.","&lt;Linux_Group&gt; is the Linux user group to associate with and run the daemon process.","Save and close the file.","Create a service file called p6eppm.service.","Edit the p6eppm.service and add the following lines:","[Unit]","Description=P6 EPPM service","After=wlsnodemgr.service","Requires=wlsnodemgr.service","BindsTo=wlsnodemgr.service","[Service]","Type=simple","Environment=P6_Log_File=&lt;P6_Log _Path&gt;/p6.log","Environment=P6_EPPM_Home=&lt;P6_EPPM_Home&gt;","ExecStart=/bin/bash -c './${P6_EPPM_Home}/scripts/start_Primavera.sh &gt; $P6_Log_File'","RemainAfterExit=yes","ExecStop=/bin/bash -c './${P6_EPPM_Home}/scripts/stop_Primavera.sh &gt; $P6_Log_File'","User=&lt;Linux_User&gt;","Group=&lt;Linux_Group&gt;","KillMode=process","TimeoutStartSec=1200","[Install]","WantedBy=multi-user.target","Where:","&lt;P6_EPPM_Home&gt; is the P6 EPPM home directory that was set during installation.","&lt;P6_Log _Path&gt; is the log path where the start and stop processes write their logs. You can use any location.","&lt;Linux_User&gt; is the Linux user you to associate with and run the daemon process.","&lt;Linux_Group&gt; is the Linux user group to associate with and run the daemon process.","Save and close the file.","Enable the services, by running:","sudo systemctl enable wlsnodemgr p6eppm","Reload the Services, by running:","sudo systemctl daemon-reload","Check the Status of the services and logs, by running:","sudo systemctl status wlsnodemgr ","sudo systemctl status p6eppm","Note The output shows - Active: inactive (dead) first time and shows - Active: active (running) after reboot of server or after manual start.","Once you have created the services, you can:","Check the start and stop logs, by running:","cat &lt;NodeMgr_Log_Path&gt;/wlsnodemgr.log ","cat &lt;P6_Log _Path&gt;/p6.log","Stop the service, by running: sudo systemctl stop p6eppm wlsnodemgr","Start the service, by running: sudo systemctl start wlsnodemgr p6eppm","Disable the service, by running: sudo systemctl disable wlsnodemgr p6eppm","Restart the service, by running: sudo systemctl restart wlsnodemgr p6eppm","Daemonizing the P6 EPPM WebLogic Domain Processes","93037.htm");
Page[52]=new Array("To start the Node Manager with WebLogic:","Open a terminal console.","Run startNodeManager.sh from the bin folder of the P6 EPPM domain by using the following scripts:","cd &lt;WebLogic_Home&gt;/user_projects/domains/&lt;P6_EPPM_Domain&gt;/bin","./startNodeManager","Where:","&lt;WebLogic_Home&gt; is the WebLogic home directory. The default is Oracle/Middleware/Oracle_Home.","&lt;P6_EPPM_Domain&gt; is the WebLogic domain for P6 EPPM that was set during configuration.","Starting the Node Manager with WebLogic","93021.htm");
Page[53]=new Array("You can set the WebLogic node manager as a windows service in your production environments.","To set up node manager as a windows service:","Stop any running instances of the WebLogic node manager.","Navigate to the WebLogic Server installation home directory, then navigate to server\\bin.","In the server\\bin folder modify the installNodeMgrSvc.cmd file using a text editor of your choice, and comment out the following lines:","Note Add @REM at the beginning of a line to comment out the line.","set NODEMGR_HOST=localhost","set NODEMGR_PORT=5556","Run the installNodeMgrSvc.cmd file to create the node manager windows service.","Note To modify the port number on which node manager runs, navigate to the WebLogic Server installation home directory, then navigate to common\\nodemanager. Open the nodemanager.properties file in a text editor of your choice and set the value of ListenPort to the port number you'd like to use in your environment.","Setting the Node Manager as a Windows Service","94260.htm");
Page[54]=new Array("If you would like to receive notification when events occur, you must configure the JMS message queue and P6 to send the events in which you are interested.","To configure your environment to support notification:","Configure the WebLogic message queue:","(Optional) Target the JMS server to a migratable target. See Targeting the JMS Server to a Migratable Target","Determine if the WebLogic message queue will be on the same domain as P6.","See Configuring the WebLogic Message Queue if the queue and the application are on the same domain.","See Sending Events to a Remote WebLogic JMS Server if the queue and the application are on different domains.","(Optional) Configure the message queue security policy. See Configuring the Security Policy for the WebLogic Message Queue.","Configure the application settings in P6 to send event notification. See Configuring Eventing in P6.","An event may be one of two types, a business object event or a special operation event.","Configuring your Environment","46783.htm");
Page[55]=new Array("JMS-related services are hosted on individual server instances within a cluster and for these services, the WebLogic Server migration framework supports failure recovery with service migration, as opposed to failover. In a clustered server environment, a recommended best practice is to target the JMS server to a migratable target, so that a member server will not be a single point of failure. Therefore, the following prerequisite instruction is required if configuring The WebLogic Message Queue In A Cluster.","Note The instruction below assumes the WebLogic domain being configured has managed servers already created and assigned to a cluster parameter.","Configure the cluster migration Basis to Consensus:","Log in into the WebLogic Administration console.","In the Change Center of the Administration Console, click Lock &amp; Edit.","Navigate to the following location under the Domain Structure:","Environment -&gt; Clusters -&gt; ClusterName -&gt; Migration","Locate the Migration Basis drop-down list and change its value to Consensus.","Select Save.","Select Active Changes.","Configure a migratable target for one of the managed servers in the cluster:","In the Change Center of the Administration Console, click Lock &amp; Edit.","In the Domain Structure tree, expand Environment, then select Migratable Targets.","On the Summary of Migratable Targets page, select the link for one of the managed servers in the list.","Select the migration tab:","In Service Migration Policy, select the Auto-Migrate Exactly-Once Services migration policy.","In Constrained Candidate Servers, move the user-preferred server and the additional managed servers in the cluster you want to support failure recovery from the Available column to the Chosen column.","Select Save.","In the Change Center of the Administration Console, click Active Changes.","Restart the Admin server and the managed servers in the cluster for changes to take effect.","Targeting the JMS Server to a Migratable Target","88373.htm");
Page[56]=new Array("When an event is triggered, the P6 Event Notification system sends the event message to a message queue. To receive these notifications, you must first configure the message queue.","The following procedure indicates how to set up a WebLogic Java Messaging Service (JMS) message queue when the queue and P6 are on the same domain. See Sending Events to a Remote WebLogic JMS Server if the application and the queue are on different domains. For information about setting up other JMS-based message queues, see the vendor documentation.","To set up the WebLogic JMS message queue:","In either a new or existing WebLogic domain, launch the WebLogic Administration Console if it is not already open.","In the WebLogic Administration Console:","Create a new JMS server and persistence store. See Creating a JMS Server and Persistence Store.","Create a JMS module. See Creating a JMS Module.","Create a new connection factory. See Creating a JMS Connection Factory.","Create a new queue or topic. See Creating a JMS Message Queue and Subdeployment to see how to create a new queue.","Note Create a queue to deliver a message to a specific group of users. Create a topic to distribute a message amongst several users.","Configuring the WebLogic Message Queue","38437.htm");
Page[57]=new Array("Create a JMS server to hold queues and topics.","To create a JMS server and persistence store:","If it is not already open, launch the WebLogic Administration Console on the remote or local server.","In the WebLogic Administration Console, expand Services/Messaging and click JMS Servers in the Domain Structure pane.","On the Summary of JMS Servers page, click New.","On the Create a New JMS Server page:","Under JMS Server Properties:","Enter a name in the Name field.","Click Create a New Store.","Under Select a store type, select File Store from the Type list and click Next.","Under File Store Properties:","Enter a name in the Name field.","Select a server instance from the Target list.","Note If you are configuring the WebLogic Message Queue in a cluster, select the migratable target you configured earlier.","Specify a location for the file store in the Directory field. ","This location must already exist on your machine and you must have read/write rights to this folder. No error messages appear on the WebLogic console if the filestore is not configured correctly.","Click OK.","Under JMS Server Properties, select the new store from the Persistent Store list and click Next.","Under Select Targets:","If you are deploying to a standalone server, select the administration server (for example, AdminServer) as the target from the Target list and click Finish.  ","If you are deploying to a cluster, select the migratable target configured earlier.","Creating a JMS Server and Persistence Store","46942.htm");
Page[58]=new Array("Create a JMS module to manage and configure resources.","To create a JMS module:","If it is not already open, launch the WebLogic Administration Console on the remote or local server.","In the WebLogic Administration Console, expand Services/Messaging and click JMS Modules in the Domain Structure pane.","On the JMS Modules page, click New.","On the Create JMS System Module page:","Under The following properties will be used to identify your new module, enter a name in the Name field and click Next.","Note Make a note of this name, you will need to know which module to expand in the Configuring the Security Policy for the WebLogic Message Queue topic.","Under The following properties will be used to target your new JMS system module, select a target server in the Servers box and click Next.","Note If you are deploying to a cluster, select the cluster from the targets list.","Under Add resources to this JMS system module, select the Would you like to add resources to this JMS system module option and click Finish.","Creating a JMS Module","46937.htm");
Page[59]=new Array("Create a connection factory to enable connections between your JMS elements.","To create a JMS connection factory:","Log in to the WebLogic Administration Console.","In the WebLogic Administration Console, expand Services/Messaging and click JMS Modules in the Domain Structure pane.","On the JMS Modules page, select the module to which you want to add the connection factory.","On the Settings page, click the Configuration tab and under Summary of Resources click New.","On the Create a New JMS System Module Resource page:","Under Choose the type of resource you want to create, select the Connection Factory option and click Next.","Under Connection Factory Properties:","Enter a name for the connection factory in the Name field.","Enter a name in the JNDI field.","Note Make note of the JNDI name. You will need to enter this name in the JMS Connection Factory field of P6 Application Settings Eventing page. If you are using a remote server, you will need to enter this name in the Remote JNDI Name field on the Connection Factories tab in the Creating a Foreign JMS Server topic.","Click Next.","Under The following properties will be used to target your new JMS system moduleresource, ensure the correct server is targeted and click Finish.","Note If you are deploying to a cluster, the cluster should be selected as the target.","Creating a JMS Connection Factory","46939.htm");
Page[60]=new Array("Create a message queue to act as a receptacle for event messages sent from P6.","To create a JMS message queue and subdeployment:","Log in to the WebLogic Administration Console.","In the WebLogic Administration Console, expand Services/Messaging and click JMS Modules in the Domain Structure pane.","On the JMS Modules page, select the module to which you want to add the queue.","On the Settings page, click the Configuration tab.","On the Configuration tab under Summary of Resources, click New.","On the Create a New JMS System Module Resource page:","Under Choose the type of resource you want to create, select the Queue option and click Next.","Under JMS Destination Properties:","Enter a name for the queue in the Name field.","Enter a name in the JNDI field.","Note  Make note of the JNDI name. You will need to enter this name in the JMS Destination Name field of the P6 Application Settings Eventing page. If you are using a remote server, you will need to enter this name in the Remote JNDI Name field on the Destinations tab in the Creating a Foreign JMS Server topic.","Click Next.","Under The following properties will be used to target your new JMS system module resource, click Create a New Subdeployment.","On the Create a New Subdeployment page, enter a name in the Subdeployment Name field and click OK.","On the Create a New JMS System Module Resource page:","Select the new subdeployment from the Subdeployments list.","Select the JMS server you created when creating the Persistence Store as the target from the JMS Servers box.","Click Finish.","Creating a JMS Message Queue and Subdeployment","46936.htm");
Page[61]=new Array("Depending on administrative settings, events can be triggered when P6, P6 EPPM Web Services, or the P6 Integration API is used to update or create objects in the P6 database or when one of the special operations completes. When a business object change or special operation triggers an event, the P6 Event Notification system sends an event message to a user-configured message queue. If you are planning to use P6 Event Notification with P6 EPPM products, follow the steps below to configure the notification to work with your Java Messaging Service (JMS), the application server, and P6. Refer to the message queue vendor documentation.","Configuring Eventing in the Primavera P6 Administrator","38438.htm");
Page[62]=new Array("If you want events to occur when business objects are created or updated, or when an operation is performed, you must configure Eventing page in the Application Settings of P6.","To configure the Eventing page:","Launch P6.","Click Administration.","On the Administration navigation bar, click Application Settings.","On the Application Settings page, click Eventing.","Click the General tab.","In the Eventing section:","Select Eventing.","Set additional settings as appropriate for your implementation. See Eventing Settings for details on available settings.","In the Directory Services section:","In the Provider URL field, enter the URL of the JNDI provider for the Connection Factory.","For example:","If you are using a standalone server: t3://&lt;Host_Name&gt;:&lt;Port&gt;","If you are using a cluster: t3://&lt;Host_Name_1&gt;:&lt;Port_1&gt;,&lt;Host_Name_2&gt;:&lt;Port_2&gt;","In the Initial Context Factory field, enter the class name of the initial context factory for the JNDI connection. For example, weblogic.jndi.WLInitialContextFactory.","In the Lookup Name field, enter the lookup used to test the directory connection. This can be the JNDI name of the JMS connection factory created earlier or the JMS destination.","In the Security Principal field, enter the principal to connect to the JNDI provider. If you are using WebLogic, this is the name of a WebLogic user.","In the Security Credentials field, enter the credentials to connect to the JNDI provider. If you are using WebLogic, this is the password for the WebLogic user you entered in the Security Principal field.","In the Security Level field, enter the security level to use when authenticating to the directory service.","Click the Configuration tab.","In the Business Objects section:","Expand a business object type and configure the options to determine the type of notifications you will receive.","Select or clear the Create option for an object to determine whether you will receive a notification when that object is created.","Select or clear the Update option for an object to determine whether you will receive a notification when that object is updated.","In the Special Operations section:","Expand an operation type and select or clear the Enabled option for each operation to determine if it is enabled or disabled.","Click Save and Close.","Configuring Eventing in P6","92569.htm");
Page[63]=new Array("Setting Name and Description","Default","Valid Ranges/Values","Eventing","Select to enable the sending of events for P6, P6 EPPM Web Services, and P6 Integration API.","selected","&#8212;","Interval","The length of time that the Event Notification System uses to determine how often it sends events to the message queue. Specifying a smaller time increases the frequency with which the Event Notification System reports event occurrences to the message queue.","5m","1s-10m","Max Queue Size","The amount of memory allocated to the queue for events. Once exceeded, events will be published immediately.","1000","10-5000","Show Costs","Select to enable the display of cost fields in event notifications.","selected","&#8212;","JMS Connection Factory","Specify the JNDI name of the JMS Connection Factory.","&#8212;","&#8212;","JMS Connection Name","Specify the JNDI name of the queue or topic where events are published.","&#8212;","&#8212;","JMS Destination Security","Select to use the user name and password specified when sending messages to JMS queue.","not selected","&#8212;","JMS Connection Username","Specify the user name to use when sending events to the specified JMS destination specified.","&#8212;","&#8212;","JMS Connection Password","Specify the password to use when sending events to the JMS Destination specified.","&#8212;","&#8212;","Eventing Settings","47532.htm");
Page[64]=new Array("Test event notification to ensure event messages are sent when an event occurs.","To test event notification:","If it is not already installed, install P6. See the P6 EPPM Installation and Configuration Guide.","Note If you are using more than one server, install P6 on the local server.","Configure WebLogic for eventing:","See Configuring the WebLogic Message Queue if the queue and the application are on the same domain.","See Sending Events to a Remote WebLogic JMS Server if the queue and the application are on different servers.","Open P6 and create a project. ","In P6:","Add one or more activities to the project.","Summarize the project to test if an event is generated.","Launch the WebLogic Administration Console to verify that the event is generated and sent to the queue.","In the WebLogic Administration Console, expand Services/Messaging and click JMS Modules in the Domain Structure pane.","On the JMS Modules page, click the module you created for the remote server.","On the Settings page for the module, click the queue you created for the remote server.","On the Settings page for the queue, click the Monitoring tab.","On the Monitoring tab, select the option for the remote server destination you created and click Show Messages. The event message should be visible in the JMS Messages list.","Testing Event Notification","47021.htm");
Page[65]=new Array("When an event is triggered, the P6 Event Notification system sends the event message to a message queue. If you are using a remote JMS server, then you must configure the local and remote servers to receive these notifications.","The following procedure should be used when the queue is on a different domain than P6. For information about setting up other JMS-based servers, see the vendor documentation.","Note If you are configuring the WebLogic messaging queue in a cluster, ensure that you have targetted the JMS server to a migratable target. See: Targeting the JMS Server to a Migratable Target","To send events to a remote WebLogic JMS server:","Start the WebLogic Configuration Wizard.","In the wizard, create a WebLogic domain on the remote server to which you will be sending the events. See Creating a WebLogic Domain on a Remote or Local Server. ","Note Rename the WebLogic administration server to a name that is different from the name you used to deploy the P6 application. For example, RemoteAdminServer. ","Start the new server and launch the WebLogic Administration Console. The new server will act as the remote server.","In the WebLogic Administration Console:","Create a WebLogic message queue.","Create a new JMS server. See Creating a JMS Server and Persistence Store.","Create a JMS module. See Creating a JMS Module.","Create a connection factory. See Creating a JMS Connection Factory.","Create a new queue or topic. See Creating a JMS Message Queue and Subdeployment to see how to create a queue.","Note Create a queue to deliver a message to a specific group of users. Create a topic to distribute a message amongst several users.","Configure the trust relationship on the remote server. See Configuring a Trust Relationship.","Create a WebLogic domain on the local server from which the events will be sent. See Creating a WebLogic Domain on a Remote or Local Server.","Start the local server and launch the WebLogic Administration Console.","In the WebLogic Administration Console:","Target the JMS Server to a migratable target. See Targeting the JMS Server to a Migratable Target","Create a new JMS server. See Creating a JMS Server and Persistence Store.","Create a JMS module. See Creating a JMS Module.","Create a foreign server. See Creating a Foreign JMS Server.","Configure the trust relationship on the local server. You must use the same credentials that were used on the remote server. See Configuring a Trust Relationship.","Restart both Weblogic Administration Console servers (restart the domains, not the machines).","If it is not already installed, install P6 EPPM Web Services or P6 on the local server.","Launch P6 to configure message queue settings and event notification options. See Configuring Eventing in the Primavera P6 Administrator. The values you enter in the Directory Service and Eventing sections of the P6 Application Settings Eventing page should be the the Local JNDI names of the Destination and the Connection Factory in the Foreign JMS Server. ","Sending Events to a Remote WebLogic JMS Server","46904.htm");
Page[66]=new Array("Create a WebLogic domain on a remote or local server to define how the server and domain interact.","To create a WebLogic domain:","Start the Weblogic Configuration Wizard on the local or remote server.","In the Welcome window, select Create a new WebLogic domain and click Next.","In the Select Domain Source window, click Next to accept the default selections.","In the Specify Domain Name and Location window:","Enter the domain name. If you are creating a domain on both a local and remote server, give the domains a different name.","Select the domain location.","Click Next.","In the Configure Administrator User name and Password window, enter the user name and password information and click Next.","Note Make a note of the name and password, you will need this information for the JNDI Properties Credential fields and the JNDI Properties box in the Creating a Foreign JMS Server topic.","In the Configure Server Start Mode and JDK window:","Select Production Mode in the left pane.","Select an appropriate JDK in the right pane.","Click Next.","In the Select Optional Configuration window, click Next.","In the Configuration Summary window, click Create.","In the Creating Domain window, select Start Admin Server and click Done.","Creating a WebLogic Domain on a Remote or Local Server","46955.htm");
Page[67]=new Array("If you are sending events between different servers, you must establish a trust relationship between the local server, on which P6 is installed, and the remote server, on which you have setup the JMS message queue.","To configure a trust relationship:","If it is not already open, launch the WebLogic Administration Console on the server where you need to configure the trust relationship.","In the WebLogic Administration Console, click the name of your domain which is the top element in the Domain Structure pane.","On the Settings page, click the Security tab and then the General tab.","On the General tab, expand the Advanced section.","In the Advanced section:","Enter and confirm credentials in the Credential and Confirm Credential fields.","Note Make a note of the credentials you enter for the remote server; you must enter the same credentials for both servers.","Click Save.","Configuring a Trust Relationship","46982.htm");
Page[68]=new Array("Create a foreign JMS server to establish a link between the WebLogic domains.","To create a foreign JMS server:","If it is not already open, launch the WebLogic Administration Console.","In the WebLogic Administration Console, expand Services/Messaging and click JMS Modules in the Domain Structure pane.","On the JMS Modules page, select the module you created for the remote server.","On the Settings page, click the Configuration tab and under Summary of Resources click New.","On the Create a New JMS System Module Resource page:","Under Choose the type of resource you want to create, select the Foreign Server option and click Next.","Under Foreign Server Properties, enter a name in the Name field and click Next.","Under The following properties will be used to target your new JMS system module resource, ensure the correct server is targeted and click Finish.","Note If you are deploying to a cluster, the cluster should be selected as the target.","On the Configuration tab of the Settings page, click the name of the new foreign server.","On the Settings page, click the Configuration tab and then click the General tab.","On the General tab:","Enter the URL of the remote server created from step 4 of section Sending Events to a Remote WebLogic JMS Server in the JNDI Connection URL field. ","For example:","If you are using a standalone server: t3://&lt;hostname&gt;:7001.","If you are using a cluster: t3://&lt;hostname&gt;:7003,&lt;hostname&gt;:7004.","Enter the password that you used to log on to the remote WebLogic server in the JNDI Properties Credential field.","Reenter this password in the Confirm JNDI Properties Credential field.","Enter java.naming.security.principal=&lt;name&gt; in the JNDI Properties box, where name is the user name you used to log on to the remote WebLogic server.","Click Save.","On the Configurations tab, click the Destinations tab and click New under Foreign Destinations.","On the Create a New Foreign JMS Destination page:","Enter a name in the Name field.","Enter a JNDI name in the Local JNDI Name field.  Ensure that the Local JNDI name is different from the JNDI name that you had previously assigned to the message queue for the remote server.","Enter the JNDI name that you assigned to the message queue for the remote server in the Remote JNDI Name field.","Click OK.","On the Configurations tab, click the Connection Factories tab and click New under Foreign Connection Factories.","On the Create a New Foreign JMS Connection Factory page:","Enter a name in the Name field.","Enter a JNDI name in the Local JNDI Name field.  Ensure that the Local JNDI name is different from the JNDI name that you had previously assigned to the connection factory for the remote server.","Enter the JNDI name that you assigned to the connection factory for the remote server in the Remote JNDI Name field.","Click OK.","Creating a Foreign JMS Server","46987.htm");
Page[69]=new Array("You can configure the WebLogic security policy to allow only specific users, roles, or groups to access the queue. The following is an example a security policy configured for one user. If you need more information, refer to the WebLogic documentation.","To configure the WebLogic message queue security policy for one user:","Launch the WebLogic Administration console.","In the WebLogic Administration console, click Security Realms in the Domain Structure pane.","On the Summary of Security Realms page, click the security realm you are using in the Name column under Realms.","On the Settings page for the realm, click the Users and Groups tab and then click the Users tab.","On the Users tab, under Users click New.","On the Create a New User page, enter a name and password in the appropriate fields and click OK.","Note Make a note of the name and password as they will be needed in the Configuring and Testing the WebLogic Message Queue Security topic.","On the Settings page for the user, click the Roles and Policies tab and then click the Realm Policies tab.","On the Realm Policies tab, under Policies expand JMS then expand the module you created for the remote server and click the queue you created for the remote server.","On the Settings page for the queue, click the Security tab and then click the Policies tab.","On the Policies tab:","In the Policy Conditions section, click Add Conditions.","Under Choose a Predicate, select User from the Predicate list and click Next.","Under Edit Arguments:","Enter the user name for the user you just created in the User Argument Name field and click Add. You can now use this user in P6.","Click Finish.","On the Settings page for the queue, click Save.","Log in to P6 as an administrator.","From the Administer menu, select Applications Settings.","On the Application Settings page, click Eventing.","Enter information in the required fields. For more information about information that is required for each field, refer to Configuring Eventing in P6.","Change and test the Directory Services user name and password. See Configuring and Testing the WebLogic Message Queue Security.","Configuring the Security Policy for the WebLogic Message Queue","46886.htm");
Page[70]=new Array("After you create a new user on the Users and Groups tab in Security Realms, you must change the Security Principal and the Security credentials listed under Directory Services in P6.","To configure and test the WebLogic message queue security:","Log in to P6 as an administrator.","From the Administer menu, select Applications Settings.","On the Application Settings page, click Eventing.","Under Directory Services, complete the following:","Enter the new username in the Security Principal field.","Enter the new password in the Security Credentials field.","Enter the provider URL in the Provider URL field.","Enter the initial context factory name in the Initial Context Factory field.","Enter the lookup name in the Lookup Name field.","Note The user name and password were set in the Configuring the Security Policy for the WebLogic Message Queue topic.","Click Test Connection.","Repeat the steps above with the original username and password to ensure that they no longer work.","Under Eventing,enter your eventing settings and test the connection. See Configuring Eventing in P6.","Configuring and Testing the WebLogic Message Queue Security","47005.htm");
Page[71]=new Array("You must configure your WebLogic deployment of P6 if you would like to use a Secure Sockets Layer (SSL) connection.","Note Please ensure that you have completed the steps in the Sending Events to a Remote WebLogic JMS Server section before attempting to configure your WebLogic deployment of P6 to use SSL.","To configure a WebLogic deployment of P6 to use SSL:","See Configuring an SSL Connection on One Server if P6 and the WebLogic message queue are on the same server.","See Configuring an SSL Connection on Different Servers if P6 and the WebLogic message queue are on different servers.","Configuring a WebLogic Deployment of P6 to Use an SSL connection","46901.htm");
Page[72]=new Array("You can configure your WebLogic deployment of P6 to use a Secure Sockets Layer (SSL) connection when P6 and the WebLogic message queue are on the same server.","Note When P6 and the WebLogic message queue are on the same server, they will use the same certificate and trust store.","To configure an SSL connection on one server:","Launch the WebLogic Administration Console.","In the WebLogic Administration Console, enable the SSL port. See Enabling the SSL Port.","Log in to P6 as an administrator.","From the Administer menu, select Applications Settings.","On the Application Settings page, click Eventing.","In the Provider URL field, under Directory Services, enter the protocol over SSL (t3s:// or iiops://) and the SSL port.For example, t3s://&lt;hostname&gt;:7002","Configuring an SSL Connection on One Server","47094.htm");
Page[73]=new Array("You can configure your WebLogic deployment of P6 to use a Secure Sockets Layer (SSL) connection when P6 and the WebLogic message queue are on different servers.","Note This topic assumes that you have already set up a foreign JMS server. See Creating a Foreign JMS Server.","To configure an SSL connection on different servers:","Launch the WebLogic Administration Console.","In the WebLogic Administration Console, enable the SSL port on both servers. See Enabling the SSL Port.","Log in to P6 as an administrator.","From the Administer menu, select Applications Settings.","On the Application Settings page, click Eventing.","In the Provider URL field, under Directory Services, enter the protocol over SSL (t3s:// or iiops://) and the SSL port. For example, t3s://&lt;hostname&gt;:7002.","Import the certificate of the server hosting the WebLogic message queue into the trust store of the server hosting P6. Please refer to the WebLogic documentation for detailed instructions.","http://download.oracle.com/docs/cd/E21764_01/web.1111/e13707/identity_trust.htm","http://download.oracle.com/docs/cd/E21764_01/apirefs.1111/e13952/taskhelp/security/ConfigureIdentityAndTrust.html","In the WebLogic Administration Console, expand Services and click JMS Modules in the Domain Structure pane.","On the JMS Modules page, click the module that contains the foreign JMS server you are using.","On the Settings page for the module, click the foreign JMS server on the Configuration tab.","On the Settings page for the foreign JMS server, use the protocol over SSL (t3s:// or iiops://) and the SSL port in the JNDI Connection URL on the General tab. For example, t3s://&lt;hostname&gt;:7002.","Configuring an SSL Connection on Different Servers","47096.htm");
Page[74]=new Array("To enable the SSL port:","Launch the WebLogic Administration Console.","In the WebLogic Administration Console, expand Environment and click Servers in the Domain Structure pane.","On the Summary of Servers page, click your server in the Name column under Servers.","On the Settings page for the server, click the Configuration tab and then click the General tab.","On the General tab, select the SSL Listen Port Enabled option and click Save.","Enabling the SSL Port","47544.htm");
Page[75]=new Array("You may configure the Java client to use a Secure Sockets Layer (SSL) connection. See the documentation for WebLogic for more information.","To configure Java to use an SSL connection:","In order to use an SSL connection, include the following jar files in you classpath:","wlfullclient.jar","wlcipher.jar (This can be found in the &lt;WL_HOME&gt;/server/lib (e.g. C:\\Oracle\\Middleware\\wlserver_10.3\\server\\lib).)","To obtain the jar file wlfullclient.jar, run java &#8211;jar wljarbuilder.jar in &lt;WL_HOME&gt;/server/lib.","To obtain the provider URL, you can use either t3s:// or iiops:// protocol (t3 or iiop over SSL).","Note Use the SSL port (7002 by default).","To obtain the keystore file that contains the server's certificate:","Export the server's certificate from the browser to a certificate file.","Import the certificate file into your keystore using java's keytool:","keytool -import -trustcacerts -alias demotrust -file server_cert.crt -keystore mykeystore.jks","When running the client, specify the following parameters:","Dweblogic.security.TrustKeyStore=CustomTrust","Dweblogic.security.CustomTrustKeyStoreFileName=mykeystore.jks","Dweblogic.security.CustomTrustKeyStorePassPhrase=&lt;your keystore password&gt;","(Optional) Dweblogic.security.SSL.ignoreHostnameVerification=true (Specify this parameter to ignore hostname verification.)","Configuring your Java client to use an SSL connection","47044.htm");
Page[76]=new Array("High availability allows application processing to continue when a server instance fails and provides a reliable environment with minimal or no loss of service. High Availability is often achieved through the use of clusters, units of servers running concurrently to provide application failover and load balancing. Enterprise application deployments can benefit from the additional reliance and flexibility high availability systems provide. ","Reasons for Implementing High Availability","Mission critical computer systems need to be available 24 hours a day, 7 days a week, and 365 days a year. However, part or all of the system may be inoperable during planned or unplanned downtime. A system's availability is measured by the amount of time that it provides service over the total time elapsed since the system's initial deployment.","System downtime may be categorized as planned or unplanned. Planned downtime refers to scheduled operations that render the system unavailable. The effect of planned downtime on end users is typically minimized by scheduling downtime when system traffic is slow. Unplanned downtime is any sort of unexpected failure. Unplanned downtime may have a greater effect than planned downtime because it can happen at peak hours, disrupt business operations, or lead to lost productivity or revenue.","When designing your P6 EPPM implementation, it is important to recognize the cost of downtime to understand how your services can benefit from availability improvements.","High Availability Options for P6 EPPM","WebLogic Clustering enables you to provide high availability for P6 EPPM applications, ensuring your services remain scalable and resilient against unexpected failures. ","Introduction to High Availability","93839.htm");
Page[77]=new Array("WebLogic Server clusters provide scalability and reliability for your applications by distributing the work load among multiple instances of WebLogic Server. Incoming requests can be routed to a WebLogic Server instance in the cluster based on the volume of work being processed. In case of hardware or other failures, session state is available to other cluster nodes that can resume the work of the failed node.","A WebLogic server cluster consists of multiple WebLogic server instances running simultaneously to provide increased scalability and reliability. A cluster appears to clients to be a single WebLogic server instance. The server instances that constitute a cluster can run on the same machine, or be located on different machines. You can increase a cluster's capacity by adding additional server instances to the cluster on an existing machine, or you can add machines to the cluster to host the incremental server instances.","Note Each server instance in a cluster must run the same version of WebLogic.","Relationship between Clusters and Domains","A domain is an interrelated set of WebLogic server resources that are managed as a unit. A domain includes one or more WebLogic server instances, which can be clustered, non-clustered, or a combination of clustered and non-clustered instances. A domain can include multiple clusters. A domain also contains the application components deployed in the domain, and the resources and services required by those application components and the server instances in the domain. Examples of the resources and services used by applications and server instances include machine definitions, optional network channels, connectors, and startup classes.","In each domain, one WebLogic server instance acts as the Administration Server&#8212;the server instance that configures, manages, and monitors all other server instances and resources in the domain. Each domain contains one Administration Server only. If a domain contains multiple clusters, each cluster in the domain has the same Administration Server. All server instances in a cluster must reside in the same domain; you cannot split a cluster over multiple domains. Similarly, you cannot share a configured resource or subsystem between domains.","Clustered WebLogic server instances behave similarly to non-clustered instances, except that they provide failover and load balancing. The process and tools used to configure clustered WebLogic server instances are the same as those used to configure non-clustered instances. However, to achieve the load balancing and failover benefits that clustering enables, you must adhere to certain guidelines for cluster configuration.","High Availability with WebLogic Clustering","P6 EPPM can utilize WebLogic clustering to continue processing data when a server instance fails. You cluster P6 EPPM by deploying it on multiple server instances in the cluster. If a server instance on which P6 EPPM is running fails, then another running server instance on which P6 EPPM is deployed can continue to process data.","For a more comprehensive product overview, documentation, and community forums for WebLogic and its clustering functionality, see http://www.oracle.com/technetwork/middleware/weblogic/overview/index.html","About WebLogic Clustering","93841.htm");
Page[78]=new Array("Prerequisites for WebLogic Clustering","This guide assumes that you have already installed and configured P6 EPPM.","In addition to the prerequisites to enable WebLogic clustering on your initial P6 EPPM deployment, which are described in either Installation Prerequisites of the Installation and Configuration Guide or Prerequisites in Manual Deployment Guide, you will need to install a supported version of Oracle HTTP Server. For a supported version of Oracle HTTP Server, refer to Tested Configurations.","Deploying P6 EPPM with WebLogic clustering requires you to install WebLogic on each machine that will use the P6 EPPM domain, which was created by the P6 EPPM configuration wizard.","Note You must install the same version of WebLogic on each machine.","Prerequisites","93842.htm");
Page[79]=new Array("After you have installed and configured P6 EPPM, you can add new machines, servers, and clusters using the WebLogic Administration Console. You must then add any new servers to different machines and create a cluster to utilize high availability for your application deployments. After creating a cluster, you must add servers to the cluster. To add new servers to your clusters and establish high availability for your P6 EPPM applications, complete the following topics in the order that they are listed:","Adding New Machines in WebLogic","Adding New Servers in WebLogic","Associating Servers with Machines","Adding New Clusters in WebLogic","Assigning Servers to Clusters","After the servers have been added to your cluster, deploy the P6 EPPM WebLogic domain to new machines by creating a zip file of the domain, extracting its contents to the domains folder in Oracle Middleware Home, and then updating nodemanager.properties with the correct ListenAddress hostname. For the procedures to deploy the P6 EPPM domain to new machines, refer to Copying the P6 EPPM Domain to Additional Machines.","When deploying P6 EPPM to managed servers in a cluster running across different physical machines to the domain's administration server, you must modify the Web Service Manager (WSM) Policy Manager on the remote machines so that the additional managed servers can use the WSM Policy Framework. To modify the WSM Policy Manager, refer to Modifying the WSM Policy Manager.","Lastly, configure the WebLogic proxy plugin driver (mod_wl_ohs) of an Oracle HTTP Server (OHS) instance to connect to the P6 EPPM WebLogic cluster using the instructions in Configuring the WebLogic Proxy Plugin Driver of an Oracle HTTP Server and then start your node managers and managed servers using the instructions in Starting the Node Managers and Managed Servers on Additional Machines.","Setting Up WebLogic Clustering for P6 EPPM Applications","93844.htm");
Page[80]=new Array("To add new machines in WebLogic:","Log in to the WebLogic Administration Console with the following URL: ","http://&lt;host_name&gt;:&lt;port&gt;/console","In the Change Center pane, click Lock &amp; Edit.","In the Domain Structure pane, click Environment and then click Machines.","Click New.","On the Create a New Machine page, complete the following:","In the Name field, enter a logical name for the machine (for example, Machine 1).","In the Machine OS list, select Unix if the machine uses a Unix operating system or select Other if the machine uses a non-Unix operating system, such as Windows.","Click Next.","On the Create a New Machine page, complete the following:","In the Type list, select the protocol with which the node manager on the machine communicates with its servers. The protocol options are SSL (default option), Plain, RSH, and SSH.","In the Listen Address field, enter the hostname or IP Address of the remote server.","In the Port field, enter the port number for the remote server on which the node manager will run.","Click Finish.","Click Activate Changes.","Adding New Machines in WebLogic","93845.htm");
Page[81]=new Array("To add new servers in WebLogic:","Log in to the WebLogic Administration Console with the following URL:","http://&lt;host_name&gt;:&lt;port&gt;/console","In the Change Center pane, click Lock &amp; Edit.","In the Domain Structure pane, click Environment and then click Servers.","Click New.","On the Create a New Server page, complete the following:","In the Server Name field, enter a name for the managed server.","In the Server Listen Address field, enter the hostname or IP Address of the remote server.","Note If you plan to add a new managed server on the same physical server as the Administration server, you can leave this field blank. This allows all local listening addresses on the server to be utilized.","In the Server Listen Port field, enter the port number from which you want to access the server instance.","Tip You can more easily manage and maintain the servers in your cluster by using the same port number across all of your managed servers.","Select Yes, make this server a member of an existing cluster.","Select a cluster.","Click Finish.","Click Activate Changes.","Adding New Servers in WebLogic","93846.htm");
Page[82]=new Array("To add new clusters in WebLogic:","Log in to the WebLogic Administration Console with the following URL:","http://&lt;host_name&gt;:&lt;port&gt;/console","In the Change Center pane, click Lock &amp; Edit.","In the Domain Structure Pane, click Environment, then click Clusters. ","Click New, then select Cluster.","On the Create a New Cluster page, complete the following:","Enter a name for the cluster in the Name field.","Select a messaging mode for the cluster, Unicast or Multicast.","If you selected Unicast, enter a Unicast Broadcast Channel.","If you selected Multicast, enter a Multicast Address and a Multicast Port number.","Click Ok.","Click Activate Changes.","To learn more about WebLogic clusters, cluster configuration, and application deployment, refer to the official WebLogic documentation.","Adding New Clusters in WebLogic","93859.htm");
Page[83]=new Array("To assign servers to clusters in WebLogic:","Log in to the WebLogic Administration Console with the following URL:","http://&lt;host_name&gt;:&lt;port&gt;/console","In the Change Center pane, click Lock &amp; Edit.","In the Domain Structure Pane, click Environment, then click Clusters. ","Click the name of the cluster you want to which you want to assign servers.","On the Settings for &lt;Cluster_Name&gt; page, click the Servers tab. ","On the Servers tab, in the Servers table, click Add.","Select Select an existing server, and add it as a member of this cluster, to add a preexisting server to the cluster. ","Select a server in the Select a server list. ","Click Next. ","Click Activate Changes.","Assigning Servers to Clusters","93860.htm");
Page[84]=new Array("To associate a server with a machine:","Log in to the WebLogic Administration Console with the following URL:","http://&lt;host_name&gt;:&lt;port&gt;/console","In the Change Center pane, click Lock &amp; Edit.","In the Domain Structure pane, click Environment and then click Machines.","Click the name of the machine to which you want to add a server.","Under the Configuration tab, click Servers.","Click Add.","On the Add Server to Machine page, complete the following:","Select Select an existing server, and associate it with this machine.","In the Select a Server list, select the name of the server that you want to add to the machine.","Click Finish.","Click Activate Changes.","Associating Servers with Machines","93847.htm");
Page[85]=new Array("P6 EPPM uses Fusion Middleware Infrastructure, which includes Oracle Web Services Manager (WSM) Policy Manager to manage Oracle WSM policies and run the Oracle WSM policy framework. The Oracle WSM Policy Manager reads from a configuration file called wsm-ccw-config.xml that is stored in the &lt;Primavera_Domain&gt;/config/fmwconfig directory. In wsm-ccw-config.xml, the administration server URL is referred as http://localhost:&lt;port&gt;. The wsm-ccw-config.xml file will need to be updated to change localhost references to the actual hostname of the administration server before you copy the domain for every additional managed server that has been added to the P6 EPPM cluster.","To modify the WSM Policy Manager:","Go to &lt;Oracle_Middleware_Home&gt;/user_projects/domains/&lt;Primavera_Domain&gt;/config/fmwconfig/.","Edit wsm-ccw-config.xml.","Replace localhost references with the hostname of the machine on which the administration servers runs and then save your changes.","Modifying the Web Services Manager Policy Manager","93848.htm");
Page[86]=new Array("After you have added new managed servers to your P6 EPPM cluster and modified the WSM Policy Manager, you need to copy the domain to your new machines. WebLogic offers two command-line utilities for this process. The pack command creates a template that contains a snapshot of your domain. The unpack command uses this template to re-create a domain that contains the packaged applications. For more information on using pack and unpack, see the WebLogic documentation.","To copy the P6 EPPM domain:","Navigate to the &lt;WebLogic_Home&gt;/wlserver/common/bin of the machine on which you created the initial P6 EPPM domain.","Depending on your operating system, complete the following:","For Windows, run:","pack.cmd -managed=true &#8211;domain=&lt;Domain_Path&gt; -template=&lt;Template_Location&gt;\\Clustered_Domain.jar -template_name=&#8221;Clustered_Domain&#8221;","For Unix, run:","pack.sh -managed=true &#8211;domain=&lt;Domain_Path&gt; -template=&lt;Template_Location&gt;/Clustered_Domain.jar -template_name=&#8221;Clustered_Domain&#8221;","Where:","&lt;Domain_Path&gt; is the full path to the P6 EPPM domain. For example, &lt;WebLogic_Home&gt;\\user_projects\\domains\\&lt;P6_EPPM_Domain&gt;.","&lt;Template_Location&gt; is the full path where P6 EPPM Web Services creates the template. For example, C:\\oracle\\user_templates.","Copy the Clustered_Domain.jar file from &lt;Template_Location&gt; to the machines on which you have created additional servers.","Navigate to &lt;WebLogic_Home&gt;/wlsever/common/bin.","Depending on your operating system, compete the following:","For Windows, run:","Unpack.cmd &#8211;template=&lt;Copy_Location&gt;/Clustered_Domain.jar &#8211;domain=&lt;WebLogic_Home&gt;/user_projects/domains/Clustered_Domain","For Unix, run:","Unpack.sh &#8211;template=&lt;Copy_Location&gt;/Clustered_Domain.jar &#8211;domain=&lt;WebLogic_Home&gt;/user_projects/domains/Clustered_Domain","Where:","&lt;Copy_Location&gt; is the path to where you copied the Clustered_Domain.jar file. For example, C:\\temp.","&lt;WebLogic_Home&gt; is the WebLogic home directory. The default is Oracle/Middleware/Oracle_Home.","Repeat these steps for each clustered server.","Copying the P6 EPPM Domain to Additional Machines","93849.htm");
Page[87]=new Array("To run the node manager as a background process upon system startup, you can run the node manager as a service on Windows or you can configure the node manager as a daemon on Unix.","For Unix","To start the node manager upon system startup and to run it in the background:","Open a terminal and run the following script:","nohup &lt;Oracle_Middleware_Home&gt;/user_projects/domains/&lt;Primavera_Domain&gt;/bin/startNodeManager.sh &gt; logfilename.log 2&gt;&amp;1 &amp;","Create a shell script using the following sample script:"," #! /bin/bash"," #"," # wlsnmd Oracle Weblogic NodeManager service"," #"," # chkconfig:   345 85 15"," # description: Oracle Weblogic NodeManager service"," case &quot;$1&quot; in","     start)","         export WL_HOME=&lt;Oracle_Middleware_Home&gt;/wlserver/","         $WL_HOME/../user_projects/domains/&lt;Primavera_Domain&gt;/bin/startNodeManager.sh","         ;;","     *)","         echo &quot;Usage: $0 {start}&quot;","         exit 1"," esac"," exit_status","Save the script to /etc/init.d/nodemgr.","Run the following command with root privileges:"," # chmod +x /etc/init.d/nodemgr"," # chkconfig --add nodemgr","For Windows","To create and run a node manager as a Windows service:","Log in to a machine with administrative privileges.","Go to &lt;Oracle_Middleware_Home&gt;/wlserver/server/bin.","Edit installNodeMgrSvc.cmd.","Comment out the following lines:","set NODEMGR_HOST=&lt;host&gt;","set NODEMGR_PORT=&lt;port&gt;","Save your changes and then close the file.","Go to &lt;Oracle_Middleware_Home&gt;/user_projects/domains/&lt;Primavera_Domain&gt;/bin.","Edit installNodeMgrSvc.cmd.","Comment out the following lines:","set NODEMGR_HOST=&lt;host&gt;","set NODEMGR_PORT=&lt;port&gt;","Save your changes and then close the file.","Open a command prompt and then complete the following:","Change your directory to &lt;Oracle_Middleware_Home&gt;/user_projects/domains/&lt;Primavera_Domain&gt;/bin.","Run installNodeMgrSvc.cmd.","Note If the node manager service has already been installed, the following message will display: CreateService failed - The specified service already exists.","Close the command prompt.","Go to Control Panel\\All Control Panel Items\\Administrative Tools and then click Services.","Right-click Oracle WebLogic &lt;primavera_domain&gt; NodeManager and then click Start.","Running Node Manager as a Service","93850.htm");
Page[88]=new Array("Typically, you use Oracle HTTP Server to front end a cluster of WebLogic servers. Oracle HTTP Server acts as a front end for the cluster of WebLogic servers. When a request is made to a managed server, the mod_wl_ohs directive specifies a comma-separated list of cluster members to balance the server load. The process works as follows:","When mod_wl_ohs receives a request that requires a managed server, it sends that request to one of the WebLogic cluster members that is listed in the directive. At least one server must be available to service the request.","The Managed server processes the request and sends a complete list of cluster members back to mod_wl_ohs.","When mod_wl_ohs receives the updated list, it dynamically adds any previously unknown servers, that may have been down during the initial request, to the list of known servers, which enables all future requests to be load balanced across the full cluster member list defined in the mod_wl_ohs configuration.","This process also enables new managed servers to be added to the cluster without having to manually update mod_wl_ohs as long as the new managed server host and port is determined ahead of time.","In an example scenario, assume that the WebLogic Cluster consists of WLS1, WLS2, and WLS3. Also assume that all three managed servers have been added to the mod_wl_ohs clustering directive, but only WLS1 and WLS2 are known to mod_wl_ohs during an initial request because WLS3 is offline.","When mod_wl_ohs first receives a request, it attempts to send that request to either WLS1 or WLS2. If during the request WLS3 becomes active, the list of available servers is updated to include WLS3 for future requests. If, however, WLS1 and WLS2 are unavailable, but WLS3 becomes available during the request, the request is rejected because mod_wl_ohs has no way of knowing WLS3 exists.","To configure mod_wl_ohs:","Go to &lt;OHS_Middleware_Home&gt;/user_projects/domains/&lt;Primavera_Domain&gt;/config/fmwconfig/components/OHS/instances/&lt;instance_name&gt;.","Edit mod_wl_ohs.conf.","Add the following information to mod_wl_ohs:","&lt;Location /p6&gt;","WLSRequest On","WebLogicCluster &lt;WebLogic_server1&gt;:&lt;port1&gt;, &lt;WebLogic_server2&gt;:&lt;port2&gt;, &lt;WebLogic_server3&gt;:&lt;port3&gt;","&lt;/Location&gt;","&lt;Location /p6tmweb&gt;","WLSRequest On","WebLogicCluster &lt;WebLogic_server1&gt;:&lt;port1&gt;, &lt;WebLogic_server2&gt;:&lt;port2&gt;, &lt;WebLogic_server3&gt;:&lt;port3&gt;","&lt;/Location&gt;","&lt;Location /p6ws&gt;","WLSRequest On","WebLogicCluster &lt;WebLogic_server1&gt;:&lt;port1&gt;, &lt;WebLogic_server2&gt;:&lt;port2&gt;, &lt;WebLogic_server3&gt;:&lt;port3&gt;","&lt;/Location&gt;","Restart Oracle HTTP Server.","Go to &lt;OHS_Middleware_Home&gt;/user_projects/domains/base_domains/bin.","Depending on your operating system, complete the following:","For Unix, run the following in a terminal:","./stopComponent.sh &lt;component_name&gt;","./startComponent.sh &lt;component_name&gt;","For Windows, run the following in a command prompt:","stopComponent.bat &lt;component_name&gt;","startComponent.bat &lt;component_name&gt;","Configuring the WebLogic Proxy Plugin Driver of an Oracle HTTP Server","93851.htm");
Page[89]=new Array("After the P6 EPPM domain has been modified on machines on which they reside, you must start the node manager on each machine to control the managed servers from the WebLogic Administration Console.","To start a managed server:","Log in to the Domain's Administration Console.","In the left pane of the Administration Console, expand Environment and select Servers.","In the right pane, select the Control tab.","In the Server Status table, select the check box next to the name of the server you want to start and click Start.","Click Yes to confirm.","To start the node manager:","Go to &lt;Oracle_Middleware_Home&gt;/user_projects/domains/&lt;Primavera_Domain&gt;/bin.","Depending on your operating system, complete the following:","For Windows, run:","startManagedWeblogic.bat &lt;server_name&gt; t3://&lt;administration_server_name&gt;:&lt;port&gt;","For Unix, run","./startNodeManager.sh","Starting Node Managers and Managed Servers on Additional Machines","93852.htm");
Page[90]=new Array("Now that you have deployed P6 in WebLogic, you can begin using P6. You may find the following guides useful for help getting started:","P6 EPPM System Administration Guide","P6 EPPM Application Administration Guide","P6 EPPM Database Administration Guide","P6 Help","P6 Team Member User's Guide","Depending on what other applications you are using, you may also need the following guides:","P6 Professional","P6 Professional Installation and Configuration Guide for your database","Primavera Data Warehouse","Primavera Data Warehouse Installation and Configuration Guide","Analytics","Analytics Installation and Configuration Guide","Additional Applications","P6 EPPM Oracle Analytics Publisher Configuration Guide","P6 EPPM BPM Configuration Guide","P6 EPPM Content Repository Configuration Guide","P6 EPPM Oracle Identity Manager Configuration Guide","Primavera Oracle Access Manager Configuration Guide","Primavera Oracle Enterprise Manager Configuration Guide","Where to Go from Here","93089.htm");
var PageCount=91;


/*
Date: 12/3/2025 5:47 PM
Source: EPPM_25_dev
BookID: 93087
PubProduct: PRIMAVERA_EPPM
BookTitle: WebLogic Configuration Guide for On-Premises
Version: Version 25
Lang:	en
*/
	var PageLength=Page.length;
	var Result = "";
	var ResultTemp = "";
	var ResultFound = "";
	var ResultTitleOnly = [];
	var ResultTitleAndContent = [];
	var ResultInContent = [];
	var ResultInContentTemp = [];

	var ResultCombinedTemp = [];
	var ResultCombined = [];

	var arrayIndex = 0;
	var NrRes = 0;
	var j = 0;
	var i = 0;
	var k = 0;
	var d = 0;
	var maxItems = 1000;
	var heading = 0;
	var WordPos = -1;
	var WordPosHeading = -1;
	var WordPosContentText = -1;
	var FoundWord = "";
	var FoundWordHead = "";
	var SearchInHeadingOnly = 0;
	var isChecked;
	var size = 10;
	var resGroupCounter = 0;
	var shown = "shown";
	var checkBoxInHeading;
	var searchFlag = 0;
	var DivResult;
	var SearchWord;

if (SearchText && SearchText.length >= 1) {
		SearchWord = SearchText.replace(/\+/g, " ").replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;");
		searchFlag = 1;
	} else {
		SearchWord = "";
		searchFlag = 0;
	}
	

	if (searchFlag === 1) {
		Result = "";

		// checkBoxInHeading = document.getElementById("inHeading");
		if (inHeading) {

			isChecked = true;
		} else {

			isChecked = false;
		}

		if (SearchWord && SearchWord.length >= 1) {
			if (isChecked) {
				SearchInHeadingOnly = 1;
			} else {
				SearchInHeadingOnly = 0;
			}
			SearchWord = SearchWord.toLowerCase();
			window.status = "Searching, please wait...";
			for (j = 0; j < PageLength; j++) {
				k = Page[j].length - 1;
				for (i = 0; i < k; i++) {

					heading = k - 1;

					if (SearchInHeadingOnly === 1) {
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPosHeading > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);

							NrRes++;
							ResultTemp = "<li>";
							ResultTemp += "<span>";
							ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							ResultTitleOnly[arrayIndex] = ResultTemp;
							arrayIndex++;

							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}
					} else if (SearchInHeadingOnly === 0) {
						WordPos = Page[j][i].toLowerCase().indexOf(SearchWord);
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPos > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							NrRes++;
							ResultTemp += "<li>";
							ResultTemp += "<span>";
							if (WordPosHeading > -1) {
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";
							} else {
								// found word is not in the head
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading] + "</a><br/>\n";

							}
							if (i < k - 1) {
								WordPosContentText = Page[j][i].toLowerCase().indexOf(SearchWord);

								if (Page[j][i].length > 300 && (WordPosContentText > -1)) {

									if (WordPosContentText > 75) {
										ResultInContentTemp.push("..." + Page[j][i].substr(WordPosContentText - 75, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");
									} else {
										ResultInContentTemp.push("..." + Page[j][i].substr(0, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");

									}

								} else if (WordPosContentText > -1) {

									ResultInContentTemp.push(Page[j][i].replace(FoundWord, FoundWord.bold()));

								}
							}

							ResultTemp += ResultInContentTemp.join("");

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							if (WordPosHeading > -1) {
								ResultTitleAndContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							} else {
								ResultInContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							}

							ResultInContentTemp.length = 0;
							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}

					}
				}
			}

			ResultTitleOnly = ResultTitleOnly.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultTitleAndContent = ResultTitleAndContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultInContent = ResultInContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			ResultCombinedTemp = ResultTitleOnly.concat(ResultTitleAndContent, ResultInContent);

			ResultCombinedTemp = ResultCombinedTemp.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			for (d = 0; d < ResultCombinedTemp.length; d += size) {
				resGroupCounter++
				ResultCombined.push("<div id=" + "'" + "resGroup_" + resGroupCounter + "'" + " class=" + "'" + "resGroup " + shown + "'" + ">" + "<ol class='searchResults'>" + ResultCombinedTemp.slice(d, d + size).join("") + "</ol></div>");
				shown = "notshown";
			}

			ResultFound = ResultCombined.join("");

Result += "<div id='searchDetailsDiv'>";
			Result += "<p class='searchDetails'>Your Search Found&nbsp;" + NrRes + "&nbsp;items.&nbsp;";
			Result += "</p></div>";
			
			Result += "<div class='searchResultsDiv'>";
			Result += "<div id='resultsCollection' class='searchResults'>";
			Result += ResultFound;
			Result += "</div>";
			Result += "</div>";
			Result += "<div class='searchPaging'>";

			Result += '<hr />';

			Result += '<p class="bodytext"><a class="disabledAnchor" id="pBack" onclick="turnPage(\'backPage\')" href="#pBack">Back</a>&nbsp; | &nbsp;';
			
			if (resGroupCounter && resGroupCounter > 1) {
				Result += '<a id="pNext" onclick="turnPage(\'nextPage\')" href="#pNext">Next</a>';
			} else {
				Result += '<a id="pNext"  class="disabledAnchor" href="#pNext">Next</a>';
			}
			Result += '</p>\n';
			Result += '<div id="pagenofn"><p class="bodytext">Page <span id="pagen">1</span> of ' + resGroupCounter + '</p></div>';

			Result += "</div>";
			
			
		}

		DivResult = document.getElementById("s_anchor");
		if (Result && DivResult) {

			//myDivResult.append(Result);
			DivResult.innerHTML = Result;
			

		}
		window.status = "";
		
		

	}
	}())
}
