'use strict';
function search(SearchText, inHeading) {
(function () {
var Page = [];

/* Generated with Author-it 23.4.1.30004  12/3/2025 5:49:50 PM */
Page[0]=new Array("Title and Copyright Information","Copyright  1999, 2025, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information","46576.htm");
Page[1]=new Array("This guide describes how to configure Oracle Identity Manager (OIM) for use with P6 EPPM. OIM is an enterprise identity management system that manages the entire user identity lifecycle to help your organization meet changing business and regulatory requirements, and provides essential auditing, reporting, and compliance functionality.","Audience","System Administrators should use this guide.","Using this Guide","This guide assumes you have already installed P6. For more information, see the P6 EPPM Installation and Configuration Guide.","About This Guide","52057.htm");
Page[2]=new Array("The OIM connector includes a resource directory with all user attributes and two files&#8212;a JAR file to communicate with P6 EPPM and a dynamically generated XML file representing P6 users and their properties.","As an administrator, you can take advantage of the OIM connector to provision P6 EPPM users. With the help of P6 EPPM Web Services, the OIM connector helps you administer the complete user identity life cycles of P6 users. As a primary example, when you create a new user in OIM, it will also create a new user with the same user login name, password, email address, and personal name in the P6 EPPM database.","The core attributes and operations supported by the connector are listed below.","Attributes","The following user attributes are managed:","Login Name","Password","email Address","Personal Name","Operations","The following operations are supported:","Create User: Add a new user in P6 via OIM.","Modify User: Modify an attribute, such as an email address or personal name, in P6 via OIM.","Delete User: Remove a user in P6 via OIM.","About Connecting Oracle Identity Manager to P6","52082.htm");
Page[3]=new Array("Follow the steps below to install OIM and the other applications needed to use OIM:","Install Oracle Identity Manager (OIM). Refer to the following URL for documentation specific to this release: http://download.oracle.com/docs/cd/E14571_01/install.1111/e12002/install001.htm#CIHEJIIG","After installing and configuring the Oracle Identity Manager Server for the first time, you must start the Oracle Identity Manager Managed Server. For information about starting the server, see &quot;Starting the Stack&quot; (http://download.oracle.com/docs/cd/E14571_01/install.1111/e12002/start_stop001.htm#CHDDIFCD) in the Oracle Identity Manager documentation (http://download.oracle.com/docs/cd/E14571_01/install.1111/e12002/oidonly009.htm).","Install P6 and P6 EPPM Web Services. Check that you have OIM, P6, and P6 EPPM Web Services up and running before moving on to the next step. P6 EPPM Web Services must be configured to run in cookie-based authentication mode.","Log in to Primavera P6 Administrator and complete the following:","Expand Primavera P6 Confguration, Web Services, Security, and Message Protection and then set the following settings as false:","Require Digital Signatures for Incoming Messages","Require Encryption for Incoming Messages","Encrypt Response","Download the Oracle Identity Manager Connector for Primavera P6. ","Extract the ZIP archive.","Copy the following Primavera-P6-EPPM.properties files to the &lt;IDM_Home&gt;\\server\\connectorResources directory:","Primavera-P6-EPPM.properties ","Primavera-P6-EPPM_de.properties ","Primavera-P6-EPPM_en.properties ","Primavera-P6-EPPM_en_US.properties ","Primavera-P6-EPPM_es_MX.properties ","Primavera-P6-EPPM_fr.properties ","Primavera-P6-EPPM_ja.properties","Primavera-P6-EPPM_pt_BR.properties","Primavera-P6-EPPM_ru.properties ","Primavera-P6-EPPM_zh_CN.properties ","Primavera-P6-EPPM_zh_TW.properties","Copy primavera-p6eppm-prov.jar to the &lt;IDM_Home&gt;\\server\\JavaTasks directory.","Copy p6ws-jaxws-client.jar to the &lt;IDM_Home&gt;\\server\\ThirdParty directory.","Note The p6ws-jaxws-client.jar is not included in the OIM Connector ZIP archive; it is in the P6 EPPM Web Services client folder (for example, &lt;EPPM_HOME&gt;\\ws\\client\\Java\\JAX-WS\\stubs).","Save PrimaveraP6EPPMProvOIM11gR2.xml to a local drive.","(Only if applicable; otherwise, skip this step.) If you are using a WebLogic application server and the default settings are unsuccessful after first skipping this step:","In Windows:","Edit the StartWebLogic.cmd file located in weblogic_home\\user_projects\\domains\\your_domain\\bin\\ directory.","Add &lt;IDM_HOME&gt;\\server\\ThirdParty\\p6ws-jaxws-client.jar as part of the CLASSPATH.","For example:","set CLASSPATH=&lt;IDM_HOME&gt;/server/ThirdParty/p6ws-jaxws-client.jar;%SAVE_CLASSPATH%","where &lt;IDM_HOME&gt; is your IDM home directory (for example, C:\\oracle\\Middleware\\Oracle_IDM1)","Copy the p6ws-jaxws-client.jar to the weblogic_home\\user_projects\\OIM_domain\\lib directory.","In Unix:","Edit the StartWebLogic.sh file located in weblogic_home/user_projects/domains/your_domain/bin/ directory.","Add &lt;IDM_HOME&gt;/server/ThirdParty/p6ws-jaxws-client.jar as part of the CLASSPATH.","For example:","SAVE_CLASSPATH=&quot;&lt;IDM_HOME&gt;/server/ThirdParty/p6ws-jaxws-client.jar:${CLASSPATH}&quot;","where &lt;IDM_HOME&gt; is your IDM home directory (for example, test/Middleware/Oracle_IDM1)","Copy the p6ws-jaxws-client.jar to the weblogic_home/user_projects/OIM_domain/lib directory.","Set the XEL_HOME variable in the setenv file:","In Windows:","Edit the setenv.bat file located in &lt;IDM_HOME&gt;\\server\\bin\\.","Set the path of the XEL_HOME variable to the absolute path of &lt;IDM_Home&gt;\\server. ","For example, if your IDM_Home is the C:\\oracle\\Middleware\\Oracle_IDM1, then your path will look as follows:","set XEL_HOME=C:\\oracle\\Middleware\\Oracle_IDM1\\server","In Unix:	","Edit the setenv.sh file located in &lt;IDM_HOME&gt;/server/bin/.","Set the path of the XEL_HOME variable to the absolute path of &lt;IDM_Home&gt;/server. ","For example, if your IDM_Home is the test/Middleware/Oracle_IDM1, then your path will look as follows:","XEL_HOME=&quot;test/Middleware/Oracle_IDM1/server&quot;","Restart the OIM WebLogic Server.","Installing the OIM Applications","52083.htm");
Page[4]=new Array("Complete these steps before you begin connecting OIM and P6.","Login to the OIM sysadmin console as an administrative user. ","For example:","http://OIM_Host:14000/sysadmin","In the System Configuration section, click Lookup.","Click Search and scroll to find Lookup.USR_PROCESS_TRIGGERS.","Select Lookup.USR_PROCESS_TRIGGERS.","Change the Meaning for two codes:","Click the Edit button.","Locate USR_FIRST_NAME.","In the Meaning column, enter Change Personal Name.","Locate USR_LAST_NAME.","In the Meaning column, enter Change Personal Name.","Create a new code and meaning:","Click the Create button.","In the Meaning column, enter Change Email.","In the Code column, enter USR_EMAIL.","Click Save and click OK to close the dialog box.","Configuring OIM","79153.htm");
Page[5]=new Array("Follow the steps below to configure OIM and the other applications needed to use OIM. After completing these steps, you can provision users through Application Instances:","Login to the OIM sysadmin console as an administrative user. ","For example:","http://OIM_Host:14000/sysadmin","In the Oracle Identity System Administration Screen, under System Management, select Import.","In the Deployment Manager - Import window, click Add File.","In the Select a file for import dialog box, browse to the location of the PrimaveraP6EPPMProv.xml file and click Open.","In the Deployment Manager wizard:","On the Substitutions screen, accept the default options and click Next.","On the Confirmation screen, select Next.","On the Provide IT Resource Instance Data screen, select Primavera P6 EPPM IT Resource:","In the Host Name field, enter the host name of the managed server hosting the P6 Web Services application.","In the Protocol field, enter the protocol used to connect to the P6 Web Services.","In the Admin User Name and Admin User Password fields, enter the user name and password of a P6 EPPM user assigned Web Services module access and either the &lt;Admin Superuser&gt; global security profile or a global security profile with the Add/Edit/Delete Users privilege assigned.","In the Port field, enter the port number of the managed server hosting the P6 Web Services application.","Click Next, then click Skip.","On the Confirmation screen, verify the details are correct, then click View Selections.","In the Deployment Manager - Import window, click Import.","In the Confirmation dialog box, click Import.","Note At step 5 in the process above, if a red X or yellow warning message displays next to the UD_PM_USER parameter, a user already attempted to import or export that UD_PM_USR version. If you receive this error:","Close the import and restart the process.","On the Substitutions screen of the wizard, note the number in the Current Name column for the PrimaveraP6EPPMProv.xml row. The default is 5. In the New Name column on the same row, type 6 (or one number higher than the Current Name)","Then continue with the remaining screens of the wizard.","To verify the creation of the resource, imported from the XML file:","In the Oracle Identity System Administration Screen, under Configuration Grouping, select IT Resource.","In the IT Resource Type list, select Primavera P6 EPPM Server.","Click Search.","Click the P6 EPPM IT Resource link.","In the View IT Resource Details and Parameters screen, verify the details are correct.","If any of the details is incorrect click Edit then modify the details.","Configuring the OIM Application to Work with P6","52076.htm");
Page[6]=new Array("Once you have configured OIM and P6, you will need to provision users in OIM. Provisioning users will ensure you can manage (create, delete, modify) user's profiles through both OIM and P6. For more information on provisioning, see the documentation included with OIM.","Provisioning Users for OIM","78590.htm");
Page[7]=new Array("To provision users from OIM for P6:","Launch OIM Identity Self Service Console.","For example:","http://OIM_Host:14000/oim","In the Manage section, click Users.","Create a new user.","In the Accounts tab, click Request Accounts.","In the Catalog, select the Application Instance and click Add to Cart.","Click Checkout.","Click Submit.","Provisioning Users for P6","79154.htm");
Page[8]=new Array("To modify or delete an OIM user's access to P6, follow the steps below.","To modify an account:","In User Details page:","Click Modify User.","Update the first name, last name, and email address.","Click Submit.","To delete an account:","In User Details page:","Go to the Accounts tab.","Click Modify Accounts."," Click Submit.","Click Remove Accounts.","Click Submit to revoke the user from P6.","Refer OIM documentation for more information on creating, modifying, and removing users.","Modifying or Deleting OIM Users P6 Privileges","79155.htm");
var PageCount=9;


/*
Date: 12/3/2025 5:49 PM
Source: EPPM_25_dev
BookID: 52079
PubProduct: PRIMAVERA_EPPM
BookTitle: Oracle Identity Manager Configuration Guide for On-Premises
Version: Version 25
Lang:	en
*/
	var PageLength=Page.length;
	var Result = "";
	var ResultTemp = "";
	var ResultFound = "";
	var ResultTitleOnly = [];
	var ResultTitleAndContent = [];
	var ResultInContent = [];
	var ResultInContentTemp = [];

	var ResultCombinedTemp = [];
	var ResultCombined = [];

	var arrayIndex = 0;
	var NrRes = 0;
	var j = 0;
	var i = 0;
	var k = 0;
	var d = 0;
	var maxItems = 1000;
	var heading = 0;
	var WordPos = -1;
	var WordPosHeading = -1;
	var WordPosContentText = -1;
	var FoundWord = "";
	var FoundWordHead = "";
	var SearchInHeadingOnly = 0;
	var isChecked;
	var size = 10;
	var resGroupCounter = 0;
	var shown = "shown";
	var checkBoxInHeading;
	var searchFlag = 0;
	var DivResult;
	var SearchWord;

if (SearchText && SearchText.length >= 1) {
		SearchWord = SearchText.replace(/\+/g, " ").replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;");
		searchFlag = 1;
	} else {
		SearchWord = "";
		searchFlag = 0;
	}
	

	if (searchFlag === 1) {
		Result = "";

		// checkBoxInHeading = document.getElementById("inHeading");
		if (inHeading) {

			isChecked = true;
		} else {

			isChecked = false;
		}

		if (SearchWord && SearchWord.length >= 1) {
			if (isChecked) {
				SearchInHeadingOnly = 1;
			} else {
				SearchInHeadingOnly = 0;
			}
			SearchWord = SearchWord.toLowerCase();
			window.status = "Searching, please wait...";
			for (j = 0; j < PageLength; j++) {
				k = Page[j].length - 1;
				for (i = 0; i < k; i++) {

					heading = k - 1;

					if (SearchInHeadingOnly === 1) {
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPosHeading > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);

							NrRes++;
							ResultTemp = "<li>";
							ResultTemp += "<span>";
							ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							ResultTitleOnly[arrayIndex] = ResultTemp;
							arrayIndex++;

							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}
					} else if (SearchInHeadingOnly === 0) {
						WordPos = Page[j][i].toLowerCase().indexOf(SearchWord);
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPos > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							NrRes++;
							ResultTemp += "<li>";
							ResultTemp += "<span>";
							if (WordPosHeading > -1) {
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";
							} else {
								// found word is not in the head
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading] + "</a><br/>\n";

							}
							if (i < k - 1) {
								WordPosContentText = Page[j][i].toLowerCase().indexOf(SearchWord);

								if (Page[j][i].length > 300 && (WordPosContentText > -1)) {

									if (WordPosContentText > 75) {
										ResultInContentTemp.push("..." + Page[j][i].substr(WordPosContentText - 75, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");
									} else {
										ResultInContentTemp.push("..." + Page[j][i].substr(0, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");

									}

								} else if (WordPosContentText > -1) {

									ResultInContentTemp.push(Page[j][i].replace(FoundWord, FoundWord.bold()));

								}
							}

							ResultTemp += ResultInContentTemp.join("");

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							if (WordPosHeading > -1) {
								ResultTitleAndContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							} else {
								ResultInContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							}

							ResultInContentTemp.length = 0;
							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}

					}
				}
			}

			ResultTitleOnly = ResultTitleOnly.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultTitleAndContent = ResultTitleAndContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultInContent = ResultInContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			ResultCombinedTemp = ResultTitleOnly.concat(ResultTitleAndContent, ResultInContent);

			ResultCombinedTemp = ResultCombinedTemp.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			for (d = 0; d < ResultCombinedTemp.length; d += size) {
				resGroupCounter++
				ResultCombined.push("<div id=" + "'" + "resGroup_" + resGroupCounter + "'" + " class=" + "'" + "resGroup " + shown + "'" + ">" + "<ol class='searchResults'>" + ResultCombinedTemp.slice(d, d + size).join("") + "</ol></div>");
				shown = "notshown";
			}

			ResultFound = ResultCombined.join("");

Result += "<div id='searchDetailsDiv'>";
			Result += "<p class='searchDetails'>Your Search Found&nbsp;" + NrRes + "&nbsp;items.&nbsp;";
			Result += "</p></div>";
			
			Result += "<div class='searchResultsDiv'>";
			Result += "<div id='resultsCollection' class='searchResults'>";
			Result += ResultFound;
			Result += "</div>";
			Result += "</div>";
			Result += "<div class='searchPaging'>";

			Result += '<hr />';

			Result += '<p class="bodytext"><a class="disabledAnchor" id="pBack" onclick="turnPage(\'backPage\')" href="#pBack">Back</a>&nbsp; | &nbsp;';
			
			if (resGroupCounter && resGroupCounter > 1) {
				Result += '<a id="pNext" onclick="turnPage(\'nextPage\')" href="#pNext">Next</a>';
			} else {
				Result += '<a id="pNext"  class="disabledAnchor" href="#pNext">Next</a>';
			}
			Result += '</p>\n';
			Result += '<div id="pagenofn"><p class="bodytext">Page <span id="pagen">1</span> of ' + resGroupCounter + '</p></div>';

			Result += "</div>";
			
			
		}

		DivResult = document.getElementById("s_anchor");
		if (Result && DivResult) {

			//myDivResult.append(Result);
			DivResult.innerHTML = Result;
			

		}
		window.status = "";
		
		

	}
	}())
}
