'use strict';
function search(SearchText, inHeading) {
(function () {
var Page = [];

/* Generated with Author-it 23.4.1.30004  12/11/2025 7:39:18 PM */
Page[0]=new Array("Title and Copyright Information","Copyright  1999, 2025, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information","46576.htm");
Page[1]=new Array("Scope","Oracle Analytics Publisher integrates with the P6 EPPM Extended Schema to deliver on-demand web-based reporting through P6.","This guide describes how to:","Set parameters for Oracle Analytics Publisher and P6.","Configure Oracle Analytics Publisher in the Primavera P6 Administrator.","Set security settings in Oracle Analytics Publisher to work with P6.","Note These instructions only contain information on configuring Oracle Analytics Publisher to work with P6. They do not include information on installing Oracle Analytics Publisher. For Oracle Analytics Publisher installation instructions, see the documentation included with Oracle Analytics Publisher.","Audience","System administrators should use this guide.","Using This Guide","This guide assumes you have installed P6 and its supporting applications. For more information on installing P6 see the P6 EPPMInstallation and Configuration Guide.","About This Guide","50781.htm");
Page[2]=new Array("Before getting started, familiarize yourself with the way Oracle Analytics Publisher handles reports. P6 populates its list of reports from the Report Definitions that load from Oracle Analytics Publisher's web services. When you need to create or modify a report, you will use Oracle Analytics Publisher. The documentation on Oracle Analytics Publisher will help you understand how it works. Before continuing with the following sections, learn about the following Report Definitions from the Oracle Analytics Publisher documentation:","Data Model","Writing SQL queries and data templates","Parameters","Include these types: Text, Menu, Date, Boolean","Work with the &quot;List of Values&quot;","Include different settings that you can set","Templates","The graphic below will help you understand the basic flow between Oracle Analytics Publisher and P6.","Oracle Analytics Publisher Diagram","Item","Description","Log in with Oracle Analytics Publisher admin credentials and impersonate a P6 user.","Connect to the P6 EPPM Extended Schema with the PXRptUser. The PXRptUser must be in the same instance as the admuser.","You can add many other data sources for reports.","The data source you will work with to create reports will be the P6 EPPM Extended Schema database. Note that the Publication Services populate the tables and views used for reporting in the P6 EPPM Extended Schema. Configure and run the Publication Services before you run any report that uses the P6 EPPM Extended Schema. For more information on configuring Publication Services, see Working with Publication Services, Configuring Publication Settings in Services Settings, and Configuring Publication Services in Services Settings.","Note Oracle recommends you use the P6 EPPM Extended Schema database for reporting. The Primavera Data Warehouse is an optional add-on component to P6 EPPM, which supports Analytics, third-party reporting tools, off-line analysis, and the consolidation of P6 data into larger corporate data warehouses.","Getting Started with Oracle Analytics Publisher Reports","47001.htm");
Page[3]=new Array("P6 relies on Oracle Analytics Publisher and the P6 EPPM Extended Schema to produce reports. ","To configure P6 to run reports:","If not already set up, create a Oracle Analytics Publisher environment to manage reports. See the documentation included with Oracle Analytics Publisher.","Configure sample reports, roles, security, and users in Oracle Analytics Publisher. See Configuring Enterprise Reporting with Oracle Analytics Publisher.","Populate Oracle Analytics Publisher settings in the Primavera P6 Administrator. See Configuring the Primavera P6 Administrator for Oracle Analytics Publisher and Publication Services","For Publication Services, you will also need to configure the Primavera P6 Administrator settings. You can configure publication settings for General Data, Time Distributed Data, Blob Data, and Log retention. You can also configure publication services settings for Project Arbiter, Projects, Enterprise Data, Enterprise Summaries, Resource Management, and Security. For more information, see Configuring Publication Settings in Services Settings, and Configuring Publication Services in Services Settings.","Configure and deploy the Publication Services required to populate the reporting views in the P6 EPPM Extended Schema. See Working with Publication Services and Publishing P6 Data.","Configure Oracle Analytics Publisher to allow P6 to use parameter keys so users do not have to enter field values for reports. See Why Do I Need Parameters?.","When you begin working in P6, you can configure your application settings and global scheduled services. See the P6 EPPM Application Administration Guide for more information on scheduled services and application settings.","Provide users with the 'Edit EPS Costs/Financials' project privilege if they need to view project costs in a report generated from the P6 EPPM Extended Schema. See information about security profiles in the P6 EPPM Application Administration Guide.","Configuring P6 for Reporting","46852.htm");
Page[4]=new Array("The following topics describe how to configure reports in Oracle Analytics Publisher to work with P6. To follow these topics you will need to be able to access:","WebLogic Server Administration Console","&lt;host&gt;:&lt;port&gt;/console","Oracle Enterprise Manager","&lt;host&gt;:&lt;port&gt;/em","Oracle Analytics Publisher:","&lt;host&gt;:&lt;port&gt;/xmlpserver","Oracle Analytics Publisher:","&lt;host&gt;:&lt;port&gt;/analytics","Configuring Enterprise Reporting with Oracle Analytics Publisher","51738.htm");
Page[5]=new Array("Oracle Analytics Publisher requires you to connect your P6 EPPM database to Oracle Analytics Publisher using a JDBC connection string.","To create the JDBC connection string:","Log in to Oracle Analytics Publisher as an administrative user.","Click My Profile and select Administration.","Under Data Sources, click the JDBC Connection link.","Click Add Data Source or choose the data source name you want to use.","In the General section:","In the Data Source Name field, enter one of the following data source names:","For Oracle, P6RPT.","For Microsoft SQL Server, P6SSRPT.","In the Driver Type field, select your version.","In the Database Driver Class field, enter the JDBC driver class for your database.","In the Connection String field, enter your JDBC connection string for the P6 EPPM Database.","Clear the Use System User option.","In the Username field, enter your Reporting database user name (for example, pxrptuser).","In the Password field, enter your Reporting database user password.","(For an Oracle database only) In the Pre Process Function field, enter the following:","Secpac.SET_BIP_USER(:xdo_user_name)","Clear the Use Proxy Authentication option for this data source definition.","Click Test Connection.","In the Security section:","In the Available Roles list, select BI Consumer, BI Content Author, and BI Service Administrator.","Click Move selected items to other list.","Click Apply.","Creating the JDBC Connection String for Oracle Analytics Publisher","81740.htm");
Page[6]=new Array("You can use P6 sample reports to test the functionality of your Oracle Analytics Publisher integration.","Note The P6 EPPM sample reports were designed to be run against the small data set included in the sample database. These reports are provided as an example of the product's capability only. Oracle provides no guarantee, implied or explicit, that the sample reports will run against your database or will produce meaningful data when they are run against your database. You may modify the sample reports to suit your own data set, including adding filter criteria to limit data output or changing filter criteria to suit your data.","Before you can upload the sample reports to the catalog:","Extract the contents of P6Reports.zip from the P6 media pack.","Note the location of the P6Reports.xdrz file in the BIPP6reportsOracle (for Oracle) or BIPP6reportsSQLServer (for Microsoft SQL Server) folder.","To upload the sample reports to the catalog:","Log in to Oracle Analytics Publisher as an administrative user.","Click Catalog.","Click Shared Folders.","Click Upload in the Tasks pane.","In the Upload window:","Click Choose File.","Navigate to and select P6Reports.xdrz and click Open.","Click Upload.","Verify that the P6Reports folder is present under Shared Folders.","Adding P6 Sample Reports","81741.htm");
Page[7]=new Array("To read, run, schedule, and view reports, you must assign the BIConsumer role access to the objects in the P6Reports catalog.","To assign permissions to the P6Reports catalog:","Log in to Oracle Analytics Publisher as an administrative user.","Select Catalog.","Under Shared Folders, select the P6Reports folder.","In the Tasks pane, click Permissions.","In the Permissions window:","For the BI Consumer account:","In the Permissions list, select Custom, then in the Custom Permissions window, clear all options except Read, Traverse, Run Publisher Report, Schedule Publisher Report, and View Publisher Output.","For the BI Content Author account:","In the Permissions list, select Full Control.","For the BI Service Administrators account;","In the Permissions list, select Full Control.","Select the Owner option.","Select Apply permissions to sub-folders.","Select Apply permissions to items within folder.","Click OK to save.","Assigning Permissions to the P6Reports Catalog Folder","81745.htm");
Page[8]=new Array("Create groups in Oracle Analytics Publisher to contain the user accounts that will have access to reports.","To create groups in Oracle Analytics Publisher for P6 EPPM:","Log in to the WebLogic Administration Console.","In the Domain Structure pane, select Security Realms.","In the Summary of Security Realms pane, select myrealm.","Select the Users and Groups tab.","Select the Groups sub-tab.","Select New.","In the Create a New Group section, in the Name field type BIConsumers.","In the Provider list, select DefaultAuthenticator.","Click OK.","Repeat step 6 to create two further groups called BIContentAuthors and BIServiceAdministrators.","Creating Groups in Oracle Analytics Publisher","102107.htm");
Page[9]=new Array("Create groups in Oracle Analytics Publisher to contain the user accounts that will have access to reports.","To create groups in Oracle Analytics Publisher for P6 EPPM:","Log in to Oracle Enterprise Manager as an administrative user.","On the WebLogic Domain menu, select Security, Application Roles.","On the Application Stripe list, select obi.","In the Role Name field, selects Starts With and type BI into the field, then click Search application roles.","In the Role table, select BIServiceAdministrators and click Edit.","In the Edit Application Role screen, select click Add.","In the Add Principal screen:","On the Type list, select Group.","In the Display Name field, select Starts With and type BI into the field, then click Search roles.","In the Searched Principals table, select BIServiceAdministrators.","Click OK.","Repeat steps 5 to 7 to map the BIConsumers role to the BIConsumers group.","Repeat steps 5 to 7 to map the BIContentAuthors role to the BIContentAuthors group.","Mapping Roles to Groups in Oracle Analytics Publisher","102108.htm");
Page[10]=new Array("Create a reporting user in Oracle Analytics Publisher that matches an equivalent user in P6, for every user who will use the reporting feature, to ensure you have users who can run reports in both applications.","To create reporting users in Oracle Analytics Publisher for P6 EPPM:","Log in to the WebLogic Administration Console.","In the Domain Structure pane, select Security Realms.","In the Summary of Security Realms pane, select myrealm.","Select the Users and Groups tab.","Select the Users sub-tab.","Click New.","In the Create a New User screen:","On the Name field, type a name for the user.","In the Password field, type a password for the user.","In the Confirm Password field, re-type the password for the user.","Click OK.","Note","If using LDAP, complete these steps by configuring an LDAP provider.","The password for the user does not have to match the user's P6 password.","Select the newly created user.","In the Settings for User screen, select the Groups tab.","In the Parent Groups section, on the Available list, select BIConsumers, BIContentAuthors and BIServiceAdministrators, then click Move selected items from the Available list to the Chosen list.","Click Save.","Creating Reporting Users in Oracle Analytics Publisher for P6 EPPM","81749.htm");
Page[11]=new Array("Use the Primavera P6 Administrator to connect Oracle Analytics Publisher and P6 and to set your Publication services to populate reporting views.","For your publication services and settings, Oracle recommends having at least two configurations: one for application servers hosting P6 and another for the background service applications that run services but do not process web pages. You can create more configurations as needed.","For the P6 application server, limit background services and how often they run. This will allow user's requests to process more quickly.","For the background services configuration, you can have more threads configured and run them at shorter intervals. For information on setting up a separate server for job services, see the P6 EPPM System Administration Guide.","If you are running background services and P6 on the same server, Oracle recommends keeping the settings' defaults for your configuration.","Configuring the Primavera P6 Administrator for Oracle Analytics Publisher and Publication Services","53857.htm");
Page[12]=new Array("You must configure Oracle Analytics Publisher settings for Oracle Analytics Publisher to work with P6.","To configure your Oracle Analytics Publisher settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectDatabase.","Select your Instance from the drop-down list.","Expand BI Publisher.","Note Changes to these settings require you to restart the P6 server.","Select Personal Folders, to enable personal folders per user. If you do not want to use personal folders, leave the option clear. Users have their own personal folders where they can store their objects. Only the user who created and saved the content in the folder can access the folder.","In the Server URL field, enter the URL used to connect to the Oracle Analytics Publisher web service to P6.","For example, http://serverIP:port/xmlpserver/services/PublicReportService?wsdl","In the Folder Paths field, enter the relative path to the Oracle Analytics Publisher P6 reports folder where P6 will search for reports.","Example format (the forward slash is required):","/P6REPORTS","In the Version field, enter the version of Oracle Analytics Publisher that you want to integrate with P6.","In the Admin Username field, enter the username for a WebLogic Server Administrator.","In the Password field, enter the password for the WebLogic Server Administrator.","In the Sender Email ID field, enter the email address that you want users to see if they choose to receive reports by email.","Configuring Oracle Analytics Publisher in the Primavera P6 Administrator","51591.htm");
Page[13]=new Array("Modify publication settings to specify constraints on your report publishing jobs. ","To configure your publication settings:","Note The default settings should be the optimal settings for most environments. Change them only if your environment requires different settings.","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expandServices, then expand Publication, and select Settings.","To configure General Data:","In the Page Size field, enter the maximum number of rows of general data a job can process. This applies to each business object that falls under the general category; general data is not time-distributed (spread), not hierarchical, and not in a blob. When using this setting, each business object processes separately.","The default value is 32.","Enter a value between 1 and 8192.","In the Max Job Count field, enter the number of processes used for this service on your server.","The default value is 1.","Enter a value between 1 and 20.","To configure Blob Data:","In the Page Size field, enter the maximum number of rows of blob data that a job can process. This applies to each business object that falls under the blob category. When using this setting, each business object processes separately.","The default value is 25.","Enter a value between 1 and 8192.","In the Max Job Count field, enter the number of processes used for this service on your server.","The default value is 1.","Enter a value between 1 and 20.","To configure TimeDistributed:","In the Page Size field, enter the maximum number of rows of time-distributed (spread) data that a job can process. This applies to each business object that falls under the time-distributed category. When using this setting, each business object processes separately.","The default value is 16.","Enter a value between 1 and 8192.","In the Max Job Count field, enter the number of processes used for this service on your server.","The default value is 1.","Enter a value between 1 and 20.","To configure Log:","In the Security Level drop-down menu, select the level of information contained in the log file for all publication services. The ranges are inclusive. For example, select debug to log all messages; select info to log details about what runs, exceptions, and warnings; select warning to log both warning and error level messages.","The default value is info.","Select info, debug, warning, or error.","In the Global Service Log File Cap (Success) field, enter the number of logs to retain for successful global publication services. This will retain a log for each global service. If set to 5, the last 5 successful service runs will be retained for each global service.","The default value is 5.","Enter a value between 1 and 25.","In the Global Service Log File Cap (Fail) field, enter the number of logs to retain for failed global publication services. This will retain a log for each global service. If set to 5, the last 5 failed service runs will be retained for each global service.","The default value is 5.","Enter a value between 1 and 25.","In the Project Service Log File Cap (Success) field, enter the number of logs to retain for successful Publish Project jobs. This will retain a log for each project service. If set to 5, the last 5 successful service runs will be retained.","The default value is 5.","Enter a value between 1 and 25.","In the Project Service Log File Cap (Fail) field, enter the number of logs to retain for failed Publish Project jobs. This will retain a log for each project service. If set to 5, the last 5 failed service runs will be retained, per project.","The default value is 5.","Enter a value between 1 and 25.","Configuring Publication Settings in Services Settings","51618.htm");
Page[14]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you have scheduling work that needs to be done immediately, you should set the Interval low (for example, 10s) and the Concurrent Threads high. Remember that if the server is actively applying the service, all users will experience delays in the application.","To configure your publication settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication, and select Services.","You can use Project Arbiter to automate submitting Publish Project services for eligible projects to the service queue.","To configure Project&nbsp;Arbiter:","Select Active Mode if you want jobs processed continuously until all jobs finish. Leave this field clear if you want each job processed according to the Interval.","In the Interval field, enter the amount of time the service will wait before running the next available job.","The default value is 10s.","Enter a value between 1s and 24d20h31m23s647.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that this service will not run on this server. ","The default value is 1. ","Enter either 0 or 1.","To configure Publish Enterprise Summaries:","Note Publish Enterprise Data, Enterprise Summaries, Resource Management, and Security will recalculate data and store it in physical fields in the Extended Schema tables, and will perform other data denormalization tasks. For example, duration fields are calculated fields in the existing P6 schema tables, but will be recalculated and stored as physical fields in the extended schema tables when a project is published.","Select Active Mode if you want jobs processed continuously until all jobs finish. Leave this field clear if you want each job processed according to the Interval.","In the Interval field, enter the amount of time the service will wait before running the next available job.","The default value is 10s. ","Enter a value between 1s and 24d20h31m23s647.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that this service will not run on this server. ","The default value is 1. ","Enter either 0 or 1.","To configure Publish Resource Management:","Select Active Mode if you want jobs processed continuously until all jobs finish. Leave this field clear if you want each job processed according to the Interval.","In the Interval field, enter the amount of time the service will wait before running the next available job.","The default value is 10s. ","Enter a value between 1s and 24d20h31m23s647.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that this service will not be run on this server. ","The default value is 1. ","Enter either 0 or 1.","To configure Publish Resource Role Assignment:","Select Active Mode if you want jobs processed continuously until all jobs finish. Leave this field clear if you want each job processed according to the Interval.","In the Interval field, enter the amount of time the service will wait before running the next available job.","The default value is 10s.","Enter a value between 1s and 24d20h31m23s647.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that this service will not run on this server.","The default value is 1.","Enter either 0 or 1.","To configure Publish Project:","Select Active Mode field if you want jobs processed continuously until all jobs finish. Leave this field clear if you want each job processed according to the Interval.","In the Interval field, enter the amount of time the service will wait before running the next available job.","The default value is 10s. ","Enter a value between 1s and 24d20h31m23s647.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that this service will not be run on this server. ","The default value is 2. ","Enter a value between 0 and 20.","To configure Publish Enterprise Summaries:","Note Publish Enterprise Data, Enterprise Summaries, Resource Management, and Security will recalculate data and store it in physical fields in the Extended Schema tables, and will perform other data denormalization tasks. For example, duration fields are calculated fields in the existing P6 schema tables, but will be recalculated and stored as physical fields in the extended schema tables when a project is published.","Select Active Mode if you want jobs processed continuously until all jobs finish. Leave this field clear if you want each job processed according to the Interval.","In the Interval field, enter the amount of time the service will wait before running the next available job.","The default value is 10s. ","Enter a value between 1s and 24d20h31m23s647.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that this service will not run on this server. ","The default value is 1. ","Enter either 0 or 1.","Configuring Publication Services in Services Settings","51619.htm");
Page[15]=new Array("To test P6 sample reports, you must:","Assign Enterprise Reports module access to the P6 user.","Have a Oracle Analytics Publisher user who matches your P6 user name and has the P6 Reports role.","Run publication services first to ensure the report runs successfully.","To test sample reports:","Log in to P6.","Click Reports.","On the Report page:","Click the Reports tab.","Select a report.","Click Run....","In the Run Report dialog box:","In the Schedule Name field, enter a name for the report.","In the Template list, choose a template to apply to the report.","In the Output Format list, choose a file format for the delivery of the report.","In the Delivery Type list, choose to have the report sent through email or display the file immediately.","If you chose Email, click @&nbsp;Send&nbsp;Email and enter or select email addresses for the intended report recipients.","If you chose File, the report will display after you click Run.","If you chose Email, in the Notification section, choose to send yourself a status notification of the report run.","In the Report Parameters section, specify values for the parameters in the Field Name column. You can enter values directly in the field or double-click in the field and click @&nbsp;Select to open a selection dialog box.","Note","When selecting project parameters, if you choose to add an EPS to the Selected Projects list, only the projects directly under the EPS are added. If additional EPS elements are under the parent EPS, these projects will not automatically be included in the report; however, you can select additional EPS elements and add them to the Selected Projects list.","To avoid system performance issues, be as specific as possible when entering values for reports. Narrow down your choices to include only what is absolutely necessary.","Click Run.","Tip","Refer to the sample reports included with P6 for examples on how to create Oracle Analytics Publisher reports to use with P6 on an Oracle database.","You can find sample reports in the P6reports.zip folder of the P6 EPPM physical media or download. ","Use the BIPP6reportsOracle folder.","NoteThe P6 EPPM sample reports were designed to be run against the small data set included in the sample database. These reports are provided as an example of the product's capability only. Oracle provides no guarantee, implied or explicit, that the sample reports will run against your database or will produce meaningful data when they are run against your database. You may modify the sample reports to suit your own data set, including adding filter criteria to limit data output or changing filter criteria to suit your data.","Testing P6 Sample Reports","51675.htm");
Page[16]=new Array("Use the information in this section to setup Oracle Analytics Publisher with LDAP. Before you begin, ensure you have:","Set P6 EPPM to use LDAP. See the P6 EPPM System Administration Guide for more information.","Assigned the Enterprise Reports module in P6 to each user who needs access to reports.","Restart the Oracle Analytics Publisher server.","Configuring Oracle Analytics Publisher for LDAP","54175.htm");
Page[17]=new Array("To utilize LDAP, you should configure Oracle Analytics Publisher to use the &quot;Oracle Fusion Middleware&quot; security model and configure WebLogic to use LDAP.","To configure WebLogic to use LDAP:","Log in to WebLogic.","Under Domain Structure, select Security Realms.","Select the myrealm link.","In the settings for myrealm page, select the Providers tab.","Select the DefaultAuthenticator link.","Select Lock and Edit in the Change Center.","Set the Control Flag dropdown to Sufficient.","Save your changes.","Return to the Providers page.","Select the new button to create a new provider (this will allow you to connect to an LDAP server).","In the Name field, call the provider anything you want.","In the Type dropdown, select the provider that makes sense for your environment (if active directory, select 'ActiveDirectoryProvider').","Select OK.","Select the link for the provider you created.","On the Common tab, set the Control Flag to Sufficient.","Select the Provider Specific tab.","Configure the fields to connect to one of your LDAP servers.","Save the changes.","Return to the Providers page.","Select the Reorder button and move the LDAP provider to the top of your list.","If needed, repeat these steps to create additional LDAP Server connections.","In the Change Center section, select Active Changes.","Note Do not restart Oracle Analytics Publisher until you complete the steps in the following sections.","Configuring WebLogic For Multiple LDAP Servers","85507.htm");
Page[18]=new Array("To use LDAP authentication, you must configure your Oracle Analytics Publisher deployment to connect with multiple security providers.","To connect Oracle Analytics Publisher to multiple security providers:","Log in to Enterprise Manager in the Oracle Analytics Publisher domain (http://adminserverhost:port/em) as your WebLogic admin user.","On the left pane, expand the WebLogic Domain folder.","Right-click on your domain and select Security, Security Provider configuration.","Default domain: bi","Under the Identity Store Provider grouping, click Configure.","Click Add to add a custom property:","In Property Name field, enter virtualize.","In Property Value field, enter true.","Select OK.","Log out of Enterprise Manager.","Configuring Oracle Analytics Publisher To Connect To Multiple Security Providers","85508.htm");
Page[19]=new Array("You must restart Oracle Analytics Publisher for authentication settings changes to take effect and to begin using LDAP authentication.","To confirm you have successfully configured LDAP:","Restart the Oracle Analytics Publisher server.","Log in to WebLogic Administrative console.","Under Domain Structure, select Security Realms.","Select the myrealm link.","In the settings for myrealm page, select the Users and Groups tab. You should see users from the LDAP providers you set up. This confirms successful configuration of &lt;0P_ProdName_OASs&gt;.","Restarting Oracle Analytics Publisher Domain and Confirming LDAP Setup","85509.htm");
Page[20]=new Array("Data in the P6 Extended Schema is calculated and stored by Publication Services, which gives administrators control over when data is calculated and stored in the P6 Extended Schema. Publication Services exist for project and global data. Global data includes enterprise data, as well as resource and role, portfolio, security and audit data. Project data includes all information about projects and baselines, including summaries and calculations. ","The Publish Project service is dedicated to publishing project and baseline data to the P6 Extended Schema.","Note The Publish Project service recalculates and publishes all project business objects containing calculated or denormalized data including, but not limited to: the WBS, activities, resource/role assignments, high-level planning assignments, relationships, risks, documents, expenses, steps, milestones, UDF values, notes, issues, budget change logs, timesheets, code assignments, funding source assignments.","These additional Publication Services publish global data to the P6 Extended Schema:","Publish Audit Data","Publish Enterprise Data","Project Data","Activity Data","Resource Data","Calendar Data","Enterprise Data dictionary definitions","Publish Enterprise Summaries","Publish Resource Management","Publish Security","The first time a data type is published to the P6 Extended Schema all data is recalculated and published to the extended schema tables. After a data type has been published for the first time, future publication services recalculate and publish only data that has changed since the last time that data was published.","When any of the publication services runs, each business object type processed by the service is individually timestamped, and the timestamp stored in the database. The services can accurately determine exactly which data has changed since the last time it was published using these timestamps because they exist at the individual business object type level.","Configure Publication Services in P6 as follows:","Set up automatic publication and enable P6 to publish project and global data on the Services page in Application settings. ","Enable the types of global data to be scheduled in Global Scheduled Services. ","Disable or enable publication for a selected project on the Services page in Project Preferences. ","Add, verify the status of, modify, or delete project management services on the Project Scheduled Services page. ","Tip","Run the global data services before turning on the Project Arbiter service.","Publication Services","66129.htm");
Page[21]=new Array("Before you can generate reports or view data in some areas of P6, data must be refreshed and calculations must be made in precisely arranged tables and fields. Publication Services address these needs, gathering and calculating data as close as possible to real-time. To make this happen, you can configure P6 to publish data to specific tables used for these features. An administrator must configure settings for Publication Services before you can publish data. For reports, depending on the type of data published, P6 tables may still be used to generate reports, or a combination of P6 and reporting tables may be used to generate them. ","Your organization's P6 EPPM published data has two categories: project data and global data. ","Published project data includes all information about your projects, including aggregates, calculations, and auditing data. Most pages that use published data use published project data.","You can publish project data on an ad-hoc basis using the Publish Projects item on the Actions menu of the EPS or Activities pages, allow P6 to publish automatically on the basis of how much the project has changed, or you can schedule a service to publish project data automatically.","Published global data includes enterprise data for projects (for example, codes and UDFs), activities (for example, codes and UDFs), resources, and calendars as well as the enterprise data dictionary and security data. Reports use published global data as well as published project data. ","Global data is published by services which are usually scheduled to run automatically.","P6 tracks all projects enabled for publishing and determines when each project will be published on the basis of the number of changes made to the project and the time since its data was last published. You can configure the settings guiding this process on the Services page of Application Settings.","Publish a changed project when the... Number of changes exceeds: P6 tracks the combined number of changes to the project itself as well as its WBS, activities, relationships, resource and role assignments, risks, project codes, activity codes, and UDFs.","Publish a changed project when the... Time since last publication exceeds: P6 also considers when the project was most recently published and whether that period exceeds the Time since last publication setting.","If both the number of changes is great enough and the published data is old enough, as stipulated by these two settings, P6 creates a job to publish the data.","Note P6 has checks in place to ensure that publishing jobs cannot impair system performance, no matter how many jobs are created at any given time.","About Publication Services","48710.htm");
Page[22]=new Array("To achieve near real-time reporting, usage, and analysis date, you can configure P6 to publish to tables that store updated data, including calculations and summary data. These tables also create views for generating reports. The P6 data is split into two general categories: project data and global data. Project data includes all information about your projects, including aggregates and calculations. Global data includes enterprise data, as well as resource and role, portfolio, and security data. The image below encapsulates the key concepts in the publication and reporting process.","Table of Key Publication Services Concepts","Item","Description","EPPM Database: The EPPM database captures all the data your organization generates every second of every day. However, the raw data in the EPPM database is not structured for immediate reporting.","Project Data: You can configure P6 to publish a project based on publication thresholds. Based on the options you select, you can prioritize projects for publication in a queue. If necessary, you can manually add a project to the queue. ","Global Data: You can configure services in P6 to schedule the publication of global data based on recurring intervals that you specify. If necessary, you can also immediately publish this data manually.","Project Queue: Projects publish in sequential order based on priority. Your administrator can control which projects are added to the publishing queue, when, and in what order. These options ensure the project data you need most is available for P6 in near real-time.","P6 Extended Schema Tables: The project and global services recalculate certain logical fields in the P6 EPPM database and store them as physical fields in the P6 Extended Schema tables so they are available for reporting and other purposes. Some fields in P6, such as durations, are calculated in real time as related field data is changed and are not stored in the database. Publication services recalculate these fields and store their values in the extended schema tables. Other fields, such as notebook topics, are not stored in the database in a format suitable for reporting. For these fields, publication services will convert them to a format more suitable for reporting.","Note For information about which tables are updated by the Publication Services, see the following knowledge management document:","What PX tables are updated when running Global Scheduled Services or Publish Project (KB495991)","P6 Reports: You can run reports directly against P6 Extended Schema table views.","Working with Publication Services","49312.htm");
Page[23]=new Array("Before data can be published, you must configure the settings that control publishing in P6.","Specify the timeframe for which data should be published and the distribution interval for the published data.","See Defining Publication Periods.","Enable publication and specify how often data will be published.","See Enabling Automatic Publishing of P6 Project Data.","Determine the types of enterprise and project data to publish.","See Enabling Automatic Publishing of P6 Global Data.","Specify which projects should be published and the relative priorities of projects for publishing.","See Configuring Publication Service Settings for Projects.","Optionally set up services to publish project data at scheduled intervals.","See Creating Project Scheduled Services.","Configuring Publication","101756.htm");
Page[24]=new Array("Reports based on P6 data require timely access to the most current data in order to be accurate. For example, report recipients expect to see updated enterprise data and project data including any calculations. ","Some other areas of P6 also rely on published data to provide accurate information.","In order to provide this data, P6 generates and stores data in reporting tables (the P6 Extended Schema). You can configure P6 to publish essential data to the tables automatically, schedule the publication of project data to happen at specific times of day, or you can choose to generate it on demand so that the most current data is available. You can select to be notified by email if publication services fail.","The data is split into two general categories: project data and global data. Project data includes all information about your projects, including baselines, summaries, calculations, and audit data. Global data includes enterprise data, project, activity, resource, calendar, enterprise data dictionary, resource and role data, security and audit data. Most pages that use published data access project data. Reports can use both project and global data.","Note In areas of the software that show published data, a user who has the right to view costs and financials at WBS level but not at Project level will not see financial data at the WBS level. Although the user has the privilege to view cost and financial data at WBS level, the data is only published at project level.","Publishing P6 Data","48619.htm");
Page[25]=new Array("Before publishing global or project data for reporting, define the publication period. The publication period you define should be large enough to capture all the project data you need to include in reports. Data before or after the defined publication period range is assigned to the period before or after the publication period range (respectively).","Caution You can perform these steps again at any time to modify your settings. However, if an Admin Superuser modifies the Start date, Time distributed interval, or Finish date is current date plus fields, all data will be fully recalculated. Oracle recommends that you only reconfigure publication options on weekends or during off-peak hours to prevent the disruption of other P6 features.","To define the publication period:","Click Administration.","On the Administration navigation bar, click Application Settings.","On the Application Settings page, click Services.","On the Services page, in the Publication Periods section:","In the Start date field, click @&nbsp;Select&nbsp;Date to select the exact month, day, year, and time to mark the initial start of the data publication period. Select any date in the past that represents a reasonable amount of historical spread data for your organization. For example, in order for users to be able to produce time-distributed reports for any date range, enter the earliest project start date at your organization.","In the Finish date is current date plus field, select a numeric quantity and unit of time to construct a dynamic period of time. Whenever a publication service runs, this period of time is added to the current date to determine the finish date for the publication of data. For example, if the value is 5 years, time-distributed data will always be published covering the period of time that begins with the value in the Start Date field and extends five years into the future each time a service runs.","In the Time distributed interval field, select the unit of time in which time distributed data will be recalculated and published. Time distributed interval is set to Week by default. Set this to Day if you need to see daily data.","Click Save.","Defining Publication Periods","49552.htm");
Page[26]=new Array("Perform the following procedure to enable projects for publication, and to set options for automatic project publication. Then, as you work, P6 automatically detects the changes to your projects that trigger the publication of their data.","To enable Publication Services for project data:","Click Administration.","On the Administration navigation bar, click Application Settings.","On the Application Settings page, select Services.","On the Services page, in the Project Publication section:","Select Enable Publish Projects to enable automatic project publication based on defined thresholds. Selecting this option also allows users to publish projects on demand.","In the Publish projects every field, select an interval by which projects are polled to be published.","Enter a number in the Number of changes exceeds field. This threshold setting determines the number of edits users can make to the project data before P6 publishes its data. Assuming a constant rate of change among projects, a lower value will result in more frequent publication of project data. If you enter a value of 0, projects with tracked changes will be automatically published.","Enter a time period for the Time since last publication exceeds field. This threshold setting determines how often the publication of project data should occur. For example, if you enter 12 hours, the project data will be published every 12 hours unless the threshold for the number of changes has already been reached. ","Select Publish idle projects to add projects to the service queue that are enabled for publication but have not been changed during the time threshold. This setting is only valid for the initial run of the service.","In the Maximum number to publish field, enter the maximum number of pending idle Publish Project services that can be present at once in the service queue. This prevents performance problems during peak demand when enabling the publication of a large number of projects. For example, if the service runs and queues 40 projects that have exceeded specified thresholds and must be published, or that have been published on demand by users, and you have set the maximum to 100, P6 will schedule up to 60 idle projects for publication.","Select Publish resource and role data if you want to be able to publish resource and role spread data.","Select Enable Baseline Publication if you want to be able to publish baseline data.","Select Enable Notification Email and type an email address in the Notification Email address field if you want to receive an email if publication services fail.","Click Save.","Tip","You can also schedule project data to be published at specific times of day.","If your organization is upgrading to P6, select Publish idle projects to add your migrated projects to the service queue after your database is upgraded. This will publish all your projects in the queue and refresh the available data for reporting. After an upgrade, this setting is no longer applicable, and projects will be submitted to the service queue based on threshold values specified on the Application Settings page.","Clear the Publish idle projects option if your organization does not report against completed projects.","The Maximum number to publish field is only applicable immediately following an upgrade, when all projects are considered idle. When all projects have been published, the service queue will no longer be constrained based on this setting.","A project will be automatically submitted to the service queue if you change the project baseline, calendar, or data date. Projects are also automatically submitted to the queue if you select or clear Calculate Activity % Complete from activity steps option, or modify the default price/unit value for assignments without activities, from the Set Project Preferences dialog box.","For threshold settings, projects are added to the service queue based on tracked changes to data. Only changes to activities, resource/role assignments, relationships, risk assignments, UDF values, activity code assignments, project code assignments and the WBS are tracked.","You can delete published project data by selecting Delete Published Data on the Actions&nbsp;@ menu of the EPS page.","Enabling Automatic Publishing of P6 Project Data","48877.htm");
Page[27]=new Array("Perform the steps below to configure P6 to automatically publish any of the following types of global data to reporting tables.","Enterprise Data","Project Data","Activity Data","Resource Data","Calendar Data","Enterprise Data dictionary definitions","Enterprise Summary Data including portfolio data","Resource Management Data","Security Data","Audit Data","To automatically publish P6 global data:","Click Administration.","On the Administration navigation bar, click Scheduled Services.","On the Scheduled Services page, select Global.","On the Global page:","Select a service, then configure its settings in the Service Settings detail window. For example, you might specify that the service runs daily with a start time of 08:00 AM.","Note Oracle recommends running the Publish Security service first if the Run After Previous option is selected in the Run Service list for other publication services. Running the Publish Security service first will ensure that security data updates in the extended schema as soon as possible and ensures that the security restrictions are in place before you run the report.","Select the Enabled option for any of the global services listed.","If you choose to run one or more services with the relative frequency value of After previous service, click Move Up or Move Down to arrange the services in your preferred sequence.","Click Save.","Enabling Automatic Publishing of P6 Global Data","48684.htm");
Page[28]=new Array("After enabling automatic publishing or adding a job to publish project data on a scheduled basis, perform the following procedure to configure settings for each individual project in Publication Services. Then, as you work, P6 automatically detects the changes to your project that trigger the publication of its data in the service queue.","To configure Publication Service settings for a project:","Click Projects.","On the Projects navigation bar, click EPS.","On the EPS page:","Select a project.","Click @&nbsp;Row&nbsp;Actions and select Set Project Preferences.","In the Project Preferences dialog box, select Analytics &amp;Services.","On the Analytics &amp;Services page, in the Publication section:","Select the Enable Publication option.","Adjust the relative Publication Priority up or down between 1 and 100 with 50 being the default priority value, 1 being the highest priority, and 100 being the lowest.","Click OK.","Tip","By default, all projects are enabled for publication. You only need to modify the Enable Publication setting if you want to disable publication for a project or re-enable publication of a previously disabled project.","Clearing the Enable Publication setting does not delete previously published data. You can delete published project data by selecting Delete Published Data on the Actions&nbsp;@ menu in the EPS page.","If you wish to modify publication settings for many projects at one time, you can display the Enable Publication, Last Published On, and Publication Priority fields as columns in your EPS view.","If you want to publish Baseline data, you must also publish project data for the relevant projects.","Configuring Publication Service Settings for Projects","49606.htm");
Page[29]=new Array("After enabling automatic publishing or adding a job to publish project data on a scheduled basis, perform the following procedure to configure settings for each individual project's baselines in Publication Services. Then, as you work, P6 automatically detects the changes to your baselines that trigger the publication of its data in the service queue.","To configure Publication Service settings for a baseline:","Click the Projects&nbsp;@ menu and choose Open Projects.","In the Open Projects dialog box, open one or more projects whose baselines you want to enable for publication.","On the Project navigation bar, click Activities or EPS.","On the Activities or EPS page, click Actions&nbsp;@ and select Define Baselines.","In the Define Baselines dialog box:","If you want to switch on publication for all baselines for a project, select the Publish option in the project band.","If you want to switch on publication for only some baselines for a project, expand the project band and select the Publish option for the baselines you want to publish.","Click Save.","Configuring Publication Service Settings for Baselines","78355.htm");
Page[30]=new Array("You can publish the data from projects on demand. Projects are added to the queue of projects being processed for publication the next time the Publish Projects service runs. You can check the status of the Publish Projects service after it has been added to the service queue by selecting View Service Status from the User menu. When you publish projects on demand, any of the projects' baselines which is enabled for publishing will also be published. Only projects enabled for publication are published.","To publish P6 project data on demand:","Click Projects.","On the Projects navigation bar, click EPS.","On the EPS page:","On the Actions&nbsp;@ menu, click Publish Projects.","Tip","In order to manually project data from the EPS page on demand, Publication Services must be enabled and configured.","You can publish all open projects by clicking Publish Projects on the Actions&nbsp;@ menu of the Activities page. You can also publish projects by selecting one or more projects on the EPS page, and then using the right-click menu.","If you have permission to view application settings, you can see the settings for the Publish Projects service, including how often the service runs, on the Global tab of the Secheduled Services page.","A project will be automatically submitted to the service queue if you change the project baseline, calendar, or data date. Projects are also automatically submitted to the queue if you select or clear the Calculate Activity % Complete from activity steps option, or modify the default price/unit value for assignments without activities from the Set Project Preferences dialog box available from the Actions&nbsp;@ menu the EPS page.","You can delete published project data by selecting Delete Published Data on the Actions&nbsp;@ menu of the EPS page.","Publishing P6 Project Data On Demand","48620.htm");
Page[31]=new Array("You can publish any of the following types of global data to the reporting tables on demand.","Enterprise Data","Project Data","Activity Data","Resource Data","Calendar Data","Enterprise Data dictionary definitions","Enterprise Summary Data including portfolio data","Resource Management Data","Security Data","Audit Data","To publish P6 global data on demand:","Click Administration.","On the Administration navigation bar, click Scheduled Services.","On the Scheduled Services page, select Global.","On the Global page:","Select a global service.","Click Run Service.","In the resulting message box, click OK.","Tip","If the service listed under the manually selected service is configured to run After previous service, it will run automatically when the selected service finishes. ","You must have the Administer Global Scheduled Services global security privilege to run a global scheduled service. ","Publishing P6 Global Data On Demand","48709.htm");
Page[32]=new Array("You can schedule services to run at intervals you choose on projects that you select. Available services include apply actuals, export, import, level, project checker, publish, schedule, summarize, and send to schedule sheet.","To create project scheduled services:","Click Administration.","On the Administration navigation bar, click Scheduled Services.","On the Scheduled Services page, click Project.","Click Add&nbsp;@ and select the type of service to add.","Enter a name for the new service.","In the Project Settings detail window:","Select @&nbsp;Add to add projects, EPS nodes, project code values, or portfolios to the Project table.","Note You cannot select projects for Import Primavera XML services.","Enter or select a value for every field.","Select or clear the Enabled option to determine whether the service will run.","Select Save.","Tip","You cannot schedule services for project templates.","Creating Project Scheduled Services","44525.htm");
Page[33]=new Array("If you change the start date in the Publication settings, you will need to delete the contents in the REPORTDATE table. When you delete the content from the REPORTDATE table, the publication services will refill the table the next time you run the Publish Enterprise Data service.","To delete content from the REPORTDATE table, the database administrator will need to:","Log in to the database.","Run one of the following commands:","DELETE FROM REPORTDATE;","or","TRUNCATE TABLE REPORTDATE;","Back Filling the REPORTDATE Table","50170.htm");
Page[34]=new Array("P6 supports parameter keys in Oracle Analytics Publisher. You will use these parameters in the P6 Reports section when running and scheduling reports. For most of the parameters you add, lists will be available for users when they are entering the value. The default behavior for an unrecognized parameter will be to provide a plain text box. The user will then need to type in the correct value. If the value is not in the format the report expected, the report will fail to run.","Adding parameters to your reports allows users that run or schedule a report. They can select or filter what data to include without having to first create additional reports or data templates for reports. For example, consider this scenario:","You have a report on activities and each activity has an activity code value assigned to it to determine the location of the team working on it. ","You want each team to be able to run the report, but they want to see only the activities for their location.","Without parameters, you would need to create a different report and data template for each team. All of these reports would be almost the same, except each statement pulling the activity data would have a different connection to the activity code table to match the correct location. With parameters, you can do this with just one report and data template.","Why Do I Need Parameters?","47002.htm");
Page[35]=new Array("When adding a new parameter in Oracle Analytics Publisher you will see the following fields: ","Identifier &#8211; The key for the parameter. Determines whether a list supports the parameter.","Data Type &#8211; String should be the default type. When using a supported parameter, select String for the type. See Primitive Parameters for more on Date, Boolean, and Integer parameters. ","Default Value &#8211; The value entered in this field will be the default for the parameter whenever the report runs. Users will be able to see this value in P6.","Parameter Type &#8211; Text, Menu, and Date are the common types. Unless otherwise specified, you should use Text as the default for the supported parameters. If you need to select multiple values, use Menu. ","Display Label &#8211; The text that displays in P6 for the parameter. If you do not set a display label, the identifier displays instead.","Defining Parameters in Oracle Analytics Publisher","47771.htm");
Page[36]=new Array("You can use any parameter for Oracle Analytics Publisher, but users have to ensure they enter the value correctly or the SQL statements in the data template will fail. Using supported parameters allows you to provide a user interface to enter the values for parameters. Supported parameters for P6 fall into one of the following categories: ","Enumeration parameters allow users to pick parameters from static lists.","Dynamic parameters generate the list at run time. For example, when focusing on Project ID, users see a Project list that pulls the current projects from the P6 EPPM database. ","Primitive parameters support basic selections. For example, if a parameter is a Boolean, an option appears for users to select or clear a text box instead of entering true or false.","The following are the supported parameters for P6, grouped by category:","Enumeration Parameters","Activity Priority","Activity Status","Activity Type","Assignment Proficiency","Constraint Type","Duration Type","Percent Complete Type","Project Status","Rate Source","Rate Type","Resource Type","Risk Status","Risk Type","Dynamic Parameters","Activity Code Value","Cost Account","EPS","Expense Category","Funding Source","Portfolio","Project","Project Code Value","User Defined Project Code (type and value)","User Defined Resource Code","Resource Code Value","Resource Team","Resource ID","Responsible Manager","Risk Category","Role","Role Team","Timesheet Period","User","User Defined Activity Code (type and value)","Primitive Parameters","Boolean","Date","Float","Integer","Custom Parameters","List of Values","Supported Parameters in P6","47008.htm");
Page[37]=new Array("Enumeration parameters map to fields that have a set list of possible values. When running a report with an enumeration parameter, P6 will offer a list to select one of the values. Users will see the localized text for the enumeration value's description; however, the return value will be the English description of the enumeration, which is the value the PX Views database stores.","Descriptions of enumeration parameters are in the following format:","Parameter: Name of the parameter.","Identifier: The value you must enter in the identifier field in Oracle Analytics Publisher when creating the parameter for the report.","Details: A description and technical details of the parameter.","Values: The values that will be available in P6.","Maps to field: The database field the return value maps to in the PX Views database. It could match multiple fields in the database, so only the primary table is listed.","Use case: An example of how you might use the parameter in a report.","Supported Enumeration Parameters","Parameter: Activity Priority ","Identifier: p_activity_priority","Details: Allows users to select the leveling priority of an activity. ","Values: Top, High, Normal, Low, Lowest","Maps to field: ACTIVITY.LEVELINGPRIORITY","Use case: Filter activity data by leveling priority. ","Parameter: Assignment Proficiency ","Identifier: p_assignment_proficiency","Details: Allows users to select a value for assignment proficiency.","Values: Master, Expert, Skilled, Proficient, Inexperienced","Maps to field: RESOURCEASSIGNMENT.PROFICIENCY","Use case: Filter resource assignment data by the proficiency of the assignment. ","Parameter: Activity Status","Identifier: p_activity_status","Details: Allows users to select activity status. ","Values: Not Started, In Progress, Completed","Maps to field: ACTIVITY.STATUS","Use case: Filter activity reports based on a certain status. ","Parameter: Activity Type","Identifier: p_activity_type","Details: Allows users to select the activity type. ","Values: Task Dependent, Resource Dependent, Level of Effort, Start Milestone, Finish Milestone, WBS Summary","Maps to field: ACTIVITY.TYPE","Use case: Filter activity reports based on the type of the activity. ","Parameter: Constraint Type","Identifier: p_contstraint_type","Details: Allows users to select an activity constraint type. ","Values: Start On, Start On or Before, Start On or After, Finish On, Finish On or Before, Finish On or After, As Late As Possible, Mandatory Start, Mandatory Finish","Maps to field: ACTIVITY.PRIMARYCONSTRAINTTYPE and ACTIVITY.SECONDARYCONSTRAINTTYPE","Use case: Filter activities in a report by the activity primary or secondary constraint type. ","Parameter: Duration Type","Identifier: p_duration_type","Details: Allows users to select the duration types of an activity. ","Values: Fixed Units/Time, Fixed Duration &amp; Units/Time, Fixed Units, Fixed Duration &amp; Units","Maps to field: ACTIVITY.DURATIONTYPE","Use case: Filter activities in a report based on their duration type. ","Parameter: Percent Complete Type","Identifier: p_percent_complete_type","Details: Allows users to select the percent complete type of an activity.","Values: Physical, Duration, Units","Maps to field: ACTIVITY.PERCENTCOMPLETETYPE","Use case: Filter activities in a report based on the percent complete type of the activity.","Parameter: Project Status","Identifier: p_project_status","Details: Allows users to select the status of a project.","Values: Planned, Active, Inactive, What If, Requested, Template","Maps to field: PROJECT.STATUS","Use case: Filter the projects in a report based on the desired type. For example, you might want to use this for a report that needs to display information only on planned projects.","Parameter: Rate Source","Identifier: p_rate_source","Details: Allows users to select the rate source of an assignment. ","Values: Resource, Role, Override","Maps to field: RESOURCEASSIGNMENT.RATESOURCE","Use case: Filter resource assignments included in a report based on the rate source of the assignment. ","Parameter: Rate Type","Identifier: p_rate_type","Details: Allows users to select the rate type of an assignment.","Values: Price/Unit, Price/Unit 2, Price/Unit 3, Price/Unit 4, Price/Unit 5 ","Maps to field: RESOURCEASSIGNMENT.RATETYPE","Use case: Filter resource assignments included in a report based on the rate type of the assignment. ","Parameter: Resource Type","Identifier: p_resource_type","Details: Allows users to select the resource type of an assignment. ","Values: Labor, Nonlabor, Material","Maps to field: RESOURCEASSIGNMENT.RESOURCETYPE","Use case: Filter resource assignments included in a report based on the resource type of the assignment.","Parameter: Risk Status","Identifier: p_risk_status","Details: Allows users to select the status of a risk.","Values: Proposed, Open, Active, Rejected (Closed), Managed (Closed), Impacted (Closed)","Maps to field: RISK.RISKSTATUS","Use case: Filter risks in a report based on the status of the risk. ","Parameter: Risk Type","Identifier: p_risk_type","Details: Allows users to select the type of a risk.","Values: Threat, Opportunity","Maps to field: RISK.RISKTYPE","Use case: Filter risks in a report based on the type of risk.","Enumeration Parameters","47008.htm#o47009");
Page[38]=new Array("Dynamic parameters map to fields that have a varying list of possible values. When running a report with a dynamic parameter, P6 will offer a list to select one of the available values.","Descriptions of dynamic parameters are in the following format:","Parameter:Name of the parameter.","Identifier: The value you must enter in the identifier field in Oracle Analytics Publisher when creating the parameter for the report. In some cases, identifiers can pass in context by appending short names to the end of the identifier. The character in quotations is the separator that the code splits and &lt;name&gt; represents the context you are trying to pass in.","Details: A description and technical details of the parameter.","P6: What the editor for the parameter will be in the Reports section of P6.","Return Value: The values that will be available in P6.","Maps to field: The database field the return value maps to in the PX Views database. It could match multiple fields in the database, so only the primary table is listed.","Use case: An example of how you might use the parameter in a report.","Supported Dynamic Parameters ","Parameter: Activity Code Value","Identifier: p_a_code_val__&lt;short name&gt; ","Details: Enables users to select an activity code value via a list. Context passes into the parameter by appending a colon&quot;:&quot; followed by the short name of the activity code type you want to set.","P6: Provides a list that displays the Activity Code Values for the Activity Code type passed in the context.","Return value: Short name of the Activity Code (unique per code type).","Maps to field: ACTIVITYCODE.CODEVALUE","Use case: Create a report that displays some basic information about activities. Users at five locations need to run the report, but they only want to see the data for activities with codes matching their location. Instead of creating five reports hard coding the location (for example, location=L1) on each report, you can create one report and add this parameter to it (for example, p_a_code_val__Location).","In the data template for the report, filter the activities based on this parameter. Hard code the left side of the activity filter to match the activity code you selected, which in this case is location. ","Example query: CODETYPENAME='Location' &amp; CODEVALUE=:p_a_code_val__Location","If you did not have a parameter for this, you would need different templates for each location.","Parameter: User Defined Activity Code","Identifier: p_activity_code_value &quot;.&quot; &lt;number&gt; p_activity_code_type &quot;.&quot; &lt;number&gt;","Details: Enables users to select a user defined Activity Code. The user defined Activity Code is two parameters on the report in Oracle Analytics Publisher, but will display only as one row in the report settings parameter table. ","P6: Provides a list that displays all global Activity Code types. When users expand a type, the list shows the values for that type. By selecting a value, both the type and value will return to the report. ","Return value: Short name for the Activity Code Value, primary key for the Activity Code type. ","Maps to field: ","p_activity_code_value maps to ACTIVITYCODE.CODEVALUE","p_activity_code_type maps to ACTIVITYCODE.CODETYPEOBJECTID","Use case: Create a report that can have a variable Activity Code. The report pulls activities and displays some basic statistics of the activities. The data template for the report must accommodate setting both sides of the query. While a typical parameter just sets the IN clause for a user defined field, this parameter must set both sides. The &quot;Activity Code Value&quot; parameter Use case example shows where it hard codes the CODETYPENAME to be Location. This parameter enables multiple user defined activity codes to be used on the same report. For each parameter you use, you must add p_activity_code_value.1 and p_activity_code_type.1. There must be a pair of numbers to ensure that the editor works properly.","Parameter: Cost Account","Identifier: p_cost_account","Details: Enables users to select Cost Accounts. The P6 user must have access to view Cost Accounts for the list to populate.","P6: Provides a list that displays all Cost Accounts in a hierarchical tree.","Return value: Short name of the cost account (unique).","Maps to field: COSTACCOUNT_FULL.NAME","Use case: Filter items using certain Cost Accounts or generate information on the Cost Accounts.","Parameter: EPS","Identifier: p_eps_id","Details: Enables a user to select an EPS.","P6: Provides a list that displays all of the EPS nodes where the user has access.","Return value: The short name of the EPS.","Maps to field: ","EPS_FULL.NAME","EPS_U.NAME","Use case: Use a parameter for EPS to filter a query to load all projects under an EPS for a report.","Parameter: Expense Category","Identifier: p_expense_category","Details: Enables a user to select Expense Category where the user has access.","P6: Will provide a list that displays all of the Expense Categories.","Return value: The short name of the Expense Category (unique).","Maps to field: ","EXPENSECATEGORY_FULL.NAME","EXPENSECATEGORY_U.NAME","Use case: Run a report filtered by assignments that use a certain Expense Category associated with them.","Parameter: Funding Source","Identifier: p_funding_source","Details: Enables a user to select a Funding Source.","P6: Provides a hierarchical list filled with Funding Sources where a user has access.","Return value: The short name of the Funding Source (unique).","Maps to field: ","FUNDINGSOURCE_FULL.NAME","FUNDINGSOURCE_U.NAME","Use case: Filter the report data to include only projects that have the selected Funding Source assigned.","Parameter: Portfolio ID","Identifier: p_portfolio_id","Details: Enables a user to select a Portfolio where the user has access.","P6: Provides a list of Portfolios where the user has access.","Return value: The portfolio short name (unique).","Maps to field: PROJECTPORTFOLIO_FULL.NAME","Use case: Filter the report data to include only the projects in a Portfolio.","Note If there is a user portfolio that shares the same name as one of the global portfolios, then the report will return data for both when you run it. You'll need to use the Portfolio Name and User ID to make a unique constraint.","Parameter: Project ID","Identifier: p_project_id","Details: Enables a user to select one or more projects where the user has access.","P6: Click the Projects&nbsp;@ menu, and select Open Project to display the Project list. Enables switching between Template and Regular projects.","Return value: The project short name (unique).","Maps to field: PROJECT_FULL.ID","Use case: Run a report where the data comes from selected projects.","Parameter: Project Code Value","Identifier: p_p_code_val__&lt;short name&gt;","Details: Select a Project Code value. Note that underscores (_) are the only special character allowed. Do not use other special characters.","P6: Provides a list containing the project code values for the Project Code whose short name matches the second part of the parameter. For example: If the short name was Scope, and there were four values &#8211; Local, Regional, Country, and Global &#8211; the list would display Local, Regional, Country, and Global in the list.","Return value: Activity code value short name (unique per code type).","Maps to field: PROJECTCODE_FULL.CODEVALUE","Use case: Filter the set of projects loaded to those projects that have the user-selected Project Code Value assigned to them.","Parameter: User Defined Project Code","Identifier: p_project_code_value&quot;.&quot;&lt;number&gt; p_project_code_type&quot;.&quot;&lt;number&gt;","Details: Similar to the User Defined Activity Code, this parameter consists of two parameters in Oracle Analytics Publisher: One parameter returns the selected Project Code Value, and the other parameter returns the Project Code type ID. For each parameter you use, you must add both p_project_code_value.# and p_project_code_type.#. There must be a pair of numbers for the editor to work properly. You can have multiple sets to allow for more than one User Defined Code Value.","P6: Provides a list populated with all the global Project Codes as the first level. Expanding a Project Code type will list all the values for the type. In the parameter table, only one row will represent both parameters. After you select a Project Code Value, both parameters will be set.","Return value: The short name for p_project_code_value and the object id for p_project_code_type.","Maps to field: ","p_project_code_value maps to PROJECTCODE_FULL.CODEVALUE ","p_project_code_type maps to PROJECTCODE_FULL.CODETYPEOBJECTID","Use case: Create a report that enables the projects to filter based on a Project Code that the user defines. Unlike the Project Code Value parameter, the report creator should not hard code the Project Code type. Instead, they should write the query to enable the p_project_code_type.1 parameter to determine the Project Code type. This lets a report be more flexible in the filter criteria.","Parameter: User Defined Resource Code","Identifier: p_resource_code_value &quot;.&quot; &lt;number&gt; p_resource_code_type &quot;.&quot; &lt;number&gt;","Details: Similar to the other user-defined codes this parameter consists of two parameters on the report in Oracle Analytics Publisher: One parameter returns the selected Resource Code Value, and the other parameter returns the Resource Code type ID. For each parameter you use, you must add both p_resource_code_value.# and p_resource_code_type .# There must be a pair of numbers in order for the editor to work properly. You can have multiple sets to allow for more than one user-defined code value.","P6: Provides a list populated with the Resource Codes as the first level. Expanding a Resource Code type will list all the values for the type. In the parameter table, only one row will represent both parameters. After you select a Resource Code Value, both parameters will be set.","Return value: ","p_resource_code_value: short name for the code value","p_resource_code_type: object id for the code type","Maps to field: ","p_resource_code_value maps to RESOURCECODE_FULL.CODEVALUE","p_resource_code_type maps to RESOURCE_CODE_FULL.CODETYPEOBJECTID","Use case: Create a report that allows for the resources to be filtered based on a Resource Code Value and type that the user defines. Unlike the Resource Code Value parameter, the report creator should not hard code the resource code type. Instead, they should write the query to enable the p_resource_code_type.1 parameter to determine the resource code type. This allows a report to be more flexible in the filter criteria.","Parameter: Resource Code Value","Identifier: p_r_code_val__&lt;short name&gt;","Details: Select a Resource Code value to use for filtering loaded resources for a report.","P6: Provides a list populated with the resource code values for the resource code type indicated by the &lt;short name&gt; at the end of the parameter. For example: If the short name was Department, the list would display Engineering, Marketing, Research, and Development as the values in the list.","Return value: The short name of the Resource Code Value (unique per code type).","Maps to field: RESOURCECODE_FULL.CODEVALUE","Use case: Create a report where the resources filter based on the resources that match the user-selected Resource Code Value for a particular Resource Code type. The report data query must hard code the Resource Code type for matching resources to the returned code value.","Parameter: Resource Team","Identifier: p_resource_team","Details: Enables resource team selection.","P6: Provides a list populated with resource teams that the user has access to view.","Return value: The short name of the resource team (unique).","Maps to field: RESOURCETEAM_FULL.NAME","Use case: Filter a report to load resources that are on the selected resource team.","Parameter: Resource ID","Identifier: p_resource_id","Details: Select a resource to filter a report.","P6: Provides a list populated with resources that the user has access to view.","Return value: The short name of the resource (unique).","Maps to field: RESOURCES_FULL.NAME","Use case: Filter the activities in a report based on the user-selected resource assigned to the activity.","Parameter: Responsible Manager","Identifier: p_responsible_manager","Details: Select a responsible manager (OBS).","P6 GUI: Provides a list populated with the OBS structure that the user has access to view. ","Return value: The short name of the OBS (unique).","Maps to field: PROJECT_FULL.OBSNAME and OBS_FULL.NAME","Use case: Filter a report to load only the projects that have the user-selected responsible manager.","Parameter: Risk Category","Identifier: p_risk_category","Details: Select a Risk Category.","P6: Provides a list populated with all the Risk Categories that the user has access to view. ","Return value: The name of the Risk Category (unique).","Maps to field: RISK_FULL.RISKTYPE","Use case: Filter a report to load only the Risks of the user-selected category.","Parameter: Role Team","Identifier: p_role_team","Details: Select a Role Team.","P6: Provides a list populated with all the Role Teams the user has access to view.","Return value: The name of the Role Team (unique).","Maps to field: ROLLTEAM_FULL.NAME","Use case: Filter a report of Resources to include only the Resources that are assigned to the user-selected Role Team.","Parameter: Role","Identifier: p_p6_role_id","Details: Select a Role.","P6: Provides a list populated with all the Roles the user has access to view.","Return value: The short name of the Role (unique).","Maps to field: ROLL_FULL.ID","Use case: Filter a report of Resources to include only the Resources that have the user-selected Role.","Parameter: Timesheet Period","Identifier: p_timesheet_period_start and p_timesheet_period_end","Details: This parameter consists of two parameters on the report in Oracle Analytics Publisher, but is represented by a single row in parameter list for P6. The user will select a timesheet period, and it will set the Start Date to p_timesheet_period_start and the End Date to p_timesheet_period_end.","P6: Drop down menu of the Timesheet Periods in the database. Selecting a Timesheet Period will return the Start Date and End Date in the parameters.","Return value: The Start Date and End Date of the Timesheet Period selected by the user.","Maps to field: N/A","Use case: Filter a report to look for a date between two dates of a Timesheet Period. Instead of adding two date parameters and making the user manually enter the Start and End of the period, the user can use a drop down with the Timesheet Periods in the database. ","Parameter: User","Identifier: p_p6_user_id","Details: Select a P6 EPPM user name.","P6: Provides a list populated with the P6 users that the logged-in user has access to view.","Return value: The user name (unique).","Maps to field: USERS_FULL.NAME","Dynamic Parameters","47008.htm#o47010");
Page[39]=new Array("In Oracle Analytics Publisher, when you create a parameter, a field Data Type allows the following options: String, Integer, Boolean, Float. The default type is String, and you should use it for all the supported enumeration and dynamic parameters. For primitive parameters, select the appropriate option for the parameter that you are configuring.","Type: Date","Editor: P6 will use the date picker to select the date.","Return: The date string in the format entered in Oracle Analytics Publisher.","Type: Boolean","Editor: Will use a check box editor.","Return: Either true (selected) or false (cleared).","Type: Integer","Editor: Will use a default text box without validation.","Return: The text entered in the box.","Type: Float","Editor: Will use a default text box without validation. ","Return: The text entered in the box.","Primitive Parameters","47011.htm");
Page[40]=new Array("If you need a supported parameter to return a comma separated list of values for an IN clause in the data template, do the following: ","In Oracle Analytics Publisher, set the parameter type to Menu. This will allow you to link it to a list. ","Create a hard coded list or a query to get the possible values for the parameter. ","See examples of this in Oracle Analytics Publisher's pre-packaged reports. ","Select the list of values you just created for the parameter.","Check the Multiple Selection option for the parameter. ","If a parameter allows for multiple selection, P6 will allow selecting multiple values from the list or allow users to continue to assign values without closing the list. Values will have commas to separate parameters when the return value appears.","Allowing for Multiple Values Returned via a List","47012.htm");
var PageCount=41;


/*
Date: 12/11/2025 7:39 PM
Source: EPPM_25_dev
BookID: 50840
PubProduct: PRIMAVERA_EPPM
BookTitle: Oracle Analytics Publisher Configuration Guide for On-Premises
Version: Version 25
Lang:	en
*/
	var PageLength=Page.length;
	var Result = "";
	var ResultTemp = "";
	var ResultFound = "";
	var ResultTitleOnly = [];
	var ResultTitleAndContent = [];
	var ResultInContent = [];
	var ResultInContentTemp = [];

	var ResultCombinedTemp = [];
	var ResultCombined = [];

	var arrayIndex = 0;
	var NrRes = 0;
	var j = 0;
	var i = 0;
	var k = 0;
	var d = 0;
	var maxItems = 1000;
	var heading = 0;
	var WordPos = -1;
	var WordPosHeading = -1;
	var WordPosContentText = -1;
	var FoundWord = "";
	var FoundWordHead = "";
	var SearchInHeadingOnly = 0;
	var isChecked;
	var size = 10;
	var resGroupCounter = 0;
	var shown = "shown";
	var checkBoxInHeading;
	var searchFlag = 0;
	var DivResult;
	var SearchWord;

if (SearchText && SearchText.length >= 1) {
		SearchWord = SearchText.replace(/\+/g, " ").replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;");
		searchFlag = 1;
	} else {
		SearchWord = "";
		searchFlag = 0;
	}
	

	if (searchFlag === 1) {
		Result = "";

		// checkBoxInHeading = document.getElementById("inHeading");
		if (inHeading) {

			isChecked = true;
		} else {

			isChecked = false;
		}

		if (SearchWord && SearchWord.length >= 1) {
			if (isChecked) {
				SearchInHeadingOnly = 1;
			} else {
				SearchInHeadingOnly = 0;
			}
			SearchWord = SearchWord.toLowerCase();
			window.status = "Searching, please wait...";
			for (j = 0; j < PageLength; j++) {
				k = Page[j].length - 1;
				for (i = 0; i < k; i++) {

					heading = k - 1;

					if (SearchInHeadingOnly === 1) {
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPosHeading > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);

							NrRes++;
							ResultTemp = "<li>";
							ResultTemp += "<span>";
							ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							ResultTitleOnly[arrayIndex] = ResultTemp;
							arrayIndex++;

							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}
					} else if (SearchInHeadingOnly === 0) {
						WordPos = Page[j][i].toLowerCase().indexOf(SearchWord);
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPos > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							NrRes++;
							ResultTemp += "<li>";
							ResultTemp += "<span>";
							if (WordPosHeading > -1) {
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";
							} else {
								// found word is not in the head
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading] + "</a><br/>\n";

							}
							if (i < k - 1) {
								WordPosContentText = Page[j][i].toLowerCase().indexOf(SearchWord);

								if (Page[j][i].length > 300 && (WordPosContentText > -1)) {

									if (WordPosContentText > 75) {
										ResultInContentTemp.push("..." + Page[j][i].substr(WordPosContentText - 75, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");
									} else {
										ResultInContentTemp.push("..." + Page[j][i].substr(0, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");

									}

								} else if (WordPosContentText > -1) {

									ResultInContentTemp.push(Page[j][i].replace(FoundWord, FoundWord.bold()));

								}
							}

							ResultTemp += ResultInContentTemp.join("");

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							if (WordPosHeading > -1) {
								ResultTitleAndContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							} else {
								ResultInContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							}

							ResultInContentTemp.length = 0;
							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}

					}
				}
			}

			ResultTitleOnly = ResultTitleOnly.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultTitleAndContent = ResultTitleAndContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultInContent = ResultInContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			ResultCombinedTemp = ResultTitleOnly.concat(ResultTitleAndContent, ResultInContent);

			ResultCombinedTemp = ResultCombinedTemp.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			for (d = 0; d < ResultCombinedTemp.length; d += size) {
				resGroupCounter++
				ResultCombined.push("<div id=" + "'" + "resGroup_" + resGroupCounter + "'" + " class=" + "'" + "resGroup " + shown + "'" + ">" + "<ol class='searchResults'>" + ResultCombinedTemp.slice(d, d + size).join("") + "</ol></div>");
				shown = "notshown";
			}

			ResultFound = ResultCombined.join("");

Result += "<div id='searchDetailsDiv'>";
			Result += "<p class='searchDetails'>Your Search Found&nbsp;" + NrRes + "&nbsp;items.&nbsp;";
			Result += "</p></div>";
			
			Result += "<div class='searchResultsDiv'>";
			Result += "<div id='resultsCollection' class='searchResults'>";
			Result += ResultFound;
			Result += "</div>";
			Result += "</div>";
			Result += "<div class='searchPaging'>";

			Result += '<hr />';

			Result += '<p class="bodytext"><a class="disabledAnchor" id="pBack" onclick="turnPage(\'backPage\')" href="#pBack">Back</a>&nbsp; | &nbsp;';
			
			if (resGroupCounter && resGroupCounter > 1) {
				Result += '<a id="pNext" onclick="turnPage(\'nextPage\')" href="#pNext">Next</a>';
			} else {
				Result += '<a id="pNext"  class="disabledAnchor" href="#pNext">Next</a>';
			}
			Result += '</p>\n';
			Result += '<div id="pagenofn"><p class="bodytext">Page <span id="pagen">1</span> of ' + resGroupCounter + '</p></div>';

			Result += "</div>";
			
			
		}

		DivResult = document.getElementById("s_anchor");
		if (Result && DivResult) {

			//myDivResult.append(Result);
			DivResult.innerHTML = Result;
			

		}
		window.status = "";
		
		

	}
	}())
}
