'use strict';
function search(SearchText, inHeading) {
(function () {
var Page = [];

/* Generated with Author-it 23.4.1.30004  12/11/2025 7:40:38 PM */
Page[0]=new Array("Title and Copyright Information","Copyright  1999, 2025, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information","46576.htm");
Page[1]=new Array("Scope","Integrate a content repository with P6 to make it easier to catalog, access, search, and reuse documentation.","This guide describes how to:","Configure Oracle Webcenter Content Core Capabilities (WCCC), Oracle Database, Microsoft SharePoint or any CMIS-compliant content repository for integration with P6. Refer to Tested Configurations for a complete list of the content repositories P6 EPPM supports.","Set your content repository settings in the Primavera P6 Administrator to connect your content repository to P6.","Note","The SharePoint connector has been removed from version 16.1 and later. New SharePoint users should configure SharePoint with a CMIS-compliant content repository, and then configure P6 EPPM to the CMIS-compliant content repository. ","Do not reconfigure SharePoint with a CMIS-compliant content repository if you previously configured your SharePoint connection using the Primavera P6 Administrator and SharePoint connector. Reconfiguring SharePoint with a CMIS repository will prevent previously stored documents from being visible. For more information, refer to documentation from Version 16.","Audience","System administrators should use this guide.","Using This Guide","This guide assumes you have installed P6 and its supporting applications. For more information, see the P6 EPPM Installation and Configuration Guide.","About This Guide","53858.htm");
Page[2]=new Array("P6 EPPM offers two content repository authentication modes. You can configure authentication for either single user authentication or multiple user authentication. In single user authentication mode, all P6 EPPM users access the repository using a single administrator user login that is set during repository configuration. In multiple user authentication mode,&nbsp;each P6 EPPM user is authenticated based on their individual login.","Single User authentication mode is useful when you want users to have full access to the content repository through P6 EPPM without having to maintain an equivalent list of users for both P6 EPPM and the repository. This allows a repository administrator to maintain one set of credentials for the repository without having to share those credentials with all users. Single user authentication is also useful for quickly setting up test repositories that testers can access with ease.","Multiple User authentication mode is the default mode. Multiple user authentication mode provides increased security by restricting content repository access on an individual user basis. Because it uses native auditing fields it also allows a clear audit of who has created and modified files.","Note","When using multiple user authentication mode,&nbsp;you should disable for the Oracle content repository Guest Access. If you leave Guest Access enabled and the guest user is not part of the P6 EPPM security group, that user will not be able to access P6 repository functionality.","If you are using the Oracle Database as your content repository, you can only use multiple user.","See the P6 EPPM Application Administration Guide for more information about Single User and Multiple User settings.","About Content Repository Authentication Modes","14398.htm");
Page[3]=new Array("If you are installing P6 and the content repository for the first time, follow the steps in this section.","If you are upgrading from a previous version of P6 and need to update your content repository to the latest supported version, you need to follow the steps in Upgrading the Content Repository.","Before you configure your content repository, you need to decide which authentication mode to use. Refer to the documentation included with the content repository application for detailed instructions on how to complete the guidelines in this section.","Note When P6 is configured with a content repository, it develops a dependency on that content repository. After you configure your content repository, if dependency is broken (for example, starting P6 when the content repository is not running), the content repository features will fail until the P6 Server is restarted. ","Configuring the Content Repository for P6","7243.htm");
Page[4]=new Array("Depending on your organization, you can choose to use existing configurations or your own naming conventions when configuring Oracle Webcenter Content Core Capabilities (WCCC). Refer to the documentation included with WCCC for detailed instructions on how to complete the guidelines in this section. See the P6 EPPM Tested Configurations document for information on supported versions.","These instructions contain information only on configuring Oracle Webcenter Content Core Capabilities to work with P6. They do not include information on installing WCCC. For WCCC installation instructions, see the documentation included with Oracle WCCC. For more information on configuring Oracle Webcenter Core Capablities, consult the following Knowledge Base article on integrating WCCC with P6: How to Configure Local or External Users for Webcenter Content Core Capabilities (WCCC) When Integrating With P6 EPPM (KB696872).","Configuring Oracle Webcenter Content Core Capabilities to Work with P6","91749.htm");
Page[5]=new Array("The Intradoc Server Port is used by P6 to communicate with WCCC. When this is enabled, a security filter list which includes the IP address of the P6 application server is required to communicate to the Content Server through the Intradoc Server Port. The security filter list must be defined because it is a trusted connection. If you are accessing WebContent Center for the first time, you must configure the Incoming Socket Connection Address Security Filter and Server Socket Port. ","To configure the Incoming Socket Connection Address Security Filter and Server Socket Port:","Log in to WebCenter Content (http://&lt;host&gt;:&lt;port&gt;/cs) as an administrator. The default is weblogic.","Enter or edit the following configuration values:","In Incoming Socket Connection Address Security Filter, enter the server IP address of the P6 application server. ","Note Separate multiple IP addresses using a pipe symbol or |. For example, 127.0.0.1|127.0.0.2.","In Server Socket Port, enter an unused port number for the Content Server. For example, 4444.","Apply the changes.","Restart the WCCC managed server for changes to take effect.","Note If this is not the first time you have installed WCCC, you must confirm or modify the server configuration Incoming Socket Connection Address Security Filter and Server Socket Port values. You can modify the values through Enterprise Manager or with the configuration file (config.cfg) using the following procedures:","Modifying the Server Configuration through Enterprise Manager","Modifying the Server Configuration using the Configuration File","Configuring an Intradoc Server Port in WCCC","91726.htm");
Page[6]=new Array("To modify the server configuration through Enterprise Manager:","Connect to Enterprise Manager Fusion Middleware Control (http://&lt;server&gt;:&lt;port&gt;/em).","Log in as a domain administrative user. For example, weblogic.","In the navigation tree, expand WebCenter, Content, Content Server.","Select the Content Server instance name (for example, Oracle Content Server (WCCC_server1)).","Use the WCCC menu to select Configuration Pages, Internet Configuration.","In the Server Configuration section, in the IP Address Filter field, enter a list of IP addresses that can be used to access the server. ","Note  Separate multiple IP addresses or machine name entries using a pipe symbol or |. For example, 127.0.0.1|127.0.0.2.","In the Intradoc Server Port field, enter a server port number.","Apply the changes.","Restart the WCCC managed server for changes to take effect.","Modifying the Server Configuration through Enterprise Manager","91751.htm");
Page[7]=new Array("To edit the files in the server:","Go to &lt;WCCC_Home&gt;\\ucm\\cs\\config. WCCC_Home is the location where you installed WCCC. The WCCC_Home path is \\Oracle\\Middleware\\user_projects\\domains\\$domain_name by default.","Edit the config.cfg file.","Find the SocketHostAddressSecurityFilter line and add the list of IP addresses that can be used to access the server to the end of the line. ","Note  Separate multiple IP addresses or machine name entries using a pipe symbol or |.  For example, 127.0.0.1|127.0.0.2.","Find the IntradocServerPort line and enter a server port number. For example, 4444.","Save the changes.","Restart the WCCC managed server for changes to take effect.","Modifying the Server Configuration using the Configuration File","91752.htm");
Page[8]=new Array("The Framework folder interface is not enabled by default. See the WCCC documentation for more information.","To enable the Framework Folders component:","Log in to WebCenter Content (http://&lt;host&gt;:&lt;port&gt;/cs) as an administrator.","On the Main Menu, choose Administration, Admin Server, Component Manager.","On the Component Manager page, select the FrameworkFolders option.","Click Update.","Restart the WCCC managed server for changes to take effect.","Enabling Framework Folders in WCCC","91727.htm");
Page[9]=new Array("To maintain your WCCC repository, create a P6 Security Group in WCCC and grant the appropriate rights to P6 EPPM users. Consider the following:","P6 user names must match the WCCC user names, unless you are using Single User for the Authentication Mode.","Note Single User Authentication Mode will log all P6 users into WCCC using the administrator user or as specified in the Database/Instance/Content Repository&nbsp;setting in P6 Admin Settings. ","All P6 EPPM-related WCCC user names must have corresponding assignments to WCCC Roles and Users. For a quick setup, you can create one P6 EPPM-specific Role to map to users with full privileges (read, write, delete, admin).","All P6 EPPM-related WCCC user names must have access to the P6 Security Group, either directly or through a role.","When you are creating users in WCCC for integrating with P6, consider the following:","If you are using Multiple User Authentication Mode when configuring P6:","You must create a WCCC user for every P6 EPPM user, and the user name created must match the P6 EPPM user.","You must assign the user to a role mapped to the security group associated with the P6 Framework folder and must have the right to read, write, and delete.","You must create an administrative user in WCCC. The user name does not have to match a P6 user.","You must assign the administrative user to a role mapped to the Security Group associated with the P6 folder. The administrator must have read, write, delete, and admin rights within the Security Group.","If you are using Single User Authentication Mode when configuring P6:","You must create an administrative user in WCCC. The user name does not have to match that of a P6 EPPM user.","You must assign the administrative user to a role mapped to the Security Group associated with the P6 folder. The administrator must have read, write, delete, and admin rights within the Security Group.","(Optional)&nbsp;If you enabled Security Accounts, create a P6 Security Account. Depending on your organization, you might need to set up a Security Account for performance and storage reasons. Security considerations include the following:","P6 EPPM user names must match the WCCC user names, unless using Single User for the Authentication Mode.","All P6-related WCCC user names must have corresponding WCCC Roles and Users.","All P6-related WCCC user names must have access to the P6 Security Account.","Creating a P6 Security Group in WCCC","91734.htm");
Page[10]=new Array("To create a local P6 Security Group and administrative user:","Log in to WebCenter Content (http://&lt;host&gt;:&lt;port&gt;/cs) as an administrator.","Expand Administration, and select Admin Applets.","Select User Admin.","In the User Admin dialog box, select Security, Permission by Group.","Click Add Group.","Enter a Group Name and description.","Click OK.","Close the Permission by Group dialog box.","Select Security, Permission by Role.","Click Add New Role.","Enter a Role Name and Display Name.","Click OK.","Select newly created role and click Edit applet Rights.","Grant all rights to the administrative user.","Click OK.","In the Groups/Rights section, select the newly created group.","Click Edit Permissions.","Grant all permissions to the group.","Click OK.","Close the Permission by Role dialog box. ","In the User Admin dialog, click Add.","Set Authorization type to Local.","Click OK.","Provide user details. ","Navigate to the Roles tab.","Click Add Role.","Add the newly created role. ","Click OK.","Close the User Admin dialog box.","Creating a Local P6 Security Group in WCCC","91965.htm");
Page[11]=new Array("You might choose to create external security accounts for WCCC. For instructions on creating external security groups, see:  How to Configure Local or External Users for Webcenter Content Core Capabilities (WCCC) When Integrating With P6 EPPM (KB696872).","Creating an External P6 Security Group in WCCC","91966.htm");
Page[12]=new Array("(Optional) You can create document types for P6 documents in WCCC. ","Log in to WebCenter Content (http://&lt;host&gt;:&lt;port&gt;/cs) as an administrator.","Expand Administration and select Admin Applets.","Select Configuration Manager.","In the Configuration Manager, select Options, Content Types.","Create a new content type for P6 Documents.","Apply the changes.","Restart the WCCC managed server for changes to take effect.","Note","Document Type as Document is the default document type in a WCCC repository.","Creating Document Types for P6 Documents in WCCC","91735.htm");
Page[13]=new Array("Create a P6 documents home folder on the WCCC server by adding a unique path to the root folder.","Log in to WebCenter Content (http://&lt;host&gt;:&lt;port&gt;/cs) as an administrator.","Expand Browse Content.","Select Folders.","Select Add.","Enter a folder name. For example, P6EPPM","Select Show Advanced Options.","Select the security group created for P6.","Apply the changes.","Creating a P6 Documents Home Folder on the WCCC Server","91736.htm");
Page[14]=new Array("From the Configuration Manager applet, create the following metadata text fields in WCCC for P6:","Log in to WebCenter Content (http://&lt;host&gt;:&lt;port&gt;/cs) as an administrator.","Expand Administration and select Admin Applets.","Select Configuration Manager.","In the Configuration Manager, select the Information Fields tab.","Create the following information fields as specified (including case):","PrmUserId","PrmProjectId","PrmWorkgroupId","PrmWorkflowId","PrmWorkflowStatus","PrmWorkflowAction","PrmSecurityPolicy","PrmTemplate","PrmCheckedOutUserId","PrmCheckedOutDate","PrmLocalFilePath (set Type to Long Text)","PrmAuthorId","Note Using &quot;Prm&quot; as a prefix is optional. You can use any prefix. If you do not use a prefix, ensure that none of the P6 metadata fields conflict with existing metadata fields.","Select Update Database Design to commit the changes.","Restart the WCCC managed server for changes to take effect.","Creating Metadata Text Fields in WCCC","91737.htm");
Page[15]=new Array("To configure WCCC settings for the Primavera P6 Administrator:","Note Ensure the settings you entered in when you configured the content repository match the settings you enter below.","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar select Database.","Select your Instance from the drop-down list.","Expand Content Repository.","In the Type field, select OracleWCCC.","In the Maximum document size field, enter the maximum size in KB for documents that can be uploaded to P6. The default is 10240 KB. Enter a value between 0 and 1048576.","In the Connection Maintenance Interval field enter the frequency at which the connection to the content repository is validated. The default is 10 minutes. Enter a value between 1 second and 24 days.","In the Oracle Webcenter Content Core Capabilities area","In the Host field, enter the machine name or IP address of the content repository server.","In the Port field, enter the IntradocServerPort number of the content repository server. By default, this is 4444.","Go to WCCC_Home\\ucm\\cs\\config\\.","Edit the config.cfg file.","Find the IntradocServerPort line, which contains the port number.","In the Oracle Home field, enter the location of the framework folder.","For the framework folder, use the following format:","/&lt;FolderName&gt;","For example:","/P6EPPM","In the Oracle Security Group field, enter the name of the Security Group assigned to the document folder created in WebCenter for P6 EPPM documents, as specified when you configured the content repository. ","For Example:","Enter Oracle Security Group as Public.","In the Oracle Security Account field, enter the name of the Security Account for P6 EPPM documents, as specified when you configured the content repository. ","If you did not enable security accounts, leave this setting blank.","In the Oracle Document Type field, enter the document type for P6 EPPM documents, which can be either an existing document type or a new one, as specified when you configured the content repository. ","For example:","Enter the Document Type as Document.","In the Metadata Prefix field, enter the prefix added to P6 EPPM metadata fields, as specified when you configured the content repository. For example, Prm.","In the Admin User field, enter the user name with administrative privileges, as specified when you configured the content repository. This setting is required.","From the Authentication Mode drop-down menu, select the authentication mode used to access the content repository server. P6 EPPM users cannot access content repository functions if you do not configure this setting.","If you choose &quot;Multiple User&quot;, all P6 EPPM content repository-related user names must match the equivalent content repository user name. For example, a P6 EPPM user named &quot;Joe&quot; must have an equivalent user named &quot;Joe&quot; in the content repository. ","If you choose &quot;Single User&quot;, the administrative user specified in the setting above must have access to all appropriate SharePoint libraries to browse to documents outside of the P6 EPPM home folder.","Restart the P6 Server.","Configuring WCCC settings for the Primavera P6 Administrator","91738.htm");
Page[16]=new Array("Content Management Interoperability Services (CMIS) is a standard that content repositories have agreed to adhere to so that a single document connector can be used to connect to any CMIS-compliant repository. ","You can connect any CMIS-compliant content repository, including SharePoint, to P6. The repository must be 100% CMIS-compliant to utilize all the features of P6 document functionality.","Configuring CMIS-Compliant Content Repository for P6","65455.htm");
Page[17]=new Array("You can use Microsoft SharePoint with P6 by integrating SharePoint with your CMIS-compliant content repository and then configuring your CMIS-compliant content repository with P6.","To configure your CMIS-compliant content repository:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectDatabase.","Select your Instance from the drop-down list.","Expand Content Repository.","In the Type field, select CMIS.","Note Changes to these settings require you to restart the P6 server.","In the Maximum document size field, enter the maximum size in KB for documents that can be uploaded to P6. The default is 10240 KB. Enter a value between 0 and 1048576.","Note To block specific document types, enter a comma separated list of file extensions in the Invalid Document Types field in the Integration &amp; Allow Lists tab of the Application Settings in P6. Oracle recommends at least blocking the following document types: .exe,.com,.bat,.cmd,.vbs,.js,.msi.","In the SharePoint area:","In the Login Name field, enter the user name for your content repository.","In the Password field, enter the password for the user name you entered above.","In the Authentication Mode field, enter authentication mode used to access the content repository server. P6 EPPM users cannot access content repository functions if you do not configure this setting.","If you choose &quot;Multiple User&quot;, all P6 EPPM content repository-related user names must match the equivalent content repository user name. For example, a P6 EPPM user named &quot;Joe&quot; must have an equivalent user named &quot;Joe&quot; in the content repository.","If you choose &quot;Single User&quot;, the administrative user specified in the setting above must have access to all appropriate Security Groups to browse to documents outside of the P6 EPPM home folder.","In the Repository Name field, enter the name for your content repository.","Note For SharePoint, enter the document library name you created for P6. ","In the Document Home field, enter the location of the folder in the document library where you want to store P6 documents.","In the Web Service URL field, enter the URL for your web services home.","This is Web Service Endpoint with format http://&lt;sharepoint host&gt;/sites/&lt;site name&gt;/_vti_bin/cmissoapwsdl.aspx","Restart the P6 server.","Configuring CMIS-Compliant Content Repository in the Database Instance Settings","65454.htm");
Page[18]=new Array("Configuring AutoVue without VueLink is the native AutoVue implementation. To use this implementation, you will configure a single AutoVue server that is common across all database instances.","Note","When you configure AutoVue without VueLink, you are creating global AutoVue settings. These settings override any individual settings you may have created to configure AutoVue with VueLink.","When upgrading to Version 25 from 15 R2 or earlier, AutoVue connection details are lost and must be entered again.","To configure AutoVue without VueLink, complete the following steps:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar select Document Viewing.","Note Changes to these settings require you to restart the P6 server.","Select Enable. The default value is unselected.","Note","SSL mode does not work when the Enable option is set to false.","By default, the ESAPI resources that come with VueLink is used. You can change the location of the resource files by using -Dorg.owasp.espai.resources JAVA_OPTIONS in the WebLogic application server or in the setDomainEnv script.","By default, dmsstamp.ini and the oracle sample stamp from VueLink is used to create markup. You can change the location of the dmsstamp.ini file, which contains the stampfile location, using -Dexternal.csi.intellistamp.def.location JAVA_OPTIONS in the WebLogic application server or in the setDomainEnv script. ","If using Oracle Access Manager with your P6 EPPM deployment, add following context roots to the Oracle Access Manager exclusion list:<br />/p6/VueServlet/**<br />/p6/jvueDMS/**<br />/p6/P6AutoVueJNLPLauncher/**<br />/p6/av_cert.pem<br />For more information about protecting your resources using Oracle Access Manager's exclusion list, see the &quot;Protecting Your Resources&quot; chapter in the Oracle Access Manager Configuration Guide.","Select Enable SSL if your AutoVue server is enabled with SSL to allow communication via HTTPS.","In the Host Name field, enter the hostname for the server where AutoVue is installed. ","Note Do not put a / at the end of the URL.","In the Host Port field, enter the port for the server where AutoVue is installed. The default port is 5099.","Restart the P6 server.","Configuring AutoVue without VueLink","94037.htm");
Page[19]=new Array("Outside In converts documents uploaded to your content repository into a raster-image file. ","To configure Outside In:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectDocument Viewing.","In the Fonts Directory field, enter the full path to your operating system-specific fonts folder. For example, C:\\Windows\\Fonts.","Note You cannot convert documents in languages that do not have a compatible font installed in the Fonts Directory. Before you convert these documents you must install the appropriate language font.","In the Images Directory field, enter the full path to your Outside In images folder. For example, P6EPPM_HOME\\P6\\outsidein\\ImageExport\\Images.","Navigate to P6EPPM_HOME\\P6.","Run outsideInConfig.cmd or outsideInConfig.sh (based on your operating system).","Configuring Outside In","96417.htm");
Page[20]=new Array("You can use Oracle database as a content repository with your P6 EPPM installation.","To configure the Oracle database as your content repository:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectDatabase.","Select your Instance from the drop-down list.","Expand Content Repository.","Note Changes to these settings require you to restart the P6 server.","In the Type field, select Oracle Database.","This option will save documents and associated information in the P6 database schema. This option is only applicable if you are using an Oracle database on-premises or an Oracle Autonomous Database.","In the Maximum document size field, enter the maximum size in KB for documents that can be uploaded to P6. The default is 10240 KB. Enter a value between 0 and 1048576.","Note To block specific document types, enter a comma separated list of file extensions in the Invalid Document Types field in the Integration &amp; Allow Lists tab of the Application Settings in P6. Oracle recommends at least blocking the following document types: .exe,.com,.bat,.cmd,.vbs,.js,.msi.","In the Connection Maintenance Interval field enter the frequency at which the connection to the content repository is validated. The default is 10 minutes. Enter a value between 1 second and 24 days.","Note Ensure that the Enable Cloud Storage field is set to false.","Restart the P6 server.","Configuring the Oracle Database Content Repository","84126.htm");
Page[21]=new Array("If you upgraded to P6 or the content repository, you need to do one of the following:","If you upgraded from a previous P6 version, see Migrating the Content Repository if Upgrading P6.","If you upgraded UCM to 11.1.1.9 or higher, see Upgrading from Previous Universal Content Management Version to WCCC.","Upgrading the Content Repository","78226.htm");
Page[22]=new Array("Run the migration utility before connecting the upgraded environment back to the Content Repository. Running the migration utility will ensure all project folder names in the Content Repository change from Database IDs to their Project ID field (from P6).","If you upgraded P6 from a previous version, you must:","Go to the P6EPPM_Home/p6 folder.","Run migrationtool.cmd or migrationtool.sh (based on your operating system).","Migrating the Content Repository if Upgrading","78221.htm");
Page[23]=new Array("If you were using a previous version of Universal Content Management (UCM), you will notice many changes when you upgrade to a supported version of WCCC. To maintain your documents from P6, you should ensure that your framework folder has updated correctly. To do this, you should:","Shutdown all the P6 applications connecting to your current content repository. ","Run the migration utility.","Go to the P6EPPM_Home/p6 folder.","Run migrationtool.cmd or migrationtool.sh (based on your operating system).","Note","Users is a restricted folder name for folders within the folder structure in supported versions of WCCC.","Note the folder database converts project IDs to project short names.","Upgrade a previous version of UCM or WCCC to a supported version of WCCC or higher using the upgrade guide provided with the WCCC media packs.","Enable the framework folders components. ","After the migration:","Locate the migration_run**** folder that was created.","Move all the folders and documents under this folder to the Content repository home folder that you want to use.","Ensure you select inhibit propagation to ensure proper movement of documents and folders.","After the move completes, you can start using the documents with the correct content repository home.","Tip","Have 4-6 GB open memory space.","Don't propagate changes when given the option.","Upgrading from Previous Universal Content Management Version to WCCC","65745.htm");
Page[24]=new Array("If you started using the document functionality of the P6 application without running migration utility provided with P6 on an upgraded environment, where you were using a content repository for managing documents, you will be unable to use the documents that were earlier associated with any Projects or Users.","Troubleshooting","79887.htm");
var PageCount=25;


/*
Date: 12/11/2025 7:40 PM
Source: EPPM_25_dev
BookID: 50762
PubProduct: PRIMAVERA_EPPM
BookTitle: Content Repository Configuration Guide for On-Premises
Version: Version 25
Lang:	en
*/
	var PageLength=Page.length;
	var Result = "";
	var ResultTemp = "";
	var ResultFound = "";
	var ResultTitleOnly = [];
	var ResultTitleAndContent = [];
	var ResultInContent = [];
	var ResultInContentTemp = [];

	var ResultCombinedTemp = [];
	var ResultCombined = [];

	var arrayIndex = 0;
	var NrRes = 0;
	var j = 0;
	var i = 0;
	var k = 0;
	var d = 0;
	var maxItems = 1000;
	var heading = 0;
	var WordPos = -1;
	var WordPosHeading = -1;
	var WordPosContentText = -1;
	var FoundWord = "";
	var FoundWordHead = "";
	var SearchInHeadingOnly = 0;
	var isChecked;
	var size = 10;
	var resGroupCounter = 0;
	var shown = "shown";
	var checkBoxInHeading;
	var searchFlag = 0;
	var DivResult;
	var SearchWord;

if (SearchText && SearchText.length >= 1) {
		SearchWord = SearchText.replace(/\+/g, " ").replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;");
		searchFlag = 1;
	} else {
		SearchWord = "";
		searchFlag = 0;
	}
	

	if (searchFlag === 1) {
		Result = "";

		// checkBoxInHeading = document.getElementById("inHeading");
		if (inHeading) {

			isChecked = true;
		} else {

			isChecked = false;
		}

		if (SearchWord && SearchWord.length >= 1) {
			if (isChecked) {
				SearchInHeadingOnly = 1;
			} else {
				SearchInHeadingOnly = 0;
			}
			SearchWord = SearchWord.toLowerCase();
			window.status = "Searching, please wait...";
			for (j = 0; j < PageLength; j++) {
				k = Page[j].length - 1;
				for (i = 0; i < k; i++) {

					heading = k - 1;

					if (SearchInHeadingOnly === 1) {
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPosHeading > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);

							NrRes++;
							ResultTemp = "<li>";
							ResultTemp += "<span>";
							ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							ResultTitleOnly[arrayIndex] = ResultTemp;
							arrayIndex++;

							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}
					} else if (SearchInHeadingOnly === 0) {
						WordPos = Page[j][i].toLowerCase().indexOf(SearchWord);
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPos > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							NrRes++;
							ResultTemp += "<li>";
							ResultTemp += "<span>";
							if (WordPosHeading > -1) {
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";
							} else {
								// found word is not in the head
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading] + "</a><br/>\n";

							}
							if (i < k - 1) {
								WordPosContentText = Page[j][i].toLowerCase().indexOf(SearchWord);

								if (Page[j][i].length > 300 && (WordPosContentText > -1)) {

									if (WordPosContentText > 75) {
										ResultInContentTemp.push("..." + Page[j][i].substr(WordPosContentText - 75, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");
									} else {
										ResultInContentTemp.push("..." + Page[j][i].substr(0, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");

									}

								} else if (WordPosContentText > -1) {

									ResultInContentTemp.push(Page[j][i].replace(FoundWord, FoundWord.bold()));

								}
							}

							ResultTemp += ResultInContentTemp.join("");

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							if (WordPosHeading > -1) {
								ResultTitleAndContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							} else {
								ResultInContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							}

							ResultInContentTemp.length = 0;
							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}

					}
				}
			}

			ResultTitleOnly = ResultTitleOnly.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultTitleAndContent = ResultTitleAndContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultInContent = ResultInContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			ResultCombinedTemp = ResultTitleOnly.concat(ResultTitleAndContent, ResultInContent);

			ResultCombinedTemp = ResultCombinedTemp.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			for (d = 0; d < ResultCombinedTemp.length; d += size) {
				resGroupCounter++
				ResultCombined.push("<div id=" + "'" + "resGroup_" + resGroupCounter + "'" + " class=" + "'" + "resGroup " + shown + "'" + ">" + "<ol class='searchResults'>" + ResultCombinedTemp.slice(d, d + size).join("") + "</ol></div>");
				shown = "notshown";
			}

			ResultFound = ResultCombined.join("");

Result += "<div id='searchDetailsDiv'>";
			Result += "<p class='searchDetails'>Your Search Found&nbsp;" + NrRes + "&nbsp;items.&nbsp;";
			Result += "</p></div>";
			
			Result += "<div class='searchResultsDiv'>";
			Result += "<div id='resultsCollection' class='searchResults'>";
			Result += ResultFound;
			Result += "</div>";
			Result += "</div>";
			Result += "<div class='searchPaging'>";

			Result += '<hr />';

			Result += '<p class="bodytext"><a class="disabledAnchor" id="pBack" onclick="turnPage(\'backPage\')" href="#pBack">Back</a>&nbsp; | &nbsp;';
			
			if (resGroupCounter && resGroupCounter > 1) {
				Result += '<a id="pNext" onclick="turnPage(\'nextPage\')" href="#pNext">Next</a>';
			} else {
				Result += '<a id="pNext"  class="disabledAnchor" href="#pNext">Next</a>';
			}
			Result += '</p>\n';
			Result += '<div id="pagenofn"><p class="bodytext">Page <span id="pagen">1</span> of ' + resGroupCounter + '</p></div>';

			Result += "</div>";
			
			
		}

		DivResult = document.getElementById("s_anchor");
		if (Result && DivResult) {

			//myDivResult.append(Result);
			DivResult.innerHTML = Result;
			

		}
		window.status = "";
		
		

	}
	}())
}
