'use strict';
function search(SearchText, inHeading) {
(function () {
var Page = [];

/* Generated with Author-it 23.4.1.30004  12/3/2025 5:52:54 PM */
Page[0]=new Array("Title and Copyright Information","Copyright  1999, 2025, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information","46576.htm");
Page[1]=new Array("Scope","This guide describes how to configure BPM for integration with P6. Additionally, this guide provides information on creating cluster environments for BPM and testing your BPM-P6 integration.","Audience","System administrators should use this guide.","Using This Guide","This guide assumes you have installed P6 and its supporting applications. For more information, see the P6 EPPM Installation and Configuration Guide.","About This Guide","94213.htm");
Page[2]=new Array("The Oracle Business Process Management (BPM) Suite provides an integrated environment for developing, administering, and using business applications centered around business processes. BPM supports BPM and Business Process Execution Language (BPEL) standards from modeling and implementation to run-time and monitoring.","P6 integrates with BPM which lets you initiate and manage workflows. You can use a sample project initiation workflow for P6 sample database.","You can expand your investment in BPM to include workflows representing more stages of your application, program, project, or product development life cycle from design-time and implementation to run-time and application management.","The Oracle BPM Suite enables you to:","Create and customize business processes, models, and standards using pre-defined components for web-based applications. ","Collaborate between process developers and process analysts.","Expand business process management to include flexible, unstructured processes.","Integrate your applications with Web Services.","Add dynamic tasks and support approval routing using declarative patterns and rules-driven flow determination.","Unify different stages of your development life cycle by addressing end-to-end requirements for developing process-based applications. Oracle BPM unifies the design, implementation, run time, and monitoring stages based on a Service-Oriented Architecture (SOA) infrastructure. This allows different personas to participate through all stages of the workflow life-cycle.","Oracle BPM Setup Tasks","49382.htm");
Page[3]=new Array("Before continuing, ensure the following required conditions have been addressed:","Note See the Tested Configurations document for information on supported versions.","On the domain where you will install P6 EPPM, configure WebLogic Middleware with Oracle Application Development Framework (Oracle ADF). This will ensure the P6 EPPM domain will have Oracle WSM Policy Manager and Oracle JRF modules, which you must have when integrating P6 EPPM with BPM.  To download the Oracle ADF, refer to the following link: http://www.oracle.com/technetwork/developer-tools/adf/downloads/index.html","Note  If you installed the Oracle Fusion Middleware SOA Suite to the same WebLogic Middleware home where you installed P6 EPPM, then the Oracle ADF is already available and you can skip this step.","Download the Oracle BPM Suite documentation from http://www.oracle.com/technetwork/middleware/soasuite/documentation/index.html. See Tested Configurations for the supported versions of BPM.","See http://www.oracle.com/technetwork/middleware/soasuite/downloads/index.html to accept a license agreement and download a BPM package.","Install Oracle BPM. See the BPM documentation at http://www.oracle.com/technetwork/middleware/soasuite/documentation/index.html to guide you. When you design and develop your own workflows in 12c, you will need JDeveloper with extensions or Oracle Business Process Composer for 12c.","Note You can use BPM with P6 EPPM.","Install and configure P6 EPPM. This includes having completed any licensing requirements and downloading any documentation for P6 EPPM, including P6 and P6 EPPM Web Services.","Make sure you have a working configuration of P6. The term P6 refers to the web application user interface for the main module in the P6 EPPM suite.","You must deploy the Oracle WSM Policy and JRF modules for P6 to work with BPM. If you use the P6 EPPM Configuration Wizard, you can use it to deploy the Oracle WSM Policy and JRF modules. You will have to have a WebLogic domain to deploy the policy and module. You can also deploy the Oracle WSM Policy and JRF modules manually in WebLogic if you choose not to use the configuration wizard to do so.","Note P6 EPPM Web Services and P6 (which includes Oracle WSM Policy manager and Oracle WSM JRF modules) can be on the same domain or separate domains. However, if OWSM is enabled for P6 EPPM Web Services, then BPM will not work with P6 .","Make sure you have installed P6 EPPM Web Services and ensure its authentication mode matches BPM's authentication mode. For example, Username Token Profile or SAML.","Note Cookie authentication is not currently supported at this time.","Configure both BPM and P6 to work together. See Integrating Oracle BPM 12c with P6 in this guide for steps.","To ensure the BPM functionality is available in P6, you must set up a username in BPM that matches an equivalent P6 username (only the username value must match; Passwords can be different between the environments).","You must assign the user in BPM the appropriate role to perform the functional requirements. Refer to Testing the Connection for P6, BPM, and Web Services.","Pre-Integration Requirements for BPM: Start Here","89465.htm");
Page[4]=new Array("To integrate Oracle BPM with P6, you must complete the following tasks in the specified order:","Modifying the P6 Environment for BPM","Configuring P6 to Connect to Oracle BPM","Integrating Oracle BPM with P6","89466.htm");
Page[5]=new Array("To configure BPM with P6:","Create a new directory on the host where P6 is running. For example, P6BPMConnector/P6 and P6BPMConnector/BPM.","In the P6 media pack Tools\\BPM Connector\\12c subfolder, locate the following file:","prm-bpm-connector-12c-v2.0.jar","Copy the connector file listed above to the P6BPMConnector/P6 folder you created. Determine the location of the BPM installation that you are using to integrate with P6. If you have multiple SOA Suite installations, ensure that you determine the location of the specific installation that you are integrating with P6.","Copy the following folders and their contents from your BPM installation to the P6BPMConnector/BPM folder you created.&nbsp;Their default locations are listed:","&lt;ORA_HOME&gt;\\soa\\soa\\modules\\oracle.bpm.client_11.1.1 ","&lt;ORA_HOME&gt;\\soa\\soa\\modules\\oracle.bpm.project_11.1.1 ","&lt;ORA_HOME&gt;\\soa\\soa\\modules\\oracle.bpm.runtime_11.1.1 ","Copy all the supporting jars from the BPM installation that you are using to integrate with P6 to the P6BPMConnector/BPM folder you created.&nbsp;Their default locations are listed:","&lt;Oracle_Home&gt;\\soa\\soa\\modules\\oracle.soa.fabric_11.x.x\\bpm-infra.jar","&lt;Oracle_Home&gt;\\soa\\soa\\modules\\oracle.soa.workflow_11.x.x\\bpm-services.jar","&lt;Oracle_Home&gt;\\soa\\soa\\modules\\oracle.soa.fabric_11.x.x\\fabric-runtime.jar","&lt;Oracle_Home&gt;\\oracle_common\\modules\\oracle.jmx_12.x.x\\jmxframework.jar","&lt;Oracle_Home&gt;\\oracle_common\\modules\\oracle.jmx_12.x.x\\jmxspi.jar","&lt;Oracle_Home&gt;\\soa\\bpm\\modules\\oracle.bpm.mgmt_11.x.x\\oracle.bpm.bpmn-em-tools.jar","&lt;Oracle_Home&gt;\\soa\\soa\\modules\\oracle.soa.mgmt_11.x.x\\soa-infra-mgmt.jar","&lt;Oracle_Home&gt;\\wlserver\\server\\lib\\wlclient.jar","&lt;Oracle_Home&gt;\\oracle_common\\modules\\oracle.xdk_12.x.x\\xml.jar","&lt;Oracle_Home&gt;\\oracle_common\\modules\\oracle.xdk_12.x.x\\xmlparserv2.jar","&lt;Oracle_Home&gt;\\soa\\soa\\modules\\oracle.soa.fabric_11.x.x\\tracking-api.jar","&lt;Oracle_Home&gt;\\soa\\soa\\modules\\oracle.rules_11.x.x\\rulesdk2.jar","Note","The jar files must be from the same BPM installation that will be integrated with P6.","Modifying the P6 Environment for BPM","89467.htm");
Page[6]=new Array("To connect P6 and BPM:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectDatabase/Instance[n]/BPM Settings.","In the Connector file location field, enter the full path (including the file name) where you copied the connector files.","For example:","c:/oracle/bpm&lt;release_level&gt;/eppmjars/prm-bpm-connector-12c-v1.0.jar or /home/oracle/bpm1213x/prm-bpm-connector-12c-v1.0.jar","In the BPM library path field, enter the path of the directory where you copied all the  jars.","Note If the above settings are incorrect or the BPM jar files are incomplete, you will be prompted with an error message when you try to configure the BPM. Verify that your settings and jar files are correct.","Right-click BPM Configuration, then select Configure to set options from the dialog box. If you receive an error message, check your values from the previous steps in this section. ","To configure P6 to use BPM, add the following settings:","Caution Do not put a forward slash / at the end of the URL. For example, it should read only http://&lt;host_name&gt;:&lt;port&gt;, and not http://&lt;host_name&gt;:&lt;port&gt;/.","In the bpm.user field, enter the BPM user with administrative access to BPM.","In the bpm.password field, enter the password for the user.","In the bpm.t3.url field, enter the T3 URL for your Oracle SOA configuration. For example: t3://&lt;host_name&gt;:&lt;port&gt;/soa-infra","In the bpm.security.realm field, enter the name of the security realm used by BPM.&nbsp;This is jazn.com by default.","In the bpm.soap.url field, enter the URL for the SOAP services. Usually this URL takes the form of http://&lt;host_name&gt;:&lt;port&gt;.","In the bpm.workspace.url field, enter an address in the form of http://&lt;host_name&gt;:&lt;port&gt; that indicates where the BPM Workspace application is hosted.","Note The host can be an IP address or a host name such as a machine name.","In the bpm.partition field, enter the name of the SOA partition containing the BPM composite applications you would like to use in P6.&nbsp;The default partition name is default.","Click OK and save changes. When the configuration is complete, you will see a BPM properties have been configured message. ","Restart the P6 application server.","Configuring P6 to Connect to Oracle BPM","89468.htm");
Page[7]=new Array("The sample workflow provided uses Username Token Authentication and does not implement the message protection options of Nonce, Creation Timestamp, or SSL encryption. For the sample workflow to work, you must set the following settings to false or P6 EPPM Web Services will reject the messages sent from BPM.","To verify you configured the sample workflow correctly set the following to false:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar select Web Services/Security/Authentication.","In the Mode field, select Username Token Profile.","Expand Web Services/Security/Authentication/Username Token Profile/Nonce and set Require Nonce to false.","Expand Web Services/Security/Authentication/Username Token Profile/Created and set Require Created to false.","Expand Web Services/Security/Message Protection:","Set Require Timestamp to false.","Set Require Digital Signatures for Incoming Messages to false.","Set Require Encryption for Incoming Messages to false.","Set Encrypt Response to false.","Verifying the Sample Workflow Configuration","88110.htm");
Page[8]=new Array("Follow the instructions in the following sections to create a cluster environment for BPM in WebLogic.","Creating a Cluster Environment for BPM in WebLogic","79521.htm");
Page[9]=new Array("Before you create a cluster:","Note See the Tested Configurations document for supported versions.","Install the Oracle MDS (Metadata Services) schema using the Repository Creation Unit (RCU) on a separate database instance.","Install Oracle ADF Runtime on the Middleware Home for all nodes where you configured P6 EPPM.","Create a cluster for BPM in WebLogic. Follow WebLogic's instructions to create a cluster. The following instructions will refer to the cluster as BPMCLUSTER_domain.","Prerequisites for Creating a Cluster for BPM in WebLogic","79522.htm");
Page[10]=new Array("To extend the WebLogic Domain:","Stop the P6 EPPM servers:","If you started the servers using Node Manager (for example, start_Primavera.bat), run stop_Primavera.bat to stop all running servers. ","If you started the servers using startWebLogic.cmd/startManagedWebLogic.cmd in Windows or startWebLogic.sh/startManagedWebLogic.sh in Unix, use the &quot;stop&quot; version for those files to stop the servers. ","Run the WebLogic Configuration Wizard.","In the Welcome&nbsp;window:","Select Extend an existing WebLogic domain.","Click Next. ","In the Select a WebLogic Domain Directory window:","Expand domains.","Select the BPM Cluster domain (for example, BPMCLUSTER_domain), which you must extend with policy manager.","Click Next.","In the Select Extension Source window:","Select Extend my domain automatically to support the following added products:.","Select Oracle WSM Policy Manager - 12.1.3.0 [oracle_common]. When you select this option, the wizard will automatically select Oracle JRF - 12.1.3.0 [oracle_common]. ","Click Next.","In the Configure JDBC Component Schema window:","Enter your MDS schema details. The MDS details are the DB configuration details where you installed the Oracle MDS schema.","Click Next. ","In the Test JDBC Component Schema window:","Select your schema.","Click Test Connections.","If the test is successful, click Next.","If the test fails, go back to the previous screen and ensure your credentials are correct.","In the Select Optional Configuration window:","Select Managed Servers, Clusters and Machines and Deployments and Services.","Click Next.","In the Configured Managed Servers window, do not make changes and click Next.","In the Configure Clusters window, do not make changes and click Next.","In the Assign Servers to Clusters window, do not make changes and click Next.","In the Configure Machines window, do not make changes and click Next. ","In the Assign Servers to Machines window, do not make changes and click Next.","In the Target Deployments to Clusters or Servers window: ","In the left pane, select Cluster. ","In the right pane under Applications, select wsm-pm. ","In the right pane under Library, select all options.","In the left pane, select another server.","In the right pane under Applications, select the application that corresponds to that server. For example, if you selected the P6 server, select P6 under Applications.","Clear all other options for that server.","Repeat these steps for each server.","In the left pane, select Cluster and select all the applications that belong in that cluster from the right pane. ","Click Next.","In the Target Services to Clusters or Servers window: ","In the left pane, select Cluster and select all options in the right pane.","In the left pane, select Cluster and clear all options in the right pane.","Click Next.","On the Configuration Summary screen:","Verify the configuration summary.","Click Extend.","When the extension is complete, click Done. ","Extending the WebLogic Domain to Create a New Cluster","79523.htm");
Page[11]=new Array("To finalize the extended schema for BPM:","Copy this extended domain to all node server machines that are part of the created cluster.","Set StartScriptEnabled to true:","Go to the Node Manager folder in the WebLogic home (for example, C:\\Oracle\\Middleware\\Oracle_Home\\user_projects\\&lt;P6 EPPM_Domain&gt;\\nodemanager)","Edit the nodemanager.properties file.\\","Set StartScriptEnabled = true.","Ensure that StartScriptName=startWebLogic.cmd or StartScriptName=startWebLogic.sh depending on your operating system.","Start the servers:","Run start_Primavera.bat/ start_Primavera.sh to start all the servers through node manager. ","To start the servers manually, run startWeblogic.cmd/startManagedWeblogic.cmd for Windows or startWeblogic.sh/startManagedWeblogic.sh for Unix. ","Finalizing the Extended Schema for BPM","79524.htm");
Page[12]=new Array("This section includes steps to to deploy and configure the P6ConfigValidator workflow, which you can use to test a web services call.","Testing the Connection for P6, BPM, and Web Services","78988.htm");
Page[13]=new Array("The configuration plan references the generic endpoint: p682ws:7011. The configuration plan also contains BPEL properties in the workflow to configure the target environment. In this workflow, these entries consist only of the P6 user name, password, and database instance to use when making the test Web Service call.","To prepare the configuration plan:","Unzip the files in the P6_&lt;release_level&gt;_Tools\\BPM Connector\\p6ConfigValidator 2.0 [12.1.3.0].zip folder from the Media Pack.","Edit the P6ConfigValidator_cfgplan.xml file.","Find the attribute &lt;replace /&gt; and change the following values:","Find &lt;property name=&quot;bpel.preference.p6userName&quot;&gt; and replace the P6 username value between the &quot;&lt;replace&gt; &lt;/replace&gt;&quot; elements with a P6 username from your environment. Oracle recommends using a user assigned to the Admin Superuser Global security profile.","Find &lt;property name=&quot;bpel.preference.p6password&quot;&gt; and replace the P6 password value between the &quot;&lt;replace&gt; &lt;/replace&gt;&quot; elements with the password of the user from above.","Find &lt;replace&gt;localhost:7011&lt;/replace&gt; and replace the value between the &quot;&lt;replace&gt; &lt;/replace&gt;&quot; elements with the hostname:port where you deployed P6 Web Services.","Save the changes made to the P6ConfigValidator_cfgplan.xml file and close the text editor.","Configuring WSDL Location and Service Endpoints","79087.htm");
Page[14]=new Array("To deploy the JAR for the SOA composite:","Login to Enterprise Manager on the WebLogic Server hosting SOA.","Expand SOA, soa-infra, server_name.","Right-click on the target soa-infra partition and select SOA Deployment, Deploy to This Partition....","Specify the location of the service archive file sca_P6ConfigValidator_rev1.0.jar and the edited configuration plan (P6ConfigValidator_cfgplan.xml) for this environment.","Click Next to confirm the remaining options for the target environment.","Deploy the JAR for the SOA composite.","Deploying the SOA Composite","79088.htm");
Page[15]=new Array("To deploy the P6ConfigUI.ear as a standard application deployment to the same server where the SOA is running:","Login to Enterprise Manager.","Expand WebLogic Domain, domain_name.","Right-click on the server name and select Application Deployment, Deploy.","Specify the location of P6ConfigUI.ear.","(optional) Specify the location of the deployment plan if needed.","Click Next to confirm the remaining options for the target environment.","Deploy P6ConfigUI.ear.","Deploy Client Application and Task UI Project","79091.htm");
Page[16]=new Array("To use this workflow, you need to assign a BPM role for the user to initiate the test and receive the confirmation the test was successful.","To assign the role:","Login to the BPM Workspace as a user with administrative rights.","Click Administration on the top right toolbar.","On the Organization Roles list, select P6ConfigValidator.TestConfig.","On the Details pane, make one or more BPM users or user groups a member of the TestConfig role. The BPM users or user groups assigned to the TestConfig role must match a P6 username for the workflow to be visible from P6.","Click Apply to save these changes.","Assigning the TestConfig Role to Users","79092.htm");
Page[17]=new Array("Use the BPM and P6 EPPM Web Services log viewers to troubleshoot problems if they arise and check for known issues with BPM.","Note As a general rule when troubleshooting workflow failures, first check the BPM diagnostics to determine at what point in the process the workflow failed. If the failure is related to retrieving data from P6, then you should check the P6 EPPM Web Services logs. Also be sure to check the P6 Help and other documentation for both P6 and BPM.","Troubleshooting and Known Issues for BPM","89502.htm");
Page[18]=new Array("When integrating P6 and BPM, you can use only English as the language. While both P6 and BPM both support localization, the API for integrating these two applications supports only English.","Known Issues","78589.htm");
Page[19]=new Array("The P6 EPPM Web Services uses different settings for logging errors and warnings than for logging SOAP requests and responses.","Checking the P6 EPPM Web Services Logs","54186.htm");
Page[20]=new Array("If logging is enabled and configured in Primavera P6 Administrator, P6 EPPM Web Services can output to the P6 log file.","Log settings in Primavera P6 Administrator can be set at one of four levels, each of which also incorporates all the messages logged by the previous logging level. The levels are, error, warn, info, and debug.","The output is recorded to a log file called P6WebAccess.html. The location of the log file is specified in BREBootStrap.xml located in your P6 EPPM home folder.","For more information, see the P6 EPPM System Administration Guide.","Logging Errors and Warnings","54189.htm");
Page[21]=new Array("If you want to log incoming SOAP requests and the corresponding outgoing responses, you must configure JVM startup parameters on your WebLogic server.","The SOAP requests and responses are logged to the console output and captured in the following file:","&lt;WLServerDomainFolder&gt;/servers/P6WebServices/logs/P6WebServices.out.","To configure logging of SOAP requests and responses, add the following JVM properties to your startup parameters in the Arguments section of the Server Start tab of the managed P6 EPPM Web Services server:","-Dcom.sun.xml.ws.transport.http.client.HttpTransportPipe.dump=true","-Dcom.sun.xml.internal.ws.transport.http.client.HttpTransportPipe.dump=true","-Dcom.sun.xml.ws.transport.http.HttpAdapter.dump=true","-Dcom.sun.xml.internal.ws.transport.http.HttpAdapter.dump=true","-Dcom.sun.xml.internal.ws.transport.http.HttpAdapter.dumpTreshold=999999","Note You must restart your P6 EPPM Web Services server for these settings to take effect.","Logging SOAP Requests and Responses","54191.htm");
Page[22]=new Array("Refer to the following file to access BPM messages:","&lt;weblogic_domain&gt;/servers/AdminServer/logs/AdminServer.log","In a typical BPM installation on Linux, the WebLogic domain for Fusion Middleware is:","&lt;WebLogic_domain&gt;/user_projects/domains/domain1","Oracle BPM Logging","89503.htm");
Page[23]=new Array("Outside of the scope of general issues with BPM or P6 EPPM, the P6 BPM Integration can potentially yield two types of issues:","connector configuration issues","data implementation issues rooted in either P6 or the BPM server","Troubleshooting Scenarios","54201.htm");
Page[24]=new Array("In the Primavera P6 Administrator, set the Log/Console Logger/Severity Level to debug or info. ","Check the P6 log for BPM related messages. The log file is P6WebAccess.html and its location is specified in BREBootStrap.xml located in your P6 EPPM home folder. These messages should indicate the cause of the connector failing to load.","Troubleshooting Connector Failures to Load Due to Configuration Issues","54202.htm");
Page[25]=new Array("These type of errors could have their root cause in either the P6 application or the BPM server.","In Primavera P6 Administrator, set the Log/Console Logger/Severity Level to debug or info.","Check the P6 log for BPM related messages. The log file is P6WebAccess.html and its location is specified in BREBootStrap.xml located in your P6 EPPM home folder. These messages should indicate why the BPM code failed to process normally.","Check the BPM logs in these cases to make sure that the cause of the failure is not due to the BPM server.","Troubleshooting P6 Workflows Portlet Failures To Load Data, Show Forms, Status Images, or Initiate a Process","54203.htm");

Page[26]=new Array("The following sections detail information about workflows and how to work with them.","BPM Workflows in P6","47842.htm");
Page[27]=new Array("A workflow is an automated business process that routes information and tasks between participants according to a defined set of procedures or rules designed to coordinate a specific business goal. Workflows are primarily characterized by their level of procedural automation involving one or more dynamic related series of processes, and their combination of human and machine-based tasks involving interaction with software and systems.","The following industry segments, marked by relatively high office labor costs and transaction volume, have demonstrated successful workflow implementations:","Insurance","Banking","Legal","General &amp; Administrative","Design","Engineering","Manufacturing","Business process modeling and workflow automation allow transactions to be conducted electronically without the need for manual intervention such as conducting certain validations or re-keying data. When workflow IT systems are processing repetitive, mundane, and often error-prone work, talented staff resources become available to handle activities that add real value to the enterprise. ","About Workflows","36631.htm");
Page[28]=new Array("You can use workflows to route business processes such as project initiation requests through your organization to gather information and visibility before a go/no go decision is made. Template data, routing designators, and approval rules can be set for each stage of a workflow. To illustrate these options, suppose we have a workflow involving five key approval managers. You can define the workflow such that all five must approve and even specify a particular sequence, if any. A much more relaxed approval rule would require only one out of the five to approve. The following are just some example of how you can use workflows.","Workflows are defined, deployed, and configured in BPM where your workflow designer defines the workflow tasks involved and assigns them to specific users, roles, or groups. Then, in P6, a business need kicks off an instance of the workflow and its required tasks are automatically routed to their users, roles, or groups.","When a specific user or any user assigned to a role or group logs into P6, the Workflows portlet on their dashboard will display their relevant tasks at this stage of the workflow, as authenticated by BPM. As a workflow participant, you can select a task in the workflow instance and claim ownership for it. This means you will be responsible for performing the task. The application refreshes itself to show only the actions permitted for this stage of the workflow for you (the currently logged in user). ","After your administrator sets up BPM for P6, they can configure a dashboard to display the Workflows portlet. The following list represents a list of the key Workflow elements that you can observe in the portlet depending on your configuration.","Action Required Tab: This tab shows the tasks that are important to you (the currently logged in user).","My Workflows Tab: This tab enables you to view all workflows according to role and status filters you can set.","Initiate a Workflow: Click Initiate a Workflow to start a new instance of a workflow based on a predesigned template.","BPM Workspace: Use the BPM Workspace to update the progress of tasks, initiate a change, request a project, and retrieve project information. You are also able to apply a bulk action to multiple work items.","Note If SSO authentication is not configured with BPM, you must log into BPM in the resulting window, close that window, and then return to P6 and click _ View Form again. This procedure is required whenever your BPM session expires.","Sample Workflow: A basic workflow image with tasks for a business user, two project offices, and a project manager.","Workflow History: View a chronological sequence of all the previous actions, users, and stages in the current workflow. ","Working with Workflows in P6 (On Premises only)","45215.htm");
Page[29]=new Array("Oracle Web Services Manager (WSM) includes wss11_saml_token_identity_switch_with_message_protection_client_policy, which enables identity switching. Identity switching means that the policy propagates a different identity than the one based on the authenticated Subject.","The Service-Oriented Architecture (SOA) application requires you to specify which user identity to use in client-side Web service policies, and then dynamically switches the user associated with the SAML token in the outbound Web service request. Instead of using the user name from the Subject, this policy allows you to set a new user name when sending the SAML Web service request.","The wss11_saml_token_identity_switch_with_message_protection_client_policy creates the SAML token based on the user ID set via the property javax.xml.ws.security.auth.username.","The initial identity switching policy requires message encryption, which requires the server-side policy to be the same. You will not want this policy when working in P6. To change the policy, you need to create a new client-side policy based on the existing identity switching policy (this is done through Enterprise Manager (EM), using the &quot;create like&quot; option). Within the new policy definition, you can remove the existing assertion (SAML 1.1 SAML with Certificates) and replace it with a new assertion based on an appropriate template, which in this case is WS-Security SAML Token Client.","Configuring SAML Web Service Clients for Identity Switching without Message Protection","62845.htm");
Page[30]=new Array("You can configure policies in the Web Services Policies, Edit Policy section of EM. You can also copy the custom SAML Identity Policy. To do this, copy the oracle_wss11_saml_token_identity_switch_with_message_protection_client_policy.txt file located here: http://download.oracle.com/docs/cd/E20686_01/English/Technical_Documentation/Oracle_BPM/oracle_wss11_saml_token_identity_switch_with_message_protection_client_policy.txt.","Message Protection Policy","62846.htm");
Page[31]=new Array("The Web service client (for example, the SOA reference binding component) where you attached the wss11_saml_token_identity_switch_with_message_protection_client_policy must have the oracle.wsm.security.WSIdentityPermission.","To use Fusion Middleware Control and add the oracle.wsm.security.WSIdentityPermission to the SOA reference binding component as a System Grant, perform the following steps:","In the Navigator pane, expand WebLogic Domain to show the domain where you need to configure the application. Select the domain.","Using Fusion Middleware Control, click WebLogic Domain, Security, System Policies. System policies are the system-wide policies applied to all applications deployed to the current WebLogic Domain.","From the System Policies page, select the arrow icon in the Permission field to search the system security grants.","Select one of the codebase permissions to use as a starting point and click Create Like.","In the Grant Details section of the page, enter file:${common.components.home}/modules/oracle.wsm.agent.common_11.1.1/wsm-agent-core.jar in the Codebase field.","In the Permissions section of the page, select the starting point permission class and click Edit.","In the Permission Class field, enter oracle.wsm.security.WSIdentityPermission. The resource name is the composite name for SOA and the application name for a J2EE client. The action is always assert.","Setting the WSIdentityPermission","62848.htm");
Page[32]=new Array("You also need to add the basic.credentials key to the csf store via EM. You might need to create a default keystore if you have not done that already.","Right-click Domain then select Security, Credentials.","Create a basic.credentials key.","Creating the basic.credentials Key","62849.htm");
Page[33]=new Array("Before applying the new policy, you need to import into JDeveloper. Copy the new custom policy to your JDev store directory (either use the attached policy from this document or export your custom policy from EM). The location of the store could appear as follows:","USER_HOME\\AppData\\Roaming\\JDeveloper\\system11.1.1.4.37.59.23\\DefaultDomain\\oracle\\store\\gmds\\owsm\\policies"," Apply this new client policy to your service reference in your composite app via EM.","With this policy in place you can leverage the javax.xml.ws.security.auth.username inbound service property. If you are hardcoding, set the value without quotes. The value is set to jcooper; however, you can also extract the username from the payload of execData variable.","You do not have to import the policy to JDev, you can deploy the composite without a client-side policy, and then set the client policy through EM.","EM has a feature for setting the client-side policies that shows you compatible client-side policies based on the service you are calling.","References","http://download.oracle.com/docs/cd/E17904_01/web.1111/b32511/setup_config.htm#WSSEC3585","Applying the New Policy","62850.htm");
Page[34]=new Array("Right-click your WebLogic domain and select Security Provider Configuration.","In the Keystore Section, select Configure.","Provide credentials.","Configuring a Keystore if One Is Not Configured","62851.htm");
var PageCount=36;


/*
Date: 12/3/2025 5:52 PM
Source: EPPM_25_dev
BookID: 89464
PubProduct: PRIMAVERA_EPPM
BookTitle: BPM Configuration Guide for On-Premises
Version: Version 25
Lang:	en
*/
	var PageLength=Page.length;
	var Result = "";
	var ResultTemp = "";
	var ResultFound = "";
	var ResultTitleOnly = [];
	var ResultTitleAndContent = [];
	var ResultInContent = [];
	var ResultInContentTemp = [];

	var ResultCombinedTemp = [];
	var ResultCombined = [];

	var arrayIndex = 0;
	var NrRes = 0;
	var j = 0;
	var i = 0;
	var k = 0;
	var d = 0;
	var maxItems = 1000;
	var heading = 0;
	var WordPos = -1;
	var WordPosHeading = -1;
	var WordPosContentText = -1;
	var FoundWord = "";
	var FoundWordHead = "";
	var SearchInHeadingOnly = 0;
	var isChecked;
	var size = 10;
	var resGroupCounter = 0;
	var shown = "shown";
	var checkBoxInHeading;
	var searchFlag = 0;
	var DivResult;
	var SearchWord;

if (SearchText && SearchText.length >= 1) {
		SearchWord = SearchText.replace(/\+/g, " ").replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;");
		searchFlag = 1;
	} else {
		SearchWord = "";
		searchFlag = 0;
	}
	

	if (searchFlag === 1) {
		Result = "";

		// checkBoxInHeading = document.getElementById("inHeading");
		if (inHeading) {

			isChecked = true;
		} else {

			isChecked = false;
		}

		if (SearchWord && SearchWord.length >= 1) {
			if (isChecked) {
				SearchInHeadingOnly = 1;
			} else {
				SearchInHeadingOnly = 0;
			}
			SearchWord = SearchWord.toLowerCase();
			window.status = "Searching, please wait...";
			for (j = 0; j < PageLength; j++) {
				k = Page[j].length - 1;
				for (i = 0; i < k; i++) {

					heading = k - 1;

					if (SearchInHeadingOnly === 1) {
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPosHeading > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);

							NrRes++;
							ResultTemp = "<li>";
							ResultTemp += "<span>";
							ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							ResultTitleOnly[arrayIndex] = ResultTemp;
							arrayIndex++;

							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}
					} else if (SearchInHeadingOnly === 0) {
						WordPos = Page[j][i].toLowerCase().indexOf(SearchWord);
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPos > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							NrRes++;
							ResultTemp += "<li>";
							ResultTemp += "<span>";
							if (WordPosHeading > -1) {
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";
							} else {
								// found word is not in the head
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading] + "</a><br/>\n";

							}
							if (i < k - 1) {
								WordPosContentText = Page[j][i].toLowerCase().indexOf(SearchWord);

								if (Page[j][i].length > 300 && (WordPosContentText > -1)) {

									if (WordPosContentText > 75) {
										ResultInContentTemp.push("..." + Page[j][i].substr(WordPosContentText - 75, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");
									} else {
										ResultInContentTemp.push("..." + Page[j][i].substr(0, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");

									}

								} else if (WordPosContentText > -1) {

									ResultInContentTemp.push(Page[j][i].replace(FoundWord, FoundWord.bold()));

								}
							}

							ResultTemp += ResultInContentTemp.join("");

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							if (WordPosHeading > -1) {
								ResultTitleAndContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							} else {
								ResultInContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							}

							ResultInContentTemp.length = 0;
							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}

					}
				}
			}

			ResultTitleOnly = ResultTitleOnly.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultTitleAndContent = ResultTitleAndContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultInContent = ResultInContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			ResultCombinedTemp = ResultTitleOnly.concat(ResultTitleAndContent, ResultInContent);

			ResultCombinedTemp = ResultCombinedTemp.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			for (d = 0; d < ResultCombinedTemp.length; d += size) {
				resGroupCounter++
				ResultCombined.push("<div id=" + "'" + "resGroup_" + resGroupCounter + "'" + " class=" + "'" + "resGroup " + shown + "'" + ">" + "<ol class='searchResults'>" + ResultCombinedTemp.slice(d, d + size).join("") + "</ol></div>");
				shown = "notshown";
			}

			ResultFound = ResultCombined.join("");

Result += "<div id='searchDetailsDiv'>";
			Result += "<p class='searchDetails'>Your Search Found&nbsp;" + NrRes + "&nbsp;items.&nbsp;";
			Result += "</p></div>";
			
			Result += "<div class='searchResultsDiv'>";
			Result += "<div id='resultsCollection' class='searchResults'>";
			Result += ResultFound;
			Result += "</div>";
			Result += "</div>";
			Result += "<div class='searchPaging'>";

			Result += '<hr />';

			Result += '<p class="bodytext"><a class="disabledAnchor" id="pBack" onclick="turnPage(\'backPage\')" href="#pBack">Back</a>&nbsp; | &nbsp;';
			
			if (resGroupCounter && resGroupCounter > 1) {
				Result += '<a id="pNext" onclick="turnPage(\'nextPage\')" href="#pNext">Next</a>';
			} else {
				Result += '<a id="pNext"  class="disabledAnchor" href="#pNext">Next</a>';
			}
			Result += '</p>\n';
			Result += '<div id="pagenofn"><p class="bodytext">Page <span id="pagen">1</span> of ' + resGroupCounter + '</p></div>';

			Result += "</div>";
			
			
		}

		DivResult = document.getElementById("s_anchor");
		if (Result && DivResult) {

			//myDivResult.append(Result);
			DivResult.innerHTML = Result;
			

		}
		window.status = "";
		
		

	}
	}())
}
