'use strict';
function search(SearchText, inHeading) {
(function () {
var Page = [];

/* Generated with Author-it 23.4.1.30004  12/11/2025 7:41:48 PM */
Page[0]=new Array("Title and Copyright Information","Copyright  1999, 2025, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information","46576.htm");
Page[1]=new Array("Scope","P6 EPPM system administrators manage and create configurations for your P6 EPPM applications. This guide describes how to perform common system administration tasks using the Primavera P6 Administrator.","Audience","System administrators should use this guide.","Using This Guide","This guide assumes you have installed the Primavera P6 Administrator and other P6 EPPM applications. For more information, see the P6 EPPM Installation and Configuration Guide.","About This Guide","94271.htm");
Page[2]=new Array("Primavera P6 Administrator is the primary application that system administrators use to review, modify, add, and delete P6 EPPM configurations. P6 EPPM configurations are stored in the database that was specified during the installation of P6. These configurations contain all of the settings used to run the application server for P6.","Caution Many of the defaults are set to maximize the performance of your database. You should change them only if you are certain a change is needed.","Primavera P6 Administrator Setup Tasks","7028.htm");
Page[3]=new Array("On-Premises","You can run the Primavera P6 Administrator locally or remotely through a browser. The installation for P6 sets the default URLs for remote access to the Primavera P6 Administrator. You can use the application server's configuration utility to change the listen port number and context root. After launching the Primavera P6 Administrator, you will need to enter an Admin Superuser name and password.","Cloud","Submit a Service Request in My Oracle Support to request access to Primavera P6 Administrator. You will be provided with a URL for Primavera P6 Administrator for your environment. After launching Primavera P6 Administrator, you will need to enter the name and password for a user which has been granted access to Primavera P6 Administrator.","Launching the Primavera P6 Administrator","14417.htm");
Page[4]=new Array("To launch the Primavera P6 Administrator locally with Windows:","Go to the P6 home directory (for example, C:\\P6EPPM_1\\p6).","Run adminpv.cmd.","Log in as an administrator.","Launching the Primavera P6 Administrator Locally with Windows for On-Premises","41724.htm");
Page[5]=new Array("To launch the Primavera P6 Administrator locally with UNIX or Linux:","Change to the p6home directory that you specified when installing P6. For example:","/usr/P6EPPM_1/p6","Run adminpv.sh.","Log in as the privileged database user (for example, privuser).","Launching the Primavera P6 Administrator Locally with UNIX or Linux for On-Premises","41725.htm");
Page[6]=new Array("To launch the Primavera P6 Administrator remotely:","Launch a supported browser.","Go to https://&lt;server IP:listenport&gt;/&lt;ContextRoot&gt;/admin.jsp","where &lt;serverIP:listenport&gt;&nbsp;is the IP address and listen port for the P6 server and &lt;ContextRoot&gt; is p6 by default.","Log in as a user with Admin Superuser privileges. ","Note","Only users with Admin Superuser privileges can log in to the Primavera P6 Administrator remotely. If you are logged in to P6, but do not have the appropriate privileges to edit settings in the Primavera P6 Administrator, you will be redirected to the P6 login page.","The Privileged database user (for example, privuser) can still access the local Primavera P6 Administrator, but will not have access to the remote Primavera P6 Administrator.","Launching the Primavera P6 Administrator Remotely for On-Premises","38478.htm");
Page[7]=new Array("Scope","This guide contains information about how you can:","Review, modify, add, and delete P6 EPPM configurations using Primavera P6 Administrator","Setup and maintain each of the P6 EPPM applications","Troubleshoot P6 EPPM","Audience","This guide is intended to be used by experienced system administrators, network administrators, or database administrators.","About the P6 EPPM System Administration Guide","90345.htm");
Page[8]=new Array("The Primavera P6 Administrator presents configuration settings for your P6 EPPM applications. The Configurations and Authentication tabs display the current configurations and settings. The Log tab displays a history of configuration changes.","Tip","Position the mouse over a setting to read the description.","You cannot edit the Factory Default configuration settings. You can only modify custom configurations.","The Primavera P6 Administrator warns you of any out of date configurations. Oracle recommends that you update these configurations.","If you create a new configuration, you need to click Update to latest version before changing your settings in the new configuration.","To find a setting quickly, you can use the search box below the Configurations drop-down list. Clicking the search button or hitting enter will open every file with that setting name.","Reviewing and Modifying Configurations for P6","53859.htm");
Page[9]=new Array("To change a setting value:","Select either the Configurations or the Authentication tab to display a hierarchical view of the settings.","Select a heading to display the settings.","Select the field or the drop-down list that you want to change.","Enter a new value.","On the You have unsaved changes context menu, select Save Changes.","Changing a Setting in the Primavera P6 Administrator","32731.htm");
Page[10]=new Array("To return a setting to its default value:","Position your mouse over the setting to display the tool tip.","Enter the Default into the field.","On the You have unsaved changes context menu, select Save Changes.","Returning a Primavera P6 Administrator Setting to its Default Value","32732.htm");
Page[11]=new Array("Duplicate an existing configuration to create a new configuration. To duplicate a configuration:","Select Manage Configurations in the Configurations list.","Select the menu button next to a configuration and select Duplicate.","Double-click the new configuration.","Enter a name for the configuration.","Select Save. ","Edit settings as needed.","Click Save Changes.","Tip","To create a new configuration based on default settings, duplicate the Factory Defaults configuration.","If you create a new configuration, you must click Update to latest version before changing your settings in the new configuration.","Adding Configurations to the Primavera P6 Administrator","14438.htm");
Page[12]=new Array("To add a new database instance to a configuration, duplicate an existing instance. To duplicate a database instance:","Select Database.","In the Instance drop-down list, select Manage Instances","Select the menu button next to a configuration and select Duplicate. ","Enter a unique name for the new instance.","Select Save.","Edit Database settings as needed.","Click Save Changes.","Adding Database Instances to a Configuration in the Primavera P6 Administrator for On-Premises","14439.htm");
Page[13]=new Array("To delete a configuration or database instance:","Select the configuration or database instance you want to delete.","Right-click the configuration or database instance and select Delete.","Tip","You cannot delete the Factory Defaults configuration. You can delete any custom configuration, but not all of them. You must always have one custom configuration.","You can delete any database instance associated with a configuration, but not all of them. Each configuration must have at least one database instance.","You can delete the database that you specified during the database configuration. If you do so, you will need to run the Database Configuration wizard again. See About the Database Configuration Wizard for P6.","Deleting Configurations and Database Instances for P6 in the Primavera P6 Administrator for On-Premises","14440.htm");
Page[14]=new Array("To export a P6 configuration using the command line:","adminpv -CopyConfig &quot;&lt;CurrentConfig&gt;&quot; &quot;&lt;ExportConfig&gt;&quot;","where &lt;CurrentConfig&gt; is the name of the configuration you want to export (by default, Primavera P6 Configuration) and &lt;ExportConfig&gt; is the name of the exported configuration.","Exporting Configurations Using the Command Line for On-Premises","93741.htm");
Page[15]=new Array("Many of the settings in the configurations tab are already set for you. You should change them only if you are certain a change is needed.","Use the configurations tab to:","Create new configurations.","Delete configurations.","Configure your settings for your applications.","About the Configurations Tab in the Primavera P6 Administrator","6989.htm");
Page[16]=new Array("Your localization settings specify the language you see when you log in to P6 and the country for server string constants. The Java application uses this setting to ensure all instances of P6 EPPM will use the same localization settings.","Note","The localization used by your operating system will have priority for the language used. The localization setting in P6 ensures P6 EPPM uses your preferred language if the JVM fails to recognize your operating system's localization settings.","If you change the localization of P6 on the login page, you will only change the language for your P6 user interface. It does not translate your data or change the convention followed by your region.","Changes to these settings require you to restart the P6 server.","To set your language and country:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar select Localization.","In the System Language drop-down list, select your language. The default value is English (en).","In the System Country drop-down list, select your country. The default value is US.","Tip Go to http://download.oracle.com/javase/1.5.0/docs/guide/intl/locale.doc.html or the Tested Configurations document for a list of supported languages and countries.","Configuring Localization Settings","51460.htm");
Page[17]=new Array("The Maximum Session Timeout setting is the maximum length of time that a user can connect to the application server (regardless of activity) before P6 EPPM times it out.","To set your session timeout:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectSession Management.","In Maximum Session Timeout, enter the amount of time a user session can remain open before it times out.","The default value is 1d. ","Enter a value between 1m and 24d.","Note Changes to this setting require you to restart the P6 server.","Configuring Session Management Settings","51463.htm");
Page[18]=new Array("You will use the database instance settings to specify information about your database, such as name, description, and schema.","To set your database instance settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectDatabase.","In the Instance list, select Manage Instances....","In the Manage Instances dialog box, hover over the instance that should be the default instance, click @&nbsp;Row&nbsp;Actions then select Set Default to set the selected instance as the default instance.","Note You can also remove the default database.","In the Instance list, select your database instance.","In the General Settings section:","In the Name field, enter the name of this database instance. ","Note","This determines how the database instance name will appear on the P6 login page.","The name can be a maximum of 32 characters.","In the Description field, enter a description of this database instance.","Note The description can be a maximum of 128 characters.","In the Public Group ID field, enter the database group ID of the privileged user account that will access the database. ","The default value is 1. ","In the User Name field, enter the name used to establish a connection to the database. ","The default value is pubuser, but if you created a custom Public User name, you must use your custom name.","In the Password field, enter the Public User password used to establish a connection to the database.","Select the Auto Start Services option to automatically start all services for this database when the application server starts. ","When this option is selected, all job services with a Concurrent Threads setting greater than zero will start when the application server starts. ","Select this option if you will use the Summarize or Apply Actuals features in P6 Professional.","If you do not select this option, users must manually log in to the application before the services will start.","Note If you clear the Auto Start Services option, job services will not start until someone logs in to the application for the first time.","Configuring Database Instance Settings for On-Premises","51554.htm");
Page[19]=new Array("If you have more than one database instance for your configurations, you will see them all under the database folder for your configuration. You can configure these settings for a database instance:","Database information, such as name, schema, and public group ID","Driver Class and URL","User Security","Connection Pool","Content Repository, such as Oracle WebCenter Content Core Capabilities (formerly Universal Content Management), Microsoft SharePoint, Oracle Database, and CMIS-compliant content repository","AutoVue","Session Settings","Cost Based Optimization settings","Oracle Analytics Publisher","BPM Settings","About Database Instance Settings","53438.htm");
Page[20]=new Array("The Driver Class and URL settings are where you configure the Java class and database URL that will connect to P6 EPPM.","To set your Driver Class and URL settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectDatabase.","Select your Instance from the drop-down list.","Expand Driver Class &amp; URL.","In the Java Class field, enter the database driver class used for communicating with the database. Your options are:","oracle.jdbc.driver.OracleDriver","com.microsoft.sqlserver.jdbc.SQLServerDriver","In the URL field, enter the database URL used to establish a connection to the P6 EPPM database.","Oracle example:","jdbc:oracle:thin:@&lt;Host_Name&gt;:&lt;Database_Port&gt;:&lt;Database_Name&gt;","Oracle Autonomous Database example:","jdbc:oracle:thin:@&lt;servicename&gt;?TNS_ADMIN=&lt;unzipped_wallet_path&gt;","Microsoft SQL Server example:","jdbc:sqlserver://&lt;Host_Name&gt;:&lt;Database_Port&gt;;database=&lt;Database_SID&gt;;","Note","If you upgrade your database and this database connection gets disconnected, you can right-click on the Driver Class &amp; URL node to reconfigure your database connection. When you right-click on the node, click Configure and the Configure URL dialog box will appear.","You can also define a custom Oracle/MSSQL driver class from the Configure URL dialog box. The jar file for your custom driver class should exist in the application server classpath. Oracle recommends copying the driver jar file to the &lt;WebLogic_Home&gt;\\user_projects\\domains\\your_domain\\lib file.","Configuring Driver Class and URL for Database Instance Settings","51555.htm");
Page[21]=new Array("These settings let you specify how many times users can log in before they are locked out and for how long the users will stay locked out. You can also specify whether to allow multiple user or single machine sessions.","To set your database instance settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectDatabase.","Select your Instance from the drop-down list.","Expand User Security.","Note","Changes to these settings require you to restart the P6 server.","In the Log Login Attempts field, select whether login attempts to P6 are tracked in the logs. You can choose to log the following:","None","Failed Attempts","Successful Attempts","All","In the Login Lockout Count field, enter the number of times a user can attempt to log in before the account locks. ","The default value is 5.","Enter a value between 0 and 100000.","Note","A setting of &quot;0&quot; allows an unlimited number of attempts.","The count resets after each successful login.","In the Login Lockout Duration field, enter the length of time that a user is blocked from logging in to P6; starts when the user exceeds the Login Lockout Count.","The default value is 1h.","Enter a value between 0 and 24d.","Note","The Admin Superuser can override this setting if they manually reset a user's session. See the Resetting User Sessions section of the P6 EPPM Application Administration Guide for details.","In the Allow Multiple User Sessions field, select whether a single user can simultaneously log in to P6 on different machines. ","The default value is Yes.","You can select one of the following:","Selecting &quot;Yes&quot; allows a single user to log in multiple times on the same machine or different machines.","Note","The following restrictions apply when you select &quot;Yes&quot; for multiple user sessions:","Users must use Microsoft Edge or Google Chrome when logging in more than once on the same machine. See the Tested Configurations document for supported versions.","If you want users to log in multiple times on the same machine (either with the same user name or with different user names), you must set the Allow Multiple User Sessions setting to Yes. The other settings will not allow the user to log in multiple times.","Selecting &quot;No&quot; allows a single user to log in only once with the same user name. If the user tries to log in again while another session is active, the log in will fail. A session can still be active if the user has closed the browser without logging out of P6. The user will have to wait until the session resets before they can log in again.","Selecting &quot;Single Machine&quot; allows a user to log in once on a machine. The user can log in again on the same machine if they close their browser without logging out; they will not have to wait for the session to reset. If they close their browser without logging out, they can immediately log in again on the same machine they were using; the user won't be able to log in on a different machine unless they wait for the session to reset.","Configuring User Security for Database Instance Settings","51556.htm");
Page[22]=new Array("The connection pools create and open database connections when they are first needed. When you start the P6 EPPM server, it will allocate one or two connections for initialization routines. The server will allocate and open more connections when the pool cannot satisfy requests from the current pool. You can set the connection pool settings for: ","Regular Used for the regular connection pool. Regular is the most used connection pool and has 90%+ of database access.","Long Running Used for the long running connection pool. Use this connection pool for services that will run for a long time.","Transactional Used for the transactional connection pool. Use this connection pool when you have several types of objects saved at one time. ","Note Gantt applets will use the Regular pool when loading data and the Transactional pool when creating or updating data. ","A P6 EPPM application operation requires a database connection, so it asks the connection pool for a database connection. If the connection pool contains a connection that is not currently leased, it returns that connection. If it doesn't have a connection available it will check to see if its current allocated count is below 50 (which is the default in the Maximum Connections setting). If the count is below 50, it will create a new database connection and open it, put it in the pool, and return it to the caller. The caller uses the connection, then releases it when they end the session.","If the pool could not allocate a connection because all 50 connections were leased, it will keep checking for the next 30 seconds (which is the default in the Lease Request Wait Timeout setting). If a connection becomes available within that 30 seconds, it will return that connection. If a connection does not become available, it will log the following error:  &#8220;Error: Lease request timeout while waiting for a connection to become available. Database &lt;dbname&gt;&#8221; and the caller will have to try again at a later time.","To set your connection pool settings:","Note","The defaults will provide optimal performance in most environments. Change them only if you are certain a change is needed. Contact My Oracle Support for more information.","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectDatabase.","Select your Instance from the drop-down list.","Expand the relevant Connection Pool branch.","Note Changes to these settings require you to restart the P6 server.","Select Trace SQL to trace all SQL sent to the database.","The default is unselected.","Select Renewable Leases if you want connection leases renewed when database statements are completed within the MaxLeaseDuration time period. When selected, the code can hold onto the connection as long as it needs, provided SQL statements finish within the MaxLeaseDuration period. When selected, the connection is revoked if no SQL statements are issued within the MaxLeaseDuration period or if one statement takes longer to run than that period.","Leave this field blank if you want each connection to be leased only for the MaxLeaseDuration period.","The default for Connection Pool (Regular) is false. The default for Long Running and Transactional is true.","In the Resize Rate field, enter the timeout period when the system will close all of its unused connections. For example, if the resize rate is 4 minutes, then every 4 minutes the connection pool will attempt to close all of its unused connections.","The default value is 4m.","Enter a value between 4m and 12h.","In the Maintenance Frequency field, enter how often maintenance will run to ensure leases have not exceeded the maximum duration.","The default value is 1m.","Enter a value between 10s and 1h.","In the Lease Request Wait Timeout field, enter the amount of time a request for a database connection will wait before timing out.","If a request for a database connection times out, the user can reload the page and attempt to connect to the database again.","The default value is 30s.","Enter a value between 5s and 2h.","In the Maximum Connections field, enter the maximum number of connections the server will have to the database. ","The default for Regular and Transactional is 50 and the default for Long Running is 100.","Enter a value between 5 and 15000.","In the Fetch Size field, enter how many rows to pull from the database and send to the application server.","The default value is 120.","In the Renewable Free Limit field, enter the minimum number of connections that leases need to be renewed.","The default value is 3.","Enter a value between 3 and 5.","In the Maximum Lease Durations field, enter the maximum time a database connection can be leased before it is revoked. ","The default for Regular is 2m, with a range of 5s and 4h.","The default for Long Running is 30m, with a range of 5s and 6h.","Note During the summarization process, queries may take a long time to run if the project has a high number of WBS nodes. If you receive timeout errors, set your Long Running maximum lease duration to at least 30 minutes.","The default for Transactional is 30m, with a range of 5s and 6h.","Configuring Connection Pool for Database Instance Settings","51557.htm");
Page[23]=new Array("To set your WCCC settings:","Note Ensure the settings you entered in when you configured the content repository match the settings you enter below.","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar select Database.","Select your Instance from the drop-down list.","Expand Content Repository.","In the Type field, select OracleWCCC.","In the Maximum document size field, enter the maximum size in KB for documents that can be uploaded to P6. The default is 10240 KB. Enter a value between 0 and 1048576.","In the Connection Maintenance Interval field enter the frequency at which the connection to the content repository is validated. The default is 10 minutes. Enter a value between 1 second and 24 days.","In the Oracle Webcenter Content Core Capabilities area","In the Host field, enter the machine name or IP address of the content repository server.","In the Port field, enter the IntradocServerPort number of the content repository server. By default, this is 4444.","Go to WCCC_Home\\ucm\\cs\\config\\.","Edit the config.cfg file.","Find the IntradocServerPort line, which contains the port number.","In the Oracle Home field, enter the location of the framework folder.","For the framework folder, use the following format:","/&lt;FolderName&gt;","For example:","/P6EPPM","In the Oracle Security Group field, enter the name of the Security Group assigned to the document folder created in WebCenter for P6 EPPM documents, as specified when you configured the content repository. ","For Example:","Enter Oracle Security Group as Public.","In the Oracle Security Account field, enter the name of the Security Account for P6 EPPM documents, as specified when you configured the content repository. ","If you did not enable security accounts, leave this setting blank.","In the Oracle Document Type field, enter the document type for P6 EPPM documents, which can be either an existing document type or a new one, as specified when you configured the content repository. ","For example:","Enter the Document Type as Document.","In the Metadata Prefix field, enter the prefix added to P6 EPPM metadata fields, as specified when you configured the content repository. For example, Prm.","In the Admin User field, enter the user name with administrative privileges, as specified when you configured the content repository. This setting is required.","From the Authentication Mode drop-down menu, select the authentication mode used to access the content repository server. P6 EPPM users cannot access content repository functions if you do not configure this setting.","If you choose &quot;Multiple User&quot;, all P6 EPPM content repository-related user names must match the equivalent content repository user name. For example, a P6 EPPM user named &quot;Joe&quot; must have an equivalent user named &quot;Joe&quot; in the content repository. ","If you choose &quot;Single User&quot;, the administrative user specified in the setting above must have access to all appropriate SharePoint libraries to browse to documents outside of the P6 EPPM home folder.","Restart the P6 Server.","Configuring Oracle WebCenter Content Core Capabilities (WCCC) in the Database Instance Settings","65657.htm");
Page[24]=new Array("You can use Oracle database as a content repository with your P6 EPPM installation.","To configure the Oracle database as your content repository:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectDatabase.","Select your Instance from the drop-down list.","Expand Content Repository.","Note Changes to these settings require you to restart the P6 server.","In the Type field, select Oracle Database.","This option will save documents and associated information in the P6 database schema. This option is only applicable if you are using an Oracle database on-premises or an Oracle Autonomous Database.","In the Maximum document size field, enter the maximum size in KB for documents that can be uploaded to P6. The default is 10240 KB. Enter a value between 0 and 1048576.","Note To block specific document types, enter a comma separated list of file extensions in the Invalid Document Types field in the Integration &amp; Allow Lists tab of the Application Settings in P6. Oracle recommends at least blocking the following document types: .exe,.com,.bat,.cmd,.vbs,.js,.msi.","In the Connection Maintenance Interval field enter the frequency at which the connection to the content repository is validated. The default is 10 minutes. Enter a value between 1 second and 24 days.","Note Ensure that the Enable Cloud Storage field is set to false.","Restart the P6 server.","Configuring the Oracle Database Content Repository","84126.htm");
Page[25]=new Array("You can use Microsoft SharePoint with P6 by integrating SharePoint with your CMIS-compliant content repository and then configuring your CMIS-compliant content repository with P6.","To configure your CMIS-compliant content repository:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectDatabase.","Select your Instance from the drop-down list.","Expand Content Repository.","In the Type field, select CMIS.","Note Changes to these settings require you to restart the P6 server.","In the Maximum document size field, enter the maximum size in KB for documents that can be uploaded to P6. The default is 10240 KB. Enter a value between 0 and 1048576.","Note To block specific document types, enter a comma separated list of file extensions in the Invalid Document Types field in the Integration &amp; Allow Lists tab of the Application Settings in P6. Oracle recommends at least blocking the following document types: .exe,.com,.bat,.cmd,.vbs,.js,.msi.","In the SharePoint area:","In the Login Name field, enter the user name for your content repository.","In the Password field, enter the password for the user name you entered above.","In the Authentication Mode field, enter authentication mode used to access the content repository server. P6 EPPM users cannot access content repository functions if you do not configure this setting.","If you choose &quot;Multiple User&quot;, all P6 EPPM content repository-related user names must match the equivalent content repository user name. For example, a P6 EPPM user named &quot;Joe&quot; must have an equivalent user named &quot;Joe&quot; in the content repository.","If you choose &quot;Single User&quot;, the administrative user specified in the setting above must have access to all appropriate Security Groups to browse to documents outside of the P6 EPPM home folder.","In the Repository Name field, enter the name for your content repository.","Note For SharePoint, enter the document library name you created for P6. ","In the Document Home field, enter the location of the folder in the document library where you want to store P6 documents.","In the Web Service URL field, enter the URL for your web services home.","This is Web Service Endpoint with format http://&lt;sharepoint host&gt;/sites/&lt;site name&gt;/_vti_bin/cmissoapwsdl.aspx","Restart the P6 server.","Configuring CMIS-Compliant Content Repository in the Database Instance Settings","65454.htm");
Page[26]=new Array("The session settings allow you to issue database statements to customize the database environment when the connections are created. You need to set these settings only if you have a customization you need to apply to a database environment.","To set your session settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectDatabase.","Select your Instance from the drop-down list.","Expand Session Settings.","In the Setting [n] field, enter the commands used to establish cursor sharing, rule-based mode, SQL trace, and more when database connections are created. Invalid settings in these fields are ignored. You can create five session settings.","Oracle or Oracle Autonomous Database Example:","alter session set _ = _","Microsoft SQL Server Example:","SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED","Note Changes to this setting require you to restart the P6 server.","Configuring Session Settings in the Database Instance Settings","51567.htm");
Page[27]=new Array("The cost based optimization settings will enable you to manipulate base SQL queries based on optimization statistics.","Caution Do not alter these settings unless you are familiar with cost based optimization. Contact My Oracle Support for more information.","To set your cost based optimization settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectDatabase.","Select your Instance from the drop-down list.","Expand Cost Based Optimization settings.","Note Changes to these settings require you to restart the P6 server.","Select Enable, to enable Cost Based Optimization. Leave the field clear to disable it.","Select Dump Matching SQL, select to dump the SQL where a match is found in the QUERYLIB table for a given SQL statement.","Leaving the field clear to dump the SQL where a match is not found in the QUERYLIB table for a given SQL statement.","Note To see these entries, you must set your logging level to INFO in Configuring Log Settings.","Configuring Cost Based Optimization Settings in the Database Instance Settings","51568.htm");
Page[28]=new Array("You must configure Oracle Analytics Publisher settings for Oracle Analytics Publisher to work with P6.","To configure your Oracle Analytics Publisher settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectDatabase.","Select your Instance from the drop-down list.","Expand BI Publisher.","Note Changes to these settings require you to restart the P6 server.","Select Personal Folders, to enable personal folders per user. If you do not want to use personal folders, leave the option clear. Users have their own personal folders where they can store their objects. Only the user who created and saved the content in the folder can access the folder.","In the Server URL field, enter the URL used to connect to the Oracle Analytics Publisher web service to P6.","For example, http://serverIP:port/xmlpserver/services/PublicReportService?wsdl","In the Folder Paths field, enter the relative path to the Oracle Analytics Publisher P6 reports folder where P6 will search for reports.","Example format (the forward slash is required):","/P6REPORTS","In the Version field, enter the version of Oracle Analytics Publisher that you want to integrate with P6.","In the Admin Username field, enter the username for a WebLogic Server Administrator.","In the Password field, enter the password for the WebLogic Server Administrator.","In the Sender Email ID field, enter the email address that you want users to see if they choose to receive reports by email.","Configuring Oracle Analytics Publisher in the Primavera P6 Administrator","51591.htm");
Page[29]=new Array("To connect P6 and BPM:","Open the Primavera P6 Administrator.","In the Configurations tab, expand your configuration.","Expand Database.","Select your Instance from the drop-down list.","Expand BPM Settings.","Note Changes to these settings require you to restart the P6 server.","In the Type list, select BMP.","Note PCS is supported for SaaS environments only.","In the Connector File Location field, enter the full path (including the file name) where you copied the connector files.","For example:","c:\\oracle\\bpm1111x\\eppmjars\\prm-bpm-connector-12c-v1.0.jar or /home/oracle/bpm1111x/rm-bpm-connector-12c-v1.0.jar","In the BPM library path field, enter the path of the directory where you copied all the 12c jars.","Note If the above settings are incorrect or the BPM jar files are incomplete, you will be prompted with an error message when you try to configure the BPM. Verify that your settings and jar files are correct.","Select Configure BPM to set options from the dialog box. If you receive an error message, check your values from the previous steps in this section. ","To configure P6 to use BPM, add the following settings:","Caution Do not put a forward slash / at the end of the URL. For example, it should read only http://host:port, and not http://host:port/.","In the User field, enter the BPM user with administrative access to BPM.","In the Password field, enter the password for the user.","In the T3 URL field, enter the T3 URL for your Oracle SOA configuration. For example: t3://&lt;host_name&gt;:&lt;port&gt;/soa-infra.","In the Security Realm field, enter the name of the security realm used by BPM. This is jazn.com by default.","In the Soap URL field, enter the URL for the SOAP services. Usually this URL takes the form of http://&lt;host_name&gt;:&lt;port&gt;.","In the Workspace URL field, enter an address in the form of http://&lt;host_name&gt;:&lt;port&gt; that indicates where the BPM Workspace application is hosted.","Note The host can be an IP address or a host name such as a machine name.","In the Partition field, enter the name of the SOA partition containing the BPM composite applications you would like to use in P6. The default partition name is default.","Click Save. When the configuration is complete, you will see a BPM properties have been configured message. ","Restart the P6 application server.","Configuring P6 to Connect to Oracle BPM","90216.htm");
Page[30]=new Array("To set your import/export options (Scheduled Service) settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar select Database.","Select your Instance from the drop-down list.","Expand Import/Export Options (Scheduled Services).","In the File Location field, enter the path you want the system to use for scheduled import and export jobs. All imports and exports, as well as all subfolders created or selected during scheduled jobs, are stored in the location specified in the File Location (Scheduled Service) field.<br />","Note There are separate File Location (Scheduled Services) fields for each of your available P6 EPPM database instances. Each field can be modified or set in Database/Instance/Import/Export Options (Scheduled Services).","Configuring Import/Export Options (Scheduled Service)","94036.htm");
Page[31]=new Array("The Thread Pool performs background job work. These settings control how many thread pools are available and how long any job can use them. Oracle recommends you keep the defaults because they will provide optimal service for most environments. Change the defaults only if you are configuring a large amount of services (scheduler, leveler, apply actuals, etc.). ","To set your thread pool settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectThread Pool.","Note Changes to these settings require you to restart the P6 server.","In the Number of Threads field, enter the number of server threads.","The default value is 50.","In the Maximum Task Duration field, enter the maximum amount of time a task can use a thread from the P6 thread pool. Only the P6 activity view uses the P6 thread pool. ","The default value is 5m.","Since database transactions can run inside the P6 thread pool, Oracle recommends setting the duration to be longer than the Regular Connection Pool's Maximum Lease Duration setting.","Note","A thread from the P6 thread pool can only be interrupted when it is in a wait condition (such as waiting for a database request to complete).","See Configuring Connection Pool for Database Instance Settings for related settings.","In the Maximum Long Running Task Duration field, enter the maximum amount of time a long running task can run before being interrupted and canceled. This setting is used for Job Services (scheduler, summarizer, and leveler), which use the P6 Long Running Thread Pool. ","The default value is 20m.","Oracle recommends you set the Maximum Long Running Task Duration for the thread pool to a value longer than the Long Running Connection Pool's Maximum Lease Duration.","In the Maintenance Frequency field, enter the frequency at which threads are checked for excess time durations.","The default value is 45s.","Configuring Thread Pool Settings","51469.htm");
Page[32]=new Array("Configuring AutoVue without VueLink is the native AutoVue implementation. To use this implementation, you will configure a single AutoVue server that is common across all database instances.","Note","When you configure AutoVue without VueLink, you are creating global AutoVue settings. These settings override any individual settings you may have created to configure AutoVue with VueLink.","When upgrading to Version 25 from 15 R2 or earlier, AutoVue connection details are lost and must be entered again.","To configure AutoVue without VueLink, complete the following steps:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar select Document Viewing.","Note Changes to these settings require you to restart the P6 server.","Select Enable. The default value is unselected.","Note","SSL mode does not work when the Enable option is set to false.","By default, the ESAPI resources that come with VueLink is used. You can change the location of the resource files by using -Dorg.owasp.espai.resources JAVA_OPTIONS in the WebLogic application server or in the setDomainEnv script.","By default, dmsstamp.ini and the oracle sample stamp from VueLink is used to create markup. You can change the location of the dmsstamp.ini file, which contains the stampfile location, using -Dexternal.csi.intellistamp.def.location JAVA_OPTIONS in the WebLogic application server or in the setDomainEnv script. ","If using Oracle Access Manager with your P6 EPPM deployment, add following context roots to the Oracle Access Manager exclusion list:<br />/p6/VueServlet/**<br />/p6/jvueDMS/**<br />/p6/P6AutoVueJNLPLauncher/**<br />/p6/av_cert.pem<br />For more information about protecting your resources using Oracle Access Manager's exclusion list, see the &quot;Protecting Your Resources&quot; chapter in the Oracle Access Manager Configuration Guide.","Select Enable SSL if your AutoVue server is enabled with SSL to allow communication via HTTPS.","In the Host Name field, enter the hostname for the server where AutoVue is installed. ","Note Do not put a / at the end of the URL.","In the Host Port field, enter the port for the server where AutoVue is installed. The default port is 5099.","Restart the P6 server.","Configuring AutoVue without VueLink","94037.htm");
Page[33]=new Array("Outside In converts documents uploaded to your content repository into a raster-image file. ","To configure Outside In:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectDocument Viewing.","In the Fonts Directory field, enter the full path to your operating system-specific fonts folder. For example, C:\\Windows\\Fonts.","Note You cannot convert documents in languages that do not have a compatible font installed in the Fonts Directory. Before you convert these documents you must install the appropriate language font.","In the Images Directory field, enter the full path to your Outside In images folder. For example, P6EPPM_HOME\\P6\\outsidein\\ImageExport\\Images.","Navigate to P6EPPM_HOME\\P6.","Run outsideInConfig.cmd or outsideInConfig.sh (based on your operating system).","Configuring Outside In","96417.htm");
Page[34]=new Array("You can use the log settings to set how the system logs errors and warnings.","To set your log settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectLog.","Select Asynchronous to log messages after the previous one has been logged for better performance. The default is unselected.","To configure Console Logger settings:","Select Enabled, to enable the console logger. The default is unselected.","In the Severity Level drop-down menu, select one of the following severity levels for the Console Logger:","error: Logs errors only.","warn: Logs errors and warnings only.","info: Logs errors, warnings, and informational messages only.","debug: Logs errors, warnings, informational messages, and debug comments.","Note","The default severity level is info.","The ranges are inclusive. For example, select &quot;debug&quot; to log all messages; select &quot;warning&quot; to log both warning and error level messages.","To configure File Logger settings:","Select Enabled, to enable the file logger. The default is selected.","Select HTML, to log as HTML, or leave the option clear to log as plain text.","Note Log files are created in a folder named WebAccessLogs, located in webaccesshome\\WebAccessLogs","In the Archive Size field, enter the minimum size (in Kb) a log file must be before it is archived.","The default value is 1024. ","Enter a value between 1024 and 15360.","In the Severity Level drop-down menu, select one of the following severity levels for the File Logger:","error: Logs errors only.","warn: Logs errors and warnings only.","info: Logs errors, warnings, and informational messages only.","debug: Logs errors, warnings, informational messages, and debug comments.","Note","The default severity level is error.","The ranges are inclusive. For example, select &quot;debug&quot; to log all messages; select &quot;warning&quot; to log both warning and error level messages.","In the Number of Archive Files field, enter the maximum number of log files to use. ","Enter a value between 2 and 2073600000. The default value is 6.","Note The default files are named WebAccessLog0.html through WebAccessLog5.html.","To configure Email Logger settings:","Note The email logger only sends information about Error messages.","Select Enabled, to enable the Email Logger. The default is unselected.","In the SMTP Host field, enter SMTP server that will send the email message.","In the Sender Email Address field, enter the email address that you want to send log messages.","In the Recipient Email Address field, enter the email address where you would like log messages sent.","In the Email Subject field, enter the subject line for error emails. The default value is P6 Web Access error.","Configuring Log Settings","51474.htm");
Page[35]=new Array("You can use the log settings to set how the system logs errors and warnings.","To set your log settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectClient Properties.","Select Compress HTML Content to compress responses from REST API and Web Services.","In the HTTP Server And Port Override field, enter the HTTP front-end web server and port that P6 clients should use. Use URL format: http[s]://servername[:port], do not include context root.","Note This setting is only necessary if problems are encountered while using a front-end web server proxy.","In the Ajax Request Wait Timeout field, specify how long the server should wait for Business Process Management workflows and Action Required tabs to respond.","Configuring Client Properties Settings","101145.htm");
Page[36]=new Array("When internal services in P6 EPPM need to access external web sites, they may need to go through your organization's firewall. You can configure that capability in the Web Proxy settings. P6 uses web proxy settings when it displays Contract Manager portlets that integrate with a Fusion server and when it connects to a Geo Code Provider server.","To set your web proxy settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar select Web Proxy.","In the Web Proxy Server field, enter the URL for your proxy server.","In the Web Proxy Port field, enter the port number for your proxy server.","In the Web Proxy Ignore List, type a comma separated list of the hosts that should not go through the proxy server. ","Configuring Web Proxy Settings","51478.htm");
Page[37]=new Array("Once you have installed P6, you will need to set your Primavera P6 Administrator settings to create multiple databases and get items such as your help and tutorials working with P6. These settings also focus on items within P6 such as custom portlets.","About Application Settings in the Primavera P6 Administrator","51595.htm");
Page[38]=new Array("P6 enables you to access data from different P6 EPPM databases. When you configure P6 to support multiple database instances, the Login page displays a Database list that enables users to choose the database instance where they want to connect.","Through the Primavera P6 Administrator, you can configure the server for P6 to manage user access to specific databases by requiring a database parameter in the URL. The database parameter, which is the name of a database instance, connects to the P6 server URL and points to that specific database instance. When users access the URL you specify, the Database list does not display in the Login page and they have login access only to the database instance defined by the database parameter. If users attempt to access the login page URL without specifying the required database parameter, a message displays to indicate that the URL is invalid and directs them to the administrator of P6.","For example, the following URL would log a user in to the database instance named Sample:","http://serverIP:listenport/login?db=Sample","As the administrator, you can specify a keyword that bypasses the database parameter requirement, so that you can access all databases through the Login page database list.","Follow instructions for the database dropdown key in Configuring Application Settings in the Primavera P6 Administrator to require a database parameter for the URL and to set a keyword to bypass the database parameter requirement.","Manage Access to Multiple Database Instances","14430.htm");
Page[39]=new Array("To set your application settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expandApplication and select General.","Do the following to configure your general application settings:","Select Ignore Daylight Savings Time to ignore daylight savings time or leave the field clear to use it.","Note","This setting will also impact P6 Team Member. If you notice dates and tasks are off by an hour in your P6 Team Member interfaces, the time difference could be caused by this setting.","Changes to this setting require you to restart the P6 server.","Select Allow Auto-Summarize Option to allow automatic summarization to be available in Resource Staffing user preferences.","Select Use HTTP POST for Custom Portlets to use HTTP POST requests instead of GET requests when loading custom portlets.","Select Enable Cross Site Scripting Filter to allow P6 EPPM to check for unsafe http requests from the browser and unsafe responses from P6, including requested documents. P6 EPPM considers requests and responses that contain JavaScript that P6 did not generate unsafe.","The browser will display an error message for all unsafe page requests. Internet Explorer 7 will show an error message if users attempt to download an unsafe document. Internet Explorer 8 and Firefox will prompt users to download the document file instead of viewing the document directly in the P6 browser.","Select Enable Cross Site Request Forgery Checking (CSRF) to allow CSRF for your environment.","Select Enable Session Hijack Checking to allow hijack checking.","In the Maximum Transactions for Excel Import of Resources field, enter the maximum number of transactions (activities or resources) that can be imported at once from an .xlsx or .csv file.","The default value is 2000.","Enter a value between 100 and 2000.","In the Database Dropdown Key field, enter the keyword to use for enabling database selection control in the login page. Pass this as a URL parameter db=keyword. See Manage Access to Multiple Database Instances for more information.","Set this to an empty string if you do not want to require the keyword.","You can also use the value you specify as the keyword to bypass the database requirement when logging in to the server for P6. For example, https://serverIP:listenport/login?db=bypass","In the Logout URL field, enter a specific URL that appears when the user exits with the Logout/Close icon in the banner of P6. You can use any valid URL. ","If you are using WebSSO, Oracle recommends you set the Logout URL to your SSO server's logout page to end the current SSO session.","If you do not specify a URL, P6 directs the user to the launch page of P6.","Note If you selected the &quot;Don't show this again&quot; option when you used the SSO login screen, that screen will not reappear after you logout then try to log back in. To get it to reappear, you need to clear the cookies for P6.","In the Hide Empty Project or WBS Threshold field, enter the maximum number of projects which the user can open before empty projects and WBS nodes will be hidden in the Activities view.","In the Custom Portlet URL Encryption Key field, enter Encryption key for custom portlet user password. ","In the Dashboards page of P6, users can create custom portlets. Depending on the target, P6 can pass the password of the currently logged on user to the target application. By default, the password is not encrypted. Use this setting to encrypt the password.","Note","Assigning a key encrypts the password that is part of the URL for a custom portlet.","The value can be any alphanumeric character or string of characters.","This encryption uses the Sun/Blowfish algorithm.","Changes to this setting require you to restart the P6 server.","See the P6 Help for more information on custom portlets.","In the Transaction Monitor Execution Interval field, enter how often the transaction monitor job will run. This will ensure there are no orphan transactions.","The default value is 10m. ","Enter a value between 1s and 24d20h31m23s647.","Note Changes to this setting require you to restart the P6 server.","In the P6 Help Server URL field, enter the URL used to launch P6 Help.","The default URL points to the version of the help hosted by Oracle. In contains the most up-to-date documentation.","Note If you prefer to use the local version of the P6 Help, you can use the local host URL. You can use the local help only if you installed and deployed the p6help.war file in WebLogic.","Example format:","http://&lt;server_name&gt;:&lt;listen_port&gt;/&lt;context_root&gt;","The URL might be case-sensitive, depending on your application server configuration.","In the TM Help Server URL field, enter the URL used to launch P6 Team Member Help.","The default URL points to the version hosted by Oracle. It contains the most up-to-date documentation.","Note If you prefer to use the local version of the P6 Team Member Help, you can use the local host URL. You can use the local help only if you installed and deployed the p6tmhelp.war file in WebLogic.","The URL might be case-sensitive, depending on your application server configuration.","In the System Administration Help Server URL field, enter the URL for system administration help.","Example format:","http://&lt;server_name&gt;:&lt;listen_port&gt;/&lt;context_root&gt;","Configuring Application Settings in the Primavera P6 Administrator","51596.htm");
Page[40]=new Array("To set your User Productivity Kit (UPK) settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectApplication/User Productivity Kit.","Select Enable User Productivity Kit to allow tutorials to be available within P6 EPPM.","Note See the documentation included with Oracle UPK (User Productivity Kit) for details on In-Application Support.","In the User Productivity Kit URL field, enter the URL used to launch UPK content.","Note","The URL might be case-sensitive, depending on your application server configuration.","WebLogic requires that the name of the UPK file stay the same when a custom UPK file is deployed. If you change the file name, you must create a new domain in WebLogic to match the name of the new UPK file.","A UPK URL entered here is used for both P6 and P6 Team Member Web. A separate P6 EPPM configuration must be made to use different content in these products.","Configuring User Productivity Kit Settings in Application Settings","51614.htm");
Page[41]=new Array("Once you have installed P6, you will need to set your Primavera P6 Administrator services settings to set items such as scheduler, leveler, and apply actuals. These services settings manage your long running services including when to run them and how many threads to use.","Oracle recommends having at least two configurations: one for application servers hosting P6 and another for the background service applications that run services, but do not process web pages. You can create more configurations as needed.","For the P6 application server, you need to limit background services and how often they run. This will allow users' requests to process more quickly.","For the background services configuration, you can have more threads configured and run them at shorter intervals. For information on setting up a separate server for job services, see Configuring a Separate Server for Job Services.","If you are running background services and P6 on the same server, Oracle recommends keeping the settings' defaults for your configuration.","About the Primavera P6 Administrator Services Settings","51615.htm");
Page[42]=new Array("The availability of ASAP and Scheduled Services depends on which Primavera P6 Administrator settings you populate and whether you are using P6 or P6 Professional. The summary below will help you to determine when you need to configure the Primavera P6 Administrator for job services.","ASAP Jobs","For P6, you must populate the appropriate Primavera P6 Administrator settings for all ASAP jobs that you want to run.","For P6 Professional, you must populate the Summarizer and Apply Actuals Primavera P6 Administrator settings for those features to run. The Scheduler, Leveler, Store Period Performance, and Recalculate Assignment Costs features will run locally in P6 Professional.","Scheduled Services Jobs","For P6, you must populate the appropriate Primavera P6 Administrator settings for all scheduled services jobs that you want to run. All scheduled services jobs are run from and are displayed in P6.","P6 Professional cannot run any scheduled services jobs or display the status of P6 scheduled services jobs.","Note Scheduled Services cannot run for Project Templates; however, Scheduler, Leveler, and Recalculate Assignment Costs features can be run as ASAP jobs for templates in P6.","Configuration for ASAP and Scheduled Services","45646.htm");
Page[43]=new Array("To set your services settings:","Note If you are running services and P6 on the same server, you should keep the defaults for the rates settings. If you want to apply the service immediately, set the rates low. Remember that if the server is actively applying the service, all users will experience delays in the application.","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expandServices and select General.","Select Enable All Services to enable all services without having to set concurrent threads on each service. If selected, the application will use the concurrent threads for all services. Oracle recommends enabling all services if you are using the Summarize or Apply Actuals features in P6 Professional.","Ensure the field is clear if you want the application to treat the concurrent threads of services as equal to zero. When you set to false, the values for the threads will stay the same.","Select Enable Job Cleanup on Startup to restart recurring jobs that are stuck in the running state.","Enable Job Cleanup on Startup will start when the application initially launches and will check for any recurring jobs that are running. It will set the status of all running jobs to pending for all databases that have Database/Instance/Auto Start Services enabled. It also follows the Services/Enable All Services setting and will not run if Enable All Services is set to false. ","Enable Job Cleanup on Startup can run on a full build or the separate job services application. If you are on a clustered environment, run this service in only one instance.","In the Job Service Poll Rate field, enter the rate at which the server polls the database for new jobs to run.","The default value is 10s.","Enter a value between 1s and 24d20h31m23s647.","In the ASAP Cleanup Rate field, enter the rate that the database removes completed WebASAP jobs from the database.","The default value is 1d.","Enter a value between 1d and 24d.","Once the time is met all ASAP jobs that have a status other than running or delegated will be removed from the table automatically. Running and delegated jobs will be removed if they are older than the cleanup rate or if they are older than one day, whichever is greater.","Note Confirm that the cleanup rate is greater than your longest running job.","In the Job Service Shared Folder Location field, enter the location to store temporary files while they are in the job queue.","Tip","See Configuring a Job Services Server Using p6services.jar for more information on these settings.","Configuring Services Settings","51616.htm");
Page[44]=new Array("Modify publication settings to specify constraints on your report publishing jobs. ","To configure your publication settings:","Note The default settings should be the optimal settings for most environments. Change them only if your environment requires different settings.","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expandServices, then expand Publication, and select Settings.","To configure General Data:","In the Page Size field, enter the maximum number of rows of general data a job can process. This applies to each business object that falls under the general category; general data is not time-distributed (spread), not hierarchical, and not in a blob. When using this setting, each business object processes separately.","The default value is 32.","Enter a value between 1 and 8192.","In the Max Job Count field, enter the number of processes used for this service on your server.","The default value is 1.","Enter a value between 1 and 20.","To configure Blob Data:","In the Page Size field, enter the maximum number of rows of blob data that a job can process. This applies to each business object that falls under the blob category. When using this setting, each business object processes separately.","The default value is 25.","Enter a value between 1 and 8192.","In the Max Job Count field, enter the number of processes used for this service on your server.","The default value is 1.","Enter a value between 1 and 20.","To configure TimeDistributed:","In the Page Size field, enter the maximum number of rows of time-distributed (spread) data that a job can process. This applies to each business object that falls under the time-distributed category. When using this setting, each business object processes separately.","The default value is 16.","Enter a value between 1 and 8192.","In the Max Job Count field, enter the number of processes used for this service on your server.","The default value is 1.","Enter a value between 1 and 20.","To configure Log:","In the Security Level drop-down menu, select the level of information contained in the log file for all publication services. The ranges are inclusive. For example, select debug to log all messages; select info to log details about what runs, exceptions, and warnings; select warning to log both warning and error level messages.","The default value is info.","Select info, debug, warning, or error.","In the Global Service Log File Cap (Success) field, enter the number of logs to retain for successful global publication services. This will retain a log for each global service. If set to 5, the last 5 successful service runs will be retained for each global service.","The default value is 5.","Enter a value between 1 and 25.","In the Global Service Log File Cap (Fail) field, enter the number of logs to retain for failed global publication services. This will retain a log for each global service. If set to 5, the last 5 failed service runs will be retained for each global service.","The default value is 5.","Enter a value between 1 and 25.","In the Project Service Log File Cap (Success) field, enter the number of logs to retain for successful Publish Project jobs. This will retain a log for each project service. If set to 5, the last 5 successful service runs will be retained.","The default value is 5.","Enter a value between 1 and 25.","In the Project Service Log File Cap (Fail) field, enter the number of logs to retain for failed Publish Project jobs. This will retain a log for each project service. If set to 5, the last 5 failed service runs will be retained, per project.","The default value is 5.","Enter a value between 1 and 25.","Configuring Publication Settings in Services Settings","51618.htm");
Page[45]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you have scheduling work that needs to be done immediately, you should set the Interval low (for example, 10s) and the Concurrent Threads high. Remember that if the server is actively applying the service, all users will experience delays in the application.","To configure your publication settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication, and select Services.","You can use Project Arbiter to automate submitting Publish Project services for eligible projects to the service queue.","To configure Project&nbsp;Arbiter:","Select Active Mode if you want jobs processed continuously until all jobs finish. Leave this field clear if you want each job processed according to the Interval.","In the Interval field, enter the amount of time the service will wait before running the next available job.","The default value is 10s.","Enter a value between 1s and 24d20h31m23s647.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that this service will not run on this server. ","The default value is 1. ","Enter either 0 or 1.","To configure Publish Enterprise Summaries:","Note Publish Enterprise Data, Enterprise Summaries, Resource Management, and Security will recalculate data and store it in physical fields in the Extended Schema tables, and will perform other data denormalization tasks. For example, duration fields are calculated fields in the existing P6 schema tables, but will be recalculated and stored as physical fields in the extended schema tables when a project is published.","Select Active Mode if you want jobs processed continuously until all jobs finish. Leave this field clear if you want each job processed according to the Interval.","In the Interval field, enter the amount of time the service will wait before running the next available job.","The default value is 10s. ","Enter a value between 1s and 24d20h31m23s647.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that this service will not run on this server. ","The default value is 1. ","Enter either 0 or 1.","To configure Publish Resource Management:","Select Active Mode if you want jobs processed continuously until all jobs finish. Leave this field clear if you want each job processed according to the Interval.","In the Interval field, enter the amount of time the service will wait before running the next available job.","The default value is 10s. ","Enter a value between 1s and 24d20h31m23s647.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that this service will not be run on this server. ","The default value is 1. ","Enter either 0 or 1.","To configure Publish Resource Role Assignment:","Select Active Mode if you want jobs processed continuously until all jobs finish. Leave this field clear if you want each job processed according to the Interval.","In the Interval field, enter the amount of time the service will wait before running the next available job.","The default value is 10s.","Enter a value between 1s and 24d20h31m23s647.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that this service will not run on this server.","The default value is 1.","Enter either 0 or 1.","To configure Publish Project:","Select Active Mode field if you want jobs processed continuously until all jobs finish. Leave this field clear if you want each job processed according to the Interval.","In the Interval field, enter the amount of time the service will wait before running the next available job.","The default value is 10s. ","Enter a value between 1s and 24d20h31m23s647.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that this service will not be run on this server. ","The default value is 2. ","Enter a value between 0 and 20.","To configure Publish Enterprise Summaries:","Note Publish Enterprise Data, Enterprise Summaries, Resource Management, and Security will recalculate data and store it in physical fields in the Extended Schema tables, and will perform other data denormalization tasks. For example, duration fields are calculated fields in the existing P6 schema tables, but will be recalculated and stored as physical fields in the extended schema tables when a project is published.","Select Active Mode if you want jobs processed continuously until all jobs finish. Leave this field clear if you want each job processed according to the Interval.","In the Interval field, enter the amount of time the service will wait before running the next available job.","The default value is 10s. ","Enter a value between 1s and 24d20h31m23s647.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that this service will not run on this server. ","The default value is 1. ","Enter either 0 or 1.","Configuring Publication Services in Services Settings","51619.htm");
Page[46]=new Array("If you are running services and P6 on the same server, you should keep the defaults.","To set your delete published data settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication, and select Delete Published Data.","Select Active Mode if you want jobs processed continuously until all jobs finish. Leave this field clear if you want each job processed according to the Interval.","In the Interval field, enter the amount of time the DeletePublishedData service will wait before scheduling the next available job (in 1d1h1m1s format, specifying only numbers without letters implies milliseconds). When P6 initiates the DeletePublishedData service, it will attempt to run immediately but switch to running as a job service if it takes too long to start. ","The default value is 10s.","Enter a value between 1s and 24d20h31m23s647.","In the Concurrent Threads field, enter the number of processes used for the DeletePublishedData service on this server. A value of 0 indicates that the service is not available on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Delete Published Data in Services Settings","98268.htm");
Page[47]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you have scheduling work that needs to be done immediately, you should set the Interval low (for example, 10s) and the Concurrent Threads high (for example, 20). Remember that if the server is actively scheduling work, all users will experience delays in the application.","To set your scheduler settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Scheduler.","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","Select Load All Calendars Till Threshold.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Scheduler in Services Settings","51628.htm");
Page[48]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you have leveling work that needs to be done immediately, you should set the Interval low (for example, 10s) and the Concurrent Threads high (for example, 20). Remember that if the server is actively doing leveling work, all users will experience delays in the application.","To set your leveler settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Leveler.","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Leveler in Services Settings","51629.htm");
Page[49]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you have summarizing work that needs to be done immediately, you should set the Interval low (for example, 10s) and the Concurrent Threads high (for example, 20). Remember that if the server is actively doing summarizing work, all users will experience delays in the application.","To set your summarizer settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Summarizer.","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","In the Maximum Duration to Summarize field, enter the maximum activity duration in hours that the summarizer will handle. Any projects that contain activities with durations longer than this setting will fail summarization and an error will be displayed for that project.","The default value is 100,000.","Configuring Summarizer in Services Settings","51630.htm");
Page[50]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you have apply actuals work that needs to be done immediately, you should set the Interval low (for example, 10s) and the Concurrent Threads high (for example, 20). Remember that if the server is actively applying actuals, all users will experience delays in the application.","To set your apply actuals settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Apply Actuals.","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Apply Actuals in Services Settings","51631.htm");
Page[51]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you have store period performance work that needs to be done immediately, you should set the Interval low (for example, 10s) and the Concurrent Threads high (for example, 20). Remember that if the server is actively running store period performance work, all users will experience delays in the application.","To set your import/export settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Import/Export.","Under Import/Export Service:","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20..","Configuring Import/Export Service in Services Settings","85633.htm");
Page[52]=new Array("To set your import/export options settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Import/Export.","Under Import/Export Options:","Select Store Files In Database if you want imported files including images to be stored in the database. Leave this field clear if you do not want files to be stored in the database.","In the Temporary File Location(ASAP Service) field, enter the location to store the temporary file during the XML import/export process or image storing process. If you do not specify a location, the temporary file is placed in the bootstrap home location, which is in the P6 home directory (for example, c:\\p6home).","In the Maximum file size field, enter the maximum file size (in KB) for XML import/export and image files. JVM settings and available space in the Temporary File Location determine the file size. Users might need to alter the memory settings in their application server if the import/export file size is greater than the maximum default file size.","The default value is 102400.","Enter a value between 1024 and 2147483647.","Note There are also settings to configure the maximum height and width of stored images in P6 on the Data Limits page of Application Settings.","Configuring Import/Export Options in Services Settings","51647.htm");
Page[53]=new Array("To set your Unifier integration settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Unifier.","The SendToScheduleSheet service sends P6 data to Unifier's schedule sheet when the Send to Schedule Sheet action is used in P6.","In the SendToScheduleSheet area:","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","The SummarizeByCBS service creates either CBS Summary data or Resource and Expenses Summary and Spread data depending on a project's Schedule Type when the Send to Summary Sheet action is used in P6.","In the SummarizeByCBS area:","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","If a project has been summarized and there hasn't been any changes made to the project since it was summarized, the ProjectUpdateCheck service will prevent the SummarizeByCBS service from running.","In the ProjectUpdateCheck area:","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Unifier in Services Settings","78351.htm");
Page[54]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you want the server to check for overallocations immediately, you should set the Interval low (for example, 10s) and the Concurrent Threads high (for example, 20). Remember that if the server is actively checking for overallocations, all users will experience delays in the application.","Note Enable the Project Arbiter service because projects will be published before running the overallocation service.","To set your overallocation check settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Overallocation Check.","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Overallocation Check in Services Settings","51632.htm");
Page[55]=new Array("To set your global replace settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Global Replace.","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Global Replace Service in Services Settings","90460.htm");
Page[56]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you want to sync actuals immediately, you should set the Interval low (for example, 10s) and the Concurrent Threads high (for example, 20). Remember that if the server is actively synchronizing actuals, all users will experience delays in the application.","To set your sync actual this period settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Sync Units.","Under Sync Actual This Period:","Select Enabled to enable the service. Clear this field to disable the service.","If you enable this service, P6 automatically recalculates actual units and costs for ThisPeriod.","In the Execution Interval field, select the amount of time to wait before checking for any jobs. The service will poll the job service table and the execution interval will determine when it starts.","The default value is 5 minutes.","Enter a value between 1 second and 24 days.","In the ActivityThreshold field, determine if the SyncActualThisPeriod service will run simultaneously or as a job service. ","If the number of activities in a project is over the activity threshold, the SyncActualThisPeriod will run as a job service and add an entry to the job service table. The SyncActualThisPeriod service will poll the job service table, and the execution interval will determine when it starts. If the number of activities in a project is under the activity threshold, it will run immediately and will not add an entry to the job service table.","The default value is 8000.","Enter a value between 1 and 2147483647.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Sync Actual This Period in Services Settings","51638.htm");
Page[57]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you want to sync immediately, you should set the Interval low (for example, 10s) and the Concurrent Threads high (for example, 20). Remember that if the server is actively synchronizing, all users will experience delays in the application.","To set your sync remaining to planned settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Sync Units.","Under Sync Remaining to Planned:","Select Enabled to enable the service. Clear this field to disable the service.","In the Execution Interval field, select the amount of time to wait before checking for any jobs. The service will poll the job service table and the execution interval will determine when it starts.","The default value is 5 minutes.","Enter a value between 1 second and 24 days.","In the ActivityThreshold field, determine if the SyncRemainingtoPlanned service will run simultaneously or as a job service.","If the number of activities in a project is over the activity threshold, the SyncRemainingtoPlanned will run as a job service and add an entry to the job service table. The SyncRemainingtoPlanned service will poll the job service table, and the execution interval will determine when it starts. If the number of activities in a project is under the activity threshold, it will run immediately and will not add an entry to the job service table.","The default value is 8000.","Enter a value between 1 and 30000.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Sync Remaining to Planned in Services Settings","51639.htm");
Page[58]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you want to sync actuals immediately, you should set the Interval low (for example, 10s) and the Concurrent Threads high (for example, 20). Remember that if the server is actively synchronizing actuals, all users will experience delays in the application.","To set your sync actuals with duration % complete settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Sync Units.","Under Sync Actuals with Duration % Complete:","Select Enabled to enable the service. Clear this field to disable the service.","In the Execution Interval field, select the amount of time to wait before checking for any jobs. The service will poll the job service table and the execution interval will determine when it starts.","The default value is 5 minutes.","Enter a value between 1 second and 24 days.","In the ActivityThreshold field, determine if the SyncActualswithDuration%Complete service will run simultaneously or as a job service.","If the number of activities in a project is over the activity threshold, the SyncActualswithDuration%Complete will run as a job service and add an entry to the job service table. The SyncActualswithDuration%Complete service will poll the job service table, and the execution interval will determine when it starts. If the number of activities in a project is under the activity threshold, it will run immediately and will not add an entry to the job service table.","The default value is 8000.","Enter a value between 1 and 2147483647.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Sync Actuals with Duration % Complete in Services Settings","51640.htm");
Page[59]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you want the server to check CopyProject immediately, you should set the Interval low (for example, 10s) and the Concurrent Threads high (for example, 20). Remember that if the server is actively checking for CopyProject, all users will experience delays in the application.","To configure the copy project settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select CopyProject.","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring CopyProject in Services Settings","85632.htm");
Page[60]=new Array("As a project progresses, you might choose to update baseline data without restoring the baseline or creating a new baseline. When a project is in progress, creating a new baseline may not yield accurate comparison results. When you update a baseline, only the data types you select will be updated. You may also create and copy baselines efficiently.","To set your baseline settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Baseline.","In the Create/Copy baseline section:","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","In the Update Baseline section:","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Baseline in Service Settings","89731.htm");
Page[61]=new Array("The GatewaySynchronization service sends information from P6 to Primavera Unifier or Oracle Primavera Cloud via Primavera Gateway.","To configure Gateway synchronization:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select GatewaySynchronization.","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","In the Timeout for Gateway job completion field, enter the maximum time P6 will wait for a gateway job to be completed before marking its status as failed or timed out.","The default value is 12 minutes.","Enter a value between 1 minute and 2 days.","Configuring GatewaySynchronization","88636.htm");
Page[62]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you have store period performance work that needs to be done immediately, you should set the Interval low (for example, 10s) and the Concurrent Threads high (for example, 20). Remember that if the server is actively running store period performance work, all users will experience delays in the application.","To set your store period performance settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Store Period Performance.","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Store Period Performance in Services Settings","51635.htm");
Page[63]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you have recalculate assignment cost work that needs to be done immediately, you should set the Interval low (for example, 10s) and the Concurrent Threads high (for example, 20). Remember that if the server is actively running recalculate assignment cost work, all users will experience delays in the application.","To set your recalculate assignment cost settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Recalculate Assignment Cost.","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Recalculate Assignment Cost in Services Settings","51636.htm");
Page[64]=new Array("If you are running services and P6 on the same server, you should keep the defaults.","To set your rename document folder settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Rename Document Folder.","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Rename Document Folder in Services Settings","98267.htm");
Page[65]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you want the server to copy WBS elements immediately, you should set the Interval low (for example, 10s) and the Concurrent Threads high (for example, 20). Remember that if the server is actively copying WBS elements, all users will experience delays in the application.","To configure the copy WBS settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select CopyWBS.","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring CopyWBS in Services Settings","98401.htm");
Page[66]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you have exports to Excel that need to be done immediately, you should set the Interval low (for example, 10s) and the Concurrent Threads high (for example, 20). Remember that if the server is actively exporting to Excel, all users will experience delays in the application.","To configure the export excel settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Export Excel.","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Export Excel in Services Settings","98402.htm");
Page[67]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you want the server to import or export enterprise data immediately, you should set the Interval low (for example, 10s) and the Concurrent Threads high (for example, 20). Remember that if the server is actively importing or exporting enterprise data, all users will experience delays in the application.","To configure the import/export enterprise data settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Import/Export Enterprise Data.","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","In the Maximum Duration field, enter the maximum activity duration that the Import/Export Enterprise Data service will handle.","The default value is 100,000.","Enter a value between 0 and 2147483647.","Configuring Import/Export Enterprise Data in Services Settings","98403.htm");
Page[68]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you want the server to generate reports immediately, you should set the Interval low (for example, 10s) and the Concurrent Threads high (for example, 20). Remember that if the server is actively generating reports, all users will experience delays in the application.","To configure the generate reports settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Generate Reports.","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Generate Reports in Services Settings","98404.htm");
Page[69]=new Array("If you are running services and P6 on the same server, you should keep the defaults.","To configure the checkin enterprise data settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Checkin Enterprise Data.","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Checkin Enterprise Data in Services Settings","98985.htm");
Page[70]=new Array("If you are running services and P6 on the same server, you should keep the defaults.","To configure the checkout enterprise data settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Checkout Enterprise Data.","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Checkout Enterprise Data in Services Settings","98986.htm");
Page[71]=new Array("If you are running services and P6 on the same server, you should keep the defaults.","To set your preview baseline settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Preview Baseline.","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Preview Baseline in Services Settings","101143.htm");
Page[72]=new Array("If you are running services and P6 on the same server, you should keep the defaults.","To configure the check schedule settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Check Schedule.","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Check Schedule in Services Settings","103068.htm");
Page[73]=new Array("If you are running services and P6 on the same server, you should keep the defaults.","To set your project check settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Job Services.","Select Project Check.","Select Active Mode if you want jobs processed continuously until all jobs finish. Clear this field if you want each job processed according to the Interval.","In the Interval field, select the amount of time to wait before running the next available job.","The default value is 10s.","Enter a value between 1 second and 24 days.","In the Concurrent Threads field, enter the number of processes used for this service on this server. A value of 0 indicates that that this job will not run on this server.","The default value is 2.","Enter a value between 0 and 20.","Configuring Project Check in Services Settings","103067.htm");
Page[74]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you want to apply the service immediately, you should set the rates low (for example, 30s). Remember that if the server is actively applying the service, all users will experience delays in the application.","To set your module access service settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Infrastructure Services.","In the Module Access Service area:","In the Update Rate field, enter the rate when a Business Rule Engine synchronizes with the database for license counts.","The default value is 30s.","Enter a value between 100 and 1m.","In the Expiration Check Rate field, enter the rate when the database checks licenses to see if they should expire. ","The default value is 2m.","Enter a value between 500 and 15m.","Configuring Module Access Service in Services Settings","51620.htm");
Page[75]=new Array("When the timestamp service runs, it searches the database for what items have changed and need to be refreshed in the cache.","To set your timestamp service settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expandServices, then expand Publication and select Infrastructure Services.","In the Timestamp Service area:","In the Refresh Rate field, enter the rate when the database is queried to determine if a table change notification is necessary. ","The default value is 1m.","Enter a value between 15s and 1h.","Note","If you are running services and P6 on the same server, you should keep the defaults. If you enter a longer rate, the server will run more efficiently, but the data may be out of date. If you enter a shorter time, the data will be up to date, but the server may not run as efficiently.","Changes to this setting require you to restart the P6 server.","Configuring Timestamp Service in Services Settings","51621.htm");
Page[76]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you want to apply the service immediately, you should set the Interval low. Remember that if the server is actively applying the service, all users will experience delays in the application.","To set your mail service settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Infrastructure Services.","In the Mail Service section:","In the Email Server field, enter the hostname or IP address of the email notification server.","In the Security drop-down menu, select one of the following based on the security you are using:","SSL","TLS","None","In the SMTP(S) Port field, enter the TCP/IP port of the outgoing SMTP server. The default value is 465.","In the Bounce Email Address field, enter the address where emails should be sent if delivery fails.","Note Bounced emails will be sent to the person who sent them automatically. This bounce field allows you to send bounced emails to your administrators so they can investigate potential problems with emails.","In the Sender's Email ID field, enter the address to be used for all emails sent from P6.","In the Send Interval field, enter how often to send queued mail messages.","The default value is 1m.","Enter a value between 0 and 24d20h31m23s647.","In the Maximum Queue Length field, enter the maximum size of the mail message queue.","The default value is 250.","Enter a value between 0 and 2147483647.","In the Authorized User Name field, enter the name of the account to use to send mail from this mail server.","In the Authorized User password field, enter the password of the account used to send mail from this mail server.","Configuring Mail Service in Services Settings","51644.htm");
Page[77]=new Array("The registry service finds changes in the Primavera P6 Administrator configuration settings and deploys those changes in the server. If you are running services and P6 on the same server, you should keep the defaults. If you enter a longer rate, the server will run more efficiently, but the data may be out of date. If you enter a shorter time, the data will be up to date, but the server may not run as efficiently.","To set your registry service settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Infrastructure Services.","In the Registry Service section:","In the Refresh Rate field, enter the rate when the Business Rule Engine status updates in the database. ","The default value is 1m30s. ","Enter a value between 15s and 1h.","In the Stale Period field, enter the duration of inactivity that indicates an inoperable Business Rule Engine. ","The default value is 4m.","Enter a value between 1m and 10m.","In the Port field, enter the TCP/IP port that will receive requests to revive dead Business Rule Engines.","The default value is 9192.","Enter a value between 1 and 65535.","Configuring Registry Service in Services Settings","51622.htm");
Page[78]=new Array("The next key service finds cached keys that need updating.","To set your next key service settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expandServices, then expand Publication and select Infrastructure Services.","In the Next Key Service area:","In the Refresh Rate field, enter the rate to refresh the next key cache.","The default value is 1m.","Enter a value between 15s and 1h.","Note If you are running services and P6 on the same server, you should keep the defaults. If you enter a longer rate, the server will run more efficiently, but the data may be out of date. If you enter a shorter time, the data will be up to date, but the server may not run as efficiently.","In the Maximum Cached Keys field, enter the maximum next keys to cache per table.","The default value is 10.","Enter a value between 1 and 100.","Configuring Next Key Service in Services Settings","51623.htm");
Page[79]=new Array("The alert notification service controls how often the P6 database checks for alerts.","To set your alert notification service settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expandServices, then expand Publication and select Infrastructure Services.","In the Alert Notification Service area.","In the Refresh Rate field, enter the rate to refresh alerts.","The default value is 30s.","Enter a value between 15s and 15m.","Note If you are running services and P6 on the same server, you should keep the defaults. If you enter a longer rate, the server will run more efficiently, but the data may be out of date. If you enter a shorter time, the data will be up to date, but the server may not run as efficiently.","Configuring Alert Notification Service in Services Settings","54652.htm");
Page[80]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you want to apply the service immediately, you should set the Interval low. Remember that if the server is actively applying the service, all users will experience delays in the application.","To set your collaboration synchronization service settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Infrastructure Services.","In the Collaboration Synchronization Service area:","In the Synchronization Interval field, enter the interval when the collaboration synchronization service runs. The synchronization service deletes documents and workflows for deleted projects.","The default value is 1h.","Enter a value between 1m and 24d20h31m23s647.","Configuring Collaboration Synchronization Service in Services Settings","51642.htm");
Page[81]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you want to apply the service immediately, you should set the Interval low. Remember that if the server is actively applying the service, all users will experience delays in the application.","To set your asynchronous jobs service settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Services, then expand Publication and select Infrastructure Services.","In the Asynchronous Jobs.","In the Purge Interval field, enter how often to remove long running job records from the database.","The default value is 1h.","Enter a value between 1m and 24d20h31m23s647.","In the Grace Time field, enter the minimum age of long running job records removed during purge.","The default value is 1d.","Enter a value between 0 and 24d20h31m23s647.","Configuring Asynchronous Jobs in Services Settings","51643.htm");
Page[82]=new Array("If you are running services and P6 on the same server, you should keep the defaults. If you want to apply the cache immediately, you should set the Frequency low. Remember that if the server is actively applying the cache, all users will experience delays in the application.","To set your project hierarchy cache settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expandServices, then expand Publication and select Infrastructure Services.","In the Project Hierarchy Cache area:","Select Enable WBS Hierarchy Preload.","Oracle recommends keeping this setting selected for most situations since security checks rely on the WBS Hierarchy cache preload. ","Leave this field clear only if you are loading project details (for example, an API request) and the preloading cache with WBS Hierarchy details is taking a lot of time.","In the Cache Policy drop-down menu, select the cache policy to use. The cache policy determines how much data is in the cache and which data to remove to reclaim memory.","You can select one of the following:","FIFO&nbsp;First In First Out-projects are cleared from the cache in the same order they were added to memory.","LRU&nbsp;Least Recently Used projects are cleared from the cache before more recently used ones.","JVMM&nbsp;Java Virtual Machine Managed uses soft references to cache elements; memory used by soft references is reclaimed by the JVM as required.","PRR&nbsp;Projects are selected at random to be cleared from cache.","PRFIFO&nbsp;Periodic Refresh First In First Out is the same as FIFO, except policy is enforced based on MaintenanceFrequency.","PRLRU&nbsp;Periodic Refresh Least Recently Used is the same as LRU, except policy is enforced based on MaintenanceFrequency.","PRCC&nbsp;Periodic Refresh Clear Cache ignores CacheLimit to flush the entire cache, based on MaintenanceFrequency.","Note The default value is PRR.","In the Cache Limit field, enter the maximum number of projects stored in memory.","The default value is 5000.","Enter a value between 1000 and 30000.","In the Maintenance Frequency field, enter the frequency for applying the specified cache policy. If you apply the cache policy, the system can reclaim memory from the cache.","The default value is 5h.","Enter a value between 1m and 24d.","Configuring Project Hierarchy Cache in Services Settings","51641.htm");
Page[83]=new Array("To configure settings for P6 Pro Cloud Connect:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectP6ProCloudConnect.","Note Changes to these settings require you to restart the P6 server.","In the FetchSize field, enter the maximum number of rows gathered in a database block. The default value is 254. You can enter a value between 0 and 2147483647.","In the TaskMaxTime field, enter the maximum time allowed for a P6 Pro task to complete. A job consists of one or more P6 Pro tasks. The default value is 5m.","In the TransactionMaxInactiveInterval field, enter the timeout interval for an inactive session that has a pending database transaction. The default value is 15m.","In the SessionMaxInactiveInterval field, enter the timeout interval for an inactive session. The default value is 2h.","In the Mode drop-down menu, you can select Username Token Profile or SAML Token Profile. The default value is Username Token Profile.","Configuring P6ProCloudConnect Settings","85465.htm");
Page[84]=new Array("Configuring your Geo Code Provider settings will allow you to use the locations feature in P6. With the locations feature, you can assign locations to projects, activities, and resources so you can later report in Analytics based on geographical location.","To set your GeoCodeProvider settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectGeoCodeProvider.","Note Changes to these settings require you to restart the P6 server.","In the GeoCodeProvider drop-down menu, select your provider:","Oracle GeoCoder","Third Party Geocoder","None","In the Geocode Provider URL field, enter the URL for your geocode provider.","Note The P6 server may have trouble starting if it cannot connect to the Geo Code URL. On the machine where you installed P6, test the URL in a browser to ensure you can connect before you enter the URL in this setting.","For the Oracle GeoCoder, the default value is http://elocation.oracle.com/geocoder/gcserver.","For a third-party geocoder, use the URL associated with your geocoder.","Note If you use the Oracle GeoCoder, you must also set your Web Proxy Server to www-proxy.us.oracle.com on the Web Proxy page for your configuration.","Configuring GeoCodeProvider Settings","51697.htm");
Page[85]=new Array("To configure P6 Integration API and P6 to work together, you will need to set the P6 Integration API settings in the Primavera P6 Administrator.","Note For more information on the Primavera P6 Administrator see Primavera P6 Administrator Setup Tasks.","To set your Integration API server settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectIntegration API Server.","In the Session Timeout field, enter the number of minutes when an idle connection will end.","The default value is 120 minutes.","Enter a value between 1 second and 24 days.","In the Security Authenticate Mode field, select one of the following modes:","Username Token Profile","SAML Token Profile","The default value is Username Token Profile.","To configure RMI settings:","Select Enable to enable the RMI server. You only need to enable the RMI server if you are using P6 Integration API.","P6 Integration API supports three modes. Depending on the mode you are using, do one of the following:","Select Enable Standard Service to enable Standard service mode.","Select Enable SSL to enable SSL service mode.","Select Enable Compression to enable compression service mode.","In the Registry Port field, enter the port for the RMI Registry. The default value is 9099.","Depending on which mode you enable, set the corresponding port for that mode:","In the Standard Service Port field, enter the port to use for Standard service mode. A setting of 0 indicates that any available port will be used. If the server will be accessed across a firewall, you must set this to a specific port.","The default value is 0.","In the SSLServicePort field, enter the port to use for SSL service mode. A setting of 0 indicates that any available port will be used. If the server will be accessed across a firewall, you must set this to a specific port. ","The default value is 0.","In the Compression ServicePort field, enter the port to use for Compression service mode. A setting of 0 indicates that any available port will be used. If the server will be accessed across a firewall, you must set this to a specific port. ","The default value is 0.","In the File Location field, enter the full path to the Keystore file.","In the Keystore Password field enter the Keystore password.","Configuring Integration API Server Settings","51649.htm");
Page[86]=new Array("One P6 EPPM Web Services server instance can control more than one database and you can specify an authentication mode for a database through the Authentication Configuration wizard. ","You can use the Primavera P6 Administrator to set the authentication mode, token profiles and message protection settings. If you use SAML for P6 EPPM Web Services, you must use Single Sign-On or LDAP authentication for P6 EPPM. You must configure additional settings for LDAP authentication with secure communication (SSL) between the P6 EPPM Web Services server and the LDAP server. ","To configure P6 EPPM Web Services and P6 to work together, you must set the P6 EPPM Web Services settings in the Primavera P6 Administrator.","The server can be configured to authenticate user credentials using the following methods:","Oracle Web Services Manager (OWSM)","Username Token Profile","Security Assertion Markup Language (SAML) 1.1 or 2.0","HTTP Cookies (on-premises only)","OAuth","If you select multiple authentication modes, priority is given in the order of the list above, with OWSM being the highest priority and Cookies being the lowest priority. For example, if you select both Username Token Profile and SAML, .","Note","A P6 EPPM Web Services configuration might include database instances that are not set to the same authentication mode as the P6 EPPM Web Services server. If a user connects and requests a database that is set to a different authentication mode than the P6 EPPM Web Services server, an error message displays. The user must select a database that matches the authentication mode set for the P6 EPPM Web Services server.","For more information on the Primavera P6 Administrator see Primavera P6 Administrator Setup Tasks.","See the P6 EPPM Web Services Programming Guide for more information about using P6 EPPM Web Services.","About Configuring P6 EPPM Web Services in the Primavera P6 Administrator","51698.htm");
Page[87]=new Array("To set your authentication mode:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expandWeb Services, then expand Security and select Authentication.","On the Authentication page, select the methods you want to allow clients use for authentication. The default value is Username Token Profile. You can select multiple authentication modes.","Note If you select OWSM as the authentication mode for P6 EPPM Web Services, only OWSM authentication can be used. OWSM receives the authentication request and will perform the authentication instead of passing the authentication request to P6 EPPM Web Services.","The available authentication modes are:","Username Token Profile - SOAP and REST: This mode defines how a web service client application can supply a user name and an optional password in the message request that the web service server can use to authenticate the requester's identity.","SAML Token - SOAP: Security Assertion Markup Language (SAML) defines an XML-based mechanism for exchanging messages that contain security information in the form of assertions.","Cookies - SOAP: This option requires you to call the Authentication service Login operation to establish a session and obtain a cookie before you can use any other P6 web service.","OWSM - SOAP: This option lets you use Oracle Web Services Manager to manage P6 EPPM Web Services security policies and to monitor authentication and authorization attempts.","OAuth - SOAP and REST: This option uses a private key corresponding to a public certificate for generating user assertions and access tokens.","Note","See the P6 EPPM Web Services Programming Guide for more information.","Changes to this setting require you to restart the P6 server.","Configuring Authentication Mode for P6 EPPM Web Services","51654.htm");
Page[88]=new Array("To set your Username Token Profile settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Web Services, then expand Security and select Authentication.","Expand Username Token Profile:","In the Nonce area:","Select Require Nonce to enable nonce.","Nonce is a token that contains a random value and is used to prevent attacks.","In the Nonce Cache Timeout field, enter the value for the Nonce cache timeout. The value specified indicates how long the nonce remains cached before it is deleted.","The default value is 10m.","Enter a value between 5m and 24d.","In the Created area:","Select Require Created to enable the Username token timestamp.","Requiring a Created element allows the server to determine whether the difference between two timestamps falls within an allowable window of time and can then reject any messages that exceed the window. ","In the Timeout field, enter the value for the Created timestamp timeout. You can specify a minimum of 5m.","The default value is 10m.","Enter a value between 5m and 24d.","Configuring Username Token Profile Settings for P6 EPPM Web Services","51655.htm");
Page[89]=new Array("To set your SAML Token Profile settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expand Web Services, then expand Security and select Authentication.","Expand SAML Token Profile:","Select Require Signed SAML Token to require signed SAML tokens or false to require unsigned SAML tokens.","In the SAML Version field, select one of the following:","1.1","2.0","Both","To configure SAML tokens settings, in the SAML Tokens area:","Select Disable Timeout to use Issue Instant Timeout and Authentication Timeout fields.","In the Issuer field, enter the valid issuer for the SAML token. Use a space to separate multiple valid issuers. For example, ","http://your.saml.issuer.com","In the Issue Instant Timeout field, enter the value for the Issue Instant timeout. The value specified indicates the maximum time allowed between the time the token is issued and the time the token is received by the web service.","The default value is 5 minutes.","Enter a value between 5 minutes and 24 days.","In the AuthenticationInstant Timeout field, enter the value for the Authentication Issue Instant timeout. The value specified indicates the maximum time allowed between the time the token is issued, the time the user is authenticated, and the time the token is received by the web service.","The default value is 5 minutes.","Enter a value between 5 minutes and 24 days.","To configure Signed SAML Tokens settings:","In the KeyStore Type list, select the KeyStore type.","The default value is JKS. JCEKS is also supported.","In the File Location field, enter the absolute path to the keystore file. This file must exist on the local file system. For example, ","c:\\keystore\\keystore.jks","In the Keystore Password field, enter keystore password.","In the Certificate Alias field, enter alias for the client certificate containing the public key.","The default value is alias.","In the Private Key Alias field, enter the alias for the private key.","The default value is privatekeyalias.","In the Private Key Password field, enter the password for the private key alias.","Configuring SAML Token Profile Settings for P6 EPPM Web Services","51656.htm");
Page[90]=new Array("To set your message protection settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar expandWeb Services, then expand Security and select Message Protection.","Select Require Timestamp if incoming SOAP messages must contain the WS-Security Timestamp.","Select Require Digital Signatures for Incoming Messages to require that incoming SOAP messages are signed and conform to Web Service Security 1.1 standards.","Note To access Web Services, you must configure all Web Services settings to get encryption and digital signatures to work. If you do not want to use encryption or digital signatures, you must set this setting and the Require Encryption setting to false.","Select Require Encryption for Incoming Messages to require incoming SOAP messages are encrypted and conform to Web Service Security 1.1 standards. When this setting is selected, at least one element in each P6 EPPM Web Services request message must be encrypted. ","Note","To access Web Services, you must configure all Web Services settings to get encryption and digital signatures to work. If you do not want to use encryption or digital signatures, you must set this setting and the Require Encryption setting to false.","When the Encrypt Response setting and the Require Encryption for Incoming Messages setting are both set to true, the server encrypts everything inside of the body element of P6 Web Services response messages.","When the Encrypt Response setting is Encrypt only if request is encrypted and Require Encryption for Incoming Messages setting is set to true, the server encrypts everything inside of the body element of P6 Web Services response messages.","When the Require Encryption for Incoming Messages setting is set to false, both encrypted and un-encrypted incoming messages are accepted. This setting provides flexible interoperability with multiple Web Services clients simultaneously, without compromising security.","In the Encrypt Response list, select the encryption response options for outgoing messages. This setting governs when responses will be returned as encrypted.","The default value is Encrypt only if request is encrypted.","In the Key Store Type list, select the key store type.","The default value is JKS.","In the File Location field, enter the absolute path to the key store file. This file must exist on the local file system. For example, ","c:\\keystore\\keystore.jks","In the Keystore Password field, enter key store password.","In the Private Key Alias field, enter alias for the private key in key store.","The default value is alias.","In the Private Key Password field, enter password for the private key. ","Note","When the Encrypt Response setting and the Require Encryption for Incoming Messages setting are both set to true, the server encrypts everything inside of the body element of P6 Web Services response messages.","When the Encrypt Response setting is Encrypt only if request is encrypted and Require Encryption for Incoming Messages setting is set to true, the server encrypts everything inside of the body element of P6 Web Services response messages.","When the Require Encryption for Incoming Messages setting is set to false, both encrypted and un-encrypted incoming messages are accepted. This setting provides flexible interoperability with multiple Web Services clients simultaneously, without compromising security.","Configuring Message Protection Settings for P6 EPPM Web Services","51657.htm");
Page[91]=new Array("Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectTeam Member if you want to alter the following default values:","Note Changes to these settings require you to restart the P6 Team Member server.","Initial connection pool size: 10","Maximum active database connections: 150","Maximum idle database connections: -1","Minimum idle database connections: 10","Enabled: Selected","Severity Level: Error","Note Other Severity Level options include the following:","off","fatal","warn","info","debug","trace","all","Log File Name: p6tmweb.log","Configuring P6 Team Member Settings","89732.htm");
Page[92]=new Array("Diagnostics Settings allows you to track specific tasks that could be causing your application to run slowly. ","To set your diagnostics settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar selectDiagnostics.","Note Changes to these settings require you to restart the P6 server.","To configure Metrics Collector settings:","Select Metric Collection if you want poorly performing issues to be tracked. The default value is unselected.","ThresholdLimit is the amount of time a browser request pends before being tracked as a poorly performing issue. The default value is 5 milliseconds. ","CollectionSize is the number of poorly performing issues that are tracked. The default value is 100. ","Note","The number entered for ThresholdLimit should be set to the average processing time of the application.  ","When the time taken to complete a browser request exceeds the ThresholdLimit, the task is tracked as poorly performing issue. ","CollectionSize can be adjusted based on the amount of memory in your machine. 100 is the average for a machine with 8GB of RAM available. Oracle recommends using the default value of 100 tracked issues. ","To configure Tracer settings:","Select Enable to send debugging messages to the Tracer application. Leave this option clear if you do not want debugging messages sent.","Select Use Background Send Thread to use the background thread to send TCP messages to tracer. Leave this option clear if you don't want to use the background thread to send TCP messages.","In the Server Name field, enter the destination IP address or hostname for sending tracer information.","The default value is localhost.","In the Port field, enter the port to use for the Tracer socket connection.","The default value is 9210.","Configuring Diagnostics Settings","90461.htm");
Page[93]=new Array("This chapter describes the authentication modes for P6 EPPM and outlines the steps required to implement an authentication scheme. It also details steps on how to import user information from an LDAP server.","Note If you are using LDAP, you need to verify your field mappings and alter them to match the fields for your LDAP environment. See Provisioning LDAP User Information for the First Time for details.","Authentication in P6 EPPM","89756.htm");
Page[94]=new Array("To manage how users can access your applications, use authentication and authorization mechanisms. Authentication is the process of validating user identity and authorization is how you control what resources and data your users can access.","P6 uses multiple settings to support authentication. These settings also control the authentication used for all P6 EPPM applications except P6 EPPM Web Services. You set authentication settings in the Primavera P6 Administrator's Authentication tab. ","P6 EPPM supports these authentication modes:","Native is the default mode for P6 EPPM. In Native mode, the P6 EPPM database acts as the authority and the application handles the authentication of the user who is logging into that application.","Single Sign-On (SSO) controls access to Web applications. In SSO mode, the applications are protected resources. When a user tries to log in, a Web agent intercepts the request and prompts the user for login credentials. The Web agent passes the user's credentials to a policy server, which authenticates them against a user data store. With SSO, once the users log in, they are logged in to all Web applications during their browser session (as long as all Web applications authenticate against the same policy server). ","Lightweight Directory Access Protocol (LDAP) authenticates users through a directory and is available for all applications. You can use LDAP referrals&nbsp;with Oracle Internet Directory and Microsoft Windows Active Directory. LDAP referrals allow authentication to extend to another domain. You can also configure multiple LDAP servers, which supports failover and enables you to search for users in multiple LDAP stores. An LDAP directory server database confirms the user's identity when they attempt to login to the application.","Note For Oracle Internet Directory, referrals only work when you configure the directories to search anonymously.","Regardless of the authentication scheme you choose, the P6 EPPM database controls user authorization.","Authentication Modes in P6 EPPM","7634.htm");
Page[95]=new Array("To specify the authentication scheme you want to use for P6 EPPM applications, use the P6 EPPM Authentication tab of the Primavera P6 Administrator. Although you specify authentication modes for client/server applications and Web applications separately, you must use a consistent authentication scheme within P6 EPPM. For example, client/server and Web applications must both&nbsp;be configured for either LDAP authentication or native authentication.","Authentication mode is database-driven, so the configuration utility enables you to first specify a database connection setting, then choose authentication modes for the applications that access that database.","For LDAP authentication, the configuration utility also enables you to specify LDAP servers, map LDAP attributes to P6 EPPM database fields, and provision users.","Choosing an Authentication Scheme","38149.htm");
Page[96]=new Array("The authentication modes have different login procedures:","In Native mode","P6 EPPM presents a login dialog box that prompts for a user name and password. Depending on whether you enabled the password policy option in Application Settings in P6, the user may have to create a strong password.","In LDAP mode","All P6 EPPM applications require a login password.","Since the LDAP directory stores and authenticates passwords, users cannot change their passwords in P6 EPPM.","In Single Sign-On mode","For P6, the Single Sign-On server requests and validates login credentials. Once a user is authenticated, the launch page for P6 appears so the user can select a database and language.","Users cannot change their passwords in P6 EPPM because passwords are stored and authenticated against a directory server user store.","Login Procedures and Authentication in P6 EPPM","7665.htm");
Page[97]=new Array("By default, all P6 EPPM applications use Native authentication. After you install your P6 EPPM applications, you can choose a different authentication scheme.","Note If you are upgrading from a previous version of P6 EPPM, see the P6 EPPM Upgrade and Configuration Guide before modifying the authentication settings.","Your database controls your Authentication mode. ","When using SSO mode, P6 Integration API and P6 EPPM Web Services use LDAP mode.","If using LDAP authentication, you can specify LDAP servers, configure more than one LDAP server for each database instance, map LDAP attributes to P6 EPPM database fields, and provision users.","Follow the guidelines below to specify an authentication scheme and perform additional configuration tasks for authentication:","Configure administrative settings using the Primavera P6 Administrator. See About the Authentication Tab in the Primavera P6 Administrator for details on these settings.","When using LDAP mode, provision user information from the LDAP server using P6. See Provisioning LDAP User Information for the First Time for details.","Configure Oracle Analytics Publisher to use with P6 when using LDAP or SSO mode. See the P6 EPPM Oracle Analytics Publisher Configuration Guide for more information.","Tip","If multiple instances within a configuration point to the same database, P6 EPPM will use the Authentication Mode for the first instance in the list.","To enable you to configure more than one LDAP server for each database instance, you can set multiple LDAP Connection Settings for authentication. Right-click the LDAP Connection Settings folder to duplicate, delete, copy, paste, or test a configuration. When P6 authenticates a user, it will search each LDAP server in order for a user name that matches the login name and will use the first matching user to verify the password.","A configuration for P6 might include database instances that are not set to the same authentication mode as the P6 server. If a user connects and requests a database that is set to a different authentication mode than the P6 server, an error message will display; the user must select a database that matches the authentication mode set for the P6 server.","Authentication Configuration Process in P6 EPPM","7637.htm");
Page[98]=new Array("The information below details all settings available from the Authentication tab of the Primavera P6 Administrator.","Note","See the procedures in the P6 EPPM Installation and Configuration Guide if you are upgrading from a previous version of P6 EPPM software before modifying the authentication settings.","See Authentication in P6 EPPM for an overview of the authentication configuration process and instructions on how to provision LDAP user information.","If you are using LDAP, you need to verify your field mappings and alter them to match the fields for your LDAP environment. See Provisioning LDAP User Information for the First Time for details.","About the Authentication Tab in the Primavera P6 Administrator","51707.htm");
Page[99]=new Array("Single Sign-On (SSO) controls access to Web applications. In SSO mode, the applications are protected resources. When a user tries to log in, a Web agent intercepts the request and prompts the user for login credentials. The Web agent passes the user's credentials to a policy server, which authenticates them against a user data store. With SSO, once the users log in, they are logged in to all Web applications during their browser session (as long as all Web applications authenticate against the same policy server). ","To set your web Single Sign-On settings:","Open the Primavera P6 Administrator.","In the Authentication tab, select your configuration from the drop-down list.","SelectAuthentication.","In the Login Mode drop-down list, select WebSSO.","To configure Web Single Sign-On settings:","Note","Changes to these settings require you to restart the P6 server.","Select Allow Alternate Login Attribute when using Oracle Single Sign-On, and you want to use an SSO login attribute other than the P6 user name. For example, you will enter your email address when authenticating Oracle Single Sign-On, but your P6 user name will map to the LDAP's UID field.","In the User Name Header Key field, enter the name of the HTTP Header you specified in the policy server.","The value you specify must match the property you created under the policy domain/realm,&nbsp;where the Web server for P6 resides. ","For Oracle Single Sign-On, the value should be Proxy-Remote-User. The Proxy-Remote-User should match the LDAP server attribute that maps to the P6 EPPM database USER_NAME field. See Provisioning LDAP User Information for the First Time for details.","For Oracle Access Manager, the value should be OAM_REMOTE_USER, which is the default value.","In the Context Path Override field, enter the path used to pass web requests from the Single Sign-On Web server to the P6 server. The default listed is the value for P6 (/p6).","Note","If you enable the Allow Alternate Login Attribute setting, you must configure the Header Key and LDAP Search Attribute settings. You must also configure the LDAP settings for the appropriate database instance to establish a connection to the LDAP server. See Provisioning LDAP User Information for the First Time for details.","In the Header Key field, enter the HTTP Header Key which contains the global user ID. The default value is Osso-User-Guid.","In the LDAP Search Attribute field, enter the LDAP attribute searched by the Header Key to authenticate users. The default value is orclguid.","Note You must configure the LDAP settings for the appropriate database instance to establish a connection to the LDAP server.","Configuring Web Single Sign-On Settings in the Primavera P6 Administrator","51658.htm");
Page[100]=new Array("Lightweight Directory Access Protocol (LDAP) authenticates users through a directory and is available for all applications. You can use LDAP referrals&nbsp;with Oracle Internet Directory and Microsoft Windows Active Directory. LDAP referrals allow authentication to extend to another domain. You can also configure multiple LDAP servers, which supports failover and enables you to search for users in multiple LDAP stores. An LDAP directory server database confirms the user's identity when they attempt to login to the application.","To set your LDAP settings:","Open the Primavera P6 Administrator.","In the Authentication tab, select your configuration from the drop-down list.","SelectAuthentication.","In the Login Mode drop-down list, select LDAP. ","To configure LDAP settings:","Note Changes to these settings require you to restart the P6 server.","In the SSL Certificate Store field, enter the full path to the keystore that holds the SSL certificate for the LDAP server.","In the SSL Store Password field, enter the password for the keystore that holds the SSL certificate.","Configuring LDAP Settings in the Primavera P6 Administrator","51659.htm");
Page[101]=new Array("Native is the default mode for P6 EPPM. In Native mode, the P6 EPPM database acts as the authority and the application handles the authentication of the user who is logging into that application.","To set your HTTPS settings:","Open the Primavera P6 Administrator.","In the Authentication tab, select your configuration from the drop-down list.","SelectAuthentication.","In the Login Mode drop-down list, select Native.","To configure HTTPS settings:","Note Changes to these settings require you to restart the P6 server.","Select Enable HTTPS if users do not use an HTTPS URL for the login page. If selected, P6 redirects the users to an HTTPS login page to complete the login process. You must enable SSL communication for the application server or web server.","Leave this option clear if you do not want users redirected to an HTTPS URL for login.","Caution If kept as clear, the application server will receive the passwords as clear text when a user logs in to the application.","Note If you have problems accessing the P6 application and you enabled this setting, you will need to verify that you enabled the SSL listen port on your application server and that it matches the Authentication/HTTPS/Port setting below. You should also check the WebAccessLog to ensure there is not an &quot;SSL disabled&quot; error message.","In the Port field, enter the port number used for SSL. You must enter the port number only if you enable the HTTPS option. ","The default value is 443. ","Enter a value between 0 and 2147483647.","Configuring HTTPS Settings in the Primavera P6 Administrator","51660.htm");
Page[102]=new Array("To set your database instance settings:","Open the Primavera P6 Administrator.","In the Authentication tab, select your configuration from the drop-down list.","Select your Database Instance.","In the Authentication Mode drop-down list, select one of the following authentication modes:","Note Changes to this setting require you to restart the P6 server.","Native","WebSSO","LDAP","Note Other authentication modes available in this list are used for P6 EPPM Cloud Service.","For more information about each authentication mode, refer to Authentication Modes in P6 EPPM.","Configuring Database Instance Settings in the Primavera P6 Administrator","51661.htm");
Page[103]=new Array("To provision LDAP user information for P6 EPPM for the first time:","Caution Ensure that all users are logged out of P6 EPPM to ensure the Primavera P6 Administrator saves your new settings.","Note Verify your default global profile; the global profile will be assigned to all provisioned users.","Log in to the Primavera P6 Administrator. See Primavera P6 Administrator Setup Tasks for details.","From the Authentication tab:","Select Authentication and ensure that Login Mode is set to NATIVE.","Select Database instance and ensure that Authentication Mode is set to Native.","Restart the application server instance.","NoteIf you do not restart the application server instance, the Primavera P6 Administrator will restore settings to the previous configuration.","Log in to P6 as a user with privileges to create a new user.","Follow the instructions in the Creating User Accounts for P6 EPPM section of the P6 EPPM Application Administration Guide to add a new user (in Native mode) that matches an LDAP server user with rights to read the LDAP directory.","Note Ensure that you have a P6 user and LDAP user that match.","Assign a global profile that contains privileges to add new users and search the LDAP directory. See the Configuring User Access section of the P6 EPPM Application Administration Guide for details.","Assign the appropriate project profiles and module access. See the Configuring User Access section of the P6 EPPM Application Administration Guide for details.","Log in to the Primavera P6 Administrator.","From the Authentication tab:","Select your configuration.","Change Login Mode to LDAP.","Select your Database instance and set Authentication Mode to LDAP.","To configure your LDAP Connection Settings[n].","Select Enable SSL if you are using SSL.","Select Chase Referrals to enable chase referrals.","In the Host field, enter the host name of your LDAP server.","In the Port field, enter the port number of your LDAP server. The default value is 636.","In the Username field, enter the LDAP user name that has privileges to log in to the LDAP server and perform LDAP searches.","In the Password field, enter the password for the user name you entered above.","In the Base Directory Node field, enter the base directory node string that represents where the LDAP tree should search during login or provisioning. For example:","dc=ad, dc=Marketing, dc=CompanyABC, dc=com","In the Preferred Pool Size field, enter the preferred pool size. The default value is 10.","In the Maximum Pool Size field, enter the maximum pool size. The default value is 20.","In the Connection Timeout (in seconds) field, enter how long (in seconds) the system should try to connect to the LDAP before timing out. The default value is 300.","Expand Field Map.","Note Except where noted, these settings represent what you will enter for an Oracle Internet Directory (OID) LDAP server and a Microsoft Active Directory. ","In the Username field, enter the LDAP field name that holds the user's login ID. For example:","uid","or","samaccountname (for Microsoft Active Directory)","In the Email ID field, enter the LDAP field name that holds the user's email address. For example:","mail","In the Actual Name field, enter the LDAP field name that holds the user's full name. For example:","cn","or","displayname (for Microsoft Active Directory)","In the Office Phone field, enter the LDAP field name that holds the user's phone number. For example:","telephoneNumber","Select Test Connection.","Click Save Changes.","Restart the application server instance.","NoteIf you do not restart the application server instance, the Primavera P6 Administrator will restore settings to the previous configuration.","Log in to P6 as the new user you created when you were in Native mode.","On the Users page, click the@&nbsp;Add icon and do the following:","Add users as described in &quot;Adding Users in LDAP or SSO Authentication Mode&quot; in the P6 EPPM Application Administration Guide for details.","If needed, change the configuration settings for the new users. See &quot;Configuring User Access&quot; in the P6 EPPM Application Administration Guide for details.","Tip","When you provision users, changed records are updated in the P6 EPPM database and new users are added. However, users that have been deleted from the LDAP directory or LDIF file are not automatically removed from the P6 EPPM database. You must manually delete these users.","You can copy a current user's settings to all the new users you create when you bring them in from LDAP.","Provisioning LDAP User Information for the First Time","32757.htm");
Page[104]=new Array("This section has information about how to setup your P6 deployment for end-users, such as:","Precompiling the application","Application access information","Client and Browser configuration settings","Using Oracle Secure Global Desktop","Server plug-ins","Also, this section provides information on how you can change the application's database connection and configure a separate server for Job Services.","P6 Setup Tasks","90248.htm");
Page[105]=new Array("Although not required for P6, precompilation helps to reduce the amount of time it takes for users to load P6 pages for the first time. The following instructions apply to all application servers supported by P6 EPPM. You need to perform these instructions while the application server is running.","Note Your application server must be listening on a HTTP port (non-SSL) for the precompile utility to work. You can later disable the HTTP port after precompilation if you will be using only HTTPS.","To precompile P6:","Locate the precompile_utility folder. It will be in the location where you installed P6 EPPM. For example:","C:\\P6EPPM_1\\p6\\precompile_utility (with Windows)","/usr/P6EPPM_1/p6/precompile_utility (with UNIX or Linux)","Run a command similar to the following:","java -jar JSPPrecompile.jar -u &lt;baseURL&gt; -f &lt;inputfile&gt;","where &lt;baseURL&gt; is the P6 URL and &lt;inputfile&gt; is the location of the P6 EAR file.","Note The file path of the P6 EAR file cannot contain spaces.","For example, the command should look similar to the following if you have a standard P6 installation on WebLogic:","If you deployed P6 in WebLogic:","java -jar JSPPrecompile.jar -u http://localhost:7001/p6&nbsp;-f &lt;p6home&gt;/p6.ear","where &lt;p6home&gt; is the location you installed P6. For example, C:\\P6EPPM_1\\p6\\p6.ear or /usr/P6EPPM_1/p6/p6.ear.","If you used the P6 EPPM Configuration Wizard to deploy P6:","java -jar JSPPrecompile.jar -u http://localhost:8203/p6&nbsp;-f p6home/p6.ear","where p6home is the location where you installed P6. For example, C:\\P6EPPM_1\\p6\\p6.ear or /usr/P6EPPM_1/p6/p6.ear.","Precompiling P6","7312.htm");
Page[106]=new Array("To access P6 from Client Browsers using WebLogic:","Launch a supported browser. ","Enter the URL using the structure,","http://serverIP:listenport/ContextRoot/login","where listenport is 7001 (if you manually deployed P6) or 8203 (if you used the wizard to deploy P6) by default and ContextRoot is p6 by default.","Examples: ","http://serverIP:7001/p6/login","http://serverIP:8203/p6/login","Tip","HTTPS settings are available in the Primavera P6 Administrator. If you have set the HTTPS/Enabled setting to true, ensure that your application server or front-end Web server is listening on the specified HTTPS port. See Configuring HTTPS Settings in the Primavera P6 Administrator for more information on the HTTPS settings.","To select the authentication mode for P6, use the Primavera P6 Administrator. See About the Authentication Tab in the Primavera P6 Administrator for information about authentication configuration settings.","On the P6 login window, SSO users can choose to bypass the login window the next time by selecting the appropriate option. See Configuring Application Settings in the Primavera P6 Administrator for more information.","You can modify the context root. For information about context root configuration, refer to your application server documentation. Also, URLs might be case-sensitive, depending on your application server configuration.","See Tested Configurations for a list of supported application servers with version numbers.","For a full list of tested configurations for P6, see Tested Configurations.","Accessing P6 from Client Browsers using WebLogic","14384.htm");
Page[107]=new Array("Features, such as exporting to Excel and resolving null pointer exceptions, require additional configuration settings on client machines. Some settings are required for a feature to work, while others are only necessary under certain conditions. You must configure your settings on each client machine requiring access to the feature.","Configuring Settings on Client Machines","7319.htm");
Page[108]=new Array("Note Before you begin, ensure you are using the supported version of Mozilla Firefox. See the Tested Configurations document for more information.","Open Mozilla Firefox.","Go to Tools, Options.","In the Options dialog box:","Select the Security tab.","Select the Warn me when sites try to install add-ons option.","Select the Content tab.","Deselect the Block pop-up windows option.","Click OK to save your options and close the dialog box.","Configuring Browser Settings for Mozilla Firefox","78596.htm");
Page[109]=new Array("Note Before you begin, ensure you are using the supported version of Safari. See the Tested Configurations document for more information.","Open Safari.","From the Settings drop-down, select Preferences.","In the General dialog box, select Security.","In the Web Content section:","Select the following:","Enable Plug-ins","Enable Java","Enable JavaScript","Deselect Block pop-up windows.","Select Advanced.","Select Press Tab to highlight each item on a webpage.","Close the dialog box. ","Tip","Complete the following steps to enable the Java plug-in:","From the Settings drop-down, select Preferences.","In the General dialog box, select Security.","In the Java section, select Run in Unsafe Mode for the P6 URL.","Configuring Browser Settings for Safari","78341.htm");
Page[110]=new Array("You can use Oracle Secure Global Desktop to publish P6 EPPM and P6 Professional to remote users.","See the Tested Configurations document for supported versions of Oracle Secure Global Desktop.","For details on publishing Windows desktops, see the Oracle Secure Global Desktop Administration Guide. You will find the Secure Global Desktop documentation library here: http://www.oracle.com/technetwork/documentation/sgd-193668.html.","Using Oracle Secure Global Desktop","62800.htm");
Page[111]=new Array("Application servers offer a variety of plug-ins that enable you to configure a front-end Web server other than the one provided with the application server. For procedures on configuring a Web server plug-in, refer to the application server's documentation.","Application Server Plug-Ins for P6 EPPM","7328.htm");
Page[112]=new Array("The Database Configuration wizard enables you to change the database connection settings you specified when you installed P6.","The database you select during configuration stores one or more P6 EPPM configurations, each one specifying a set of parameters that determine how P6 operates. During configuration, you select an existing P6 EPPM configuration or create a new one. Later, you can use the Database Configuration wizard to select a different P6 EPPM configuration or create a new one. ","Note","After selecting a different P6 EPPM configuration or creating a new configuration, you must stop and restart the P6 application server for the changes to take effect.","You should protect the Database Configuration file (dbconfigpv) for security reasons. Depending on which method you used to protect the file, you might have to relocate the file to the production server to run the wizard after implementation. See &quot;Files to Protect after Implementation&quot; in the P6 EPPM Security Guide.","About the Database Configuration Wizard for P6","34047.htm");
Page[113]=new Array("To change database connection settings for P6:","Do one of the following:","On Windows platforms, run dbconfigpv.cmd (located in the p6home directory that you specified when installing P6).","On UNIX platforms, change to the p6home directory that you specified when installing P6, and run dbconfigpv.sh.","On the Setup and Configuration of the Primavera P6 Database dialog box, select the database type.","On the Please enter the following information. . . dialog box:","Specify the database connection parameters. Type your database user name (for example, pubuser) and password, the database name, host address, and host port. The database name, host address, and host port are specific to your database installation. The Database Host Port field displays the default port for the database type you selected. You can edit this port.","To use the SSL protocol to securely communicate between the P6 application server and the database server, select the SSL option. If you select the SSL option, you must specify an SSL-enabled port number in the Database Host Port field.","Note","See the appropriate database server documentation and the My Oracle Support's Knowledge Articles for information on configuring SSL.","Using the SSL protocol will impact database performance.","Ensure that the Public Group ID is 1 for a standard configuration.","If there is an existing Primavera configuration, on the The installer has detected. . . dialog box, choose whether you want to use it, or create a new configuration.","Note","If you are upgrading from a previous version of P6 against the same database, choose the option to create a new configuration. This is necessary to accommodate newly added configuration settings. See Primavera P6 Administrator Setup Tasks for more information about configurations.","If you have not created a Primavera configuration, the The installer has detected. . . dialog box does not appear and the installation process automatically creates a default configuration named Primavera P6 Configuration. You can edit the settings for this configuration through the Primavera P6 Administrator.","When the message displays to confirm that the database configuration has completed successfully, click OK.","On the End of Installation screen, click Exit.","Changing Database Connection Settings for P6","14395.htm");
Page[114]=new Array("For medium to large deployments, Oracle recommends setting up a dedicated node for job services, and disabling job services from running on servers accepting user traffic. ","Note","For details on what constitutes a medium or large deployment, see the P6 EPPM Performance and Sizing Guide.","These instructions assume that you have already configured the server accepting user traffic.","Oracle provides the following options to configure a dedicated node for job services:","Standalone deployment of p6services.jar. This option provides a simple installation process and runs the job services from an independent java process. See Configuring a Job Services Server Using p6services.jar","Application Server deployment of p6jobservices.war: This option provides the advantages of deployment to an application server, including remote monitoring of the health of the server, remote management of the server lifecycle, and improved error logging. This option runs job services from an application server instance that will not accept user traffic. See Configuring a Job Services Server Using p6jobservices.war","Configuring a Separate Server for Job Services","98910.htm");
Page[115]=new Array("Follow the guidelines below to configure the dedicated job services server using p6services.jar:","Copy the p6services.jar from the p6home directory where you installed P6 to a node that will use job services.","Ensure a supported JRE is in the system path. (See the Tested Configuration for supported JREs.)","Open a new command line or terminal window.","Navigate to the folder where p6services.jar was copied (for example, c:\\jobservices).","Run the services application by entering java -Xms&lt;MEMORY SIZE&gt; &#8211;Xmx&lt;MEMORY SIZE&gt; &#8211;jar p6services.jar in the window. (See the P6 EPPM  Performance and Sizing Guide for the correct value for the &lt;MEMORY SIZE&gt; setting for your environment. The settings in the example are the recommended values.) ","The line should look similar to the following:","java -Xms4096m &#8211;Xmx4096m &#8211;jar p6services.jar","If you are using Sun JDK, it should look similar to the following:","java -server -Xms4096m &#8211;Xmx4096m &#8211;jar p6services.jar","If a BREBootStrap.xml file is in the USER_HOME, you can specify the location to the BREBootstrap.xml file by adding the following line:","Note","USER_HOME refers to your home directory. For example, in Windows it could be C:\\Users\\&lt;USER_NAME&gt; or C:\\Documents and Settings\\&lt;USER_NAME&gt;; in UNIX, it could be /home/&lt;USER_NAME&gt;.","If this is the first time you are launching p6services.jar, and a BREBootStrap.xml file does not exist in the USER_HOME, the database configuration wizard will launch. Skip to the next step.","&#8211;Dprimavera.bootstrap.home=&lt;BOOTSTRAP_LOCATION&gt;","The line should look similar to the following:","java -Xms4096m &#8211;Xmx4096m &#8211;Dprimavera.bootstrap.home=&lt;BOOTSTRAP_LOCATION&gt; -jar p6services.jar","where &lt;BOOTSTRAP_LOCATION&gt; is the location where the BREBootStrap.xml is located (for example, C:/USER_HOME).","If your organization needs to use Unicode characters, add to the JAVA_OPTS variable -Dfile.encoding=UTF-8","The line should look similar to the following:","java -Xms4096m &#8211;Xmx4096m &#8211;Dprimavera.bootstrap.home=&lt;BOOTSTRAP_LOCATION&gt; -Dfile.encoding=UTF-8 -jar p6services.jar","where &lt;BOOTSTRAP_LOCATION&gt; is the location where the BREBootStrap.xml is located (for example, C:/USER_HOME).","If this is the first time you are launching p6services.jar, and a BREBootStrap.xml file does not exist in the &lt;USER_HOME&gt; directory (or &lt;BOOTSTRAP_HOME&gt; directory if the primavera.bootstrap.home is specified), the database configuration wizard will launch.","Follow the steps in Changing Database Connection Settings for P6.","Create a new configuration when The Installer has detected... dialog box appears and give this new configuration a distinct name. For example, if you chose &quot;P6 Users&quot; for the configuration name for the server accepting user traffic, name the new configuration &quot;P6 Job Services.&quot;","Note Create a new configuration for Job Services to ensure optimal database performance. Job Services could slow down performance if it is part of the same configuration.","In the Primavera P6 Administrator: ","Locate the Services/Enable All Services setting for the configuration created for the job services server (for example, P6 Job Services). Set the setting to true to enable all services.","Locate the Services/Enable All Services setting for the configuration created for user traffic (for example, P6 Users). Set the setting to false to disable all services.","Configuring a Job Services Server Using p6services.jar","47615.htm");
Page[116]=new Array("Note  These instructions assume that you have already installed and configured WebLogic Middleware and have deployed P6.  These instructions provide single WebLogic node deployment steps, but you can target the application to a WebLogic cluster.","Follow the guidelines below to configure a dedicated job services server using p6jobservices.war:","Create a new directory in the P6 EPPM installation folder for p6jobservices.","Copy the following files from the p6home directory where you installed P6 to the new directory you created in the previous step:","p6jobservices.war","adminpv.cmd or adminpv.sh","dbconfigpv.cmd or dbconfigpv.sh","installp6keystore.bat or installp6keystore.sh","p6keystore.jks","lib folder and all files","In the new directory:","Open adminpv.cmd or adminpv.sh in a text editor.","Change the PV_HOME environment variable to match the location of the new directory.","Change the JAVA_HOME environment variable to match the location of your JDK home directory.","Save changes and close the file.","Open dbconfigpv.cmd or dbconfigpv.sh in a text editor.","Change the PV_HOME environment variable to match the location of the new directory.","Change the JAVA_HOME environment variable to match the location of your JDK home directory. ","Save changes and close the file","Open installp6keystore.bat or installp6keystore.sh in a text editor.","Change the JAVA_HOME environment variable to match the location of your JDK home directory.","Save changes and close the file","Copy the new directory to a WebLogic node where you will deploy p6jobservices.war.  ","If the WebLogic Admin Server runs on a different physical node from your managed server, copy the directory to your admin server to deploy the application.","If the PV_HOME or JAVA_HOME directory path is different from the path you modified earlier, you must update the files to reflect the actual location on the new node.","Note If you deploy p6jobservices.war to a cluster, the directory must be present on all nodes in the cluster.","If you are using external encryption, generate a new password file for reading p6keystore.jks using the following command:","Windows: installp6keystore.cmd -genpassfile","Unix: ./installp6keystore.sh -genpassfile","Note For more information on encryption keys for P6 EPPM, see: External Storage Of Encryption Keys For P6 EPPM (KB610056) at https://support.oracle.com/support/?kmExternalId=KB610056","To create a BREBootStrap.xml file in the job services directory, run dbconfigpv.cmd or dbconfigpv.sh.","In the Database Configuration Wizard:","Select your database type, then click Next.","Enter the required information for connecting to your database, then click Next.","Select the option to create a new configuration for job services, then click Next.","Click OK.","Check that a BREBootStrap.xml file was created in the job services directory.","Note If you deploy p6jobservices.war to a cluster, you must create a BREBootStrap.xml file on all nodes of the cluster.  ","Create a new managed server in your WebLogic domain and set the following JVM parameters for the managed server:","-Xms&lt;MEMORY SIZE&gt; -Xmx&lt;MEMORY SIZE&gt;","For example: -Xms4096m &#8211;Xmx4096m","Note See the P6 EPPM  Performance and Sizing Guide for the correct value for the &lt;MEMORY SIZE&gt; setting for your environment. The settings in the example are the recommended values.","-Dprimavera.bootstrap.home=&lt;BOOTSTRAP_LOCATION&gt;","Where &lt;BOOTSTRAP_LOCATION&gt; is the location of the BREBootStrap.xml file.","-Dfile.encoding=UTF-8","This is required only if your organization needs to use Unicode characters.","Deploy p6jobservices.war to the managed server.","See the P6 EPPM WebLogic Configuration Guide.","Launch adminpv.cmd or adminpv.sh.","Select the configuration used by job services.","Expand Services and select General.","Select the Enable All Services option.","Select the configurations used by all other P6 EPPM web deployments and clear the Enable All Services option.","Restart all the deployments you changed.","When upgrading your P6 EPPM environment perform the following steps:","Replace the following files in the job services directory with the upgraded files from your p6home directory:","p6jobservices.war","lib folder and all files","Launch adminpv.cmd or adminpv.sh.","On the Configurations tab, right-click the job services configuration. ","Click Update to latest version.","Click Save Changes.","To redeploy the updated p6jobservices.war to your WebLogic environment:","Login to your WebLogic Administration Console.","In the Change Center pane, click Lock &amp; Edit. ","In the Domain Structure pane, click Deployments. ","In the Configuration tab on the Summary of Deployments page, click Update.","Click Finish.","Configuring a Job Services Server Using p6jobservices.war","98911.htm");
Page[117]=new Array("You can create custom URL so that users can directly access pages.","In order to create custom URLs, you must be a database user, such as privuser or admuser, that can make queries against the P6 EPPM database for project wbsids. If you do not have database access to P6 EPPM, refer to your P6 EPPM database administrator.","Users can only access custom URLs to access pages as long as they have Project module access and OBS access to projects and project templates. ","Any P6 EPPM user can use a custom URL, as long as they have Project module access. If the user does not have access to the projects listed in the URL, P6 EPPM will open to the Open Projects dialog box.","To create a custom URL:","Determine the base URL for your P6 EPPM instance. ","The base URL follows the format http://&lt;server&gt;:&lt;port&gt;/p6/bookmark?uri=navigatetopage&amp;ctx=","For example, http://corporatep6server:8203/p6/bookmark?uri=navigatetopage&amp;ctx=","Determine the wbs_ids of the projects that you want users to access by completing the following:","Log in to the P6 EPPM database with the following script and provide the relevant password when prompted:","sqlplus &lt;admuser or privuser&gt;@&lt;db_tns_names_entry&gt;","Run the following scripts for the project wbs_ids:","column wbs_short_name format a20","column wbs_name format a30","select pw.wbs_id, pw.proj_id, pw.wbs_short_name, pw.wbs_name from projwbs pw inner join project p on pw.proj_id=p.proj_id where pw.proj_node_flag = 'Y' and p.project_flag='Y' and orig_proj_id is null;","Note","In addition to returning wbs_ids and proj_ids, the last line of the script also returns the wbs_short_name and wbs_name in order to provide you more context for each wbs_id and proj_id that you return.","By default, the wbs_short_name and wbs_name have a length of 40 and 100 characters respectively. The first two lines of the script reduce the displayed characters of the wbs_short_name and wbs_name to 20 and 30 characters respectively in order to prevent the column length from overtaking the output.","Create a string of parameters and their values to describe the view. You must list the parameters in the order described in this step and separate the parameters with an ampersand. Do not include an ampersand after the last parameter. The parameters available are:","projectList: A comma-separated list of wbs_ids for the projects that you want to display.","For example, 3165,65422,984&amp;","key: Determines which page will be opened.","Supported values: activities","For example, key=activities&amp;","(Optional) showNavigation: Determines whether to show the header bar when P6 EPPM opens. If this parameter is not included or it is set to true, P6 EPPM opens with the header bar. If this parameter is set to false, P6 EPPM opens without the header bar.","Supported values: true or false","For example, showNavigation=false","Note Your string should be similar to projectList=3165,65422,984&amp;key=activities&amp;showNavigation=false","Percent-encode the string.","For example, you could use URL Encoder/Decoder at http://meyerweb.com/eric/tools/dencoder/.","Note After you percent-encode your string, the string should be similar to projectList%3D3165%2C65422%2C984%26key%3Dactivities%26showNavigation%3Dfalse","Append the string to the base URL.","For example: http://corporatep6server:8203/p6/bookmark?uri=navigatetopage&amp;ctx=projectList%3D3165%2C65422%2C984%26key%3Dactivities%26showNavigation%3Dfalse","Creating Custom URLs to Access Pages","90523.htm");
Page[118]=new Array("This chapter includes information create a new configuration for P6 Team Member, configure P6 Team Member settings, configure Email Statusing Service for P6, and to configure IIS 8.5 for P6 Team Member.","P6 Team Member Setup Tasks","90347.htm");
Page[119]=new Array("To create a Primavera P6 Administrator configuration:","Do one of the following:","On Windows platforms, run dbconfigpv.cmd (located in the p6home directory that you specified when installing P6).","On UNIX platforms, change to the p6home directory that you specified when installing P6, and run dbconfigpv.sh.","On the Setup and Configuration of the Primavera P6 Database dialog box, select the database type.","On the Please enter the following information... dialog box:","Specify the database connection parameters. Type your database user name and password, the database name, host address, and host port. The database name, host address, and host port are specific to your database installation. The Database Host Port field displays the default port for the database type you selected. You can edit this port.","To use the SSL protocol to securely communicate between the P6 application server and the database server, select the SSL option. If you select the SSL option, you must specify an SSL-enabled port number in the Database Host Port field.","Note","See the appropriate database server documentation and the My Oracle Support's Knowledge Articles for information on configuring SSL.","Using the SSL protocol will impact database performance.","Ensure that the Public Group ID is 1 for a standard configuration.","Select Create a new configuration and then enter the name of your new configuration (for example, Team Member Configuration).","Click Next.","Click OK.","Creating a New Primavera P6 Administrator Configuration","89116.htm");
Page[120]=new Array("To configure the settings for P6 Team Member Web, you must have a P6 Team Member Admin Configuration. See Installing and Configuring P6 EPPM for more information on how to create this configuration during a new installation of P6 Team Member Web or P6 EPPM.","To configure the settings for P6 Team Member Web:","Launch Primavera P6 Administrator.","Navigate to your P6 Team Member configuration, and then expand it.","Expand Application:","Set the Help server URL to one of the following:","http://localhost:listenport/ContextRoot","where localhost is your server's host name, listenport is your P6 Team Member port number, and ContextRoot is the root for your Help.","https://docs.oracle.com/cd/E90746_01/team_member/web/help/","Note Oracle recommends that you use the second URL option because it ensures that you always access the latest version of the P6 Team Member Help, including critical corrections and enhancements.","Expand Team Member:","Expand Connection Pool if you want to alter the following default values:","Initial connection pool size: 10","Maximum active database connections: 150","Maximum idle database connections: -0","Minimum idle database connections: 10","Expand Logging if you want to alter the following default values:","Enable: enabled","Severity Level: Error","Log File Name: p6tmweb.log","Note","The primavera.bootstrap.home property determines the location of the log file.","Configuring P6 Team Member Web Settings","55075.htm");
Page[121]=new Array("To configure Email Statusing Service for P6:","From the P6 Team Member home directory (for example, C:\\P6EPPM_1\\tmws), extract the files from the p6tm-email-service.zip to any location on the application server. (That location will be referred to as EMAIL_HOME).","Make a backup copy of the config.properties file before you edit it.","Edit the config.properties file to configure the settings for the email application.","Note When you are finished editing the config.properties file, move it to a secure location.","In the P6 Configuration section, locate and specify the following:","In the p6.admin.user = line, specify a P6 user who is assigned to at least one module access and has resource access.","In the p6.notify.user= line, specify the email addresses, separated by commas, of users who can send Notify Task lists to other users. As you see the P6 Help for more information on sending team members their tasks.","In the p6.max.tmusers = line, specify the maximum number of email recipients that can receive notification emails at one time. You should keep the number below 500 to avoid performance problems.","In the p6.bootstrap = line, specify the location of the BREBootstrap.xml file.","For example, the location could be one of the following: C:/P6EPPM_1/p6, C:/EMAIL_HOME, /usr/P6EPPM_1/p6, or /usr/EMAIL_HOME or you can use the following: C:\\\\P6EPPM_1\\p6, C:\\\\EMAIL_HOME.","In the mail.read.schedule = line, specify how often your email should process new messages. Use cron expressions for your formatting. For example:","0 */5 * * * ?","will process new messages every five minutes.","Note For more information on cron expressions, see https://docs.oracle.com/cd/E12058_01/doc/doc.1014/e12030/cron_expressions.htm.","In the Outgoing mail (SMTP Settings) section, locate and specify the following:","In the send.host = line, specify the SMTP server hostname or IP address that you will use to send emails.","In the send.port = line, specify the port number that connects to the SMTP server.","In the send.ssl = line, specify true to use SSL or false if you will not use SSL.","Note Oracle recommends that you always use SSL in a production environment for secure communications.","In the send.starttls = line, specify true to use TLS or false if you will not use TLS.","In the send.email = line, specify the email address or User Principal Name (UPN) where team members will send their status update requests.","In the send.replyto = line, specify an email address for team members to respond to when they receive emails. If this field is left blank, the reply address will be the send.email address you specified above.","In the send.password = line, specify the password for the email address or UPN you just specified. ","Note","If you do not specify a password now, the email application prompts you to specify one when it runs. ","You can also specify a password by running the following parameter when you run the 'run.bat' or 'run.sh' file:<br />-Dsend.password=YOUR_PASSWORD<br />where Your_Password is the password for your status email address.<br />For example: <br />In Windows: ./run.bat -Dsend.password=YOUR_PASSWORD<br />In UNIX: ./run.sh -Dsend.password=YOUR_PASSWORD","Oracle recommends using the option in the config.properties file and then moving that file to a secure location when you are finished modifying it.","If you want to set up anonymous authentication for an SMTP server, comment this field out.","In the Incoming Mail (IMAP Settings) section, locate and specify the following:","In the imap.host = line, specify the IMAP protocol host to read emails.","In the imap.port = line, specify the IMAP port number.","In the imap.ssl= line, specify true to use SSL or false if you will not use SSL.","NoteOracle recommends that you always use SSL in a production environment for secure communications.","In the imap.username = line, specify the IMAP user name (which will be your email address) or User Principal Name (UPN).","In the imap.password = line, specify the password for the user name you just specified.","Note","If you do not specify a password now, the email application will ask you to specify one when it runs. ","You can also specify a password by running the following parameter when you run the 'run.bat' or 'run.sh' file:<br />-Dimap.password=YOUR_PASSWORD<br />where Your_Password is the password for your status email address.<br />For example: <br />In Windows: ./run.bat -Dimap.password=YOUR_PASSWORD<br />In UNIX: ./run.sh -Dimap.password=YOUR_PASSWORD","Oracle recommends using the option in the config.properties file and then moving that file to a secure location when you are finished modifying it.","If you want to setup anonymous authentication for an SMTP server, comment this field out.","In the imap.search.folder = line, specify the folder to use for processing incoming emails. For example:","imap.search.folder = inbox","Note The email application will use this folder to search for incoming mail. Oracle recommends you use the inbox for this folder. If you select another folder, you must ensure that all emails get filtered there, or the email application will not be able to detect the messages.","In the IMAP Folder configuration section, locate and specify the following:","In the imap.success.folder = line, specify the folder where messages that process successfully will go. For example:","imap.success.folder = P6Success","Note The email application will automatically create this folder if you do not create it now.","In the imap.failure.folder = line, specify the folder where messages that failed will go. For example:","imap.failure.folder = P6Fail","Note The email application will automatically create this folder if you do not create it now.","In the imap.temp.folder = line, specify the folder where messages that are being processed will go. For example: ","imap.temp.folder = P6Temp","Note The email application will automatically create this folder if you do not create it now.","In the Task update options section, locate and specify the following:","In the reply.label.cleanup field, enter true if you want to remove HTML tags attached to the task field labels. Enter false if you don't want to remove the tags.","In the reply.label.tag.search field, enter the regular expression to remove unexpected HTML tags during reply message parsing.","Note See information on &quot;regular expression&quot; for more details on this field. For example, see https://developer.mozilla.org/en-US/docs/JavaScript/Guide/Regular_Expressions#Writing_a_Regular_Expression_Pattern.","In the update.debug field, enter true if you want to output the contents of the email message as it is parsed for updates. Enter false if you don't want to output the contents of the email message as it is parsed for updates. You should only enter true when you are troubleshooting issues with updating tasks. ","In the Message Format options section, locate and specify the following:","In the update.task.search.term = line, specify the text that the email application should search for in the subject line of incoming messages. For example:","update.task.search.term = Your Requested P6 Tasks","In the notify.update.task.search.term = line, specify the text that the email application should search for in the subject line of incoming messages that originated from a Notify message. For example:","update.task.search.term = Your P6 Tasks","If the EMAIL_HOME is on a different server from your P6 home, copy the BREBootstrap.xml from your P6 home to your EMAIL_HOME.","If the EMAIL_HOME is on the same server as your P6 home, you will use the BREBootstrap.xml that is in your P6 home folder.","Run one of the following:","In Windows, launch the run.bat file.","In UNIX, launch the run.sh file.","When you launch the run file, you may have to complete the following steps depending on how you configured your Email Statusing Service:","If the config.properties file and the run file are in different folders, you will need to specify the config.properties location with the -Dconfig.file parameter.","In Windows (add a space between run.bat and -Dconfig):","run.bat -Dconfig.file=C:\\home\\auser\\somelocation\\config.properties","In UNIX (add a space between run.sh and -Dconfig): ","./run.sh -Dconfig.file=/home/auser/somelocation/config.properties","If you didn't specify the send.password= or imap.password=, you can specify them now. If you do not specify them now, the email application will prompt you to do so when it runs.","In Windows: ","run.bat -Dsend.password=YOUR_PASSWORD","In UNIX:","./run.sh -Dsend.password=YOUR_PASSWORD","In Windows:","run.bat -Dimap.password=YOUR_PASSWORD","In UNIX:","./run.sh -Dimap.password=YOUR_PASSWORD","where Your_Password is the password for your status email address","If your bootstrap file contains more than one database, you need to clarify which database you are using when you launch the run file.","In Windows:","run.bat -Ddatabase.instance=db_id","where db_id is your database instance (for example, -Ddatabase.instance=2).","In UNIX: ","./run.sh -Ddatabase.instance=db_id","where db_id is your database instance (for example, -Ddatabase.instance=2).","Once the run file finishes, you can verify that the email status application works. See Verifying Email Statusing Service.","Note Anonymous SMTP authentication is supported.","Configuring Email Statusing Service for P6","49980.htm");
Page[122]=new Array("Once you have installed the email status application, you can send an email to verify that the server is setup properly.","To verify your Email Statusing Service setup:","Enter an email address that P6 recognizes in the 'From' line.","Enter the email address you specified in Configuring Email Statusing Service for P6 in the 'To' line.","Enter Ping in the subject line.","Send the message.","If the message is successful, you will receive a message containing the status of the email service. The message will tell you how many users have a blank email address in the database.","If the message failed, you will not receive a message. The failed message will appear in the failure folder that you specified in the config.properties file. See Configuring Email Statusing Service for P6.","Verifying Email Statusing Service","49982.htm");
Page[123]=new Array("To ensure that your instance of P6 Team Member works correctly with IIS 8.5, you will need to update your web.config file; otherwise, you might experience an error when attempting to select an option from the My Tasks drop-down list.","To configure IIS 8.5 for P6 Team Member:","Navigate to %SystemDrive%\\inetpub\\wwwroot.","Open web.config.","Add &lt;modules&gt;&lt;remove name=&quot;WebDAVModule&quot; /&gt;&lt;/modules&gt; to the inside of the &lt;system.webServer&gt;&lt;/system.webServer&gt; tag.","Add &lt;remove name=&quot;WebDAV&quot; /&gt; beneath the &lt;handlers&gt;&lt;/handlers&gt; tag, which can be found inside the &lt;system.webServer&gt;&lt;/system.webServer&gt; tag.","Save the file and the close it.","Configuring IIS 8.5 for P6 Team Member","89730.htm");
Page[124]=new Array("Complete the following task to finish enabling P6 Integration API.","P6 Integration API Setup Tasks for On-Premises","53247.htm");
Page[125]=new Array("The P6 Integration API Database Configuration wizard lets you create a new configuration or switch to a different configuration than the one specified during the P6 Integration API installation.","The database you connect to during the installation stores one or more P6 Integration API configurations. Each configuration specifies a set of configurable parameters that determine how the P6 Integration API operates. If no configuration exists in the database the first time you install the P6 Integration API, you must create a new configuration. For subsequent configurations, you can select an existing configuration or create a new one. After configuration, you can use the Database Configuration wizard to select a different P6 Integration API configuration or create a new one.","Note After selecting a different P6 Integration API configuration or creating a new configuration, you must stop and restart the server for the changes to take effect.","Starting the Database Configuration wizard","On Windows, go to the &lt;API_INSTALL_HOME&gt; directory and run the dbconfig.cmd script. Depending on your installation, the home directory may be: C:\\P6EPPM_1\\api.","On UNIX, change to the &lt;API_INSTALL_HOME&gt; directory and run the dbconfig.sh script. Depending on your installation, the home directory may be: /usr/P6EPPM_1/api.","Changing Database Configuration Settings for P6 Integration API","38138.htm");
Page[126]=new Array("The Java security manager enables programmers to establish a custom security policy for their Java applications.","Unless you enable the security manager before you start the P6 Integration API server, the security manager is disabled. To enable/disable the security manager, edit the P6 Integration API server's startup script with a text editor and uncomment or comment the appropriate command:","For Windows, edit the startAppServer.cmd file. ","For Linux, edit the startAppServer.sh file.","Uncomment or comment one of the following:","In Windows:","SET ENABLE_JAVA_SECURITY_MANAGER=-Djava.security.manager","Linux:","ENABLE_JAVA_SECURITY_MANAGER=-Djava.security.manager","Note The P6 Integration API server can use different policy files for different application/web servers.","Enabling the Java Security Manager","38140.htm");

Page[127]=new Array("Because one P6 Integration API server instance can control more than one database, in addition to specifying an authentication mode for a database through the Authentication tab of the Primavera P6 Administrator, you can use an administrative configuration setting to specify the overall mode you want to use for the P6 Integration API server. The P6 Integration API uses a single P6 Professional configuration setting, Authentication.Mode, to support authentication selection. For LDAP authentication with secure communication (SSL) between the P6 Integration API server and the LDAP server, two additional configuration settings are required.","Use the Primavera P6 Administrator to specify these configuration settings.","Note A P6 Integration API configuration might include database instances that are not set to the same authentication mode as the P6 Integration API server. If a user connects and requests a database that is set to a different authentication mode than the P6 Integration API server, an error message displays. The user must select a database that matches the authentication mode set for the P6 Integration API server.","Configuring P6 Integration API Authentication","38151.htm");
Page[128]=new Array("Complete the following tasks to finish enabling P6 EPPM Web Services.","P6 EPPM Web Services Setup Tasks","53293.htm");
Page[129]=new Array("The Primavera Database Configuration wizard lets you create a new configuration or switch to a different configuration than the one specified during P6 EPPM Web Services installation.","The database you connect to during the installation stores one or more P6 EPPM Web Services configurations. Each configuration specifies a set of configurable parameters that determine how P6 EPPM Web Services operates. The first time you install P6 EPPM Web Services, if no configuration exists in the database, you must create a new configuration. For subsequent installs, you can select an existing configuration or create a new one. After configuration, you can use the Database Configuration wizard to select a different P6 EPPM Web Services configuration or create a new one.","Note After selecting a different P6 EPPM Web Services configuration or creating a new configuration, you must stop and restart the server for the changes to take effect.","Starting the Database Configuration wizard","On Windows, go to the &lt;WS_INSTALL_HOME&gt;/bin directory and run the dbconfig.cmd script. Depending on your installation, the home directory may be: C:\\P6EPPM_1\\ws\\bin.","On UNIX, change to the &lt;WS_INSTALL_HOME&gt;/bin directory and run the dbconfig.sh script. Depending on your installation, the home directory may be: /usr/P6EPPM_1/ws/bin.","Changing Database Configuration Settings for P6 EPPM Web Services","35677.htm");





Page[130]=new Array("To set your compression settings:","Open the Primavera P6 Administrator.","In the Configurations drop-down list, select your configuration.","In the sidebar select Web Services/Compression.","Set the minimum size for response compression. responses smaller than this will not be compressed to gzip format.","Set a value between Between 0 and 2147483647 bytes, the default is 400.","Configuring Compression Settings for P6 EPPM Web Services","101144.htm");
Page[131]=new Array("By default, the P6 EPPM Configuration Wizard deploys P6 EPPM Web Services with the oracle/wss_username_token_server_policy OWSM policy. This policy does not contain message protection and encryption.","To add a new policy to OWSM for message protection and encryption:","Create a Java Keystore.","For information about Java keystores and instructions to create one, refer to the SAML Message Protection Use Case chapter of the Oracle Fusion Middleware Securing Web Services and Managing Policies with Oracle Web Services Manager guide on Oracle Technical Network.","Configure OWSM to use the JKS Keystore.","For information about Java keystores and instructions to create one, refer to the Managing OWSM Domain Configuration chapter of the Oracle Fusion Middleware Securing Web Services and Managing Policies with Oracle Web Services Manager guide on Oracle Technical Network.","Log in to WebLogic Enterprise Manager using the following URL:","http://&lt;Host_Name&gt;:&lt;Port&gt;/em","Navigate to WebLogic Domains in the Target Navigation directory and right-click owsm.","In the owsm menu, select Web Services and then click WSM Policy Sets.","Select P6WSSOAP and then click Edit.","Note Edit becomes available when a policy set is selected.","Add additional policies to the policy set by completing the following:","On the Edit Policy Set: Enter General Information page, click Next.","On the Edit Policy Set: Enter Resource Scope page, click Next.","On the Edit Policy Set : Enter Constraint page, click Next.","On the Edit Policy Set: Add Policy References page, attach one of the following policies from the Available Policies table and then click Next:","oracle/wss11_username_token_with_message_protection_server_policy"," oracle/wss11_saml20_token_with_message_protection_server_policy OWSM","Note Refer to OWSM documentation for descriptions of each policy.","On the Edit Policy Set: Summary page, click Save.","Navigate to P6WebServices in the Target Navigation directory.","Click Apply JRF Template.","Restart the P6 server.","Adding Additional Policies to Oracle Web Services Manager","91758.htm");
Page[132]=new Array("The following sections detail solutions for problems you may encounter with P6 EPPM.","Troubleshooting for P6 EPPM","80036.htm");
Page[133]=new Array("An enhancement was made with P6 R8.4 to store documents in folders using the short name of the project instead of the database object ID. The P6 users' documents will now be stored in a folder called 'P6Users' instead of 'Users'. If you were using a previous version of the content repository P6 but did not run the migration utility provided in the media pack when you upgraded your environment, the content repository will not work.","To fix this issue:","Shutdown the P6 server.","Go to the P6EPPM_Home/p6 folder.","Run migrationtool.cmd or migrationtool.sh (based on your operating system).","After the utility finishes:","Go to the P6EPPM_Home/p6/webaccesslogs folder and ensure it contains Document-migration.html. ","Open the Document-migration.html file and ensure all the folder names changed successfully. Ensure nothing failed.","If anything failed, log in to the content repository and manually move the documents that failed to move from the older document folders to the new document folders.","Project Documents example: ","Assume there is a Project called &#8216;Business Development Processes' whose Database ID is &#8216;4321' and Project ID &#8216;BDP001'. In the content repository, you would be able to see two folders: one with the name &#8216;4321' and one with the name &#8216;BDP001'. ","Open the 4321 folder and copy all the documents in this folder. ","Open folder BDP001 and paste all the documents in this folder. ","After you finish copying the documents, you can safely delete the 4321 folder from the content repository.","User Documents example: ","If you log in to the content repository and navigate to the Project Document home, you would see only two folders: Projects and P6Users . If you see a third folder named Users, follow these steps:","Open the P6Users folder and make a note of the folder names.","Open the Users folder and check if the above folder names are present. ","If a folder name is not present in the Users folder, copy that missing folder from P6Users to Users. Repeat this step for all the missing folders.","If a folder name is present in the Users folder, manually move the documents from that folder in P6Users to the same folder in Users folder. Repeat this step for all the matching folders.","Delete the P6Users folder.","Rename the Users folder to P6Users in the content repository.","Start the P6 server and ensure you can see all the documents.","Troubleshooting for Connecting the Content Repository","80035.htm");
var PageCount=140;


/*
Date: 12/11/2025 7:41 PM
Source: EPPM_25_dev
BookID: 52385
PubProduct: PRIMAVERA_EPPM
BookTitle: System Administration Guide for On-Premises
Version: Version 25
Lang:	en
*/
	var PageLength=Page.length;
	var Result = "";
	var ResultTemp = "";
	var ResultFound = "";
	var ResultTitleOnly = [];
	var ResultTitleAndContent = [];
	var ResultInContent = [];
	var ResultInContentTemp = [];

	var ResultCombinedTemp = [];
	var ResultCombined = [];

	var arrayIndex = 0;
	var NrRes = 0;
	var j = 0;
	var i = 0;
	var k = 0;
	var d = 0;
	var maxItems = 1000;
	var heading = 0;
	var WordPos = -1;
	var WordPosHeading = -1;
	var WordPosContentText = -1;
	var FoundWord = "";
	var FoundWordHead = "";
	var SearchInHeadingOnly = 0;
	var isChecked;
	var size = 10;
	var resGroupCounter = 0;
	var shown = "shown";
	var checkBoxInHeading;
	var searchFlag = 0;
	var DivResult;
	var SearchWord;

if (SearchText && SearchText.length >= 1) {
		SearchWord = SearchText.replace(/\+/g, " ").replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;");
		searchFlag = 1;
	} else {
		SearchWord = "";
		searchFlag = 0;
	}
	

	if (searchFlag === 1) {
		Result = "";

		// checkBoxInHeading = document.getElementById("inHeading");
		if (inHeading) {

			isChecked = true;
		} else {

			isChecked = false;
		}

		if (SearchWord && SearchWord.length >= 1) {
			if (isChecked) {
				SearchInHeadingOnly = 1;
			} else {
				SearchInHeadingOnly = 0;
			}
			SearchWord = SearchWord.toLowerCase();
			window.status = "Searching, please wait...";
			for (j = 0; j < PageLength; j++) {
				k = Page[j].length - 1;
				for (i = 0; i < k; i++) {

					heading = k - 1;

					if (SearchInHeadingOnly === 1) {
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPosHeading > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);

							NrRes++;
							ResultTemp = "<li>";
							ResultTemp += "<span>";
							ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							ResultTitleOnly[arrayIndex] = ResultTemp;
							arrayIndex++;

							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}
					} else if (SearchInHeadingOnly === 0) {
						WordPos = Page[j][i].toLowerCase().indexOf(SearchWord);
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPos > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							NrRes++;
							ResultTemp += "<li>";
							ResultTemp += "<span>";
							if (WordPosHeading > -1) {
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";
							} else {
								// found word is not in the head
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading] + "</a><br/>\n";

							}
							if (i < k - 1) {
								WordPosContentText = Page[j][i].toLowerCase().indexOf(SearchWord);

								if (Page[j][i].length > 300 && (WordPosContentText > -1)) {

									if (WordPosContentText > 75) {
										ResultInContentTemp.push("..." + Page[j][i].substr(WordPosContentText - 75, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");
									} else {
										ResultInContentTemp.push("..." + Page[j][i].substr(0, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");

									}

								} else if (WordPosContentText > -1) {

									ResultInContentTemp.push(Page[j][i].replace(FoundWord, FoundWord.bold()));

								}
							}

							ResultTemp += ResultInContentTemp.join("");

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							if (WordPosHeading > -1) {
								ResultTitleAndContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							} else {
								ResultInContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							}

							ResultInContentTemp.length = 0;
							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}

					}
				}
			}

			ResultTitleOnly = ResultTitleOnly.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultTitleAndContent = ResultTitleAndContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultInContent = ResultInContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			ResultCombinedTemp = ResultTitleOnly.concat(ResultTitleAndContent, ResultInContent);

			ResultCombinedTemp = ResultCombinedTemp.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			for (d = 0; d < ResultCombinedTemp.length; d += size) {
				resGroupCounter++
				ResultCombined.push("<div id=" + "'" + "resGroup_" + resGroupCounter + "'" + " class=" + "'" + "resGroup " + shown + "'" + ">" + "<ol class='searchResults'>" + ResultCombinedTemp.slice(d, d + size).join("") + "</ol></div>");
				shown = "notshown";
			}

			ResultFound = ResultCombined.join("");

Result += "<div id='searchDetailsDiv'>";
			Result += "<p class='searchDetails'>Your Search Found&nbsp;" + NrRes + "&nbsp;items.&nbsp;";
			Result += "</p></div>";
			
			Result += "<div class='searchResultsDiv'>";
			Result += "<div id='resultsCollection' class='searchResults'>";
			Result += ResultFound;
			Result += "</div>";
			Result += "</div>";
			Result += "<div class='searchPaging'>";

			Result += '<hr />';

			Result += '<p class="bodytext"><a class="disabledAnchor" id="pBack" onclick="turnPage(\'backPage\')" href="#pBack">Back</a>&nbsp; | &nbsp;';
			
			if (resGroupCounter && resGroupCounter > 1) {
				Result += '<a id="pNext" onclick="turnPage(\'nextPage\')" href="#pNext">Next</a>';
			} else {
				Result += '<a id="pNext"  class="disabledAnchor" href="#pNext">Next</a>';
			}
			Result += '</p>\n';
			Result += '<div id="pagenofn"><p class="bodytext">Page <span id="pagen">1</span> of ' + resGroupCounter + '</p></div>';

			Result += "</div>";
			
			
		}

		DivResult = document.getElementById("s_anchor");
		if (Result && DivResult) {

			//myDivResult.append(Result);
			DivResult.innerHTML = Result;
			

		}
		window.status = "";
		
		

	}
	}())
}
