'use strict';
function search(SearchText, inHeading) {
(function () {
var Page = [];

/* Generated with Author-it 23.4.1.30004  12/11/2025 7:34:05 PM */
Page[0]=new Array("Title and Copyright Information","Copyright   2025, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information","46576.htm");
Page[1]=new Array("This document covers the tested configurations for Primavera P6 EPPM Database, P6 Web, P6 Integration API, P6 EPPM Web Services, P6 Team Member, P6 Professional Cloud Connect and P6 Professional Version 25.12.","Oracle has tested on the following configurations and only certifies this release to work on these platforms. Customers may choose to install on non-certified platforms but do so at their own risk. If customers find any problems with non-certified platforms, these may take longer to investigate and resolve by Oracle. Oracle will only test and have access to tested platforms and configurations. In addition, the resolution for an issue with a non-tested configuration might be a recommendation to deploy the product on a tested platform. If you still decide to deploy on a non-certified configuration, Oracle strongly recommends you fully test the product with the non-certified platform in a test environment before deployment to users.","Note","All platforms and technologies certified with a base P6 version are also supported with the latest P6 patch set for that version (unless specified). Before you install the latest version of a platform or technology, install the most recent P6 patch set certified for it.","Interim patches as well as quarterly Critical Patch Updates (CPUs) for tested base versions of Oracle platform technologies listed in this document (Weblogic, Oracle database, and Java) are also supported.","P6 EPPM is tested using the Enterprise Edition of the stated database, operating system, or web server and only certifies this product edition to work on the platforms as listed in this document.","Any operating system certified for use with technologies listed in this document is supported. For information on certified platforms for Oracle and other third-party technologies, refer to the certification matrix of the respective technology and select the platform compatible with your Primavera applications and the respective technology.","Refer to the link below for the specific and complete Oracle Support terms and conditions:","https://www.oracle.com/support/policies/","About This Guide","100188.htm");
Page[2]=new Array("Review the table to learn about updates to this document.","Change Record","Date","Change Reference","December 2025","First published for this release.","What's Changed","100238.htm");
Page[3]=new Array("P6 EPPM supports:","Oracle Virtual Machine as a virtualization platform.","EXA Hardware for database and application server platforms.","Multitenant for database platform.","Microsoft .Net framework 4.6.2.","Windows installer 4.5.","P6 Professional Cloud Connect is not supported with any version of SQL Server.","Java","JRE (Java Runtime Environment) is not a requirement for P6 EPPM; it is requirement only for AutoVue. JRE 1.8.0_311 is certified for this requirement.","Deprecated Technologies","P6 Integration API is deprecated as of version 16.1 of P6 and may be dropped in a future release.","General Information","100443.htm");
Page[4]=new Array("Database Platforms","Oracle Database *","Driver","Exceptions and Additional Information","Oracle Database 23","Oracle 19.29.0.0","Oracle Autonomous Database","Oracle JDBC","*OS Version:","Tested with following fully localized international versions of Windows:","Arabic","Brazilian Portuguese","Chinese Simplified","Chinese Traditional","English","French","German","Italian","Japanese","Russian","Spanish","Korean","Dutch","*Oracle and Oracle Autonomous Database","P6 EPPM supports:","Dataguard, Oracle Advanced Compression, RAC (Real Application Cluster), database partitioning, Oracle Database Vault, and transparent data encryption features on Oracle and Oracle Autonomous Databases.","AL32UTF8, UTF 8, and Western European (WE8MSWIN1252) character sets for Oracle and Oracle Autonomous Databases.","Hardened database server environment setup on Oracle and Oracle Autonomous Database.","Systems - Oracle Database Information","100189.htm");
Page[5]=new Array("Database Platforms","MS SQL Server Database *","Driver","Exceptions and Additional Information","SQL Server 2019","SQL Server 2022","Oracle JDBC","Azure SQL database is not supported.","Case-sensitive (CS) collation is not supported for SQL Server. Only case insensitive (CI) collation is supported for SQL Server.","*OS Version:","Tested with following fully localized international versions of Windows:","Arabic","Brazilian Portuguese","Chinese Simplified","Chinese Traditional","English","French","German","Italian","Japanese","Russian","Spanish","Korean","Dutch","*MS SQL Server Database","P6 EPPM supports:","Hardened database server environment setup SQL Server 2019.","Cyrillic, Japanese, Chinese/PRC, Chinese/Taiwan, and Western European collations for SQL Server databases on the respective operating system locales.","Oracle recommends LEGACY_CARDINALITY_ESTIMATION be switched on for any version of SQL Server 2019, or later.","Systems - Non Oracle Database Information","100190.htm");
Page[6]=new Array("Application Servers","Product","Version","JDK","Exceptions and Additional Information","Oracle WebLogic","14.1.2","Oracle JDK 17","Web Servers","Product","Version","Exceptions and Additional Information","Oracle HTTP Server","14.1.2","Microsoft Internet Information Server","10","*Version Supported","P6 EPPM supports:","Java Application Server Cluster set up on a supported version of Oracle WebLogic with a supported version of JDK. Refer to the tables above for supported versions.","Hardened application server environment set up on a supported version of Oracle WebLogic with a supported version of JDK. Refer to the tables above for supported versions.","End to end (Database, Application Server and Client tier) SSL for a supported version of Oracle WebLogic with a supported version of JDK. Refer to the tables above for supported versions.","Oracle Virtual Machine as a virtualization platform.","EXA Hardware for database and application server platform.","Refer to the About This Guide page for further consideration relating to non-tested platforms.","Application and Web Servers","100191.htm");
Page[7]=new Array("Access Provisioning","Product","Version","Exceptions and Additional Information","Oracle Identity Manager","14.1.2","Supported for P6 Web only.","Application Hosting","Product","Version","Exceptions and Additional Information","Citrix XenApp","7.18","1. Supported for P6 Professional only","2. Citrix XenApp Plugin for Hosted Apps is tested with this server version","3. P6 Professional through Citrix is supported by application publishing only","Remote Desktop Services ","2019","2022","Secure Global Desktop","5.5","Content Repository","Product","Version","Exceptions and Additional Information","Content Management Interoperability Services","n/a","1. CMIS connector supports all repositories which are 100% CMIS compliant","2. CMIS connector is tested only with Sharepoint 2016 and Alfresco content repositories.","Microsoft Sharepoint Enterprise Edition","2019","2022","1.SharePoint 2016 is supported through Connector only for upgrades.","2. Oracle AutoVue support is not available with Sharepoint 2016.","Oracle WebCenter Content Core Capabilities","14.1.2.0","Enterprise Administration","Product","Version","Exceptions and Additional Information","Oracle Enterprise Manager Grid Control","13.3.0.0.0","Java Message Service","Product","Version","Exceptions and Additional Information","Oracle WebLogic","14.1.2","P6 Reporting Software","Product","Version","Exceptions and Additional Information","Oracle Analytics Publisher (formerly Business Intelligence Publisher)","2025","Visualization","Product","Version","Exceptions and Additional Information","Oracle AutoVue 2D Professional","21.1","VueLink 20.1 for UCM is supported only with Oracle WebCenter Content Core Capabilities.","Oracle AutoVue 3D Professional Advanced","21.1","VueLink 20.1 for UCM is supported only with Oracle WebCenter Content Core Capabilities.","Workflow Repository","Product","Version","Exceptions and Additional Information","Oracle Business Process Management","14.1.2","Supported for P6 Web only.","Microsoft Office Format Support","Format","Product","Version","Exceptions and Additional Information","MS Excel (xlsx)","Microsoft Office","2019","Office 365","Microsoft Project Format Support","Format","Product","Version","Exceptions and Additional Information","MS Project (xml)","Microsoft Project","2010","2013","2016","2019","2021","2019 and 2021 were tested only for importing data from a Microsoft Project XML file into P6 EPPM. All other versions were tested both for importing and exporting.","Integrations and 3rd Party Applications","100207.htm");
Page[8]=new Array("User Directory Support","Product*","Version","Exceptions and Additional Information","Active Directory","2022","2025","Oracle Access Manager","14.1.2.0","Oracle Internet Directory","14.1.2","Oracle Unified Directory","14.1.2","* Product","Failover and referrals are supported for Active Directory only.","Single Sign On Support","Product*","Version","Exceptions and Additional Information","Oracle Access Manager","14.1.2","P6 EPPM supports Oracle Identity Federation 12.2.1.4.0 and SAML 2.0","Shibboleth","3.3.3.0.0","P6 EPPM supports SAML 2.0.","Tested only with Tomcat (application server) and Apache (web server).","*Product","P6 EPPM Single Sign On support is tested only with Oracle WebLogic Server (application server) and OHTTP (web server).","LDAP and SSO","100192.htm");
Page[9]=new Array("Database Client","Client OS/ Email Clients","Oracle database Client Version","Exceptions and Additional Information","Windows 11 (64 bit)","19.8","P6 EPPM supports only 64 bit versions of database clients for P6 Professional on 64 bit operating systems.","Database client is supported for P6 Professional only.","Chrome is recommended for optimal performance.","Browser","Client OS/ Email Clients","Supported Browsers","Exceptions and Additional Information","Windows 2019, 2022, 2025","Firefox 143+","Chrome 139+","Edge 139+","P6 EPPM supports only 64 bit versions of database clients for P6 Professional on 64 bit operating systems.","Database client is supported for P6 Professional only.","Chrome is recommended for optimal performance.","Mac OS 15","Safari 18.6+Firefox 143+","Chrome 139+","Windows 10 (64 bit)","(Windows Surface Pro, Windows Surface Pro2, Windows Surface Pro3)","Firefox 143+","Chrome 139+Edge 139+","Supported for P6 Team Member Web only.","iOS 18 (64 bit)","iOS 18.1 (64 bit)","(iPad)","Firefox 143+","Chrome 139+","Supported for P6 Team Member Web only.","Android Tablets 14+","Chrome 139+","Supported for P6 Team Member Web only.","Android 14","Android 13","Android 12","(Android phone and tablets)","n/a","Supported for P6 for Android native Android app only.","iOS 18.x","(iPad and iPhone)","n/a","Supported for P6 for iOS native iOS app only.","Microsoft Outlook","Mozilla Thunderbird","Apple Mail","Android","Blackberry","n/a","Supported for Email Statusing Service only.","Only English Operating System environments are certified for Email Statusing Service.","Database Client and Browser","100208.htm");
Page[10]=new Array("Applications","Product","Exceptions and Additional Information","Oracle Primavera Cloud","The tested version is the most recent version available.","Primavera Gateway","The tested version is the most recent version available.","Primavera Unifier","1. The tested version is the most recent version available.","2. Integration of Primavera Unifier through Primavera Gateway is tested when P6 EPPM Web Services is configured with Oracle database only.","Primavera Portfolio Management","1. The tested version is the most recent version available.","2. Requires P6 EPPM Web Services to integrate with P6 EPPM.","3. IIS 10 with SMTP Service on Windows 2019 &amp; 2022.","4. P6 EPPM integration is supported whenP6 EPPM Web Services is configured for cookies or username token authentication.","Oracle Primavera Risk Analysis","1. The tested version is the most recent version available.","2. Requires P6 EPPM Web Services to integrate with P6 EPPM.","Primavera Data Warehouse and Primavera Analytics","Product","Version","Exceptions and Additional Information","Analytics","25.12","The tested version of Analytics is the most recent version available.","Primavera Data Warehouse","25.4","The tested version of Primavera Data Warehouse is the most recent version available.","Other Primavera Applications","100209.htm");
Page[11]=new Array("Language Code","Language","Exceptions and Additional Information","AR","Arabic","English help","PT_BR","Brazilian Portuguese","English help","CH_CN","Chinese Simplified","Localized help","CH_TW","Chinese Traditional","English help","EN","English","English help","NL","Dutch","English help","FR","French","Localized help","DE","German","Localized help","IT","Italian","English help","JA","Japanese","Localized help","RU","Russian","English help","ES_ES","Spanish","English help","KO","Korean","Localized help","PL","Polish","English help, only P6 Team Member Web is supported","CS","Czech","English help, only P6 Team Member Web is supported","Localization","100237.htm");
var PageCount=12;


/*
Date: 12/11/2025 7:34 PM
Source: EPPM_25_dev
BookID: 100187
PubProduct: PRIMAVERA_EPPM
BookTitle: Tested Configurations
Version: Version 25
Lang:	en
*/
	var PageLength=Page.length;
	var Result = "";
	var ResultTemp = "";
	var ResultFound = "";
	var ResultTitleOnly = [];
	var ResultTitleAndContent = [];
	var ResultInContent = [];
	var ResultInContentTemp = [];

	var ResultCombinedTemp = [];
	var ResultCombined = [];

	var arrayIndex = 0;
	var NrRes = 0;
	var j = 0;
	var i = 0;
	var k = 0;
	var d = 0;
	var maxItems = 1000;
	var heading = 0;
	var WordPos = -1;
	var WordPosHeading = -1;
	var WordPosContentText = -1;
	var FoundWord = "";
	var FoundWordHead = "";
	var SearchInHeadingOnly = 0;
	var isChecked;
	var size = 10;
	var resGroupCounter = 0;
	var shown = "shown";
	var checkBoxInHeading;
	var searchFlag = 0;
	var DivResult;
	var SearchWord;

if (SearchText && SearchText.length >= 1) {
		SearchWord = SearchText.replace(/\+/g, " ").replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;");
		searchFlag = 1;
	} else {
		SearchWord = "";
		searchFlag = 0;
	}
	

	if (searchFlag === 1) {
		Result = "";

		// checkBoxInHeading = document.getElementById("inHeading");
		if (inHeading) {

			isChecked = true;
		} else {

			isChecked = false;
		}

		if (SearchWord && SearchWord.length >= 1) {
			if (isChecked) {
				SearchInHeadingOnly = 1;
			} else {
				SearchInHeadingOnly = 0;
			}
			SearchWord = SearchWord.toLowerCase();
			window.status = "Searching, please wait...";
			for (j = 0; j < PageLength; j++) {
				k = Page[j].length - 1;
				for (i = 0; i < k; i++) {

					heading = k - 1;

					if (SearchInHeadingOnly === 1) {
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPosHeading > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);

							NrRes++;
							ResultTemp = "<li>";
							ResultTemp += "<span>";
							ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							ResultTitleOnly[arrayIndex] = ResultTemp;
							arrayIndex++;

							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}
					} else if (SearchInHeadingOnly === 0) {
						WordPos = Page[j][i].toLowerCase().indexOf(SearchWord);
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPos > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							NrRes++;
							ResultTemp += "<li>";
							ResultTemp += "<span>";
							if (WordPosHeading > -1) {
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";
							} else {
								// found word is not in the head
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading] + "</a><br/>\n";

							}
							if (i < k - 1) {
								WordPosContentText = Page[j][i].toLowerCase().indexOf(SearchWord);

								if (Page[j][i].length > 300 && (WordPosContentText > -1)) {

									if (WordPosContentText > 75) {
										ResultInContentTemp.push("..." + Page[j][i].substr(WordPosContentText - 75, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");
									} else {
										ResultInContentTemp.push("..." + Page[j][i].substr(0, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");

									}

								} else if (WordPosContentText > -1) {

									ResultInContentTemp.push(Page[j][i].replace(FoundWord, FoundWord.bold()));

								}
							}

							ResultTemp += ResultInContentTemp.join("");

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							if (WordPosHeading > -1) {
								ResultTitleAndContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							} else {
								ResultInContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							}

							ResultInContentTemp.length = 0;
							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}

					}
				}
			}

			ResultTitleOnly = ResultTitleOnly.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultTitleAndContent = ResultTitleAndContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultInContent = ResultInContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			ResultCombinedTemp = ResultTitleOnly.concat(ResultTitleAndContent, ResultInContent);

			ResultCombinedTemp = ResultCombinedTemp.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			for (d = 0; d < ResultCombinedTemp.length; d += size) {
				resGroupCounter++
				ResultCombined.push("<div id=" + "'" + "resGroup_" + resGroupCounter + "'" + " class=" + "'" + "resGroup " + shown + "'" + ">" + "<ol class='searchResults'>" + ResultCombinedTemp.slice(d, d + size).join("") + "</ol></div>");
				shown = "notshown";
			}

			ResultFound = ResultCombined.join("");

Result += "<div id='searchDetailsDiv'>";
			Result += "<p class='searchDetails'>Your Search Found&nbsp;" + NrRes + "&nbsp;items.&nbsp;";
			Result += "</p></div>";
			
			Result += "<div class='searchResultsDiv'>";
			Result += "<div id='resultsCollection' class='searchResults'>";
			Result += ResultFound;
			Result += "</div>";
			Result += "</div>";
			Result += "<div class='searchPaging'>";

			Result += '<hr />';

			Result += '<p class="bodytext"><a class="disabledAnchor" id="pBack" onclick="turnPage(\'backPage\')" href="#pBack">Back</a>&nbsp; | &nbsp;';
			
			if (resGroupCounter && resGroupCounter > 1) {
				Result += '<a id="pNext" onclick="turnPage(\'nextPage\')" href="#pNext">Next</a>';
			} else {
				Result += '<a id="pNext"  class="disabledAnchor" href="#pNext">Next</a>';
			}
			Result += '</p>\n';
			Result += '<div id="pagenofn"><p class="bodytext">Page <span id="pagen">1</span> of ' + resGroupCounter + '</p></div>';

			Result += "</div>";
			
			
		}

		DivResult = document.getElementById("s_anchor");
		if (Result && DivResult) {

			//myDivResult.append(Result);
			DivResult.innerHTML = Result;
			

		}
		window.status = "";
		
		

	}
	}())
}
