'use strict';
function search(SearchText, inHeading) {
(function () {
var Page = [];

/* Generated with Author-it 23.4.1.30004  12/11/2025 7:44:32 PM */
Page[0]=new Array("Title and Copyright Information","Copyright   2025, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information","46576.htm");
Page[1]=new Array("This document covers the client system requirements for Primavera P6 EPPM Database, P6 Web, P6 Web Services, P6 Team Member Web, P6 Professional Cloud Connect and P6 Professional Version 25 cloud deployments.","Note All platforms and technologies certified with a base P6 version are also supported with the latest p6 patch set of the platform or technology for that major release version (unless specified). ","Any operating system certified for use with technologies listed in this document is supported. For information on certified platforms for Oracle and other third-party technologies, refer to the certification matrix of the respective technology and select the platform compatible with your Primavera applications and the respective technology.","Oracle has tested on the following configurations and certifies this version to work with these technologies. Customers may choose to use non-certified technologies but do so at their own risk. If any problems are found with non-certified technologies,  these may take longer to investigate and resolve by Oracle. Oracle will only test and have access to tested platforms and configurations. In addition, the resolution for any issues with non-tested configurations could be a recommendation that to resolve the issue you will need to use a tested technology.  If it is still decided to use a non-certified technology,  it is strongly recommended to fully test the product and non-certified platform in a test environment.","For your reference, please refer to the link below for the specific and complete Oracle Support terms and conditions:","https://www.oracle.com/support/policies/","About This Guide","99012.htm");
Page[2]=new Array("Review the table to learn about updates to this document.","Change Record","Date","Change Reference","December 2025","First publication for this release.","What's Changed","99013.htm");
Page[3]=new Array("This document covers the tested configurations for Primavera P6 EPPM Database, P6 Web, P6 Web Services, P6 Team Member Web, P6 Professional Cloud Connect and P6 Professional Version 25 cloud deployments.","Microsoft Office Format Support","Format","Product","Version","Exceptions and Additional Information","MS Excel (xlsx)","Microsoft Office","2019","Office 365","Microsoft Project Format Support","Format","Product","Version","Exceptions and Additional Information","MS Project (xml)","Microsoft Project","2010","2013","2016","2019","2021","2019 and 2021 were tested only for importing data from a Microsoft Project XML file into P6 EPPM. All other versions were tested both for importing and exporting.","P6 Reporting Software","Product","Version","Exceptions and Additional Information","Oracle Analytics Publisher (formerly Business Intelligence Publisher)","2025","Integrations and 3rd Party Applications","99014.htm");
Page[4]=new Array("This document covers the tested configurations for Primavera P6 EPPM Database, P6, P6 EPPM Web Services, P6 Team Member Web, P6 Professional Cloud Connect and P6 Professional Version 25 cloud deployments.","Client and Browser Support","Client OS/ Email Clients","Supported Browsers","Exceptions and Additional Information","Windows 2019, 2022, 2025","Firefox 143+","Chrome 139+","Edge 139+","P6 EPPM supports only 64 bit versions of database clients for P6 Professional on 64 bit operating systems.","Database client is supported for P6 Professional only.","Chrome is recommended for optimal performance.","Mac OS 15","Safari 18.6+Firefox 143+","Chrome 139+","Windows 10 (64 bit)","(Windows Surface Pro, Windows Surface Pro2, Windows Surface Pro3)","Firefox 143+","Chrome 139+Edge 139+","Supported for P6 Team Member Web only.","iOS 18 (64 bit)","iOS 18.1 (64 bit)","(iPad)","Firefox 143+","Chrome 139+","Supported for P6 Team Member Web only.","Android Tablets 14+","Chrome 139+","Supported for P6 Team Member Web only.","Android 14","Android 13","Android 12","(Android phone and tablets)","n/a","Supported for P6 for Android native Android app only.","iOS 18.x","(iPad and iPhone)","n/a","Supported for P6 for iOS native iOS app only.","Microsoft Outlook","Mozilla Thunderbird","Apple Mail","Android","Blackberry","n/a","Supported for Email Statusing Service only.","Only English Operating System environments are certified for Email Statusing Service.","*JRE Vendor Version - JRE is not a requirement for P6 EPPM. It is requirement only for AutoVue and JRE 1.8.0_311 is certified for this requirement.","Client and Browser","99015.htm");
Page[5]=new Array("P6 Professional Windows Client","Client OS/ Email Clients","Oracle database Client Version","Exceptions and Additional Information","Windows 11 (64 bit)","19.8","P6 EPPM supports only 64 bit versions of database clients for P6 Professional on 64 bit operating systems.","Database client is supported for P6 Professional only.","Chrome is recommended for optimal performance.","*OS Version:","Tested with the following fully localized international versions of Windows:","Arabic","Brazilian Portuguese","Chinese Simplified","Chinese Traditional","English","French","German","Italian","Japanese","Russian","Spanish","Korean","Dutch (Nederlands)","Hardware Requirements","4GB memory (minimum).","5GB disk space (minimum).","P6 Professional Windows Client","100294.htm");
Page[6]=new Array("This document covers the tested configurations for Primavera P6 EPPM Database, P6 Web, P6 Web Services, P6 Team Member Web, P6 Professional Cloud Connect and P6 Professional Version 25 cloud deployments.","Product","Exceptions and Additional Information","Oracle Primavera Cloud","Primavera Gateway 21.12","Primavera Unifier Version 25.12","Integration of Primavera Unifier through Primavera Gateway is tested when P6 EPPM Web Services is configured with Oracle database only.","Primavera Data Warehouse and Primavera Analytics","Product","Version","Exceptions and Additional Information","Analytics","25.12","The tested version of Analytics is the most recent version available.","Primavera Data Warehouse","25.4","The tested version of Primavera Data Warehouse is the most recent version available.","*Product - Refer to the Primavera Primavera Unifier Version 25, Primavera Gateway Version 25 and Oracle Primavera Cloud Version 25 Tested Configurations for more info.","Other Primavera Applications","99016.htm");
Page[7]=new Array("Language Code","Language","Exceptions and Additional Information","AR","Arabic","English help","PT_BR","Brazilian Portuguese","English help","CH_CN","Chinese Simplified","Localized help","CH_TW","Chinese Traditional","English help","EN","English","English help","NL","Dutch","English help","FR","French","Localized help","DE","German","Localized help","IT","Italian","English help","JA","Japanese","Localized help","RU","Russian","English help","ES_ES","Spanish","English help","KO","Korean","Localized help","PL","Polish","English help, only P6 Team Member Web is supported","CS","Czech","English help, only P6 Team Member Web is supported","Localization","100237.htm");
var PageCount=8;


/*
Date: 12/11/2025 7:44 PM
Source: EPPM_25_dev
BookID: 99011
PubProduct: PRIMAVERA_EPPM
BookTitle: Client System Requirements
Version: Version 25
Lang:	en
*/
	var PageLength=Page.length;
	var Result = "";
	var ResultTemp = "";
	var ResultFound = "";
	var ResultTitleOnly = [];
	var ResultTitleAndContent = [];
	var ResultInContent = [];
	var ResultInContentTemp = [];

	var ResultCombinedTemp = [];
	var ResultCombined = [];

	var arrayIndex = 0;
	var NrRes = 0;
	var j = 0;
	var i = 0;
	var k = 0;
	var d = 0;
	var maxItems = 1000;
	var heading = 0;
	var WordPos = -1;
	var WordPosHeading = -1;
	var WordPosContentText = -1;
	var FoundWord = "";
	var FoundWordHead = "";
	var SearchInHeadingOnly = 0;
	var isChecked;
	var size = 10;
	var resGroupCounter = 0;
	var shown = "shown";
	var checkBoxInHeading;
	var searchFlag = 0;
	var DivResult;
	var SearchWord;

if (SearchText && SearchText.length >= 1) {
		SearchWord = SearchText.replace(/\+/g, " ").replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;");
		searchFlag = 1;
	} else {
		SearchWord = "";
		searchFlag = 0;
	}
	

	if (searchFlag === 1) {
		Result = "";

		// checkBoxInHeading = document.getElementById("inHeading");
		if (inHeading) {

			isChecked = true;
		} else {

			isChecked = false;
		}

		if (SearchWord && SearchWord.length >= 1) {
			if (isChecked) {
				SearchInHeadingOnly = 1;
			} else {
				SearchInHeadingOnly = 0;
			}
			SearchWord = SearchWord.toLowerCase();
			window.status = "Searching, please wait...";
			for (j = 0; j < PageLength; j++) {
				k = Page[j].length - 1;
				for (i = 0; i < k; i++) {

					heading = k - 1;

					if (SearchInHeadingOnly === 1) {
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPosHeading > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);

							NrRes++;
							ResultTemp = "<li>";
							ResultTemp += "<span>";
							ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							ResultTitleOnly[arrayIndex] = ResultTemp;
							arrayIndex++;

							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}
					} else if (SearchInHeadingOnly === 0) {
						WordPos = Page[j][i].toLowerCase().indexOf(SearchWord);
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPos > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							NrRes++;
							ResultTemp += "<li>";
							ResultTemp += "<span>";
							if (WordPosHeading > -1) {
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";
							} else {
								// found word is not in the head
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading] + "</a><br/>\n";

							}
							if (i < k - 1) {
								WordPosContentText = Page[j][i].toLowerCase().indexOf(SearchWord);

								if (Page[j][i].length > 300 && (WordPosContentText > -1)) {

									if (WordPosContentText > 75) {
										ResultInContentTemp.push("..." + Page[j][i].substr(WordPosContentText - 75, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");
									} else {
										ResultInContentTemp.push("..." + Page[j][i].substr(0, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");

									}

								} else if (WordPosContentText > -1) {

									ResultInContentTemp.push(Page[j][i].replace(FoundWord, FoundWord.bold()));

								}
							}

							ResultTemp += ResultInContentTemp.join("");

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							if (WordPosHeading > -1) {
								ResultTitleAndContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							} else {
								ResultInContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							}

							ResultInContentTemp.length = 0;
							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}

					}
				}
			}

			ResultTitleOnly = ResultTitleOnly.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultTitleAndContent = ResultTitleAndContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultInContent = ResultInContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			ResultCombinedTemp = ResultTitleOnly.concat(ResultTitleAndContent, ResultInContent);

			ResultCombinedTemp = ResultCombinedTemp.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			for (d = 0; d < ResultCombinedTemp.length; d += size) {
				resGroupCounter++
				ResultCombined.push("<div id=" + "'" + "resGroup_" + resGroupCounter + "'" + " class=" + "'" + "resGroup " + shown + "'" + ">" + "<ol class='searchResults'>" + ResultCombinedTemp.slice(d, d + size).join("") + "</ol></div>");
				shown = "notshown";
			}

			ResultFound = ResultCombined.join("");

Result += "<div id='searchDetailsDiv'>";
			Result += "<p class='searchDetails'>Your Search Found&nbsp;" + NrRes + "&nbsp;items.&nbsp;";
			Result += "</p></div>";
			
			Result += "<div class='searchResultsDiv'>";
			Result += "<div id='resultsCollection' class='searchResults'>";
			Result += ResultFound;
			Result += "</div>";
			Result += "</div>";
			Result += "<div class='searchPaging'>";

			Result += '<hr />';

			Result += '<p class="bodytext"><a class="disabledAnchor" id="pBack" onclick="turnPage(\'backPage\')" href="#pBack">Back</a>&nbsp; | &nbsp;';
			
			if (resGroupCounter && resGroupCounter > 1) {
				Result += '<a id="pNext" onclick="turnPage(\'nextPage\')" href="#pNext">Next</a>';
			} else {
				Result += '<a id="pNext"  class="disabledAnchor" href="#pNext">Next</a>';
			}
			Result += '</p>\n';
			Result += '<div id="pagenofn"><p class="bodytext">Page <span id="pagen">1</span> of ' + resGroupCounter + '</p></div>';

			Result += "</div>";
			
			
		}

		DivResult = document.getElementById("s_anchor");
		if (Result && DivResult) {

			//myDivResult.append(Result);
			DivResult.innerHTML = Result;
			

		}
		window.status = "";
		
		

	}
	}())
}
