'use strict';
function search(SearchText, inHeading) {
(function () {
var Page = [];

/* Generated with Author-it 23.4.1.30004  12/9/2025 1:46:22 PM */
Page[0]=new Array("Title and Copyright Information","Copyright  1999, 2025, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information","46576.htm");
Page[1]=new Array("This guide details how data is mapped between P6 EPPM and XLSX format. Throughout this guide, the term P6 EPPM includes P6 Professional. Any content that applies to only one of these applications is labeled accordingly.","All users who want to exchange data between P6 EPPM and other systems using XLSX format should use this document.","Note","Columns marked with an asterisk in the export file are calculated fields or non-importable fields and are ignored during import. If you modify a field name in the export file, the column will be ignored during import. Refer to the P6 EPPM Importing and Exporting Guide for more information about importing this data.","You cannot import any global data that does not currently exist in the P6 EPPM database. Project codes cannot be updated or imported.","If you modify a field name in the export file, the column will be ignored during import.","Caution Personal information (PI) may be at risk of exposure. Depending on local data protection laws organizations may be responsible for mitigating any risk of exposure.","About This Guide","97785.htm");
Page[2]=new Array("Columns","Field Name in XLSX","Activity % Complete","complete_pct","Activity ID ","task_code","Activity Name","task_name","Activity Status","status_code","Actual Finish","act_end_date","Actual Start","act_start_date","Calendar","clndr_id","Percent Complete Type","complete_pct_type","Planned Duration (P6 EPPM)","Original Duration or Planned Duration (P6 Professional) ","target_drtn_hr_cnt","Primary Constraint","cstr_type","Primary Constraint Date","cstr_date","Remaining Duration","remain_drtn_hr_cnt","Secondary Constraint","cstr_type2","Secondary Constraint Date","cstr_date2","WBS Code","wbs_id","Project Codes","proj_catg_XXXXX_id","Activity Codes","actv_code_XXXX_id","All UDFs","user_field_XXXX","Column to Field Name Mapping","97837.htm");
Page[3]=new Array("Note","Hierarchical information relating to cost accounts is not exported to Excel. Ensure that cost account IDs are unique throughout the entire dictionary. Any cost accounts that do not have unique cost account IDs will be overwritten during the import process. For example, if cost account A and cost account B each have child cost accounts assigned cost account ID 1, cost account A.1 and B.1 are both exported to Excel with the Cost Account ID of 1. Renaming these child cost accounts as A1 and B1 ensures that there will be no conflict when the data is imported. ","The activity status column is included in the Expenses, Resource Assignments, and Activity Relationships sections of the export file only for reference, but is ignored during import. To update the activity status, modify the activity status column in the activities subject area of the import file. ","Columns","Field Name in XLSX","Activity ID","task_id","Actual Cost","act_cost","Actual Units","act_units","At Completion Cost","total_cost","At Completion Units","at_completion_units","Cost Account ID","acct_id","Document Number","po_number","Expense Description","cost_descr","Expense Item","cost_name","Planned Cost (P6 EPPM)","Budgeted Cost or Planned Cost (P6 Professional) ","target_cost","Planned Units (P6 EPPM)","Budgeted Units or Planned Units (P6 Professional) ","target_qty","Remaining Cost","remain_cost","Remaining Units","remain_units","Unit of Measure","qty_name","Vendor","vendor_name","All UDFs","Expenses Columns and Fields Imported from XLSX Files","97838.htm");
Page[4]=new Array("Columns","Field Name in XLSX","Lag","lag_hr_cnt","Predecessor ","pred_task_id","Relationship Type ","pred_type","Successor ","task_id","Relationships Columns and Fields Imported from XLSX files","97839.htm");
Page[5]=new Array("Columns","Field Name in XLSX","Calendar","clndr_id","Default Units / Time","def_qty_per_hr","Email Address","email_addr","Employee ID","employee_code","Office Phone","office_phone","Other Phone","other_phone","Resource ID","rsrc_short_name","Resource Name","rsrc_name","Title","rsrc_title_name","Unit of Measure","unit_id","User Login Name","user_id","Resource Codes","rsrc_catg_XXXXXX_id","All UDFs","Resources Columns and Fields Imported from XLSX Files","97840.htm");
Page[6]=new Array("Columns ","Field Name in XLSX","Activity ID ","task_id","Actual Cost","act_cost","Actual Finish","act_end_date","Actual Start","act_start_date","Actual This Period Cost","act_this_per_cost","Actual This Period Units","act_this_per_qty","Actual Units","act_qty","At Completion Cost","total_cost","At Completion Units","total_qty","Cost Account ID ","acct_id","Curve","curv_id","Planned Cost (P6 EPPM)","Budgeted Cost or Planned Cost (P6 Professional) ","target_cost","Planned Duration (P6 EPPM)","Original Duration or Planned Duration (P6 Professional) ","target_drtn_hr_cnt","Planned Units (P6 EPPM)","Budgeted Units or Planned Units (P6 Professional) ","target_qty","Remaining Cost","remain_cost","Remaining Duration","remain_drtn_hr_cnt","Remaining Lag","remain_lag_drtn_hr_cnt","Remaining Units","remain_qty","Remaining Units/Time","remain_qty_per_hr","Resource ID ","rsrc_id","Role ID ","role_id","Unit of Measure","unit_of_measure","Units % Complete","effort_complete_pct","Assignment Codes","asgnmnt_catg_XXXX_id","Resource Codes","rsrc_catg_XXXXX_id","All UDFs","Note Hierarchical information relating to cost accounts is not exported to Excel. Ensure that Cost Account IDs are unique throughout the entire dictionary. Any cost accounts that do not have unique Cost Account IDs may be overwritten during the import process.","Resource Assignments Columns and Fields Imported from XLSX Files","97841.htm");
Page[7]=new Array("Activities","Activity ID","Activity Name","Activity Status","Finish","Resources","Start","WBS Code","Activity Relationships","Lag","Predecessor","Predecessor Activity Name","Predecessor Activity Status","Predecessor Primary Resource","Predecessor Project","Predecessor WBS","Relationship Type","Successor","Successor Activity Name","Successor Activity Status","Successor Primary Resource","Successor Project","Successor WBS","Expenses","Activity ID","Activity Status","Actual Cost","At Completion Cost","Expense Item","Planned Cost (P6 EPPM), Budgeted Cost or Cost (P6 Professional) ","Remaining Cost","Resources","Default Units/Time","Resource ID","Resource Name","Resource Type","Role ID","Unit of Measure","Resource Assignments","Activity ID","Activity Status","Cost Account ID","Finish","Price/Unit","Resource ID","Resource Type","Role ID","Start","Note","Italicized text indicates that the column is required for importing and exporting. The column cannot be removed from the export template and must exist in the import file to import successfully.","Default Columns Per Subject Area","97957.htm");
var PageCount=8;


/*
Date: 12/9/2025 1:46 PM
Source: EPPM_25_dev
BookID: 97556
PubProduct: PRIMAVERA_EPPM
BookTitle: XLSX Import/Export Data Map Guide
Version: Version 25
Lang:	en
*/
	var PageLength=Page.length;
	var Result = "";
	var ResultTemp = "";
	var ResultFound = "";
	var ResultTitleOnly = [];
	var ResultTitleAndContent = [];
	var ResultInContent = [];
	var ResultInContentTemp = [];

	var ResultCombinedTemp = [];
	var ResultCombined = [];

	var arrayIndex = 0;
	var NrRes = 0;
	var j = 0;
	var i = 0;
	var k = 0;
	var d = 0;
	var maxItems = 1000;
	var heading = 0;
	var WordPos = -1;
	var WordPosHeading = -1;
	var WordPosContentText = -1;
	var FoundWord = "";
	var FoundWordHead = "";
	var SearchInHeadingOnly = 0;
	var isChecked;
	var size = 10;
	var resGroupCounter = 0;
	var shown = "shown";
	var checkBoxInHeading;
	var searchFlag = 0;
	var DivResult;
	var SearchWord;

if (SearchText && SearchText.length >= 1) {
		SearchWord = SearchText.replace(/\+/g, " ").replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;");
		searchFlag = 1;
	} else {
		SearchWord = "";
		searchFlag = 0;
	}
	

	if (searchFlag === 1) {
		Result = "";

		// checkBoxInHeading = document.getElementById("inHeading");
		if (inHeading) {

			isChecked = true;
		} else {

			isChecked = false;
		}

		if (SearchWord && SearchWord.length >= 1) {
			if (isChecked) {
				SearchInHeadingOnly = 1;
			} else {
				SearchInHeadingOnly = 0;
			}
			SearchWord = SearchWord.toLowerCase();
			window.status = "Searching, please wait...";
			for (j = 0; j < PageLength; j++) {
				k = Page[j].length - 1;
				for (i = 0; i < k; i++) {

					heading = k - 1;

					if (SearchInHeadingOnly === 1) {
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPosHeading > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);

							NrRes++;
							ResultTemp = "<li>";
							ResultTemp += "<span>";
							ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							ResultTitleOnly[arrayIndex] = ResultTemp;
							arrayIndex++;

							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}
					} else if (SearchInHeadingOnly === 0) {
						WordPos = Page[j][i].toLowerCase().indexOf(SearchWord);
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPos > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							NrRes++;
							ResultTemp += "<li>";
							ResultTemp += "<span>";
							if (WordPosHeading > -1) {
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";
							} else {
								// found word is not in the head
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading] + "</a><br/>\n";

							}
							if (i < k - 1) {
								WordPosContentText = Page[j][i].toLowerCase().indexOf(SearchWord);

								if (Page[j][i].length > 300 && (WordPosContentText > -1)) {

									if (WordPosContentText > 75) {
										ResultInContentTemp.push("..." + Page[j][i].substr(WordPosContentText - 75, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");
									} else {
										ResultInContentTemp.push("..." + Page[j][i].substr(0, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");

									}

								} else if (WordPosContentText > -1) {

									ResultInContentTemp.push(Page[j][i].replace(FoundWord, FoundWord.bold()));

								}
							}

							ResultTemp += ResultInContentTemp.join("");

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							if (WordPosHeading > -1) {
								ResultTitleAndContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							} else {
								ResultInContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							}

							ResultInContentTemp.length = 0;
							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}

					}
				}
			}

			ResultTitleOnly = ResultTitleOnly.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultTitleAndContent = ResultTitleAndContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultInContent = ResultInContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			ResultCombinedTemp = ResultTitleOnly.concat(ResultTitleAndContent, ResultInContent);

			ResultCombinedTemp = ResultCombinedTemp.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			for (d = 0; d < ResultCombinedTemp.length; d += size) {
				resGroupCounter++
				ResultCombined.push("<div id=" + "'" + "resGroup_" + resGroupCounter + "'" + " class=" + "'" + "resGroup " + shown + "'" + ">" + "<ol class='searchResults'>" + ResultCombinedTemp.slice(d, d + size).join("") + "</ol></div>");
				shown = "notshown";
			}

			ResultFound = ResultCombined.join("");

Result += "<div id='searchDetailsDiv'>";
			Result += "<p class='searchDetails'>Your Search Found&nbsp;" + NrRes + "&nbsp;items.&nbsp;";
			Result += "</p></div>";
			
			Result += "<div class='searchResultsDiv'>";
			Result += "<div id='resultsCollection' class='searchResults'>";
			Result += ResultFound;
			Result += "</div>";
			Result += "</div>";
			Result += "<div class='searchPaging'>";

			Result += '<hr />';

			Result += '<p class="bodytext"><a class="disabledAnchor" id="pBack" onclick="turnPage(\'backPage\')" href="#pBack">Back</a>&nbsp; | &nbsp;';
			
			if (resGroupCounter && resGroupCounter > 1) {
				Result += '<a id="pNext" onclick="turnPage(\'nextPage\')" href="#pNext">Next</a>';
			} else {
				Result += '<a id="pNext"  class="disabledAnchor" href="#pNext">Next</a>';
			}
			Result += '</p>\n';
			Result += '<div id="pagenofn"><p class="bodytext">Page <span id="pagen">1</span> of ' + resGroupCounter + '</p></div>';

			Result += "</div>";
			
			
		}

		DivResult = document.getElementById("s_anchor");
		if (Result && DivResult) {

			//myDivResult.append(Result);
			DivResult.innerHTML = Result;
			

		}
		window.status = "";
		
		

	}
	}())
}
