'use strict';
function search(SearchText, inHeading) {
(function () {
var Page = [];

/* Generated with Author-it 23.4.1.30004  12/8/2025 10:53:36 AM */
Page[0]=new Array("Title and Copyright Information","Copyright  1999,  2025, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information","46576.htm");
Page[1]=new Array("This guide explains how to create SDEF files from your P6 Professional projects, including information about how to structure data in P6 Professional to ensure it is converted correctly to SDEF format.","Note Throughout this guide, we refer to P6 Professional, however with the exception of where to find the required utilities, all the information in this guide also applies to P6 EPPM.","About This Guide","50255.htm");
Page[2]=new Array("In 1986, the US Army Corps of Engineers recognized the need for a Standard Data Exchange Format (SDEF) to facilitate the exchange of data among contractors using various project management tools. The format chosen was a 132-character per line, fixed-length ASCII file, with data items, field positions, and field lengths explicitly defined by the SDEF specification.","The complete SDEF specification document is available online from the US Army Corps of Engineers official library for Engineer Regulation ER 1-1-11 dated June 15, 1995.","SDEF Overview","50256.htm");
Page[3]=new Array("You can exchange project data with other Primavera users by exporting projects to Oracle Primavera Proprietary Exchange Format (XER). You can then convert data between the XER and SDEF formats using the following utilities:","SDEF to XER (P330XERConvert.exe)","XER to SDEF (XERP330Convert.exe)","Locate the conversion utilities folder here:","P6 Professional:&lt;local drive&gt;\\Program Files\\Oracle\\Primavera P6\\P6 Professional","P6 Standalone: &lt;local drive&gt;\\Oracle\\Primavera P6\\P6 Professional","Use these SDEF conversion utilities when you want to:","Exchange project data with contractors and owners who do not use Oracle Primavera products.","Provide project data in the SDEF format whenever required by your contract.","Caution Personal information (PI) may be at risk of exposure. Depending on local data protection laws organizations may be responsible for mitigating any risk of exposure.","SDEF Conversion Utilities","50260.htm");
Page[4]=new Array("P6 Professional projects can store far more data than the SDEF specification requires. For example, the SDEF file structure allows for only one application of a resource per activity, while P6 Professional enables you to apply a resource to an activity repeatedly using assignment lags and durations.","P6 Professional projects intended for use with the SDEF interface should comply with the SDEF specification. There is no requirement to utilize the additional capabilities that P6 Professional offers because the SDEF file structure cannot store the additional data.","The following explains what you should expect and how you should structure your data when exchanging projects between P6 Professional and SDEF formats.","Restrictions Relating to Fields and Data Types","Activity description: The SDEF file structure only allows activity descriptions up to 30 characters long. When converting XER files exported from P6 Professional to SDEF, only the first 30 characters of the description are exported.","Activity ID: The SDEF standard does not support activity IDs longer than ten characters, while P6 Professional projects may contain activity IDs longer than ten characters. Activity IDs are truncated to the first ten characters when converting a project to SDEF. Due to this truncation, it is possible that duplicate activity IDs will be encountered during the conversion; if so, the conversion is aborted. To ensure that conversions to SDEF are not aborted, ensure projects do not contain activity IDs longer than ten characters. If activity IDs must be longer than ten characters in P6 Professional, the first ten characters must be unique.","Activity limit: SDEF files cannot contain more than 10,000 activities. When converting XER files to SDEF, only the first 10,000 activities are exported.","Activity totals: The SDEF file structure does not store individual resource budgets as XER does. Instead, SDEF stores total budgeted cost and total budgeted units for each activity. The conversion utility totals costs and units for each activity's resources in conformance with the SDEF standard.","Calendars: Calendars names in SDEF are only one character; therefore, calendar names from XER are truncated to one character. You are limited to 36 calendars in SDEF (A through Z and 0 through 9).","Cost per unit: The SDEF standard uses a calculated cost per unit for each activity. SDEF calculates the cost per unit as the activity's budget cost divided by its budget quantity. The Oracle Primavera SDEF conversion conforms to this standard.","Durations: The SDEF standard does not support durations longer than 999 days. If your P6 Professional project contains durations longer than 999 days, these durations will convert to zero in the SDEF file.","Expenses: The SDEF standard does not support expenses, so expenses are not exported to SDEF.","Milestones: The SDEF standard does not recognize the use of activities as milestones. If your project uses milestones, the converter stores these as zero-duration activities.","Suspend and resume dates: The SDEF standard does not recognize suspend and resume dates, so suspend and resume dates are not exported to SDEF.","Data mapping","The following table describes how some XER data is converted to SDEF.","SDEF Field","XER Field or Calculation","Total Qty","Planned Units for the activity assignment.","Cost Per Unit","Planned Cost divided by the Planned Units for the activity assignment.","Qty to Date","Actual Units for the activity assignment.","Activity Cost","Planned Cost for the activity assignment.","Cost to Date","Actual Regular Cost for the assignment plus the Stored Material Cost (STMA) amount for the activity.","Note The Stored Material Cost is derived from the Activity UDF named STMA. Refer to Required User-defined Field (STMA) for more information.","Required User-defined Fields","Some data fields required by the SDEF format do not exist in the XER format by default. You must create these fields as user-defined fields (UDFs) in P6 Professional.","When converting an SDEF file to XER, if these fields do not exist as UDFs in the XER project, they will be created automatically during the import process. If the UDFs were previously defined in P6 Professional (to be used for a different purpose), you should rename the pre-existing UDFs before importing an SDEF file.","When converting an XER file to SDEF, if these fields do not exist as UDFs in the XER, the SDEF fields will be blank when you convert the exported XER file to an SDEF file.","UDF Name","Data Type","Description","STMA","Number","The stored material cost data associated with an activity.","Contract Number","Text","The identifying number of the contract.","Note This field cannot be longer than six characters. If any values in this field are longer than six characters, the data will be truncated to the first six characters when you convert to SDEF.","Contractor Name","Text","The name of the contractor.","Note This field cannot be longer than 36 characters.","Required Activity Codes","The US Army Corps of Engineers requires all projects to use a predefined activity code structure. This structure specifies the name and maximum length of each activity code in the project. The SDEF format adheres to this structure; therefore, all P6 Professional projects being exported to SDEF format must have an activity code structure that exactly matches the predefined structure.","The following table shows the required activity code structure:","Code","Max Length","Description","WRKP","3","Workers Per day","RESP","4","Responsibility","AREA","4","Area","MODF","6","MOD or Claim #","BIDI","6","Bid Item","PHAS","2","Phase","CATW","1","Category of work","FOW","30","Feature of work","Note","The Description column is for your information only. XER does not support activity code descriptions, and SDEF does not require them. When creating the activity code structure, you only need to create each code and specify the maximum length. You also need to make sure you define each activity code as a global activity code.","When converted, the code value for the Feature of Work activity code displays in the Activity Codes Description column of the XER file, and a unique code value is generated by the converter. For all other activity codes, the code value displays in the Activity Codes Code Value column of the XER file.","Considerations When Converting a Project to SDEF","50257.htm");
Page[5]=new Array("Generating an SDEF file from P6 Professional is a two-step process. First you must export the project to an XER file, then you can convert the XER to SDEF format.","To export and convert an XER project to SDEF:","In P6 Professional, open the project you want to convert and export it to an XER file.","For specific instructions on exporting projects to an XER file, refer to the Importing and Exporting Guide.","Double-click XERP330Convert.exe to run the conversion utility.","Refer to SDEF Conversion Utilities for information about where to get the utility.","In the XER to SDEF Project Conversion dialog:","Click Browse to select the XER file you want to convert to SDEF, then click Next.","Enter the path and filename for the SDEF file you want to create, then click Next.","Select the Don't transfer costs option if applicable, then click Finish. ","Note The Don't transfer costs option is used primarily on cost reimbursement contracts where a firm fixed price does not exist.","Tip","When the conversion is complete, the utility creates a log file named [filename]_ConversionFromP3e.log. View the log file for information about the conversion, including problems that were encountered during the conversion.","Generating a Project in SDEF Format","50262.htm");
Page[6]=new Array("Importing an SDEF file to P6 Professional is a two-step process. First you must convert the SDEF file to XER, then you can import the XER file into P6 Professional. Once the file is imported, the project is accessible using P6 Professional.","To convert and import an SDEF file:","Double-click P330XERConvert.exe.","Refer to SDEF Conversion Utilities for information about where to get the utility.","In the SDEF to XER Project Conversion dialog:","Choose SDEF as the conversion type, then click Next.","Click Browse to select the SDEF file you want to convert, then click Next.","Click Browse to select the XER file you want to overwrite or enter a new XER filename, then click Next.","Click Finish.","Import the XER file to P6 Professional.","For specific instructions on importing XER files, refer to the Importing and Exporting Guide.","Importing a Project in SDEF Format","50261.htm");
var PageCount=7;


/*
Date: 12/8/2025 10:53 AM
Source: EPPM_25_dev
BookID: 50263
PubProduct: PRIMAVERA_P6_PRO
BookTitle: SDEF Conversion Guide for On-Premises
Version: Version 25
Lang:	en
*/
	var PageLength=Page.length;
	var Result = "";
	var ResultTemp = "";
	var ResultFound = "";
	var ResultTitleOnly = [];
	var ResultTitleAndContent = [];
	var ResultInContent = [];
	var ResultInContentTemp = [];

	var ResultCombinedTemp = [];
	var ResultCombined = [];

	var arrayIndex = 0;
	var NrRes = 0;
	var j = 0;
	var i = 0;
	var k = 0;
	var d = 0;
	var maxItems = 1000;
	var heading = 0;
	var WordPos = -1;
	var WordPosHeading = -1;
	var WordPosContentText = -1;
	var FoundWord = "";
	var FoundWordHead = "";
	var SearchInHeadingOnly = 0;
	var isChecked;
	var size = 10;
	var resGroupCounter = 0;
	var shown = "shown";
	var checkBoxInHeading;
	var searchFlag = 0;
	var DivResult;
	var SearchWord;

if (SearchText && SearchText.length >= 1) {
		SearchWord = SearchText.replace(/\+/g, " ").replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;");
		searchFlag = 1;
	} else {
		SearchWord = "";
		searchFlag = 0;
	}
	

	if (searchFlag === 1) {
		Result = "";

		// checkBoxInHeading = document.getElementById("inHeading");
		if (inHeading) {

			isChecked = true;
		} else {

			isChecked = false;
		}

		if (SearchWord && SearchWord.length >= 1) {
			if (isChecked) {
				SearchInHeadingOnly = 1;
			} else {
				SearchInHeadingOnly = 0;
			}
			SearchWord = SearchWord.toLowerCase();
			window.status = "Searching, please wait...";
			for (j = 0; j < PageLength; j++) {
				k = Page[j].length - 1;
				for (i = 0; i < k; i++) {

					heading = k - 1;

					if (SearchInHeadingOnly === 1) {
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPosHeading > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);

							NrRes++;
							ResultTemp = "<li>";
							ResultTemp += "<span>";
							ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							ResultTitleOnly[arrayIndex] = ResultTemp;
							arrayIndex++;

							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}
					} else if (SearchInHeadingOnly === 0) {
						WordPos = Page[j][i].toLowerCase().indexOf(SearchWord);
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPos > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							NrRes++;
							ResultTemp += "<li>";
							ResultTemp += "<span>";
							if (WordPosHeading > -1) {
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";
							} else {
								// found word is not in the head
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading] + "</a><br/>\n";

							}
							if (i < k - 1) {
								WordPosContentText = Page[j][i].toLowerCase().indexOf(SearchWord);

								if (Page[j][i].length > 300 && (WordPosContentText > -1)) {

									if (WordPosContentText > 75) {
										ResultInContentTemp.push("..." + Page[j][i].substr(WordPosContentText - 75, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");
									} else {
										ResultInContentTemp.push("..." + Page[j][i].substr(0, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");

									}

								} else if (WordPosContentText > -1) {

									ResultInContentTemp.push(Page[j][i].replace(FoundWord, FoundWord.bold()));

								}
							}

							ResultTemp += ResultInContentTemp.join("");

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							if (WordPosHeading > -1) {
								ResultTitleAndContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							} else {
								ResultInContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							}

							ResultInContentTemp.length = 0;
							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}

					}
				}
			}

			ResultTitleOnly = ResultTitleOnly.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultTitleAndContent = ResultTitleAndContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultInContent = ResultInContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			ResultCombinedTemp = ResultTitleOnly.concat(ResultTitleAndContent, ResultInContent);

			ResultCombinedTemp = ResultCombinedTemp.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			for (d = 0; d < ResultCombinedTemp.length; d += size) {
				resGroupCounter++
				ResultCombined.push("<div id=" + "'" + "resGroup_" + resGroupCounter + "'" + " class=" + "'" + "resGroup " + shown + "'" + ">" + "<ol class='searchResults'>" + ResultCombinedTemp.slice(d, d + size).join("") + "</ol></div>");
				shown = "notshown";
			}

			ResultFound = ResultCombined.join("");

Result += "<div id='searchDetailsDiv'>";
			Result += "<p class='searchDetails'>Your Search Found&nbsp;" + NrRes + "&nbsp;items.&nbsp;";
			Result += "</p></div>";
			
			Result += "<div class='searchResultsDiv'>";
			Result += "<div id='resultsCollection' class='searchResults'>";
			Result += ResultFound;
			Result += "</div>";
			Result += "</div>";
			Result += "<div class='searchPaging'>";

			Result += '<hr />';

			Result += '<p class="bodytext"><a class="disabledAnchor" id="pBack" onclick="turnPage(\'backPage\')" href="#pBack">Back</a>&nbsp; | &nbsp;';
			
			if (resGroupCounter && resGroupCounter > 1) {
				Result += '<a id="pNext" onclick="turnPage(\'nextPage\')" href="#pNext">Next</a>';
			} else {
				Result += '<a id="pNext"  class="disabledAnchor" href="#pNext">Next</a>';
			}
			Result += '</p>\n';
			Result += '<div id="pagenofn"><p class="bodytext">Page <span id="pagen">1</span> of ' + resGroupCounter + '</p></div>';

			Result += "</div>";
			
			
		}

		DivResult = document.getElementById("s_anchor");
		if (Result && DivResult) {

			//myDivResult.append(Result);
			DivResult.innerHTML = Result;
			

		}
		window.status = "";
		
		

	}
	}())
}
