'use strict';
function search(SearchText, inHeading) {
(function () {
var Page = [];

/* Generated with Author-it 23.4.1.30004  12/19/2024 11:09:59 AM */
Page[0]=new Array("Title and Copyright Information","Copyright  1999, 2025, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information","46576.htm");
Page[1]=new Array("Use this guide to understand how to use the P6 extended schema for reporting.","This guide is intended to be used by anyone who will create reports to be run against data in the P6 EPPM database.","About This Guide","102974.htm");
Page[2]=new Array("Personal information (PI) is any piece of data which can be used on its own or with other information to identify, contact or locate an individual or identify an individual in context. This information is not limited to a person's name, address, and contact details, for example a person's IP address, phone IMEI number, gender, and location at a particular time could all be personal information. Organizations are responsible for ensuring the privacy of PI wherever it is stored, including in back-ups, locally stored downloads, and data stored in development environments.","Caution: Personal information (PI) may be at risk of exposure. Depending on local data protection laws organizations may be responsible for mitigating any risk of exposure.","About Personal Information","97692.htm");
Page[3]=new Array("Within our documentation, some content might be specific for cloud deployments while other content is relevant for on-premises deployments. Any content that applies to only one of these deployments is labeled accordingly.","Understanding and Working with the P6 Extended Schema","66133.htm");
Page[4]=new Array("The P6 Extended Schema is the core database schema for P6 reporting. It allows for:","Access to views of P6 data tables","Access to more up-to-date calculated data than is available in the ODS ","Additional control over when data is calculated and stored","Introduced with P6 Release 8.1, the P6 Extended Schema combines the P6 database with additional calculated fields. The tables that make up the P6 Extended Schema are technically views. Views are predefined SQL queries of data from one or more database tables, with security applied. Though they are not tables, views can be called upon like tables in SQL queries when building reports. A database administrator account called PxRptUser serves as the schema owner and has access to all P6 Extended Schema views. ","Prior to the introduction of the P6 Extended Schema, calculated fields were only available via the ODS (Operational Data Store), which would typically be updated nightly. By comparison, the P6 Extended Schema can be updated on a near real-time basis. ","Understanding the P6 Extended Schema","65990.htm");
Page[5]=new Array("Data in the P6 Extended Schema is calculated and stored by Publication Services, which gives administrators control over when data is calculated and stored in the P6 Extended Schema. Publication Services exist for project and global data. Global data includes enterprise data, as well as resource and role, portfolio, security and audit data. Project data includes all information about projects and baselines, including summaries and calculations. ","The Publish Project service is dedicated to publishing project and baseline data to the P6 Extended Schema.","Note: The Publish Project service recalculates and publishes all project business objects containing calculated or denormalized data including, but not limited to: the WBS, activities, resource/role assignments, high-level planning assignments, relationships, risks, documents, expenses, steps, milestones, UDF values, notes, issues, budget change logs, timesheets, code assignments, funding source assignments.","These additional Publication Services publish global data to the P6 Extended Schema:","Publish Audit Data","Publish Enterprise Data","Project Data","Activity Data","Resource Data","Calendar Data","Enterprise Data dictionary definitions","Publish Enterprise Summaries","Publish Resource Management","Publish Security","The first time a data type is published to the P6 Extended Schema all data is recalculated and published to the extended schema tables. After a data type has been published for the first time, future publication services recalculate and publish only data that has changed since the last time that data was published.","When any of the publication services runs, each business object type processed by the service is individually timestamped, and the timestamp stored in the database. The services can accurately determine exactly which data has changed since the last time it was published using these timestamps because they exist at the individual business object type level.","Configure Publication Services in P6 as follows:","Set up automatic publication and enable P6 to publish project and global data on the Services page in Application settings. ","Enable the types of global data to be scheduled in Global Scheduled Services. ","Disable or enable publication for a selected project on the Services page in Project Preferences. ","Add, verify the status of, modify, or delete project management services on the Project Scheduled Services page. ","Tip","Run the global data services before turning on the Project Arbiter service.","Publication Services","66129.htm");
Page[6]=new Array("The P6 Extended Schema consists of multiple views. The number of fields in each view varies greatly, depending on what kind of data the view contains. To view a functional description of the type of data contained in a view, use the Oracle SQL Developer Data Modeler to view the DMD for the schema. ","Oracle provides support for reports written against the P6 Extended Schema views only. ","Note: In SQL databases you can select tables, views, and materialized views from the schema (for Oracle and Oracle Autonomous Databases, synonyms are also listed). See the Oracle Fusion Middleware Data Modeling Guide for Oracle Business Intelligence Publisher for further information.","Naming Convention","The synonyms that make up the P6 Extended Schema use the same naming convention as many of the logical views found in the ODS database, with the addition of a P6 prefix. For example, ACTIVITY in the ODS is P6ACTIVITY in the P6 Extended Schema. Every synonyms in the P6 Extended Schema has the prefix P6. ","In addition, the purpose of some views can be inferred from common elements in their names:","Hierarchy: Views with names containing the word HIERARCHY contain data needed to rebuild one of the parent-child structures from P6. For example, P6EPSHIERARCHY indicates the EPS nodes under which projects fall. ","Spread: Views with names containing the word SPREAD contain data in time-based segments. For example, P6ACTIVITYSPREAD contains units for activities by time period. ","Joining","Since the P6 Extended Schema consists of views, and not actual database tables, primary and foreign keys are not hard-wired into the schema. However, a view often contains an OBJECTID field which can be used to join it to another view. ","For example, to join the P6PROJECT view to the P6ACTIVITY view, you could use the OBJECTID field from the P6PROJECT view and the PROJECTOBJECTID field from P6ACTIVITY. Here, the OBJECTID field in P6PROJECT serves as a unique identifier for projects, and PROJECTOBJECTID in P6ACTIVITY also serves as a unique identifier for projects. P6ACTIVITY contains its own OBJECTID field, but it cannot be used to join P6ACTIVITY to P6PROJECT because the OBJECTID in the P6ACTIVITY view serves as a unique identifier for activities. ","Security","If your organization uses an Oracle or Oracle Autonomous Database database, your P6 security privileges determine which P6 Extended Schema view data you can access.","If your organization uses Microsoft SQL Server, P6 security privileges are not enforced in your P6 reporting software. Instead, you must add security to each report query via a WHERE clause.","Working with the P6 Extended Schema","66043.htm");
Page[7]=new Array("Oracle SQL Developer Data Modeler is a data modeling and database design tool that provides an environment for capturing, modeling, and managing database metadata. SQL Developer Data Modeler allows you to create, browse and edit, logical, relational, physical, multi-dimensional, and data type models. P6 users can download SQL Developer Data Modeler and use it to:","View the P6 Extended Schema's DMD (Data Model Definition).","Display P6 Extended Schema view functional descriptions.","View the P6 database tables from which P6 Extended Schema data.","SQL Developer Data Modeler is a stand-alone product, available for download from the Oracle Technology Network (OTN) or as an extension to Oracle SQL Developer 3.0.","SQL Developer Data Modeler and the P6 Extended Schema","P6 report builders can use the SQL Developer Data Modeler to view the P6 Extended Schema's DMD. The DMD contains additional information on P6 Extended Schema views. ","To open the P6 Extended Schema's DMD in SQL Developer Data Modeler, click Open on the File menu, and then browse to and select the P6 Extended Schema's DMD. ","Locating a P6 Extended Schema View's Functional Description","For each P6 Extended Schema view, SQL Developer Data Modeler contains a description of its related P6 function. These descriptions may help you identify which tables to use in reports. ","To access a view's functional description, right-click on a view and select Properties. The View Properties dialog box is displayed. In the View Properties dialog box, select Comments in RDBMS. The Comments in RDBMS field contains a description of the P6 function related to the selected P6 Extended Schema view.","Locating a P6 Extended Schema View's Source Tables","Use the Query Builder within the SQL Developer Data Modeler to display a view's underlying SQL query. ","Right-click a view and select Properties to display the View Properties dialog box. In the General section of the View Properties dialog box, click Query to display the SQL Developer Data Modeler's Query Builder. The bottom field of the Query Builder contains the view's SQL query, including SELECT statements and a FROM clause. Scroll down in the bottom field until you see a FROM clause. ","The FROM clause dictates the P6 database table from which the corresponding view is derived. For example, RESOURCES, in a FROM clause denotes that the P6RESOURCES Extended Schema view retrieves its data from the RESOURCES P6 database table. ","Oracle SQL Developer Data Modeler","66044.htm");
var PageCount=8;


/*
Date: 12/19/2024 11:09 AM
Source: EPPM_25_dev
BookID: 66042
PubProduct: PRIMAVERA_EPPM
BookTitle: Extended Schema Guide
Version: Version 25
Lang:	en
*/
	var PageLength=Page.length;
	var Result = "";
	var ResultTemp = "";
	var ResultFound = "";
	var ResultTitleOnly = [];
	var ResultTitleAndContent = [];
	var ResultInContent = [];
	var ResultInContentTemp = [];

	var ResultCombinedTemp = [];
	var ResultCombined = [];

	var arrayIndex = 0;
	var NrRes = 0;
	var j = 0;
	var i = 0;
	var k = 0;
	var d = 0;
	var maxItems = 1000;
	var heading = 0;
	var WordPos = -1;
	var WordPosHeading = -1;
	var WordPosContentText = -1;
	var FoundWord = "";
	var FoundWordHead = "";
	var SearchInHeadingOnly = 0;
	var isChecked;
	var size = 10;
	var resGroupCounter = 0;
	var shown = "shown";
	var checkBoxInHeading;
	var searchFlag = 0;
	var DivResult;
	var SearchWord;

if (SearchText && SearchText.length >= 1) {
		SearchWord = SearchText.replace(/\+/g, " ").replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;");
		searchFlag = 1;
	} else {
		SearchWord = "";
		searchFlag = 0;
	}
	

	if (searchFlag === 1) {
		Result = "";

		// checkBoxInHeading = document.getElementById("inHeading");
		if (inHeading) {

			isChecked = true;
		} else {

			isChecked = false;
		}

		if (SearchWord && SearchWord.length >= 1) {
			if (isChecked) {
				SearchInHeadingOnly = 1;
			} else {
				SearchInHeadingOnly = 0;
			}
			SearchWord = SearchWord.toLowerCase();
			window.status = "Searching, please wait...";
			for (j = 0; j < PageLength; j++) {
				k = Page[j].length - 1;
				for (i = 0; i < k; i++) {

					heading = k - 1;

					if (SearchInHeadingOnly === 1) {
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPosHeading > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);

							NrRes++;
							ResultTemp = "<li>";
							ResultTemp += "<span>";
							ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							ResultTitleOnly[arrayIndex] = ResultTemp;
							arrayIndex++;

							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}
					} else if (SearchInHeadingOnly === 0) {
						WordPos = Page[j][i].toLowerCase().indexOf(SearchWord);
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPos > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							NrRes++;
							ResultTemp += "<li>";
							ResultTemp += "<span>";
							if (WordPosHeading > -1) {
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";
							} else {
								// found word is not in the head
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading] + "</a><br/>\n";

							}
							if (i < k - 1) {
								WordPosContentText = Page[j][i].toLowerCase().indexOf(SearchWord);

								if (Page[j][i].length > 300 && (WordPosContentText > -1)) {

									if (WordPosContentText > 75) {
										ResultInContentTemp.push("..." + Page[j][i].substr(WordPosContentText - 75, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");
									} else {
										ResultInContentTemp.push("..." + Page[j][i].substr(0, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");

									}

								} else if (WordPosContentText > -1) {

									ResultInContentTemp.push(Page[j][i].replace(FoundWord, FoundWord.bold()));

								}
							}

							ResultTemp += ResultInContentTemp.join("");

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							if (WordPosHeading > -1) {
								ResultTitleAndContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							} else {
								ResultInContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							}

							ResultInContentTemp.length = 0;
							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}

					}
				}
			}

			ResultTitleOnly = ResultTitleOnly.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultTitleAndContent = ResultTitleAndContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultInContent = ResultInContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			ResultCombinedTemp = ResultTitleOnly.concat(ResultTitleAndContent, ResultInContent);

			ResultCombinedTemp = ResultCombinedTemp.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			for (d = 0; d < ResultCombinedTemp.length; d += size) {
				resGroupCounter++
				ResultCombined.push("<div id=" + "'" + "resGroup_" + resGroupCounter + "'" + " class=" + "'" + "resGroup " + shown + "'" + ">" + "<ol class='searchResults'>" + ResultCombinedTemp.slice(d, d + size).join("") + "</ol></div>");
				shown = "notshown";
			}

			ResultFound = ResultCombined.join("");

Result += "<div id='searchDetailsDiv'>";
			Result += "<p class='searchDetails'>Your Search Found&nbsp;" + NrRes + "&nbsp;items.&nbsp;";
			Result += "</p></div>";
			
			Result += "<div class='searchResultsDiv'>";
			Result += "<div id='resultsCollection' class='searchResults'>";
			Result += ResultFound;
			Result += "</div>";
			Result += "</div>";
			Result += "<div class='searchPaging'>";

			Result += '<hr />';

			Result += '<p class="bodytext"><a class="disabledAnchor" id="pBack" onclick="turnPage(\'backPage\')" href="#pBack">Back</a>&nbsp; | &nbsp;';
			
			if (resGroupCounter && resGroupCounter > 1) {
				Result += '<a id="pNext" onclick="turnPage(\'nextPage\')" href="#pNext">Next</a>';
			} else {
				Result += '<a id="pNext"  class="disabledAnchor" href="#pNext">Next</a>';
			}
			Result += '</p>\n';
			Result += '<div id="pagenofn"><p class="bodytext">Page <span id="pagen">1</span> of ' + resGroupCounter + '</p></div>';

			Result += "</div>";
			
			
		}

		DivResult = document.getElementById("s_anchor");
		if (Result && DivResult) {

			//myDivResult.append(Result);
			DivResult.innerHTML = Result;
			

		}
		window.status = "";
		
		

	}
	}())
}
