'use strict';
function search(SearchText, inHeading) {
(function () {
var Page = [];

/* Generated with Author-it 23.4.1.30004  12/9/2025 1:55:26 PM */
Page[0]=new Array("Title and Copyright Information","Copyright  1999, 2025, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information","46576.htm");
Page[1]=new Array("This guide details how data is mapped between P6 EPPM and the US Department of Energy's CPP format.","All users who want to exchange data between P6 EPPM and other systems using CPP format should use this document.","Note All date fields are exported as date only, without the time. All units, durations, and float fields are exported as hours.","Caution Personal information (PI) may be at risk of exposure. Depending on local data protection laws organizations may be responsible for mitigating any risk of exposure.","About This Guide","101827.htm");
Page[2]=new Array("To populate the CPP project, you must map the relevant CPP fields to appropriately configured codes, UDFs, or notebook topics. The Auto Map feature searches P6 EPPM codes, UDFs, and notebook topics for names matching the required CPP fields and configures the mapping accordingly. Alternatively, you can create the mapping manually or use a mixture of manual mapping and Auto Map to populate the map.","If you select to run Auto Map when some of the CPP fields have already been mapped, P6 gives two options:","You can choose to retain the fields that have already been mapped and Auto Map will map only those fields that have not yet been mapped.","Or you can choose to remap all fields.","The table below describes the fields Auto Map searches in order to populate the CPP mapping for each data type. The order of priority is used to determine which code, UDF, or notebook topic to map if there are multiple codes, UDFs, or notebook topics with names similar to the CPP field name being mapped.","CPP DS Code","CPP Field Name","Priority 1","Priority 2","Priority 3","Priority 4","Priority 5","DS_04","description","Activity UDF","Activity Code (Global)","Activity Code (EPS)","Activity Code (Project)","DS_04","subtype","Activity Code (Global)","Activity Code (EPS)","Activity UDF","Activity Code (Project)","DS_04","milestone_level","Activity UDF","Activity Code (Global)","Activity Code (EPS)","Activity Code (Project)","DS_04","milestone_level_description","Activity UDF","Activity Code (Global)","Activity Code (EPS)","Activity Code (Project)","DS_04","WBS_ID","WBS UDF","Activity UDF","Activity Code (Global)","Activity Code (EPS)","Activity Code (Project)","DS_04","justification_WBS","WBS UDF","Activity UDF","Activity Code (Global)","Activity Code (EPS)","Activity Code (Project)","DS_04","CAM","WBS UDF","Activity Code (Global)","Activity Code (EPS)","Activity UDF","Activity Code (Project)","DS_04","EVT","WBS UDF","Activity Code (Global)","Activity Code (EPS)","Activity UDF","Activity Code (Project)","DS_04","justification_EVT","WBS UDF","Activity Code (Global)","Activity Code (EPS)","Activity UDF","Activity Code (Project)","DS_04","justification_float_high","Activity UDF","Activity Code (Global)","Activity Code (EPS)","Activity Code (Project)","DS_04","justification_lag","Activity UDF","Activity Code (Global)","Activity Code (EPS)","Activity Code (Project)","DS_04","RMT_ID","Activity Code (Global)","Activity Code (EPS)","Activity UDF","Activity Code (Project)","DS_04","justification_constraint_hard","Notebook Topics","Activity UDF","Activity Code (Global)","Activity Code (EPS)","Activity Code (Project)","DS_04","justification_constraint_soft","Notebook Topics","Activity UDF","Activity Code (Global)","Activity Code (EPS)","Activity Code (Project)","DS_04","justification_constraint_secondary","Notebook Topics","Activity UDF","Activity Code (Global)","Activity Code (EPS)","Activity Code (Project)","DS_04","HDV_CI_ID","Activity Code (Global)","Activity Code (EPS)","Activity UDF","Activity Code (Project)","DS_04","RPG","Activity Code (Global)","Activity Code (EPS)","Activity UDF","Activity Code (Project)","WBS UDF","DS_06","EOC","Resource Code","Assignment Code","Resource UDF","Assignment UDF","DS_18","EU_min_days","Activity UDF","Activity Code (Global)","Activity Code (EPS)","Activity Code (Project)","WBS UDF","DS_18","EU_likely_days","Activity UDF","Activity Code (Global)","Activity Code (EPS)","Activity Code (Project)","WBS UDF","DS_18","EU_max_days","Activity UDF","Activity Code (Global)","Activity Code (EPS)","Activity Code (Project)","WBS UDF","DS_18","justification_EU","Activity UDF","Activity Code (Global)","Activity Code (EPS)","Activity Code (Project)","WBS UDF","Auto Map Functionality","101828.htm");
Page[3]=new Array("Many of the data elements you export with your CPP files may be mapped to Activity Codes. By default, P6 EPPM exports the code values only. However if you have many levels to your hierarchical activity codes, you might prefer to export the full hierarchical path to the code value instead.","To export the code value path:","Click Projects.","On the Projects navigation bar, click EPS.","On the EPS page:","Click the Actions&nbsp;@ menu and select Import/Export Projects.","In the Import/Export Projects dialog box, click the Export tab.","On the Export tab:","Select DOD - CPP from the Export Type list.","Select a project.","Click Manage Templates.","In the Manage CPP Templates dialog box, click the name of the template you want to configure","In the CPP Template dialog box, double click into a cell in the Mapping column, then click @&nbsp;Select.","In the Select Field Name dialog box:","On the Select a Code Type list, select any code.","Select the Include code value path option.","Select the code to map to the field.","Click Select.","Code Values","102774.htm");
Page[4]=new Array("Where there are duplicate assignments on an activity, the duplicated assignments are exported as a single assignment.","Assignments are considered to be duplicates of each other if:","The same resource is assigned to an activity more than once, without role assignments.","The same role is assigned to an activity more than once, without resource assignments.","The same resource-role combination is assigned to an activity more than once.","Note If the contents of the field mapped to EOC (Element of Cost) are not the same for assignments identified as duplicates according to the definitions above, the export will stop and report an invalid EOC mapping.","Values for the rolled up assignment are calculated as follows:","CPP DS File","CPP Field Name","Calculation","Notes","DS06 Schedule Resources","start","Earliest start date of the duplicate assignments.","DS06 Schedule Resources","finish","Latest finish date of the duplicate assignments.","DS05 Schedule Logic","lag_remaining_days","Maximum lag of all predecessor activities.","This value is exported in days, as calculated according to the predecessor's calendar.","DS05 Schedule Logic","lag_planned_days","Maximum lag of all predecessor activities.","This value is exported in days, as calculated according to the predecessor's calendar.","DS06 Schedule Resources","budget_dollars","Aggregated planned cost of all duplicate assignments.","If an assignment is to a role only, without a resource, this field is exported as zero.","DS06 Schedule Resources","actual_dollars","Aggregated actual cost of all duplicate assignments.","If an assignment is to a role only, without a resource, this field is exported as zero.","DS06 Schedule Resources","remaining_dollars","Aggregated remaining cost of all duplicate assignments.","If an assignment is to a role only, without a resource, this field is exported as zero.","DS06 Schedule Resources","budget_units","Aggregated planned units of all duplicate assignments.","If an assignment is to a role only, without a resource, this field is exported as zero.","DS06 Schedule Resources","actual_units","Aggregated actual units of all duplicate assignments.","If an assignment is to a role only, without a resource, this field is exported as zero.","DS06 Schedule Resources","remaining_units","Aggregated remaining units of all duplicate assignments.","If an assignment is to a role only, without a resource, this field is exported as zero.","Duplicate Assignments","106908.htm");
Page[5]=new Array("Note Relationships to activities outside the set of projects being exported are represented by relationships to placeholder tasks with a subtype of SVT.","CPP Field Name","CPP Field Description","P6 Source","PARSID","Project Assessment and Reporting System identifier for the project submitted.","Entered in the template.","CPP_status_date","Contractor &quot;as-of&quot; date.","Entered in the template.","$schema","The JSON schema for this object.","Visible in the template. Not editable.","revision","Revision number for export.","Entered in the template.","schedule_type","Describes whether the schedule is a baseline (BL) or forecast (FC).","Project type (baseline or project).","task_ID","Task identifier.","Activity ID","type","Describes whether the task is an activity (A) or milestone (M).","Activity Type","Task dependent, resource dependent, level of effort, and WBS summary activities are assigned the type A.<br />Start milestones and finish milestones are assigned the type M.","description","Unique task description. This description should include a verb.","This field is mandatory.","Mapped in the template.","subtype","Task subtype selection. Restricted to: &quot;SVT&quot;, &quot;ZBA&quot;, or null.","SVT is a schedule visibility activity and is used to characterize potential impacts to the logic-driven network. Tasks of subtype SVT can be activities or milestones, but should not be performance management baseline activities, nor should they be resource loaded. The EVT (earned value technique) for SVT tasks defaults to level of effort.","ZBA is a zero budget activity and is used for fixed-price procurements. Tasks of subtype ZBA should be used on a limited basis and should not be resource loaded. The task_description for a ZBA activity must be prefixed with &quot;Payment Milestone\\&quot;.  The EVT (earned value technique) for ZBA tasks defaults to level of effort.","Mapped in the template.","milestone_level","Milestone level selection for tasks of DS04.type M, that identify key milestones, deliverables, and control point dates.","The schedule should include exactly one task with a milestone level of either 170 or 175 to signify the end of the project.","Restricted to the values described in Milestone Level Descriptions.","Mapped in the template.","milestone_level_description","A verb-based description of the milestone.","Mapped in the template.","WBS_ID","Work package (WP) or planning package (PP) WBS identifier.","This field is mandatory.","Mapped in the template.","justification_WBS","Justification narrative for situations where the WBS_ID is not WP or PP.","Mapped in the template.","CAM","Control account manager name in the format:","&lt;Last Name&gt; &lt;First Name&gt; &lt;Optional Middle Initial&gt;","Characters allowed are A-Z (Upper and lower case, latin characters only), 0-9, apostrophe, hyphen, and underscore. ","This field is mandatory.","Mapped in the template.","EVT","The earned value technique used. Milestones should have have EVT set to NA. If the EVT is coded as H, J, L, M, N, O, or P, provide an explanation in DS04.justification_EVT.","Restricted to the values described in EVT Selection Descriptions.","Mapped in the template.","justification_EVT","Justification narrative where DS04.EVT is H, J,  L, M, N, O, or P.","Mapped in the template.","EVT_J_to_task_ID","The task ID to which EVT is apportioned, if EVT is J.","Mapped in the template.","EVT_J_pct","The percent of EVT apportioned, if apportioned from a different task. The value should be between 0.00 and 1.00.","Mapped in the template.","ES_date","Early start date.","Early Start","EF_date","Early finish date.","Early Finish","LS_date","Late start date.","Late Start","LF_date","Late finish date.","Late Finish","AS_date","Actual start date.","Actual Start","AF_date","Actual finish date.","Actual Finish","duration_original_days","Original duration calculated using the activity calendar.","Original Duration / Planned Duration","duration_remaining_days","Remaining duration calculated using the activity calendar.","Remaining Duration","duration_actual_days","Actual duration calculated using the activity calendar.","Actual Duration","float_free_days","Free float calculated using the activity calendar.","Free Float","float_total_days","Total float calculated using the activity calendar.","Total Float","justification_float_high","Justification narrative for high float.","The value for high float is calculated as 10% of the number of calendar work days between the CPP_status_date and the end of the project. The end of the project for this definition is the early finish date of the final milestone of the project, i.e. the task with the milestone level of 170 or 175.","Mapped in the template.","justification_lag","Justification narrative for lag on relationship to predecessor. This should be populated when the value of DS05.lag_days is greater than zero.","Mapped in the template.","driving_path","Determines whether the task is on the longest path or (in P6) the driving path.","Restricted to:","Y","N","Longest Path","risk_ID","A semicolon-separated list of risks assigned to the task. The list of risks is only required if there is no Risk Mitigation Task (RMT) assigned to the task.","Maximum length: 50 characters.","Risk IDs assigned to the Activity.","RMT_ID","Unique identifier for a Risk Mitigation Task. Do not provide an RMT if there are risks assigned to the task listed in the risk_ID field.","Maximum length: 50 characters.","Mapped in the template.","PC_type","The percent complete type of the task.","Restricted to:","duration","physical","units","Percent complete type","PC_duration","Duration percent complete of the task, rounded to two decimal places. The value should be between zero and one.","Duration % Complete divided by 100.","PC_physical","Physical percent complete of the task, rounded to two decimal places. The value should be between zero and one.","Physical % Complete divided by 100.","PC_units","Units percent complete of the task, rounded to two decimal places. The value should be between zero and one.","Units % Complete divided by 100.","constraint_type","Primary constraint type.","Restricted to the values described in Constraint Selection Descriptions.","Primary Constraint Type","constraint_date","Primary constraint date.","Primary Constraint Date","justification_constraint_hard","Justification narrative if the constraint_type is a hard constraint.","Mapped in the template.","justification_constraint_soft","Justification narrative if the constraint_type is a soft constraint.","Mapped in the template.","justification_constraint_secondary","Justification narrative for secondary constraints applied to activities.","Mapped in the template.","HDV_CI_ID","High dollar value critical item  identifier.","Maximum length: 50 characters.","Mapped in the template.","RPG","Determines whether the task is for a reprogramming effort.","Restricted to:","Y","N","This field is mandatory and defaults to N.","Mapped in the template.","calendar_name","Task calendar name.","For resource dependent activities where all assigned resources use the same calendar, the resource's calendar is used. For resource dependent activities with no resource assignments or where the resources assign use different calendars, the activity calendar is used. For all other activity types, the activity calendar is used.","Calendar Name","subproject_ID","Unique subproject identifier, which can be used for SVT tasks or multi-project schedules.","Project ID","DS04 Schedule","101831.htm");
Page[6]=new Array("Milestone Level","Description","1xx"," DOE O 413.3B milestones. All 1xx are considered DS04.task_subtype SVT, unless otherwise noted.","100","approve start project","110","approve CD-0","111","approve CD-0R-01","112","approve CD-0R-02","120","approve CD-1","121","approve CD-1R-01","122","approve CD-1R-02","130","approve CD-2","131","approve BCP-01","132","approve BCP-02","133","approve BCP-03","134","approve BCP-04","135","approve BCP-05","138","approve reprogramming (not SVT) (Specify if OTB and/or OTS in DS04.milestone_level_description)","139","approve replan (not SVT)","140","approve CD-3A","141","approve CD-3B","142","approve CD-3C","143","approve CD-3D","144","approve CD-3E","145","approve CD-3F","150","approve CD-3","160","approve CD-4A","161","approve CD-4B","162","approve CD-4C","163","approve CD-4D","164","approve CD-4E","165","approve CD-4F","170","planned/estimated completion without UB","175","planned/estimated completion with UB","180","contract completion","190","approve CD-4","195","approve closeout","199","approve finish project","2xx","contract driven milestones and periods of performance","3xx","customer driven milestones. All 3xx are considered DS04.task_subtype SVT.","4xx","programmatic driven milestones","5xx","major internal driven milestones","6xx","minor internal driven milestones","7xx","external driven milestones, e.g., regulatory, consent decree. All 7xx are considered DS04.task_subtype SVT.","8xx","subK alignment milestones.","Milestone Level Descriptions","101897.htm");
Page[7]=new Array("EVT Value","EVT Description","A","Level of effort","B","Weighted milestones","C","Percent complete or for use in DS03, discrete (combination of discrete DS03.EVT excluding A, J, K, M, or NA)","D","Units complete","E","50-50","F","0-100","G","100-0","H","Variation of 50-50","J","Apportioned","K","Planning package","L","Assignment percent complete ","M","Calculated apportionment","N","Steps","O","Earned as spent","P","Percent manual entry","EVT Selection Descriptions","101899.htm");
Page[8]=new Array("Constraint Name","Constraint Type","Note","NA","None","-","CS_ASAP","As Soon As Possible","-","CS_MANDSTART","Mandatory Start","Hard constraint. Provide justification in DS04.justification_constraint_hard","CS_MSO","Must Start On","Hard constraint. Provide justification in DS04.justification_constraint_hard.","CS_MSOA","Must Start On Or After","Soft constraint: DS04.justification_constraint_soft.","CS_MSOB","Must Start On Or Before","Hard constraint. Provide justification in DS04.justification_constraint_hard.","CS_MANDFIN","Mandatory Finish","Hard constraint. Provide justification in DS04.justification_constraint_hard.","CS_MEO","Must Finish On","Hard constraint. Provide justification in DS04.justification_constraint_hard.","CS_MEOA","Must Finish On Or After","Soft constraint: DS04.justification_constraint_soft.","CS_MEOB","Must Finish On Or Before","Hard constraint. Provide justification in DS04.justification_constraint_hard.","Constraint Selection Descriptions","101902.htm");
Page[9]=new Array("Note Relationships to activities outside the set of projects being exported are represented by relationships to placeholder tasks with a subtype of SVT.","CPP Field Name","CPP Field Description","P6 Source","PARSID","Project Assessment and Reporting System identifier for the project submitted.","Entered in the template.","CPP_status_date","Contractor &quot;as-of&quot; date.","Entered in the template.","schedule_type","Describes whether the schedule is a baseline (BL) or forecast (FC).","Project type","task_ID","Task identifier of the successor.","Activity ID (Successor)","predecessor_task_ID","Task identifier of the predecessor.","Activity ID (Predecessor)","type","Determines whether the relationship between task and predecessor is finish to start (FS), start to start (SS), start to finish (SF), or finish to finish (FF)","Relationship Type","lag_days","Task relationship lag, based on predecessor's calendar. A positive figure represents lag, a negative figure represents lead.","Lag","subproject_ID","Unique subproject identifier.","Project Short Name of the predecessor activity's project.","DS05 Schedule Logic","101829.htm");
Page[10]=new Array("Note Duplicate assignments of resources and roles are rolled up and exported as a single assignment. See Duplicate Assignments","CPP Field Name","CPP Field Description","P6 Source","PARSID","Project Assessment and Reporting System identifier for the project submitted.","Entered in the template.","CPP_status_date","Contractor &quot;as-of&quot; date.","Entered in the template.","schedule_type","Describes whether the schedule is a baseline (BL) or forecast (FC).","Project type","task_ID","Task identifier.","Activity ID (Successor)","resource_ID","Resource identifier.","Resource ID","resource_name","Resource name.","Resource Name","role_ID","Role identifier.","Role ID","role_Name","Role name.","Role Name","type","Resource type.","Resource Type","EOC","Element of cost describes whether the cost associated with the resource is related to labor, subcontract, materials, indirect, or &quot; other direct costs&quot;. ","Restricted to:"," labor"," material"," ODC"," indirect"," subcontract","This field cannot be empty.","Mapped in the template.","start_date","Resource start date.","Start Date of the assignment.","finish_date","Resource finish date.","Finish Date of the assignment.","budget_dollars","Total budget in dollars.","Planned Cost","actual_dollars","Total actual in dollars.","Actual Cost","remaining_dollars","Total remaining in dollars.","Remaining Cost","budget_units","Total budgeted units.","The units of measure are specified in the UOM field.","Planned Units","actual_units","Total actual units.","The units of measure are specified in the UOM field.","Actual Units","remaining_units","Total remaining units.","The units of measure are specified in the UOM field.","Remaining Units","UOM","Unit of measure for budgeted_units, actual_units, and remaining_units fields.","If the resource type is labor or nonlabor, the value of the UOM is &quot;h&quot;.","If the resource is a material the value of UOM is derived from the Unit of Measure for the material resource.","If a material unit has not been specified, the value is &quot;units&quot;.","lag_planned_days","Task relationship planned lag, based on predecessor's calendar. A positive figure represents lag, a negative figure represents lead.","Planned Lag","lag_remaining_days","Task relationship remaining lag, based on predecessor's calendar. A positive figure represents lag, a negative figure represents lead.","Remaining Lag","calendar_name","The calendar name for the resource or role.","For resource assignments or resources with a role assignment, the resource's calendar is used. For role assignments, the activity calendar is used.","Calendar","subproject_ID","Unique subproject identifier, which can be used for SVT tasks or multi-project schedules.","Project ID","DS06 Schedule Resources","101830.htm");
Page[11]=new Array("CPP Field Name","CPP Field Description","P6 Source","PARSID","Project Assessment and Reporting System identifier for the project submitted.","Entered in the template.","CPP_status_date","Contractor &quot;as-of&quot; date.","Entered in the template.","schedule_type","Describes whether the schedule is a baseline (BL) or forecast (FC).","Project type","task_ID","Task identifier of the successor.","Activity ID (Successor)","EU_min_days","The minimum number of EU working days remaining.","This field is mandatory. Null values are converted to 0.00.","Mapped in the template.","EU_likely_days","The most likely number of EU working days remaining.","This field is mandatory. Null values are converted to 0.00.","Mapped in the template.","EU_max_days","The maximum number of EU working days remaining.","This field is mandatory. Null values are converted to 0.00.","Mapped in the template.","justification_EU","Justification narrative for situations where task EU distribution is not triangular.","Mapped in the template.","subproject_ID","Unique subproject identifier, which can be used for SVT tasks or multi-project schedules.","Project ID","DS18_schedule_EU","102161.htm");
Page[12]=new Array("CPP Field Name","CPP Field Description","P6 Source","calendar_name","Unique name for the calendar.","Calendar Name","hours_per_day","The number of hours in a working day.","Time Periods - Hours/Day","std_01_Mon_shift_A_start_time","Monday shift A start time, according to the standard work week.","Start time for first shift on Mondays.","std_01_Mon_shift_A_stop_time","Monday shift A finish time, according to the standard work week.","Finish time for first shift on Mondays.","std_01_Mon_shift_B_start_time","Monday shift B start time, according to the standard work week.","Start time for second shift on Mondays.","std_01_Mon_shift_B_stop_time","Monday shift B finish time, according to the standard work week.","Finish Time for second shift on Mondays.","std_01_Mon_shift_C_start_time","Monday shift C start time, according to the standard work week.","Start Time for third shift on Mondays.","std_01_Mon_shift_C_stop_time","Monday shift C finish time, according to the standard work week.","Finish Time for last shift on Mondays.","std_02_Tue_shift_A_start_time","Tuesday shift A start time, according to the standard work week.","Start time for first shift on Tuesdays.","std_02_Tue_shift_A_stop_time","Tuesday shift A finish time, according to the standard work week.","Finish Time for first shift on Tuesdays.","std_02_Tue_shift_B_start_time","Tuesday shift B start time, according to the standard work week.","Start Time for second shift on Tuesdays.","std_02_Tue_shift_B_stop_time","Tuesday shift B finish time, according to the standard work week.","Finish Time for second shift on Tuesdays.","std_02_Tue_shift_C_start_time","Tuesday shift C start time, according to the standard work week.","Start Time for third shift on Tuesdays.","std_02_Tue_shift_C_stop_time","Tuesday shift C finish time, according to the standard work week.","Finish Time for last shift on Tuesdays.","std_03_Wed_shift_A_start_time","Wednesday shift A start time, according to the standard work week.","Start Time for first shift on Wednesdays.","std_03_Wed_shift_A_stop_time","Wednesday shift A finish time, according to the standard work week.","Finish Time for first shift on Wednesdays.","std_03_Wed_shift_B_start_time","Wednesday shift B start time, according to the standard work week.","Start Time for second shift on Wednesdays.","std_03_Wed_shift_B_stop_time","Wednesday shift B finish time, according to the standard work week.","Finish Time for second shift on Wednesdays.","std_03_Wed_shift_C_start_time","Wednesday shift C start time, according to the standard work week.","Start Time for third shift on Wednesdays.","std_03_Wed_shift_C_stop_time","Wednesday shift C finish time, according to the standard work week.","Finish Time for last shift on Wednesdays.","std_04_Thu_shift_A_start_time","Thursday shift A start time, according to the standard work week.","Start Time for first shift on Thursdays.","std_04_Thu_shift_A_stop_time","Thursday shift A finish time, according to the standard work week.","Finish Time for first shift on Thursdays.","std_04_Thu_shift_B_start_time","Thursday shift B start time, according to the standard work week.","Start Time for second shift on Thursdays.","std_04_Thu_shift_B_stop_time","Thursday shift B finish time, according to the standard work week.","Finish Time for second shift on Thursdays.","std_04_Thu_shift_C_start_time","Thursday shift C start time, according to the standard work week.","Start Time for third shift on Thursdays.","std_04_Thu_shift_C_stop_time","Thursday shift C finish time, according to the standard work week.","Finish Time for last shift on Thursdays.","std_05_Fri_shift_A_start_time","Friday shift A start time, according to the standard work week.","Start Time for first shift on Fridays.","std_05_Fri_shift_A_stop_time","Friday shift A finish time, according to the standard work week.","Finish Time for first shift on Fridays.","std_05_Fri_shift_B_start_time","Friday shift B start time, according to the standard work week.","Start Time for second shift on Fridays.","std_05_Fri_shift_B_stop_time","Friday shift B finish time, according to the standard work week.","Finish Time for second shift on Fridays.","std_05_Fri_shift_C_start_time","Friday shift C start time, according to the standard work week.","Start Time for third shift on Fridays.","std_05_Fri_shift_C_stop_time","Friday shift C finish time, according to the standard work week.","Finish Time for last shift on Fridays.","std_06_Sat_shift_A_start_time","Saturday shift A start time, according to the standard work week.","Start Time for first shift on Saturdays.","std_06_Sat_shift_A_stop_time","Saturday shift A finish time, according to the standard work week.","Finish Time for first shift on Saturdays.","std_06_Sat_shift_B_start_time","Saturday shift B start time, according to the standard work week.","Start Time for second shift on Saturdays.","std_06_Sat_shift_B_stop_time","Saturday shift B finish time, according to the standard work week.","Finish Time for second shift on Saturdays.","std_06_Sat_shift_C_start_time","Saturday shift C start time, according to the standard work week.","Start Time for third shift on Saturdays.","std_06_Sat_shift_C_stop_time","Saturday shift C finish time, according to the standard work week.","Finish Time for last shift on Saturdays.","std_07_Sun_shift_A_start_time","Sunday shift A start time, according to the standard work week.","Start Time for first shift on Sundays.","std_07_Sun_shift_A_stop_time","Sunday shift A finish time, according to the standard work week.","Finish Time for first shift on Sundays.","std_07_Sun_shift_B_start_time","Sunday shift B start time, according to the standard work week.","Start Time for second shift on Sundays.","std_07_Sun_shift_B_stop_time","Sunday shift B finish time, according to the standard work week.","Finish Time for second shift  on Sundays.","std_07_Sun_shift_C_start_time","Sunday shift C start time, according to the standard work week.","Start Time for third shift  on Sundays.","std_07_Sun_shift_C_stop_time","Sunday shift C finish time, according to the standard work week.","Finish Time for last shift  on Sundays.","DS19_schedule_calendar_std","102162.htm");
Page[13]=new Array("CPP Field Name","CPP Field Description","P6 Source","calendar_name","Unique calendar name.","Align with DS21.calendar_name.","Calendar Name","exception_date","Date of exception","Associated calendar","exception_work_day","Determines whether the exception is a non-work day. If the exception is a work day, this field shows N. If it is a non-work day the field shows Y and shifts do not need to be provided.","Associated calendar","exception_shift_A_start_time","Exception shift A start time, according to the associated calendar.","Start Time for first shift on the day according to the exceptions in the associated calendar","exception_shift_A_stop_time","Exception shift A finish time, according to the associated calendar.","Finish Time for first shift on the day according to the exceptions in the associated calendar","exception_shift_B_start_time","Exception shift B start time, according to the associated calendar.","Start Time for second shift on the day according to the exceptions in the associated calendar","exception_shift_B_stop_time","Exception shift B finish time, according to the associated calendar.","Finish Time for second shift on the day according to the exceptions in the associated calendar","exception_shift_C_start_time","Exception shift C start time, according to the associated calendar.","Start Time for third shift on the day according to the exceptions in the associated calendar","exception_shift_C_stop_time","Exception shift C finish time, according to the associated calendar.","Finish Time for last shift on the day according to the exceptions in the associated calendar","DS20_schedule_calendar_exception","102163.htm");
Page[14]=new Array("Abbreviation","Description","#","number","$RAM","dollarized RAM","Ac","ACWP cumulative","Act","actual","ACWP","actual cost of work performed","ACWPc","ACWP cumulative","ACWPi","ACWP incremental","AF","actual finish","Ai","ACWP incremental","AS","actual start","ASAP","as soon as possible","ATC ","at completion","auth ","authorization","AUW ","authorized unpriced work","BAC ","budget at completion","BCP ","baseline change proposal","BCR ","baseline change request","BCR-C","BCR usage of contingency","BCR-M ","BCR usage of MR","BCR-P ","BCR usage of UB","BCWP ","budgeted cost for work performed","BCWPc ","BCWP cumulative","BCWPi ","BCWP incremental","BCWS ","budgeted cost for work scheduled","BCWSc ","BCWS cumulative","BCWSi ","BCWS incremental","bgt","budget","BL","baseline","BOM","bill of material","BWC","base work construct","c","cumulative","CA ","control account","CAL ","corrective action list","CAM ","control account manager","CBB ","contract budget base","CC ","change control or charge code","CD ","critical decision","CFSR","contract funds status report","CI","critical item","CLIN ","contract line item number","cmp ","type of EVMS cost tool software file","CNT ","DOE contingency","col. ","column","con ","contract","CPP ","contractor project performance","CPP+1","CPP, 1 month future","CPP-1 ","CPP, 1 month prior","CPP-2 ","CPP, 2 months prior","CPP-3 ","CPP, 3 months prior","CPP-5 ","CPP, 5 months prior","CPPSD","CPP supporting documentation","CS ","constraint","csv ","comma-separated value","cum ","cumulative","CV","cost variance","Cx","commissioning","D ","direct","DB","distributed budget ","DID ","data item descriptions","DMS ","document management system","DOE ","U.S. Department of Energy","DS","data set","e.g. ","for example","EAC ","estimate at completion","EACc ","EAC cumulative","EACi","EAC incremental","EE","Office of Energy Efficiency and Renewable Energy","EF","early finish","EFCO","Energy Facility Contractors Group","EIA ","Electronic Industries Alliance","EM","Office of Environmental Management","EOC","element of cost","ES ","early start","est ","estimate","ETC ","estimate to complete","ETCc","ETC cumulative","EU ","estimate uncertainty","EV ","earned value","EVM ","earned value management","EVMS ","earned value management system","EVT","earned value technique","F","format","F","FTE","fav","favorable","FC ","finish constraint","FC ","forecast","FE ","Office of Fossil Energy","FF ","finish to finish","FF ","flat file","FFTSCS","flat file to source crosswalk spreadsheet","FIFO","first-in, first-out","FS ","finish to start","FY ","fiscal year","GAO","U.S. Government Accountability Office","GL ","guideline","H","hours","HDV","high dollar value","I","indirect","i.e. ","that is","ID ","identifier","IMP ","integrated master plan","IMS ","integrated master schedule","inc ","incremental","IP2M","integrated project/program management","IPMR ","integrated program management report","JSON","JavaScript object notation","K","thousands of dollars","ktr","contractor","LF ","late finish","LIFO ","last-in, first-out","LOE","level of effort","LS ","late start","M","milestone","M ","month","max.","maximum","METRR ","maturity and environment total risk rating","MF","finish milestone","MIN or min.","minimum","MR","management reserve","MS","start milestone","NA","National Nuclear Security Administration","NA or N/A","not applicable","NCC","negotiated contract cost","NDIA","National Defense Industrial Association","NE","Office of Nuclear Energy","neg","negotiated","no","number","NTE","not-to-exceed","O","order","OBS","organization breakdown structure","ODC","other direct costs","OE","Office of Electricity","org","original","OTB","over-target baseline","OTS","over-target schedule","P","period","PARS","Project Assessment and Reporting System","PASEG","Planning &amp; Scheduling Excellence Guide","PB","performance baseline","PBB","project budget base","Pc","BCWP cumulative","PC","percent complete","pct","percent","PEP","project execution plan","perf","performance","Pi","BCWP incremental","PM","contractor project manager","PM","Office of Project Management","PMB","performance measurement baseline","PMP","project management plan","PO","purchase order","POC","point of contact","POP","period of performance","PP","planning package","PRJ","project summary","QBD","quantity basis document","QRA-CL","quantitative risk analysis confidence level","qty","quantity","RAM","responsibility assignment matrix","RC","root cause","RD","resource dependent","R&amp;D","research and development","rel","relationship","rem","remaining","rep","representative","req'd","required","RMT","risk mitigation task","RP","reporting period","RP","reporting period date (the associated CPP status date)","RP+1","next RP","RPG","formal reprogramming analysis","rpg","reprogramming adjustment","RPT","report","SC","Office of Science","SC","schedule contingency","SC","start contraint","SD","system description","SF","start to finish","SLPP","summary level planning package","SM","schedule margin","SOP","standard operating procedure","SOW","scope of work","SR","schedule reserve","SS","start to start","SU","start-up","subK","subcontract","subktr","subcontractor","SV","schedule variance","SVT","schedule visibility task","TAB","total allocated budget","TCPI","to-complete performance index","TD","task dependent","tgt","target","tot","total","UB","undistributed budget","UCNI","unclassified controlled nuclear information","unfav","unfavorable","UOM","unit of measure","v","version","VAC","variance at completion","VAR","variance","W","whole dollars","w/","with","w/o","without","WAD","work authorization document","WBS","work breakdown structure","WP","work package","WPM","WP manager","WS","WBS summary","X","numerator value or test flags","xer","type of IMS software file","Y","denominator value or test population","ZBA","zero budget activity ","CPP Glossary","101873.htm");
var PageCount=15;


/*
Date: 12/9/2025 1:55 PM
Source: EPPM_25_dev
BookID: 101921
PubProduct: PRIMAVERA_EPPM
BookTitle: CPP Import/Export Data Map Guide
Version: Version 25
Lang:	en
*/
	var PageLength=Page.length;
	var Result = "";
	var ResultTemp = "";
	var ResultFound = "";
	var ResultTitleOnly = [];
	var ResultTitleAndContent = [];
	var ResultInContent = [];
	var ResultInContentTemp = [];

	var ResultCombinedTemp = [];
	var ResultCombined = [];

	var arrayIndex = 0;
	var NrRes = 0;
	var j = 0;
	var i = 0;
	var k = 0;
	var d = 0;
	var maxItems = 1000;
	var heading = 0;
	var WordPos = -1;
	var WordPosHeading = -1;
	var WordPosContentText = -1;
	var FoundWord = "";
	var FoundWordHead = "";
	var SearchInHeadingOnly = 0;
	var isChecked;
	var size = 10;
	var resGroupCounter = 0;
	var shown = "shown";
	var checkBoxInHeading;
	var searchFlag = 0;
	var DivResult;
	var SearchWord;

if (SearchText && SearchText.length >= 1) {
		SearchWord = SearchText.replace(/\+/g, " ").replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;");
		searchFlag = 1;
	} else {
		SearchWord = "";
		searchFlag = 0;
	}
	

	if (searchFlag === 1) {
		Result = "";

		// checkBoxInHeading = document.getElementById("inHeading");
		if (inHeading) {

			isChecked = true;
		} else {

			isChecked = false;
		}

		if (SearchWord && SearchWord.length >= 1) {
			if (isChecked) {
				SearchInHeadingOnly = 1;
			} else {
				SearchInHeadingOnly = 0;
			}
			SearchWord = SearchWord.toLowerCase();
			window.status = "Searching, please wait...";
			for (j = 0; j < PageLength; j++) {
				k = Page[j].length - 1;
				for (i = 0; i < k; i++) {

					heading = k - 1;

					if (SearchInHeadingOnly === 1) {
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPosHeading > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);

							NrRes++;
							ResultTemp = "<li>";
							ResultTemp += "<span>";
							ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							ResultTitleOnly[arrayIndex] = ResultTemp;
							arrayIndex++;

							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}
					} else if (SearchInHeadingOnly === 0) {
						WordPos = Page[j][i].toLowerCase().indexOf(SearchWord);
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPos > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							NrRes++;
							ResultTemp += "<li>";
							ResultTemp += "<span>";
							if (WordPosHeading > -1) {
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";
							} else {
								// found word is not in the head
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading] + "</a><br/>\n";

							}
							if (i < k - 1) {
								WordPosContentText = Page[j][i].toLowerCase().indexOf(SearchWord);

								if (Page[j][i].length > 300 && (WordPosContentText > -1)) {

									if (WordPosContentText > 75) {
										ResultInContentTemp.push("..." + Page[j][i].substr(WordPosContentText - 75, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");
									} else {
										ResultInContentTemp.push("..." + Page[j][i].substr(0, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");

									}

								} else if (WordPosContentText > -1) {

									ResultInContentTemp.push(Page[j][i].replace(FoundWord, FoundWord.bold()));

								}
							}

							ResultTemp += ResultInContentTemp.join("");

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							if (WordPosHeading > -1) {
								ResultTitleAndContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							} else {
								ResultInContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							}

							ResultInContentTemp.length = 0;
							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}

					}
				}
			}

			ResultTitleOnly = ResultTitleOnly.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultTitleAndContent = ResultTitleAndContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultInContent = ResultInContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			ResultCombinedTemp = ResultTitleOnly.concat(ResultTitleAndContent, ResultInContent);

			ResultCombinedTemp = ResultCombinedTemp.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			for (d = 0; d < ResultCombinedTemp.length; d += size) {
				resGroupCounter++
				ResultCombined.push("<div id=" + "'" + "resGroup_" + resGroupCounter + "'" + " class=" + "'" + "resGroup " + shown + "'" + ">" + "<ol class='searchResults'>" + ResultCombinedTemp.slice(d, d + size).join("") + "</ol></div>");
				shown = "notshown";
			}

			ResultFound = ResultCombined.join("");

Result += "<div id='searchDetailsDiv'>";
			Result += "<p class='searchDetails'>Your Search Found&nbsp;" + NrRes + "&nbsp;items.&nbsp;";
			Result += "</p></div>";
			
			Result += "<div class='searchResultsDiv'>";
			Result += "<div id='resultsCollection' class='searchResults'>";
			Result += ResultFound;
			Result += "</div>";
			Result += "</div>";
			Result += "<div class='searchPaging'>";

			Result += '<hr />';

			Result += '<p class="bodytext"><a class="disabledAnchor" id="pBack" onclick="turnPage(\'backPage\')" href="#pBack">Back</a>&nbsp; | &nbsp;';
			
			if (resGroupCounter && resGroupCounter > 1) {
				Result += '<a id="pNext" onclick="turnPage(\'nextPage\')" href="#pNext">Next</a>';
			} else {
				Result += '<a id="pNext"  class="disabledAnchor" href="#pNext">Next</a>';
			}
			Result += '</p>\n';
			Result += '<div id="pagenofn"><p class="bodytext">Page <span id="pagen">1</span> of ' + resGroupCounter + '</p></div>';

			Result += "</div>";
			
			
		}

		DivResult = document.getElementById("s_anchor");
		if (Result && DivResult) {

			//myDivResult.append(Result);
			DivResult.innerHTML = Result;
			

		}
		window.status = "";
		
		

	}
	}())
}
