define(
{
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"About the REST APIs",
                    "href":"index.html"
                },
                {
                    "title":"All REST Endpoints",
                    "href":"rest-endpoints.html"
                }
            ]
        },
        {
            "heading":"Get Started",
            "topics":[
                {
                    "title":"About This Guide",
                    "href":"D99665.html"
                },
                {
                    "title":"What's New in the P6 EPPM REST API",
                    "href":"D106904.html"
                },
                {
                    "title":"About Personal Information",
                    "href":"D100079.html"
                },
                {
                    "title":"About OAuth and Oracle Cloud Infrastructure",
                    "href":"D100078.html"
                },
                {
                    "title":"About REST Style Architecture",
                    "href":"D99670.html"
                },
                {
                    "title":"Status Codes",
                    "href":"D99671.html"
                },
                {
                    "title":"Using the P6 REST API",
                    "href":"D99666.html"
                },
                {
                    "title":"Best Practices",
                    "href":"D102454.html",
                    "topics":[
                        {
                            "title":"Using Filters",
                            "href":"D102455.html"
                        },
                        {
                            "title":"Performance Tips",
                            "href":"D102457.html"
                        }
                    ]
                },
                {
                    "title":"Security",
                    "href":"D100084.html",
                    "topics":[
                        {
                            "title":"Using HTTPS for Transport Level Security On-Premises",
                            "href":"D99814.html"
                        },
                        {
                            "title":"Application Level Security",
                            "href":"D99816.html"
                        },
                        {
                            "title":"Generating OAuth Tokens",
                            "href":"D99926.html",
                            "topics":[
                                {
                                    "title":"Using Resource Owner Password Credential (ROPC) Grant Type",
                                    "href":"D102832.html"
                                },
                                {
                                    "title":"Using JSON Web Token (JWT) Grant Type",
                                    "href":"D102833.html",
                                    "topics":[
                                        {
                                            "title":"Prerequisite Setup",
                                            "href":"D102845.html"
                                        },
                                        {
                                            "title":"Using JWT User Assertion",
                                            "href":"D102846.html"
                                        },
                                        {
                                            "title":"Using Refresh Tokens",
                                            "href":"D102899.html"
                                        }
                                    ]
                                },
                                {
                                    "title":"Generating the OAuth Access Token",
                                    "href":"D102896.html",
                                    "topics":[
                                        {
                                            "title":"Using Client ID and Secret",
                                            "href":"D102897.html"
                                        },
                                        {
                                            "title":"Using JWT Client Assertion",
                                            "href":"D102898.html"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"HTTP Standard Authentication and HTTPS (Traditional)",
                            "href":"D99833.html"
                        },
                        {
                            "title":"Using Username Token Profile for Authentication and Authorization",
                            "href":"D99598.html"
                        },
                        {
                            "title":"Using OAuth for Authentication and Authorization",
                            "href":"D99930.html"
                        },
                        {
                            "title":"Cookies",
                            "href":"D99818.html"
                        }
                    ]
                },
                {
                    "title":"Ordering",
                    "href":"D100086.html"
                },
                {
                    "title":"Sample Java Code",
                    "href":"D100095.html",
                    "topics":[
                        {
                            "title":"Sample Java Code (OAuth)",
                            "href":"D100062.html"
                        },
                        {
                            "title":"Sample Java Code (Traditional)",
                            "href":"D100060.html"
                        }
                    ]
                },
                {
                    "title":"Troubleshooting the P6 REST API",
                    "href":"D99667.html"
                },
                {
                    "title":"Use Cases",
                    "href":"D99602.html",
                    "topics":[
                        {
                            "title":"Viewing the created resource details",
                            "href":"D99643.html"
                        }
                    ]
                },
                {
                    "title":"Entity Filtering",
                    "href":"D99716.html"
                }
            ]
        },
        {
            "heading":"Tasks",
            "topics":[
                {
                    "title":"Activity",
                    "href":"api-activity.html",
                    "topics":[
                        {
                            "title":"Copy Activity",
                            "href":"op-activity-copyactivity-post.html"
                        },
                        {
                            "title":"Create Activities",
                            "href":"op-activity-post.html"
                        },
                        {
                            "title":"Delete Activities",
                            "href":"op-activity-delete.html"
                        },
                        {
                            "title":"Read Activities",
                            "href":"op-activity-get.html"
                        },
                        {
                            "title":"Update Activities",
                            "href":"op-activity-put.html"
                        },
                        {
                            "title":"View Activity Field Length",
                            "href":"op-activity-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View Activity fields",
                            "href":"op-activity-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ActivityCode",
                    "href":"api-activitycode.html",
                    "topics":[
                        {
                            "title":"Create ActivityCodes",
                            "href":"op-activitycode-post.html"
                        },
                        {
                            "title":"Delete ActivityCodes",
                            "href":"op-activitycode-delete.html"
                        },
                        {
                            "title":"Read ActivityCodes",
                            "href":"op-activitycode-get.html"
                        },
                        {
                            "title":"Update ActivityCodes",
                            "href":"op-activitycode-put.html"
                        },
                        {
                            "title":"View Activity fields",
                            "href":"op-activitycode-fields-get.html"
                        },
                        {
                            "title":"View ActivityCode Field Length",
                            "href":"op-activitycode-getfieldlength-fieldname-get.html"
                        }
                    ]
                },
                {
                    "title":"ActivityCodeAssignment",
                    "href":"api-activitycodeassignment.html",
                    "topics":[
                        {
                            "title":"Create ActivityCodeAssignments",
                            "href":"op-activitycodeassignment-post.html"
                        },
                        {
                            "title":"Delete ActivityCodeAssignments",
                            "href":"op-activitycodeassignment-delete.html"
                        },
                        {
                            "title":"Read ActivityCodeAssignments",
                            "href":"op-activitycodeassignment-get.html"
                        },
                        {
                            "title":"Update ActivityCodeAssignments",
                            "href":"op-activitycodeassignment-put.html"
                        },
                        {
                            "title":"View ActivityCodeAssignment Field Length",
                            "href":"op-activitycodeassignment-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ActivityCodeAssignment fields",
                            "href":"op-activitycodeassignment-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ActivityCodeType",
                    "href":"api-activitycodetype.html",
                    "topics":[
                        {
                            "title":"Create ActivitiyCodeTypes",
                            "href":"op-activitycodetype-post.html"
                        },
                        {
                            "title":"Delete ActivitiyCodeTypes",
                            "href":"op-activitycodetype-delete.html"
                        },
                        {
                            "title":"Read ActivityCodeTypes",
                            "href":"op-activitycodetype-get.html"
                        },
                        {
                            "title":"Update ActivitiyCodeTypes",
                            "href":"op-activitycodetype-put.html"
                        },
                        {
                            "title":"View ActivitiyCodeType Field Length",
                            "href":"op-activitycodetype-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ActivitiyCodeType fields",
                            "href":"op-activitycodetype-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ActivityComment",
                    "href":"api-activitycomment.html",
                    "topics":[
                        {
                            "title":"Create ActivityComments",
                            "href":"op-activitycomment-post.html"
                        },
                        {
                            "title":"Read ActivityComments",
                            "href":"op-activitycomment-get.html"
                        },
                        {
                            "title":"Update ActivityComments",
                            "href":"op-activitycomment-put.html"
                        },
                        {
                            "title":"View ActivityComment Field Length",
                            "href":"op-activitycomment-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ActivityComment fields",
                            "href":"op-activitycomment-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ActivityExpense",
                    "href":"api-activityexpense.html",
                    "topics":[
                        {
                            "title":"Create ActivityExpenses",
                            "href":"op-activityexpense-post.html"
                        },
                        {
                            "title":"Delete ActivityExpenses",
                            "href":"op-activityexpense-delete.html"
                        },
                        {
                            "title":"Read ActivityExpenses",
                            "href":"op-activityexpense-get.html"
                        },
                        {
                            "title":"Update ActivityExpenses",
                            "href":"op-activityexpense-put.html"
                        },
                        {
                            "title":"View ActivityExpense Field Length",
                            "href":"op-activityexpense-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ActivityExpense fields",
                            "href":"op-activityexpense-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ActivityFilter",
                    "href":"api-activityfilter.html",
                    "topics":[
                        {
                            "title":"Create ActivityFilters",
                            "href":"op-activityfilter-post.html"
                        },
                        {
                            "title":"Deletes ActivityFilters",
                            "href":"op-activityfilter-delete.html"
                        },
                        {
                            "title":"Read ActivityFilters",
                            "href":"op-activityfilter-get.html"
                        },
                        {
                            "title":"Update ActivityFilters",
                            "href":"op-activityfilter-put.html"
                        },
                        {
                            "title":"View ActivityFilter Field Length",
                            "href":"op-activityfilter-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ActivityFilter fields",
                            "href":"op-activityfilter-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ActivityNote",
                    "href":"api-activitynote.html",
                    "topics":[
                        {
                            "title":"Create ActivityNotes",
                            "href":"op-activitynote-post.html"
                        },
                        {
                            "title":"Delete ActivityNotes",
                            "href":"op-activitynote-delete.html"
                        },
                        {
                            "title":"Read ActivityNotes",
                            "href":"op-activitynote-get.html"
                        },
                        {
                            "title":"Update ActivityNotes",
                            "href":"op-activitynote-put.html"
                        },
                        {
                            "title":"View ActivityNote Field Length",
                            "href":"op-activitynote-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ActivityNote fields",
                            "href":"op-activitynote-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ActivityOwner",
                    "href":"api-activityowner.html",
                    "topics":[
                        {
                            "title":"Create ActivityOwners",
                            "href":"op-activityowner-post.html"
                        },
                        {
                            "title":"Delete ActivityOwners",
                            "href":"op-activityowner-delete.html"
                        },
                        {
                            "title":"Read ActivityOwners",
                            "href":"op-activityowner-get.html"
                        },
                        {
                            "title":"Update ActivityOwners",
                            "href":"op-activityowner-put.html"
                        },
                        {
                            "title":"View ActivityOwner Field Length",
                            "href":"op-activityowner-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ActivityOwner fields",
                            "href":"op-activityowner-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ActivityPeriodActual",
                    "href":"api-activityperiodactual.html",
                    "topics":[
                        {
                            "title":"Create ActivityPeriodActuals",
                            "href":"op-activityperiodactual-post.html"
                        },
                        {
                            "title":"Delete ActivityPeriodActuals",
                            "href":"op-activityperiodactual-delete.html"
                        },
                        {
                            "title":"Reads ActivityPeriodActuals.",
                            "href":"op-activityperiodactual-get.html"
                        },
                        {
                            "title":"Update ActivityPeriodActuals",
                            "href":"op-activityperiodactual-put.html"
                        },
                        {
                            "title":"View ActivityPeriodActuals Field Length",
                            "href":"op-activityperiodactual-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ActivityPeriodActuals fields",
                            "href":"op-activityperiodactual-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ActivityRisk",
                    "href":"api-activityrisk.html",
                    "topics":[
                        {
                            "title":"Create ActivityRisk",
                            "href":"op-activityrisk-post.html"
                        },
                        {
                            "title":"Delete ActivityRisk",
                            "href":"op-activityrisk-delete.html"
                        },
                        {
                            "title":"Reads ActivityRisks.",
                            "href":"op-activityrisk-get.html"
                        },
                        {
                            "title":"View ActivityRisk Field Length",
                            "href":"op-activityrisk-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ActivityRisk fields",
                            "href":"op-activityrisk-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ActivityStep",
                    "href":"api-activitystep.html",
                    "topics":[
                        {
                            "title":"Create ActivitySteps",
                            "href":"op-activitystep-post.html"
                        },
                        {
                            "title":"Delete ActivitySteps",
                            "href":"op-activitystep-delete.html"
                        },
                        {
                            "title":"Read ActivitySteps",
                            "href":"op-activitystep-get.html"
                        },
                        {
                            "title":"Update ActivitySteps",
                            "href":"op-activitystep-put.html"
                        },
                        {
                            "title":"View ActivityStep Field Length",
                            "href":"op-activitystep-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ActivityStep fields",
                            "href":"op-activitystep-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ActivityStepTemplate",
                    "href":"api-activitysteptemplate.html",
                    "topics":[
                        {
                            "title":"Create ActivityStepTemplates",
                            "href":"op-activitysteptemplate-post.html"
                        },
                        {
                            "title":"Delete ActivityStepTemplates",
                            "href":"op-activitysteptemplate-delete.html"
                        },
                        {
                            "title":"Read ActivityStepTemplates",
                            "href":"op-activitysteptemplate-get.html"
                        },
                        {
                            "title":"Update ActivityStepTemplates",
                            "href":"op-activitysteptemplate-put.html"
                        },
                        {
                            "title":"View ActivityStepTemplate Field Length",
                            "href":"op-activitysteptemplate-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ActivityStepTemplate fields",
                            "href":"op-activitysteptemplate-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ActivityStepTemplateItem",
                    "href":"api-activitysteptemplateitem.html",
                    "topics":[
                        {
                            "title":"Create ActivityStepTemplateItems",
                            "href":"op-activitysteptemplateitem-post.html"
                        },
                        {
                            "title":"Delete ActivityStepTemplateItems",
                            "href":"op-activitysteptemplateitem-delete.html"
                        },
                        {
                            "title":"Read ActivityStepTemplateItems",
                            "href":"op-activitysteptemplateitem-get.html"
                        },
                        {
                            "title":"Update ActivityStepTemplateItems",
                            "href":"op-activitysteptemplateitem-put.html"
                        },
                        {
                            "title":"View ActivityStepTemplateItem Field Length",
                            "href":"op-activitysteptemplateitem-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ActivityStepTemplateItem fields",
                            "href":"op-activitysteptemplateitem-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"BaselineProject",
                    "href":"api-baselineproject.html",
                    "topics":[
                        {
                            "title":"Create BaselineProjects",
                            "href":"op-baselineproject-post.html"
                        },
                        {
                            "title":"Delete BaselineProjects",
                            "href":"op-baselineproject-delete.html"
                        },
                        {
                            "title":"Read BaselineProjects",
                            "href":"op-baselineproject-get.html"
                        },
                        {
                            "title":"Update BaselineProjects",
                            "href":"op-baselineproject-put.html"
                        },
                        {
                            "title":"View BaselineProject Field Length",
                            "href":"op-baselineproject-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View BaselineProject fields",
                            "href":"op-baselineproject-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"BaselineType",
                    "href":"api-baselinetype.html",
                    "topics":[
                        {
                            "title":"Create BaselineTypes",
                            "href":"op-baselinetype-post.html"
                        },
                        {
                            "title":"Delete BaselineTypes",
                            "href":"op-baselinetype-delete.html"
                        },
                        {
                            "title":"Read BaselineTypes",
                            "href":"op-baselinetype-get.html"
                        },
                        {
                            "title":"Update BaselineTypes",
                            "href":"op-baselinetype-put.html"
                        },
                        {
                            "title":"View BaselineType Field Length",
                            "href":"op-baselinetype-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View BaselineType fields",
                            "href":"op-baselinetype-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"Calendar",
                    "href":"api-calendar.html",
                    "topics":[
                        {
                            "title":"Copy Calendar",
                            "href":"op-calendar-copycalendar-post.html"
                        },
                        {
                            "title":"Create Calendars",
                            "href":"op-calendar-post.html"
                        },
                        {
                            "title":"Delete Calendars",
                            "href":"op-calendar-delete.html"
                        },
                        {
                            "title":"Load Calendar DetailedWorkHours",
                            "href":"op-calendar-detailedworkhours-get.html"
                        },
                        {
                            "title":"Load Calendar HolidayExceptionDates",
                            "href":"op-calendar-holidayexceptiondates-get.html"
                        },
                        {
                            "title":"Load Calendar StandardDetailedWorkHours",
                            "href":"op-calendar-standarddetailedworkhours-get.html"
                        },
                        {
                            "title":"Load Calendar StandardTotalWorkHours",
                            "href":"op-calendar-standardtotalworkhours-get.html"
                        },
                        {
                            "title":"Load Calendar TotalWorkHours",
                            "href":"op-calendar-totalworkhours-get.html"
                        },
                        {
                            "title":"Read Calendars",
                            "href":"op-calendar-get.html"
                        },
                        {
                            "title":"Replace With Global Calendar",
                            "href":"op-calendar-replacewithglobalcalendar-put.html"
                        },
                        {
                            "title":"Replace With Project Calendar",
                            "href":"op-calendar-replacewithprojectcalendar-put.html"
                        },
                        {
                            "title":"Replace With Resource Calendar",
                            "href":"op-calendar-replacewithresourcecalendar-put.html"
                        },
                        {
                            "title":"Update Calendars",
                            "href":"op-calendar-put.html"
                        },
                        {
                            "title":"Update DetailedWorkHours of Calendar",
                            "href":"op-calendar-detailedworkhours-put.html"
                        },
                        {
                            "title":"Update StandardDetailedWorkHours of Calendar",
                            "href":"op-calendar-standarddetailedworkhours-put.html"
                        },
                        {
                            "title":"View Calendar Field Length",
                            "href":"op-calendar-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View Calendar fields",
                            "href":"op-calendar-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"CBS",
                    "href":"api-cbs.html",
                    "topics":[
                        {
                            "title":"Create CBSs",
                            "href":"op-cbs-post.html"
                        },
                        {
                            "title":"Delete CBSs",
                            "href":"op-cbs-delete.html"
                        },
                        {
                            "title":"Read CBSs",
                            "href":"op-cbs-get.html"
                        },
                        {
                            "title":"Update CBSs",
                            "href":"op-cbs-put.html"
                        },
                        {
                            "title":"View CBS Field Length",
                            "href":"op-cbs-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View CBS fields",
                            "href":"op-cbs-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"CBSDurationSummary",
                    "href":"api-cbsdurationsummary.html",
                    "topics":[
                        {
                            "title":"Create CBSDurationSummarys",
                            "href":"op-cbsdurationsummary-post.html"
                        },
                        {
                            "title":"Delete CBSDurationSummarys",
                            "href":"op-cbsdurationsummary-delete.html"
                        },
                        {
                            "title":"Read CBSDurationSummarys",
                            "href":"op-cbsdurationsummary-get.html"
                        },
                        {
                            "title":"Update CBSDurationSummarys",
                            "href":"op-cbsdurationsummary-put.html"
                        },
                        {
                            "title":"View CBSDurationSummary Field Length",
                            "href":"op-cbsdurationsummary-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View CBSDurationSummary fields",
                            "href":"op-cbsdurationsummary-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"CostAccount",
                    "href":"api-costaccount.html",
                    "topics":[
                        {
                            "title":"Create CostAccount",
                            "href":"op-costaccount-post.html"
                        },
                        {
                            "title":"Delete CostAccount",
                            "href":"op-costaccount-delete.html"
                        },
                        {
                            "title":"Read CostAccount",
                            "href":"op-costaccount-get.html"
                        },
                        {
                            "title":"Update CostAccount",
                            "href":"op-costaccount-put.html"
                        },
                        {
                            "title":"View CostAccount Field Length",
                            "href":"op-costaccount-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View CostAccount fields",
                            "href":"op-costaccount-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"Currency",
                    "href":"api-currency.html",
                    "topics":[
                        {
                            "title":"Create Currencies",
                            "href":"op-currency-post.html"
                        },
                        {
                            "title":"Delete Currencies",
                            "href":"op-currency-delete.html"
                        },
                        {
                            "title":"Read Currencies",
                            "href":"op-currency-get.html"
                        },
                        {
                            "title":"Update Currencies",
                            "href":"op-currency-put.html"
                        },
                        {
                            "title":"View Currency Field Length",
                            "href":"op-currency-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View Currency fields",
                            "href":"op-currency-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"Document",
                    "href":"api-document.html",
                    "topics":[
                        {
                            "title":"Checkin Document",
                            "href":"op-document-checkindocument-post.html"
                        },
                        {
                            "title":"Checkout Document",
                            "href":"op-document-checkoutdocument-get.html"
                        },
                        {
                            "title":"Create Document",
                            "href":"op-document-post.html"
                        },
                        {
                            "title":"Delete Document",
                            "href":"op-document-delete.html"
                        },
                        {
                            "title":"Download Document",
                            "href":"op-document-downloaddocument-get.html"
                        },
                        {
                            "title":"Read Document",
                            "href":"op-document-get.html"
                        },
                        {
                            "title":"Update Document",
                            "href":"op-document-put.html"
                        },
                        {
                            "title":"Upload Document",
                            "href":"op-document-uploaddocument-post.html"
                        },
                        {
                            "title":"View Document Field Length",
                            "href":"op-document-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View Document fields",
                            "href":"op-document-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"DocumentCategory",
                    "href":"api-documentcategory.html",
                    "topics":[
                        {
                            "title":"Create DocumentCategory",
                            "href":"op-documentcategory-post.html"
                        },
                        {
                            "title":"Delete DocumentCategory",
                            "href":"op-documentcategory-delete.html"
                        },
                        {
                            "title":"Read DocumentCategory",
                            "href":"op-documentcategory-get.html"
                        },
                        {
                            "title":"Update DocumentCategory",
                            "href":"op-documentcategory-put.html"
                        },
                        {
                            "title":"View DocumentCategory Field Length",
                            "href":"op-documentcategory-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View DocumentCategory fields",
                            "href":"op-documentcategory-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"DocumentStatusCode",
                    "href":"api-documentstatuscode.html",
                    "topics":[
                        {
                            "title":"Create DocumentStatusCode",
                            "href":"op-documentstatuscode-post.html"
                        },
                        {
                            "title":"Delete DocumentStatusCode",
                            "href":"op-documentstatuscode-delete.html"
                        },
                        {
                            "title":"Read DocumentStatusCode",
                            "href":"op-documentstatuscode-get.html"
                        },
                        {
                            "title":"Update DocumentStatusCode",
                            "href":"op-documentstatuscode-put.html"
                        },
                        {
                            "title":"View DocumentStatusCode Field Length",
                            "href":"op-documentstatuscode-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View DocumentStatusCode fields",
                            "href":"op-documentstatuscode-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"EPS",
                    "href":"api-eps.html",
                    "topics":[
                        {
                            "title":"Create EPS",
                            "href":"op-eps-post.html"
                        },
                        {
                            "title":"Delete EPS",
                            "href":"op-eps-delete.html"
                        },
                        {
                            "title":"Read EPS",
                            "href":"op-eps-get.html"
                        },
                        {
                            "title":"Update EPS",
                            "href":"op-eps-put.html"
                        },
                        {
                            "title":"View EPS Field Length",
                            "href":"op-eps-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View EPS fields",
                            "href":"op-eps-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"EPSBudgetChangeLog",
                    "href":"api-epsbudgetchangelog.html",
                    "topics":[
                        {
                            "title":"Create EPSBudgetChangeLog to the store",
                            "href":"op-epsbudgetchangelog-post.html"
                        },
                        {
                            "title":"Delete EPSBudgetChangeLog",
                            "href":"op-epsbudgetchangelog-delete.html"
                        },
                        {
                            "title":"Read EPSBudgetChangeLog",
                            "href":"op-epsbudgetchangelog-get.html"
                        },
                        {
                            "title":"Update EPSBudgetChangeLog",
                            "href":"op-epsbudgetchangelog-put.html"
                        },
                        {
                            "title":"View EPSBudgetChangeLog Field Length",
                            "href":"op-epsbudgetchangelog-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View EPSBudgetChangeLog fields",
                            "href":"op-epsbudgetchangelog-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"EPSFunding",
                    "href":"api-epsfunding.html",
                    "topics":[
                        {
                            "title":"Create EPSFunding",
                            "href":"op-epsfunding-post.html"
                        },
                        {
                            "title":"Delete EPSFunding",
                            "href":"op-epsfunding-delete.html"
                        },
                        {
                            "title":"Read EPSFunding",
                            "href":"op-epsfunding-get.html"
                        },
                        {
                            "title":"Update EPSFunding",
                            "href":"op-epsfunding-put.html"
                        },
                        {
                            "title":"View EPSFunding Field Length",
                            "href":"op-epsfunding-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View EPSFunding fields",
                            "href":"op-epsfunding-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"EPSNote",
                    "href":"api-epsnote.html",
                    "topics":[
                        {
                            "title":"Create EPSNote",
                            "href":"op-epsnote-post.html"
                        },
                        {
                            "title":"Delete EPSNote",
                            "href":"op-epsnote-delete.html"
                        },
                        {
                            "title":"Read EPSNote",
                            "href":"op-epsnote-get.html"
                        },
                        {
                            "title":"Update EPSNote",
                            "href":"op-epsnote-put.html"
                        },
                        {
                            "title":"View EPSNote Field Length",
                            "href":"op-epsnote-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View EPSNote fields",
                            "href":"op-epsnote-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"EPSSpendingPlan",
                    "href":"api-epsspendingplan.html",
                    "topics":[
                        {
                            "title":"Create EPSSpendingPlan",
                            "href":"op-epsspendingplan-post.html"
                        },
                        {
                            "title":"Delete EPSSpendingPlan",
                            "href":"op-epsspendingplan-delete.html"
                        },
                        {
                            "title":"Read EPSSpendingPlan",
                            "href":"op-epsspendingplan-get.html"
                        },
                        {
                            "title":"Update EPSSpendingPlan",
                            "href":"op-epsspendingplan-put.html"
                        },
                        {
                            "title":"View EPSSpendingPlan Field Length",
                            "href":"op-epsspendingplan-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View EPSSpendingPlan fields",
                            "href":"op-epsspendingplan-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ExpenseCategory",
                    "href":"api-expensecategory.html",
                    "topics":[
                        {
                            "title":"Create ExpenseCategories",
                            "href":"op-expensecategory-post.html"
                        },
                        {
                            "title":"Delete ExpenseCategories",
                            "href":"op-expensecategory-delete.html"
                        },
                        {
                            "title":"Read ExpenseCategories",
                            "href":"op-expensecategory-get.html"
                        },
                        {
                            "title":"Update ExpenseCategories",
                            "href":"op-expensecategory-put.html"
                        },
                        {
                            "title":"View ExpenseCategory Field Length",
                            "href":"op-expensecategory-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ExpenseCategory fields",
                            "href":"op-expensecategory-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"Export",
                    "href":"api-export.html",
                    "topics":[
                        {
                            "title":"Download Files",
                            "href":"op-export-downloadfiles-post.html"
                        },
                        {
                            "title":"Export DOE-CPP Project",
                            "href":"op-export-exportdoecppproject-post.html"
                        },
                        {
                            "title":"Export ImpdarProject",
                            "href":"op-export-exportipmdarproject-post.html"
                        },
                        {
                            "title":"Export Project",
                            "href":"op-export-exportproject-post.html"
                        },
                        {
                            "title":"Export Projects",
                            "href":"op-export-exportprojects-post.html"
                        },
                        {
                            "title":"Export XER Project",
                            "href":"op-export-exportxerproject-post.html"
                        }
                    ]
                },
                {
                    "title":"FinancialPeriod",
                    "href":"api-financialperiod.html",
                    "topics":[
                        {
                            "title":"Create FinancialPeriods",
                            "href":"op-financialperiod-post.html"
                        },
                        {
                            "title":"Delete FinancialPeriods",
                            "href":"op-financialperiod-delete.html"
                        },
                        {
                            "title":"Read FinancialPeriods",
                            "href":"op-financialperiod-get.html"
                        },
                        {
                            "title":"Update FinancialPeriods",
                            "href":"op-financialperiod-put.html"
                        },
                        {
                            "title":"View FinancialPeriod Field Length",
                            "href":"op-financialperiod-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View FinancialPeriod fields",
                            "href":"op-financialperiod-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"FundingSource",
                    "href":"api-fundingsource.html",
                    "topics":[
                        {
                            "title":"Create FundingSources",
                            "href":"op-fundingsource-post.html"
                        },
                        {
                            "title":"Delete FundingSources",
                            "href":"op-fundingsource-delete.html"
                        },
                        {
                            "title":"Read FundingSources",
                            "href":"op-fundingsource-get.html"
                        },
                        {
                            "title":"Update FundingSources",
                            "href":"op-fundingsource-put.html"
                        },
                        {
                            "title":"View FundingSource Field Length",
                            "href":"op-fundingsource-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View FundingSource fields",
                            "href":"op-fundingsource-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"GlobalPreferences",
                    "href":"api-globalpreferences.html",
                    "topics":[
                        {
                            "title":"Read GlobalPreferences",
                            "href":"op-globalpreferences-get.html"
                        },
                        {
                            "title":"Update GlobalPreferences",
                            "href":"op-globalpreferences-put.html"
                        },
                        {
                            "title":"View GlobalPreferences Field Length",
                            "href":"op-globalpreferences-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View GlobalPreferences fields",
                            "href":"op-globalpreferences-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"GlobalProfile",
                    "href":"api-globalprofile.html",
                    "topics":[
                        {
                            "title":"Create GlobalProfiles",
                            "href":"op-globalprofile-post.html"
                        },
                        {
                            "title":"Delete GlobalProfiles",
                            "href":"op-globalprofile-delete.html"
                        },
                        {
                            "title":"exportPrivilegesReport",
                            "href":"op-globalprofile-exportprivilegesreport-get.html"
                        },
                        {
                            "title":"Read GlobalProfile",
                            "href":"op-globalprofile-get.html"
                        },
                        {
                            "title":"Update GlobalProfile",
                            "href":"op-globalprofile-put.html"
                        },
                        {
                            "title":"View GlobalProfile Field Length",
                            "href":"op-globalprofile-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View GlobalProfile fields",
                            "href":"op-globalprofile-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"GlobalReplace",
                    "href":"api-globalreplace.html",
                    "topics":[
                        {
                            "title":"Read GlobalReplace",
                            "href":"op-globalreplace-get.html"
                        },
                        {
                            "title":"Update GlobalReplace",
                            "href":"op-globalreplace-put.html"
                        },
                        {
                            "title":"View GlobalReplace Field Length",
                            "href":"op-globalreplace-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View GlobalReplace fields",
                            "href":"op-globalreplace-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"Import",
                    "href":"api-import.html",
                    "topics":[
                        {
                            "title":"CreateNewProject",
                            "href":"op-import-createnewproject-post.html"
                        },
                        {
                            "title":"ImportProjectAsyncASAP",
                            "href":"op-import-importprojectasyncasap-post.html"
                        },
                        {
                            "title":"ImportProjects",
                            "href":"op-import-importprojects-post.html"
                        },
                        {
                            "title":"UpdateExistingProject",
                            "href":"op-import-updateexistingproject-post.html"
                        }
                    ]
                },
                {
                    "title":"ImportOptionsTemplate",
                    "href":"api-importoptionstemplate.html",
                    "topics":[
                        {
                            "title":"Read ImportOptionsTemplate",
                            "href":"op-importoptionstemplate-get.html"
                        },
                        {
                            "title":"View ImportOptionsTemplate Field Length",
                            "href":"op-importoptionstemplate-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ImportOptionsTemplate fields",
                            "href":"op-importoptionstemplate-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"IssueHistory",
                    "href":"api-issuehistory.html",
                    "topics":[
                        {
                            "title":"Read IssueHistory",
                            "href":"op-issuehistory-get.html"
                        },
                        {
                            "title":"View IssueHistory Field Length",
                            "href":"op-issuehistory-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View IssueHistory fields",
                            "href":"op-issuehistory-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"Job",
                    "href":"api-job.html",
                    "topics":[
                        {
                            "title":"Apply Actual",
                            "href":"op-job-applyactuals-post.html"
                        },
                        {
                            "title":"CancelJob",
                            "href":"op-job-canceljob-post.html"
                        },
                        {
                            "title":"GetCurrentJobs",
                            "href":"op-job-getcurrentjobs-get.html"
                        },
                        {
                            "title":"Leveling Project",
                            "href":"op-job-level-post.html"
                        },
                        {
                            "title":"Publish Project(s)",
                            "href":"op-job-publish-post.html"
                        },
                        {
                            "title":"ReadJobLog",
                            "href":"op-job-readjoblog-post.html"
                        },
                        {
                            "title":"ReadJobStatus",
                            "href":"op-job-readjobstatus-get.html"
                        },
                        {
                            "title":"RecalculateAssignmentCosts",
                            "href":"op-job-recalculateassignmentcosts-post.html"
                        },
                        {
                            "title":"Schedule Project",
                            "href":"op-job-schedule-post.html"
                        },
                        {
                            "title":"ScheduleCheck",
                            "href":"op-job-schedulecheck-post.html"
                        },
                        {
                            "title":"SendToUnifier",
                            "href":"op-job-sendtounifier-post.html"
                        },
                        {
                            "title":"StorePeriodPerformance",
                            "href":"op-job-storeperiodperformance-post.html"
                        },
                        {
                            "title":"Summarize CBS",
                            "href":"op-job-summarizecbs-post.html"
                        },
                        {
                            "title":"Summarize EPS",
                            "href":"op-job-summarizeeps-post.html"
                        },
                        {
                            "title":"Summarize Project",
                            "href":"op-job-summarizeproject-post.html"
                        },
                        {
                            "title":"Update Baseline",
                            "href":"op-job-updatebaseline-post.html"
                        }
                    ]
                },
                {
                    "title":"JobService",
                    "href":"api-jobservice.html",
                    "topics":[
                        {
                            "title":"Create JobService",
                            "href":"op-jobservice-post.html"
                        },
                        {
                            "title":"Delete JobService",
                            "href":"op-jobservice-delete.html"
                        },
                        {
                            "title":"Read JobService",
                            "href":"op-jobservice-get.html"
                        },
                        {
                            "title":"Update JobService",
                            "href":"op-jobservice-put.html"
                        },
                        {
                            "title":"View JobService Field Length",
                            "href":"op-jobservice-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ScheduleOptions fields",
                            "href":"op-jobservice-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"LeanTask",
                    "href":"api-leantask.html",
                    "topics":[
                        {
                            "title":"Create LeanTasks",
                            "href":"op-leantask-post.html"
                        },
                        {
                            "title":"Delete LeanTasks",
                            "href":"op-leantask-delete.html"
                        },
                        {
                            "title":"Read LeanTasks",
                            "href":"op-leantask-get.html"
                        },
                        {
                            "title":"Update LeanTasks",
                            "href":"op-leantask-put.html"
                        },
                        {
                            "title":"View LeanTask Field Length",
                            "href":"op-leantask-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View LeanTask fields",
                            "href":"op-leantask-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"Location",
                    "href":"api-location.html",
                    "topics":[
                        {
                            "title":"Create Locations",
                            "href":"op-location-post.html"
                        },
                        {
                            "title":"Delete Locations",
                            "href":"op-location-delete.html"
                        },
                        {
                            "title":"Read Locations",
                            "href":"op-location-get.html"
                        },
                        {
                            "title":"Update Locations",
                            "href":"op-location-put.html"
                        },
                        {
                            "title":"View Location Field Length",
                            "href":"op-location-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View Location fields",
                            "href":"op-location-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"Login",
                    "href":"api-login.html",
                    "topics":[
                        {
                            "title":"Login",
                            "href":"op-login-post.html"
                        }
                    ]
                },
                {
                    "title":"Logout",
                    "href":"api-logout.html",
                    "topics":[
                        {
                            "title":"Logout",
                            "href":"op-logout-post.html"
                        }
                    ]
                },
                {
                    "title":"MSPTemplate",
                    "href":"api-msptemplate.html",
                    "topics":[
                        {
                            "title":"Read MSPTemplate",
                            "href":"op-msptemplate-get.html"
                        },
                        {
                            "title":"View MSPTemplate Field Length",
                            "href":"op-msptemplate-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View MSPTemplate fields",
                            "href":"op-msptemplate-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"NotebookTopic",
                    "href":"api-notebooktopic.html",
                    "topics":[
                        {
                            "title":"Create NotebookTopics",
                            "href":"op-notebooktopic-post.html"
                        },
                        {
                            "title":"Delete NotebookTopics",
                            "href":"op-notebooktopic-delete.html"
                        },
                        {
                            "title":"Read NotebookTopics",
                            "href":"op-notebooktopic-get.html"
                        },
                        {
                            "title":"Update NotebookTopics",
                            "href":"op-notebooktopic-put.html"
                        },
                        {
                            "title":"View NotebookTopic Field Length",
                            "href":"op-notebooktopic-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View NotebookTopic fields",
                            "href":"op-notebooktopic-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"OBS",
                    "href":"api-obs.html",
                    "topics":[
                        {
                            "title":"Create OBS",
                            "href":"op-obs-post.html"
                        },
                        {
                            "title":"Delete OBS",
                            "href":"op-obs-delete.html"
                        },
                        {
                            "title":"Read OBS",
                            "href":"op-obs-get.html"
                        },
                        {
                            "title":"Update OBS",
                            "href":"op-obs-put.html"
                        },
                        {
                            "title":"View OBS Field Length",
                            "href":"op-obs-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View OBS fields",
                            "href":"op-obs-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"OverheadCode",
                    "href":"api-overheadcode.html",
                    "topics":[
                        {
                            "title":"Create OverheadCodes",
                            "href":"op-overheadcode-post.html"
                        },
                        {
                            "title":"Delete OverheadCodes",
                            "href":"op-overheadcode-delete.html"
                        },
                        {
                            "title":"Read OverheadCodes",
                            "href":"op-overheadcode-get.html"
                        },
                        {
                            "title":"Update OverheadCodes",
                            "href":"op-overheadcode-put.html"
                        },
                        {
                            "title":"View OverheadCode Field Length",
                            "href":"op-overheadcode-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View OverheadCode fields",
                            "href":"op-overheadcode-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"Project",
                    "href":"api-project.html",
                    "topics":[
                        {
                            "title":"Assign Project As Baseline",
                            "href":"op-project-assignprojectasbaseline-post.html"
                        },
                        {
                            "title":"Calculate Project Score",
                            "href":"op-project-calculateprojectscore-get.html"
                        },
                        {
                            "title":"CheckIn",
                            "href":"op-project-checkinproject-put.html"
                        },
                        {
                            "title":"CheckOut",
                            "href":"op-project-checkoutproject-put.html"
                        },
                        {
                            "title":"Copy Project",
                            "href":"op-project-copyproject-post.html"
                        },
                        {
                            "title":"Copy Project as Baseline",
                            "href":"op-project-copyprojectasbaseline-post.html"
                        },
                        {
                            "title":"Copy WBS from Template",
                            "href":"op-project-copywbsfromtemplate-post.html"
                        },
                        {
                            "title":"Create copy as Template",
                            "href":"op-project-createcopyastemplate-post.html"
                        },
                        {
                            "title":"Create Project",
                            "href":"op-project-post.html"
                        },
                        {
                            "title":"Create Project From Template",
                            "href":"op-project-createprojectfromtemplate-post.html"
                        },
                        {
                            "title":"Delete Project",
                            "href":"op-project-delete.html"
                        },
                        {
                            "title":"Is Project locked",
                            "href":"op-project-isprojectlocked-get.html"
                        },
                        {
                            "title":"Publish Project",
                            "href":"op-project-publishproject-post.html"
                        },
                        {
                            "title":"Read Projects",
                            "href":"op-project-get.html"
                        },
                        {
                            "title":"Update Project",
                            "href":"op-project-put.html"
                        },
                        {
                            "title":"View Project Field Length",
                            "href":"op-project-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View Project fields",
                            "href":"op-project-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ProjectBudgetChangeLog",
                    "href":"api-projectbudgetchangelog.html",
                    "topics":[
                        {
                            "title":"Create ProjectBudgetChangeLog",
                            "href":"op-projectbudgetchangelog-post.html"
                        },
                        {
                            "title":"Delete ProjectBudgetChangeLog",
                            "href":"op-projectbudgetchangelog-delete.html"
                        },
                        {
                            "title":"Read ProjectBudgetChangeLog",
                            "href":"op-projectbudgetchangelog-get.html"
                        },
                        {
                            "title":"Update ProjectBudgetChangeLog",
                            "href":"op-projectbudgetchangelog-put.html"
                        },
                        {
                            "title":"View ProjectBudgetChangeLog Field Length",
                            "href":"op-projectbudgetchangelog-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ProjectBudgetChangeLog fields",
                            "href":"op-projectbudgetchangelog-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ProjectCode",
                    "href":"api-projectcode.html",
                    "topics":[
                        {
                            "title":"Create ProjectCodes",
                            "href":"op-projectcode-post.html"
                        },
                        {
                            "title":"Delete ProjectCodes",
                            "href":"op-projectcode-delete.html"
                        },
                        {
                            "title":"Read ProjectCodes",
                            "href":"op-projectcode-get.html"
                        },
                        {
                            "title":"Update ProjectCodes",
                            "href":"op-projectcode-put.html"
                        },
                        {
                            "title":"View ProjectCode Field Length",
                            "href":"op-projectcode-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ProjectCode fields",
                            "href":"op-projectcode-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ProjectCodeAssignment",
                    "href":"api-projectcodeassignment.html",
                    "topics":[
                        {
                            "title":"Create ProjectCodeAssignment",
                            "href":"op-projectcodeassignment-post.html"
                        },
                        {
                            "title":"Delete Project Code Assignment",
                            "href":"op-projectcodeassignment-delete.html"
                        },
                        {
                            "title":"Read ProjectCodeAssignment",
                            "href":"op-projectcodeassignment-get.html"
                        },
                        {
                            "title":"Update ProjectCodeAssignment",
                            "href":"op-projectcodeassignment-put.html"
                        },
                        {
                            "title":"View ProjectCodeAssignment Field",
                            "href":"op-projectcodeassignment-fields-get.html"
                        },
                        {
                            "title":"View ProjectCodeAssignment Field Length",
                            "href":"op-projectcodeassignment-getfieldlength-fieldname-get.html"
                        }
                    ]
                },
                {
                    "title":"ProjectCodeType",
                    "href":"api-projectcodetype.html",
                    "topics":[
                        {
                            "title":"Create ProjectCodeTypes",
                            "href":"op-projectcodetype-post.html"
                        },
                        {
                            "title":"Delete ProjectCodeTypes",
                            "href":"op-projectcodetype-delete.html"
                        },
                        {
                            "title":"Read ProjectCodeTypes",
                            "href":"op-projectcodetype-get.html"
                        },
                        {
                            "title":"Update ProjectCodeTypes",
                            "href":"op-projectcodetype-put.html"
                        },
                        {
                            "title":"View ProjectCodeType Field Length",
                            "href":"op-projectcodetype-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ProjectCodeType fields",
                            "href":"op-projectcodetype-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ProjectDeployment",
                    "href":"api-projectdeployment.html",
                    "topics":[
                        {
                            "title":"Create ProjectDeployment",
                            "href":"op-projectdeployment-post.html"
                        },
                        {
                            "title":"Delete ProjectDeployment",
                            "href":"op-projectdeployment-delete.html"
                        },
                        {
                            "title":"Read ProjectDeployment",
                            "href":"op-projectdeployment-get.html"
                        },
                        {
                            "title":"Update ProjectDeployment",
                            "href":"op-projectdeployment-put.html"
                        },
                        {
                            "title":"View ProjectDeployment Field Length",
                            "href":"op-projectdeployment-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ProjectResourceQuantity fields",
                            "href":"op-projectdeployment-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ProjectDocument",
                    "href":"api-projectdocument.html",
                    "topics":[
                        {
                            "title":"Create ProjectDocument",
                            "href":"op-projectdocument-post.html"
                        },
                        {
                            "title":"Delete ProjectDocument",
                            "href":"op-projectdocument-delete.html"
                        },
                        {
                            "title":"Read ProjectDocument",
                            "href":"op-projectdocument-get.html"
                        },
                        {
                            "title":"Update ProjectDocument",
                            "href":"op-projectdocument-put.html"
                        },
                        {
                            "title":"View ProjectDocument Field Length",
                            "href":"op-projectdocument-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ProjectDocument fields",
                            "href":"op-projectdocument-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ProjectFunding",
                    "href":"api-projectfunding.html",
                    "topics":[
                        {
                            "title":"Creates ProjectFunding",
                            "href":"op-projectfunding-post.html"
                        },
                        {
                            "title":"Delete ProjectFunding",
                            "href":"op-projectfunding-delete.html"
                        },
                        {
                            "title":"Read ProjectFunding",
                            "href":"op-projectfunding-get.html"
                        },
                        {
                            "title":"Update ProjectFunding",
                            "href":"op-projectfunding-put.html"
                        },
                        {
                            "title":"View ProjectFunding Field Length",
                            "href":"op-projectfunding-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ProjectFunding fields",
                            "href":"op-projectfunding-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ProjectIssue",
                    "href":"api-projectissue.html",
                    "topics":[
                        {
                            "title":"Create ProjectIssue",
                            "href":"op-projectissue-post.html"
                        },
                        {
                            "title":"Delete ProjectIssue",
                            "href":"op-projectissue-delete.html"
                        },
                        {
                            "title":"Reads ProjectIssue",
                            "href":"op-projectissue-get.html"
                        },
                        {
                            "title":"Update ProjectIssue",
                            "href":"op-projectissue-put.html"
                        },
                        {
                            "title":"View Project fields",
                            "href":"op-projectissue-fields-get.html"
                        },
                        {
                            "title":"View ProjectIssue Field Length",
                            "href":"op-projectissue-getfieldlength-fieldname-get.html"
                        }
                    ]
                },
                {
                    "title":"ProjectNote",
                    "href":"api-projectnote.html",
                    "topics":[
                        {
                            "title":"Create ProjectNote",
                            "href":"op-projectnote-post.html"
                        },
                        {
                            "title":"Delete ProjectNote",
                            "href":"op-projectnote-delete.html"
                        },
                        {
                            "title":"Read ProjectNote",
                            "href":"op-projectnote-get.html"
                        },
                        {
                            "title":"Update ProjectNote",
                            "href":"op-projectnote-put.html"
                        },
                        {
                            "title":"View ProjectNote Field Length",
                            "href":"op-projectnote-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ProjectNote fields",
                            "href":"op-projectnote-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ProjectPortfolio",
                    "href":"api-projectportfolio.html",
                    "topics":[
                        {
                            "title":"Add Projects",
                            "href":"op-projectportfolio-addprojects-put.html"
                        },
                        {
                            "title":"Create ProjectPortfolio",
                            "href":"op-projectportfolio-post.html"
                        },
                        {
                            "title":"Delete ProjectPortfolio",
                            "href":"op-projectportfolio-delete.html"
                        },
                        {
                            "title":"Get Project Object Ids",
                            "href":"op-projectportfolio-getprojectobjectids-get.html"
                        },
                        {
                            "title":"LoadProjects Operation",
                            "href":"op-projectportfolio-loadprojects-get.html"
                        },
                        {
                            "title":"Read ProjectPortfolio",
                            "href":"op-projectportfolio-get.html"
                        },
                        {
                            "title":"Remove Projects",
                            "href":"op-projectportfolio-removeprojects-put.html"
                        },
                        {
                            "title":"Update ProjectPortfolio",
                            "href":"op-projectportfolio-put.html"
                        },
                        {
                            "title":"View ProjectPortfolio Field Length",
                            "href":"op-projectportfolio-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ProjectPortfolio fields",
                            "href":"op-projectportfolio-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ProjectProfile",
                    "href":"api-projectprofile.html",
                    "topics":[
                        {
                            "title":"Create ProjectProfile",
                            "href":"op-projectprofile-post.html"
                        },
                        {
                            "title":"Delete ProjectProfile",
                            "href":"op-projectprofile-delete.html"
                        },
                        {
                            "title":"exportPrivilegesReport",
                            "href":"op-projectprofile-exportprivilegesreport-get.html"
                        },
                        {
                            "title":"hasPrivilege",
                            "href":"op-projectprofile-hasprivilege-get.html"
                        },
                        {
                            "title":"Read ProjectProfile",
                            "href":"op-projectprofile-get.html"
                        },
                        {
                            "title":"Update ProjectProfile",
                            "href":"op-projectprofile-put.html"
                        },
                        {
                            "title":"View ProjectProfile Field Length",
                            "href":"op-projectprofile-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ProjectProfile fields",
                            "href":"op-projectprofile-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ProjectResource",
                    "href":"api-projectresource.html",
                    "topics":[
                        {
                            "title":"Create ProjectResource",
                            "href":"op-projectresource-post.html"
                        },
                        {
                            "title":"Delete ProjectResource",
                            "href":"op-projectresource-delete.html"
                        },
                        {
                            "title":"Read ProjectResource",
                            "href":"op-projectresource-get.html"
                        },
                        {
                            "title":"Update ProjectResource",
                            "href":"op-projectresource-put.html"
                        },
                        {
                            "title":"View ProjectResource Field Length",
                            "href":"op-projectresource-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ProjectResource fields",
                            "href":"op-projectresource-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ProjectResourceCategory",
                    "href":"api-projectresourcecategory.html",
                    "topics":[
                        {
                            "title":"Create ProjectResourceCategory",
                            "href":"op-projectresourcecategory-post.html"
                        },
                        {
                            "title":"Delete ProjectResourceCategory",
                            "href":"op-projectresourcecategory-delete.html"
                        },
                        {
                            "title":"Read ProjectResourceCategory",
                            "href":"op-projectresourcecategory-get.html"
                        },
                        {
                            "title":"Update ProjectResourceCategory",
                            "href":"op-projectresourcecategory-put.html"
                        },
                        {
                            "title":"View ProjectResourceCategory Field Length",
                            "href":"op-projectresourcecategory-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View projectresourcecategory fields",
                            "href":"op-projectresourcecategory-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ProjectResourceQuantity",
                    "href":"api-projectresourcequantity.html",
                    "topics":[
                        {
                            "title":"Create ProjectResourceQuantity",
                            "href":"op-projectresourcequantity-post.html"
                        },
                        {
                            "title":"Delete ProjectResourceQuantity",
                            "href":"op-projectresourcequantity-delete.html"
                        },
                        {
                            "title":"Reads ProjectResourceQuantity",
                            "href":"op-projectresourcequantity-get.html"
                        },
                        {
                            "title":"Update ProjectResourceQuantity",
                            "href":"op-projectresourcequantity-put.html"
                        },
                        {
                            "title":"View ProjectResourceQuantity Field Length",
                            "href":"op-projectresourcequantity-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ProjectResourceQuantity fields",
                            "href":"op-projectresourcequantity-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ProjectSpendingPlan",
                    "href":"api-projectspendingplan.html",
                    "topics":[
                        {
                            "title":"Create ProjectSpendingPlan",
                            "href":"op-projectspendingplan-post.html"
                        },
                        {
                            "title":"Delete ProjectSpendingPlan",
                            "href":"op-projectspendingplan-delete.html"
                        },
                        {
                            "title":"Read ProjectSpendingPlan",
                            "href":"op-projectspendingplan-get.html"
                        },
                        {
                            "title":"Update ProjectSpendingPlan",
                            "href":"op-projectspendingplan-put.html"
                        },
                        {
                            "title":"View ProjectSpendingPlan Field Length",
                            "href":"op-projectspendingplan-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ProjectSpendingPlan fields",
                            "href":"op-projectspendingplan-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ProjectThreshold",
                    "href":"api-projectthreshold.html",
                    "topics":[
                        {
                            "title":"Create ProjectThreshold",
                            "href":"op-projectthreshold-post.html"
                        },
                        {
                            "title":"Delete ProjectThreshold",
                            "href":"op-projectthreshold-delete.html"
                        },
                        {
                            "title":"Read ProjectThreshold",
                            "href":"op-projectthreshold-get.html"
                        },
                        {
                            "title":"Update ProjectThreshold",
                            "href":"op-projectthreshold-put.html"
                        },
                        {
                            "title":"View Project Field Length",
                            "href":"op-projectthreshold-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View Project fields",
                            "href":"op-projectthreshold-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"Relationship",
                    "href":"api-relationship.html",
                    "topics":[
                        {
                            "title":"Create Relationship",
                            "href":"op-relationship-post.html"
                        },
                        {
                            "title":"Delete Relationship",
                            "href":"op-relationship-delete.html"
                        },
                        {
                            "title":"Read Relationship",
                            "href":"op-relationship-get.html"
                        },
                        {
                            "title":"Update Relationship",
                            "href":"op-relationship-put.html"
                        },
                        {
                            "title":"View Relationship Field Length",
                            "href":"op-relationship-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View Relationship fields",
                            "href":"op-relationship-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"Resource",
                    "href":"api-resource.html",
                    "topics":[
                        {
                            "title":"Create Resource",
                            "href":"op-resource-post.html"
                        },
                        {
                            "title":"Delete Resource",
                            "href":"op-resource-delete.html"
                        },
                        {
                            "title":"Loads activities assigned to the specified resource.",
                            "href":"op-resource-loadactivities-get.html"
                        },
                        {
                            "title":"Read Resources",
                            "href":"op-resource-get.html"
                        },
                        {
                            "title":"Update Resource",
                            "href":"op-resource-put.html"
                        },
                        {
                            "title":"View Resource Field Length",
                            "href":"op-resource-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View Resource fields",
                            "href":"op-resource-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ResourceAccess",
                    "href":"api-resourceaccess.html",
                    "topics":[
                        {
                            "title":"Create ResourceAccess",
                            "href":"op-resourceaccess-post.html"
                        },
                        {
                            "title":"Delete ResourceAccess",
                            "href":"op-resourceaccess-delete.html"
                        },
                        {
                            "title":"Read ResourceAccess",
                            "href":"op-resourceaccess-get.html"
                        },
                        {
                            "title":"View ResourceAccess Field Length",
                            "href":"op-resourceaccess-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ResourceAccess fields",
                            "href":"op-resourceaccess-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ResourceAssignment",
                    "href":"api-resourceassignment.html",
                    "topics":[
                        {
                            "title":"Create ResourceAssignments",
                            "href":"op-resourceassignment-post.html"
                        },
                        {
                            "title":"Delete ResourceAssignments",
                            "href":"op-resourceassignment-delete.html"
                        },
                        {
                            "title":"Read All Resource Assignment by WBS",
                            "href":"op-resourceassignment-readallresourceassignmentsbywbs-get.html"
                        },
                        {
                            "title":"Read ResourceAssignments",
                            "href":"op-resourceassignment-get.html"
                        },
                        {
                            "title":"Update ResourceAssignments",
                            "href":"op-resourceassignment-put.html"
                        },
                        {
                            "title":"View ResourceAssignment Field Length",
                            "href":"op-resourceassignment-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ResourceAssignment fields",
                            "href":"op-resourceassignment-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ResourceAssignmentCode",
                    "href":"api-resourceassignmentcode.html",
                    "topics":[
                        {
                            "title":"Create ResourceAssignmentCodes",
                            "href":"op-resourceassignmentcode-post.html"
                        },
                        {
                            "title":"Delete ResourceAssignmentCodes",
                            "href":"op-resourceassignmentcode-delete.html"
                        },
                        {
                            "title":"Read ResourceAssignmentCodes",
                            "href":"op-resourceassignmentcode-get.html"
                        },
                        {
                            "title":"Update ResourceAssignmentCodes",
                            "href":"op-resourceassignmentcode-put.html"
                        },
                        {
                            "title":"View ResourceAssignmentCode Field Length",
                            "href":"op-resourceassignmentcode-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ResourceAssignmentCode fields",
                            "href":"op-resourceassignmentcode-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ResourceAssignmentCodeAssignment",
                    "href":"api-resourceassignmentcodeassignment.html",
                    "topics":[
                        {
                            "title":"Create ResourceAssignmentCodeAssignment",
                            "href":"op-resourceassignmentcodeassignment-post.html"
                        },
                        {
                            "title":"Delete ResourceAssignmentCodeAssignment",
                            "href":"op-resourceassignmentcodeassignment-delete.html"
                        },
                        {
                            "title":"Read ResourceAssignmentCodeAssignment",
                            "href":"op-resourceassignmentcodeassignment-get.html"
                        },
                        {
                            "title":"Update ResourceAssignmentCodeAssignment",
                            "href":"op-resourceassignmentcodeassignment-put.html"
                        },
                        {
                            "title":"View ResourceAssignmentCodeAssignment Field Length",
                            "href":"op-resourceassignmentcodeassignment-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ResourceAssignmentCodeAssignment fields",
                            "href":"op-resourceassignmentcodeassignment-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ResourceAssignmentCodeType",
                    "href":"api-resourceassignmentcodetype.html",
                    "topics":[
                        {
                            "title":"Create ResourceAssignmentCodeType",
                            "href":"op-resourceassignmentcodetype-post.html"
                        },
                        {
                            "title":"Delete ResourceAssignmentCodeType",
                            "href":"op-resourceassignmentcodetype-delete.html"
                        },
                        {
                            "title":"Read ResourceAssignmentCodeType",
                            "href":"op-resourceassignmentcodetype-get.html"
                        },
                        {
                            "title":"Update ResourceAssignmentCodeType",
                            "href":"op-resourceassignmentcodetype-put.html"
                        },
                        {
                            "title":"View ResourceAssignmentCodeType Field Length",
                            "href":"op-resourceassignmentcodetype-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ResourceAssignmentCodeType fields",
                            "href":"op-resourceassignmentcodetype-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ResourceAssignmentCreate",
                    "href":"api-resourceassignmentcreate.html",
                    "topics":[
                        {
                            "title":"Create ResourceAssignmentCreate",
                            "href":"op-resourceassignmentcreate-post.html"
                        },
                        {
                            "title":"Delete ResourceAssignmentCreate",
                            "href":"op-resourceassignmentcreate-delete.html"
                        },
                        {
                            "title":"Read ResourceAssignmentCreate",
                            "href":"op-resourceassignmentcreate-get.html"
                        },
                        {
                            "title":"Update ResourceAssignmentCreate",
                            "href":"op-resourceassignmentcreate-put.html"
                        },
                        {
                            "title":"View ResourceAssignmentCreate Field Length",
                            "href":"op-resourceassignmentcreate-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ResourceAssignmentCreate fields",
                            "href":"op-resourceassignmentcreate-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ResourceAssignmentPeriodActual",
                    "href":"api-resourceassignmentperiodactual.html",
                    "topics":[
                        {
                            "title":"Create ResourceAssignmentPeriodActual",
                            "href":"op-resourceassignmentperiodactual-post.html"
                        },
                        {
                            "title":"Delete ResourceAssignmentPeriodActual",
                            "href":"op-resourceassignmentperiodactual-delete.html"
                        },
                        {
                            "title":"Read ResourceAssignmentPeriodActual",
                            "href":"op-resourceassignmentperiodactual-get.html"
                        },
                        {
                            "title":"Update ResourceAssignmentPeriodActual",
                            "href":"op-resourceassignmentperiodactual-put.html"
                        },
                        {
                            "title":"View ResourceAssignmentPeriodActual Field Length",
                            "href":"op-resourceassignmentperiodactual-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ResourceAssignmentPeriodActual fields",
                            "href":"op-resourceassignmentperiodactual-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ResourceAssignmentUpdate",
                    "href":"api-resourceassignmentupdate.html",
                    "topics":[
                        {
                            "title":"Create ResourceAssignmentUpdate",
                            "href":"op-resourceassignmentupdate-post.html"
                        },
                        {
                            "title":"Delete ResourceAssignmentUpdate",
                            "href":"op-resourceassignmentupdate-delete.html"
                        },
                        {
                            "title":"Read ResourceAssignmentUpdate",
                            "href":"op-resourceassignmentupdate-get.html"
                        },
                        {
                            "title":"Update ResourceAssignmentUpdate",
                            "href":"op-resourceassignmentupdate-put.html"
                        },
                        {
                            "title":"View ResourceAssignmentUpdate Field Length",
                            "href":"op-resourceassignmentupdate-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ResourceAssignmentUpdate fields",
                            "href":"op-resourceassignmentupdate-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ResourceCode",
                    "href":"api-resourcecode.html",
                    "topics":[
                        {
                            "title":"Create ResourceCodes",
                            "href":"op-resourcecode-post.html"
                        },
                        {
                            "title":"Delete ResourceCodes",
                            "href":"op-resourcecode-delete.html"
                        },
                        {
                            "title":"Read ResourceCodes",
                            "href":"op-resourcecode-get.html"
                        },
                        {
                            "title":"Returns Resources",
                            "href":"op-resourcecode-loadresources-get.html"
                        },
                        {
                            "title":"Update ResourceCodes",
                            "href":"op-resourcecode-put.html"
                        },
                        {
                            "title":"View ResourceCode Field Length",
                            "href":"op-resourcecode-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ResourceCode fields",
                            "href":"op-resourcecode-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ResourceCodeAssignment",
                    "href":"api-resourcecodeassignment.html",
                    "topics":[
                        {
                            "title":"Create ResourceCodeAssignment",
                            "href":"op-resourcecodeassignment-post.html"
                        },
                        {
                            "title":"Delete ResourceCodeAssignment",
                            "href":"op-resourcecodeassignment-delete.html"
                        },
                        {
                            "title":"Read ResourceCodeAssignment",
                            "href":"op-resourcecodeassignment-get.html"
                        },
                        {
                            "title":"Update ResourceCodeAssignment",
                            "href":"op-resourcecodeassignment-put.html"
                        },
                        {
                            "title":"View ResourceCodeAssignment Field Length",
                            "href":"op-resourcecodeassignment-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ResourceCodeAssignment fields",
                            "href":"op-resourcecodeassignment-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ResourceCodeType",
                    "href":"api-resourcecodetype.html",
                    "topics":[
                        {
                            "title":"Create ResourceCodeTypes",
                            "href":"op-resourcecodetype-post.html"
                        },
                        {
                            "title":"Delete ResourceCodeTypes",
                            "href":"op-resourcecodetype-delete.html"
                        },
                        {
                            "title":"Read ResourceCodeType",
                            "href":"op-resourcecodetype-get.html"
                        },
                        {
                            "title":"Update ResourceCodeTypes",
                            "href":"op-resourcecodetype-put.html"
                        },
                        {
                            "title":"View ResourceCodeType Field Length",
                            "href":"op-resourcecodetype-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ResourceCodeType fields",
                            "href":"op-resourcecodetype-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ResourceCurve",
                    "href":"api-resourcecurve.html",
                    "topics":[
                        {
                            "title":"Create ResourceCurve",
                            "href":"op-resourcecurve-post.html"
                        },
                        {
                            "title":"Delete ResourceCurve",
                            "href":"op-resourcecurve-delete.html"
                        },
                        {
                            "title":"Read ResourceCurve",
                            "href":"op-resourcecurve-get.html"
                        },
                        {
                            "title":"Update ResourceCurve",
                            "href":"op-resourcecurve-put.html"
                        },
                        {
                            "title":"View ResourceCurve Field Length",
                            "href":"op-resourcecurve-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ResourceCurve fields",
                            "href":"op-resourcecurve-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ResourceHour",
                    "href":"api-resourcehour.html",
                    "topics":[
                        {
                            "title":"Create ResourceHour",
                            "href":"op-resourcehour-post.html"
                        },
                        {
                            "title":"Delete ResourceHour",
                            "href":"op-resourcehour-delete.html"
                        },
                        {
                            "title":"Read ResourceHour",
                            "href":"op-resourcehour-get.html"
                        },
                        {
                            "title":"Update ResourceHour",
                            "href":"op-resourcehour-put.html"
                        },
                        {
                            "title":"View ResourceHour Field Length",
                            "href":"op-resourcehour-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ResourceHour fields",
                            "href":"op-resourcehour-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ResourceLocation",
                    "href":"api-resourcelocation.html",
                    "topics":[
                        {
                            "title":"Create ResourceLocations",
                            "href":"op-resourcelocation-post.html"
                        },
                        {
                            "title":"Delete ResourceLocation",
                            "href":"op-resourcelocation-delete.html"
                        },
                        {
                            "title":"Read ResourceLocations",
                            "href":"op-resourcelocation-get.html"
                        },
                        {
                            "title":"Update ResourceLocation",
                            "href":"op-resourcelocation-put.html"
                        },
                        {
                            "title":"View ResourceLocation Field Length",
                            "href":"op-resourcelocation-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ResourceLocation fields",
                            "href":"op-resourcelocation-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ResourceRate",
                    "href":"api-resourcerate.html",
                    "topics":[
                        {
                            "title":"Create ResourceRate",
                            "href":"op-resourcerate-post.html"
                        },
                        {
                            "title":"Delete ResourceRate",
                            "href":"op-resourcerate-delete.html"
                        },
                        {
                            "title":"Read ResourceRate",
                            "href":"op-resourcerate-get.html"
                        },
                        {
                            "title":"Update ResourceRate",
                            "href":"op-resourcerate-put.html"
                        },
                        {
                            "title":"View ResourceRate Field Length",
                            "href":"op-resourcerate-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ResourceRate fields",
                            "href":"op-resourcerate-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ResourceRole",
                    "href":"api-resourcerole.html",
                    "topics":[
                        {
                            "title":"Create ResourceRole",
                            "href":"op-resourcerole-post.html"
                        },
                        {
                            "title":"Delete ResourceRole",
                            "href":"op-resourcerole-delete.html"
                        },
                        {
                            "title":"Read ResourceRole",
                            "href":"op-resourcerole-get.html"
                        },
                        {
                            "title":"Update ResourceRole",
                            "href":"op-resourcerole-put.html"
                        },
                        {
                            "title":"View ResourceRole Field Length",
                            "href":"op-resourcerole-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ResourceRole fields",
                            "href":"op-resourcerole-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ResourceTeam",
                    "href":"api-resourceteam.html",
                    "topics":[
                        {
                            "title":"Add Resources",
                            "href":"op-resourceteam-addresources-put.html"
                        },
                        {
                            "title":"Create ResourceTeam",
                            "href":"op-resourceteam-post.html"
                        },
                        {
                            "title":"Delete ResourceTeam",
                            "href":"op-resourceteam-delete.html"
                        },
                        {
                            "title":"Get Resource Object Ids",
                            "href":"op-resourceteam-getresourceobjectids-get.html"
                        },
                        {
                            "title":"Read ResourceTeam",
                            "href":"op-resourceteam-get.html"
                        },
                        {
                            "title":"Remove Resources",
                            "href":"op-resourceteam-removeresources-put.html"
                        },
                        {
                            "title":"Update ResourceTeam",
                            "href":"op-resourceteam-put.html"
                        },
                        {
                            "title":"View ResourceTeam Field Length",
                            "href":"op-resourceteam-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ResourceTeam fields",
                            "href":"op-resourceteam-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"Risk",
                    "href":"api-risk.html",
                    "topics":[
                        {
                            "title":"Create Risks",
                            "href":"op-risk-post.html"
                        },
                        {
                            "title":"Delete Risks",
                            "href":"op-risk-delete.html"
                        },
                        {
                            "title":"Read Risks",
                            "href":"op-risk-get.html"
                        },
                        {
                            "title":"Update Risks",
                            "href":"op-risk-put.html"
                        },
                        {
                            "title":"View Risk Field Length",
                            "href":"op-risk-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View Risk fields",
                            "href":"op-risk-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"RiskCategory",
                    "href":"api-riskcategory.html",
                    "topics":[
                        {
                            "title":"Create RiskCategories",
                            "href":"op-riskcategory-post.html"
                        },
                        {
                            "title":"Delete RiskCategories",
                            "href":"op-riskcategory-delete.html"
                        },
                        {
                            "title":"Read RiskCategories",
                            "href":"op-riskcategory-get.html"
                        },
                        {
                            "title":"Update RiskCategories",
                            "href":"op-riskcategory-put.html"
                        },
                        {
                            "title":"View RiskCategory Field Length",
                            "href":"op-riskcategory-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View RiskCategory fields",
                            "href":"op-riskcategory-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"RiskImpact",
                    "href":"api-riskimpact.html",
                    "topics":[
                        {
                            "title":"Create RiskImpacts",
                            "href":"op-riskimpact-post.html"
                        },
                        {
                            "title":"Delete RiskImpacts",
                            "href":"op-riskimpact-delete.html"
                        },
                        {
                            "title":"Read RiskImpacts",
                            "href":"op-riskimpact-get.html"
                        },
                        {
                            "title":"Update RiskImpacts",
                            "href":"op-riskimpact-put.html"
                        },
                        {
                            "title":"View RiskImpact Field Length",
                            "href":"op-riskimpact-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View RiskImpact fields",
                            "href":"op-riskimpact-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"RiskMatrix",
                    "href":"api-riskmatrix.html",
                    "topics":[
                        {
                            "title":"Create RiskMatrixs",
                            "href":"op-riskmatrix-post.html"
                        },
                        {
                            "title":"Delete RiskMatrixs",
                            "href":"op-riskmatrix-delete.html"
                        },
                        {
                            "title":"Read RiskMatrixs",
                            "href":"op-riskmatrix-get.html"
                        },
                        {
                            "title":"Update RiskMatrixs",
                            "href":"op-riskmatrix-put.html"
                        },
                        {
                            "title":"View RiskMatrix Field Length",
                            "href":"op-riskmatrix-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View RiskMatrix fields",
                            "href":"op-riskmatrix-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"RiskMatrixScore",
                    "href":"api-riskmatrixscore.html",
                    "topics":[
                        {
                            "title":"Create RiskMatrixScores",
                            "href":"op-riskmatrixscore-post.html"
                        },
                        {
                            "title":"Delete RiskMatrixScores",
                            "href":"op-riskmatrixscore-delete.html"
                        },
                        {
                            "title":"Read RiskMatrixScores",
                            "href":"op-riskmatrixscore-get.html"
                        },
                        {
                            "title":"Update RiskMatrixScores",
                            "href":"op-riskmatrixscore-put.html"
                        },
                        {
                            "title":"View RiskMatrixScore Field Length",
                            "href":"op-riskmatrixscore-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View RiskMatrixScore fields",
                            "href":"op-riskmatrixscore-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"RiskMatrixThreshold",
                    "href":"api-riskmatrixthreshold.html",
                    "topics":[
                        {
                            "title":"Create RiskMatrixThresholds",
                            "href":"op-riskmatrixthreshold-post.html"
                        },
                        {
                            "title":"Delete RiskMatrixThresholds",
                            "href":"op-riskmatrixthreshold-delete.html"
                        },
                        {
                            "title":"Read RiskMatrixThresholds",
                            "href":"op-riskmatrixthreshold-get.html"
                        },
                        {
                            "title":"View RiskMatrixThreshold Field Length",
                            "href":"op-riskmatrixthreshold-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View RiskMatrixThreshold fields",
                            "href":"op-riskmatrixthreshold-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"RiskResponseAction",
                    "href":"api-riskresponseaction.html",
                    "topics":[
                        {
                            "title":"Create RiskResponseActions",
                            "href":"op-riskresponseaction-post.html"
                        },
                        {
                            "title":"Delete RiskResponseActions",
                            "href":"op-riskresponseaction-delete.html"
                        },
                        {
                            "title":"Read RiskResponseActions",
                            "href":"op-riskresponseaction-get.html"
                        },
                        {
                            "title":"Update RiskResponseActions",
                            "href":"op-riskresponseaction-put.html"
                        },
                        {
                            "title":"View RiskResponseAction Field Length",
                            "href":"op-riskresponseaction-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View RiskResponseAction fields",
                            "href":"op-riskresponseaction-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"RiskResponseActionImpact",
                    "href":"api-riskresponseactionimpact.html",
                    "topics":[
                        {
                            "title":"Create RiskResponseActionImpacts",
                            "href":"op-riskresponseactionimpact-post.html"
                        },
                        {
                            "title":"Delete RiskResponseActionImpacts",
                            "href":"op-riskresponseactionimpact-delete.html"
                        },
                        {
                            "title":"Read RiskResponseActionImpacts",
                            "href":"op-riskresponseactionimpact-get.html"
                        },
                        {
                            "title":"Update RiskResponseActionImpacts",
                            "href":"op-riskresponseactionimpact-put.html"
                        },
                        {
                            "title":"View RiskResponseActionImpact Field Length",
                            "href":"op-riskresponseactionimpact-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View RiskResponseActionImpact fields",
                            "href":"op-riskresponseactionimpact-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"RiskResponsePlan",
                    "href":"api-riskresponseplan.html",
                    "topics":[
                        {
                            "title":"Create RiskResponsePlans",
                            "href":"op-riskresponseplan-post.html"
                        },
                        {
                            "title":"Delete RiskResponsePlans",
                            "href":"op-riskresponseplan-delete.html"
                        },
                        {
                            "title":"Read RiskResponsePlans",
                            "href":"op-riskresponseplan-get.html"
                        },
                        {
                            "title":"Update RiskResponsePlans",
                            "href":"op-riskresponseplan-put.html"
                        },
                        {
                            "title":"View RiskResponsePlan Field Length",
                            "href":"op-riskresponseplan-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View RiskResponsePlan fields",
                            "href":"op-riskresponseplan-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"RiskThreshold",
                    "href":"api-riskthreshold.html",
                    "topics":[
                        {
                            "title":"Create RiskThresholds",
                            "href":"op-riskthreshold-post.html"
                        },
                        {
                            "title":"Delete RiskThresholds",
                            "href":"op-riskthreshold-delete.html"
                        },
                        {
                            "title":"Read RiskThresholds",
                            "href":"op-riskthreshold-get.html"
                        },
                        {
                            "title":"Update RiskThresholds",
                            "href":"op-riskthreshold-put.html"
                        },
                        {
                            "title":"View RiskThreshold Field Length",
                            "href":"op-riskthreshold-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View RiskThreshold fields",
                            "href":"op-riskthreshold-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"RiskThresholdLevel",
                    "href":"api-riskthresholdlevel.html",
                    "topics":[
                        {
                            "title":"Create RiskThresholdLevels",
                            "href":"op-riskthresholdlevel-post.html"
                        },
                        {
                            "title":"Delete RiskThresholdLevels",
                            "href":"op-riskthresholdlevel-delete.html"
                        },
                        {
                            "title":"Read RiskThresholdLevels",
                            "href":"op-riskthresholdlevel-get.html"
                        },
                        {
                            "title":"Update RiskThresholdLevels",
                            "href":"op-riskthresholdlevel-put.html"
                        },
                        {
                            "title":"View RiskThresholdLevel Field Length",
                            "href":"op-riskthresholdlevel-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View RiskThresholdLevel fields",
                            "href":"op-riskthresholdlevel-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"Role",
                    "href":"api-role.html",
                    "topics":[
                        {
                            "title":"Create Role",
                            "href":"op-role-post.html"
                        },
                        {
                            "title":"Delete Role",
                            "href":"op-role-delete.html"
                        },
                        {
                            "title":"Read Role",
                            "href":"op-role-get.html"
                        },
                        {
                            "title":"Update Activities",
                            "href":"op-role-put.html"
                        },
                        {
                            "title":"View Role Field Length",
                            "href":"op-role-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View Role fields",
                            "href":"op-role-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"RoleCode",
                    "href":"api-rolecode.html",
                    "topics":[
                        {
                            "title":"Create RoleCodes",
                            "href":"op-rolecode-post.html"
                        },
                        {
                            "title":"Delete RoleCode",
                            "href":"op-rolecode-delete.html"
                        },
                        {
                            "title":"Read RoleCodes",
                            "href":"op-rolecode-get.html"
                        },
                        {
                            "title":"Update RoleCode",
                            "href":"op-rolecode-put.html"
                        },
                        {
                            "title":"View RoleCode Field Length",
                            "href":"op-rolecode-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View RoleCode fields",
                            "href":"op-rolecode-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"RoleCodeAssignment",
                    "href":"api-rolecodeassignment.html",
                    "topics":[
                        {
                            "title":"Create RoleCodeAssignments",
                            "href":"op-rolecodeassignment-post.html"
                        },
                        {
                            "title":"Delete RoleCodeAssignments",
                            "href":"op-rolecodeassignment-delete.html"
                        },
                        {
                            "title":"Read RoleCodeAssignments",
                            "href":"op-rolecodeassignment-get.html"
                        },
                        {
                            "title":"Update RoleCodeAssignments",
                            "href":"op-rolecodeassignment-put.html"
                        },
                        {
                            "title":"View RoleCodeAssignment Field Length",
                            "href":"op-rolecodeassignment-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View RoleCodeAssignment fields",
                            "href":"op-rolecodeassignment-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"RoleCodeType",
                    "href":"api-rolecodetype.html",
                    "topics":[
                        {
                            "title":"Create RoleCodeTypes",
                            "href":"op-rolecodetype-post.html"
                        },
                        {
                            "title":"Delete RoleCodeTypes",
                            "href":"op-rolecodetype-delete.html"
                        },
                        {
                            "title":"Read RoleCodeTypes",
                            "href":"op-rolecodetype-get.html"
                        },
                        {
                            "title":"Update RoleCodeTypes",
                            "href":"op-rolecodetype-put.html"
                        },
                        {
                            "title":"View RoleCodeType Field Length",
                            "href":"op-rolecodetype-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View RoleCodeType fields",
                            "href":"op-rolecodetype-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"RoleRate",
                    "href":"api-rolerate.html",
                    "topics":[
                        {
                            "title":"Create RoleRate",
                            "href":"op-rolerate-post.html"
                        },
                        {
                            "title":"Delete RoleRate",
                            "href":"op-rolerate-delete.html"
                        },
                        {
                            "title":"Read RoleRate",
                            "href":"op-rolerate-get.html"
                        },
                        {
                            "title":"Update Activities",
                            "href":"op-rolerate-put.html"
                        },
                        {
                            "title":"View RoleRate Field Length",
                            "href":"op-rolerate-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View RoleRate fields",
                            "href":"op-rolerate-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ScheduleCheckOption",
                    "href":"api-schedulecheckoption.html",
                    "topics":[
                        {
                            "title":"Create ScheduleCheckOption",
                            "href":"op-schedulecheckoption-post.html"
                        },
                        {
                            "title":"Delete ScheduleCheckOption",
                            "href":"op-schedulecheckoption-delete.html"
                        },
                        {
                            "title":"Read ScheduleCheckOption",
                            "href":"op-schedulecheckoption-get.html"
                        },
                        {
                            "title":"Update ScheduleCheckOption",
                            "href":"op-schedulecheckoption-put.html"
                        },
                        {
                            "title":"View ScheduleCheckOption Field Length",
                            "href":"op-schedulecheckoption-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ScheduleCheckOption fields",
                            "href":"op-schedulecheckoption-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"ScheduleOptions",
                    "href":"api-scheduleoptions.html",
                    "topics":[
                        {
                            "title":"Read ScheduleOptions",
                            "href":"op-scheduleoptions-get.html"
                        },
                        {
                            "title":"Update ScheduleOptions",
                            "href":"op-scheduleoptions-put.html"
                        },
                        {
                            "title":"View ScheduleOptions Field Length",
                            "href":"op-scheduleoptions-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ScheduleOptions fields",
                            "href":"op-scheduleoptions-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"Shift",
                    "href":"api-shift.html",
                    "topics":[
                        {
                            "title":"Add ShiftPeriod",
                            "href":"op-shift-addshiftperiod-put.html"
                        },
                        {
                            "title":"Create Shift",
                            "href":"op-shift-post.html"
                        },
                        {
                            "title":"Delete Shift",
                            "href":"op-shift-delete.html"
                        },
                        {
                            "title":"Read Shift",
                            "href":"op-shift-get.html"
                        },
                        {
                            "title":"Remove all ShiftPeriod",
                            "href":"op-shift-removeallshiftperiods-put.html"
                        },
                        {
                            "title":"Remove ShiftPeriod",
                            "href":"op-shift-removeshiftperiod-put.html"
                        },
                        {
                            "title":"Update Shift",
                            "href":"op-shift-put.html"
                        },
                        {
                            "title":"View Shift Field Length",
                            "href":"op-shift-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View Shift fields",
                            "href":"op-shift-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"Spread",
                    "href":"api-spread.html",
                    "topics":[
                        {
                            "title":"ReadActivitySpread",
                            "href":"op-spread-activityspread-get.html"
                        },
                        {
                            "title":"ReadCBSExpenseSpread",
                            "href":"op-spread-cbsexpensespread-get.html"
                        },
                        {
                            "title":"ReadCBSResourceSpread",
                            "href":"op-spread-cbsresourcespread-get.html"
                        },
                        {
                            "title":"ReadEPSSpread",
                            "href":"op-spread-epsspread-get.html"
                        },
                        {
                            "title":"ReadProjectResourceSpread",
                            "href":"op-spread-projectresourcespread-get.html"
                        },
                        {
                            "title":"ReadProjectRoleSpread",
                            "href":"op-spread-projectrolespread-get.html"
                        },
                        {
                            "title":"ReadProjectSpread",
                            "href":"op-spread-projectspread-get.html"
                        },
                        {
                            "title":"ReadResourceAssignmentSpread",
                            "href":"op-spread-resourceassignmentspread-get.html"
                        },
                        {
                            "title":"ReadWBSExpenseSpread",
                            "href":"op-spread-wbsexpensespread-get.html"
                        },
                        {
                            "title":"ReadWBSResourceSpread",
                            "href":"op-spread-wbsresourcespread-get.html"
                        },
                        {
                            "title":"ReadWBSRoleSpread",
                            "href":"op-spread-wbsrolespread-get.html"
                        },
                        {
                            "title":"ReadWBSSpread",
                            "href":"op-spread-wbsspread-get.html"
                        },
                        {
                            "title":"Update ResourceAssignmentSpread",
                            "href":"op-spread-resourceassignmentspread-put.html"
                        }
                    ]
                },
                {
                    "title":"SyncService",
                    "href":"api-syncservice.html",
                    "topics":[
                        {
                            "title":"Update Project",
                            "href":"op-syncservice-updateproject-put.html"
                        }
                    ]
                },
                {
                    "title":"ThresholdParameter",
                    "href":"api-thresholdparameter.html",
                    "topics":[
                        {
                            "title":"Read ThresholdParameters",
                            "href":"op-thresholdparameter-get.html"
                        },
                        {
                            "title":"View ThresholdParameter Field Length",
                            "href":"op-thresholdparameter-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View ThresholdParameter fields",
                            "href":"op-thresholdparameter-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"Timesheet",
                    "href":"api-timesheet.html",
                    "topics":[
                        {
                            "title":"Create Timesheet",
                            "href":"op-timesheet-post.html"
                        },
                        {
                            "title":"Delete Timesheet",
                            "href":"op-timesheet-delete.html"
                        },
                        {
                            "title":"Read Timesheet",
                            "href":"op-timesheet-get.html"
                        },
                        {
                            "title":"Update Timesheet",
                            "href":"op-timesheet-put.html"
                        },
                        {
                            "title":"View Timesheet Field Length",
                            "href":"op-timesheet-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View Timesheet fields",
                            "href":"op-timesheet-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"TimesheetAudit",
                    "href":"api-timesheetaudit.html",
                    "topics":[
                        {
                            "title":"Read TimesheetAudit",
                            "href":"op-timesheetaudit-get.html"
                        },
                        {
                            "title":"View TimesheetAudit Field Length",
                            "href":"op-timesheetaudit-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View TimesheetAudit fields",
                            "href":"op-timesheetaudit-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"TimesheetDelegate",
                    "href":"api-timesheetdelegate.html",
                    "topics":[
                        {
                            "title":"Read TimesheetDelegate",
                            "href":"op-timesheetdelegate-get.html"
                        },
                        {
                            "title":"View TimesheetDelegate Field Length",
                            "href":"op-timesheetdelegate-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View TimesheetDelegate fields",
                            "href":"op-timesheetdelegate-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"TimesheetPeriod",
                    "href":"api-timesheetperiod.html",
                    "topics":[
                        {
                            "title":"Create TimesheetPeriods",
                            "href":"op-timesheetperiod-post.html"
                        },
                        {
                            "title":"Delete TimesheetPeriods",
                            "href":"op-timesheetperiod-delete.html"
                        },
                        {
                            "title":"Read TimesheetPeriods",
                            "href":"op-timesheetperiod-get.html"
                        },
                        {
                            "title":"Update TimesheetPeriods",
                            "href":"op-timesheetperiod-put.html"
                        },
                        {
                            "title":"View TimesheetPeriod Field Length",
                            "href":"op-timesheetperiod-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View TimesheetPeriod fields",
                            "href":"op-timesheetperiod-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"UDFCode",
                    "href":"api-udfcode.html",
                    "topics":[
                        {
                            "title":"Create UDFCodes",
                            "href":"op-udfcode-post.html"
                        },
                        {
                            "title":"Delete UDFCodes",
                            "href":"op-udfcode-delete.html"
                        },
                        {
                            "title":"Read UDFCodes",
                            "href":"op-udfcode-get.html"
                        },
                        {
                            "title":"Update UDFCodes",
                            "href":"op-udfcode-put.html"
                        },
                        {
                            "title":"View UDFCode Field Length",
                            "href":"op-udfcode-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View UDFCode fields",
                            "href":"op-udfcode-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"UDFType",
                    "href":"api-udftype.html",
                    "topics":[
                        {
                            "title":"Create UDFTypes",
                            "href":"op-udftype-post.html"
                        },
                        {
                            "title":"Delete UDFTypes",
                            "href":"op-udftype-delete.html"
                        },
                        {
                            "title":"Read UDFTypes",
                            "href":"op-udftype-get.html"
                        },
                        {
                            "title":"Update UDFTypes",
                            "href":"op-udftype-put.html"
                        },
                        {
                            "title":"View UDFType Field Length",
                            "href":"op-udftype-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View UDFType fields",
                            "href":"op-udftype-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"UDFValue",
                    "href":"api-udfvalue.html",
                    "topics":[
                        {
                            "title":"Create UDFValue",
                            "href":"op-udfvalue-post.html"
                        },
                        {
                            "title":"Delete UDFValue",
                            "href":"op-udfvalue-delete.html"
                        },
                        {
                            "title":"Read UDFValues",
                            "href":"op-udfvalue-get.html"
                        },
                        {
                            "title":"Update UDFValue",
                            "href":"op-udfvalue-put.html"
                        },
                        {
                            "title":"View UDFValue Field Length",
                            "href":"op-udfvalue-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View UDFValue fields",
                            "href":"op-udfvalue-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"UnitOfMeasure",
                    "href":"api-unitofmeasure.html",
                    "topics":[
                        {
                            "title":"Create UnitOfMeasures",
                            "href":"op-unitofmeasure-post.html"
                        },
                        {
                            "title":"Delete UnitOfMeasures",
                            "href":"op-unitofmeasure-delete.html"
                        },
                        {
                            "title":"Read UnitOfMeasures",
                            "href":"op-unitofmeasure-get.html"
                        },
                        {
                            "title":"Update UnitOfMeasures",
                            "href":"op-unitofmeasure-put.html"
                        },
                        {
                            "title":"View UnitOfMeasure Field Length",
                            "href":"op-unitofmeasure-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View UnitOfMeasure fields",
                            "href":"op-unitofmeasure-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"UpdateBaselineOption",
                    "href":"api-updatebaselineoption.html",
                    "topics":[
                        {
                            "title":"Read UpdateBaselineOption",
                            "href":"op-updatebaselineoption-get.html"
                        },
                        {
                            "title":"Update UpdateBaselineOption",
                            "href":"op-updatebaselineoption-put.html"
                        },
                        {
                            "title":"View UpdateBaselineOption Field Length",
                            "href":"op-updatebaselineoption-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View UpdateBaselineOption fields",
                            "href":"op-updatebaselineoption-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"User",
                    "href":"api-user.html",
                    "topics":[
                        {
                            "title":"Create Users",
                            "href":"op-user-post.html"
                        },
                        {
                            "title":"Delete Users",
                            "href":"op-user-delete.html"
                        },
                        {
                            "title":"getPrimaryBaselineProject Operation",
                            "href":"op-user-getprimarybaselineproject-get.html"
                        },
                        {
                            "title":"LoadUserFilteredActivities Operation",
                            "href":"op-user-loaduserfilteredactivities-get.html"
                        },
                        {
                            "title":"LoadUserFilteredMilestoneActivities Operation",
                            "href":"op-user-loaduserfilteredmilestoneactivities-get.html"
                        },
                        {
                            "title":"Read Users",
                            "href":"op-user-get.html"
                        },
                        {
                            "title":"SetMailServerPassword Operation",
                            "href":"op-user-setmailserverpassword-put.html"
                        },
                        {
                            "title":"setPrimaryBaselineProject Operation",
                            "href":"op-user-setprimarybaselineproject-put.html"
                        },
                        {
                            "title":"SetUserPassword Operation",
                            "href":"op-user-setuserpassword-put.html"
                        },
                        {
                            "title":"Update Users",
                            "href":"op-user-put.html"
                        },
                        {
                            "title":"View User Field Length",
                            "href":"op-user-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View User fields",
                            "href":"op-user-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"UserFieldTitle",
                    "href":"api-userfieldtitle.html",
                    "topics":[
                        {
                            "title":"Read UserFieldTitles",
                            "href":"op-userfieldtitle-get.html"
                        },
                        {
                            "title":"Update UserFieldTitles",
                            "href":"op-userfieldtitle-put.html"
                        },
                        {
                            "title":"View UserFieldTitle Field Length",
                            "href":"op-userfieldtitle-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View UserFieldTitle fields",
                            "href":"op-userfieldtitle-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"UserInterfaceView",
                    "href":"api-userinterfaceview.html",
                    "topics":[
                        {
                            "title":"Read UserInterfaceView",
                            "href":"op-userinterfaceview-get.html"
                        },
                        {
                            "title":"View UserInterfaceView Field Length",
                            "href":"op-userinterfaceview-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View UserInterfaceView fields",
                            "href":"op-userinterfaceview-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"UserLicense",
                    "href":"api-userlicense.html",
                    "topics":[
                        {
                            "title":"Create UserLicense",
                            "href":"op-userlicense-post.html"
                        },
                        {
                            "title":"Delete UserLicense",
                            "href":"op-userlicense-delete.html"
                        },
                        {
                            "title":"Read UserLicense",
                            "href":"op-userlicense-get.html"
                        },
                        {
                            "title":"View UserLicense Field Length",
                            "href":"op-userlicense-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View UserLicense fields",
                            "href":"op-userlicense-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"UserOBS",
                    "href":"api-userobs.html",
                    "topics":[
                        {
                            "title":"Create UserOBS",
                            "href":"op-userobs-post.html"
                        },
                        {
                            "title":"Delete UserOBS",
                            "href":"op-userobs-delete.html"
                        },
                        {
                            "title":"Read UserOBS",
                            "href":"op-userobs-get.html"
                        },
                        {
                            "title":"Update UserOBS",
                            "href":"op-userobs-put.html"
                        },
                        {
                            "title":"View UserOBS Field Length",
                            "href":"op-userobs-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View UserOBS fields",
                            "href":"op-userobs-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"WBS",
                    "href":"api-wbs.html",
                    "topics":[
                        {
                            "title":"Copy WBS from Template",
                            "href":"op-wbs-copywbsfromtemplate-post.html"
                        },
                        {
                            "title":"Create WBS",
                            "href":"op-wbs-post.html"
                        },
                        {
                            "title":"Delete WBS",
                            "href":"op-wbs-delete.html"
                        },
                        {
                            "title":"Read Activity WBS Path",
                            "href":"op-wbs-readactivitywbspath-get.html"
                        },
                        {
                            "title":"Read All WBS",
                            "href":"op-wbs-readallwbs-get.html"
                        },
                        {
                            "title":"Read WBS",
                            "href":"op-wbs-get.html"
                        },
                        {
                            "title":"Read WBS Path",
                            "href":"op-wbs-readwbspath-get.html"
                        },
                        {
                            "title":"Update WBS",
                            "href":"op-wbs-put.html"
                        },
                        {
                            "title":"View WBS Field Length",
                            "href":"op-wbs-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View WBS fields",
                            "href":"op-wbs-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"WBSCategory",
                    "href":"api-wbscategory.html",
                    "topics":[
                        {
                            "title":"Create WBSCategories",
                            "href":"op-wbscategory-post.html"
                        },
                        {
                            "title":"Delete WBSCategories",
                            "href":"op-wbscategory-delete.html"
                        },
                        {
                            "title":"Read WBSCategories",
                            "href":"op-wbscategory-get.html"
                        },
                        {
                            "title":"Update WBSCategories",
                            "href":"op-wbscategory-put.html"
                        },
                        {
                            "title":"View WBSCategory Field Length",
                            "href":"op-wbscategory-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View WBSCategory fields",
                            "href":"op-wbscategory-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"WBSMilestone",
                    "href":"api-wbsmilestone.html",
                    "topics":[
                        {
                            "title":"Create WBSMilestone",
                            "href":"op-wbsmilestone-post.html"
                        },
                        {
                            "title":"Delete WBSMilestone",
                            "href":"op-wbsmilestone-delete.html"
                        },
                        {
                            "title":"Read WBSMilestone",
                            "href":"op-wbsmilestone-get.html"
                        },
                        {
                            "title":"Update WBSMilestone",
                            "href":"op-wbsmilestone-put.html"
                        },
                        {
                            "title":"View Project Field Length",
                            "href":"op-wbsmilestone-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View Project fields",
                            "href":"op-wbsmilestone-fields-get.html"
                        }
                    ]
                },
                {
                    "title":"WbsReviewers",
                    "href":"api-wbsreviewers.html",
                    "topics":[
                        {
                            "title":"Create WbsReviewers",
                            "href":"op-wbsreviewers-post.html"
                        },
                        {
                            "title":"Delete WbsReviewers",
                            "href":"op-wbsreviewers-delete.html"
                        },
                        {
                            "title":"Read WbsReviewers",
                            "href":"op-wbsreviewers-get.html"
                        },
                        {
                            "title":"Update WbsReviewers",
                            "href":"op-wbsreviewers-put.html"
                        },
                        {
                            "title":"View WbsReviewers Field Length",
                            "href":"op-wbsreviewers-getfieldlength-fieldname-get.html"
                        },
                        {
                            "title":"View WbsReviewers fields",
                            "href":"op-wbsreviewers-fields-get.html"
                        }
                    ]
                }
            ]
        }
    ]
});