'use strict';
function search(SearchText, inHeading) {
(function () {
var Page = [];

/* Generated with Author-it 23.4.1.30004  12/8/2025 10:50:38 AM */
Page[0]=new Array("Title and Copyright Information","Copyright  2010,  2025, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information","46576.htm");
Page[1]=new Array("Scope","Use this guide to learn more about the types of events that can be triggered when using P6.","Audience","This guide is intended to be used by system and network administrators.","Within our documentation, some content might be specific for cloud deployments while other content is relevant for on-premises deployments. Any content that applies to only one of these deployments is labeled accordingly.","About This Guide","93171.htm");
Page[2]=new Array("Personal information (PI) is any piece of data which can be used on its own or with other information to identify, contact or locate an individual or identify an individual in context. This information is not limited to a person's name, address, and contact details, for example a person's IP address, phone IMEI number, gender, and location at a particular time could all be personal information. Organizations are responsible for ensuring the privacy of PI wherever it is stored, including in back-ups, locally stored downloads, and data stored in development environments.","Caution Personal information (PI) may be at risk of exposure. Depending on local data protection laws organizations may be responsible for mitigating any risk of exposure.","About Personal Information","97692.htm");
Page[3]=new Array("Depending on administrative settings, events can be triggered by changes that take place in the P6 database. These events can be classified into two types of events:","Business object events: Triggered when the P6, the P6 Integration API (on-premises only), or P6 EPPM Web Services is used to update or create objects in the P6 database. ","Special operation events: Triggered when a supported operation or job service is invoked.","When a change triggers an event, the P6 Event Notification system sends the event message to a user configured message queue. You can use the events in a client application to trigger subsequent actions. You could, for example, launch an external workflow based on the existence of a specific event.","Note The content in this section details optional configuration for P6. You do not need to configure eventing for P6 in order to enable P6 for users to work in the application.","Overview of Eventing (On Premises Only)","38422.htm");
Page[4]=new Array("An event may be one of two types, a business object event or a special operation event.","See Business Object Events for a list of business object events.","See Special Operation Events for a list of special operation events.","Changes that trigger events","With the exception of the Timesheet object, create and update changes made to supported objects using P6, the P6 Integration API (on-premises only), or P6 EPPM Web Services will trigger an event. When a status change is made to a Timesheet object using P6, a TimesheetUpdated event will be triggered.","Changes that do not trigger events","The following create and update changes do not trigger events:","Create and update changes made to objects that do not support events ","Create and update changes made to objects that support events but are not configured to send events ","Changes made in P6 Professional","Note Additionally, an event is triggered when you run either the Apply Actuals or Summarize Job service from P6 Professional.  Receiving either of these events depends on administrative settings and requires that P6, the P6 Integration API (on-premises only), or P6 EPPM Web Services is running on the same database as P6 Professional.","Event Triggers","38423.htm");
Page[5]=new Array("Events are triggered when a supported business object is updated or changed. Forty-seven P6 business objects support both create and update event notification messages.","Note Only updates to physical fields trigger events. Updates or changes to calculated fields or BLOBs, GUIDs, or SequenceNumbers do not trigger events.","In addition to update and create changes to the database, changes caused by special operations also trigger events. Twenty-two special operations trigger events when the operation specified by the message completes.","See Business Object Events for additional information about business object events.","See Special Operation Events for additional information about special operation events.","Administrators can enable and disable event notification messages on a per object basis. Refer to the P6 EPPM Application Administration Guide for additional information.","Business Object vs Special Operation Events","38425.htm");
Page[6]=new Array("Forty-seven P6 business objects support create and update event notification messages. Administrators can enable and disable event notification messages on a per object basis. ","The table below lists the business objects that support event notification messages along with the message that is sent when an event is triggered:","Object","Notification Message","Triggered Message","Activity","ActivityCreated Message","ActivityUpdated Message","ActivityCodeAssignment","ActivityCodeAssignmentCreated Message","ActivityCodeAssignmentUpdated Message","ActivityExpense","ActivityExpenseCreated Message","ActivityExpenseUpdated Message","ActivityNote","ActivityNoteCreated Message","ActivityNoteUpdated Message","ActivityOwner","ActivityOwnerCreated Message","ActivityOwnerUpdated Message","ActivityRisk","ActivityRiskCreated Message","ActivityRiskUpdated Message","ActivityStep","ActivityStepCreated Message","ActivityStepUpdated Message","BaselineProject","BaselineProjectCreated Message","BaselineProjectUpdated Message","Calendar","CalendarCreated Message","CalendarUpdated Message","EPS","EPSCreated Message","EPSUpdated Message","EPSBudgetChangeLog","EPSBudgetChangeLogCreated Message","EPSBudgetChangeLogUpdated Message","EPSFunding","EPSFundingCreated Message","EPSFundingUpdated Message","EPSNote","EPSNoteCreated Message","EPSNoteUpdated Message","Project","ProjectCreated Message","ProjectUpdated Message","ProjectBudgetChangeLog","ProjectBudgetChangeLogCreated Message","ProjectBudgetChangeLogUpdated Message","ProjectCodeAssignment","ProjectCodeAssignmentCreated Message","ProjectCodeAssignmentUpdated Message","ProjectFunding","ProjectFundingCreated Message","ProjectFundingUpdated Message","ProjectIssue","ProjectIssueCreated Message","ProjectIssueUpdated Message","ProjectNote","ProjectNoteCreated Message","ProjectNoteUpdated Message","ProjectPortfolio","ProjectPortfolioCreated Message","ProjectPortfolioUpdated Message","ProjectResource","ProjectResourceCreated Message","ProjectResourceUpdated Message","Relationship","RelationshipCreated Message","RelationshipUpdated Message","Resource","ResourceCreated Message","ResourceUpdated Message","ResourceAssignment","ResourceAssignmentCreated Message","ResourceAssignmentUpdated Message","ResourceCodeAssignment","ResourceCodeAssignmentCreated Message","ResourceCodeAssignmentUpdated Message","ResourceRate","ResourceRateCreated Message","ResourceRateUpdated Message","ResourceRole","ResourceRoleCreated Message","ResourceRoleUpdated Message","ResouceTeam","ResourceTeamCreated Message","ResourceTeamUpdated Message","Risk","RiskCreated Message","RiskUpdated Message","RiskCategory","RiskCategoryCreated Message","RiskCategoryUpdated Message","RiskImpact","RiskImpactCreated Message","RiskImpactUpdated Message","RiskMatrix","RiskMatrixCreated Message","RiskMatrixUpdated Message","RiskMatrixScore","RiskMatrixScoreCreated Message","RiskMatrixScoreUpdated Message","RiskMatrixThreshold","RiskMatrixThresholdCreated Message","RiskMatrixThresholdUpdated Message","RiskResponseAction","RiskResponseActionCreated Message","RiskResponseActionUpdated Message","RiskResponseActionImpact","RiskResponseActionImpactCreated Message","RiskResponseActionImpactUpdated Message","RiskResponsePlan","RiskResponsePlanCreated Message","RiskResponsePlanUpdated Message","RiskThreshold","RiskThresholdCreated Message","RiskThresholdUpdated Message","RiskThresholdLevel","RiskThresholdLevelCreated Message","RiskThresholdLevelUpdated Message","Role","RoleCreated Message","RoleUpdated Message","RoleRate","RoleRateCreated Message","RoleRateUpdated Message","RoleTeam","RoleTeamCreated Message","RoleTeamUpdated Message","Timesheet","Not Applicable","TimesheetUpdated Message","UDFValue","UDFValueCreated Message","UDFValueUpdated Message","User","UserCreated Message","UserUpdated Message","UserOBS","UserOBSCreated Message","UserOBSUpdated Message","WBS","WBSCreated Message","WBSUpdated Message","Business Object Events","38427.htm");
Page[7]=new Array("Sample ActivityCreated Message: When an activity is created, the system sends an ActivityCreated message similar to the following message:","&lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot;?&gt;","&lt;MessagingObjects xmlns=&quot;http://xmlns.oracle.com/Primavera/P6/V8.2/Common/Event&quot; xmlns:xsi=&quot;http://www.w3.org/2001/XMLSchema-instance&quot;&gt;","  &lt;ActivityCreated&gt;","   &lt;Id&gt;Auto-1&lt;/Id&gt;","   &lt;ObjectId&gt;125500&lt;/ObjectId&gt;","   &lt;ProjectObjectId&gt;11840&lt;/ProjectObjectId&gt;","   &lt;WBSObjectId&gt;36320&lt;/WBSObjectId&gt;","  &lt;/ActivityCreated&gt;","&lt;/MessagingObjects&gt;","Sample ActivityUpdated Message: When an activity is updated, the system sends an ActivityUpdated message similar to the following message:","&lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot;?&gt;","&lt;MessagingObjects xmlns=&quot;http://xmlns.oracle.com/Primavera/P6/V8.2/Common/Event&quot; xmlns:xsi=&quot;http://www.w3.org/2001/XMLSchema-instance&quot;&gt;","  &lt;ActivityUpdated&gt;","    &lt;Id&gt;Auto-1&lt;/Id&gt;","    &lt;Name&gt;t2&lt;/Name&gt;","    &lt;ObjectId&gt;125500&lt;/ObjectId&gt;","    &lt;ProjectObjectId&gt;11840&lt;/ProjectObjectId&gt;","    &lt;WBSObjectId&gt;36320&lt;/WBSObjectId&gt;","    &lt;NewValues&gt;","      &lt;Name&gt;t2&lt;/Name&gt;","    &lt;/NewValues&gt;","    &lt;OldValues&gt;","      &lt;Name&gt;Auto-1&lt;/Name&gt;","    &lt;/OldValues&gt;","  &lt;/ActivityUpdated&gt;","&lt;/MessagingObjects&gt;","Sample Business Object Event Message","38429.htm");
Page[8]=new Array("Special operation events are triggered when the operations listed below complete. The special operation event messages contain operation-specific fields that are included with the message depending on which operation triggered the event message. For additional information relating to the messages, refer to the reference section of this document or the p6events.xsd schema file that is shipped on P6 media.","JobService: Occurs when the JobService completes. The event message includes a status element that indicates whether the operation completed successfully or not.","Publication Service: Occurs when the specified Publish service completes. The event message includes a status element that indicates whether the operation completed successfully or not.","API: Occurs after an XML file has been imported regardless of success or failure of the import.","Content Repository: Occurs when a document has been successfully checked into the content repository, or when a folder or document has been successfully added to the repository.","Stored Procedure: Occurs when the stored procedure completes successfully.","Special Operation Type","Operation","Message","Job Service","ApplyActuals","ApplyActualsInvoked Message","Job Service","CopyProject","CopyProjectInvoked Message","Job Service","CopyorCreateBaseline","CopyBaselineInvoked Method or CreateBaselineInvoked Message","Job Service","Export","ExportInvoked Message","Job Service","GlobalSearchandReplace","GlobalSearchandReplaceInvoked Message","Job Service","Import","ImportInvoked Message","Job Service","Level","LevelInvoked Message","Job Service","PublishAuditdata","PublishAuditdataInvoked Message","Job Service","RecalculateAssignmentCosts","RecalculateAssignmentCostsInvoked Message","Job Service","Schedule","ScheduleInvoked Message","Job Service","StorePeriodPerformance","StorePeriodPerformanceInvoked Message","Job Service","Summarize","SummarizeInvoked Message","Job Service","Updatebaseline","UpdatebaselineInvoked Message","Publication Service","PublishProject","PublishProjectInvoked Message","Publication Service","PublishEnterpriseData","PublishEnterpriseDataInvoked Message","Publication Service","PublishSecurity","PublishSecurityInvoked Message","Publication Service","PublishEnterpriseSummaries","PublishEnterpriseSummariesInvoked Message","Publication Service","PublishResourceManagement","PublishResourceManagementInvoked Message","Publication Service","PublishResourceRoleAssignmentSpread","PublishResourceRoleAssignmentSpreadInvoked Message","API","XML Import","XMLImportInvoked Message","Content Repository","AddDocument","ContentRepositoryDocumentAdded Message","Content Repository","AddFolder","ContentRepositoryFolderAdded Message","Content Repository","CheckIn","ContentRepositoryDocumentCheckedIn Message","Stored Procedure","ConvertProjectToBaseline","ConvertProjectToBaselineInvoked Message","Stored Procedure","CreateProjectFromTemplate","CreateProjectFromTemplateInvoked Message","Stored Procedure","CreateTemplateFromProject","CreateTemplatefromProjectInvoked Message","Stored Procedure","RestoreBaselineProject","RestoreBaselineProjectInvoked Message","Special Operation Events","38430.htm");
Page[9]=new Array("Using JMS messages properties, you can select event messages that are received for P6 based on the following message properties:","Type","Group","Name","Operation","Property Name","Possible Property Values","Type","Business Objects","Special Operations","Group","For business object events:  Activity, EPS...","For special operations events:  Job Service, API...","Name","For business object events:  ","Activity: Activity, ActivityCodeAssignment, ActivityExpense, ActivityNote, ActivityOwner, ActivityStep, Relationship, ResourceAssignment","EPS: EPS EPSBugetChangeLog, EPSFunding, EPSNote","Global: Calendar, Timesheet, User, UserOBS","Project: BaselineProject, Project, ProjectBudgetChangeLog, ProjectCodeAssignment, ProjectFunding, ProjectIssue, ProjectNote, ProjectPortfolio, ProjectResource, WBS","Resouce: Resource, RsourceCodeAssignment, ResourceRate, ResourceRole, ResourceTeam, Role, RoleRate, RoleTeam","Risk: ActivityRisk, Risk, RiskCategory, RiskImpact, RiskMatrix, RiskMatrixScore, RiskMatrixThreshold, RiskResponseAction, RiskResponseActionImpact, RiskResponsePlan, RiskThreshold, RiskThresholdLevel","UDF: UDF","For special operations events:  Apply Actuals, Schedule...","Job Service: Apply Actuals, Schedule, Store Period Performance, Summarize, Level, Recalculate Assignment Costs","Publication Service: Publish Project, Publish Enterprise Data, Publish Enterprose Summaries, Publish Resource Management, Publish Security","API: XML Import","Content Repository: Add Document, Add Folder, Check In","Stored Procedures: Copy Project, Copy Project As Baseline, Create project From Template, Create Copy As Template, Copy Baseline Project, Restore Baseline Project, Convert project to Baseline","Operation (only for business object events)","Created","Updated","JMS Message Properties Support","50138.htm");
Page[10]=new Array("A message similar to the following is triggered by the ScheduledInvoked event:","&lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot; standalone=&quot;no&quot;?&gt;","&lt;MessagingObjects xmlns=&quot;http://xmlns.oracle.com/Primavera/P6/V8.2/Common/Event&quot; xmlns:xsi=&quot;http://www.w3.org/2001/XMLSchema-instance&quot;&gt;","  &lt;ScheduleInvoked&gt;","   &lt;DataDate&gt;2015-01-03T08:00:00&lt;/DataDate&gt;","   &lt;Project&gt;","    &lt;Id&gt;Auto-Testproj2&lt;/Id&gt;","    &lt;Name&gt;Auto-Testproj2&lt;/Name&gt;","    &lt;ObjectId&gt;1001&lt;/ObjectId&gt;","   &lt;/Project&gt;","   &lt;Status&gt;Completed&lt;/Status&gt;","  &lt;/ScheduleInvoked&gt;","&lt;/MessagingObjects&gt;","Sample Special Operation Event Message","38434.htm");
Page[11]=new Array("Field","Type","Description","ActivityCodeObjectId","int","The unique ID of the associated activity code.","ActivityCodeTypeObjectId","int","The unique ID of the parent activity code type.","ActivityObjectId","int","The unique ID of the activity to which the activity code is assigned.","ProjectObjectId","int","The unique ID of the associated project.","ActivityCodeAssignmentCreated Message","34223.htm");
Page[12]=new Array("Field","Type","Description","ActivityCodeObjectId","int","The unique ID of the associated activity code.","ActivityCodeTypeObjectId","int","The unique ID of the parent activity code type.","ActivityObjectId","int","The unique ID of the activity to which the activity code is assigned.","ProjectObjectId","int","The unique ID of the associated project.","NewValues","ActivityCodeAssignmentType","Refer to the entries in the ActivityCodeAssignmentType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","ActivityCodeAssignmentType","Refer to the entries in the ActivityCodeAssignmentType Table below. ","Additional information can be found in the p6events.xsd schema.","The old values of Physical and writable fields that have changed.","ActivityCodeAssignmentType Table","Type: ActivityCodeAssignmentType","Elements","Type","ActivityCodeObjectId","int","ActivityObjectId","int","ActivityCodeAssignmentUpdated Message","34224.htm");
Page[13]=new Array("Field","Type","Description","Id","string","The short ID that uniquely identifies the activity within the project.","Name","string","The name of the activity. The activity name does not have to be unique.","ObjectId","int","The unique ID generated by the system.","ProjectObjectId","int","The unique ID of the associated project.","WBSObjectId","int","The unique ID of the WBS for the activity.","ActivityCreated Message","34221.htm");
Page[14]=new Array("Field","Type","Description","Id","string","The short ID that uniquely identifies the activity within the project.","Name","string","The name of the activity. The activity name does not have to be unique.","ObjectId","int","The unique ID generated by the system.","ProjectObjectId","int","The unique ID of the associated project.","WBSObjectId","int","The unique ID of the WBS for the activity.","NewValues","ActivityType","Refer to the entries in the ActivityType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","ActivityType","Refer to the entries in the ActivityType Table below. ","Additional information can be found in the p6events.xsd schema.&nbsp;&nbsp;","The old values of Physical and writable fields that have changed.","ActivityType Table","Type: ActivityType","Elements","Type","ActualFinishDate","dateTime","ActualLaborUnits","double","ActualNonLaborUnits","double","ActualStartDate","dateTime","ActualThisPeriodLaborUnits","double","ActualThisPeriodNonLaborUnits","double","AtCompletionLaborUnits","double","AtCompletionNonLaborUnits","double","AutoComputeActuals","boolean","CalendarObjectId","int","CBSCode","string","DBPhysicalPercentComplete","double","DurationType","string<br />restricted to <br />'Fixed Units/Time'<br />'Fixed Duration and Units/Time'<br />'Fixed Units'<br />'Fixed Duration and Units'<br />","ExpectedFinishDate","dateTime","Id","string","IsNewFeedback","boolean","IsStarred","boolean","LevelingPriority","string<br />restricted to <br />'Top'<br />'High'<br />'Normal'<br />'Low'<br />'Lowest'<br />","LocationObjectId","int","Name","string","ObjectId","int","PercentCompleteType","string<br />restricted to <br />'Physical'<br />'Duration'<br />'Units'<br />","PlannedDuration","double","PlannedFinishDate","dateTime","PlannedLaborUnits","double","PlannedNonLaborUnits","double","PlannedStartDate","dateTime","PrimaryConstraintDate","dateTime","PrimaryConstraintType","string<br />restricted to <br />'Start On'<br />'Start On or Before'<br />'Start On or After'<br />'Finish On'<br />'Finish On or Before'<br />'Finish On or After'<br />'As Late As Possible'<br />'Mandatory Start'<br />'Mandatory Finish'<br />","PrimaryResourceObjectId","int","ProjectObjectId","int","RemainingDuration","double","RemainingEarlyFinishDate","dateTime","RemainingEarlyStartDate","dateTime","RemainingLaborUnits","double","RemainingLateFinishDate","dateTime","RemainingLateStartDate","dateTime","RemainingNonLaborUnits","double","ResumeDate","dateTime","ReviewRequired","boolean","ReviewStatus","string<br />restricted to <br />'OK'<br />'For Review'<br />'Rejected'<br />","SecondaryConstraintDate","dateTime","SecondaryConstraintType","string<br />restricted to <br />'Start On'<br />'Start On or Before'<br />'Start On or After'<br />'Finish On'<br />'Finish On or Before'<br />'Finish On or After'<br />'As Late As Possible'<br />'Mandatory Start'<br />'Mandatory Finish'<br />","Status","string<br />restricted to <br />'Not Started'<br />'In Progress'<br />'Completed'<br />","SuspendDate","dateTime","Type","string<br />restricted to <br />'Task Dependent'<br />'Resource Dependent'<br />'Level of Effort'<br />'Start Milestone'<br />'Finish Milestone'<br />'WBS Summary'<br />","WBSObjectId","int","ActivityUpdated Message","34222.htm");
Page[15]=new Array("Field","Type","Description","ActivityObjectId","int","The unique ID of the activity to which the project expense is linked. Every project expense is associated with one activity in the project.","CostAccountObjectId","int","The unique ID of the cost account associated with the project expense.","ExpenseCategoryObjectId","int","The unique ID of the expense category for the project expense.","ExpenseItem","string","The name of the project expense.","ObjectId","int","The unique ID generated by the system.","ProjectObjectId","int","The unique ID of the associated project.","ActivityExpenseCreated Message","34225.htm");
Page[16]=new Array("Field","Type","Description","ActivityObjectId","int","The unique ID of the activity to which the project expense is linked. Every project expense is associated with one activity in the project.","CostAccountObjectId","int","The unique ID of the cost account associated with the project expense.","ExpenseCategoryObjectId","int","The unique ID of the expense category for the project expense.","ExpenseItem","string","The name of the project expense.","ObjectId","int","The unique ID generated by the system.","ProjectObjectId","int","The unique ID of the associated project.","NewValues","ActivityExpenseType<br /><br />Refer to the entries in the ActivityExpenseType Table below.","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","ActivityExpenseType<br /><br />Refer to the entries in the ActivityExpenseType Table below.","Additional information can be found in the p6events.xsd schema.","The old values of Physical and writable fields that have changed.","ActivityExpenseType Table","Type: ActivityExpenseType","Elements","Type","AccrualType","string<br />restricted to <br />'Start of Activity'<br />'End of Activity'<br />'Uniform Over Activity'<br />","ActivityObjectId","int","ActualCost","double","AutoComputeActuals","boolean","CostAccountObjectId","int","DocumentNumber","string","ExpenseCategoryObjectId","int","ExpenseItem","string","ObjectId","int","PlannedCost","double","PlannedUnits","double","PricePerUnit","double","RemainingCost","double","UnitOfMeasure","string","Vendor","string","ActivityExpenseUpdated Message","34226.htm");
Page[17]=new Array("Field","Type","Description","ActivityObjectId","int","The unique ID of the activity to which the activity note is assigned.","NotebookTopicObjectId","int","The unique ID of the associated notebook topic.","ObjectId","int","The unique ID generated by the system.","ActivityNoteCreated Message","34227.htm");
Page[18]=new Array("Field","Type","Description","ActivityObjectId","int","The unique ID of the activity to which the activity note is assigned.","NotebookTopicObjectId","int","The unique ID of the associated notebook topic.","ObjectId","int","The unique ID generated by the system.","NewValues","ActivityNoteType","Refer to the entries in the ActivityNoteType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","ActivityNoteType","Refer to the entries in the ActivityNoteType Table below. ","Additional information can be found in the p6events.xsd schema.&nbsp;&nbsp;","The old values of Physical and writable fields that have changed.","ActivityNoteType Table","Type: ActivityNoteType","Elements","Type","ActivityObjectId","int","NotebookTopicObjectId","int","ObjectId","int","ActivityNoteUpdated Message","34228.htm");
Page[19]=new Array("Field","Type","Description","ActivityObjectId","int","The unique ID of the associated activity.","ProjectObjectId","int","The unique ID of the associated project.","UserObjectId","int","The unique ID of the associated user.","ActivityOwnerCreated Message","34229.htm");
Page[20]=new Array("Field","Type","Description","ActivityObjectId","int","The unique ID of the associated activity.","ProjectObjectId","int","The unique ID of the associated project.","UserObjectId","int","The unique ID of the associated user.","NewValues","ActivityOwnerType","Refer to the entries in the ActivityOwnerType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","ActivityOwnerType","Refer to the entries in the ActivityOwnerType Table below. ","Additional information can be found in the p6events.xsd schema.","The old values of Physical and writable fields that have changed.","ActivityOwnerType Table","Type: ActivityOwnerType","Elements","Type","ActivityObjectId","int","IsActivityFlagged","boolean","UserObjectId","int","ActivityOwnerUpdated Message","34230.htm");
Page[21]=new Array("Field","Type","Description","ActivityObjectId","int","The unique ID of the activity to which the risk is assigned.","ProjectObjectId","int","The unique ID of the associated project.","RiskObjectId","int","The unique ID of the associated risk.","ActivityRiskCreated Message","35629.htm");
Page[22]=new Array("Field","Type","Description","ActivityObjectId","int","The unique ID of the activity to which the risk is assigned.","ProjectObjectId","int","The unique ID of the associated project.","RiskObjectId","int","The unique ID of the associated risk.","NewValues","ActivityRiskType","Refer to the entries in the ActivityRiskType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","ActivityRiskType","Refer to the entries in the ActivityRiskType Table below. ","Additional information can be found in the p6events.xsd schema.","The old values of Physical and writable fields that have changed.","ActivityRiskType Table","Type: ActivityRiskType","Elements","Type","ActivityObjectId","int","RiskObjectId","int","ActivityRiskUpdated Message","35630.htm");
Page[23]=new Array("Field","Type","Description","ActivityObjectId","int","The unique ID of the activity to which the steps are assigned.","Name","string","The name of the activity step.","ObjectId","int","The unique ID generated by the system.","ProjectObjectId","int","The unique ID of the associated project.","ActivityStepCreated Message","34231.htm");
Page[24]=new Array("Field","Type","Description","ActivityObjectId","int","The unique ID of the activity to which the steps are assigned.","Name","string","The name of the activity step.","ObjectId","int","The unique ID generated by the system.","ProjectObjectId","int","The unique ID of the associated project.","NewValues","ActivityStepType","Refer to the entries in the ActivityStepType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","ActivityStepType","Refer to the entries in the ActivityStepType Table below. ","Additional information can be found in the p6events.xsd schema.","The old values of Physical and writable fields that have changed.","ActivityStepType Table","Type: ActivityStepType","Elements","Type","ActivityObjectId","int","IsCompleted","boolean","Name","string","ObjectId","int","PercentComplete","double","Weight","double","ActivityStepUpdated Message","34232.htm");
Page[25]=new Array("Field","Type","Description","Id","string","The short code assigned to each WBS element for identification. Each WBS element is uniquely identified by concatenating its own code together with its parents' codes.","Name","string","The name of the baseline project.","ObjectId","int","The unique ID generated by the system.","BaselineProjectCreated Message","34235.htm");
Page[26]=new Array("Field","Type","Description","Id","string","The short code assigned to each WBS element for identification. Each WBS element is uniquely identified by concatenating its own code together with its parents' codes.","Name","string","The name of the baseline project.","ObjectId","int","The unique ID generated by the system.","NewValues","BaselineProjectType","Refer to the entries in the BaselineProjectType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","BaselineProjectType","Refer to the entries in the BaselineProjectType Table below. ","Additional information can be found in the p6events.xsd schema.<br />","The old values of Physical and writable fields that have changed.","BaselineProjectType Table ","Type: BaselineProjectType","Elements","Type","ActivityDefaultActivityType","string<br />restricted to <br />'Task Dependent'<br />'Resource Dependent'<br />'Level of Effort'<br />'Start Milestone'<br />'Finish Milestone'<br />'WBS Summary'<br />","ActivityDefaultCalendarObjectId","int","ActivityDefaultCostAccountObjectId","int","ActivityDefaultDurationType","string<br />restricted to <br />'Fixed Units/Time'<br />'Fixed Duration and Units/Time'<br />'Fixed Units'<br />'Fixed Duration and Units'<br />","ActivityDefaultPercentCompleteType","string<br />restricted to <br />'Physical'<br />'Duration'<br />'Units'<br />","ActivityDefaultPricePerUnit","double","ActivityIdBasedOnSelectedActivity","boolean","ActivityIdIncrement","int","ActivityIdPrefix","string","ActivityIdSuffix","int","ActivityPercentCompleteBasedOnActivitySteps","boolean","AddActualToRemaining","boolean","AddedBy","string","AllowStatusReview","boolean","AnnualDiscountRate","double","AnticipatedFinishDate","dateTime","AnticipatedStartDate","dateTime","AssignmentDefaultDrivingFlag","boolean","AssignmentDefaultRateType","string<br />restricted to <br />'Price / Unit'<br />'Price / Unit 2'<br />'Price / Unit 3'<br />'Price / Unit 4'<br />'Price / Unit 5'<br />","BaselineTypeObjectId","int","CostQuantityRecalculateFlag","boolean","CriticalActivityFloatLimit","double","CriticalActivityPathType","string<br />restricted to <br />'Critical Float'<br />'Longest Path'<br />","DateAdded","dateTime","DefaultPriceTimeUnits","string<br />restricted to <br />'Hour'<br />'Day'<br />'Week'<br />'Month'<br />'Year'<br />'Days Hours'<br />'Hours Minutes'<br />","Description","string","DiscountApplicationPeriod","string<br />restricted to <br />'Month'<br />'Quarter'<br />'Year'<br />","EnablePublication","boolean","EnableSummarization","boolean","FiscalYearStartMonth","int","HistoryInterval","string<br />restricted to <br />'Month'<br />'Week'<br />'Quarter'<br />'Year'<br />'Financial Period'<br />","HistoryLevel","string<br />restricted to <br />'None'<br />'Project'<br />'WBS'<br />'Activity'","Id","string","IndependentETCLaborUnits","double","IndependentETCTotalCost","double","LastBaselineUpdateDate","dateTime","LastFinancialPeriodObjectId","int","LastUpdateBaselineOptions","string","LevelingPriority","int","LinkActualToActualThisPeriod","boolean","LinkPercentCompleteWithActual","boolean","LinkPlannedAndAtCompletionFlag","boolean","LocationObjectId","int","MustFinishByDate","dateTime","Name","string","OBSObjectId","int","ObjectId","int","OriginalBudget","double","OwnerResourceObjectId","int","ParentEPSObjectId","int","PlannedStartDate","dateTime","PrimaryResourcesCanMarkActivitiesAsCompleted","boolean","ProjectForecastStartDate","dateTime","PublicationPriority","int","ResetPlannedToRemainingFlag","boolean","ResourceCanBeAssignedToSameActivityMoreThanOnce","boolean","ResourcesCanAssignThemselvesToActivities","boolean","ResourcesCanEditAssignmentPercentComplete","boolean","RiskMatrixObjectId","int","ScheduledFinishDate","dateTime","Status","string<br />restricted to <br />'Planned'<br />'Active'<br />'Inactive'<br />'What-If'<br />'Requested'<br />'Template'<br />","StatusReviewerObjectId","int","StrategicPriority","int","WBSCodeSeparator","string","WebSiteRootDirectory","string","WebSiteURL","string","BaselineProjectUpdated Message","34236.htm");
Page[27]=new Array("Field","Type","Description","Name","string","The name of the calendar.","ObjectId","int","The unique ID generated by the system.","ProjectObjectId","int","The unique ID of the associated project.","Type","string<br />restricted to <br />'Global'<br />'Project'<br />'Resource'<br />","The calendar type - either 'Global', 'Resource', or 'Project'. 'Global' calendars can be assigned to projects and resources. 'Resource' calendars can be assigned only to resources. 'Project' calendars are specific to projects.","CalendarCreated Message","45505.htm");
Page[28]=new Array("Field","Type","Description","Name","string","The name of the calendar.","ObjectId","int","The unique ID generated by the system.","ProjectObjectId","int","The unique ID of the associated project.","Type","string<br />restricted to <br />'Global'<br />'Project'<br />'Resource'<br />","The calendar type - either 'Global', 'Resource', or 'Project'. 'Global' calendars can be assigned to projects and resources. 'Resource' calendars can be assigned only to resources. 'Project' calendars are specific to projects.","NewValues","CalendarType","Refer to the entries in the CalendarType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","CalendarType","Refer to the entries in the CalendarType Table below. ","Additional information can be found in the p6events.xsd schema.","The old values of Physical and writable fields that have changed.","CalendarType Table","Type: CalendarType","Elements","Type","BaseCalendarObjectId","int","HoursPerDay","double","HoursPerMonth","double","HoursPerWeek","double","HoursPerYear","double","IsDefault","boolean","IsPersonal","boolean","Name","string","ObjectId","int","ProjectObjectId","int","Type","string<br />restricted to <br />'Global'<br />'Project'<br />'Resource'<br />","CalendarData","string","CalendarUpdated Message","45506.htm");
Page[29]=new Array("Field","Type","Description","ChangeNumber","string","The change number that is automatically incremented according to when changes are added. This can be changed to any number.","EPSObjectId","int","The unique ID of the EPS element to which the budget change log applies.","ObjectId","int","The unique ID generated by the system.","EPSBudgetChangeLogCreated Message","34241.htm");
Page[30]=new Array("Field","Type","Description","ChangeNumber","string","The change number that is automatically incremented according to when changes are added. This can be changed to any number.","EPSObjectId","int","The unique ID of the EPS element to which the budget change log applies.","ObjectId","int","The unique ID generated by the system.","NewValues","EPSBudgetChangeLogType","Refer to the entries in the EPSBudgetChangeLogType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","EPSBudgetChangeLogType","Refer to the entries in the EPSBudgetChangeLogType Table below. ","Additional information can be found in the p6events.xsd schema.","The old values of Physical and writable fields that have changed.","EPSBudgetChangeLogType Table","Type: EPSBudgetChangeLogType","Elements","Type","Amount","double","ChangeNumber","string","Date","dateTime","EPSObjectId","int","ObjectId","int","ProjectObjectId","int","Reason","string","Responsible","string","Status","string<br />restricted to <br />'Pending'<br />'Approved'<br />'Not Approved'<br />","EPSBudgetChangeLogUpdated Message","34242.htm");
Page[31]=new Array("Field","Type","Description","Id","string","The short code assigned to each EPS element for identification.","Name","string","The name of the EPS element.","ObjectId","int","The unique ID generated by the system.","EPSCreated Message","34491.htm");
Page[32]=new Array("Field","Type","Description","Id","string","The short code assigned to each EPS element for identification.","Name","string","The name of the EPS element.","ObjectId","int","The unique ID generated by the system.","NewValues","EPSType","Refer to the entries in the EPSType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","EPSType","Refer to the entries in the EPSType Table below. ","Additional information can be found in the p6events.xsd schema.","The old values of Physical and writable fields that have changed.","EPSType Table","Type: EPSType","Elements","Type","AnticipatedFinishDate","dateTime","AnticipatedStartDate","dateTime","Id","string","Name","string","OBSObjectId","int","ObjectId","int","OriginalBudget","double","ParentObjectId","int","EPSUpdated Message","34492.htm");
Page[33]=new Array("Field","Type","Description","EPSObjectId","int","The unique ID of the associated EPS for this EPS funding.","FundingSourceObjectId","int","The unique ID of the associated funding source for this EPS funding.","ObjectId","int","The unique ID generated by the system.","EPSFundingCreated Message","34243.htm");
Page[34]=new Array("Field","Type","Description","EPSObjectId","int","The unique ID of the associated EPS for this EPS funding.","FundingSourceObjectId","int","The unique ID of the associated funding source for this EPS funding.","ObjectId","int","The unique ID generated by the system.","NewValues","EPSFundingType","Refer to the entries in the EPSFundingType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","EPSFundingType","Refer to the entries in the EPSFundingType Table below. ","Additional information can be found in the p6events.xsd schema.&nbsp;&nbsp;","The old values of Physical and writable fields that have changed.","EPSFundingType Table","Type: EPSFundingType","Elements","Type","Amount","double","FundShare","double","FundingSourceObjectId","int","ObjectId","int","ProjectObjectId","int","EPSFundingUpdated Message","34244.htm");
Page[35]=new Array("Field","Type","Description","EPSObjectId","int","The unique ID of the associated EPS.","NotebookTopicObjectId","int","The unique ID of the associated notebook topic.","ObjectId","int","The unique ID generated by the system.","EPSNoteCreated Message","34245.htm");
Page[36]=new Array("Field","Type","Description","EPSObjectId","int","The unique ID of the associated EPS.","NotebookTopicObjectId","int","The unique ID of the associated notebook topic.","ObjectId","int","The unique ID generated by the system.","NewValues","EPSNoteType","Refer to the entries in the EPSNoteType below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","EPSNoteType","Refer to the entries in the EPSNoteType below. ","Additional information can be found in the p6events.xsd schema.&nbsp;&nbsp;","The old values of Physical and writable fields that have changed.","EPSNoteType Table","Type: EPSNoteType","Elements","Type","EPSObjectId","int","NotebookTopicObjectId","int","ObjectId","int","ProjectObjectId","int","EPSNoteUpdated Message","34246.htm");
Page[37]=new Array("Field","Type","Description","ChangeNumber","string","The change number that is automatically incremented according to when changes are added. This can be changed to any number.","ObjectId","int","The unique ID generated by the system.","ProjectObjectId","int","The unique ID of the associated project.","WBSObjectId","int","The unique ID of the WBS element to which the budget change log applies.","ProjectBudgetChangeLogCreated Message","34237.htm");
Page[38]=new Array("Field","Type","Description","ChangeNumber","string","The change number that is automatically incremented according to when changes are added. This can be changed to any number.","ObjectId","int","The unique ID generated by the system.","ProjectObjectId","int","The unique ID of the associated project.","WBSObjectId","int","The unique ID of the WBS element to which the budget change log applies.","NewValues","ProjectBudgetChangeLogType","Refer to the entries in the ProjectBudgetChangeLogType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","ProjectBudgetChangeLogType","Refer to the entries in the ProjectBudgetChangeLogType Table below. ","Additional information can be found in the p6events.xsd schema.","The old values of Physical and writable fields that have changed.","ProjectBudgetChangeLogType Table","Type: ProjectBudgetChangeLogType","Elements","Type","Amount","double","ChangeNumber","string","Date","dateTime","ObjectId","int","ProjectObjectId","int","Reason","string","Responsible","string","Status","string<br />restricted to <br />'Pending'<br />'Approved'<br />'Not Approved'<br />","WBSObjectId","int","ProjectBudgetChangeLogUpdated Message","34238.htm");
Page[39]=new Array("Field","Type","Description","ProjectCodeObjectId","int","The unique ID of the associated project code.","ProjectCodeTypeObjectId","int","The unique ID of the parent project code type.","ProjectObjectId","int","The unique ID of the project to which the project code is assigned.","ProjectCodeAssignmentCreated Message","34253.htm");
Page[40]=new Array("Field","Type","Description","ProjectCodeObjectId","int","The unique ID of the associated project code.","ProjectCodeTypeObjectId","int","The unique ID of the parent project code type.","ProjectObjectId","int","The unique ID of the project to which the project code is assigned.","NewValues","ProjectCodeAssignmentType","Refer to the entries in the ProjectCodeAssignmentType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","ProjectCodeAssignmentType","Refer to the entries in the ProjectCodeAssignmentType Table below. ","Additional information can be found in the p6events.xsd schema.","The old values of Physical and writable fields that have changed.","ProjectCodeAssignmentType Table","Type: ProjectCodeAssignmentType","Elements","Type","ProjectCodeObjectId","int","ProjectObjectId","int","ProjectCodeAssignmentUpdated Message","34254.htm");
Page[41]=new Array("Field","Type","Description","Id","string","The short code assigned to each Project element for identification. Each Project element is uniquely identified by this short code.","Name","string","The name of the Project element.","ObjectId","int","The unique ID generated by the system.","ProjectCreated Message","34247.htm");
Page[42]=new Array("Field","Type","Description","Id","string","The short code assigned to each Project element for identification. Each Project element is uniquely identified by this short code.","Name","string","The name of the Project element.","ObjectId","int","The unique ID generated by the system.","NewValues","ProjectType","Refer to the entries in the ProjectType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","ProjectType","Refer to the entries in the ProjectType Table below. ","Additional information can be found in the p6events.xsd schema.&nbsp;&nbsp;","The old values of Physical and writable fields that have changed.","ProjectType Table","Type: ProjectType","Elements","Type","ActivityDefaultActivityType","string<br />restricted to <br />'Task Dependent'<br />'Resource Dependent'<br />'Level of Effort'<br />'Start Milestone'<br />'Finish Milestone'<br />'WBS Summary'<br />","ActivityDefaultCalendarObjectId","int","ActivityDefaultCostAccountObjectId","int","ActivityDefaultDurationType","string<br />restricted to <br />'Fixed Units/Time'<br />'Fixed Duration and Units/Time'<br />'Fixed Units'<br />'Fixed Duration and Units'<br />","ActivityDefaultPercentCompleteType","string<br />restricted to <br />'Physical'<br />'Duration'<br />'Units'<br />","ActivityDefaultPricePerUnit","double","ActivityIdBasedOnSelectedActivity","boolean","ActivityIdIncrement","int","ActivityIdPrefix","string","ActivityIdSuffix","int","ActivityPercentCompleteBasedOnActivitySteps","boolean","AddActualToRemaining","boolean","AddedBy","string","AllowNegativeActualUnitsFlag","boolean","AllowStatusReview","boolean","AnnualDiscountRate","double","AnticipatedFinishDate","dateTime","AnticipatedStartDate","dateTime","AssignmentDefaultDrivingFlag","boolean","AssignmentDefaultRateType","string<br />restricted to <br />'Price / Unit'<br />'Price / Unit 2'<br />'Price / Unit 3'<br />'Price / Unit 4'<br />'Price / Unit 5'<br />","CheckOutStatus","boolean","ContractManagementGroupName","string","ContractManagementProjectName","string","CostQuantityRecalculateFlag","boolean","CriticalActivityFloatLimit","double","CriticalActivityPathType","string<br />restricted to <br />'Critical Float'<br />'Longest Path'<br />","CurrentBaselineProjectObjectId","int","DateAdded","dateTime","DefaultPriceTimeUnits","string<br />restricted to <br />'Hour'<br />'Day'<br />'Week'<br />'Month'<br />'Year'<br />'Days Hours'<br />'Hours Minutes'<br />","Description","string","DiscountApplicationPeriod","string<br />restricted to <br />'Month'<br />'Quarter'<br />'Year'<br />","EarnedValueComputeType","string<br />restricted to <br />'Activity Percent Complete'<br />'0 / 100'<br />'50 / 50'<br />'Custom Percent Complete'<br />'WBS Milestones Percent Complete'<br />'Activity Percent Complete Using Resource Curves'<br />","EarnedValueETCComputeType","string<br />restricted to <br />'ETC = Remaining Cost for Activity'<br />'PF = 1'<br />'PF = Custom Value'<br />'PF = 1 / CPI'<br />'PF = 1 / (CPI * SPI)'<br />","EarnedValueETCUserValue","double","EarnedValueUserPercent","double","EnablePublication","boolean","EnableSummarization","boolean","FiscalYearStartMonth","int","HistoryInterval","string<br />restricted to <br />'Month'<br />'Week'<br />'Quarter'<br />'Year'<br />'Financial Period'<br />","HistoryLevel","string<br />restricted to <br />'None'<br />'Project'<br />'WBS'<br />'Activity'<br />","Id","string","IndependentETCLaborUnits","double","IndependentETCTotalCost","double","IntegratedType","string<br />restricted to <br />'ERP'<br />'Fusion'<br />'Gateway'","LastFinancialPeriodObjectId","int","LevelingPriority","int","LinkActualToActualThisPeriod","boolean","LinkPercentCompleteWithActual","boolean","LinkPlannedAndAtCompletionFlag","boolean","LocationObjectId","int","MustFinishByDate","dateTime","Name","string","OBSObjectId","int","ObjectId","int","OriginalBudget","double","OwnerResourceObjectId","int","ParentEPSObjectId","int","PlannedStartDate","dateTime","PrimaryResourcesCanMarkActivitiesAsCompleted","boolean","ProjectForecastStartDate","dateTime","PublicationPriority","int","ResetPlannedToRemainingFlag","boolean","ResourceCanBeAssignedToSameActivityMoreThanOnce","boolean","ResourcesCanAssignThemselvesToActivities","boolean","ResourcesCanEditAssignmentPercentComplete","boolean","ResourcesCanMarkAssignmentAsCompleted","boolean","ResourcesCanViewInactiveActivities","boolean","RiskMatrixObjectId","int","ScheduledFinishDate","dateTime","Status","string<br />restricted to <br />'Planned'<br />'Active'<br />'Inactive'<br />'What-If'<br />'Requested'<br />'Template'<br />","StatusReviewerObjectId","int","StrategicPriority","int","SummarizeToWBSLevel","int","SummarizedDataDate","dateTime","SummaryLevel","string<br />restricted to <br />'WBS Level'<br />'Assignment Level'<br />","UseProjectBaselineForEarnedValue","boolean","WBSCodeSeparator","string","WebSiteRootDirectory","string","WebSiteURL","string","ProjectUpdated Message","34248.htm");
Page[43]=new Array("Field","Type","Description","FundingSourceObjectId","int","The unique ID of the associated funding source for this project funding.","ObjectId","int","The unique ID generated by the system.","ProjectObjectId","int","The unique ID of the associated project source for this project funding.","ProjectFundingCreated Message","34249.htm");
Page[44]=new Array("Field","Type","Description","FundingSourceObjectId","int","The unique ID of the associated funding source for this project funding.","ObjectId","int","The unique ID generated by the system.","ProjectObjectId","int","The unique ID of the associated project source for this project funding.","NewValues","ProjectFundingType","Refer to the entries in the ProjectFundingType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","ProjectFundingType","Refer to the entries in the ProjectFundingType Table below. ","Additional information can be found in the p6events.xsd schema.&nbsp;&nbsp;","The old values of Physical and writable fields that have changed.","ProjectFundingType Table","Type: ProjectFundingType","Elements","Type","Amount","double","FundShare","double","FundingSourceObjectId","int","ObjectId","int","ProjectObjectId","int","ProjectFundingUpdated Message","34250.htm");
Page[45]=new Array("Field","Type","Description","ActivityObjectId","int","The unique ID of the activity to which the project issue applies.","Name","string","The name of the project issue. Issues which are automatically generated by the threshold monitor are named after the threshold parameter that triggered the project issue.","ObjectId","int","The unique ID generated by the system.","ProjectObjectId","int","The unique ID of the associated project.","WBSObjectId","int","The unique ID of the WBS to which the project issue applies. If a parent WBS is selected, the project issue applies to all child elements as well. If the top WBS is selected, the project issue applies to the entire project.","ProjectIssueCreated Message","34251.htm");
Page[46]=new Array("Field","Type","Description","ActivityObjectId","int","The unique ID of the activity to which the project issue applies.","Name","string","The name of the project issue. Issues which are automatically generated by the threshold monitor are named after the threshold parameter that triggered the project issue.","ObjectId","int","The unique ID generated by the system.","ProjectObjectId","int","The unique ID of the associated project.","WBSObjectId","int","The unique ID of the WBS to which the project issue applies. If a parent WBS is selected, the project issue applies to all child elements as well. If the top WBS is selected, the project issue applies to the entire project.","NewValues","ProjectIssueType","Refer to the entries in the ProjectIssueType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","ProjectIssueType","Refer to the entries in the ProjectIssueType Table below. ","Additional information can be found in the p6events.xsd schema.","The old values of Physical and writable fields that have changed.","ProjectIssueType Table","Type: ProjectIssueType","Elements","Type","ActivityObjectId","int","ActualValue","double","DateIdentified","dateTime","IdentifiedBy","string","LowerThreshold","double","Name","string","OBSObjectId","int","ObjectId","int","Priority","string<br />restricted to <br />'Top'<br />'High'<br />'Normal'<br />'Low'<br />'Lowest'<br />","ProjectObjectId","int","ResolutionDate","dateTime","ResourceObjectId","int","Status","string<br />restricted to <br />'Open'<br />'On Hold'<br />'Closed'<br />","UpperThreshold","double","WBSObjectId","int","ProjectIssueUpdated Message","34252.htm");
Page[47]=new Array("Field","Type","Description","NotebookTopicObjectId","int","The unique ID of the associated notebook topic.","ObjectId","int","The unique ID generated by the system.","ProjectObjectId","int","The unique ID of the associated project.","WBSObjectId","int","The unique ID of the associated WBS.","ProjectNoteCreated Message","34275.htm");
Page[48]=new Array("Field","Type","Description","NotebookTopicObjectId","int","The unique ID of the associated notebook topic.","ObjectId","int","The unique ID generated by the system.","ProjectObjectId","int","The unique ID of the associated project.","WBSObjectId","int","The unique ID of the associated WBS.","NewValues","ProjectNoteType","Refer to the entries in the ProjectNoteType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","ProjectNoteType","Refer to the entries in the ProjectNoteType Table below. ","Additional information can be found in the p6events.xsd schema.","The old values of Physical and writable fields that have changed.","ProjectNoteType Table","Type: ProjectNoteType","Elements","Type","NotebookTopicObjectId","int","ObjectId","int","ProjectObjectId","int","WBSObjectId","int","ProjectNoteUpdated Message","34276.htm");
Page[49]=new Array("Field","Type","Description","Name","string","The name of the project portfolio.","ObjectId","int","The unique ID generated by the system.","UserObjectId","int","The unique ID of a specific user who has access to the selected project portfolio.","ProjectPortfolioCreated Message","34493.htm");
Page[50]=new Array("Field","Type","Description","Name","string","The name of the project portfolio.","ObjectId","int","The unique ID generated by the system.","UserObjectId","int","The unique ID of a specific user who has access to the selected project portfolio.","NewValues","ProjectPortfolioType","Refer to the entries in the ProjectPortfolioType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","ProjectPortfolioType","Refer to the entries in the ProjectPortfolioType Table below. ","Additional information can be found in the p6events.xsd schema.&nbsp;&nbsp;","The old values of Physical and writable fields that have changed.","ProjectPortfolioType Table","Type: ProjectPortfolioType","Elements","Type","Description","string","IncludeClosedProjects","boolean","IncludeWhatIfProjects","boolean","Name","string","ObjectId","int","UserObjectId","int","Projects","ProjectPortfolioUpdated Message","34494.htm");
Page[51]=new Array("Field","Type","Description","ObjectId","int","The unique ID generated by the system.","ProjectObjectId","int","The unique ID of the associated project.","ResourceObjectId","int","The unique ID of the associated resource.","RoleObjectId","int","The unique ID of the associated role.","WBSObjectId","int","The unique ID of the associated WBS.","ProjectResourceCreated Message","34277.htm");
Page[52]=new Array("Field","Type","Description","ObjectId","int","The unique ID generated by the system.","ProjectObjectId","int","The unique ID of the associated project.","ResourceObjectId","int","The unique ID of the associated resource.","RoleObjectId","int","The unique ID of the associated role.","WBSObjectId","int","The unique ID of the associated WBS.","NewValues","ProjectResourceType","Refer to the entries in the ProjectResourceType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","ProjectResourceType","Refer to the entries in the ProjectResourceType Table below. ","Additional information can be found in the p6events.xsd schema.&nbsp;&nbsp;","The old values of Physical and writable fields that have changed.","ProjectResourceType Table","Type: ProjectResourceType","Elements","Type","CommittedFlag","boolean","LifeOfProjectFlag","boolean","ObjectId","int","ProjectObjectId","int","ProjectResourceCategoryObjectId","int","ResourceObjectId","int","RoleObjectId","int","WBSObjectId","int","ProjectResourceUpdated Message","34278.htm");
Page[53]=new Array("Field","Type","Description","ObjectId","int","The unique ID generated by the system.","PredecessorActivityObjectId","int","The unique ID of the predecessor activity.","PredecessorProjectObjectId","int","The unique ID of the project that owns the predecessor activity.","SuccessorActivityObjectId","int","The unique ID of the successor activity.","SuccessorProjectObjectId","int","The unique ID of the project that owns the successor activity.","Type","string<br />restricted to <br />'Finish to Start'<br />'Finish to Finish'<br />'Start to Start'<br />'Start to Finish'<br />","The type of relationship: 'Finish to Start', 'Finish to Finish', 'Start to Start', or 'Start to Finish'.","RelationshipCreated Message","34239.htm");
Page[54]=new Array("Field","Type","Description","ObjectId","int","The unique ID generated by the system.","PredecessorActivityObjectId","int","The unique ID of the predecessor activity.","PredecessorProjectObjectId","int","The unique ID of the project that owns the predecessor activity.","SuccessorActivityObjectId","int","The unique ID of the successor activity.","SuccessorProjectObjectId","int","The unique ID of the project that owns the successor activity.","Type","string<br />restricted to <br />'Finish to Start'<br />'Finish to Finish'<br />'Start to Start'<br />'Start to Finish'<br />","The type of relationship: 'Finish to Start', 'Finish to Finish', 'Start to Start', or 'Start to Finish'.","NewValues","RelationshipType","Refer to the entries in the RelationshipType Table below.","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","RelationshipType","Refer to the entries in the RelationshipType Table below.","Additional information can be found in the p6events.xsd schema.","The old values of Physical and writable fields that have changed.","RelationshipType Table","Type: RelationshipType","Elements","Type","Lag","double","ObjectId","int","PredecessorActivityObjectId","int","PredecessorProjectObjectId","int","SuccessorActivityObjectId","int","SuccessorProjectObjectId","int","Type","string<br />restricted to <br />'Finish to Start'<br />'Finish to Finish'<br />'Start to Start'<br />'Start to Finish'<br />","RelationshipUpdated Message","34240.htm");
Page[55]=new Array("Field","Type","Description","ActivityObjectId","int","The unique ID of the activity to which the resource is assigned.","CostAccountObjectId","int","The unique ID of the cost account associated with this resource assignment.","ObjectId","int","The unique ID generated by the system.","ProjectObjectId","int","The unique ID of the associated project.","ResourceObjectId","int","The unique ID of the associated resource.","RoleObjectId","int","The unique ID of the role the resource is performing on this activity. A resource may be assigned to the same activity more than once, performing different roles. The project manager controls whether the same resource can be assigned to an activity more than once.","ResourceAssignmentCreated Message","34233.htm");
Page[56]=new Array("Field","Type","Description","ActivityObjectId","int","The unique ID of the activity to which the resource is assigned.","CostAccountObjectId","int","The unique ID of the cost account associated with this resource assignment.","ObjectId","int","The unique ID generated by the system.","ProjectObjectId","int","The unique ID of the associated project.","ResourceObjectId","int","The unique ID of the associated resource.","RoleObjectId","int","The unique ID of the role the resource is performing on this activity. A resource may be assigned to the same activity more than once, performing different roles. The project manager controls whether the same resource can be assigned to an activity more than once.","NewValues","ResourceAssignmentType","Refer to the entries in the ResourceAssignmentType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","ResourceAssignmentType","Refer to the entries in the ResourceAssignmentType Table below. ","Additional information can be found in the p6events.xsd schema.","The old values of Physical and writable fields that have changed.","ResourceAssignmentType Table","Type: ResourceAssignmentType","Elements","Type","ActivityObjectId","int","ActualCost","double","ActualCurve","string","ActualFinishDate","dateTime","ActualOvertimeCost","double","ActualOvertimeUnits","double","ActualRegularCost","double","ActualRegularUnits","double","ActualStartDate","dateTime","ActualThisPeriodCost","double","ActualThisPeriodUnits","double","ActualUnits","double","AtCompletionCost","double","AtCompletionUnits","double","CostAccountObjectId","int","DrivingActivityDatesFlag","boolean","IsActivityFlagged","boolean","IsCostUnitsLinked","boolean","ObjectId","int","OvertimeFactor","double","PendingPercentComplete","double","PendingRemainingUnits","double","PlannedCost","double","PlannedCurve","string","PlannedFinishDate","dateTime","PlannedLag","double","PlannedStartDate","dateTime","PlannedUnits","double","PlannedUnitsPerTime","double","Proficiency","string<br />restricted to <br />'1 - Master'<br />'2 - Expert'<br />'3 - Skilled'<br />'4 - Proficient'<br />'5 - Inexperienced'<br />","RateSource","string<br />restricted to <br />'Resource'<br />'Role'<br />'Override'<br />","RateType","string<br />restricted to <br />'Price / Unit'<br />'Price / Unit 2'<br />'Price / Unit 3'<br />'Price / Unit 4'<br />'Price / Unit 5'<br />","RemainingCost","double","RemainingCurve","string","RemainingFinishDate","dateTime","RemainingStartDate","dateTime","RemainingUnits","double","RemainingUnitsPerTime","double","ResourceCurveObjectId","int","ResourceObjectId","int","ResourceType","string<br />restricted to <br />'Labor'<br />'Nonlabor'<br />'Material'<br />","RoleObjectId","int","ResourceAssignmentUpdated Message","34234.htm");
Page[57]=new Array("Field","Type","Description","ResourceCodeObjectId","int","The unique ID of the associated resource code.","ResourceCodeTypeObjectId","int","The unique ID of the parent resource code type.","ResourceObjectId","int","The unique ID of the resource to which the resource code is assigned.","ResourceCodeAssignmentCreated Message","34261.htm");
Page[58]=new Array("Field","Type","Description","ResourceCodeObjectId","int","The unique ID of the associated resource code.","ResourceCodeTypeObjectId","int","The unique ID of the parent resource code type.","ResourceObjectId","int","The unique ID of the resource to which the resource code is assigned.","NewValues","ResourceCodeAssignmentType","Refer to the entries in the ResourceCodeAssignmentType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","ResourceCodeAssignmentType","Refer to the entries in the ResourceCodeAssignmentType Table below. ","Additional information can be found in the p6events.xsd schema.&nbsp;","The old values of Physical and writable fields that have changed.","ResourceCodeAssignmentType Table","Type: ResourceCodeAssignmentType","Elements","Type","ResourceCodeObjectId","int","ResourceObjectId","int","ResourceCodeAssignmentUpdated Message","34262.htm");
Page[59]=new Array("Field","Type","Description","Id","string","The short code that uniquely identifies the resource.","Name","string","The name of the resource.","ObjectId","int","The unique ID generated by the system.","ResourceCreated Message","34257.htm");
Page[60]=new Array("Field","Type","Description","Id","string","The short code that uniquely identifies the resource.","Name","string","The name of the resource.","ObjectId","int","The unique ID generated by the system.","NewValues","ResourceType","Refer to the entries in the ResourceType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","ResourceType","Refer to the entries in the ResourceType Table below. ","Additional information can be found in the p6events.xsd schema.","The old values of Physical and writable fields that have changed.","ResourceType Table","Type: ResourceType","Elements","Type","AutoComputeActuals","boolean","CalculateCostFromUnits","boolean","CalendarObjectId","int","CurrencyObjectId","int","DefaultUnitsPerTime","double","EmailAddress","string","EmployeeId","string","Id","string","IntegratedType","string<br />restricted to <br />'ERP'<br />'Fusion'<br />'Gateway'","IsActive","boolean","IsOverTimeAllowed","boolean","LocationObjectId","int","Name","string","ObjectId","int","OfficePhone","string","OtherPhone","string","OvertimeFactor","double","ParentObjectId","int","PrimaryRoleObjectId","int","ResourceType","string<br />restricted to <br />'Labor'<br />'Nonlabor'<br />'Material'<br />","ShiftObjectId","int","TimesheetApprovalManagerObjectId","int","Title","string","UnitOfMeasureObjectId","int","UseTimesheets","boolean","UserObjectId","int","ResourceUpdated Message","34258.htm");
Page[61]=new Array("Field","Type","Description","EffectiveDate","dateTime","The effective date for the resource price and maximum units per time.","ObjectId","int","The unique ID generated by the system.","ResourceObjectId","int","The unique ID of the associated resource.","ShiftPeriodObjectId","int","The unique ID of the associated shift.","ResourceRateCreated Message","34259.htm");
Page[62]=new Array("Field","Type","Description","EffectiveDate","dateTime","The effective date for the resource price and maximum units per time.","ObjectId","int","The unique ID generated by the system.","ResourceObjectId","int","The unique ID of the associated resource.","ShiftPeriodObjectId","int","The unique ID of the associated shift.","NewValues","ResourceRateType","Refer to the entries in the ResourceRateType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","ResourceRateType","Refer to the entries in the ResourceRateType Table below. ","Additional information can be found in the p6events.xsd schema.","The old values of Physical and writable fields that have changed.","ResourceRateType Table","Type: ResourceRateType","Elements","Type","EffectiveDate","dateTime","MaxUnitsPerTime","double","ObjectId","int","PricePerUnit","double","PricePerUnit2","double","PricePerUnit3","double","PricePerUnit4","double","PricePerUnit5","double","ResourceObjectId","int","ShiftPeriodObjectId","int","ResourceRateUpdated Message","34260.htm");
Page[63]=new Array("Field","Type","Description","ResourceObjectId","int","The unique ID of the associated resource.","RoleObjectId","int","The unique ID of the associated role.","ResourceRoleCreated Message","34263.htm");
Page[64]=new Array("Field","Type","Description","ResourceObjectId","int","The unique ID of the associated resource.","RoleObjectId","int","The unique ID of the associated role.","NewValues","ResourceRoleType","Refer to the entries in the ResourceRoleType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","ResourceRoleType","Refer to the entries in the ResourceRoleType Table below. ","Additional information can be found in the p6events.xsd schema.","The old values of Physical and writable fields that have changed.","ResourceRoleType Table","Type: ResourceRoleType","Elements","Type","Proficiency","string<br />restricted to <br />'1 - Master'<br />'2 - Expert'<br />'3 - Skilled'<br />'4 - Proficient'<br />'5 - Inexperienced'<br />","ResourceObjectId","int","RoleObjectId","int","ResourceRoleUpdated Message","34264.htm");
Page[65]=new Array("Field","Type","Description","Name","string","The name of the resource team.","ObjectId","int","The unique ID generated by the system.","UserObjectId","int","The unique ID of the associated user.","ResourceTeamCreated Message","34495.htm");
Page[66]=new Array("Field","Type","Description","Name","string","The name of the resource team.","ObjectId","int","The unique ID generated by the system.","UserObjectId","int","The unique ID of the associated user.","NewValues","ResourceTeamType","Refer to the entries in the ResourceTeamType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","ResourceTeamType","Refer to the entries in the ResourceTeamType Table below. ","Additional information can be found in the p6events.xsd schema.","The old values of Physical and writable fields that have changed.","ResourceTeamType Table","Type: ResourceTeamType","Elements","Type","Description","string","Name","string","ObjectId","int","UserObjectId","int","Resources","ResourceTeamUpdated Message","34496.htm");
Page[67]=new Array("Field","Type","Description","Name","string","The name of the risk category.","ObjectId","int","The unique ID generated by the system.","ParentObjectId","int","The unique ID of the parent risk type of this risk type in the hierarchy.","RiskCategoryCreated Message","35651.htm");
Page[68]=new Array("Field","Type","Description","Name","string","The name of the risk category.","ObjectId","int","The unique ID generated by the system.","ParentObjectId","int","The unique ID of the parent risk type of this risk type in the hierarchy.","NewValues","RiskCategoryType","Refer to the entries in the RiskCategoryType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","RiskCategoryType","Refer to the entries in the RiskCategoryType Table below. ","Additional information can be found in the p6events.xsd schema.&nbsp;","The old values of Physical and writable fields that have changed.","RiskCategoryType Table","Type: RiskCategoryType","Elements","Type","Name","string","ObjectId","int","ParentObjectId","int","RiskCategoryUpdated Message","35652.htm");
Page[69]=new Array("Field","Type","Description","Id","string","The ID of the Risk. Must be unique within a project.","IdentifiedByResourceObjectId","int","The unique ID of the resource that identified the risk.","IdentifiedDate","dateTime","The date this risk was identified.","ObjectId","int","The unique ID generated by the system.","ProjectObjectId","int","The unique ID of the associated project.","ResourceObjectId","int","The unique ID of the associated resource.","RiskCategoryObjectId","int","The unique ID of the category to which the Risk is assigned. e.g. Weather, Health, Legal etc. A Risk can only be associated with a single category.","RiskCreated Message","35631.htm");
Page[70]=new Array("Field","Type","Description","Id","string","The ID of the Risk. Must be unique within a project.","IdentifiedByResourceObjectId","int","The unique ID of the resource that identified the risk.","IdentifiedDate","dateTime","The date this risk was identified.","ObjectId","int","The unique ID generated by the system.","ProjectObjectId","int","The unique ID of the associated project.","ResourceObjectId","int","The unique ID of the associated resource.","RiskCategoryObjectId","int","The unique ID of the category to which the Risk is assigned. e.g. Weather, Health, Legal etc. A Risk can only be associated with a single category.","NewValues","RiskType","Refer to the entries in the RiskType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","RiskType","Refer to the entries in the RiskType Table below. ","Additional information can be found in the p6events.xsd schema.&nbsp;","The old values of Physical and writable fields that have changed.","RiskType Table","Type: RiskType","Elements","Type","Cause","string","Description","string","Effect","string","Id","string","IdentifiedByResourceObjectId","int","IdentifiedDate","dateTime","Name","string","Note","string","ObjectId","int","ProjectObjectId","int","ResourceObjectId","int","RiskCategoryObjectId","int","Status","string<br />restricted to <br />'Proposed'<br />'Open'<br />'Active'<br />'Rejected'<br />'Managed'<br />'Impacted'<br />","Type","string<br />restricted to <br />'Threat'<br />'Opportunity'<br />","RiskUpdated Message","35632.htm");
Page[71]=new Array("Field","Type","Description","ProjectObjectId","int","The unique ID of the associated project.","RiskObjectId","int","The unique ID of the associated risk.","RiskThresholdLevelObjectId","int","The unique ID of the associated Risk Threshold.","RiskThresholdObjectId","int","The unique ID of the associated Risk Threshold Type.","RiskImpactCreated Message","35633.htm");
Page[72]=new Array("Field","Type","Description","ProjectObjectId","int","The unique ID of the associated project.","RiskObjectId","int","The unique ID of the associated risk.","RiskThresholdLevelObjectId","int","The unique ID of the associated Risk Threshold.","RiskThresholdObjectId","int","The unique ID of the associated Risk Threshold Type.","NewValues","RiskImpactType","Refer to the entries in the RiskImpactType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","RiskImpactType","Refer to the entries in the RiskImpactType Table below. ","Additional information can be found in the p6events.xsd schema.","The old values of Physical and writable fields that have changed.","RiskImpactType Table","Type: RiskImpactType","Elements","Type","RiskObjectId","int","RiskThresholdLevelObjectId","int","RiskImpactUpdated Message","35634.htm");
Page[73]=new Array("Field","Type","Description","Name","string","The name of the risk matrix.","ObjectId","int","The unique ID generated by the system.","RiskMatrixCreated Message","45511.htm");
Page[74]=new Array("Field","Type","Description","Name","string","The name of the risk matrix.","ObjectId","int","The unique ID generated by the system.","NewValues","RiskMatrixType","Refer to the entries in the RiskMatrixType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","RiskMatrixType","Refer to the entries in the RiskMatrixType Table below. ","Additional information can be found in the p6events.xsd schema.&nbsp;","The old values of Physical and writable fields that have changed.","RiskMatrixType Table","Type: RiskMatrixType","Elements","Type","Description","string","Name","string","ObjectId","int","RiskScoringMethod","string<br />restricted to <br />'Highest'<br />'Average of Impacts'<br />'Average of Individual Scores'<br />","RiskMatrixUpdated Message","45512.htm");
Page[75]=new Array("Field","Type","Description","ObjectId","int","The unique ID generated by the system.","RiskMatrixObjectId","int","The unique ID of the associated Risk Matrix.","RiskMatrixScoreCreated Message","35635.htm");
Page[76]=new Array("Field","Type","Description","ObjectId","int","The unique ID generated by the system.","RiskMatrixObjectId","int","The unique ID of the associated Risk Matrix.","NewValues","RiskMatrixScoreType","Refer to the entries in the RiskMatrixScoreType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","RiskMatrixScoreType","Refer to the entries in the RiskMatrixScoreType Table below. ","Additional information can be found in the p6events.xsd schema.&nbsp;","The old values of Physical and writable fields that have changed.","RiskMatrixScoreType Table","Type: RiskMatrixScoreType","Elements","Type","ObjectId","int","ProbabilityThresholdLevel","int","RiskMatrixObjectId","int","Severity1","int","Severity1Label","string","Severity2","int","Severity2Label","string","Severity3","int","Severity3Label","string","Severity4","int","Severity4Label","string","Severity5","int","Severity5Label","string","Severity6","int","Severity6Label","string","Severity7","int","Severity7Label","string","Severity8","int","Severity8Label","string","Severity9","int","Severity9Label","string","RiskMatrixScoreUpdated Message","35636.htm");
Page[77]=new Array("Field","Type","Description","RiskMatrixObjectId","int","The unique ID of the associated Risk Matrix.","RiskThresholdObjectId","int","The unique ID of the associated Risk Threshold.","RiskMatrixThresholdCreated Message","35637.htm");
Page[78]=new Array("Field","Type","Description","RiskMatrixObjectId","int","The unique ID of the associated Risk Matrix.","RiskThresholdObjectId","int","The unique ID of the associated Risk Threshold.","NewValues","RiskMatrixThresholdType","Refer to the entries in the RiskMatrixThresholdType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","RiskMatrixThresholdType","Refer to the entries in the RiskMatrixThresholdType Table below. ","Additional information can be found in the p6events.xsd schema.&nbsp;","The old values of Physical and writable fields that have changed.","RiskMatrixThresholdType Table","Type: RiskMatrixThresholdType","Elements","Type","RiskMatrixObjectId","int","RiskThresholdObjectId","int","RiskMatrixThresholdUpdated Message","35638.htm");
Page[79]=new Array("Field","Type","Description","Id","string","The ID of the risk response action. This must be unique within the assigned risk.","ObjectId","int","The unique ID generated by the system.","ProjectObjectId","int","The unique ID of the project associated with the risk response action.","RiskResponsePlanObjectId","int","The unique ID of the risk response plan associated with the risk response action.","RiskResponseActionCreated Message","45507.htm");
Page[80]=new Array("Field","Type","Description","Id","string","The ID of the risk response action. This must be unique within the assigned risk.","ObjectId","int","The unique ID generated by the system.","ProjectObjectId","int","The unique ID of the project associated with the risk response action.","RiskResponsePlanObjectId","int","The unique ID of the risk response plan associated with the risk response action.","NewValues","RiskResponseActionType","Refer to the entries in the RiskResponseActionType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","RiskResponseActionType","Refer to the entries in the RiskResponseActionType Table below. ","Additional information can be found in the p6events.xsd schema.","The old values of Physical and writable fields that have changed.","RiskResponseActionType Table","Type: RiskResponseActionType","Elements","Type","ActivityObjectId","int","Id","string","Name","string","ObjectId","int","ResourceObjectId","int","RiskResponsePlanObjectId","int","Status","string<br />restricted to <br />'Proposed'<br />'Sanctioned'<br />'Rejected'<br />'In Progress'<br />'Complete'<br />","RiskResponseActionUpdated Message","45508.htm");
Page[81]=new Array("Field","Type","Description","ProjectObjectId","int","The ID of the risk response action impact. This must be unique within the assigned risk.","RiskResponseActionObjectId","int","The unique ID of the risk response action associated with the risk response action impact.","RiskThresholdLevelObjectId","int","The unique ID of the risk threshold level associated with the risk response action.","RiskThresholdObjectId","int","The unique id of the risk threshold associated with the risk response action.","RiskResponseActionImpactCreated Message","45509.htm");
Page[82]=new Array("Field","Type","Description","ProjectObjectId","int","The unique ID of the project associated with the risk response action impact.","RiskResponseActionObjectId","int","The unique ID of the risk response action associated with the risk response action impact.","RiskThresholdLevelObjectId","int","The unique ID of the risk threshold level associated with the risk response action impact.","RiskThresholdObjectId","int","The unique ID of the risk threshold associated with the risk response action impact.","NewValues","RiskResponseActionImpactType","Refer to the entries in the RiskResponseActionImpactType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","RiskResponseActionImpactType","Refer to the entries in the RiskResponseActionImpactType Table below. ","Additional information can be found in the p6events.xsd schema.","The old values of Physical and writable fields that have changed.","RiskResponseActionImpactType Table","Type: RiskResponseActionImpactType","Elements","Type","RiskResponseActionObjectId","int","RiskThresholdLevelObjectId","int","RiskResponseActionImpactUpdated Message","45510.htm");
Page[83]=new Array("Field","Type","Description","Id","string","The ID of the risk response plan. This must be unique within the assigned risk.","ObjectId","int","The unique ID generated by the system.","ProjectObjectId","int","The unique ID of the associated project.","RiskObjectId","int","The unique ID of the associated risk.","RiskResponsePlanCreated Message","35643.htm");
Page[84]=new Array("Field","Type","Description","Id","string","The ID of the risk response plan. This must be unique within the assigned risk.","ObjectId","int","The unique ID generated by the system.","ProjectObjectId","int","The unique ID of the associated project.","RiskObjectId","int","The unique ID of the associated risk.","NewValues","RiskResponsePlanType","Refer to the entries in the RiskResponsePlanType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","RiskResponsePlanType","Refer to the entries in the RiskResponsePlanType Table below. ","Additional information can be found in the p6events.xsd schema.&nbsp;&nbsp;","The old values of Physical and writable fields that have changed.","RiskResponsePlanType Table","Type: RiskResponsePlanType","Elements","Type","Id","string","IsActive","boolean","Name","string","ObjectId","int","ResponseType","string<br />restricted to <br />'Avoid'<br />'Transfer'<br />'Reduce'<br />'Accept'<br />'Exploit'<br />'Facilitate'<br />'Enhance'<br />'Reject'<br />","RiskObjectId","int","RiskResponsePlanUpdated Message","35644.htm");
Page[85]=new Array("Field","Type","Description","Name","string","The name of the risk score type.","ObjectId","int","The unique ID generated by the system.","RiskThresholdCreated Message","35649.htm");
Page[86]=new Array("Field","Type","Description","Name","string","The name of the risk score type.","ObjectId","int","The unique ID generated by the system.","NewValues","RiskThresholdType","Refer to the entries in the RiskThresholdType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","RiskThresholdType","Refer to the entries in the RiskThresholdType Table below. ","Additional information can be found in the p6events.xsd schema.&nbsp;","The old values of Physical and writable fields that have changed.","RiskThresholdType Table","Type: RiskThresholdType","Elements","Type","Name","string","ObjectId","int","ThresholdType","string<br />restricted to <br />'Probability'<br />'Tolerance'<br />'Schedule'<br />'Cost'<br />'Relative Schedule'<br />'Relative Cost'<br />'User Defined'<br />","RiskThresholdUpdated Message","35650.htm");
Page[87]=new Array("Field","Type","Description","Code","string","The 10 character code for the threshold level. Must be unique.","ObjectId","int","The unique ID generated by the system.","RiskThresholdObjectId","int","The unique ID of the associated Risk Threshold.","RiskThresholdLevelCreated Message","35647.htm");
Page[88]=new Array("Field","Type","Description","Code","string","The 10 character code for the threshold level. Must be unique.","ObjectId","int","The unique ID generated by the system.","RiskThresholdObjectId","int","The unique ID of the associated Risk Threshold.","NewValues","RiskThresholdLevelType","Refer to the entries in the RiskThresholdLevelType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","RiskThresholdLevelType","Refer to the entries in the RiskThresholdLevelType Table below. ","Additional information can be found in the p6events.xsd schema.&nbsp;&nbsp;","The old values of Physical and writable fields that have changed.","RiskThresholdLevelType Table","Type: RiskThresholdLevelType","Elements","Type","Code","string","Color","string<br />restricted to <br />pattern <br />'#([A-Fa-f0-9]{6})'<br />","CostRange","double","Level","int","Name","string","ObjectId","int","ProbabilityRange","double","Range","string","RiskThresholdObjectId","int","ScheduleRange","double","ToleranceRange","int","RiskThresholdLevelUpdated Message","35648.htm");
Page[89]=new Array("Field","Type","Description","Id","string","The short code that uniquely identifies the role.","Name","string","The name of the role. The role name uniquely identifies the role.","ObjectId","int","The unique ID generated by the system.","RoleCreated Message","34267.htm");
Page[90]=new Array("Field","Type","Description","Id","string","The short code that uniquely identifies the role.","Name","string","The name of the role. The role name uniquely identifies the role.","ObjectId","int","The unique ID generated by the system.","NewValues","RoleType","Refer to the entries in the RoleType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","RoleType","Refer to the entries in the RoleType Table below. ","Additional information can be found in the p6events.xsd schema.","The old values of Physical and writable fields that have changed.","RoleType Table","Type: RoleType","Elements","Type","CalculateCostFromUnits","boolean","Id","string","Name","string","ObjectId","int","ParentObjectId","int","RoleUpdated Message","34268.htm");
Page[91]=new Array("Field","Type","Description","ObjectId","int","The unique ID generated by the system.","RoleObjectId","int","The unique ID of the associated role.","RoleRateCreated Message","34265.htm");
Page[92]=new Array("Field","Type","Description","ObjectId","int","The unique ID generated by the system.","RoleObjectId","int","The unique ID of the associated role.","NewValues","RoleRateType","Refer to the entries in the RoleRateType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","RoleRateType","Refer to the entries in the RoleRateType Table below. ","Additional information can be found in the p6events.xsd schema.","The old values of Physical and writable fields that have changed.","RoleRateType Table","Type: RoleRateType","Elements","Type","ObjectId","int","PricePerUnit","double","PricePerUnit2","double","PricePerUnit3","double","PricePerUnit4","double","PricePerUnit5","double","RoleObjectId","int","RoleRateUpdated Message","34266.htm");
Page[93]=new Array("Field","Type","Description","Name","string","The name of the role team.","ObjectId","int","The unique ID generated by the system.","UserObjectId","int","The unique ID of a specific user who has access to the selected role team.","RoleTeamCreated Message","34497.htm");
Page[94]=new Array("Field","Type","Description","Name","string","The name of the role team.","ObjectId","int","The unique ID generated by the system.","UserObjectId","int","The unique ID of a specific user who has access to the selected role team.","NewValues","RoleTeamType","Refer to the entries in the RoleTeamType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","RoleTeamType","Refer to the entries in the RoleTeamType Table below. ","Additional information can be found in the p6events.xsd schema.","The old values of Physical and writable fields that have changed.","RoleTeamType Table","Type: RoleTeamType","Elements","Type","Description","string","Name","string","ObjectId","int","UserObjectId","int","Roles","RoleTeamUpdated Message","34498.htm");
Page[95]=new Array("Field","Type","Description","ResourceId","string","The short code that uniquely identifies the resource.","ResourceName","string","The name of the resource.","ResourceObjectId","int","The unique ID of the associated resource.","StatusDate","dateTime","The date on which the status of the timesheet was last changed.","TimesheetPeriodObjectId","int","The unique ID of the timesheet period.","UserName","string","The user name who updated the timesheet.","UserObjectId","int","The unique ID of the associated user.","NewValues","TimesheetType","Refer to the entries in the TimesheetType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","TimesheetType","Refer to the entries in the TimesheetType Table below. ","Additional information can be found in the p6events.xsd schema.","The old values of Physical and writable fields that have changed.","TimesheetType Table","Type: TimesheetType","Elements","Type","Status","string<br />restricted to <br />'Submitted'<br />'Approved'<br />'Resource Manager Approved'<br />'Project Manager Approved'<br />'Active'<br />'Rejected'<br />'Not Started'<br />'Resubmitted'<br />'Reopened'<br />'Submitted for RM'<br />'Resubmitted for RM'<br />","TimesheetUpdated Message","34281.htm");
Page[96]=new Array("Field","Type","Description","Cost","double","The value of the cost UDF.","Double","double","The value of the double UDF.","FinishDate","dateTime","The value of the finish date UDF.","ForeignObjectId","int","The unique ID of the business object to which the UDF is assigned: ProjectObjectId, ActivityObjectId, ResourceObjectId, etc.","Indicator","string<br />restricted to <br />'None'<br />'Red'<br />'Yellow'<br />'Green'<br />'Blue'<br />","The value of the indicator UDF.","Integer","int","The value of the integer UDF.","ProjectObjectId","int","The unique ID of the associated project.","StartDate","dateTime","The value of the start date UDF.","Text","string","The value of the text UDF.","UDFCodeObjectId","int","The unique ID of the associated UDF code.","UDFTypeObjectId","int","The unique ID of the associated UDF type.","UDFTypeSubjectArea","string<br />restricted to <br />'Activity'<br />'Activity Expense'<br />'Activity Step'<br />'Project'<br />'Project Issue'<br />'Project Risk'<br />'Resource'<br />'Resource Assignment'<br />'WBS'<br />'Work Products and Documents'<br />'Activity Step Template Item'<br />","The subject area of the associated user-defined field type.","UDFValueCreated Message","53807.htm");
Page[97]=new Array("Field","Type","Description","ForeignObjectId","int","The unique ID of the business object to which the UDF is assigned: ProjectObjectId, ActivityObjectId, ResourceObjectId, etc.","ProjectObjectId","int","The unique ID of the associated project.","UDFCodeObjectId","int","The unique ID of the associated UDF code.","UDFTypeObjectId","int","The unique ID of the associated UDF type.","UDFTypeSubjectArea","string<br />restricted to <br />'Activity'<br />'Activity Expense'<br />'Activity Step'<br />'Project'<br />'Project Issue'<br />'Project Risk'<br />'Resource'<br />'Resource Assignment'<br />'WBS'<br />'Work Products and Documents'<br />'Activity Step Template Item'<br />","The subject area of the associated user-defined field type..","NewValues","UDFValueType","Refer to the entries in the UDFValueType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","UDFValueType","Refer to the entries in the UDFValueType Table below. ","Additional information can be found in the p6events.xsd schema.&nbsp;&nbsp;","The old values of Physical and writable fields that have changed.","UDFValueType Table","Type: UDFValueType","Elements","Type","Cost","double","Double","double","FinishDate","dateTime","ForeignObjectId","int","Indicator","string<br />restricted to <br />'None'<br />'Red'<br />'Yellow'<br />'Green'<br />'Blue'<br />","Integer","int","StartDate","dateTime","Text","string","UDFCodeObjectId","int","UDFTypeObjectId","int","UDFValueUpdated Message","53808.htm");
Page[98]=new Array("Field","Type","Description","Name","string","The user's login name.","ObjectId","int","The unique ID generated by the system.","PersonalName","string","The user's personal or actual name.","UserCreated Message","34269.htm");
Page[99]=new Array("Field","Type","Description","Name","string","The user's login name.","ObjectId","int","The unique ID generated by the system.","PersonalName","string","The user's personal or actual name.","NewValues","UserType","Refer to the entries in the UserType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","UserType","Refer to the entries in the UserType Table below. ","Additional information can be found in the p6events.xsd schema.&nbsp;","The old values of Physical and writable fields that have changed.","UserType Table","Type: UserType","Elements","Type","AllResourceAccessFlag","boolean","CurrencyObjectId","int","EmailAddress","string","EmailProtocol","string<br />restricted to <br />'Internet Mail'<br />'MAPI Mail'<br />","EnableUserToModifyViewSettingsFlag","boolean","GlobalProfileObjectId","int","MailServerLoginName","string","Name","string","ObjectId","int","OfficePhone","string","OutgoingMailServer","string","PersonalName","string","ReportingFlag","boolean","UserInterfaceViewObjectId","int","UserUpdated Message","34270.htm");
Page[100]=new Array("Field","Type","Description","OBSObjectId","int","The unique ID of the OBS to which the user is granted access.","UserObjectId","int","The unique ID of the user who is assigned to the project OBS.","UserOBSCreated Message","34271.htm");
Page[101]=new Array("Field","Type","Description","OBSObjectId","int","The unique ID of the OBS to which the user is granted access.","UserObjectId","int","The unique ID of the user who is assigned to the project OBS.","NewValues","UserOBSType","Refer to the entries in the UserOBSType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","UserOBSType","Refer to the entries in the UserOBSType Table below. ","Additional information can be found in the p6events.xsd schema.&nbsp;","The old values of Physical and writable fields that have changed.","UserOBSType Table","Type: UserOBSType","Elements","Type","OBSObjectId","int","ProjectProfileObjectId","int","UserObjectId","int","UserOBSUpdated Message","34272.htm");
Page[102]=new Array("Field","Type","Description","Code","string","The short code assigned to each WBS element for identification. Each WBS element is uniquely identified by concatenating its own code together with its parents' codes.","Name","string","The name of the WBS element.","ObjectId","int","The unique ID generated by the system.","ParentObjectId","int","The unique ID of the parent WBS of this WBS in the hierarchy.","ProjectObjectId","int","The unique ID of the associated project.","StatusReviewerObjectId","int","The unique ID generated by the system.","WBSCreated Message","34273.htm");
Page[103]=new Array("Field","Type","Description","Code","string","The short code assigned to each WBS element for identification. Each WBS element is uniquely identified by concatenating its own code together with its parents' codes.","Name","string","The name of the WBS element.","ObjectId","int","The unique ID generated by the system.","ParentObjectId","int","The unique ID of the parent WBS of this WBS in the hierarchy.","ProjectObjectId","int","The unique ID of the associated project.","StatusReviewerObjectId","int","The unique ID generated by the system.","NewValues","WBSType","Refer to the entries in the WBSType Table below. ","Additional information can be found in the p6events.xsd schema.","The new values of Physical and writable fields that have changed.","OldValues","WBSType","Refer to the entries in the WBSType Table below. ","Additional information can be found in the p6events.xsd schema.","The old values of Physical and writable fields that have changed.","WBSType Table","Type: WBSType","Elements","Type","AnticipatedFinishDate","dateTime","AnticipatedStartDate","dateTime","Code","string","EarnedValueComputeType","string<br />restricted to <br />'Activity Percent Complete'<br />'0 / 100'<br />'50 / 50'<br />'Custom Percent Complete'<br />'WBS Milestones Percent Complete'<br />'Activity Percent Complete Using Resource Curves'<br />","EarnedValueETCComputeType","string<br />restricted to <br />'ETC = Remaining Cost for Activity'<br />'PF = 1'<br />'PF = Custom Value'<br />'PF = 1 / CPI'<br />'PF = 1 / (CPI * SPI)'<br />","EarnedValueETCUserValue","double","EarnedValueUserPercent","double","IndependentETCLaborUnits","double","IndependentETCTotalCost","double","IntegratedType","string<br />restricted to <br />'ERP'<br />'Fusion'<br />'Gateway'","IntegratedWBS","Boolean","Name","string","OBSObjectId","int","ObjectId","int","OriginalBudget","double","ParentObjectId","int","ProjectObjectId","int","Status","string<br />restricted to <br />'Planned'<br />'Active'<br />'Inactive'<br />'What-If'<br />'Requested'<br />'Template'<br />","StatusReviewerObjectId","int","WBSCategoryObjectId","int","WBSUpdated Message","34274.htm");
Page[104]=new Array("Field","Type","Description","DataDate","dateTime","The DataDate field that is associated with the project.","Project","ProjectIdentityType ","Refer to the entries in the ProjectIdentityType Table below.","The complex element that identifies the project.","Status","JobStatusType","Refer to the entries in the JobStatusType Table below.","Describes the state of the job after completion.","ProjectIdentityType Table","ProjectIdentityType","Id","string","Name","string","ObjectId","int","JobStatusType Table","JobStatusType","string<br />restricted to <br />'Completed'<br />'Failed'","ApplyActualsInvoked Message","34282.htm");
Page[105]=new Array("Field","Type","Description","UUID","string","The Universal Unique Identifier of the document in the content repository.","UserName","string","The user name who performed the operation.","DocumentObjectId","int","The object ID of the document that's involved in the operation.","ContentRepositoryDocumentAdded Message","34500.htm");
Page[106]=new Array("Field","Type","Description","UUID","string","The Universal Unique Identifier of the document in the content repository.","UserName","string","The user name who performed the operation.","DocumentObjectId","int","The object ID of the document that's involved in the operation.","ContentRepositoryDocumentCheckedIn Message","34502.htm");
Page[107]=new Array("Field","Type","Description","UUID","string","The Universal Unique Identifier of the document in the content repository","UserName","string","The user name who performed the operation.","DocumentObjectId","int","The object ID of the document that's involved in the operation.","ContentRepositoryFolderAdded Message","34501.htm");
Page[108]=new Array("Field","Type","Description","NewBaselineProjectObjectId","int","The object ID of the new Baseline project (it's the same as the object ID of the project that has been converted).","ObjectId","int","The object ID of the project to which the new baseline project belongs.","ConvertProjectToBaselineInvoked Message","45515.htm");
Page[109]=new Array("Field","Type","Description","NewBaselineProjectObjectId","int","The project id generated for the newly created baseline.","SourceProject","SourceProjectType","Refer to the entries in the SourceProjectType table below.","The complex element that identifies the source project from which the baseline was copied.","TargetEPS","TargetEPSType","Refer to the entries in the TargetEPSType table below.","The complex element that identifies the target EPS under which the baseline was copied.","Status","JobStatusType<br />","Refer to the entries in the JobStatusType table below.","Describes the state of the job after completion.","SourceProjectType Table","SourceProjectType","Id","string","Name","string","ProjectObjectId","ObjectId","TargetEPSType Table","TargetEPSType","Id","string","Name","string","ProjectObjectId","ObjectId","WBSObjectId","ObjectId","JobStatusType Table","JobStatusType","string restricted to completed or failed.","CopyBaselineInvoked Method","94108.htm");
Page[110]=new Array("Field","Type","Description","NewBaselineProjectObjectId","int","The object ID of the project created by the stored procedure.","ObjectId","int","The object ID of the parent EPS of the new project.","BaselineProjectObjectId","int","The object ID of the project that was copied.","CopyBaselineProjectInvoked Message","45517.htm");
Page[111]=new Array("Field","Type","Description","NewBaselineProjectObjectId","int","The object ID of the project created by the stored procedure.","EPSObjectId","int","The object ID of the parent EPS of the new project.","ObjectId","int","The object ID of the project that was copied.","CopyProjectAsBaselineInvoked Message","45518.htm");
Page[112]=new Array("Field","Type","Description","NewProjectObjectId","int","The object ID of the project created by the stored procedure.","EPSObjectId","int","The object ID of the parent EPS of the new project.","ObjectId","int","The object ID of the project that was copied.","CopyProjectInvoked Message","45520.htm");
Page[113]=new Array("Field","Type","Description","NewBaselineProjectObjectId","int","The project id generated for the newly created baseline.","SourceProject","SourceProjectType","Refer to the entries in the SourceProjectType table below.","The complex element that identifies the source project for which the baseline was created.","TargetProject","TargetProjectType","Refer to the entries in the TargetProjectType table below.","The complex element that identifies the target project for which the baseline was created.","Status","JobStatusType<br />","Refer to the entries in the JobStatusType table below.","Describes the state of the job after completion.","SourceProjectType Table","SourceProjectType","Id","string","Name","string","ProjectObjectId","ObjectId","TargetProjectType Table","TargetProjectType","Id","string","Name","string","ProjectObjectId","ObjectId","WBSObjectId","ObjectId","JobStatusType Table","JobStatusType","string restricted to completed or failed.","CreateBaselineInvoked Message","94107.htm");
Page[114]=new Array("Field","Type","Description","NewTemplateProjectObjectId","int","The object ID of the template project that was created by the stored procedure.","EPSObjectId","int","The object ID of the parent EPS of the new template project","ObjectId","int","The object ID of the project or template project that was copied.","CreateCopyAsTemplateInvoked Message","47442.htm");
Page[115]=new Array("Field","Type","Description","NewProjectObjectId","int","The object ID of the project created by the stored procedure.","EPSObjectId","int","The unique ID of the associated EPS.","ObjectId","int","The unique ID generated by the system.","CreateProjectFromTemplateInvoked Message","45519.htm");
Page[116]=new Array("Field","Type","Description","NewTemplateProjectObjectId","int","The project id generated for the newly created template.","EPSObjectId","int","The unique id of the EPS under which the template was created.","ObjectId","int","The unique id generated for the newly created template.","CreateTemplatefromProjectInvoked Message","94113.htm");
Page[117]=new Array("Field","Type","Description","ProjectObjectId","int","The object ID of the project exported by the stored procedure.","ExportedAs","String","Refer to the entries in the ExportedAs Table below.","The export type of the project.","Success","Boolean.","Export Status (1 = success, 0 = failure)","ExportedAs Table","ExportedAs","string<br />restricted to <br />'MSP'<br />'Primavera'","ExportInvoked Message","98005.htm");
Page[118]=new Array("Field","Type","Description","UserId","int","The object ID of the user who invoked the Global Search and Replace Job.","Status","String","Refer to the entries in the Status Table below.","The status of the job.","Status Table","Status","string<br />restricted to <br />'Completed'<br />'Failed'<br />'COMPLETEDWITHERRORS'","GlobalSearchandReplaceInvoked Message","98007.htm");
Page[119]=new Array("Field","Type","Description","ImportFile","String","The name of the file which is imported.","EPSObjectId","int","The object ID of the EPS in which the project is imported by the stored procedure.","ProjectObjectId","int","The object ID of the project imported by the stored procedure.","Success","Boolean","Export Status (1 = success, 0 = failure)","ImportInvoked Message","98004.htm");
Page[120]=new Array("Field","Type","Description","Project","ProjectIdentityType","Refer to the entries in the ProjectIdentityType Table below.","The complex element that identifies the project.","Status","JobStatusType","Refer to the entries in the JobStatus Type Table below.","Describes the state of the job after completion.","ProjectIdentityType Table","ProjectIdentityType","Id","string","Name","string","ObjectId","int","JobStatusType Table","JobStatusType","string<br />restricted to <br />'Completed'<br />'Failed'","LevelInvoked Message","45514.htm");
Page[121]=new Array("Field","Type","Description","Status","String","Refer to the entries in the Status Table below.","The status of the publishing audit job.","Status Table","Status","string<br />restricted to <br />'Completed'<br />'Failed'<br />'COMPLETEDWITHERRORS'","PublishAuditdataInvoked Message","98008.htm");
Page[122]=new Array("Field","Type","Description","CompletedOn","dateTime","The date and time at which publishing completed.","Status","JobStatusType","Refer to the entries in the JobStatusType Table below.","Describes the state of the job after completion.","JobStatusType Table","JobStatusType","string<br />restricted to <br />'Completed'<br />'Failed'","PublishEnterpriseDataInvoked Message","50192.htm");
Page[123]=new Array("Field","Type","Description","CompletedOn","dateTime","The date and time at which publishing completed.","Status","JobStatusType","Refer to the entries in the JobStatusType Table below.","Describes the state of the job after completion.","JobStatusType Table","JobStatusType","string<br />restricted to <br />'Completed'<br />'Failed'","PublishEnterpriseSummariesInvoked Message","50193.htm");
Page[124]=new Array("Field","Type","Description","CompletedOn","dateTime","The date and time at which publishing completed.","Project","ProjectIdentityType","Refer to the entries in the ProjectIdentityType Table below.","The complex element that identifies the project.","Status","JobStatusType","Refer to the entries in the JobStatusType Table below.","Describes the state of the job after completion.","ProjectIdentityType Table","ProjectIdentityType","Id","string","Name","string","ObjectId","int","JobStatusType Table","JobStatusType","string<br />restricted to <br />'Completed'<br />'Failed'","PublishProjectInvoked Message","50191.htm");
Page[125]=new Array("Field","Type","Description","CompletedOn","dateTime","The date and time at which publishing completed.","Status","JobStatusType","Refer to the entries in the JobStatusType Table below.","Describes the state of the job after completion.","JobStatusType Table","JobStatusType","string<br />restricted to <br />'Completed'<br />'Failed'","PublishResourceManagementInvoked Message","50194.htm");
Page[126]=new Array("Field","Type","Description","CompletedOn","dateTime","The date and time at which publishing completed.","Project","ProjectType","Refer to the ProjectType table below.","The complex element that identifies the project.","Status","JobStatusType","Refer to the JobStatusType table below.","Describes the state of the job after completion.","ProjectType Table","ProjectType","Id","string","Name","string","ObjectId","int","JobStatusType Table","JobStatusType","string restricted to completed or failed.","PublishResourceRoleAssignmentSpreadInvoked Message","94111.htm");
Page[127]=new Array("Field","Type","Description","CompletedOn","dateTime","The date and time at which publishing completed.","Status","JobStatusType","Refer to the entries in the JobStatusType Table below.","Describes the state of the job after completion.","JobStatusType Table","JobStatusType","string<br />restricted to <br />'Completed'<br />'Failed'","PublishSecurityInvoked Message","50195.htm");
Page[128]=new Array("Field","Type","Description","Project","ProjectIdentityType","Refer to the entries in the ProjectIdentityType Table below.","The complex element that identifies the project.","SyncOTFactor","boolean","The flag to synchronize the overtime factor.","Status","JobStatusType","Refer to the entries in the JobStatusType Table below.","The state of the job after completion.","ProjectIdentityType Table","ProjectIdentityType","Id","string","Name","string","ObjectId","int","JobStatusType Table","JobStatusType","string<br />restricted to <br />'Completed'<br />'Failed'","RecalculateAssignmentCostsInvoked Message","45513.htm");
Page[129]=new Array("Field","Type","Description","ObjectId","int","The object id of the baseline project, which is the same as the object id of the project after the restore.","RestoreBaselineProjectInvoked Message","45516.htm");
Page[130]=new Array("Field","Type","Description","DataDate","dateTime","The DataDate field that is associated with the project.","Project","ProjectIdentityType","Refer to the entries in the ProjectIdentityType Table below.","The complex element that identifies the project.","Status","JobStatusType","Refer to the entries in the JobStatusType Table below.","Describes the state of the job after completion.","ProjectIdentityType Table","ProjectIdentityType","Id","string","Name","string","ObjectId","int","JobStatusType Table","JobStatusType","string<br />restricted to <br />'Completed'<br />'Failed'","ScheduleInvoked Message","34284.htm");
Page[131]=new Array("Field","Type","Description","FinancialPeriod","FinancialPeriodIdentityType","Refer to the entries in the FinancialPeriodIdentityType Table below.","The complex element that identifies the FinancialPeriod.","Project","ProjectIdentityType","Refer to the entries in the ProjectIdentityType Table below.","The complex element that identifies the project.","Status","JobStatusType","Refer to the entries in the JobStatusType Table below.","Describes the state of the job after completion.","FinancialPeriodIdentityType Table","FinancialPeriodIdentityType","EndDate","dateTime","Name","string","ObjectId","int","StartDate","dateTime","ProjectIdentityType Table","ProjectIdentityType","Id","string","Name","string","ObjectId","int","JobStatusType Table","JobStatusType","string<br />restricted to <br />'Completed'<br />'Failed'","StorePeriodPerformanceInvoked Message","34285.htm");
Page[132]=new Array("Field","Type","Description","Project","ProjectIdentityType","Refer to the entries in the ProjectIdentityType Table below.","The complex element that identifies the project.","Status","JobStatusType","Refer to the entries in the JobStatusType Table below.","Describes the state of the job after completion.","ProjectIdentityType Table","ProjectIdentityType","Id","string","Name","string","ObjectId","int","JobStatusType Table","JobStatusType","string<br />restricted to <br />'Completed'<br />'Failed'","SummarizeInvoked Message","34286.htm");
Page[133]=new Array("Field","Type","Description","BaselineProjId","int","The object ID of the baseline project created by the stored procedure.","ParentProjId","int","The object ID of the parent project created by the stored procedure.","Status","String","Refer to the entries in the JobStatusType Table below.","The status of the Update Baseline job.","Status Table","Status","string<br />restricted to <br />'Completed'<br />'Failed'<br />'COMPLETEDWITHERRORS'","UpdatebaselineInvoked Message","98006.htm");
Page[134]=new Array("Field","Type","Description","ImportFile","string","The file name of the XER file imported.","CreateNewProject","This complex element is included in the message if created new project has been specified for the XER import. It contains the EPSObjectId (the EPS where the project is imported to) and the ProjectObjectId (the object ID of the project created by the import). This element is mutually exclusive with the UpdateExistingProject element.","UpdateExistingProject","UpdateExistingProject: This complex element is included in the message if update existing project has been specified for the XER import. It contains the ProjectObjectId which is the object ID of the project that has been updated.","Success","boolean","The boolean that indicates if the import is successful or failed.","ErrorMessage","string","Contains the exception message if the import fails.","XERImportInvoked Message","102297.htm");
Page[135]=new Array("Field","Type","Description","ImportFile","string","The file name of the XML file imported.","CreateNewProject","This complex element is included in the message if created new project has been specified for the XML import. It contains the EPSObjectId (the EPS where the project is imported to) and the ProjectObjectId (the object ID of the project created by the import). This element is mutually exclusive with the UpdateExistingProject element.","UpdateExistingProject","UpdateExistingProject: This complex element is included in the message if update existing project has been specified for the XML import. It contains the ProjectObjectId which is the object ID of the project that has been updated.","Success","boolean","The boolean that indicates if the import is successful or failed.","ErrorMessage","string","Contains the exception message if the import fails.","XMLImportInvoked Message","34499.htm");
var PageCount=136;


/*
Date: 12/8/2025 10:50 AM
Source: EPPM_25_dev
BookID: 34218
PubProduct: PRIMAVERA_EPPM
BookTitle: Business Object Events Reference Guide for On-Premises
Version: Version 25
Lang:	en
*/
	var PageLength=Page.length;
	var Result = "";
	var ResultTemp = "";
	var ResultFound = "";
	var ResultTitleOnly = [];
	var ResultTitleAndContent = [];
	var ResultInContent = [];
	var ResultInContentTemp = [];

	var ResultCombinedTemp = [];
	var ResultCombined = [];

	var arrayIndex = 0;
	var NrRes = 0;
	var j = 0;
	var i = 0;
	var k = 0;
	var d = 0;
	var maxItems = 1000;
	var heading = 0;
	var WordPos = -1;
	var WordPosHeading = -1;
	var WordPosContentText = -1;
	var FoundWord = "";
	var FoundWordHead = "";
	var SearchInHeadingOnly = 0;
	var isChecked;
	var size = 10;
	var resGroupCounter = 0;
	var shown = "shown";
	var checkBoxInHeading;
	var searchFlag = 0;
	var DivResult;
	var SearchWord;

if (SearchText && SearchText.length >= 1) {
		SearchWord = SearchText.replace(/\+/g, " ").replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;");
		searchFlag = 1;
	} else {
		SearchWord = "";
		searchFlag = 0;
	}
	

	if (searchFlag === 1) {
		Result = "";

		// checkBoxInHeading = document.getElementById("inHeading");
		if (inHeading) {

			isChecked = true;
		} else {

			isChecked = false;
		}

		if (SearchWord && SearchWord.length >= 1) {
			if (isChecked) {
				SearchInHeadingOnly = 1;
			} else {
				SearchInHeadingOnly = 0;
			}
			SearchWord = SearchWord.toLowerCase();
			window.status = "Searching, please wait...";
			for (j = 0; j < PageLength; j++) {
				k = Page[j].length - 1;
				for (i = 0; i < k; i++) {

					heading = k - 1;

					if (SearchInHeadingOnly === 1) {
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPosHeading > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);

							NrRes++;
							ResultTemp = "<li>";
							ResultTemp += "<span>";
							ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							ResultTitleOnly[arrayIndex] = ResultTemp;
							arrayIndex++;

							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}
					} else if (SearchInHeadingOnly === 0) {
						WordPos = Page[j][i].toLowerCase().indexOf(SearchWord);
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPos > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							NrRes++;
							ResultTemp += "<li>";
							ResultTemp += "<span>";
							if (WordPosHeading > -1) {
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";
							} else {
								// found word is not in the head
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading] + "</a><br/>\n";

							}
							if (i < k - 1) {
								WordPosContentText = Page[j][i].toLowerCase().indexOf(SearchWord);

								if (Page[j][i].length > 300 && (WordPosContentText > -1)) {

									if (WordPosContentText > 75) {
										ResultInContentTemp.push("..." + Page[j][i].substr(WordPosContentText - 75, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");
									} else {
										ResultInContentTemp.push("..." + Page[j][i].substr(0, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");

									}

								} else if (WordPosContentText > -1) {

									ResultInContentTemp.push(Page[j][i].replace(FoundWord, FoundWord.bold()));

								}
							}

							ResultTemp += ResultInContentTemp.join("");

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							if (WordPosHeading > -1) {
								ResultTitleAndContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							} else {
								ResultInContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							}

							ResultInContentTemp.length = 0;
							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}

					}
				}
			}

			ResultTitleOnly = ResultTitleOnly.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultTitleAndContent = ResultTitleAndContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultInContent = ResultInContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			ResultCombinedTemp = ResultTitleOnly.concat(ResultTitleAndContent, ResultInContent);

			ResultCombinedTemp = ResultCombinedTemp.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			for (d = 0; d < ResultCombinedTemp.length; d += size) {
				resGroupCounter++
				ResultCombined.push("<div id=" + "'" + "resGroup_" + resGroupCounter + "'" + " class=" + "'" + "resGroup " + shown + "'" + ">" + "<ol class='searchResults'>" + ResultCombinedTemp.slice(d, d + size).join("") + "</ol></div>");
				shown = "notshown";
			}

			ResultFound = ResultCombined.join("");

Result += "<div id='searchDetailsDiv'>";
			Result += "<p class='searchDetails'>Your Search Found&nbsp;" + NrRes + "&nbsp;items.&nbsp;";
			Result += "</p></div>";
			
			Result += "<div class='searchResultsDiv'>";
			Result += "<div id='resultsCollection' class='searchResults'>";
			Result += ResultFound;
			Result += "</div>";
			Result += "</div>";
			Result += "<div class='searchPaging'>";

			Result += '<hr />';

			Result += '<p class="bodytext"><a class="disabledAnchor" id="pBack" onclick="turnPage(\'backPage\')" href="#pBack">Back</a>&nbsp; | &nbsp;';
			
			if (resGroupCounter && resGroupCounter > 1) {
				Result += '<a id="pNext" onclick="turnPage(\'nextPage\')" href="#pNext">Next</a>';
			} else {
				Result += '<a id="pNext"  class="disabledAnchor" href="#pNext">Next</a>';
			}
			Result += '</p>\n';
			Result += '<div id="pagenofn"><p class="bodytext">Page <span id="pagen">1</span> of ' + resGroupCounter + '</p></div>';

			Result += "</div>";
			
			
		}

		DivResult = document.getElementById("s_anchor");
		if (Result && DivResult) {

			//myDivResult.append(Result);
			DivResult.innerHTML = Result;
			

		}
		window.status = "";
		
		

	}
	}())
}
