'use strict';
function search(SearchText, inHeading) {
(function () {
var Page = [];

/* Generated with Author-it 23.4.1.30004  12/11/2025 7:47:01 PM */
Page[0]=new Array("Title and Copyright Information","Copyright  2018, 2025, Oracle and/or its affiliates.","Primary Author: Oracle Corporation","Title and Copyright Information","46576.htm");
Page[1]=new Array("Scope","This guide contains information about import and export formats and the process of importing and exporting data.","Audience","Administrators should read this guide.","About This Guide","98033.htm");
Page[2]=new Array("Import/Export features allow you to bring data into P6 as well as export data to other tools when needed. Global and Project level privileges control the ability to import and export data.","Available Import Options:","Import projects from other P6 EPPM users or Microsoft Project","Import multiple projects in a single XML or XER file","Import multiple projects in a single XML file contained within a single zip file","Import Activities","Import Resources","Import Locations","Import Appointments as personal non-work exception time from Microsoft Outlook and other applications that support the iCalendar format","Move activity codes and calendars to projects","Remove codes, UDFs, and calendars from projects","Rename codes, UDFs, and calendars ","Specify resource hierarchical position for importing into the resource breakdown structure","Map resources to generic resource names","Save import options in a template","Import views","Import enterprise data","Available Export Options:","Export Projects","Export multiple projects in a single XML or XER file","Export multiple projects in a single zip file containing a single XML or XER file","Export Activities","Export Resources","Export Resource Allocation and Cost","Export Risks","Export views","Export enterprise data","Note For best practices on exporting data from P6 EPPM to be imported into Oracle Primavera Cloud, see: Primavera Cloud P6 EPPM XML Import Guide.","About Importing and Exporting Data","6604.htm");
Page[3]=new Array("The import template has two groups of settings that determine how data is imported.","Import Action on the Basic Tab of the Import Template","The Import Action on the Basic tab of the import template determines how to handle the import of each type of data when a match is found between data in the import file and data in the database. P6 EPPM looks for a match on the basis of a single field (usually the ID but sometimes the name).","For example, you can specify that you do not want to import any Resources or Roles, but you do want to import Calendars and Codes.","For each data type listed, you can choose from the following import actions:","Insert New leaves matching data in your database unchanged and adds all the data of the associated data type from the import file to your database as new data items.","Use the Insert New action if you do not want to change your existing data of the associated type, but you still want to import the matching data from the import file. When you use this import action, the existing data in your database will remain unchanged, but new data items will be created for each data item of the selected type in the import file, even if the items in the data file have an exact match in your database.","Keep Existing leaves matching data items in your database unchanged. If there is data in the import file that does not have a match in your database, that data will be added to your database.","Use the Keep Existing import action if you don't want the data of the associated type in your database to be changed but you want to make sure that you add new data items of that type to your database from the import file.","Update Existing overwrites matching data of the associated data type in your database with data from the import file.","Use the Update Existing action if it is important that your data conforms to the data in the originating database.","Do Not Import leaves matching data of the associated data type in your database unchanged and does not import new data from the import file.","Use the Do Not Import import action for a data type if you do not want to change that type of data in your database at all as a result of importing.","Action on the Advanced Tab of the Import Template","The Action on the Advanced tab of the import template allows you to limit exactly which Codes, User Defined Fields (UDFs), and Calendars are imported from a file. For example, here you can specify that you do not want to import any global activity codes and their values, you want to update existing EPS specific activity codes and their values, and that you want to import assignments and values of the Phase activity code, but not the Status activity code.","For each Code, UDF, and Calendar, you can choose from the following actions:","Do Not Import leaves matching data of the associated item in your database unchanged and does not import new data from the import file. This option overrides the import action for that data type selected on the Basic tab of the import template.","Keep will import the data of the associated item according to the import action for that data type selected on the Basic tab of the import template.","Note For secure codes, this action applies only to the security status of the code (that is, whether the code is secure or unsecured). Do Not Import is used to prevent a code being upgraded to a secure code if the matching code is secure in the import file. Keep is used to allow the code to be upgraded to secure if the matching code in the import file is secure. Importing a file will never change a secure code into an unsecured code.","Import Settings","103120.htm");
Page[4]=new Array("If you have the suitable permissions, you can control how secure codes are imported from Primavera XML files into your database. The information here assumes that the person importing the data has the add/delete, edit, assign, and view permissions for secure codes.","Unlike UDFs and calendars, for codes, the Action setting on the Advanced tab of the import tab controls only the security status of a code, that is, whether or not the code is secure. In situations where the security status of a code is the same in the import file as in the database, the code and its values are imported according to the import action selected on the basic tab for the data type and the action selected on the advanced tab for each code.","However if the security status of a code is different in the import file from the code in the database, further rules are applied.","Mismatch of Secure or Unsecured Status","When the security status of a code differs between the import file and your database, the rules used for importing depend on the import action for the data type and the action for the code.","Note Importing a file will never change a secure code into an unsecured code.","When the import action for the data type is Insert New, Keep Existing, or Do Not import, neither the code's security status, nor other attributes of the code are imported, even if you have set the action for the code to Keep. This is because the rule used where a match is found in your database for Insert New, Keep Existing, and Do Not Import is not to update the matching data.","However, when the import action for the data type is Update Existing, the action you choose for each code determines how that code in your database will be updated. The table below summarizes the rules.","Status in Import File","Status in Database","Action","Update Code to Secure?","Update Other Attributes?","Unsecured","Secure","Do Not Import","No","No","Secure","Unsecured","No","Yes","Unsecured","Secure","Keep","No","Yes","Secure","Unsecured","Yes","Yes","Note It is important to be aware that if the code is secure in the import file but is unsecured in the database, choosing Do Not Import for the code will allow the definition of the code, except its security status, to be updated.","Therefore, depending on what aspects of a secure code you want to update, you should set the action for the code as follows:","If you want to update the security status of the code, use Keep. Keep allows P6 to update the code in your database from the import file.","If you want to update the definition of the code, but you do not want to change its security status in your database:","If the code is unsecured in your database, use Do Not Import.","Do Not Import prevents the security status of the code in your database from being changed. Therefore, because the code is not secure in your database, using Do Not Import retains that unsecured status and the code and other aspects of the code are updated according to the Update Existing rules applied to the data type.","If the code is secure in your database, use Keep.","Importing a code cannot change the code in your database from secure to unsecured. Selecting Keep allows P6 to update other aspects of the code in your database from the import file.","Secure Codes","103110.htm");
Page[5]=new Array("When you import projects from a Primavera XML file, you can view the detailed definitions of calendars used in the project and those in the import file. You can then determine the appropriate import actions for Global Calendars and Resource Calendars, and specify whether to import each calendar included in the file on a case-by-case basis.","In the import template, the Calendars tab lists all the calendars used in the projects being imported. The list includes columns showing the following information about each calendar:","Whether it is represented in the import file.","Whether it exists in your database.","Whether it has previously been added to the import template you are using.","From the calendar list, you can click to see more detailed information about any calendar. For calendars that exist in either the database, the import file, or both, you can view the summary, standard work hours, standard work week, and exceptions. If the calendar exists in both the database and the import file, you can switch between the two versions of the calendar to compare their definitions. Exceptions from both versions of the calendar are shown as a single list, allowing you to compare the two versions more easily. You can group the list of exceptions by source or date, or choose not to group the exception list at all.","After comparing the definitions of both versions of a calendar, you can make an informed decision about whether to import that calendar without change, rename it, or convert it to either a project or resource calendar. Renaming and converting calendars can help to prevent unintended changes to calendars being used widely across your database. You can choose whether to import, rename, or convert each of the calendars included in the import file on a case-by-case basis.","Calendars","112977.htm");
Page[6]=new Array("You can import projects and baselines using the Primavera XML format and create or update a project.","Note Avoid using the pipe character ( | ), or brackets ( &lt; or &gt; ) in the Project Name. ","To import projects using Primavera XML format:","Click Projects.","On the Projects navigation bar, click EPS.","On the EPS page:","Click the Actions&nbsp;@ menu and select Import/Export Projects.","In the Import/ExportProject dialog box, click the Import tab.","On the Import tab:","In the Import Type list, select Primavera XML.","In the File field, click @&nbsp;Browse.","In the File Upload dialog box, select a file and click Open.","On the Import tab:","Select a Template to use.","Note If you need to create a template or modify an existing template, click Manage Templates.","Select an option for Import Action.","If you selected Create New, click @&nbsp;Select in the Import To field and select the EPS where you want to import the XML file.","If you selected Update Existing, click @&nbsp;Select in the Import To field and select the project where you want to import the XML file.","Select which Baselines to import.","Note If you select to import with update existing and you select to import baselines, matching baselines will be updated with the data from the XML file according to the options in the selected template.","Click Import.","Tip","To understand how the import of secure codes is handled, see Secure Codes.","You can see the status of the import in the View Service Status dialog box.","You can import multiple projects as one file using Primavera XML format.","You can import a Primavera XML file from within a zip file. If the zip file contains multiple XML files, only the file with the same name as the zip will be imported. If the zip contains only one XML file, the name of the zip and XML file need not match. ","You can update baselines when you import a project and its baselines from an XML file. When you select the Update Existing import action at the project level, matching baselines you import will be updated from the import file. Baselines you choose to import but which do not have a match in your database against the project you selected to update will be added to the project as baselines, but will not be assigned as the project, primary, secondary, or tertiary user baseline.","The Activity Owner field shows the P6 EPPM user who owns the activity. If a Primavera XML file that includes the Activity Owner field is imported into a database, the Activity Owner data is imported only if the user already exists in the database.","Stored performance data can be imported as long as the start and finish dates of periods match between the import file and the financial period calendar assigned to the project for all financial periods with data stored at the activity or assignment level.","If the XML file was generated from a version earlier than release 20.4, when it is imported into release 20.4 or later rates for roles will be the same for all effective dates. If an XML file generated from release 20.4 or later is imported into a database with a version of 20.3 or earlier, only the rates which were effective at the time of export will be imported.","If the currency stored in the XML file matches a currency in your database, you can select whether to import financial data using the base currency in your database or the currency present in the XML file. If you chose to use the XML rate, financial data is converted as follows:","Cost imported = Cost in XML file * (Exchange rate in XML file / Exchange rate of the matching currency in your database)","For example:","Michelle Peterson in the London office exports a project to a Primavera XML file and sends the project file to her colleague Judy Billings in the Paris office. The XML file that Michelle generates, contains information about the view currency Michelle used and its exchange rate with the base currency in her database. When Judy receives the file, she imports it into her database using the option to import with the XML rate.","Michelle's view currency is GB Pounds () and the base currency in her database is US Dollars ($). The exchange rate between GB Pounds and the base currency in Michelle's database is 0.79. Judy's database has a base currency of Euros (), and the exchange rate between GB Pounds () and the base currency is 0.88.","Costs are always stored in units of the base currency of the database. So to import the correct value in GB Pounds, P6 converts the costs in the XML file by multiplying by the exchange rate for GB Pounds in the XML file divided by the exchange rate for GB Pounds in Judy's database.","In Michelle's database, Activity A1000 has a planned cost of 1,000. The cost is stored in the database in the base currency of US Dollars as $1,265.82. The Primavera XML file contains the cost of the activity in the base units as well as information about the ID, name, and exchange rate for GB Pounds in Michelle's database. When Judy imports the file, P6 converts the cost of Activity A1000 as follows:","$1,265.82  (XML exchange rate / destination exchange rate)","= $1,265.82  (0.79 / 0.88) = 1,136.36","When Judy changes her view currency to GB Pounds (), the value stored in the database is converted to the view currency by multiplying by the exchange rate for the view currency, so:","1,136.36  0.88 = 1000.00","Importing Projects using Primavera XML Format","43131.htm");
Page[7]=new Array("You can view the details of calendars in a Primavera XML file prior to import. If a calendar in the import file matches one in your database, you can compare the definitions of the two calendars to allow you to make an informed decision about whether you want to import the calendar.","To view the details of calendars in an import file:","Click Projects.","On the Projects navigation bar, click EPS.","On the EPS page:","Click the Actions&nbsp;@ menu and select Import/Export Projects.","In the Import/Export Project dialog box, select the Import tab.","On the Import tab:","In the Import Type list, select Primavera XER.","In the File field, click @&nbsp;Browse.","In the File Upload dialog box, select a file and click Open.","Select Manage Templates.","In the Manage Primavera Templates dialog box, select the template you will use to import the file.","In the Primavera Template dialog box, select the Advanced tab.","On the Advanced tab, select the Calendars tab.","On the Calendars tab, in the Details column, select @&nbsp;View&nbsp;Calendar&nbsp;Details for a calendar.","In the Calendar Details dialog box:","On the Summary tab, view a list of the work period start and end times for each day of the standard work week, the time periods, and the base calendar (for project and resource calendars).","If the calendar exists in the import file and the database, use the Source list to select the version of the calendar you want to view.","On the Calendar tab, view the work and non-work periods on a day-by-day basis.","If the calendar exists in the import file and the database, use the Source list to select the version of the calendar you want to view.","On the Standard Work Week tab, view a visual representation of the work periods of a standard work week.","If the calendar exists in the import file and the database, use the Source list to select the version of the calendar you want to view.","On the Exceptions tab, view a list of the exceptions that exist in the calendar. If the calendar exists in both the database and import file, all the exceptions from both versions of the calendar are listed here. You can group the exceptions by:","Source: To group the exceptions by whether they exist in the import file, the database, or both.","Date: To group the exceptions by month.","None: To show the exceptions without grouping.","Select OK.","Viewing Calendar Details","113022.htm");
Page[8]=new Array("You can export projects to locations outside P6 using the Primavera XML format to share project information between Project Management databases.","To export projects using Primavera XML format:","Click Projects.","On the Projects navigation bar, click EPS.","On the EPS page:","Click the Actions&nbsp;@ menu and select Import/Export Projects.","In the Import/ExportProject dialog box, click the Export tab.","On the Export tab:","In the Export Type field, select Primavera XML.","Optionally select Export to zip to export a compressed file containing the XML file.","Click @&nbsp;Add&nbsp;Project..., and in the Select Project dialog box select a project then click Select.","In the Baselines field, click and select which baselines you want to include with the export.","Click Export.","Tip","You can see the status of the import in the View Service Status dialog box.","To download the exported file, click the link in the View Service Status tab or Notifications dialog box.","You can export multiple projects as one file using Primavera XML format.","Exporting Projects using Primavera XML Format","7973.htm");
Page[9]=new Array("You can import projects and baselines using P6 Professional's native Primavera XER format and create or update a project.","Note","Avoid using the pipe character ( | ), or brackets ( &lt; or &gt; ) in the Project Name. ","P6 and P6 Professional handle the import of XER files slightly differently.The XML import options in P6 have a few extra options when compared to the XML import options in P6 Professional (Document Categories, Document Statuses, Locations, and WP and Docs). However the import options for XER files in P6 Professional allow less configuration than the XML import options. Also, in P6 Professional only users with the Admin Superuser global security profile or Project Superuser project security profile can import projects, whereas any user with the appropriate permissions can import projects in P6.","To import projects using Primavera XER format:","Click Projects.","On the Projects navigation bar, click EPS.","On the EPS page:","Click the Actions&nbsp;@ menu and select Import/Export Projects.","In the Import/ExportProject dialog box, click the Import tab.","On the Import tab:","In the Import Type list, select Primavera XER.","In the File field, click @&nbsp;Browse.","In the File Upload dialog box, select a file and click Open.","On the Import tab:","Select a Template to use.","Note If you need to create a template or modify an existing template, click Manage Templates.","Select an option for Import Action.","If you selected Add Into Existing Project, click @&nbsp;Select in the Import To field and select the project or WBS node where you want to create a new child WBS to contain the imported project from the XER file.","If you selected Create New, click @&nbsp;Select in the Import To field and select the EPS where you want to import the XER file.","If you selected Replace Existing, click @&nbsp;Select in the Import To field and select the project you want to replace with the imported project from the XER file.","If you selected Update Existing, click @&nbsp;Select in the Import To field and select the project you want to update with the imported project from the XER file.","Select which Baselines to import.","Note If you select to import with update existing and you select to import baselines, matching baselines will be updated with the data from the XER file according to the options in the selected template.","Click Import.","Tip","To understand how the import of secure codes is handled, see Secure Codes","Risks in P6 Professional are stored in the ProjRisk table. ProjRisks are included in the XER file format and are imported from XER files into P6 EPPM, however ProjRisks are not visible in P6. If you need to import and export risk information, Oracle recommends you use XML format.","You can see the status of the import in the View Service Status dialog box.","You can import multiple projects as one file using Primavera XER format.","You can update baseline when you import a project and its baselines from an XER file. When you select the Update Existing import action at the project level, matching baselines you import will be updated from the import file. Baselines you choose to import but which do not have a match in your database against the project you selected to update will be added to the project.","The Activity Owner field shows the P6 EPPM user who owns the activity. If a Primavera XER file that includes the Activity Owner field is imported into a database, the Activity Owner data is imported only if the user already exists in the database.","Stored performance data can be imported as long as the start and finish dates of periods match between the import file and the financial period calendar assigned to the project for all financial periods with data stored at the activity or assignment level.","If the XER file was generated from a version earlier than release 20.4, when it is imported into release 20.4 or later rates for roles will be the same for all effective dates. If an XER file generated from release 20.4 or later is imported into a database with a version of 20.3 or earlier, only the rates which were effective at the time of export will be imported.","Importing Projects using Primavera XER Format","101760.htm");
Page[10]=new Array("You can export projects to Primavera XER format to share them with P6 Professional.","To export projects using Primavera XER format:","Click Projects.","On the Projects navigation bar, click EPS.","On the EPS page:","Click the Actions&nbsp;@ menu and select Import/Export Projects.","In the Import/ExportProject dialog box, click the Export tab.","On the Export tab:","In the Export Type list select Primavera XER.","In the Project field, click @&nbsp;Select and select a project to export.","In the Template list select a template to use.","Note If you need to create a template or modify an existing template, click Manage Templates.","Click Export.","Tip","You can see the status of the import in the View Service Status dialog box.","Exporting Projects using Primavera XER","101761.htm");
Page[11]=new Array("Configure Primavera XER templates to define data exchange options for both exporting to and importing from P6 Professional.","To configure Primavera XER templates:","Click Projects.","On the Projects navigation bar, click EPS.","On the EPS page:","Click the Actions&nbsp;@ menu and select Import/Export Projects.","In the Import/Export Projects dialog box, click the Import or Export tab.","On the Import tab:","In the Import Type list, select Primavera XER.","On the Import tab, click @&nbsp;Browse in the File field and select a Primavera XER file to import.","Click Manage Templates.","Or on the Export tab:","Click Manage Templates.","In the Manage Templates dialog box, click a template.","In the Modify Template dialog box","Configure the lists, options, and fields on each tab.","Click Save.","Configuring Primavera XER Templates","101762.htm");
Page[12]=new Array("You can import projects using the Microsoft Project XML format to create and manage them as new projects in P6.","Note","To import a project via XML using P6 or P6 Professional, your user account's Resource Access field must be set to All Resources. This change can be made temporarily and then restored on the Users pane on the User Access page.","Avoid using the pipe character ( | ), or brackets ( &lt; or &gt; ) in the Project Name. ","To import projects using the Microsoft Project XML format:","Click Projects.","On the Projects navigation bar, click EPS.","On the EPS page:","Click the Actions&nbsp;@ menu and select Import/Export Projects.","In the Import/ExportProject dialog box, click the Import tab.","On the Import tab:","In the Import Type list, select Microsoft Project XML.","In the File field, click @&nbsp;Browse.","In the File Upload dialog box, select a file and click Open.","On the Import tab:","Select a Template to use.","Note If you need to create a template or modify an existing template, click Manage Templates.","Select an option for Action.","If you selected Create New, click @&nbsp;Select in the Import To field and select the EPS where you want to import the XML file.","If you selected Update Existing Project, click Select in the Import To field and select the project where you want to import the XML file.","Select an EPS to element in the Import To field.","Click Import.","Tip","You can see the status of the import in the View Service Status dialog box.","You can import multiple projects as one file using Microsoft Project XML format.","Importing Projects using Microsoft Project XML","8010.htm");
Page[13]=new Array("You can export projects to locations outside of P6 using the Microsoft XML format to share information with Microsoft Project.","To export projects using Microsoft Project XML format:","Click Projects.","On the Projects navigation bar, click EPS.","On the EPS page:","Click the Actions&nbsp;@ menu and select Import/Export Projects.","In the Import/ExportProject dialog box, click the Export tab.","On the Export tab:","In the Export Type list select a Microsoft Project XML file type to export.","In the Project field, click @&nbsp;Select and select a project to export.","In the Template list select a template to use.","Note If you need to create a template or modify an existing template, click Manage Templates.","Click Export.","Tip","You can see the status of the import in the View Service Status dialog box.","The software automatically creates a UDF called MSP Activity ID the first time anyone exports a project to Microsoft Project format. This UDF is hidden and cannot be modified. You should avoid creating a UDF with that name.","Exporting Projects using Microsoft Project XML","43130.htm");
Page[14]=new Array("Configure Microsoft Project templates to define data exchange options for both exporting to and importing from Microsoft Project.","To configure Microsoft Project templates:","Click Projects.","On the Projects navigation bar, click EPS.","On the EPS page:","Click the Actions&nbsp;@ menu and select Import/Export Projects.","In the Import/Export Projects dialog box, click the Import or Export tab.","On the Import tab:","In the Import Type list, select Microsoft Project XML.","On the Import tab, click @&nbsp;Browse in the File field and select a Microsoft Project XML file to import.","Click Manage Templates.","Or on the Export tab:","In the Export Type list, select a Microsoft Project XML file type to export.","Click Manage Templates.","In the Manage Templates dialog box, click a template.","In the Modify Template dialog box","Configure the lists, options, and fields on each tab.","Click Save.","Tip","The area you select from the Select Subject Area list on the Custom Field Mapping tab determines what appears in the Project Management and Microsoft Project Fields.","Note Once data is exported from P6 into another project management tool, dates, durations and other data may no longer reflect those in P6 if the other project management tool recalculates this data.","Configuring Microsoft Project Templates","43970.htm");
Page[15]=new Array("You can export projects to locations outside of P6 using UN/CEFACT XML Format 6.","To export projects using UN/CEFACT XML Format 6:","Click Projects.","On the Projects navigation bar, click EPS.","On the EPS page:","Click the Actions&nbsp;@ menu and select Import/Export Projects.","In the Import/Export Project dialog box, click the Export tab.","On the Export tab:","In the Export Type field, select UN/CEFACT XML Format 6.","In the Project field, click @&nbsp;Select and select a project from the dialog box.","In the Template field, select a template.","Note If you need to create or modify a template, click the Manage Templates button.","Click Export.","Tip","You can see the status of the import in the View Service Status dialog box.","Exporting Projects using UN/CEFACT XML","89291.htm");
Page[16]=new Array("Configure UN/CEFACT templates to define data exchange options for exporting to UN/CEFACT XML Format 6.","To configure UN/CEFACT templates:","Click Projects.","On the Projects navigation bar, click EPS.","On the EPS page:","Click the Actions&nbsp;@ menu and select Import/Export Projects.","In the Import/Export Projects dialog box, click the Export tab.","On the Export tab:","Select UN/CEFACT XML Format 6 from the Export Type list.","Select a project.","Click Manage Templates.","In the Manage UN/CEFACT Templates dialog box:","Click a template or click @&nbsp;Add to create a new template.","In the UN/CEFACT Template dialog box:","Configure the lists, options, and fields on each tab.","Click Save.","Note Once data is exported from P6 into another project management tool, dates, durations and other data may no longer reflect those in P6 if the other project management tool recalculates this data.","Configuring UN/CEFACT Templates","89289.htm");
Page[17]=new Array("You can export projects to locations outside of P6 using IPMDAR Format. The IPMDAR export generates a collection of JSON files which constitute the IPMDAR data.","To export projects using IPMDAR:","Click Projects.","On the Projects navigation bar, click EPS.","On the EPS page:","Click the Actions&nbsp;@ menu and select Import/Export Projects.","In the Import/Export Project dialog box, click the Export tab.","On the Export tab:","In the Export Type field, select IPMDAR.","In the Project field, click @&nbsp;Select and select a project from the dialog box.","In the Template field, select a template.","Note If you need to create or modify a template, click the Manage Templates button.","Click Export.","Tip","You can see the status of the import in the View Service Status dialog box.","Exporting Projects using IPMDAR","100648.htm");
Page[18]=new Array("Configure IPMDAR templates to define data exchange options for exporting to IPMDAR format.","To configure IPMDAR templates:","Click Projects.","On the Projects navigation bar, click EPS.","On the EPS page:","Click the Actions&nbsp;@ menu and select Import/Export Projects.","In the Import/Export Projects dialog box, click the Export tab.","On the Export tab:","Select IPMDAR from the Export Type list.","Select a project.","Click Manage Templates.","In the Manage IPMDAR Templates dialog box:","Click a template or click @&nbsp;Add to create a new template.","In the IPMDAR Template dialog box:","Configure the lists, options, and fields on each tab.","Click Save.","Note Once data is exported from P6 into another project management tool, dates, durations and other data may no longer reflect those in P6 if the other project management tool recalculates this data.","Configuring IPMDAR Templates","100647.htm");
Page[19]=new Array("You can export projects to locations outside of P6 using CPP Format. The CPP format export generates a collection of JSON files which constitute the CPP data.","To export projects using CPP:","Click Projects.","On the Projects navigation bar, click EPS.","On the EPS page:","Click the Actions&nbsp;@ menu and select Import/Export Projects.","In the Import/Export Project dialog box, click the Export tab.","On the Export tab:","In the Export Type field, select DOE - CPP.","Click @&nbsp;Add&nbsp;Project... to select the projects you want to export.","Optionally, to remove a project from the export list, click @&nbsp;Row&nbsp;Actions and select Remove.","Select a project and click @&nbsp;Add&nbsp;Baseline... to select the baselines you want to export for that project.","In the Template field, select a template.","Note If you need to create or modify a template, click the Manage Templates button.","Click Validate&nbsp;@ to view the validation report.","Click Export.","Tip","You can see the status and download the export file in the View Service Status dialog box.","Exporting Projects using CPP","102062.htm");
Page[20]=new Array("Configure CPP templates to define data exchange options for exporting to CPP format.","To configure CPP templates:","Click Projects.","On the Projects navigation bar, click EPS.","On the EPS page:","Click the Actions&nbsp;@ menu and select Import/Export Projects.","In the Import/Export Projects dialog box, click the Export tab.","On the Export tab:","Select DOD - CPP from the Export Type list.","Select a project.","Click Manage Templates.","In the Manage CPP Templates dialog box:","Select a template or click @&nbsp;Add to create a new template or @&nbsp;Import&nbsp;Template to import a template.","Note To export a CPP template, select @&nbsp;Row&nbsp;Actions and select Export.","In the CPP Template dialog box:","Configure the lists, options, and fields on each tab.","Note To export the full path of a code value (that is the path to a code value's place in its hierarchy), in the code value picker, mark the Include code value path option. When this option is selected, each hierarchical level of the path to the code value is separated with a dot. For example, ENG.Elec.Micro.Interface.","Click Save.","Note Once data is exported from P6 into another project management tool, dates, durations and other data may no longer reflect those in P6 if the other project management tool recalculates this data.","Configuring CPP Templates","102063.htm");
Page[21]=new Array("You can import projects and baselines from compressed zip file that contains a file using the Primavera XML format. If the zip file contains multiple XML files, only the file with the same name as the zip will be imported. If the zip contains only one XML file, the name of the zip and XML file need not match.","To import projects from a zipped file:","Click Projects.","On the Projects navigation bar, click EPS.","On the EPS page:","Click the Actions&nbsp;@ menu and select Import/Export Projects.","In the Import/ExportProject dialog box, click the Import tab.","On the Import tab:","In the Import Type list, select Primavera XML.","In the File field, click @&nbsp;Browse.","In the File Upload dialog box, select a zipped file containing an XML file and click Open.","On the Import tab:","Select a Template to use, configure the Import Actions for each project, and optionally select which baselines to import.","Click Import.","Tip","You can see the status of the import in the View Service Status dialog box.","Importing Projects from a Zip File","101430.htm");
Page[22]=new Array("You can export projects to a compressed file. The resulting zip file contains a single Primavera XML file that describes the projects you selected to export.","To export projects to a compressed file:","Click Projects.","On the Projects navigation bar, click EPS.","On the EPS page:","Click the Actions&nbsp;@ menu and select Import/Export Projects.","In the Import/ExportProject dialog box, click the Export tab.","On the Export tab:","In the Export Type field, select Primavera XML.","Select the Export to zip option.","Click @&nbsp;Add&nbsp;Project..., and in the Select Project dialog box select the projects to export then click Select.","In the Baselines field, click and select which baselines you want to include with the export.","Click Export.","Tip","To download the exported file, click the link in the View Service Status tab or Notifications dialog box.","Exporting Projects to a Zip File","101431.htm");
Page[23]=new Array("You can import some types of data from a spreadsheet format.","Importing from a Spreadsheet","98048.htm");
Page[24]=new Array("You can import new activities into a P6 project from a Microsoft Excel (.xlsx) file. Create an import template, fill in the data you want to import, and save the file before before completing these steps.","To import activities:","Click Projects.","On the Projects navigation bar, click Activities.","On the Activities page:","Click the Actions&nbsp;@ menu and select Import and then select Import from Excel.","In the Import Activities dialog box:","Click @&nbsp;Browse in the Import File field and select a file from the dialog box.","Click @&nbsp;Select in the Select Project field and select a project from the dialog box.","Click Import.","On the Activities page, click Save.","Tip","The import file must be in Microsoft Excel (.xls or .xlsx) format.","Importing Activities","7916.htm");
Page[25]=new Array("Create a Microsoft Excel template to use when importing new activities into a P6 project. ","To create import templates:","Click Projects.","On the Projects navigation bar, click Activities.","On the Activities page:","Click @&nbsp;Customize&nbsp;View.","In the Customize View dialog box:","Click the Columns tab.","Move the columns you want in the import template to the Selected Columns list.","Click Apply.","In the Activities page, click Save View.","Click the Actions&nbsp;@ menu and select Import and then select Create Import Template.","When prompted, choose whether to open or save the file.","Tip","The import template is created as a Microsoft Excel file with the default file name, ExportDataToSpreadsheet.","When you select columns for your activity view, include Activity ID or Activity Name to ensure that these fields are added to the import file spreadsheet. These fields are required in the spreadsheet to ensure that activities added during import are uniquely identified in your project when the import has completed.","If a duplicate activity name exists, it will be added again as a new activity.","In the import file, column order is irrelevant and the data fields you import are not required to match the columns in your current activity view. Data for import is identified by the internal names of the data fields in the first row of the spreadsheet.","The import process will start at the first tab of the import file, regardless of the tab name.","Blank rows are ignored.","The import file contains two rows of column headings that match the columns you previously selected to display in the table or Gantt chart. The first row of headings identify the data to be imported into each column of your activity view. Do not change the content in columns of the first row. The second row contains descriptive information that is not used by the import process. You can modify the content in the second row.","If values are not provided for mandatory fields, such as the date field, a default value will be set and corresponding data will be imported.","Although the activity view is limited to 30 columns, you can add columns to your spreadsheet to import more than 30 fields of data.","All activity fields except for non-editable fields are available for import. Examples of non-editable fields include: expenses, notebook topics, predecessors, resource IDs, resource names, role IDs, steps, and successors. Non-editable columns display an asterisk (*). You cannot import data for these fields. At least one editable field must be provided in a row of the import file for an activity to be imported.","If an Enterprise Data field value does not exist for a Global Activity Code, Enterprise Project Structure (EPS) Activity Code, Project Activity Code, Calendar, Cost Account, or Primary Resource, the assignment will not be added. ","Secure activity codes are not imported, even if the column exists in the spreadsheet.","Durations with abbreviations that match the abbreviations set on the Time Periods page of the Application Settings page are imported.","Creating Import Templates for Importing Activities","7915.htm");
Page[26]=new Array("You can import new locations into P6 from a Microsoft Excel (.xlsx) file.","To import locations:","Click Administration.","On the Administration navigation bar, click Enterprise Data.","On the Enterprise Data page, expand Global and click Locations.","On the Locations page, clickActions&nbsp;@ and select Import from Excel.","In the Import Locations dialog box:","In the Import File field, click @&nbsp;Select and select a file.","Click Import.","In the import confirmation message box, click OK.","Tip","Click Actions&nbsp;@ and select Create Import Template to download a template file ready for you to populate with data.","When you import a project in Primavera XML format, if you choose to import locations any locations assigned in the project will be imported.","Importing Locations","51671.htm");
Page[27]=new Array("Create a Microsoft Excel template to use when importing location data.","To create an import template:","Click Administration.","On the Administration navigation bar, click Enterprise Data.","On the Enterprise Data page, expand Global and click Locations.","On the Locations page, click the Actions&nbsp;@ menu and select Create Import Template.","In the File Download dialog box, click Open to modify the template or click Save to save it.","Tip","The import template is created as a Microsoft Excel file with the default file name, ExportDataToSpreadsheet.","The top two rows of the spreadsheet are required when importing data locations from a spreadsheet. Do not change the data in these rows.","Creating Import Templates for Importing Locations","54238.htm");
Page[28]=new Array("You can import enterprise data into P6 from a spreadsheet. This is useful if you need to modify or add new enterprise data using the features of a spreadsheet application.","To import enterprise data:","Click Administration.","On the Administration navigation bar, click Enterprise Data.","Click Import/Export Enterprise Data.","In the Import/Export Enterprise Data dialog box, click the Import tab.","On the Import tab:","Click in the File field and click @&nbsp;Select, then browse to and select the file to import.","Select the data types to import.","Click Import.","Tip","You must have the appropriate data access and permissions to import data from a spreadsheet.","Calendars and risk thresholds cannot be imported.","You cannot delete data from the Enterprise Data page using the import feature.","When the import process is complete, you can download a copy of the input file from the View Service Status dialog box to view the Status and Remarks columns. The Status column shows a value for each row in the file. If the status column shows Added or Updated the data on that row was added or updated successfully. If the status column shows Added - Failed or Updated - Failed, the import for that row failed and further information is given in the Remarks column.","Importing Enterprise Data","98140.htm");
Page[29]=new Array("P6 can import Excel files in either .xls or .xlsx format. The import file must be in the correct format to be imported successfully. The following must be true for the file to be imported:","Each data type must be contained in a separate worksheet in the file.","The worksheets must contain the names of the data types exactly as they appear in the tabs on the Enterprise Data page. Worksheets which do not match the names of data types in the Enterprise Data page will not be imported.","The first two rows of each worksheet in the file must contain the database column name and human readable column name of each of the data attributes to be imported.","Duplicate rows will overwrite earlier rows when you import the file. Rows are identified by the primary keys for the data type. If two rows have the same data in the primary key fields they are duplicate rows.","It is possible for a row to have multiple data errors, however import of a row will fail at the first data error encountered on a row. The results column explains the cause of the import failure so that you can correct the data and import the file again. It might be necessary to import a file several times before a row with multiple data errors can be added or updated.","Note Oracle recommends that you create an import file by exporting the relevant data types first. If you intend to import data frequently, it is good practice to create an export file containing all data data types and protect the first two rows on each sheet and the worksheet names before populating the file with the data to be imported.","Creating an Import File","98155.htm");
Page[30]=new Array("This topic provides information about the rules for each of the columns on each of the worksheets in the import file.","Note Except in the case of mandatory columns, if no data is provided for a column or there is an error in the data supplied in a column, the default will be used wherever possible.","Baseline Types","You must provide a value for Type. If this column is empty or populated with unrecognizable data, the row will be ignored. If this column is missing, the sheet will be ignored.","When importing, if matching data is found in the database, the row is used to update the row in the database. Matching is not case sensitive.","Codes: Activity Codes (global, project, and EPS), Project Codes, and Resource Codes","You must provide a value for Code Name and Code Value Name. If the row represents a code value, you must also provide a value for Parent Code Name. If these columns are empty or populated with unrecognizable data, the row will be ignored. If these columns are missing, the sheet will be ignored.","When importing, if matching data is found in the database for Code Name or Code Value Name the row is used to update that code or value. If no matching Code or Code Value is found, the row is used to add a new code or value. The Code Value Name is case sensitive.","The Type must contain either Code or CodeValue. If the Type is CodeValue, the Parent Code Name column must contain the Name of the code for which this row is a value.","If the Color column is populated, the values must match the name of the color as shown in the application. To see the name of the color in the application, double click the color column on any activity code in the Enterprise Data page and hover over the color.","Cells which contain attributes which are represented with options in the application can include either true or false, or 1 or 0.","The code hierarchy is represented using the Parent Code Name and Parent Code Value Name columns. If the row represents a code value at the top level of the activity code, the Parent Code Name column must contain the name of the parent code as it appears in column A. If the row represents a code value that is not at the top level of the activity code hierarchy, the Parent Code Value Name column must also contain the name of the code value under which the data item will be imported.","Codes: Issue Codes","You must provide a value for Name and Type. If the row represents a code value, you must also provide a value for Parent Code Name. If these columns are empty or populated with unrecognizable data, the row will be ignored. If these columns are missing, the sheet will be ignored.","When importing, if matching data is found in the database for Name the row is used to update that code or value. If no matching Code or Code Value is found, the row is used to add a new code or value. The Code Value Name is case sensitive.","The Type must contain either Code or CodeValue. If the Type is CodeValue, the Parent Code Name column must contain the Name of the code for which this row is a value.","The Secure column can contain either true or false, or 1 or 0.","The code hierarchy is represented using the Parent Code Name column. If the row represents a code value at the top level of the issue code hierarchy, the Parent Code Name column must contain the name of the parent code as it appears in column A. If the row represents a code value that is not at the top level of the issue code hierarchy, the Parent Code Value Name column must also contain the name of the code value under which the data item will be imported.","Codes: Overhead Codes","You must provide a value for Name and Description. If these columns are empty or populated with unrecognizable data, the row will be ignored. If these columns are missing, the sheet will be ignored.","When importing, if matching data is found in the database for Name the row is used to update that code. If no matching code is found, the row is used to add a new code.","Cost Accounts","You must provide a value for Id and Name. If these columns are empty or populated with unrecognizable data, the row will be ignored. If these columns are missing, the sheet will be ignored.","When importing, if matching data is found in the database for both Id and Name the row is used to update the other columns in the database. If matching data is found in the Id and Parent Cost Account columns, but not the Name column, the row is used to update the Name column. If no matching ID or Name value is found, the row is used to add a new cost account.","The cost account hierarchy is represented using the Root Cost Account and Parent Cost Account columns. If the row represents a cost account at the top level of the hierarchy, the Root Cost Account column must be blank. If the row represents a cost account that is not at the top level of the cost account hierarchy, the Root Cost Account row must contain the Id of the cost account under which the data item is to be imported. Optionally, if the row represents a cost account that is not at the top level of the cost account hierarchy, the Parent Cost Account column can contain the Id of the cost account under which the data item is to be imported.","Currencies","You must provide a value for Id, Name and Currency Symbol. If these columns are empty or populated with unrecognizable data, the row will be ignored. If these columns are missing, the sheet will be ignored.","When importing, if matching data is found in the database for both Id and Name the row is used to update the other columns in the database.","The currency symbol can be one, two, or three characters and must not contain digits.","The decimal symbol and digit grouping symbol can both be either a period or comma. You cannot use the same symbol for both the decimal and digit grouping symbols.","The exchange rate specifies the rate between the base currency in the database and the currency being imported or updated. The base currency value is multiplied by the exchange rate to calculate the values displayed in cost fields.","Document Categories","You must provide a value for Name. If this column is empty or populated with unrecognizable data, the row will be ignored. If this column is missing, the sheet will be ignored.","When importing, if matching data is found in the database for Name, the row is used to update that category. If no matching code is found, the row is used to add a new category. Matching is not case sensitive.","Document Status","You must provide a value for Name. If this column is empty or populated with unrecognizable data, the row will be ignored. If this column is missing, the sheet will be ignored.","When importing, if matching data is found in the database for Name, the row is used to update that status. If no matching code is found, the row is used to add a new status. Matching is not case sensitive.","Financial Period Calendars","When importing from Excel, you can only create new financial periods.","You must provide a value for Name, Start Date, and Finish Date. If these columns are empty or populated with unrecognizable data, the row will be ignored. If these columns are missing, the sheet will be ignored.","The start date must be one day later than the finish date of the latest defined financial period in the database. Financial periods must be at least 7 days long and must not overlap.","You cannot update or replace the assignment of a financial period calendar to a project by importing using the Update Existing option.","Financial periods for a financial period calendar must be contiguous, meaning that there must not be a gap between financial periods.","The Start Date and Finish Date columns must be configured to use a numeric date format in the Excel import sheet. Dates provided in text format are not recognized.","Funding Sources","You must provide a value for Name. If this column is empty or populated with unrecognizable data, the row will be ignored. If this column is missing, the sheet will be ignored.","When importing, if matching data is found in the database for Name the row is used to update the other columns in the database. If no matching Name value is found, the row is used to add a new funding source.","The funding source hierarchy is represented using the Parent Funding Source column. If the row represents a funding source that is not at the top level of the funding source hierarchy, the Parent Funding Source column must contain the Name of the funding source under which the data item is to be imported.","You can move a funding source to a different parent on import by entering the Name of the new parent in the Parent Funding Source column.","Locations","You must provide a value for Name, Latitude, and Longitude. If these columns are empty or populated with unrecognizable data, the row will be ignored. If these columns are missing, the sheet will be ignored.","When importing, if matching data is found in the database for both Name the row is used to update the other columns in the database.","The Country column must contain the name of a country as it appears in the database. To see a list of the countries that appear in the database, view the Country list in the Add Location dialog box in P6.","The Latitude column must contain data in the range of &quot;-90&quot; to &quot;90&quot; or &quot;90S&quot; to &quot;90N&quot;.","The Longitude column must contain data in the range of &quot;-180&quot; to &quot;180&quot; or &quot;180W&quot; to &quot;180E&quot;.","The Name field can accept up to 255 alphanumeric characters or symbols. The Street and Street 2 fields can accept up to 200 alphanumeric characters. The Postal Code field can accept up to 20 alphanumeric characters.","Notebook Topics","You must provide data for Topic Name, as well as the value &quot;True&quot; or &quot;1&quot; for at least one of the following columns: EPS, Project, WBS, or Activity.","When importing, if matching data is found in the database for Topic Name the row is used to update the other columns in the database.","The Topic Name field can accept up to 40 alphanumeric characters or symbols.","The EPS, Project, WBS, and Activity fields can accept values of &quot;True&quot; and &quot;False&quot; or &quot;1&quot; and &quot;0&quot;. Null values are considered to be False or 0. The EPS, Project, WBS, and Activity fields cannot be changed to false after a notebook item of the selected type has been assigned at that level.","Risk Categories","You must provide a value for Name. If the row represents a category that is not at the root level of the hierarchy, you must also provide a value for Parent Risk Category. If the Name column is empty or populated with unrecognizable data, the row will be ignored. If the Name column is missing, the sheet will be ignored.","When importing, if matching data is found in the database for Name, the row is used to update that category. If no matching Name is found, the row is used to add a new category. Matching is not case sensitive.","The hierarchy is represented using the Parent Risk Category column. If the row represents a category at the top level of the hierarchy, the Parent Risk Category column must contain the name of the parent category.","Resource Curves","You can import and update only global resource curves. You cannot update default resource curves.","You must provide a value for Name. If the Name column is empty or populated with unrecognizable data, the row will be ignored. If the Name column is missing, the sheet will be ignored.","The Duration % columns can accept numeric values and the percent symbol only.","The import and update processes do not verify that the total of all the Duration % columns equal 100%.","Step Templates","You must provide a value for Template Name,.Step Name, and Type. If these columns are empty or populated with unrecognizable data, the row will be ignored. If these columns are missing, the sheet will be ignored.","When importing, if matching data is found in the database for Template Name,.Step Name, Type, and Parent Step Template Name the row is used to update the other columns in the database. If no matching Template Name,.Step Name, Type, and Parent Step Template Name values are found, the row is used to add a new step template.","You cannot import data to the Step Count column.","Weight can be between 0 and 999,999.","Type can be either Step Template or Step.","The step hierarchy is represented using the Parent Step Template Name column. If the row represents a step, the Parent Step Template Name column must contain the Name of the step template under which the data item is to be imported.","Timesheet Periods","You can only create new timesheet periods by importing from Excel.","You must provide a value for Start Date and Finish Date. If these columns are empty or populated with unrecognizable data, the row will be ignored. If these columns are missing, the sheet will be ignored.","Timesheet periods must not overlap, but need not be contiguous.","The Start Date and Finish Date columns must be configured to use a numeric date format in the Excel import sheet. Dates provided in text format are not recognized.","Units of Measure","You must provide a value for Unit Abbreviation and Unit Name. If these columns are empty or populated with unrecognizable data, the row will be ignored. If these columns are missing, the sheet will be ignored.","When importing, if matching data is found in the database for Unit Abbreviation or Unit Name the row is used to update the other column in the database. If no matching Unit Abbreviation or Unit Name values are found, the row is used to add a unit of measure. Matching is not case sensitive.","User Defined Fields (Activity, Assignment, Resource, WBS, Risk, Expense, Step, Issue, Document)","You must provide a value for User Defined Field and Data Type. If these columns are empty or populated with unrecognizable data, the row will be ignored. If these columns are missing, the sheet will be ignored.","The User Defined Field is limited to a maximum of 40 alphanumeric characters (including special characters).","When importing, matching is determined by the data in the User Defined Field column. If matching data is found in the database for User Defined Field the row is used to update that UDF, otherwise the row is used to add a new UDF. Matching is not case sensitive.","If no data, or unrecognizable data, is provided in the Data Type column, the UDF is imported with the data type of Text.","The data type for a UDF cannot be changed once data has been entered for that UDF anywhere in the application.","The Data Type column must contain one of these values: text, start date, finish date, cost, number, integer, or indicator. The data type is not case sensitive.","WBS Categories","You must provide a value for Category. If this column is empty or populated with unrecognizable data, the row will be ignored. If this column is missing, the sheet will be ignored.","When importing, if matching data is found in the database for Category the row is used to update the other columns in the database. If no matching Category value is found, the row is used to add a new WBS category.","Enterprise Data Import Format","98156.htm");
Page[31]=new Array("You can import enterprise data to create and update your enterprise data dictionaries more efficiently.","Note","Oracle recommends always working from a recently exported copy of your enterprise data.","When you export your existing enterprise data, the resulting XLSX file includes a separate tab for each page of enterprise data page. You can modify or create new data in the spradsheet by modifying or adding to rows three and later. Be careful to follow the existing format of data in the spreadsheet.","To import enterprise data:","Click Administration.","On the Administration navigation bar, click Enterprise Data.","Click Import/Export Enterprise Data.","On the Export tab:","Select the types of enterprise data to export.","Click Export.","Your browser might require you to approve the download of the file.","Open the exported file and enter or update the data on rows three and later.","Note","Do not change or delete any of the data in rows one and two of each tab in the XLSX file.","Click Import/Export Enterprise Data.","On the Import tab:","In the File field, click @&nbsp;Browse.","Select the types of enterprise data to import.","Click Import.","Tip","You can't delete enterprise data by importing an XLSX file.","The ability to import and export Enterprise data as described here, replaces previous import and export processes that relied on the P6 Professional SDK using a macro-enabled Excel file. Primavera SDK was a 32-bit technology and has not been supported since release 18.8. Many platforms (including Microsoft Excel) restrict macro use by default, to help protect your data against unintended macro activity. Therefore importing and exporting enterprise data using the method described here offers improved security over the use of the P6 Professional SDK tool.","Importing and Exporting Enterprise Data","112996.htm");
Page[32]=new Array("You can export some types of data to a spreadsheet format.","Exporting to a Spreadsheet","98047.htm");
Page[33]=new Array("You can export the list of projects in your EPS view to a Microsoft Excel (.xlsx) file.","To export projects:","Click Projects.","On the Projects navigation bar, click EPS.","On the EPS page:","Select an EPS view from the Views list.","Configure the EPS view to determine what data is exported.","Click @&nbsp;Download.","In the Opening dialog box, choose whether to open or save the file.","Tip","All data is exported as it appears in the current EPS view.","Exporting Projects to Excel","45522.htm");
Page[34]=new Array("You can export activity data to a Microsoft Excel (.xlsx) file.","To export activities:","Click Projects.","On the Projects navigation bar, click Activities.","On the Activities page:","Click @&nbsp;Customize&nbsp;View.","In the Customize View dialog box:","Click the Columns tab.","Move the columns you want in the import template to the Selected Columns list.","Click Apply.","In the Activities page, click Save View.","Click @&nbsp;Download.","When prompted, choose whether to open or save the file.","Tip","All data, including grouping row information, is exported as it appears in the activity table or the activity grid.","Exporting Activities to Excel","7876.htm");
Page[35]=new Array("Resource information, including resource unit and cost allocation data, high-level planning information, and resource and role usage information can be saved to a Microsoft Excel spreadsheet (*.xlsx).","All data is exported as it appears in the current view. Customize the rows using the customization options on the page, which are either a customize link or a customize columns button, to display only the data you want to export.","Use the following tasks to export data from the Resources section:","Exporting Resource Administration Data ","Exporting Resource Assignment Data","Exporting Resource or Role Usage Data ","Exporting Resource Data","8027.htm");
Page[36]=new Array("Perform these steps to save customized resource or role information to a Microsoft Excel spreadsheet (*.xlsx) for a single resource or multiple resources. All data is exported as it appears in the current view.","To export resource or role data:","Click Resources.","On the Resources navigation bar, click Administration.","On the Administration page, click either the Resources or Roles tab.","On the Resources or Roles tab: ","Click @&nbsp;Customize&nbsp;View. ","In the Customize View dialog box:","Configure the columns to be exported.","Configure the sorting options.","Expand resources or roles until all the resources or roles you want to view is visible.","Click @&nbsp;Download.","When prompted, choose whether you want to open or save the export file.","To export resource team or role team data:","Click Resources.","On the Resources navigation bar, click Administration.","On the Administration page, click either the Resource Teams or Role Teams tab.","On the Resource Teams or Role Teams tab:","Expand the Global group if you want to export Global team data. ","Expand the User group if you want to export User team data. ","Click @&nbsp;Download.","Exporting Resource Administration Data","34653.htm");
Page[37]=new Array("Perform these steps to save customized detailed resource assignment information to a Microsoft Excel spreadsheet (*.xlsx). All data is exported as it appears in the current view.","To export resource assignment data:","Click Resources.","On the Resources navigation bar, click Assignments.","On the Assignments page:","Click @&nbsp;Customize&nbsp;View to customize the table. The fields that are visible on the page are the fields that are exported to the Excel spreadsheet.","Click @&nbsp;Download.","When prompted, choose whether you want to open or save the export file.","Exporting Resource Assignment Data","34636.htm");
Page[38]=new Array("Perform these steps to save customized resource or role usage data from the Resources Analysis section to a Microsoft Excel spreadsheet (*.xlsx). All spreadsheet rows and the entire visible timescale are exported.","To export resource or role usage data:","Click Resources.","On the Resources navigation bar, click Analysis.","On the Analysis page, click the Resource button or the Role button.","In the Resource view or the Role view:","Click the Group By list and select a group type option.","The resources available depend on your selection, along with your resource security settings. If you select an individual resource, the spreadsheet displays allocation data for that resource. If the resource is a parent resource, you can select the resource's children (if any); if the resource is a child resource, no other resources are available.","If you select a resource code, resource team, or primary role on the Resource Usage tab, the spreadsheet displays summary allocation data for the code, team, or role; you can select an individual resource belonging to the code, team, or role. When you select a code, team, or role, you can only view allocation data for resources that you have access rights to view; resources you do not have access rights to view are not listed.","Click a resource, role, code, or team name. ","In the Spreadsheet expand the roles or resources to show all the data you want to export.","Note Only data which is visible in the spreadsheet will be exported.","Click @&nbsp;Customize&nbsp;View. ","In the Customize View dialog box:","On the General tab:","In the Display list, choose whether to display units or costs.","In the Timescale list, select a timescale.","Configure a date range for the spreadsheet.","On the Spreadsheet tab:","Configure the Display Fields for the resource or role data","Choose whether to show the Allocation Limit.","Choose whether to show the Limit.","Note A setting in your preferences determines whether the role limit includes the limits of resources assigned that role, but that are currently set as inactive.","Click Apply.","In the Resource or Role view, click @&nbsp;Download.","When prompted, choose whether you want to open or save the export file.","Tip","An application level setting determines whether cost spreads account for changes in resource and role rates over time.","For units display, if a resource code or resource team consists only of material resources with differing units of measure or a mix of labor, nonlabor, and material resources, the spreadsheet summary row displays dashes instead of totals. Summing unit values for mixed resource types does not provide an accurate total because labor and nonlabor resources are usually associated with time (such as hours or days), and material resources are often expressed in non-time units of measure.","Exporting Resource or Role Usage Data","34644.htm");
Page[39]=new Array("Risk data can be saved to an Excel spreadsheet (*.xlsx). All data is exported as it appears in the current view. Customize the rows to display only the data you want to export.","To export risk data:","Click Projects.","On the Projects navigation bar, click Risks.","On the Risks page, click @&nbsp;Customize&nbsp;View to configure the fields, grouping, sorting and filtering to show in the exported file.","Click @&nbsp;Download.","Exporting Risk Data","36553.htm");
Page[40]=new Array("You can export enterprise data to a spreadsheet.","To export enterprise data:","Click Administration.","On the Administration navigation bar, click Enterprise Data.","Click Import/Export Enterprise Data.","In the Import/Export Enterprise Data dialog box,click the Export tab.","On the Export tab:","Select the data types to export.","On the Export tab, click Export.","Tip","Calendars and risk thresholds cannot be exported.","Exported files are saved in your browser's default download location.","Exporting Enterprise Data","98139.htm");
Page[41]=new Array("Perform these steps to save a customized list of available reports to a Microsoft Excel spreadsheet.","All data is exported as it appears in the current view.","To export a list of reports:","Click Reports.","On the Reports page:","Click the Reports or Schedules tab.","Modify the table to view only the list of reports you want to export.","Expand or collapse group headings. ","Click Export.","When prompted, choose whether you want to open or save the export file.","Exporting a List of Reports","45523.htm");
Page[42]=new Array("Configure the Activities page and the Customize Activity View or Manage Views dialog box to customize the views that display the project and activity data you require in a format that meets your needs. You can save these settings with the view. Save the changes if you want them to appear the next time you work with the view. Do not save the changes if you only want your alterations to last for the session.","The view list provides quick and easy access to all activity views that are available to you. While working with activities, choosing the best view for your needs can facilitate the process of recording project data.","You can configure the content and organization of any activity view you create. For activity views you can access but did not create, you can review activity view settings, but you cannot make changes.","Note On the Activities page, to quickly rearrange the columns currently displayed in a view, drag and drop them.","Your ability to perform certain actions in a view depends on the access class of the view, your role as either creator or user of the view, and your security profile. For example, if a multiple user or global view includes cost data elements and the current user does not have rights to view costs, the data is dashed out so it is not visible to the user.","You can group all activities that contain the same value for a specific data field. For example, if you choose to group by Project then by Primary Resource, the Activities page groups activities in project groupings. Then, within each project group, activities are further categorized according to primary resource. Finally, within each primary resource group, activities are sorted based upon the sort field and sort order you specify, for example Start Date. You can sort EPS, Activities, and Assignments views by up to five columns.","In the Gantt chart, when you group activities, a summary bar appears for each group. You can expand and collapse the group as needed to focus only on the project Summary Schedule or on the Detailed Schedule. In the table, when you group activities, each grouping level is identified and separated by a colored  band or background. You can elect to show aggregates, for each group.","You can export and import views to share them with colleagues working in another P6 system. ","Working with Activity Views","6686.htm");
Page[43]=new Array("Export views to share them with colleagues working in another P6 system.","To export views:","Click Projects or Resources.","On the Projects navigation bar, click Activities, EPS, or Assignments.","On the Resources navigation bar, click Assignments.","Click the Views&nbsp;@ menu and select Import/Export Views.","Click the Export tab.","On the Export tab:","Select whether to export Classic Views or Standard Views.","Select the views to export.","Note Use the Select All / Deselect All option to select all views available to you. You cannot export both classic and standard views to the same file.","Click Export.","In the download window, specify a location and name for the file.","Exporting Views","95789.htm");
Page[44]=new Array("Import views to see the EPS, Activities, and Assignments views used by colleagues in another system. ","Click Projects or Resources.","On the Projects navigation bar, click Activities, EPS, or Assignments then in the Activities or EPS pages.","On the Resources navigation bar, click Assignments.","Click the Views&nbsp;@ menu and select Import/Export Views.","Click the Import tab.","On the Import tab:","Select @&nbsp;Select in the Import File field and select the file to import..","Select the views to import from the file.","Click Import.","Tip","Global and user views are always imported as user views. Multiple user views are imported as multiple user views. If you have sufficient privileges, you can make views global after you have imported them by copying or moving them to the Global section in Manage Views.","Importing Views","95790.htm");
var PageCount=45;


/*
Date: 12/11/2025 7:46 PM
Source: EPPM_25_dev
BookID: 98032
PubProduct: PRIMAVERA_EPPM
BookTitle: Importing and Exporting Guide
Version: Version 25
Lang:	en
*/
	var PageLength=Page.length;
	var Result = "";
	var ResultTemp = "";
	var ResultFound = "";
	var ResultTitleOnly = [];
	var ResultTitleAndContent = [];
	var ResultInContent = [];
	var ResultInContentTemp = [];

	var ResultCombinedTemp = [];
	var ResultCombined = [];

	var arrayIndex = 0;
	var NrRes = 0;
	var j = 0;
	var i = 0;
	var k = 0;
	var d = 0;
	var maxItems = 1000;
	var heading = 0;
	var WordPos = -1;
	var WordPosHeading = -1;
	var WordPosContentText = -1;
	var FoundWord = "";
	var FoundWordHead = "";
	var SearchInHeadingOnly = 0;
	var isChecked;
	var size = 10;
	var resGroupCounter = 0;
	var shown = "shown";
	var checkBoxInHeading;
	var searchFlag = 0;
	var DivResult;
	var SearchWord;

if (SearchText && SearchText.length >= 1) {
		SearchWord = SearchText.replace(/\+/g, " ").replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;");
		searchFlag = 1;
	} else {
		SearchWord = "";
		searchFlag = 0;
	}
	

	if (searchFlag === 1) {
		Result = "";

		// checkBoxInHeading = document.getElementById("inHeading");
		if (inHeading) {

			isChecked = true;
		} else {

			isChecked = false;
		}

		if (SearchWord && SearchWord.length >= 1) {
			if (isChecked) {
				SearchInHeadingOnly = 1;
			} else {
				SearchInHeadingOnly = 0;
			}
			SearchWord = SearchWord.toLowerCase();
			window.status = "Searching, please wait...";
			for (j = 0; j < PageLength; j++) {
				k = Page[j].length - 1;
				for (i = 0; i < k; i++) {

					heading = k - 1;

					if (SearchInHeadingOnly === 1) {
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPosHeading > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);

							NrRes++;
							ResultTemp = "<li>";
							ResultTemp += "<span>";
							ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							ResultTitleOnly[arrayIndex] = ResultTemp;
							arrayIndex++;

							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}
					} else if (SearchInHeadingOnly === 0) {
						WordPos = Page[j][i].toLowerCase().indexOf(SearchWord);
						WordPosHeading = Page[j][heading].toLowerCase().indexOf(SearchWord);
						if (WordPos > -1) {
							FoundWordHead = Page[j][heading].substr(WordPosHeading, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							FoundWord = Page[j][i].substr(WordPos, SearchWord.length);
							NrRes++;
							ResultTemp += "<li>";
							ResultTemp += "<span>";
							if (WordPosHeading > -1) {
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading].replace(FoundWordHead, FoundWordHead.bold()) + "</a><br/>\n";
							} else {
								// found word is not in the head
								ResultTemp += "<a href='" + Page[j][k] + "'>" + Page[j][heading] + "</a><br/>\n";

							}
							if (i < k - 1) {
								WordPosContentText = Page[j][i].toLowerCase().indexOf(SearchWord);

								if (Page[j][i].length > 300 && (WordPosContentText > -1)) {

									if (WordPosContentText > 75) {
										ResultInContentTemp.push("..." + Page[j][i].substr(WordPosContentText - 75, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");
									} else {
										ResultInContentTemp.push("..." + Page[j][i].substr(0, 175 + FoundWord.length).replace(FoundWord, FoundWord.bold()) + "...");

									}

								} else if (WordPosContentText > -1) {

									ResultInContentTemp.push(Page[j][i].replace(FoundWord, FoundWord.bold()));

								}
							}

							ResultTemp += ResultInContentTemp.join("");

							ResultTemp += "</span>";
							ResultTemp += "</li>";

							if (WordPosHeading > -1) {
								ResultTitleAndContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							} else {
								ResultInContent[arrayIndex] = ResultTemp;
								arrayIndex++;
							}

							ResultInContentTemp.length = 0;
							ResultTemp = "";
							WordPosHeading = -1;
							WordPosContentText = -1;
							break;
						}

					}
				}
			}

			ResultTitleOnly = ResultTitleOnly.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultTitleAndContent = ResultTitleAndContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});
			ResultInContent = ResultInContent.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			ResultCombinedTemp = ResultTitleOnly.concat(ResultTitleAndContent, ResultInContent);

			ResultCombinedTemp = ResultCombinedTemp.filter(function (n) {
				return (n !== undefined && n !== null);
			});

			for (d = 0; d < ResultCombinedTemp.length; d += size) {
				resGroupCounter++
				ResultCombined.push("<div id=" + "'" + "resGroup_" + resGroupCounter + "'" + " class=" + "'" + "resGroup " + shown + "'" + ">" + "<ol class='searchResults'>" + ResultCombinedTemp.slice(d, d + size).join("") + "</ol></div>");
				shown = "notshown";
			}

			ResultFound = ResultCombined.join("");

Result += "<div id='searchDetailsDiv'>";
			Result += "<p class='searchDetails'>Your Search Found&nbsp;" + NrRes + "&nbsp;items.&nbsp;";
			Result += "</p></div>";
			
			Result += "<div class='searchResultsDiv'>";
			Result += "<div id='resultsCollection' class='searchResults'>";
			Result += ResultFound;
			Result += "</div>";
			Result += "</div>";
			Result += "<div class='searchPaging'>";

			Result += '<hr />';

			Result += '<p class="bodytext"><a class="disabledAnchor" id="pBack" onclick="turnPage(\'backPage\')" href="#pBack">Back</a>&nbsp; | &nbsp;';
			
			if (resGroupCounter && resGroupCounter > 1) {
				Result += '<a id="pNext" onclick="turnPage(\'nextPage\')" href="#pNext">Next</a>';
			} else {
				Result += '<a id="pNext"  class="disabledAnchor" href="#pNext">Next</a>';
			}
			Result += '</p>\n';
			Result += '<div id="pagenofn"><p class="bodytext">Page <span id="pagen">1</span> of ' + resGroupCounter + '</p></div>';

			Result += "</div>";
			
			
		}

		DivResult = document.getElementById("s_anchor");
		if (Result && DivResult) {

			//myDivResult.append(Result);
			DivResult.innerHTML = Result;
			

		}
		window.status = "";
		
		

	}
	}())
}
