/* ----- Cross Browser functions ------- */
var _IE = /msie \d/.test(window.navigator.userAgent.toLowerCase());

if(!_IE) {			   
    // innerText getter and setter property for Firefox
    Element.prototype.__defineGetter__("innerText", function() {return this.textContent; });
    Element.prototype.__defineSetter__("innerText", function(textString) {return this.textContent = textString; });
    
    // define children function for HTML elements to make it workable with Firefox
    Element.prototype.__defineGetter__("parentElement", function() {return this.parentNode; });
}

function getFirstNonTextNextSibling(elem){
    if(!_IE) {
        node = elem.nextSibling;
        while (node && node.nodeType != 1){
            node = node.nextSibling;
        }
        return node;
    } else {
        return elem.nextSibling;
    }
    return null;
}

function getFirstNonTextPreviousSibling(elem){
    if(!_IE) {
        node = elem.previousSibling;
        while (node && node.nodeType != 1){
            node = node.previousSibling;
        }
        return node;
    } else {
        return elem.previousSibling;
    }
    return null;
}

//***** Returns the XMLHTTPObject
function getXMLHTTPObject() {
    if(_IE) {
        return new ActiveXObject('MSXML2.XMLHTTP.3.0');
    } else {
        return new XMLHttpRequest();
    }
}

//***** Return the target (W3C) or srcElement (IE) for the given event.
function getTarget(evt) {
  if ( ! evt) return;
  var ret = evt.target || evt.srcElement;
  if(ret == null) return null;
  if (ret.nodeType == 3) // defeat Safari bug
    ret = ret.parentNode;
  return ret;
}

//***** Return the current event (getEvent() in IE)
function getEvent(e) {
  var ret = e || window.event;

  if (!ret) {
      var c = this.getEvent.caller;
      while (c) {
        ret = c.arguments[0];
        if (ret && (ret.srcElement || ret.target)) { 
          break;
        }
        c = c.caller;
      }
  }

  return ret;
}

var localizedLanguage = parent.language;

function handleTOCOnLoad() {
    if (! isTOC()) return;
    if (parent.document.readyState != 'complete') {
        setTimeout('handleTOCOnLoad()', 50);
        return;
    }
    var currentLink = parent.link;
    if (currentLink.slice(0, 3) == 'cm/') currentLink = currentLink.slice(3);
    currentLink = 'helpNode' + currentLink;
    highlightLink(currentLink);
}

//cache images
var imgExpandHelpTree = new Image();
var imgCollapseHelpTree = new Image();

imgExpandHelpTree.src = 'images/plusHelp.gif';
imgCollapseHelpTree.src = 'images/minusHelp.gif';

var imgActiveTabEnd = new Image();
var imgActiveTabLeft = new Image();
var imgActiveTabRight = new Image();
var imgActiveTabStart = new Image();
var imgActiveTabTop = new Image();
var imgInactiveTabEnd = new Image();
var imgInactiveTabSeparator = new Image();
var imgInactiveTabStart = new Image();
var imgInactiveTabTop = new Image();

self.imgActiveTabEnd.src = 'images/activeTabEnd.gif';
self.imgActiveTabLeft.src = 'images/activeTabLeft.gif';
self.imgActiveTabRight.src = 'images/activeTabRight.gif';
self.imgActiveTabStart.src = 'images/activeTabStart.gif';
self.imgActiveTabTop.src = 'images/activeTabTop.gif';
self.imgInactiveTabEnd.src = 'images/inactiveTabEnd.gif';
self.imgInactiveTabSeparator.src = 'images/inactiveTabSeparator.gif';
self.imgInactiveTabStart.src = 'images/inactiveTabStart.gif';
self.imgInactiveTabTop.src = 'images/inactiveTabTop.gif';

var currentHighlightId;

//Shows and collapses the help tree, changes the image of the nodes as well
function displayHelpBranch(helpImage) {
    var treeDiv = getFirstNonTextNextSibling(helpImage.parentElement);

    var treeStyle = treeDiv.style;

    if (treeStyle.display == 'none') {
        treeStyle.display = '';
        helpImage.src = self.imgCollapseHelpTree.src;
        var sectionHeight = treeDiv.offsetHeight + helpImage.parentElement.offsetHeight;
        var computedOffsetTop = computeAbsoluteOffsetTop(helpImage);
        var availableHeight = document.body.clientHeight;
        if (availableHeight < sectionHeight) {
            document.body.scrollTop = computedOffsetTop;
        } else {
            var minScrollTop = computedOffsetTop + sectionHeight - availableHeight;
            if (document.body.scrollTop < minScrollTop) document.body.scrollTop = minScrollTop;
        }
    } else {
        treeStyle.display = 'none';
        helpImage.src = self.imgExpandHelpTree.src;
    }
}

function displayHeaderNode(docAndBookmark) {
    var div = findMatchingDiv(docAndBookmark);
    if (! div) return;
    parent.link = div.id.slice(8);
    highlightLink(div.id);
}

function findMatchingDiv(linkName) {
    var divs = document.getElementsByTagName('div');
    var regex = new RegExp(linkName);
    var max = divs.length;
    for (var i = 0; i < max; i++) {
        var div = divs[i];
        if (div.id.match(regex)) return div;
    }
}

function changeTextColor() {
    var eventType = getEvent().type;
    var element = getTarget(getEvent());
    var elementId = element.id;
    var elementType = element.tagName;
    var elementClass = element.className;

    if (elementClass != 'dummyIndex1' && elementClass != 'dummyIndex2' && elementClass != 'levelBranch1' && elementClass != 'levelNoBranch1' && elementId != 'helpNode'){
        if ((elementType == 'DIV') && (eventType == 'mouseover')) {
            element.style.color = '#1929FF'; //blue
        } else {
            element.style.color = 'black';
        }
    }
}

function tocIndexClickHandler() {
    if (isTOC()) {
        handleTOCClick();
        return;
    }
    var element = getTarget(getEvent());
    var elementType = element.tagName;
    var elementClass = element.className;

    if (elementType == 'DIV' && elementClass && elementClass != 'levelBranch1' && elementClass != 'levelNoBranch1' && elementClass != 'dummyIndex1') {
        var elementId = element.id;
        var helpDocument = elementId.replace(/helpNode/, '');
        parent.link = helpDocument;
        fetchHelpDocument(helpDocument);
        if (parent.selectedIndex != '') {
            elementId = parent.selectedIndex.id;
            if (document.getElementById(elementId)) {
                unhighlightIndex(parent.selectedIndex);
            }
        }
    }
}

function handleTOCClick() {
    var element = getTarget(getEvent());
    var elementType = element.tagName;
    var elementClass = element.className;

    if (elementType == 'IMG' && elementClass == 'helpImage') {
        displayHelpBranch(element);
        return;
    }

    if (elementType == 'DIV' && elementClass && elementClass != 'levelBranch1' && elementClass != 'levelNoBranch1' && elementClass != 'dummyIndex1') {
        var elementId = element.id;
        var helpDocument = elementId.replace(/helpNode/, '');
        fetchHelpDocument(helpDocument);
        highlightElement(element);
    }
}

function tocIndexKeyDownHandler() {
    keyDownHandler();
}

//vissw01 function tabClickHandler(tabElement, caller) {
function tabClickHandler(evt, tabElement, caller) {
    var tocURL = parent.tocURL;
    var idxURL = parent.idxURL;

    var element = tabElement ? document.getElementById(tabElement) : getTarget(getEvent());
    var path = caller ? '../' : '';

    var elementId = element.id;
    var elementType = element.tagName;
    var elementClass = element.className;

    var tabTOC = document.getElementById('tabTOC');
    var tabImageMiddleOne = document.getElementById('tabImageMiddleOne');
    var tabIndex = document.getElementById('tabIndex');
    var tabImageRight = document.getElementById('tabImageRight');
    var navigationPaneLocation = parent.navigationPaneLocation;

    if (elementId == 'tabTOC' && navigationPaneLocation == tocURL) return;
    if (elementId == 'tabIndex' && navigationPaneLocation == idxURL) return;
    if (elementId == 'tabTOC') {
        document.getElementById('tabImageLeft').src = imgActiveTabStart.src;
        document.getElementById('tabTOC').style.backgroundImage = 'url(' + imgActiveTabTop.src + ')';
        document.getElementById('tabTOC').className = 'activeTab';
        document.getElementById('tabImageMiddleOne').src = imgActiveTabRight.src;
        document.getElementById('tabIndex').style.backgroundImage = 'url(' + imgInactiveTabTop.src + ')';
        document.getElementById('tabIndex').className = 'inactiveTab';
        document.getElementById('tabImageRight').src = imgInactiveTabEnd.src;

        navigationPaneLocation = tocURL;
        parent.frames.navigationPane.location.href = path + navigationPaneLocation;
        parent.navigationPaneLocation = tocURL;
        parent.selectedIndex = '';
        document.getElementById('searchIndexInput').value = '';
        document.getElementById('searchSection').style.visibility = 'hidden';
        parent.tabType = 'toc';
    }
    if (elementId == 'tabIndex') {        
        document.getElementById('tabImageLeft').src = imgInactiveTabStart.src;
        document.getElementById('tabTOC').style.backgroundImage = 'url(' + imgInactiveTabTop.src + ')';
        document.getElementById('tabTOC').className = 'inactiveTab';
        document.getElementById('tabImageMiddleOne').src = imgActiveTabLeft.src;
        document.getElementById('tabIndex').style.backgroundImage = 'url(' + imgActiveTabTop.src + ')';
        document.getElementById('tabIndex').className = 'activeTab';
        document.getElementById('tabImageRight').src = imgActiveTabEnd.src;

        navigationPaneLocation = idxURL;
        parent.frames['navigationPane'].location.href = path + navigationPaneLocation;
        parent.navigationPaneLocation = idxURL;
        document.getElementById('searchSection').style.visibility = 'visible';
        document.getElementById('searchIndexInput').focus();
        parent.tabType = 'idx';
    }
}


function tabKeyDownHandler() {
    keyDownHandler();
}

function barKeyDownHandler() {
    keyDownHandler();
}

function fetchHelpDocument(bookmark) {
    if (bookmark.search(/CMBusProc/) != -1 || 
        bookmark.search(/CMAdmin/) != -1 ||
        bookmark.search(/CMReleaseNotes/) != -1 ||
        bookmark.search(/CMUtilities/) != -1) {
        bookmark = '/help/' + localizedLanguage + '/cm/' + bookmark; 
    }
    //if (bookmark.search(/#/) != -1) {
        parent.frames.dataPane.location.href = bookmark;
    //}
    parent.pushHelpHistory(bookmark, bookmark);
}

function unhiglightLink() {
    var theLink = parent.link;
    if (theLink && document.getElementById(theLink)) {
        document.getElementById(theLink).style.backgroundColor = '';
    }
}

function highlightElement(element) {
    if (self.currentHighlightId) {
        document.getElementById(self.currentHighlightId).style.backgroundColor = '';
    }
    element.style.backgroundColor = 'yellow';
    self.currentHighlightId = element.id;
}

function highlightLink(elementId) {
    if (! isTOC()) return;
    if (! elementId) return;
    var origElement = document.getElementById(elementId);
    if (! origElement) return;
    highlightElement(origElement);
    var element = origElement;
    while(true) {
        if (element.style.display == 'none') {
            element.style.display = '';
//vissw01            var helpImage = element.previousSibling.firstChild; getFirstNonTextPreviousSibling
            var helpImage = getFirstNonTextPreviousSibling(element).firstChild; 
            helpImage.src = imgCollapseHelpTree.src;
        }
        if (element.parentElement && element.parentElement.tagName == 'DIV') {
            element = element.parentElement;
        } else {
            var oldScrollLeft = document.body.scrollLeft;
            origElement.scrollIntoView();
            document.body.scrollLeft = oldScrollLeft;
            return;
        }
    }
}

function isTOC() {
    return location.href.search(/toc/) != -1;
}

function findIndex(text, lastFoundIndex) {
    var indexDocument = parent.frames.navigationPane.document;
    var max = indexDocument.getElementsByTagName('DIV').length;
    var selectedIndex = parent.selectedIndex;
    var indexBegin = lastFoundIndex;
    var searchOneMoreTime = false;
    do {
        for (index = indexBegin; index < max; index++) {
            var element = indexDocument.getElementsByTagName('DIV')[index];
            var elementId = element.id;
            var elementText = element.innerText;
            elementText = elementText.toUpperCase();
            text = text.toUpperCase();
            if (elementText.indexOf(text, 0) == 0) {
                if (selectedIndex && selectedIndex != '') {
                    unhighlightIndex(selectedIndex);
                }
                highlightIndex(element);
                parent.selectedIndex = element;
                offsetLeft = element.offsetLeft;
                offsetTop = element.offsetTop;
                parent.frames['navigationPane'].scrollTo(offsetLeft, offsetTop);
                return index;
            }
        }
        if ((lastFoundIndex != 0) && (searchOneMoreTime == false)) {
            indexBegin = 0;
            searchOneMoreTime = true;
        } else {
            searchOneMoreTime = false;
        }

    } while (searchOneMoreTime)
    return 'None';
}

function highlightIndex(element) {
    if (! element) {return;}
    element.style.background = 'yellow';
}

function unhighlightIndex(element) {
    if (! element) {return;}
    element.style.background = '';
}

function setLogo(logoURL) {
    if (! logoURL) return;
    document.getElementById('logoImage').src = logoURL;
}

function keyDownHandler() {
    //Back and Forward buttons
    if (getEvent().altKey) {
        var keyCode = getEvent().keyCode;
        switch (keyCode) {
            case 66  : { //B
                parent.doHotKeys('B');
                break;
            }
            case 71  : { //G
                parent.doHotKeys('G');
                break;
            }
        }
    }

    // F2 or Shift F2
    if (getEvent().keyCode == 113) {
        parent.doHotKeys('F2');
    }
}

//Back and Forward button navigation
function dataPaneBackward(){
      var locationBefore = parent.frames['dataPane'].document.URL;
      parent.frames['dataPane'].history.back();
      var locationAfter = parent.frames['dataPane'].document.URL;
      if (locationBefore == locationAfter){
          //document.getElementById('imgGoBackward').style.filter = 'alpha(opacity=55,finishopacity=60) gray()';
          //document.getElementById('imgGoBackward').disabled = true;
          //alert('disable Forward');
      } else {
          document.getElementById('imgGoBackward').style.filter = '';
          document.getElementById('imgGoBackward').disabled = false;
      }
  }

  function dataPaneForward(){
      var locationBefore = parent.frames.dataPane.document.URL;
      parent.frames.dataPane.history.forward()
      var locationAfter = parent.frames.dataPane.document.URL;
      if (locationBefore == locationAfter){
          //document.getElementById('imgGoForward').style.filter = 'alpha(opacity=55,finishopacity=60) gray()';
          //document.getElementById('imgGoForward').disabled = true;
          //alert('disable Forward');
      }else{
          document.getElementById('imgGoForward').style.filter = ''
          document.getElementById('imgGoForward').disabled = false;
      }
  }

  function loadInclude(filename) {
    requestURL = window.location.href;
    requestURL = requestURL.replace(/[^\/]*$/, '');
    requestURL = requestURL + filename;
    var request = getXMLHTTPObject();
    request.open('GET', requestURL, false); // Synchronous call
    try {
        request.send(null);
    } catch (e) {}  // Do nothing
    if (request.status == 0 || request.status == 200) document.write(request.responseText);
}

function computeAbsoluteOffsetTop(htmlElement) {
	var offset = htmlElement.offsetTop;
	if (htmlElement.offsetParent) {
		return offset + computeAbsoluteOffsetTop(htmlElement.offsetParent);
	} else {
		return offset;
	}
}
