var _IE = /msie \d/.test(window.navigator.userAgent.toLowerCase());

if(!_IE) {			   
    // innerText getter and setter property for Firefox
    Element.prototype.__defineGetter__("innerText", function() {return this.textContent; });
    Element.prototype.__defineSetter__("innerText", function(textString) {return this.textContent = textString; });
    
    // define children function for HTML elements to make it workable with Firefox
    Element.prototype.__defineGetter__("parentElement", function() {return this.parentNode; });
}

function getFirstNonTextNextSibling(elem){
    if(!_IE) {
        node = elem.nextSibling;
        while (node && node.nodeType != 1){
            node = node.nextSibling;
        }
        return node;
    } else {
        return elem.nextSibling;
    }
    return null;
}

function getFirstNonTextPreviousSibling(elem){
    if(!_IE) {
        node = elem.previousSibling;
        while (node && node.nodeType != 1){
            node = node.previousSibling;
        }
        return node;
    } else {
        return elem.previousSibling;
    }
    return null;
}

//***** Return the target (W3C) or srcElement (IE) for the given event.
function getTarget(evt) {
  if ( ! evt) return;
  var ret = evt.target || evt.srcElement;
  if(ret == null) return null;
  if (ret.nodeType == 3) // defeat Safari bug
    ret = ret.parentNode;
  return ret;
}

//***** Return the current event (getEvent() in IE)
function getEvent(e) {
  var ret = e || window.event;

  if (!ret) {
      var c = this.getEvent.caller;
      while (c) {
        ret = c.arguments[0];
        if (ret && (ret.srcElement || ret.target)) { 
          break;
        }
        c = c.caller;
      }
  }

  return ret;
}

function onClickHandler() {
//vissw01    var element = event.srcElement;
    var element = getTarget(getEvent());
    var elementType = element.tagName;
    var parentElement = element.parentElement;
    var parentElementType = parentElement.tagName;
	
	if (parentElementType == 'SPAN' || parentElementType == 'B' || parentElementType == 'I') {
	    parentElement = parentElement.parentElement;
		parentElementType = parentElement.tagName;
	}
    var elementHref;
    var bookmark;
    
    if ((elementType == 'A' && element.href) || (parentElementType == 'A' && parentElement.href)) {
        var myElement;
        if (elementType == 'A') {
            myElement = element;
        }
        else {
            myElement = parentElement;
        }
         
        var headerNode = myElement.href.split('/').pop();
		
        var tocIndex = headerNode.search(/SPLtoc/);
        if (tocIndex > -1) {
            var targetAnchorName = headerNode.slice(tocIndex);
            var targetAnchor = document.getElementById(targetAnchorName);
            if (targetAnchor) {
                var header = findNearestHeader(targetAnchor);
                var theAnchor = findSPLINKAnchorUnder(header);
                if (theAnchor) {
                    bookmark = theAnchor.name;
                    parent.setCurrentHeaderNode(bookmark);
                }
            }
        } else {
            parent.frames.navigationPane.displayHeaderNode(headerNode);
            bookmark = headerNode;
        }
    } else {
        var header = findNearestHeader(element);
        var theAnchor = findSPLINKAnchorUnder(header);
        if (theAnchor) {
            bookmark = theAnchor.name;
            parent.setCurrentHeaderNode(bookmark);
        }
    }

    if (elementType == 'A' || parentElementType == 'A') {
        if (parentElementType == 'A') element = parentElement;
        elementHref = element.href;
        if (! elementHref) return;

        var result = elementHref.search('dataDictionary');
        if (result != -1) {
            result = elementHref.split('?');
            var arguments = result[1];
            if (! arguments) {
                arguments = '';
            }

            var windowLocation = parent.dataDictionaryURL + '?' + arguments;
            var newWindow = window.open(windowLocation, 'dataDictionary', 'height=600,width=800,location=yes,menubar=yes,resizable=yes,scrollbars=yes,toolbar=yes');

            //attempt to put focus on the newly opened window, ignore any errors
            try {
                newWindow.focus();
            } catch (e) {}

            return false;
        } else {
            //set help history
            parent.pushHelpHistory(elementHref, bookmark);
        }
    }
}

function findNearestHeader(element) {
    if (! element) return;
    if (element.tagName && element.tagName.match(/^H\d$/)) return element;
//vissw01    var sibling = element.previousSibling;
    var sibling = getFirstNonTextPreviousSibling(element);
    while (sibling) {
        var result = findLowestHeader(sibling);
        if (result) return result;
//vissw01        sibling = sibling.previousSibling; getFirstNonTextPreviousSibling(
        sibling = getFirstNonTextPreviousSibling(sibling); 
    }
    // Go to the parent and start over
    return findNearestHeader(element.parentElement);
}

function findLowestHeader(element) {    // Recursively drill into the children of this element
    if (! element) return;
    if (element.tagName && element.tagName.match(/^H\d$/)) return element;
    var child = element.lastChild;
    if (! child) return;
    while (child) {
        var result = findLowestHeader(child);
        if (result) return result;
//vissw01        child = child.previousSibling; getFirstNonTextPreviousSibling(
		child = getFirstNonTextPreviousSibling(child); 
    }
}

function findSPLINKAnchorUnder(header) {
    if (! header) return;
    var theElement = header.firstChild;
    while(theElement) {
        if (theElement && theElement.tagName == 'A' && theElement.name.match(/^SPLINK/)) {
            return theElement;
        }
//vissw01        theElement = theElement.nextSibling;
        theElement = getFirstNonTextNextSibling(theElement);
    }
}

function onKeyPressHandler() {
    //Back and Forward buttons
//vissw01    if (event.altKey) {
    if (getEvent().altKey) {
//        var keyCode = event.keyCode;
        var keyCode = getEvent().keyCode;
        switch (keyCode) {
            case 66  : { //B
                parent.navigateHistory('B', caller);
                break;
            }
            case 71  : { //G
                parent.navigateHistory('G', caller);
                break;
            }
        }
    }

    // F2 or Shift F2
//vissw01    if (event.keyCode == 113) {
    if (getEvent().keyCode == 113) {
        parent.doHotKeys('F2', 'helpDocument');
    }
}

function windowOnloadHandler() {   
    var tocURL = parent.tocURL;
    var idxURL = parent.idxURL;

    var localizedLanguage = parent.language;
    
    if (localizedLanguage == 'ENG') return;
    if (self.documentType == parent.documentType) return;
    parent.documentType = self.documentType;
    if (parent.documentType == 'Business') {                        
        tocURL = 'tocBusiness.html';
        idxURL = 'idxBusiness.html';
    } else if (parent.documentType == 'Admin') {        
        tocURL = 'tocAdmin.html';
        idxURL = 'idxAdmin.html';
    } else if (parent.documentType == 'Utilities') {        
        tocURL = 'tocUtilities.html';
        idxURL = 'idxUtilities.html';
    } else {        
        tocURL = 'tocAll.html';
        idxURL = 'idxSDK.html';
    }
    parent.tocURL = tocURL;
    parent.idxURL = idxURL;

    parent.frames.navigationPane.location.href = '../' + ((parent.tabType == 'toc') ? tocURL : idxURL);
}
