package oracle.ugbu.ss.portal.backing;


import com.oracle.ugbu.ss.shared.view.beans.OUCSSPortalResourcesBean;
import com.oracle.ugbu.ss.shared.view.util.OUCSSADFUtil;

import oracle.adf.share.logging.ADFLogger;


/**
 * Class to handle Portal resources per LOB selected by user.
 */
public class OUCSSResourcesBean extends OUCSSPortalResourcesBean {
    @SuppressWarnings("compatibility")
    private static final long serialVersionUID = 1L;
    private static final ADFLogger LOGGER =
        ADFLogger.createADFLogger("OUCSSSiteResources");
    private static final String PAGE_TEMPLATE_DEFAULT_ID =
        "/oracle/ugbu/ss/portal/pages/template/OUCSSTemplate.jspx";

    public String getDefaultPageTemplate() {
        String template = super.getContextSiteTemplate();
        if (template == null) {
            template = PAGE_TEMPLATE_DEFAULT_ID;
        }
        return template;
    }

    public Object getNavigationPaneValue() {
        Object retVal = null;
        String navModel = super.getContextNavigationModel();
        if (navModel != null) {
            retVal = OUCSSADFUtil.resolveExpression(navModel);
        }
        return retVal;
    }
}
