package oracle.ugbu.ss.portal.backing;


import com.oracle.ugbu.ss.shared.model.cache.OUCSSSystemProperties;
import com.oracle.ugbu.ss.shared.view.util.OUCSSADFUtil;

import java.util.HashMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import oracle.adf.share.ADFContext;
import oracle.adf.share.logging.ADFLogger;


public class OUCSSNavigationBean
  extends HashMap
{
  private static final long serialVersionUID = 1L;
  private static final String AUTH_SERVLET_URL = "/adfAuthentication?logout=true";

  private transient ADFLogger _LOG = ADFLogger.createADFLogger(OUCSSNavigationBean.class);

  private static final String CLASS_NAME = OUCSSNavigationBean.class.getCanonicalName();

  private static String BASE_URL;
  private static final boolean SHOW_LANG_TZ =
    OUCSSSystemProperties.isUserLinkEnabled() && OUCSSSystemProperties.isCCBNotifications();

  public OUCSSNavigationBean()
  {
    super();
  }

  @Override
  public String get(Object param)
  {
    return getBaseURL() + param;
  }

  public String getBaseURL()
  {
    if (BASE_URL == null)
    {
      BASE_URL = (String) OUCSSADFUtil.resolveExpression("#{facesContext.externalContext.requestContextPath}");
      _LOG.fine("Base URL is " + BASE_URL);
    }
    return BASE_URL;
  }


  private static String DEFAULT_LOGOUT_OUTCOME = "logout_success";

  public String doLogout()
  {
    final String METHOD_NAME = "doLogout";
    _LOG.entering(CLASS_NAME, METHOD_NAME);
    try
    {
      logoutInternal();

    }
    catch (Exception e)
    {
      if (_LOG.isFiner())
      {
        _LOG.finer(CLASS_NAME, METHOD_NAME, e.getLocalizedMessage());
        _LOG.finer(e);
      }
    }
    return DEFAULT_LOGOUT_OUTCOME;
  }

  private void logoutInternal()
    throws Exception
  {
    final String METHOD_NAME = "logoutInternal";
    _LOG.entering(CLASS_NAME, METHOD_NAME);

    ADFContext context = ADFContext.getCurrent();
    HttpServletRequest req = (HttpServletRequest) context.getEnvironment().getRequest();
    HttpServletResponse res = (HttpServletResponse) context.getEnvironment().getResponse();

    req.getSession(false).invalidate();

    // Removed ADFConstants.AUTH_RETURN_URL for end_url since the action returned by doLogout
    // takes precedence over the redirection done by the adfAuthentication servlet
    req.getRequestDispatcher(AUTH_SERVLET_URL).forward(req, res);

    _LOG.exiting(CLASS_NAME, METHOD_NAME);
  }

  public boolean isShowLangTimeZone()
  {
    return SHOW_LANG_TZ;
  }
}
