package oracle.ugbu.ss.portal.backing;

import com.oracle.ugbu.ss.api.model.common.OUCSSConstants;
import com.oracle.ugbu.ss.shared.view.beans.OUCSSProxyURLBean;
import com.oracle.ugbu.ss.shared.view.util.OUCSSADFUtil;

import java.util.Hashtable;
import java.util.Map;

public class OUCSSErrorProxyBean
  extends OUCSSProxyURLBean
{
  //Error Pages
  private static final String PAGENOTFOUND_ERROR_URI = "/oracle/ugbu/ss/portal/pages/public/proxy/Error.html";
  private static final String UNAUTH_ERROR_URI = "/oracle/ugbu/ss/portal/pages/public/proxy/Error.html";
  private static final String SERVER_ERROR_URI = "/oracle/ugbu/ss/portal/pages/public/proxy/Error.html";
  //Default CSR View Landing Page.
  private static final String CSR_VIEW_LANDING_URI = "/oracle/ugbu/ss/portal/admin/CustomerSearch.jspx";
  private static final String ACCESSIBILITY_PREF_URI = "";
  //Default Logout Page.
  private static final String LOGOUT_PAGE_URI = "/faces/oucssHome";
  private static final String LOGIN_PAGE_URI = "/faces/oucssLogin";
  
  private static final String SESSIONBEAN_LANDINGPAGE_EL = "#{oucssUserSessionBean.landingPage}";

  static
  {
    Map<String, String> configURLMap = new Hashtable<String, String>(8);
    configURLMap.put(OUCSSConstants.PORTAL_PAGE_NOT_FOUND_PAGE, PAGENOTFOUND_ERROR_URI);
    configURLMap.put(OUCSSConstants.PORTAL_UNAUTHORIZED_PAGE, UNAUTH_ERROR_URI);
    configURLMap.put(OUCSSConstants.PORTAL_SERVER_ERROR_PAGE, SERVER_ERROR_URI);
    configURLMap.put(OUCSSConstants.PORTAL_LOGOUT_PAGE, LOGOUT_PAGE_URI);
    configURLMap.put(OUCSSConstants.PORTAL_LOGIN_PAGE, LOGIN_PAGE_URI);
    configURLMap.put(OUCSSConstants.PORTAL_CSRVIEW_LANDING_PAGE, CSR_VIEW_LANDING_URI);
    configURLMap.put(OUCSSConstants.PORTAL_ACCESSIBILITY_PAGE, ACCESSIBILITY_PREF_URI);
    configURLMap.put(OUCSSConstants.PORTAL_LANDINGPAGE_EL, SESSIONBEAN_LANDINGPAGE_EL);
    //Call configure method.
    configureURLUsingResource(configURLMap);
  }

  public String getLoginLandingPageURI()
  {
    String loginLOB = (String) OUCSSADFUtil.resolveExpression(SESSIONBEAN_LANDINGPAGE_EL);
    if (loginLOB == null)
    {
      loginLOB = "/faces/oucssHome";
    }
    return loginLOB;
  }
}
