var serviceChargesData = [];
var saIndex = 0;
var heightSet = false;
var acctId=OUCSS.CSSApp.getGlobalContext().contextAcctId;
var saExists = false;

var ajaxDataRenderer = function(url, plot, options) {
	
	if(serviceChargesData[saIndex] != null)
	return (serviceChargesData[saIndex]).usageCharges;
	else
	return null;
};  

//// Function to show Usage graph when the page loads
OUCSS.PageEvents.serviceChargesToDate = {
	
	    pageBeforeShow : function(e){	   
		   
		   
		   if(acctId == undefined)
			{				 
				 window.location.replace('../../Login.html');
			}
		   
		   $('#acctInfoMeter').text('Account : '+acctId);
		   
		  },
		
		
		pageShow   : function(){	
                  
                			 
                  //Get Usage Data for all SAs using Rest service
				 var startDate = new Date().yyyymmdd() + 'T00:00:00';
				 var ajaxArgs = {'onSuccess' : getserviceChargesData, 'onFailure' : OnReadError};
				 var args = { 'key1':acctId,'action':'READ'};		
			     
			     //Show loading sign
			     OUCSS.Utilities.displayLoading();    	    
				 OUCSS.CSSApp.invokeService("ServiceChargesToDateService", ajaxArgs, args);
				  
}};


//Handle errors from service call
function OnReadError(xjr, desc, error){
	
	  OUCSS.AJAX.serviceFailure (xjr, desc, error, 'Error getting the Service Charges To Date information');
	
}

function getserviceChargesData(data, status){
	var error = false;
	
  if(data.mainData.isInError)
	 {
	    error = data.mainData.isInError;
	 }
    
  else if(data.mainData.saAmounts){
	   
	   OUCSS.Utilities.log('SA Exists');
	      
		  var results = '';
			results=  data.mainData.saAmounts;
			
			
		 /* if(results != null && results.length >0) {
               results = new Array(results);
               
           }*/
		   
		  //Loop through SAs data. There can be multiple SAs
		  $.each(results, function(i, sa) {
			 	
					var saData=[[]];
					saExists = true;
					var saObject = new Object();
					saObject.currencySymbol = sa.currencySymbol;
					saObject.amount = sa.amount;
					saObject.saInfo=sa.saInfo;
					var priorBilledAmts = sa.priorBilledAmounts;
					 if(priorBilledAmts != null){
					$.each(sa.priorBilledAmounts, function(i, item) {	
						
						var dateMilliSecs = (item.bsegEndDate).value;
						var billDate = new Date(dateMilliSecs);
						var UTCDate = billDate.toUTCString();
						saData[0].push([UTCDate, item.bsegAmount]);
						
												
					});
					 }
					saObject.usageCharges=saData;
					if(serviceChargesData == null)
						serviceChargesData = [];
					
					serviceChargesData.push(saObject);
					//serviceChargesData.push(saObject);
					
					
					
		  });
		  
		  $('#errorDiv').hide();
			OUCSS.Utilities.hideLoading();
	}	  
		  
	  if(saExists == true)
	  {
		  OUCSS.Utilities.log('SA Exists---');
		  //Render SA List
		 renderUI();			  
						  
		  //Render Graph for first SA
		 renderGraph(); 
		  
		  //Bind event handling logic
		  //Refresh the graph if a different SA is selected
		  $('#saList').change(function() {
			  
			saIndex = $(this).val();
			renderTotalCharges();
			renderGraph();
		  }); 
	  }   
      else if(error == false)
	  {
		  $('#noSAExistMsg').show();
		  OUCSS.Utilities.hideLoading();
	  }
      else if(error == true)
    	  {
    	  $('#errorText').text("An error occurred in the system. Please contact system administrator");
			$('#errorDiv').show();
    	    OUCSS.Utilities.hideLoading();
			
    	  }
	
	
  };

//Render SA List  
  
  function renderTotalCharges()
  {
	  if(serviceChargesData[saIndex] != null && serviceChargesData[saIndex].amount != null){
	 var totalCharges ='<h2><span class="dropDownTxt"><center>Total Charges:'+serviceChargesData[saIndex].currencySymbol+' '+serviceChargesData[saIndex].amount+'</center></span></h2>';
	 
	 $('.totalChargesDiv').empty();
	 $('.totalChargesDiv').append(totalCharges).trigger('create');
	  }
  }
function renderUI(){
	
	var saList =   '<select class="dropDownTxt" data-mini=\'true\' name=\'saList\' id=\'saList\' >';
				$.each(
						serviceChargesData,
						function(i, usage) {
							saList = saList
									+ '<option  value='+i+'>'
									+ usage.saInfo
									+ '</option>';
					});
				saList = saList
						+ '</select>';
				
				console.log(saList);
						
	$('.saListDiv').empty();
	$('.saListDiv').append(saList).trigger('create');
	renderTotalCharges();
}; 
  

function renderGraph(){
	
	var height = ($(window).height()
			- $("#serviceChargesToDate").find('[data-role="header"]').outerHeight()
			- $("#serviceChargesToDate").find('[data-role="footer"]').outerHeight() 
			- $("#saListDiv").outerHeight()
			- $("#acctHeader").outerHeight());
	if(!heightSet){
	    $("#chart").height(height * 0.8);
		heightSet =  true;
	}
  
  $.jqplot.config.enablePlugins = true;  
  
  var plot1 = $.jqplot('lineChart',[],  {
	 
      title:'Previous Billed Charges',
	  dataRenderer: ajaxDataRenderer,	  
	  seriesDefaults:{showMarker:false,
	       pointLabels:{
			   show:false
			   }		   
	      },
      axes:{
        xaxis:{
          renderer:$.jqplot.DateAxisRenderer,
          tickRenderer: $.jqplot.CanvasAxisTickRenderer,
          tickOptions: {
              // labelPosition: 'middle',
              angle: 90,
			  formatString:'%b %#d,%Y',
			  textColor : '#000000'
          },
          tickInterval:'1 day'		  
        },
        yaxis:{
          tickOptions:{
			  formatString:'%.2f',
			  textColor : '#000000'
            }
        }
      },
     highlighter: {
      show: false
    },
    cursor: {
      show: true,
      tooltipLocation:'nw'
    }
  });
  
  plot1.resetAxesScale();
  plot1.replot();
  
  
}

