var tableString;
var perId;
var acctId;
var lob;
var util = OUCSS.Utilities;
var  globalAcctId = OUCSS.CSSApp.getGlobalContext().contextAcctId;

//Page Rendering Logic
OUCSS.PageEvents.enroll = {
	
	   pageBeforeShow : function(){	
		  
		   
		   if(globalAcctId == undefined)
			{				 
				 window.location.replace('../../Login.html');
			}
		   
		     $("#acctHeader").hide();
			
	 	   },
	 	   
	 	   
	 	  pageSubmitForm: function() {			
			
	 		  var valid = validateFields();
				
	 		  if(valid)
	 			  {
				if($("#enrollAction").val() == "READ")
					{
					
				        getAccountVerificationFields();
					}
				else if($("#enrollAction").val() == "VERIFY")
					{
					  
					    verifyAccount();
					}
	 	       }
				
			
		},	
		
		pageShow:	function() {
			
			
					
		}
};

function validateFields(){
	var requiredFields=[''];
	var missingFields = '';
	
	if($("#enrollAction").val() == "READ")
		{
		if($('#enrollAcctId') == null || $('#enrollAcctId').val() == '')
			 missingFields = $('label[for="enrollAcctId"]').text();
		}
    else if($("#enrollAction").val() == "VERIFY")
    	
	      $('.verifyFields').each(function() {
		      var fieldVal =  $(this).val();
		      if(fieldVal == null || fieldVal == '')
		      { 
		    	  if(missingFields != '')
				   {
				      missingFields =  missingFields + ' , ';
				   }
		    	  missingFields = missingFields + $(this).attr("placeholder") +' ';
		      }
		   });
		
	

    //This will be called only if the Browser level validation does not work
    util.log('Missing Fields ' + missingFields);					
	if(missingFields != '')					
	{
	    $('#errorText').text('Please enter value for these fields : ' + missingFields);
		$('#errorDiv').show();
		return false;
	}
	else
	{
		$('#errorDiv').hide();
	    return true;
	}
};

function getAccountVerificationFields()
{
	OUCSS.Utilities.log('Enroll page : ');		
	
	pageId='enroll';	
	var ajaxArgs = {'onSuccess' : renderData, 'onFailure' : OnReadError};
	
	//Display data
	//Custom Extension call to invoke custom service
	if(OUCSS.PageEvents[pageId].cmext && OUCSS.PageEvents[pageId].cmext.invokeService) {
		
		OUCSS.PageEvents[pageId].cmext.invokeService();  			
	}
	//Base code
	else{
	    acctId = $("#enrollAcctId").val();
		var args = { 'action': 'READ', 'key1':acctId };
		OUCSS.Utilities.displayLoading();
		OUCSS.CSSApp.invokeService("VerifyAccountService", ajaxArgs, args);
			
	}
	
}

//Handle errors from service call
function OnReadError(xjr, desc, error){
	
	  OUCSS.AJAX.serviceFailure (xjr, desc, error, 'Error getting the verify account information');
	
}

function verifyAccount()
{
	OUCSS.Utilities.log('Enroll page : ');		
	
	pageId='enroll';	
	var ajaxArgs = {'onSuccess' : checkAccountVerified, 'onFailure' : OnReadError,'method':'POST', 'contentType' : 'application/json; charset=utf-8'};
	
	//Display data
	//Custom Extension call to invoke custom service
	if(OUCSS.PageEvents[pageId].cmext && OUCSS.PageEvents[pageId].cmext.invokeService) {
		
		OUCSS.PageEvents[pageId].cmext.invokeService();  			
	}
	//Base code
	else{
		
		var ajaxArgs = {'onSuccess' : checkAccountVerified, 'onFailure' : OnReadError,'method':'POST', 'contentType' : 'application/json; charset=utf-8'};
		
		OUCSS.CSSApp.invokePageAction();
		var args = OUCSS.CSSApp.getPageContext().pageData;
		OUCSS.Utilities.displayLoading();
		
		OUCSS.CSSApp.invokeService("VerifyAccountService", ajaxArgs, JSON.stringify(args));
		
			
	}
	
}
//Handle errors from service call
function OnReadError(xjr, desc, error){
	
	  OUCSS.AJAX.serviceFailure (xjr, desc, error, 'Error getting the verify account information');
	
}


function checkAccountVerified(data,status)
{
	util.hideLoading();
	
	if(data.mainData.isVerified == "true"){
	var ajaxArgs = {'onSuccess' : showEnrollSuccess, 'onFailure' : OnReadError,'method':'POST', 'contentType' : 'application/json; charset=utf-8'};
	if(data.mainData.isVerified)
	   {
		
	    var args = {"lobCd":lob,"key1":acctId,"key2":data.head.key2.value,"userId":OUCSS.CSSApp.getGlobalContext().username};
		OUCSS.CSSApp.invokeService("OUCSSEnrollService", ajaxArgs, JSON.stringify(args));
       } 
	}
	else
	{
		$('#errorText').text("Account verification failed !");
		$('#errorDiv').show();
	    OUCSS.Utilities.hideLoading();
	}
	
}

 function showEnrollSuccess(data,status)
 {
		
	 OUCSS.CSSApp.launchPopup('Account enrolled successfully - You need to relogin again','enrollPopup','999');
	 //window.location.href = "../../Login.html";
 }
//Render UI
function renderData(data,status)
{
	
	if($("#enrollAction").val() == "READ")
		{
	tableString = '';
	dataExists=false;
	perId = data.head.key2.value;
	lob = data.mainData.businessLine;
	
	$('#enrollAcct').text('Account : '+acctId);
	$("#acctHeader").show();
	$("#acctIdSection").hide();
	
	
	if(data.mainData.accountVerification){
		tableString = '<input type="hidden" oucss-path="mainData.businessLine" value="'+lob+'" />';
		
		$.each([ 1,2,3,4,5], function( index, value ) {
		 var fieldName = "field"+value;
		if(data.mainData.accountVerification[fieldName] && data.mainData.accountVerification[fieldName].description != null && data.mainData.accountVerification[fieldName].description != '')
			{
			
			tableString = tableString + 
			'<label for="field'+value +'"'+' class="ui-hidden-accessible" >'+ 
			data.mainData.accountVerification[fieldName].description + ' '+(data.mainData.accountVerification[fieldName].format != null?data.mainData.accountVerification[fieldName].format:'') +' '+
			'</label>'+
			'<input type="text" class ="verifyFields" oucss-path="mainData.accountVerification.field'+value+'.value" name="field'+value +'"'+
			' data-mini="true" id="field"'+value+'"'+
			'oucss-path="fields" placeholder="' +data.mainData.accountVerification[fieldName].description + ' '+(data.mainData.accountVerification[fieldName].format != null?data.mainData.accountVerification[fieldName].format:'') +' " />';
           			
			}
		
	   });
	}
	
	$('#accountVerifyDataSection').empty();
	$('#accountVerifyDataSection').append(tableString).trigger('create');
	$("#enrollAction").val("VERIFY");
		}
	
	$('#errorDiv').hide();
	OUCSS.Utilities.hideLoading();
	    
}
