var tableString;
var d = new Date();
var currentYear=d.getFullYear();
var year=currentYear;
var currentDate='-'+d.getMonth()+'-'+d.getDay();
var startDate=d;
var acctId=OUCSS.CSSApp.getGlobalContext().contextAcctId;	


//Page Rendering Logic
OUCSS.PageEvents.viewBill = {
	
	   pageBeforeShow : function(){		   
		   
		   
		   if(acctId == undefined)
			{
				window.location.replace('../../Login.html');
			}
			
			$('#acctInfoBill').text('Account : '+acctId);
			
					
	 	   },
		
		pageShow:	function() {
			
			OUCSS.Utilities.log('Bill Account Selected : '+acctId);		
			
			pageId='viewBill';	
			var ajaxArgs = {'onSuccess' : renderData, 'onFailure' : OnReadError};
			
			//Display data
			//Custom Extension call to invoke custom service
			if(OUCSS.PageEvents[pageId].cmext && OUCSS.PageEvents[pageId].cmext.invokeService) {
    			OUCSS.PageEvents[pageId].cmext.invokeService();  			
    		}
			//Base code
			else{
				
				var args = {'key1':acctId ,'action':'READ'};
				OUCSS.Utilities.displayLoading();
				OUCSS.CSSApp.invokeService("ViewBillService", ajaxArgs, args);
			}
			
			
						
		}
};

//Handle errors from service call
function OnReadError(xjr, desc, error){
	
	  OUCSS.AJAX.serviceFailure (xjr, desc, error, 'Error getting the Bill information');
	
}

function renderBillInfo(obj) {
	var dataExists=false;
	if(	obj.billId == null)
	{
	  $('#mailingAddress').hide();
	  $('#acctBillDetails').hide();
	  $('#acctBillDetails2').hide();
	  dataExists=false;
	}
	else{
		dataExists=true;
	$('#noDataMsg').hide();
	$('#acctNum').text(obj.accountId);
	$('#billNum').text(obj.billId);
	var billDate = "";
	if (obj.billDate)
		billDate = new Date(obj.billDate.value).toLocaleDateString();

	$('#billDate').text(billDate);

	var dueDate = "";
	if (obj.dueDate)
		dueDate = new Date(obj.dueDate.value).toLocaleDateString();

	$('#dueDate').text(dueDate);

	$('#amtDue').text(util.formatCurrency(obj.balanceAmount));

	$('#prevPeriodBal').text(util.formatCurrency(obj.beginningBalance));
	$('#totPay').text(util.formatCurrency(obj.totalPayments));
	$('#totAdjustment').text(util.formatCurrency(obj.totalAdjustments));
	$('#totBillCorrection').text(util.formatCurrency(obj.totalCorrections));
	$('#totBillCharge').text(util.formatCurrency(obj.totalCurrentCharges));
	$('#endBal').text(util.formatCurrency(obj.endingBalance));
	
	}
	
	return dataExists;

}

function renderMailingAddress(obj) {
	var mailingAddrStr = '';
	$.each(
					obj,
					function(i, mailingAddr) {

						mailingAddrStr = mailingAddrStr
								+ mailingAddr.name
								+ '<br>'
								+ mailingAddr.addressLine1
								+ '<br>'
								+ ((mailingAddr.addressLine2 != null) ? mailingAddr.addressLine2
										+ '<br>'
										: '')
								+ mailingAddr.city
								+ ' '
								+ ((mailingAddr.postal != null) ? mailingAddr.postal
										: '')
					});

	if (mailingAddrStr == '')
		$('#addr').hide();
	else {
		$('#addr').empty();
		$('#addr').append(mailingAddrStr).trigger('create');
	}

}

function renderBillMessages(obj) {
	var billMessagesStr = '';
	$.each(obj, function(i, billMessages) {

		billMessagesStr = billMessagesStr + billMessages.messageOnBill + '<br>'

	});

	if (billMessagesStr == '')
		$('#billMsgs').hide();
	else {
		$('#billMsgs').empty();
		$('#billMsgs').append(billMessagesStr).trigger('create');
	}
}

function renderBillSegments(obj,currency)
{
	var billSegmentStr='<table id="billSegmentTable">';
	$.each(obj,function(i,billSegment){
		
			
	billSegmentStr = billSegmentStr+'<tr><td><span class="billSegmentHeader">Current Charges for Service at: </span><span class="billSegmentPremiseInfo">'+billSegment.premiseInfo+'</span><td></tr>'
	if(billSegment.billSegmentCalcHeader){
		$.each(billSegment.billSegmentCalcHeader,function(i,billSegmentCalc){
			
			var startDate="";
			if(billSegmentCalc.startDate)
				startDate = new Date(billSegmentCalc.startDate.value).toLocaleDateString();
			var endDate="";
			if(billSegmentCalc.endDate)
				endDate = new Date(billSegmentCalc.endDate.value).toLocaleDateString();
			
			billSegmentStr = billSegmentStr+'<tr style="width:100%"><td><span class="billAcct">'+billSegmentCalc.descriptionOnBill+'</span></td></tr>'
	                                       +'<tr style="width:100%"><td><span class="billRateDesc" style="width:70%">'+startDate+' to '+endDate+'</span><td align="right"><span class="billRateDesc">'+util.formatCurrency(billSegmentCalc.calcAmount)+'</span></td></tr>'
	                                       +'<tr style="width:100%"><td><span class="billRateDesc" style="width:50%">'+billSegmentCalc.rateDesc+'</span></td></tr>';
			$.each(billSegmentCalc.calcLine,function(i,billCalcLine){ 
				if(billCalcLine.inSummary == false)
					billSegmentStr = billSegmentStr+'<tr style="width:100%"><td><span class="billTxt" style="width:70%">'+billCalcLine.lineDescrOnBill+'</span></td><td align="right"><span class="billTxt">'+util.formatCurrency(billCalcLine.calcAmount)+'</span></td></tr>'
				else	
				    billSegmentStr = billSegmentStr+'<tr style="width:100%"><td><span class="billTxt">'+billCalcLine.lineDescrOnBill+'</span></td><td style="width:30%"><span class="billTxt">'+util.formatCurrency(billCalcLine.calcAmount)+'</span></td></tr>'	
				                              
			});
			
		});
	}
	});
	billSegmentStr = billSegmentStr+'</table>';
	$('#billSegment').empty();
	$('#billSegment').append(billSegmentStr).trigger('create');
}

//Render UI
function renderData(data,status)
{
	tableString = '';
	dataExists=false;
	
	if(data.mainData){
		dataExists=	renderBillInfo(data.mainData);
		
	if(data.mainData.billRouting)
		renderMailingAddress(data.mainData.billRouting);
	
	if(data.mainData.billMessages)
		renderBillMessages(data.mainData.billMessages);
	
	if(data.mainData.billSegment)
		renderBillSegments(data.mainData.billSegment,data.mainData.currency);
	
		  
   }
	
	
		// No data.
	if (dataExists == false) {

		$('#noDataMsg').show();
	} else {

		$('#noDataMsg').hide();
	}
	
	$('#errorDiv').hide();
	OUCSS.Utilities.hideLoading();
	
	}
