var serverURL = CMConfig.restServerURL;
var loginService = "MobileLogin";
var username;
var password;
var userLanguage;
var javaImpl;
var base64UserAuthentication;
var util = OUCSS.Utilities;

 if(javaImpl == undefined || javaImpl.getPasswordHash == undefined) {
			    javaImpl = {};
			    util.log("Actual Native Implementation not found, adding a dummy method");
			    javaImpl.getPasswordHash = function(password) {
			    	    util.log('Dummy Java Impl called. Will return the same password as output. No Hashing done. ');
			    	    return password;
			    	};        
			}	

// Post fresh user credentials & tries to authenticate in online mode. 
function postUserCredentials(username,password) {
	
	util.log('Attempting to Login');	
	
	userLanguage = 'ENGLISH';//$("#langcode").val();	
	
  
		// Calculate Base64 using built-in API which works on iOS too. 
		base64UserAuthentication = btoa(username + ":" + password);
		
		var data={'username' : username, 'password' : password};				
		OUCSS.CSSApp.setGlobalContext(data);
		
		//show loading sign
		util.displayLoading();
		
		var ajaxArgs = {'onSuccess' : storePasswordLocally, 'onFailure' : LoginError };
		var args = { };		    	    
		OUCSS.CSSApp.invokeService("user/OUCSSUserService?lob=1&retrieveAccountInfo=true", ajaxArgs, args);	
	
}

function LoginError(xjr, desc, err){
	
	util.hideLoading();
	 util.log('Error from service' || xjr.status);
	 // If invalid username or password, then don't proceed further. 
			if(xjr.status == 403 || xjr.status == 401 || xjr.statusText == 'timeout') {
				OUCSS.CSSApp.launchPopup("Authentication Failure:<br/> Invalid Username or Password",'loginPopup', -1);
			} else if(xjr.status == 404){ // If network not reachable then try to read offline. 
				OUCSS.CSSApp.launchPopup("Error connecting to the server",'loginPopup', -1);
			}
			else if (xjr.status == 503){
				util.log('Error from service');
			}
	
}


//Stores the password locally for future authentications
function storePasswordLocally(data, status) {
	
	if(data.restFaultBean !=null)
	{
		util.hideLoading();
	    OUCSS.CSSApp.launchPopup("Error connecting to the server",'loginPopup', -1);
		return;
	}
	
	 //Store Account List
	 var data={'acctList' : data};
	 OUCSS.CSSApp.setGlobalContext(data);
	 
	 //Create the database, if it does not exist already. And fetch lookups and messages from REST service and load into database	 	 
     var dbHandle = OUCSS.DB.getHandle();
	 
	 //Store username/password locally
	 if($('#SaveLogin').val() == "1"){	 
		 util.log('Store Password Locally'); 	 
		 dbHandle.transaction(loginDBTransaction);
	 }	 
	 
	 util.hideLoading();
	 authenticatedSuccessfully();
	 
	 //Init Labels, Messages etc
	 OUCSS.DB.init();
	
}

//After successful authentication then store the password hash into the Web SQL db. 
function loginDBTransaction(tx) {
 try {
        var dbHandle = OUCSS.DB.getHandle();
        util.log("Login DB Transaction start");
		tx.executeSql('CREATE TABLE IF NOT EXISTS CSS_USER_CACHE (LOGIN_NAME text unique primary key, USER_NAME text NOT NULL, PASSWORD text NOT NULL, LANGUAGE text NOT NULL, LAST_LOGON_TIMESTAMP text NOT NULL)');
		var currentDate = new Date();
		var currentDateString = currentDate.yyyymmdd();;
		
		var hashedPassword = javaImpl.getPasswordHash(password);
		//Remove existing rows
		tx.executeSql('delete from CSS_USER_CACHE;', [],function() {
				util.log("Successfully deleted from CSS_USER_CACHE Table. ");
			}, function() {
				util.log("Error deleting from CSS_USER_CACHE Table. ");
			}); 
		
		//Save the new credentials
		tx.executeSql('insert into CSS_USER_CACHE VALUES (?, ?, ?, ?, ?);', [username, username, hashedPassword, userLanguage, currentDateString], 
			function() {
				util.log("Successfully inserted into CSS_USER_CACHE Table. Proceeding to the next phase");
			},
			function() {
				util.log("Failed to insert into CSS_USER_CACHE Table");
				dbHandle.transaction(
						function(tx) {
								tx.executeSql('UPDATE CSS_USER_CACHE SET PASSWORD = ? WHERE LOGIN_NAME = ?', [hashedPassword, username]);
								util.log("Updating the CSS_USER_CACHE Table instead.");
						});				    		            
			}
	
		);
 		util.log("Login DB Transaction end");
 	
		 } catch(ex) {
			 util.log("Error " + ex.description);
			 throw ex;
		 }
}     

//Next step on successful authentication. It goes to the startPage variable of CMConfig. 			
function authenticatedSuccessfully() {
 
	 
	 var cmStartPage = URLMapping["#homePage"];
	 if(cmStartPage == undefined || cmStartPage == "") {
		 cmStartPage = "mods/acctList/acctList.html";
	 }
	 
	 util.log('Authentication successful moving to  ' + cmStartPage);
	 //hideLoading();	 
	   
	 /**var inputToStartPage = {
							data: {
								inputArgs: {userId: username}
								}
							}; */
	 
	 
	 $.mobile.changePage(cmStartPage);
	 
}

//Not used. Required for offline mode only.
//Authenticates against a local hashed password. 
function authenticateLocally() {
 
	 // Read the password hash of the current user.
     var dbHandle = OUCSS.DB.getHandle(); 
	 dbHandle.transaction(function(tx) {
			tx.executeSql('SELECT * FROM CSS_USER_CACHE WHERE LOGIN_NAME = ?',
					[ username ],
					readPasswordLocal,
					null);
		 
	 });
	 
	 util.log('Authenticating Locally');
 
}

//Not used. Required for offline mode only.
//Fetches the password from local and compares it with the user entered hash. If it matches then it proceeds further
//If it doesn't match you'll see an error that the user couldn't be authenticated in offline mode. 
function readPasswordLocal(tx, results) {
	 var rowCount = results.rows.length;
	 util.log("Number of Login rows found " + rowCount);
	 var passwordFromDB = "";
	 for (var i=0; i<rowCount; i++){
		 util.log("Row = " + i + " Login Name = " + results.rows.item(i).LOGIN_NAME + " Data =  " + results.rows.item(i).PASSWORD);
		 passwordFromDB = results.rows.item(i).PASSWORD;
	 }
	 
	
			
	var hashedPassword = javaImpl.getPasswordHash(password);
	
	 if(hashedPassword == passwordFromDB) {
		 authenticatedSuccessfully();
	 } else {
		 displayLoginError("Unable to Login in Offline Mode");
	 }
	 
	 return rowCount;
 
}

//Login using saved credentials
function automaticLogin(){
	
	// Read the password hash of the current user.
	 //OUCSS.DB.initDB();
     var dbHandle = OUCSS.DB.getHandle(); 
	 
	 var tryLogin = function(tx, results){
		 var rowCount = results.rows.length;
		 
		 //If saved credentials exist
		 if(rowCount >= 1){
			 username=results.rows.item(0).USER_NAME;
			 password=results.rows.item(0).PASSWORD;
			 
			 postUserCredentials(username,password);
		 }
	 };
	 
	 
	 dbHandle.transaction(function(tx) {
			tx.executeSql('SELECT * FROM CSS_USER_CACHE', [], tryLogin, null);
		 
	 });
	
}

function logout() {
	// No callback method. So pass null. 
	util.logout(null);
}



OUCSS.PageEvents.login = {
	
	pageBeforeShow : function(){
		
		   //Check if credentials are saved. then use the credentials and login
		  automaticLogin();
		  		
		   $("#loginButton").unbind('click');
		   
		   $("#loginButton").click(function() { 			
			    			
			    username = $("#username").val();
	            password = $("#password").val();
				
				if(username=="" || password=="")
	         		OUCSS.CSSApp.launchPopup("Please enter Username and Password",'loginPopup', -1);
				else	
			       postUserCredentials(username,password);	
				
			});	
			
			var center_login = function() {
				$(".login-content").center();
				
		  	};
			
			$(window).resize(center_login);
			
			$('input[type="checkbox"]').change(function() {
				this.value = (Number(this.checked));
			});
			
			 			   
		   
	   },
	   
	 pageShow : function(){
		  $(".login-content").center();
	 }
}