var OUCSS = {}; 
var cssTheme = 'a';


Number.prototype.format = function(n, x) {
    var re = '(\\d)(?=(\\d{' + (x || 3) + '})+' + (n > 0 ? '\\.' : '$') + ')';
    return this.toFixed(Math.max(0, ~~n)).replace(new RegExp(re, 'g'), '$1,');
};


Date.prototype.yyyymmdd = function() {         
                                
        var yyyy = this.getFullYear().toString();                                    
        var mm = (this.getMonth()+1).toString(); // getMonth() is zero-based         
        var dd  = this.getDate().toString();             
                            
        return yyyy + '-' + (mm[1]?mm:"0"+mm[0]) + '-' + (dd[1]?dd:"0"+dd[0]);
   }; 

jQuery.fn.center = function () {
    this.css("position","absolute");
    this.css("top", Math.max(0, (($(window).height() - $(this).outerHeight()) / 3) + 
                                                $(window).scrollTop()) + "px");
    this.css("left", Math.max(0, (($(window).width() - $(this).outerWidth()) / 2) + 
                                                $(window).scrollLeft()) + "px");
    return this;
}

//Utility functions to log Page Context or any data
OUCSS.Utilities = (function (OUCSS) {
              
    function printJSON (object) {
        var output = '';
        for (property in object) {
         if(object[property] != null)
             output += property + ': ' + object[property]+'; ';
        }
        
        return output;
    }
    
   function logPageContext (name) {
       if(window.console) {
           console.log("PAGE CONTEXT in "+name +" : "+printJSON(OUCSS.CSSApp.getPageContext()));
       }
   } 
   
   function log (arg) {
       if(window.console) {
           console.log(arg);
       }
   }

   function logErr (arg) {
       if(!window.console) {
           return;
       }
       console.error(arg);
   }

    function logDBErr (tx, err) {
       console.log('DB Error  -  '+err.message+'  - '+err.code);
   }


   function logObj (arg1, arg2) {
       if(!window.console) {
           return;
       }
       if(!arg2) {
           console.log(JSON.stringify(arg1));
           return
       }

       console.log(arg1+JSON.stringify(arg2));

   }

   function str(arg) {
       return JSON.stringify(arg);
   }
   
   function getData(data, path) {
       path = path.split('.');
       for(var i=0; i<path.length; i++) {
           data = data[path[i]];
           if (!data)
               return "";
       }
       return data;
   }

   function logout(Loginpage) {

       log("Logging out from the Application");
	   var dbHandle = OUCSS.DB.getHandle();
	   
		//Remove existing rows
		dbHandle.transaction(function(tx) {tx.executeSql('delete from CSS_USER_CACHE;', [],function() {
				util.log("Successfully deleted from CSS_USER_CACHE Table. ");
			}, function() {
				util.log("Error deleting from CSS_USER_CACHE Table. ");
			})}); 
			
		   $('#username').val('');	
		   $('#password').val('');	
		   $('#SaveLogin').val('0');
		  
           $.mobile.changePage(Loginpage); 
                   
   }   

   function getCurrentDate() {
       //TODO: need to take care of timezone and stuff
       var d = new Date();
       var day = d.getDate();
       var month = d.getMonth()+1;
       var seconds = d.getSeconds();
       if (day < 10 )
           day = "0"+day;
       if (month < 10 )
           month = "0"+month;
       if (seconds < 10)
           seconds = "0"+seconds;

       return d.getFullYear()+"-"+month+"-"+day+"-"+d.getHours()+"."+d.getMinutes()+"."+seconds;
   }

   /**
    * Find all elements with oucss-action attributes and associate the respective action handler.
    * Passed in object should be a valid jQuery object.
    */
   function registerPageActions(node) {
       node.find("[oucss-action]").each( function () {
            switch($(this).prop("tagName")) {
               case "SELECT":
                   $(this).on('change', OUCSS.CSSApp.invokePageAction);
               break;

               default:
                   $(this).on('click', OUCSS.CSSApp.invokePageAction);
           }
       });
   }
	
	function displayLoading() {
		$.mobile.loading( 'show', {
			theme: cssTheme
		});
	}

	function hideLoading() {
		$.mobile.loading( 'hide' );
	}
	
//	function formatCurrency(amount){
//		//Currently this function returns account formatted to only USD using en-US locale
//		var formatCurr = new Intl.NumberFormat('en-US', {
//			  style: 'currency',
//			  currency: 'USD',
//			  minimumFractionDigits: 2,
//			});
//		
//		return formatCurr;
//	}
	
	function formatCurrency(amount){
		var parts = (amount + "").split("."),
        main = parts[0],
        len = main.length,
        output = "",
        i = len - 1;

	    while(i >= 0) {
	        output = main.charAt(i) + output;
	        if ((len - i) % 3 === 0 && i > 0 && main.charAt(i-1) != '-') {
	            output = "," + output;
	        }
	        --i;
	    }
	    // put decimal part back
	    if (parts.length > 1) {
	        output = "$" + output + "." + parts[1];
	    }else{
	    	output = "$" + output + ".00";
	    }
	    return output;
	}
   
   return {
       printJSON: printJSON,
       logPageContext: logPageContext,
       getData: getData,
       log: log,
       logErr: logErr,
       logDBErr: logDBErr,
       logObj: logObj,
       str: str,
       logout : logout,
       getCurrentDate: getCurrentDate,
       registerPageActions: registerPageActions,
		displayLoading  :  displayLoading,
		hideLoading  : 	hideLoading,
		formatCurrency : formatCurrency
      
   };
})(OUCSS);

//Not used. Other storage options like local/session storage
OUCSS.Storage = (function (OUCSS) {
    
    //module dependency 
    var util = OUCSS.Utilities;
    
    function getLocal(key) {
        localStorage.getItem(key);
    }
    
    function setLocal(key, value) {
        util.log("Saving to local storage - "+key+": "+value);
        localStorage.setItem(key, value);
    }
    
    function getSession(key) {
        sessionStorage.getItem(key);   
    }
    
    function setSession(key, value) {
        sessionStorage.setItem(key, value);
    }    
    return {
        getLocal: getLocal,
        setLocal: setLocal,
        getSession: getSession,
        setSession: setSession
    }
})(OUCSS);

//Get the Selected theme
function getTheme(){
	return cssTheme;
}

//Set the theme for entire page
function setTheme(theme) {
	
	if(theme != '')
        cssTheme = theme;
		
    //reset all the buttons widgets
    $('[data-role=page]').find('.ui-btn').removeClass(
            'ui-btn-up-a ui-btn-up-b ui-btn-up-c ui-btn-up-d ui-btn-up-e ui-btn-hover-a ui-btn-hover-b ui-btn-hover-c ui-btn-hover-d ui-btn-hover-e').addClass(
            'ui-btn-up-' + theme).attr('data-theme', theme);

    //reset the header/footer widgets
    $('[data-role=page]').find('.ui-header, .ui-footer').removeClass(
            'ui-bar-a ui-bar-b ui-bar-c ui-bar-d ui-bar-e').addClass(
            'ui-bar-' + theme).attr('data-theme', theme);
    
    $('.ui-body-a').each(function(){
        $(this).removeClass('ui-body-a').addClass('ui-body-' + theme);    
    });
    $('.ui-body-b').each(function(){
        $(this).removeClass('ui-body-b').addClass('ui-body-' + theme);    
    });
    $('.ui-body-c').each(function(){
        $(this).removeClass('ui-body-c').addClass('ui-body-' + theme);    
    });
    $('.ui-body-d').each(function(){
        $(this).removeClass('ui-body-d').addClass('ui-body-' + theme);    
    });
    $('.ui-body-e').each(function(){
        $(this).removeClass('ui-body-e').addClass('ui-body-' + theme);    
    });

    //reset the page widget
    $('[data-role=page]').removeClass(
            'ui-body-a ui-body-b ui-body-c ui-body-d ui-body-e').addClass(
            'ui-body-' + theme).attr('data-theme', theme);
                    
    //the only difference between this block of code and the same code above is that it doesn't target list-dividers by calling: `.not('.ui-li-divider')`
    $('[data-role=page]').find('.ui-btn').not('.ui-li-divider').removeClass(
            'ui-btn-up-a ui-btn-up-b ui-btn-up-c ui-btn-up-d ui-btn-up-e ui-btn-hover-a ui-btn-hover-b ui-btn-hover-c ui-btn-hover-d ui-btn-hover-e').addClass(
            'ui-btn-up-' + theme).attr('data-theme', theme);

    //target the list divider elements, then iterate through them to check if they have a theme set, if a theme is set then do nothing, otherwise change its theme to `b` (this is the jQuery Mobile default for list-dividers)
    $('[data-role=page]').find('.ui-li-divider').each(
            function(index, obj) {
                if ($(this).parent().attr('data-divider-theme') == 'undefined') {
                    $(this).removeClass(
                            'ui-bar-a ui-bar-b ui-bar-c ui-bar-d ui-bar-e').addClass(
                            'ui-bar-b').attr('data-theme', 'b');
                }
            })

    /////HEADER Section
    //reset all the buttons widgets
    $('[data-role=header]').find('.ui-btn').removeClass(
            'ui-btn-up-a ui-btn-up-b ui-btn-up-c ui-btn-up-d ui-btn-up-e ui-btn-hover-a ui-btn-hover-b ui-btn-hover-c ui-btn-hover-d ui-btn-hover-e').addClass(
            'ui-btn-up-' + theme).attr('data-theme', theme);

    //reset the header/footer widgets
    $('[data-role=header]').find('.ui-header, .ui-footer').removeClass(
            'ui-bar-a ui-bar-b ui-bar-c ui-bar-d ui-bar-e').addClass(
            'ui-bar-' + theme).attr('data-theme', theme);

    //reset the page widget
    $('[data-role=header]').removeClass(
            'ui-body-a ui-body-b ui-body-c ui-body-d ui-body-e').addClass(
            'ui-body-' + theme).attr('data-theme', theme);
    /////Footer Section
    //reset all the buttons widgets
    $('[data-role=footer]').find('.ui-btn').removeClass(
            'ui-btn-up-a ui-btn-up-b ui-btn-up-c ui-btn-up-d ui-btn-up-e ui-btn-hover-a ui-btn-hover-b ui-btn-hover-c ui-btn-hover-d ui-btn-hover-e').addClass(
            'ui-btn-up-' + theme).attr('data-theme', theme);

    //reset the header/footer widgets
    $('[data-role=footer]').find('.ui-header, .ui-footer').removeClass(
            'ui-bar-a ui-bar-b ui-bar-c ui-bar-d ui-bar-e').addClass(
            'ui-bar-' + theme).attr('data-theme', theme);

    //reset the page widget
    $('[data-role=footer]').removeClass(
            'ui-body-a ui-body-b ui-body-c ui-body-d ui-body-e').addClass(
            'ui-body-' + theme).attr('data-theme', theme);

}

OUCSS.PageEvents = {};

//Cache Labels, Lookups
OUCSS.CacheMgr = ( function (OUCSS) {
    
    var labels = {length:0};
    var lookups = {length:0};
	var messages = {length:0};
    
    return {
        labels : labels,
        lookups: lookups,
		messages: messages, 
        
        getLabel: function(key) {
            return labels[key];
        },
		
		getMessage: function(key) {
            return messages[key];
        }


    };
})(OUCSS);

//AJAX call
OUCSS.AJAX = (function (OUCSS) {
    function serviceSuccess () {
        //OUCSS.Utilities.log('AJAX SUCCESS');
    }
    
    //show error message in a popUp. ppopup shud be defined in each page with a different ID so that it does not conflict with other pages
    function serviceFailure (xjr, desc, error, customErrorMsg) {
        
        var errorMsg;
		var util = OUCSS.Utilities;
        util.log('AJAX Service call FAILURE');
		util.hideLoading();
		
	 
	        // If invalid username or password, then don't proceed further. 
			if(xjr.status == 403 || xjr.status == 401) {
			    	errorMsg = 'Authentication Failure: Invalid Username or Password';
		        
			} else if(xjr.status == 404){ 
				
				    errorMsg = "Error connecting to the server";
			}
			else if(xjr.responseText != undefined && xjr.responseText != ''){
				util.log(xjr.status||' ' ||desc||' ' ||error);
				var response = $.parseJSON(xjr.responseText);
				
				if(response.restFaultBean){
					util.log(response.restFaultBean.faultDetail);
					errorMsg = response.restFaultBean.faultSummary;
				}
				else
				   errorMsg = customErrorMsg;			
				
			}
						
			//Show error message inline in the page
			$('#errorText').text(errorMsg);
			$('#errorDiv').show();
    }
    
    function invokeService (service, ajaxArgs, args) {
            var onSuccess = serviceSuccess, onFailure = serviceFailure, method = "GET",urlContext = CMConfig.restServerURL;  
            
            
            if(ajaxArgs.onSuccess)
                onSuccess = ajaxArgs.onSuccess; 
            if (ajaxArgs.onFailure)
                onFailure = ajaxArgs.onFailure;
            if (ajaxArgs.method)            	
                method = ajaxArgs.method;
			    
            
            var username=OUCSS.CSSApp.getGlobalContext().username; var password=OUCSS.CSSApp.getGlobalContext().password;
            var auth = "Basic " + btoa(username + ":" + password);
			var headers = { "Accept": "application/json; charset=utf-8", "Authorization" : auth}; 
			


			if (ajaxArgs.urlType && ajaxArgs.urlType == 'public') 
			{
			   urlContext = CMConfig.publicRestServerURL;
			   headers = {	"Accept" : "application/json; charset=utf-8"};
		    };
		    
            var ajaxObject= {
                url : urlContext+service,
                type : method,
                async : true,
                data : args,
                dataType:  'json',
                success : onSuccess,
                error : onFailure,
                headers: headers,
				timeout: 10000
            };
			
			if (ajaxArgs.contentType) 
			   ajaxObject["contentType"] = ajaxArgs.contentType;
			
			 //console.log(JSON.stringify(ajaxObject));
			   
			   
            $.ajax(ajaxObject);
        }
    
    return {
        invokeService: invokeService ,
		serviceFailure : serviceFailure
    };
})(OUCSS);

//Web SQL Handler. Calls REST services to load Labels, Lookups and loads into Web SQL if needed.
OUCSS.DB = ( function(OUCSS) {
    
var dbHandle = {};
    
    function dbError(tx, err) {
           OUCSS.Utilities.log('DB Error  -  '+err.message+'  - '+err.code);
    }
    
    function dbSuccess () {
        console.log('db success');
    }
    
    function cleanDB() {
        dbHandle.transaction(function(tx) { tx.executeSql('delete from SS_LABELS;', [], dbSuccess, dbError)});
    }
    
    function objectSaved () {
        console.log('object saved');
    }
    
    function objectNotSaved () {
        console.log('object could not be saved');
    }
    
    function handleLabelResponse (response, status) {
        //dump the data to DB and also populate the cache
        OUCSS.Utilities.log('handleLabelResponse');
        $.each(response.cacheList, function(i, item) {
            OUCSS.CacheMgr.labels[item.key] = item.value;
            dbHandle.transaction(function(tx) { tx.executeSql('insert into SS_LABELS (label, desc) VALUES (?, ?)', [item.key, item.value])});
        });        
        
    }
	
	 function handleMessageResponse (response, status) {
        //dump the data to DB and also populate the cache
        OUCSS.Utilities.log('handleMessageResponse');
        $.each(response.cacheList, function(i, item) {
            OUCSS.CacheMgr.messages[item.key] = item.value;
            dbHandle.transaction(function(tx) { tx.executeSql('insert into SS_MESSAGES (msg_cd, desc) VALUES (?, ?)', [item.key, item.value])});
        });        
        
    }
    
    function populateLabelsCache(transaction, results) {
        
            // Handle the results            
            var dataLen = results.rows.length;
            
            //dataLen=0;
            OUCSS.Utilities.log('Num of Labels in DB'+dataLen);
            //If no labels in local web sql, call Labels service and populate local DB
            if (dataLen == 0) {
                
                var ajaxArgs = {'onSuccess' : handleLabelResponse};		    	    
                OUCSS.CSSApp.invokeService("cache/OUCSSLabelCache", ajaxArgs, {});
                return;
            }
            
            //Populate Cache
            for (var i=0; i < dataLen; i++) {      
                var row = results.rows.item(i);
                OUCSS.CacheMgr.labels[row['label']] = row['desc'];  
            }
            
    }
	
	 function populateMessagesCache(transaction, results) {
        
            // Handle the results            
            var dataLen = results.rows.length;
            
            //dataLen=0;
            OUCSS.Utilities.log('Num of Messages in DB'+dataLen);
            //If no messages in local web sql, call Messages service and populate local DB
            if (dataLen == 0) {
                
                var ajaxArgs = {'onSuccess' : handleMessageResponse};		    	    
                OUCSS.CSSApp.invokeService("cache/OUCSSMessageCache", ajaxArgs, {});
                return;
            }
            
            //Populate Cache
            for (var i=0; i < dataLen; i++) {      
                var row = results.rows.item(i);
                OUCSS.CacheMgr.messages[row['msg_cd']] = row['desc'];  
            }
            
    }
	
    
    function initLabels() {
        //search the DB, if labels exist populate the labels cache, otherwise call the service and populate both db and cache.
    	dbHandle.transaction(function(tx) { tx.executeSql("SELECT * from SS_LABELS", [], populateLabelsCache, dbError)});
        
    }
	
	function initMessages() {
        //search the DB, if messages exist populate the messages cache, otherwise call the service and populate both db and cache.
    	dbHandle.transaction(function(tx) { tx.executeSql("SELECT * from SS_MESSAGES", [], populateMessagesCache, dbError)});
        
    }
    
    function initLookups() {
           	
        //Lookups services will be called from individual pages to get the latest Lookup data instead of caching it in the app
    } 
	
	function initAccessCache(){
		
		var handleAccessResponse = function handleAccess (response, status) {
        //dump the data to DB and also populate the cache
        OUCSS.Utilities.log('handleAccessResponse');
		
        $.each(response.cacheList, function(i, item) {
            dbHandle.transaction(function(tx) { tx.executeSql('insert into SS_ACCESS_CACHE (user_name, lob,portlet_cd,allowed_action) VALUES (?, ?)', ['', item.lob,item.portletCode,item.allowedAction])});
        });        
        
    };
		
		var populateAccessCache = function populateAccess(transaction, results) {
        
            // Handle the results            
            var dataLen = results.rows.length;
            
            //dataLen=0;
            OUCSS.Utilities.log('Num of Resource Access information in DB'+dataLen);
			
            //If no data in local web sql, call REST service and populate local DB
            if (dataLen == 0) {
                
                var ajaxArgs = {'onSuccess' : handleAccessResponse};		    	    
                OUCSS.CSSApp.invokeService("cache/OUCSSPortletAccessCache?searchCode=ACCOUNT_HOLDER", ajaxArgs, {});
                return;
            }
            
    };
		
		dbHandle.transaction(function(tx) { tx.executeSql("SELECT * from SS_ACCESS_CACHE", [], populateAccessCache, dbError)});
	}
	

    function getHandle() {

		// If this is null, then initialize and return.
        if(dbHandle.transaction == null) {
            return initDB();
        }

        return dbHandle;
    }
    
    function initDB() {
        var dbVersion = "1.0" //maybe this will be read from a conf./js file
        dbHandle = openDatabase('OUCSSDB', dbVersion, 'OUCSS Database', 2 * 1024 * 1024);
        
        //create Labels and Lookup tables
        dbHandle.transaction(function (tx) { tx.executeSql('CREATE TABLE IF NOT EXISTS SS_LABELS (label text unique primary key, desc text)')});
        dbHandle.transaction(function (tx) { tx.executeSql('CREATE TABLE IF NOT EXISTS SS_LOOKUPS (lookup_cd text , key text, value text)')});
        dbHandle.transaction(function (tx) { tx.executeSql('CREATE TABLE IF NOT EXISTS SS_MESSAGES (msg_cd text unique primary key, desc text)')});
        dbHandle.transaction(function (tx) { tx.executeSql('CREATE TABLE IF NOT EXISTS SS_ACCESS_CACHE (user_name text, lob text, portlet_cd text, allowed_action text)')});
		
		return dbHandle;
    }


    return {
        init: function () {
            //initialize DB and tables that are barely essential to launch the App.            
            // If this is null, then initialize and return.
			if(dbHandle == null) {
				initDB();
			}
			
            initLabels();
            initLookups();
			initMessages();
			//initAccessCache();
        },
        getHandle: getHandle
        
    };
})(OUCSS);

//Cannot intialize database and call REST services without credentials
//OUCSS.DB.init();

//Page Event handlers
OUCSS.CSSApp = ( function (OUCSS) {
	
	 //module dependency 
    var util = OUCSS.Utilities;
    var store = OUCSS.Storage;
    var ajax = OUCSS.AJAX;
    var db = OUCSS.DB;
    
   jQuery.support.cors = true;
   var pageContext = {};
   var globalContext = {};
   
   function formServiceSuccess(data, status) {
       util.logPageContext(arguments.callee.name);
        //hide the search filters and show the results
       if(!pageContext.nextPage && pageContext.pageType == "search") {
            $("#filters").toggle();
            $("#result").toggle();
            renderPage(data, $("result"));
       }
       else {
           //either navigate to nextPage if defined
           //or display the response on a default page(dialog)
       }
           
   }
    
    function pageServiceSuccess(data, status) {
        //allow CM/Base override
        renderPage(data);
    }
    
    function pageServiceFailure(request, status, error) {
       util.log('error calling service ' + error);
        //$.mobile.showPageLoadingMsg();
    }
    
    /**
     * Generic Form Submissions.
     * Base and CM can override this
     */
    function pageSubmitForm(e) {
		OUCSS.Utilities.log('Common Page Submit Logic');
		
        e.preventDefault(); 
        e.stopPropagation(); //without this it was still invoking action of the form
        //add logic for CM override
        //this method can be overridden to allow custome code to handle form submit
        var pageId = $.mobile.activePage.attr('id');
          if(OUCSS.PageEvents[pageId] && OUCSS.PageEvents[pageId].pageSubmitForm) {
             OUCSS.PageEvents[pageId].pageSubmitForm();      
             return;
          }
       var ajaxArgs = {onSuccess: formServiceSuccess, method: $(this).attr('method')};
       invokeService($(this).attr('action'), ajaxArgs, $(this).serializeArray());
       util.log('form submitted with data - ' +  JSON.stringify($(this).serializeArray()));
       
            
    }
    
    /**
     * CM Page redierection logic. 
     * This is called in JQM before sending an AJAX request for requested page/url. We invoke this on default page action to navigate to nextPage
     */
    function pageBeforeChange(event, data) {        
        
         if (typeof data.toPage !== 'string') {
                return;
         }
        var loc = data.toPage.indexOf("#");
        var pageId = data.toPage.substring(loc);
        
        //redirect to custom page except login and springboard
        if(pageId != '#login' && pageId != "#springboard")
        {
            var nextPage;
            if (loc == -1){
                var loc = data.toPage.indexOf("/mods/");
                nextPage = data.toPage.substring(loc);
            } else {
                nextPage = pageId;
            }
            nextPage = URLMapping[nextPage];
            if(nextPage){
                data.toPage = nextPage;
            }               
        }
      
        //cleanup the page context before we land on next page
        if(data.options.data != undefined) {
            pageContext = {inputArgs: data.options.data.inputArgs };
            if(data.options.data.inputData)
                pageContext.inputData = data.options.data.inputData; 
            
        } else {
            pageContext = {};
        }
        
        //read page arguments and update pageContext
        var paramsIndex = data.absUrl.indexOf("?");
         if (paramsIndex != -1 ) {


            var absURL = data.absUrl.substring(paramsIndex +1);
            var paramsList  = absURL.split('&');
            for (var i = 0; i < paramsList.length; i++)
            {
                var param  = paramsList[i].split('=');
                if(!pageContext.inputArgs)
                    pageContext.inputArgs = {};
                pageContext.inputArgs[param[0]] = param[1];
            }
        }
        
        setTheme(cssTheme);
    }
    
    /**
     * Parse the page metadata, call service or associate form events
     */
    function pageBeforeShow(e) {
            
            //read page attributes
            pageContext.pageService = $.mobile.activePage.attr('oucss-service');
            
            //allow only one form per page (do we really need to support more than 1 on a page?)?
           // var pageForm = $.mobile.activePage.attr('oucss-form');
            pageContext.pageId = $.mobile.activePage.attr('id');
            pageContext.pageType = $.mobile.activePage.attr('oucss-pageType');
            pageContext.nextPage = $.mobile.activePage.attr('oucss-nextPage');
            pageContext.pageData={};
            
            
            //by default form submission is handled by FW but can be overriden with a custom handler
            $.mobile.activePage.find("form").on('submit', pageSubmitForm);
            
           //invoke the page service that populates the page with data
          //TODO: there has to be standard that we need to follow to pass the input to services
            var args = JSON.stringify({"input": pageContext.inputArgs}) ; 
            var ajaxArgs = {method: "POST"};
            
            var pageId = $.mobile.activePage.attr('id');
            pageContext.pageID = pageId;     		
			
			
            displayLabels();            
            displayLookups();
			
			var show_hide_labels = function() {
				
				var height = $(window).height();
				var width = $(window).width();	
				if(pageId != 'reportPublicOutage'){
					if (width <= 400 ) 
						$.mobile.activePage.addClass('ui-hide-label');				
					else 
				        $.mobile.activePage.removeClass('ui-hide-label').addClass('ui-show-label');
			    
				}
				else{
					if (width <= 400 ) 
						$("#outagesForm").addClass('ui-hide-label');				
					else 
				        $("#outagesForm").removeClass('ui-hide-label').addClass('ui-show-label');
				}
				
		  	};
		  	show_hide_labels();
		  	$(window).resize(show_hide_labels);
            
            //If the page has a pageBeforeShow function, call it
            if(OUCSS.PageEvents[pageId] && OUCSS.PageEvents[pageId].pageBeforeShow) {
                
            	//Call page specific base logic
            	OUCSS.PageEvents[pageId].pageBeforeShow( e);  
                
                //Call CM extension hook for pageBeforeShow
            	if(OUCSS.PageEvents[pageId].cmext && OUCSS.PageEvents[pageId].cmext.pageBeforeshow) {
        			OUCSS.PageEvents[pageId].cmext.pageBeforeshow();  			
        		}
            	
            }
            else{
                //Call Page service and use default renderer
            	if(pageContext.pageService)
            		 invokeService(pageContext.pageService, ajaxArgs, args);
            }
//          else
//                  render(Pagecontext.data)

            
            util.logPageContext("pageBeforeShow"+pageId);
            setTheme(cssTheme);
    }

	 /**
     * This function can be overriden
     */
    function invokePageAction(evt) {

        //unload page data back to model(pageContext.pageData) and call the page action
        //set page next action from current element
        

        unloadPageData();
	}

	 /**
     * load page data from HTML elements back to page model (mostly on any user action, e.g. page buttons)
     */
    function unloadPageData() {
        util.logObj("Page Model Before Unload: ", pageContext.pageData);
        
        var elems = $("[oucss-path]", $.mobile.activePage).each(function() {
            var oucssPath = $(this).attr('oucss-path');
            var oucssPathValue = undefined;
            
            switch($(this).prop('tagName')) {
                case "TABLE":
                    var tableData = new Array();
                    $(this).find("tbody > tr").each(function() {
                            if($(this).attr("oucss-template"))
                                return true;
                            var row = {};
                            $(this).find("[oucss-listpath]").each(function() {
                                var path = $(this).attr("oucss-listpath");
                                var value = getElementValue($(this));
                                if(value && value != "undefined")
                                    row[path] = value;

                                //TODO: check for sublists - find([oucss-subpath] and attr( oucss-sublistpath)
                            });
                            if(!jQuery.isEmptyObject(row))
                                tableData.push(row);
                        });

                    oucssPathValue = tableData;
                    break;

				case "SELECT":					
                    oucssPathValue =  getElementValue($(this));
                    break;
                
				case "INPUT":					
                    oucssPathValue =  getElementValue($(this));
                    break;
                
				case "TEXTAREA":
                    oucssPathValue =  getElementValue($(this));
                    break;

                default:				
                    oucssPathValue =  getElementValue($(this));
                    break;
            }
            updatePageModel(oucssPath, oucssPathValue);
        });
        util.logObj("Page Model After Unload: ", pageContext.pageData);

    }

    //move this function to common.js
    function getElementValue(el) {
        var value;
        switch(el.prop('tagName')) {
            case "INPUT":
                value = el.val();
                break;
            case "SELECT":
                value =  el.find("option:selected").val();
                break;
            case "SPAN":
                value = el.text();
                break;
            case "TEXTAREA":
                value = el.val();
                break;
			
            default:
                value = el.val();
                break;
        }
        return value;
    }
    
    function updatePageModel(path, value, data) {

        if (!data)
            data = pageContext.pageData; //outside (non-recursive) call, use "data" as our base object
			
        var keys = path.split('.'); //split the key by the dots
		
        if (keys.length < 2) {
          data[keys[0]] = value; //only one part (no dots) in key, just set value
        } else {
          if (!data[keys[0]])
              data[keys[0]] = {}; //create our "new" base obj if it doesn't exist
          data = data[keys.shift()]; //remove the new "base" obj from string array, and hold actual object for recursive call
          updatePageModel(keys.join("."),value,data); //join the remaining parts back up with dots, and recursively set data on our new "base" obj
        }
        return data;
    }
    
    function pageShow(e) {
    	var pageId = $.mobile.activePage.attr('id');
    	if(OUCSS.PageEvents[pageId] && OUCSS.PageEvents[pageId].pageShow) {
            OUCSS.PageEvents[pageId].pageShow();      
            return;
        }
    }
    
    function invokeService( service, ajaxArgs, args ) {

          if(!ajaxArgs.onSuccess)
              ajaxArgs.onSuccess = pageServiceSuccess; 
          if (!ajaxArgs.onFailure)
              ajaxArgs.onFailure = pageServiceFailure;
          if (!ajaxArgs.method) 
              ajaxArgs.method = "GET";
          
          util.log("invoking service "+service+" with arguments "+JSON.stringify(args));
          ajax.invokeService(service, ajaxArgs, args);
          return true;
      }

    function getPageContext() {
        return pageContext;
    }
    
    function setPageContext(data) {
        $.each(data, function(key, value) {
            pageContext[key] =  value;
        });         
    }
    
    function getGlobalContext() {
        return globalContext;
    }
    
    function setGlobalContext(data) {
        $.each(data, function(key, value) {
            globalContext[key] =  value;
        });
    }
    
    function displayLabels(){

           $("[oucss-label]", $.mobile.activePage).each(function() {
                    var labelName = $(this).attr('oucss-label');
                    console.log($(this).prop('tagName')+'-'+labelName);
                    
                    switch($(this).prop('tagName')) {
                        case "INPUT":				
                           $(this).prop('value', OUCSS.CacheMgr.getLabel(labelName)).button('refresh');				   
                           break;
                        
                        case "LABEL":
                           $(this).html(OUCSS.CacheMgr.getLabel(labelName));
                            break;
                            
                         case "H3":
                           $(this).text(OUCSS.CacheMgr.getLabel(labelName));
                            break;
                         case "B":
                           $(this).text(OUCSS.CacheMgr.getLabel(labelName));
                            break;
                    }
                    
           });           
            
      }  
	  
	  //Call Rest service to fetch lookup data
	  function displayLookups(){
		   var idList=[];
		   
		   $("[oucss-lookup]", $.mobile.activePage).each(function() {
                    var lookupName = $(this).attr('oucss-lookup');
                    idList.push(lookupName);
                    
           }); 
		  
		  var ajaxArgs = {'onSuccess' : renderLookups};		
		  var argsList='', exists=false;
		  
		  //Arguments..append with searchCode string
		   $.each(idList, function(i, item) {
              argsList = argsList + 'searchCode=' + item +'&';
			  
        });        
		  
		  if(idList.length > 0)
          OUCSS.CSSApp.invokeService("cache/OUCSSLookupCache", ajaxArgs, argsList);
		  
	  }
	  
	  
      //Render the Lookups in the page
      function renderLookups(response, status){
		   
		    $.each(response.cacheList, function(i, item) {
				
				 lookupCode = item.searchCode;
				 var node = $("[oucss-lookup="+lookupCode+"]", $.mobile.activePage);
				 
				 for (var i =0, len = item.cacheList.length; i < len; i++) {
			 	 	node.append($('<option></option>').val(item.cacheList[i].lookupValue).html(item.cacheList[i].description)).selectmenu('refresh');;
				 }
        	}); 
            
      }
    
    function renderPage( data ) {
        //Save this data as the model for current page
        pageContext.pageData = data;
        //page rendering logic here, anyone call this method with their own data
        //This logic should do a DFS on each element and parse the elements attributes to populate data(oucss-path) and labels(oucss-label)
        var elems = $("[oucss-path]", $.mobile.activePage).each(function() {
            var oucssPath = $(this).attr('oucss-path');
            switch($(this).prop('tagName')) {
                case "DIV":
                    var jqmGrid = {'ui-grid-a': 2, 'ui-grid-b': 3, 'ui-grid-c': 4, 'ui-grid-d': 5};
                    var jqmBlockCSSPath = [{'css':'ui-block-a', 'path': ''}, {'css':'ui-block-b', 'path': ''}, {'css':'ui-block-c', 'path': ''}, {'css':'ui-block-d', 'path': ''}, {'css':'ui-block-e', 'path': ''}]; 
                    
                    //Get the class of div
                    var cname = $(this).attr('class');
                    //render as table/grid
                    if(jqmGrid[cname]) {
                        var jqmBlockPath = ['','','','',''];
                        celems = $(this).prop('childNodes');
                        //Populate the oucss-path of child elements to jqmBlockCSSPath
                        $(this).children('div').each(function(i) { 
                            jqmBlockCSSPath[i]['path'] = $(this).attr('oucss-path');
                        });
                        
                        //Loop through the data rows
                        for(var j = 0, jlen = data[oucssPath].length; j < jlen; j++ ) {
                            
                            //Loop thru the child elements
                            for(var k =0, klen = jqmGrid[cname]; k< klen; k++) {
                            	//Add a new div for each column, set CSS class, add data to <p> element
                                $("<div>").attr("class",jqmBlockCSSPath[k]['css']).append($("<p>").html(data[oucssPath][j][jqmBlockCSSPath[k]['path']])).appendTo($(this));
                            }
                        }
                    }
                    console.log(JSON.stringify(data[oucssPath]));
                    break;
                case "TABLE":
                    //get length of elements in data
                    //create that many rows ian existing table
                    //add the data to table
                    var items = getData(data, oucssPath);
                    if(!items.length) {
                        items = new Array(items);
                    }
                    var el = $(this).find('tr').last().prev();
                    
                    for (var i =0, len = items.length; i < len; i++) {
                        
                        el.find("[oucss-listpath]").each(function () { 
                            $(this).attr("value",items[i][$(this).attr("oucss-listpath")]);
                            
                        });
                        var newEl = el.clone();
                        newEl.children(":first").on("click", delRow);
                        newEl.insertAfter(el).find( 'input:text' ).val( '' );
                        el = newEl;
                    }
                    break;
                case "SELECT":
                    //get the oucss-path and oucss-optionsPath(key:value) and create options accordingly
                    var items = getData(data, oucssPath);
                    var keyValue = $(this).attr("oucss-optionsPath").split(':');//
                    
                    //convert this itme into an array if it is not (rest API is returning single items of a list as an item and not array)                    
                    if(!items.length) {                        
                        items = new Array(items);
                    }
                    for (var i =0, len = items.length; i < len; i++) {
                        $(this).append($('<option></option>').val(items[i][keyValue[0]]).html(items[i][keyValue[1]])).selectmenu('refresh');;
                    }
                    break;
                case "LABEL":                    
                     OUCSS.Utilities.log(" renderer not implemented for Tag - "+$(this).prop('tagName'));
                    break;
                case "INPUT":
                    $(this).attr("value",data[oucssPath]);
                    break;
                case "SPAN":
                    $(this).text(getData(data, oucssPath));
                    break;
                case "UL":
                     OUCSS.Utilities.log(" renderer not implemented for Tag - "+$(this).prop('tagName'));
                    break;
                default:
                    OUCSS.Utilities.log(" renderer not implemented for Tag - "+$(this).prop('tagName'));
                
            }
        });
    }

	/**
     * Find value for a given key in pageContext or globalContext
     */
    function findValueInContext(key) {
        if (pageContext.inputArgs && pageContext.inputArgs[key]) {
            return pageContext.inputArgs[key];
        }

        if (globalContext.key) {
            return globalContext.key;
        }
        return undefined;
    }
    
    function launchPopup(msgCode, divId, back) {
            
            $( "#"+divId ).popup();
            
            $("#message", "#"+divId).html(
                '<H3>'
                        + msgCode                       
                        + '</H3>');           
            
             $("#popupBtn","#"+divId).removeClass( 
            'ui-btn-up-a ui-btn-up-b ui-btn-up-c ui-btn-up-d ui-btn-up-e ui-btn-hover-a ui-btn-hover-b ui-btn-hover-c ui-btn-hover-d ui-btn-hover-e').addClass(
            'ui-btn-up-' + 'b').attr('data-theme', 'b');
            
             $("#popupBtn","#"+divId).click(function() { 
                if(back == 999){
                	window.location.href = '../../Login.html';
                }else{
                	history.go(back);
			     }
            });
            $( "#"+divId ).popup( "open" );
                      
    }

	function terminateWithError(msgCat, msgNbr, parmArray, pathSeg) {

    parmArray === undefined ? parms = [] : parms = parmArray;
    pathSeg === undefined ? errorPath = [] : errorPath = pathSeg;
    
	util.log("ERROR("+msgCat+","+msgNbr+"):::" + metadata.getMessage(msgCat, msgNbr) + " ::AT:: "+ errorPath);
    
	return {message:  metadata.getMessage(msgCat, msgNbr), arguments: parms, elemPath: errorPath};

	}

    
    
    
return {        
        //navContext: {}, //arguments passed to current page, maybe not required
        init: function() {
            
            //redirect to a CM page
            $(document).on("pagebeforechange", pageBeforeChange);
            
            //parse the page metadata, call service or associate form events
            $(document).on('pagebeforeshow', pageBeforeShow);    
            
            //custom UI after page is rendered
            $(document).on('pageshow', pageShow);    
            
           
        },
        getGlobalContext: getGlobalContext, //never cleared
        setGlobalContext: setGlobalContext,
        getPageContext: getPageContext, //context specific to current page, reset to arguments/context passed to current page on pagechange
        setPageContext: setPageContext,
        renderPage: renderPage,
        invokeService: invokeService,
        launchPopup: launchPopup,
        displayLabels: displayLabels,
        displayLookups: displayLookups,		
        invokePageAction: invokePageAction,		
        updatePageModel: updatePageModel,
		terminateWithError : terminateWithError
   };
})(OUCSS);

OUCSS.CSSApp.init();


//misc
$.fn.serializeObject = function()
{
    var o = {};
    var a = this.serializeArray();
    $.each(a, function() {
        if (o[this.name] !== undefined) {
            if (!o[this.name].push) {
                o[this.name] = [o[this.name]];
            }
            o[this.name].push(this.value || '');
        } else {
            o[this.name] = this.value || '';
        }
    });
    return o;
};


$(document).ready(	
		function() {
			
			var util = OUCSS.Utilities;
			util.log("Document Ready function Called");
			
			// Enable Cross Site scripting
			$.support.cors = true; 
			
			setTheme(cssTheme);		
			
            //Set default Map type to GOOGLE
			var data={'mapType' : "MAPVIEWER"};				
			OUCSS.CSSApp.setGlobalContext(data);

});