var usageData = [];
var saIndex = 0;
var heightSet = false;
var acctId=OUCSS.CSSApp.getGlobalContext().contextAcctId;
var saExists = false;

var ajaxDataRenderer = function(url, plot, options) {
	
	return usageData[saIndex].usage;
};  

//// Function to show Usage graph when the page loads
OUCSS.PageEvents.usageSummarySmartMeter = {
	
	    pageBeforeShow : function(e){	   
		   
		   
		   if(acctId == undefined)
			{				 
				 window.location.replace('../../Login.html');
			}
			
		   $('#acctInfoMeter').text('Account : '+acctId);
		   
	   },
		
		
		pageShow   : function(){	
                  
                			 
                  //Get Usage Data for all SAs using Rest service
				 var startDate = new Date().yyyymmdd() + 'T00:00:00';
				 var ajaxArgs = {'onSuccess' : getUsageData, 'onFailure' : OnReadError};
				 var args = { 'key1':acctId , 'referenceDateTime' : startDate, 'action':'READ'};		
			     
			     //Show loading sign
			     OUCSS.Utilities.displayLoading();    	    
				 OUCSS.CSSApp.invokeService("SSUsageOverviewService", ajaxArgs, args);
				  
}};

Date.prototype.addHours= function(h){
    var copiedDate = new Date(this.getTime());
    copiedDate.setHours(copiedDate.getHours()+h);
    return copiedDate;
}

//Handle errors from service call
function OnReadError(xjr, desc, error){
	
	  OUCSS.AJAX.serviceFailure (xjr, desc, error, 'Error getting the Consumption information');
	
}

function getUsageData(data, status){
    
   if(data.mainData.results){
	   
	   OUCSS.Utilities.log('SA Exists');
	   
	     
		  
		  var results = data.mainData.results;
		  if(!results.length) {
                        results = new Array(results);
           }
		   
		  //Loop through SAs data. There can be multiple SAs
		  $.each(results, function(i, sa) {
		  
				var dateString = sa.startDateTime;
				//OUCSS.Utilities.log(dateString);
				
				if(dateString != '' && dateString != undefined)
				{
					//Active SAs exist for this account
	                saExists = true;
		 
					var reggie = /(\d{4})-(\d{2})-(\d{2})T(\d{2}):(\d{2}):(\d{2})/;
					var dateArray = reggie.exec(dateString); 
					var startDate = new Date(
						(+dateArray[1]),
						(+dateArray[2])-1, // Careful, month starts at 0!
						(+dateArray[3]),
						(+dateArray[4]),
						(+dateArray[5]),
						(+dateArray[6]));
					
					var saData=[[]];
					var saObject = new Object();
					saObject.saInfo=sa.saInfo;
					  
					$.each(sa.measurements, function(i, item) {				
									
						var q = parseFloat(item.quantity);	
						
						saData[0].push([startDate, q]);
						startDate=startDate.addHours(1);
						
					});
					saObject.usage=saData;
					usageData.push(saObject);
				}
		  });
	}	  
		  
	  if(saExists == true)
	  {
	  
		  //Render SA List
		  renderUI();			  
						  
		  //Render Graph for first SA
		  renderGraph(); 
		  
		  //Bind event handling logic
		  //Refresh the graph if a different SA is selected
		  $('#saList').change(function() {
			  
			saIndex = $(this).val();
			renderGraph();
		  }); 
	  }   
      else
	  {
		  $('#noSAExistMsg').show();
	  }
	  
	$('#errorDiv').hide();
	OUCSS.Utilities.hideLoading();
	
  };

//Render SA List  
function renderUI(){
	var saList =  '<select class="dropDownTxt" data-mini=\'true\' name=\'saList\' id=\'saList\' >';
				$.each(
						usageData,
						function(i, usage) {
							saList = saList
									+ '<option  value='+i+'>'
									+ usage.saInfo
									+ '</option>';
						});
				saList = saList
						+ '</select><br>';
				
				console.log(saList);
						
	$('.saListDiv').empty();
	$('.saListDiv').append(saList).trigger('create');
	
}; 
  

function renderGraph(){
	
	var height = ($(window).height()
			- $("#usageSummarySmartMeter").find('[data-role="header"]').outerHeight()
			- $("#usageSummarySmartMeter").find('[data-role="footer"]').outerHeight() 
			- $("#saListDiv").outerHeight()
			- $("#acctHeader").outerHeight());
	if(!heightSet){
	    $("#chart").height(height * 0.8);
		heightSet =  true;
	}
  
  $.jqplot.config.enablePlugins = true;  
    
  var plot1 = $.jqplot('lineChart',[],  {
      title:'One Week Overview',
	  dataRenderer: ajaxDataRenderer,	  
	  seriesDefaults:{showMarker:false,
	       pointLabels:{
			   show:false
			   }		   
	      },
      axes:{
        xaxis:{
          renderer:$.jqplot.DateAxisRenderer,
          tickRenderer: $.jqplot.CanvasAxisTickRenderer,
          tickOptions: {
              // labelPosition: 'middle',
              angle: 90,
			  formatString:'%b %#d,%Y',
			  textColor : '#000000'
          },
          tickInterval:'1 day'		  
        },
        yaxis:{
          tickOptions:{
			  formatString:'%.2f',
			  textColor : '#000000'
            }
        }
      },
     highlighter: {
      show: false
    },
    cursor: {
      show: true,
      tooltipLocation:'nw'
    }
  });
  
  plot1.resetAxesScale();
  plot1.replot();
  
  
}

