var acctId=OUCSS.CSSApp.getGlobalContext().contextAcctId;
var perId=OUCSS.CSSApp.getGlobalContext().contextPerId;
var util = OUCSS.Utilities;


OUCSS.PageEvents.makePaymentPage = {
		
		pageBeforeShow:	function() {				   
		   
		   var acctId=OUCSS.CSSApp.getGlobalContext().contextAcctId;
		   if(acctId == undefined)
			{				 
				 window.location.replace('../../Login.html');
			}
			
			//Bind event for Payment Type change
			handlePaymentType();
			
			var d = new Date();
            var currentYear=d.getFullYear();
            var year=currentYear;
            var currentDate='-'+d.getMonth()+'-'+d.getDay();
            var paymentDate=d;
							
			$('#key1').val(acctId);
			$('#key2').val(perId);
			$('#payDate').val(paymentDate.yyyymmdd());
			
			$('#acctInfoPay').text('Account : '+acctId);
			
		},
		
		pageShow : function() {
			$('#paymentInfoDiv').find('.ui-btn').removeClass(
		    'ui-btn-up-a ui-btn-up-b ui-btn-up-c ui-btn-up-d ui-btn-up-e ui-btn-hover-a ui-btn-hover-b ui-btn-hover-c ui-btn-hover-d ui-btn-hover-e').addClass(
		    'ui-btn-up-d').attr('data-theme', "d");
			

			OUCSS.Utilities.log('Account Summary account Selected : '+acctId);		
			
			pageId='makePaymentPage';	
			var ajaxArgs = {'onSuccess' : renderData, 'onFailure' : OnReadError};
			
			//Display data
			//Custom Extension call to invoke custom service
			if(OUCSS.PageEvents[pageId].cmext && OUCSS.PageEvents[pageId].cmext.invokeService) {
    			OUCSS.PageEvents[pageId].cmext.invokeService();  			
    		}
			//Base code
			else{
				
				var args = {'key1':acctId ,'action':'READ' };
				OUCSS.Utilities.displayLoading();
				OUCSS.CSSApp.invokeService("AccountSummaryService", ajaxArgs, args);
			}
			
			//center();
			 
		},
		
		pageSubmitForm: function() {			
				util.log('payment page submit');
				
				var valid = validateData();			
				     
					if(valid)		
					   SubmitPayment();
				
			
		}	
};

function center(){
	        $("#form-buttons").css("position","absolute");
			$("#form-buttons").css("left", Math.max(0, (($(window).width() - $("#form-buttons").outerWidth()) / 2) + 
														$(window).scrollLeft()) + "px");
}

//Bind event for Payment Type change
function handlePaymentType()
{
	
	    $('#paymentType').change(function() {
	
			if ($(this).val() == '27' || $(this).val() == '37') {
				$('#cardInformation').hide();
				$('#billingAddress').hide();
				$('#bankAccount').show();
				$('#errorDiv').hide();
				$('#payBtn').button('enable');
				
			} 
			else {
				
				$('#bankAccount').hide();
				$('#cardInformation').show();
				$('#billingAddress').show();
								
				var ajaxArgs = {'onSuccess': OnPymtTypeReadSuccess,'onFailure':OnPymtErrorRead};
				var args = { 'action': 'READ', 'key1':acctId ,'key2':perId};		    	    
		    	OUCSS.CSSApp.invokeService("OneTimePaymentService", ajaxArgs, args);
			}
			
			
			//center();
			});
}

//Display billing address read from the service
function OnPymtTypeReadSuccess(data, status) {
		
		//// Add data from service to the form
		$('#addressLine1').val(data.mainData.billingAddress.addressLine1);
		$('#addressLine2').val(data.mainData.billingAddress.addressLine2);
		$('#city').val(data.mainData.billingAddress.city);
		$('#state').val(data.mainData.billingAddress.state);
		$('#postal').val(data.mainData.billingAddress.postal);
		

}


function validateData(){
	var requiredFields=[''];
	var missingFields = '';
	
	if($('#paymentType').val() == '27' || $('#paymentType').val() == '37')
	    requiredFields=['paymentAmount','routingNumber','accountNumber'];
    else
	    requiredFields=['paymentAmount','cardNumber','expiryMonth','expiryYear','cardValidationNumber','firstName','lastName'];
	
	$.each(
			requiredFields,
			function(i, field) {
				if($('#'+field).val() == '')
				{
				   
				   if(missingFields != '')
				   {
				      missingFields =  missingFields + ' , ';}
					  
					  missingFields =  missingFields + $('label[for="'+field+'"]').text() + ' ';
				}
			});

    //This will be called only if the Browser level validation does not work
    util.log('Missing Fields ' + missingFields);					
	if(missingFields != '')					
	{
	    $('#errorText').text('Please enter value for these fields : ' + missingFields);
		$('#errorDiv').show();
		return false;
	}
	else
	{
		$('#errorDiv').hide();
	    return true;
	}
}
		
		
//// Make one time payment
function SubmitPayment() {

	var ajaxArgs = {'onSuccess': OnPymtSubmitSuccess, 'onFailure' : OnPymtError, 'method':'POST','contentType':"application/json; charset=utf-8"};
	
	OUCSS.CSSApp.invokePageAction();
	var args = OUCSS.CSSApp.getPageContext().pageData;
	
	//Show loading sign
	util.displayLoading();
    OUCSS.CSSApp.invokeService("OneTimePaymentService", ajaxArgs, JSON.stringify(args));
}

//Show success message
function OnPymtSubmitSuccess(data, status) {

    $('#errorDiv').hide();
	response = data;
	
	util.hideLoading();
	OUCSS.CSSApp.launchPopup('Payment made successfully','pymtPopup', -2);
}

//Handle errors from service call
function OnPymtError(xjr, desc, error){
	
	  OUCSS.AJAX.serviceFailure (xjr, desc, error, 'Error submitting the payment');
	
}

//Handle errors from service call on Read
function OnPymtErrorRead(xjr, desc, error){
	  util.hideLoading();
	  $('#payBtn').button('disable');
	  OUCSS.AJAX.serviceFailure (xjr, desc, error, 'Error retreiving payment information');
	
}

/////////Account Summary methods///////////////

//Handle errors from service call
function OnReadError(xjr, desc, error){
	
	  OUCSS.AJAX.serviceFailure (xjr, desc, error, 'Error getting the account summary information');
	
}

function renderAmtDue(obj) {
	var dueDate = obj.dueDate;
	var amountDueStr ='';
	
	if(obj.amountDue != null)
	 {amountDueStr = '<center><span class="amtDueDateTitle">Amount Due: '
			+ util.formatCurrency(obj.amountDue) + '<span><br>';}
   
	if(dueDate != null)
	{amountDueStr = amountDueStr
			+ '<span class="amtDueDate" align="center">Due on: ' + dueDate
			+ '</span></center>';}
	$('#summary').empty();
	$('#summary').append(amountDueStr).trigger('create');
}

function renderService(data)
{
	var serviceStr = '';
  $.each(data,function(i,service){
	  if(serviceStr == '')
		  {
		    serviceStr = '<p><span class="chargeDetailsTitle">Charge Details</span><table>';
		  }
	  serviceStr = serviceStr+'<tr><td><span class="chargeDetails">'+service.label+'</span></td><td><span class="chargeDetails">'+util.formatCurrency(service.amount)+'</span></td></tr>';
  });	
  serviceStr = serviceStr+'</center></table></p>';
  
 // $('#summary').empty();
  $('#summary').append(serviceStr).trigger('create');
}
	//Render UI
function renderData(data,status)
{
	tableString = '';
	dataExists=false;
	
	if(data.mainData){
		dataExists=true;
		renderAmtDue(data.mainData);
		
	if(data.mainData.service)
		renderService(data.mainData.service,data.mainData.currency);
	
			  
   }
	
	
		// No data.
	if (dataExists == false) {

		$('#noDataMsg').show();
	} else {

		$('#noDataMsg').hide();
	}
	
	$('#errorDiv').hide();
	OUCSS.Utilities.hideLoading();
	
	}

