var reportOutageString;
var acctId=OUCSS.CSSApp.getGlobalContext().contextAcctId;
 
 
//// Get fields for Report Public Outage and render the form 

OUCSS.PageEvents.reportPublicOutage = {
		
		pageBeforeShow:	function() {
			
			if(acctId == undefined)
			{				 
				 window.location.replace('../../Login.html');
			}
			
			$('#acctInfoOutage').text('Account : '+acctId);	
			
			$('input[type="checkbox"]').change(function(){
				this.value = (Number(this.checked));
			});
			
							
		},
		
		pageShow:	function() {
			
						
			//Get data and render Outage Codes
			OUCSS.Utilities.displayLoading();
			OUCSS.CSSApp.invokeService("OutageScreenInfoService", {'onSuccess':OnCodesSuccess, 'onFailure': OnCodesError}, {});
			
			   				  
				/**$("#form-buttons").css("position","absolute");
				$("#form-buttons").css("left", Math.max(0, (($(window).width() - $("#form-buttons").outerWidth()) / 2) + 
															$(window).scrollLeft()) + "px");*/
		},
		pageSubmitForm: function() {
			OUCSS.Utilities.log('Report Outage page submit function');
			
			var valid = validateData();			
				
		   if(valid)
			   ReportOutageService();
			    
			
		}
		
};  


//Display Outage Codes
function OnCodesSuccess(data, status) {
	reportOutageString = '';
	
	$.each(
			data.outageCodes.outageCodeList,
			function(i, outage) {
				
				/*reportOutageString = reportOutageString
						+ '<label for=\''+outage.outageCodeName+'\'>'
						+ '<span class="dropDownTxt">'
						+ outage.outageCodeName
						+ '</span>'
						+ '</label>';*/
						
				reportOutageString = reportOutageString
						+ '<select data-theme="d" class="dropDownTxt" data-mini="true" name="'+ outage.outageCodeName  +'" id="'+outage.outageCodeName+'">';
				$.each(
						outage.option,
						function(i, codeItem) {
							reportOutageString = reportOutageString
									+ '<option  value='+codeItem.outageValue+'>'
									+ codeItem.outageValueName
									+ '</option>';
						});
				reportOutageString = reportOutageString
						+ '</select>';
			
			});
	
	$('.reportOutageDiv').append(reportOutageString).trigger('create');
	
	$('#errorDiv').hide();
	
	$('[data-role=fieldcontain]').find('.ui-btn').removeClass(
    'ui-btn-up-a ui-btn-up-b ui-btn-up-c ui-btn-up-d ui-btn-up-e ui-btn-hover-a ui-btn-hover-b ui-btn-hover-c ui-btn-hover-d ui-btn-hover-e').addClass(
    'ui-btn-up-d').attr('data-theme', "d");
	
    OUCSS.Utilities.hideLoading();
   
}

//Handle errors from service call
function OnCodesError(xjr, desc, error){
	
	  OUCSS.AJAX.serviceFailure (xjr, desc, error, 'Error getting the Outage Codes information');
	
}

function validateData(){
	var requiredFields=['location1','city','state'];
	var missingFields = '';
	
	$.each(
			requiredFields,
			function(i, field) {
				var value=$('#location1').val();
				 OUCSS.Utilities.log('Test'+field+'-'+value);
				 
				if($('#'+field).val() == '')
				{
				   
				   if(missingFields != '')
				    {  missingFields =  missingFields + ' , ';}
					  
					  missingFields =  missingFields + $('label[for="'+field+'"]').text();
			    }
			});

    //This will be called only if the Browser level validation does not work
    OUCSS.Utilities.log('Missing Fields ' + missingFields);					
	if(missingFields != '')					
	{	    
		$('#errorText').text('Please enter value for these fields : ' + missingFields);
		$('#errorDiv').show();
		return false;
	}
	else
	{
		$('#errorDiv').hide();
	    return true;
	}
}


//send userId, callbackRequested, outageCodes
function ReportOutageService() {

	var ajaxArgs = {'onSuccess':OnFormSubmitSuccess, 'onFailure': OnFormSubmitError, 'method':'POST', 'contentType' : "application/json; charset=utf-8"};
	//var args = $('#reportOutageForm :input').serializeArray();	
	OUCSS.CSSApp.invokePageAction();
	var args = OUCSS.CSSApp.getPageContext().pageData;
	
	//Send outage codes as a concatenated string of values
	var outageCodes ='';
	OUCSS.Utilities.log('*****');
	 $(".outage-code", $.mobile.activePage).each(function() {
            if($(this).prop('tagName') == "SELECT") { 
				var val = $(this).find("option:selected").val();
				if(val != undefined)			
				   outageCodes = outageCodes +  val;   
              }
          });
		
	args["outageCodes"]	= outageCodes;
	
	//Show loading sign
	OUCSS.Utilities.displayLoading();
    OUCSS.CSSApp.invokeService("OutageTroubleCallService", ajaxArgs, JSON.stringify(args));
}

//Show success Popup
function OnFormSubmitSuccess(data, status) {

	response = data;
	
	OUCSS.Utilities.hideLoading();
	OUCSS.CSSApp.launchPopup('Outage reported successfully','outgPopup', -2);
}

//Handle errors from service call
function OnFormSubmitError(xjr, desc, error){
	
	  OUCSS.AJAX.serviceFailure (xjr, desc, error, 'Error submitting the outage information');
	
}





				