/**
 * 
 */

var areaParam = 'CITY';
var acctId=OUCSS.CSSApp.getGlobalContext().contextAcctId;
var mvElocation;
var mapview;

	//// Function to show map when the page loads
	OUCSS.PageEvents.mapPage = {
		
		pageBeforeShow   : function(){	   
		   
		   
					   if(acctId == undefined)
						{				 
							 window.location.replace('../../Login.html');
						}
						
			        					  
			          var adjust_size = function() {
						var height = $(window).height();
						var width = $(window).width();	
						if (width <= 400) {
								$.mobile.activePage.addClass('ui-hide-label');
						}
						else
							  $.mobile.activePage.addClass('ui-show-label');
							  
					    var height = ($(window).height()
							- $("#mapPage").find('[data-role="header"]').outerHeight()
							- $("#mapPage").find('[data-role="footer"]').outerHeight() 
							- $("#outageTypeDiv").outerHeight()
							- $("#acctHeader").outerHeight());
							
					
					    $("#map_canvas").height(height);
					};
					adjust_size();
					$(window).resize(adjust_size);
					
				
		},
		
		pageShow   : function(){
							
							renderMap();
							
							//Bind event handling logic
							// Refresh map when the outage type changes
							$('#outageType').change(function() {
								
								var mapType = OUCSS.CSSApp.getGlobalContext().mapType;
								areaParam = $(this).val();
								
								if (mapType == 'GOOGLE'){								
									loadOutageData();
									$('#gm_map_canvas').gmap('refresh');
								}else{
									
									renderMapViewer();
								}
							});
							
	   }
		};
						
		//Map rendering logic
		function renderMap(){
			
			var mapType = OUCSS.CSSApp.getGlobalContext().mapType;
			
			geocoder = new google.maps.Geocoder();
			mvElocation = new OracleELocation("http://elocation.oracle.com/elocation") ; 
					
			  if (mapType == 'GOOGLE'){
					
					$('#mv_map_canvas').hide();
					$('#gm_map_canvas').show();
					
					$('#gm_map_canvas').gmap({
						'zoom' : 5,
						'center' : '40.97043,-81.27391'  // Latitude , Longitude
					}).bind('init', function(ev, map) {
						loadOutageData();
						google.maps.event.trigger(map, 'resize');
						$('#gm_map_canvas').gmap('refresh');

					});
					
					
				}
				else{
					
					$('#gm_map_canvas').hide();
					$('#mv_map_canvas').show();	
					
					var baseURL = "http://elocation.oracle.com/mapviewer";
					 // Create an MVMapView instance to display the map
					 mapview = new MVMapView(document.getElementById("mv_map_canvas"), baseURL);
					 // Add a map tile layer as background.
					 mapview.addMapTileLayer(new MVMapTileLayer("elocation.WORLD_MAP"));
					 var centerPoint = MVSdoGeometry.createPoint(-81.27391, 40.97043, 8307);
		             mapview.setCenter(centerPoint);
		             mapview.setZoomLevel(4);
		             var navPan = new MVMapDecoration(new MVNavigationPanel(), 0, 0, null, null, 4, 4);
		             mapview.addMapDecoration(navPan);
		             mapview.enableDragging(true); 
			         //mapview.addScaleBar();
		             mapview.display();
					
					 renderMapViewer();
				}
			
		}
		
		//Handle errors from service call
		function OnReadError(xjr, desc, error){
			
			  OUCSS.AJAX.serviceFailure (xjr, desc, error, 'Error getting the Outage information');
			
		}

		//Load Outage data
		function loadOutageData() {
			$('#gm_map_canvas').gmap('clear', 'markers');
			
			var ajaxArgs = {'onFailure' : OnReadError, 'onSuccess' : function(data) {
				if(data.geographicOutageAreasList && data.geographicOutageAreasList.length > 0) {
						$.each(
								data.geographicOutageAreasList,
								function(i, outage) {
									if (outage != null) {
										
										geocoder.geocode( { 'address': outage.area}, function(results, status) {
												if (status == google.maps.GeocoderStatus.OK) {
													
													OUCSS.Utilities.log(results[0].geometry.location);
													var theme = getTheme();
													
													$('#gm_map_canvas').gmap(													
														'addMarker',
														{
															'position' : results[0].geometry.location,
															'bounds' : false
														}).click(
														function() {
															$('#gm_map_canvas').gmap(
																	'openInfoWindow',
																	{
																		'content' :  "<table class=\"ui-body-"+theme+"\" data-theme=\"b\" id=\"outageInfo\" data-role=\"table\"><tr><td>Area</b></td><td><b>" + 
																						outage.area +
																						"</b></td></tr><tr><td>Outages</td><td><b>" + 
																						outage.numOutages +
																						"</b></td></tr><tr><td>Customers Affected</td><td><b>" + 
																						outage.custOut +
																						"</b></td></tr><tr><td>Fix By</td><td><b>" + 
																						outage.eta + "</b></td></tr></table>"
																	}, this);
														});
														  
														  
														} else {
														  OUCSS.Utilities.log('Geocode was not successful for the following reason: ' + status);
														}
													  });
									}
								});
								}
								
								$('#errorDiv').hide();
								OUCSS.Utilities.hideLoading();
								
								$('#outageListId').find('.ui-btn').removeClass(
							    'ui-btn-up-a ui-btn-up-b ui-btn-up-c ui-btn-up-d ui-btn-up-e ui-btn-hover-a ui-btn-hover-b ui-btn-hover-c ui-btn-hover-d ui-btn-hover-e').addClass(
							    'ui-btn-up-d').attr('data-theme', "d");
					}
					
					};
					
			var args = { 'areaType': areaParam };		
			OUCSS.Utilities.displayLoading();    	    
			OUCSS.CSSApp.invokeService("OutageSummaryService", ajaxArgs, args);
		}
		
			
		function renderMapViewer() {		
			 
			mapview.removeAllFOIs();
			
			//Handle errors from service call
			function OnReadError(xjr, desc, error){				
				  OUCSS.AJAX.serviceFailure (xjr, desc, error, 'Error getting the Outage information');				
			}
			
			var ajaxArgs = {'onFailure' : OnReadError, 'onSuccess' : function(data) {

				if(data.geographicOutageAreasList && data.geographicOutageAreasList.length > 0) {
				$.each(
							data.geographicOutageAreasList,
							function(i, outage) {
								if (outage != null) {
									mvElocation.geocode( outage.area, function(gcResult){
										if(gcResult.length == 0){
											OUCSS.Utilities.log("Geocoding failed as no matching address found");
										}else{
											var mpoint = MVSdoGeometry.createPoint( gcResult[0].x, gcResult[0].y, 8307);
											var marker = MVMarkerFactory.createMarkerFOI(mpoint, '', MVMarkerFactory.STYLE_POINTER_BUBBLE, MVMarkerFactory.COLOR_RED);
											marker.setInfoWindow('<table data-role=\"table\"><tr><td>Area</b></td><td><b>' + outage.area + 
													'</b></td></tr><tr><td>Outages</td><td><b>' + outage.numOutages +
													'</b></td></tr><tr><td>Customers Affected</td><td><b>' + outage.custOut + 
													'</b></td></tr><tr><td>Fix By</td><td><b>' + outage.eta +
													'</b></td></tr></table>');
											mapview.addFOI(marker);
										}
									});													 
								}
							});
				}
	             
	             $('#errorDiv').hide();
				 OUCSS.Utilities.hideLoading();
				
				 $('#outageListId').find('.ui-btn').removeClass(
			     'ui-btn-up-a ui-btn-up-b ui-btn-up-c ui-btn-up-d ui-btn-up-e ui-btn-hover-a ui-btn-hover-b ui-btn-hover-c ui-btn-hover-d ui-btn-hover-e').addClass(
			     'ui-btn-up-d').attr('data-theme', "d");
								
			 }			 
			 };		
              
            var args = { 'areaType': areaParam };		
  			OUCSS.Utilities.displayLoading();    	    
  			OUCSS.CSSApp.invokeService("OutageSummaryService", ajaxArgs, args);
			
		}
		
//# sourceURL=mods/outage/mapPage.js
