var tableString;
var d = new Date();
var currentYear=d.getFullYear();
var year=currentYear;
var currentDate='-'+d.getMonth()+'-'+d.getDay();
var startDate=d;
var acctId=OUCSS.CSSApp.getGlobalContext().contextAcctId;


//Page Rendering Logic
OUCSS.PageEvents.billingHistory = {

	   pageBeforeShow : function(){


		   if(acctId == undefined)
			{
				window.location.replace('../../Login.html');
			}

			$('#acctInfoBill').text('Account : '+acctId);


	 	   },

		pageShow:	function() {

			OUCSS.Utilities.log('Billing History Account Selected : '+acctId);

			pageId='billingHistory';
			var ajaxArgs = {'onSuccess' : renderData, 'onFailure' : OnReadError};

			//Display data
			//Custom Extension call to invoke custom service
			if(OUCSS.PageEvents[pageId].cmext && OUCSS.PageEvents[pageId].cmext.invokeService) {
    			OUCSS.PageEvents[pageId].cmext.invokeService();
    		}
			//Base code
			else{

				var args = { 'startDate': startDate.yyyymmdd(), 'key1':acctId ,'action':'READ'};
				OUCSS.Utilities.displayLoading();
				OUCSS.CSSApp.invokeService("SSFinancialHistory", ajaxArgs, args);
			}

			//Bind event handling logic
			// Previous year button clicked
			$("#previousYear").click(function() {

				startDate.setFullYear(startDate.getFullYear() - 1);
				var args = { 'startDate': startDate.yyyymmdd(), 'key1':acctId ,'action':'READ'};
				OUCSS.Utilities.displayLoading();
		    	OUCSS.CSSApp.invokeService("SSFinancialHistory", ajaxArgs, args);

			});

			// Next year button clicked
			$("#nextYear").click(function() {

				startDate.setFullYear(startDate.getFullYear() + 1);
				var args = { 'startDate': startDate.yyyymmdd(), 'key1':acctId ,'action':'READ'};
				OUCSS.Utilities.displayLoading();
		    	OUCSS.CSSApp.invokeService("SSFinancialHistory", ajaxArgs, args);
			});


		}
};

//Handle errors from service call
function OnReadError(xjr, desc, error){

	  OUCSS.AJAX.serviceFailure (xjr, desc, error, 'Error getting the Financial History information');

}


//Render UI
function renderData(data,status)
{
	tableString = '';
	dataExists=false;

	if(data.mainData.history){

	  $.each(data.mainData.history, function(i, item) {
		if (item != null) {

			tableString = tableString + '<div data-theme="d" data-role="collapsible"  data-collapsed-icon="arrow-r-custom" data-expanded-icon="arrow-d-custom" data-inset="false" class="ui-nodisc-icon"> <h2><span class="dropDownTxt">'
			                          +  item.date + '   -   ' + item.label + '   ' + item.currency + Number(item.amount).format(2)
									  +'</span></h2>';

	        if(item.detail){

				 tableString = tableString + '<ul data-role="listview" id="billHistoryList"> <li>';

				 $.each(item.detail, function(i, detail) {

					  tableString = tableString + '<p><span class="dropDownTxt">'
												+ detail.label + '   :    ' + detail.currency + detail.amount
												+ '</span></p> ';
				 });

				 tableString = tableString + '</li></ul>';

			}

			tableString = tableString + '</div>';


         dataExists=true;
		}
	});


   }


	$('#billHistoryData').empty();
	$('#billHistoryData').append(tableString).trigger('create');


	$("#billingHistoryNextPrev").show();

	//If current year, disable Next button
	if(startDate.getFullYear() == currentYear)
		  $("#nextYear").button('disable');
	  else
	      $("#nextYear").button('enable');

	//No data. Hide previous button and show No data message
	if(dataExists == false)
    {
    	$("#previousYear").button('disable');

		$('#noDataMsg').show();
    }
	else
	{
	  $("#previousYear").button('enable');

	  $('#noDataMsg').hide();
	}

	$('#errorDiv').hide();
	OUCSS.Utilities.hideLoading();

	}
