/*
  bp_layout.js
  Copyright 2007, 2013, Oracle and/or its affiliates. All rights reserved.
  Author: Vijayender Cherupally, Robert Crews
  Version: 2013.6.30
*/


function addLoadEvent(func) {
  "use strict";
  var oldOnload = window.onload;
  if (typeof window.onload !== "function") {
    window.onload = func;
  } else {
    window.onload = function () { oldOnload(); func(); };
  }
}

function stripeLi() {
  "use strict";
  var i = 0, j = 0, uls, lis,
    divs = document.getElementsByTagName("div");
  if (!document.getElementsByTagName) {
    return false;
  }
  for (i = 0; i < divs.length; i += 1) {
    if (divs[i].getAttribute("class") === "portlet" ||
        (navigator.appName.indexOf("Microsoft") !== -1 &&
        divs[i].className === "portlet")) {
      uls = divs[i].getElementsByTagName("ul");
      if (uls.length > 0) {
        lis = uls[uls.length - 1].getElementsByTagName("li");
        for (j = 0; j < lis.length; j += 1) {
          if (j % 2 === 0) {
            lis[j].style.background = "white";
          }
        }
      }
    }
  }
}
//addLoadEvent(stripeLi);

function stripeTr() {
  "use strict";
  var i = 0, j = 0, trs,
    tbodys = document.getElementsByTagName("tbody");
  if (!document.getElementsByTagName) {
    return false;
  }
  for (i = 0; i < tbodys.length; i += 1) {
    trs = tbodys[i].getElementsByTagName("tr");
    for (j = 0; j < trs.length; j += 1) {
      if (j % 2 === 0) {
        trs[j].style.background = "white";
      }
    }
  }
}
//addLoadEvent(stripeTr);

function advancedSearch(mode) {
  "use strict";
  if (!document.getElementById) {
    return false;
  }
  if (mode === 'show') {
    if (document.getElementById("BASIC") !== null) {
      document.getElementById("BASIC").style.display = "none";
    }
    if (document.getElementById("ADVANCED") !== null) {
      document.getElementById("ADVANCED").style.display = "block";
    }
  } else {
    if (document.getElementById("BASIC") !== null) {
      document.getElementById("BASIC").style.display = "block";
    }
    if (document.getElementById("ADVANCED") !== null) {
      document.getElementById("ADVANCED").style.display = "none";
    }
  }
}
addLoadEvent(advancedSearch);

function underlineTitles() {
  "use strict";
  var p1 = document.createElement("span"), p2;
  p1.style.position = "absolute";
  p1.style.right = "1em";
  p1.style.color = "#666";
  p1.style.textDecoration = "underline";
  p1.style.cursor = "pointer";
  p1.style.fontSize = "80%";
  p1.style.marginTop = "0";

  function underline() {
    var i = 0, j = 0, li, div = document.getElementsByTagName("div");
    for (i = 0; i < div.length; i += 1) {
      if (div[i].className === "portlet") {
        li = div[i].getElementsByTagName("li");
        for (j = 0; j < li.length; j += 1) {
          li[j].style.marginBottom = "1px";
          li[j].style.borderBottom = "solid 1px #666";
          li[j].style.paddingBottom = "1px";
        }
      }
    }
    document.getElementById("p1").style.display = "none";
    document.getElementById("p2").style.display = "block";
  }

  function plain() {
    var i = 0, j = 0, li, div = document.getElementsByTagName("div");
    for (i = 0; i < div.length; i += 1) {
      if (div[i].className === "portlet") {
        li = div[i].getElementsByTagName("li");
        for (j = 0; j < li.length; j += 1) {
          li[j].style.marginBottom = "0";
          li[j].style.borderBottom = "none";
          li[j].style.paddingBottom = "0";
        }
      }
    }
    document.getElementById("p1").style.display = "block";
    document.getElementById("p2").style.display = "none";
  }

  p2 = p1.cloneNode(false);
  p1.appendChild(document.createTextNode("Underline Titles"));
  p1.onclick = function () { underline(); };
  p1.id = "p1";
  p2.appendChild(document.createTextNode("Remove Title Underlines"));
  p2.onclick = function () { plain(); };
  p2.id = "p2";
  p2.style.display = "none";

  document.getElementById("FOOTER").insertBefore(p1,
    document.getElementById("FOOTER").firstChild);
  document.getElementById("FOOTER").insertBefore(p2,
    document.getElementById("FOOTER").firstChild);
}
addLoadEvent(underlineTitles);

function collapsiblePortlet() {
  "use strict";
  var h2Ele, i = 0, j = 0, aEle, h2Parent, divEle, divID, imgEle;
  function showHide(tabHref, nav) {
    var shID, table, imagePM;
    if (tabHref.id !== null) {
      shID = tabHref.id;
      shID = shID.replace('tableHref', '');
      if (tabHref !== null) {
        table = document.getElementById('table' + shID);
        if (table !== null && table.style.display !== 'none') {
          table.style.display = 'none';
          imagePM = document.getElementById('imagePM' + shID);
          if (imagePM !== null) {
            imagePM.src = nav + 'images/expand.gif';
          }
        } else if (table !== null) {
          table.style.display = 'inline';
          imagePM = document.getElementById('imagePM' + shID);
          if (imagePM !== null) {
            imagePM.src = nav + 'images/collapse.gif';
          }
        }
      }
    }
  }
  h2Ele = document.getElementsByTagName("h2");
  for (i = 0; i < h2Ele.length; i += 1) {
    h2Parent = h2Ele[i].parentNode;
    divID = "";
    if (h2Parent.nodeName === 'div' || h2Parent.nodeName === 'DIV') {
      divEle = h2Parent.getElementsByTagName("div");
      for (j = 0; j < divEle.length; j += 1) {
        if (divEle[j].id !== null) {
          if (divID === "" && divEle[j].id.indexOf('table') !== -1) {
            divID = divEle[j].id;
            divID = divID.replace("table", "");
          }
        }
      }
      if (divID !== "") {
        aEle = document.createElement("a");
        aEle.id = "tableHref" + divID;
        imgEle = document.createElement("img");
        if (document.getElementById("PORTAL_1") !== null) {
          aEle.href = "#";
          aEle.onclick = function () { showHide(this, 'nav/'); return false; };
          imgEle.src = "nav/images/collapse.gif";
        } else {
          if (document.getElementById("WELCOME") !== null) {
            aEle.href = "#";
            aEle.onclick = function () { showHide(this, 'doc/nav/'); return false; };
            imgEle.src = "doc/nav/images/collapse.gif";
          } else {
            aEle.href = "#";
            aEle.onclick = function () { showHide(this, ''); return false; };
            imgEle.src = "images/collapse.gif";
          }
        }
        imgEle.alt = "collapse";
        imgEle.border = "0";
        imgEle.id = "imagePM" + divID;
        aEle.appendChild(imgEle);
        h2Ele[i].insertBefore(aEle, h2Ele[i].firstChild);
      }
    }
  }
}
addLoadEvent(collapsiblePortlet);
