// global variables
var doc_user;

$(document).ready(function() {
    
    if ($.browser.msie && (parseInt($.browser.version,10) < 10)){

        // IE 9 and below is unsupported browser, disable star rating in html
        $("#star-rating").removeClass("star-rating-img").addClass("star-rating-disable");
    } else {

        $.support.cors="true";		

        // variables
        var rating;
        var timestmp;

	/* used for temporary debug */
        var browser = navigator.userAgent;
        var browser_l = navigator.language;

        var arrow_p = 90; // default arrow aligning

        var doc_rating   = getCookie("ORA_OTN_FEEDBACK_DOC_RATING");
        doc_user  = getCookie("ORA_OTN_FEEDBACK_DOC_USER");

        var page_uri = encodeURI(window.location);
        var regex = page_uri.match(".*\/([^/]+)\/html\/([^/]+).*");

        // library, book
        var library = null;
        var book = null;

        if (regex !== null) {
            library = regex[1];
            book = regex[2];
        }

        $('#rate-form input:checkbox').removeAttr('checked');
        
        for (j=1; j<=doc_rating; j++) {
	    $("#rating-"+j).addClass("color-star");
        }	

        // reset values
        $("#missing-info-text").attr('disabled', 'disabled');
        $("#missing-info-text").attr('value', '');
        $("#incorrect-content-text").attr('disabled', 'disabled');
        $("#incorrect-content-text").attr('value', '');
        $("#dropdown-menu").attr('disabled', 'disabled');
        $("#dropdown-menu").val('');
        $("#feedback-comment").attr('disabled','disabled');
        $("#feedback-comment").attr('value', '');
        $("#feedback-submit").attr('disabled','disabled');
        $("#lang-text").attr('value', '');

        // do stuff when click on stars
        $("#star-rating").click(function(event) {
            doc_rating   = getCookie("ORA_OTN_FEEDBACK_DOC_RATING");
	    doc_user = getCookie("ORA_OTN_FEEDBACK_DOC_USER");
            
	    var rating_div = event.target.id;
	
	    for (i=1; i<=5; i++) {
	        $("#rating-"+i).removeClass("color-star");
	    }

	    // color stars and set rating
            switch (rating_div) {
            case "rating-1":
                rating = 1;
	        remove_thank_dialog();
	        add_form_dialog();
	        $("#arrow").css("left", arrow_p);	
	        $("#rating-1").addClass("color-star");
                break;
            case "rating-2":
                rating = 2;
	        remove_thank_dialog();
	        add_form_dialog();
	        $("#arrow").css("left", arrow_p+20);
	        for (i=1; i <=rating; i++) {
		    $("#rating-"+i).addClass("color-star");						
	        }
                break;
            case "rating-3":
                rating = 3;
	        remove_thank_dialog();
	        add_form_dialog();
	        $("#arrow").css("left", arrow_p+40);
	        for (i=1; i <=rating; i++) {
		    $("#rating-"+i).addClass("color-star");						
	        }
                break;
            case "rating-4":
                rating = 4;
	        remove_form_dialog();
	        remove_thank_dialog();
                show_thank_dialog();
	        for (i=1; i <=rating; i++) {
		    $("#rating-"+i).addClass("color-star");						
	        }
                break;
            case "rating-5":
                rating = 5;
	        remove_form_dialog();
	        remove_thank_dialog();
                show_thank_dialog();
	        for (i=1; i <=rating; i++) {
		    $("#rating-"+i).addClass("color-star");						
		}
                break;
            default:
                break;
            }
            
            if (doc_user !== null) {
	        if (doc_rating !== null) {
                    // cookie for user and rating is set -> data will be updated
	            $.ajax({
		        type: "POST",
		        dataType: 'json',
		        url: 'https://apex.oracle.com/pls/apex/otn_rating/rating/update/' + doc_user,		
                        success: function (data, s, xhr) {
                            setCookie("ORA_OTN_FEEDBACK_DOC_RATING", rating);
                        },
		        data: {
			    stars: rating,
			    address: page_uri,
                            book: book,
                            library: library,
			    timestamp: make_timestamp()			
		        }
		    }); // end ajax
	        } else {
                    // doc_rating is null, new row is added 
		    $.ajax({
		        type: "POST",
		        dataType: 'json',
		        url: 'https://apex.oracle.com/pls/apex/otn_rating/rating/' + doc_user,		
                        success: function (data, s, xhr) {
                            setCookie("ORA_OTN_FEEDBACK_DOC_RATING", rating);
                        },
		        data: {
			    stars: rating,
			    address: page_uri,
                            book: book,
                            library: library,
			    timestamp: make_timestamp()			
		        }
		    }); // end ajax
	        } 
	    } else {
		// doc_user is null
	        $.ajax({
		    type: "POST",
		    dataType: 'json',
		    url: 'https://apex.oracle.com/pls/apex/otn_rating/rating/',
		    success: function (data, s, xhr) {
		        doc_user   = data.ouser_id;
                        setCookie("ORA_OTN_FEEDBACK_DOC_RATING", rating);
		        setCookie_user("ORA_OTN_FEEDBACK_DOC_USER", doc_user, 'oracle.com');
		    },			
		data: {
		    stars: rating,
		    address: page_uri,
		    timestamp: make_timestamp(),
		    library: library,
                    book: book,
                    browser: browser,
                    browser_l: browser_l
		}
	        }); // end ajax
	    }		
    }); // end onclick function
        
        
        $(".feedback-close").click(function() {
	    remove_form_dialog();
	    remove_thank_dialog();
            show_thank_dialog();
        });
        
        $("#feedback-close-butt").click(function() {
	    remove_form_dialog();
	    remove_thank_dialog();
            show_thank_dialog();
        });
        
        $(".thank-close").click(function() {
	    remove_form_dialog();
	    remove_thank_dialog();
        });
        
        
        $("#checkbox-form").submit(function() {
	    remove_form_dialog();
	    show_thank_dialog();
	    $("#thank-close").removeClass("hide-form");
	    $("#thank-close").addClass("show-form");
	    for (i=1; i <=rating; i++) {
	        $("#rating-"+i).addClass("color-star");						
	    }
	return false;
        });	// end submit function
        

        // enable submit button
        $("input[name='checkbox-2']").change(function() {
	    if ($("input[name='checkbox-2']").is(':checked')) {
                $("#feedback-submit").removeAttr('disabled');
            } else {
                disable_starrating_button();
            }
        });


        // missing info textarea
        $("input[name='checkbox-3']").change(function() {
            if ($("input[name='checkbox-3']").is(':checked')) {
                $("#missing-info-text").removeAttr('disabled');
                $("#feedback-submit").removeAttr('disabled');
            } else {
                $("#missing-info-text").attr('disabled', 'disabled');
                $("#missing-info-text").attr('value', '');
                disable_starrating_button();
            }
        });

        // incorrect info textarea
        $("input[name='checkbox-4']").change(function() {
            if ($("input[name='checkbox-4']").is(':checked')) {
                $("#incorrect-content-text").removeAttr('disabled');
                $("#feedback-submit").removeAttr('disabled');
            } else {
                $("#incorrect-content-text").attr('disabled', 'disabled');
                $("#incorrect-content-text").attr('value', '');
                disable_starrating_button();
            }
        });

        // displays submit dialog and submit button
        $("input[name='checkbox-5']").change(function() {
	    if ($("input[name='checkbox-5']").is(':checked')) {
                $("#feedback-comment").removeAttr('disabled');
                $("#feedback-submit").removeAttr('disabled');
            } else {
                $("#feedback-comment").attr('disabled','disabled');
                $("#feedback-comment").attr('value','');
                disable_starrating_button();
            }
        });
        
        
        // language drop-down menu
        $("input[name='checkbox-6']").change(function() {
            var value = $('#dropdown-menu option:selected').val();
            if ($("input[name='checkbox-6']").is(':checked')) {
                $("#dropdown-menu").removeAttr('disabled');
                if ($('#dropdown-menu option:selected').val() == "other-lang") {
                    $("#lang-text").removeClass("hide-form").addClass("show-form");
                }
            } else {
                $("#lang-text").removeClass("show-form").addClass("hide-form");
                $("#dropdown-menu").val('');
                $("#dropdown-menu").attr('disabled', 'disabled');
                $("#lang-text").attr('value', '');
                disable_starrating_button();
            }

            
        });
        
        // display language selection dropdown menu
        $("select[id='dropdown-menu']").change(function(){
            var lang = $('#dropdown-menu option:selected').val();
            
            if (lang != "N/A") {
                $("#feedback-submit").removeAttr('disabled');
            } else {
                $("#feedback-submit").attr('disabled','disabled');
            } 
            
            if ( lang == "other-lang") {
                $("#lang-text").removeClass("hide-form").addClass("show-form");
            } else {
                $("#lang-text").removeClass("show-form").addClass("hide-form");
            }
        });
    } 

}); // end document ready funtion

/* Function definitions*/
function remove_form_dialog() {
    $("#rate-form-display").removeClass("show-form").addClass("hide-form");
    $("#RatingForm").removeClass("show-form").addClass("hide-form");
    $("#arrow").removeClass("show-form").addClass("hide-form");
}

function add_form_dialog() {
    remove_thank_dialog();
    $("#arrow").removeClass("hide-form").addClass("show-form");		
    $("#RatingForm").addClass("show-form").removeClass("hide-form");
    $("#rate-form-display").addClass("show-form").removeClass("hide-form");
}

function show_thank_dialog() {
    $("#RatingForm").addClass("show-form").removeClass("hide-form");
    $("#rate-form-sent").removeClass("hide-form").addClass("show-form");
    $("#thank-close").removeClass("hide-form").addClass("show-form");	
    setTimeout(function(){
        remove_thank_dialog();
    },2500);
}

function remove_thank_dialog() {
    $("#rate-form-sent").removeClass("show-form").addClass("hide-form");
    $("#thank-close").removeClass("show-form").addClass("hide-form");	
    $(".feedback-close").removeClass("show-form").addClass("hide-form");
}

function setCookie(key, value) { // add expiration date
    document.cookie = key + '=' + value;
}

function setCookie_user(key, value, domain) {
    document.cookie = escape(key) + '=' + escape(value) + ';domain='+domain + ';path=/';
}


function getCookie(key)
{
    var cookie_val;
    var keyValue = document.cookie.match('(^|;) ?' + key + '=([^;]*)(;|$)');  
    cookie_val = keyValue ? keyValue[2] : null; 

    return cookie_val;
}

function make_timestamp() {
    var date = new Date();
    var dd = date.getUTCDate();
    var mm = date.getUTCMonth()+1;
    var yy = date.getUTCFullYear();
    var hh = date.getUTCHours();
    var min = date.getUTCMinutes();
    var timestamp = yy + '-' + mm + '-' + dd + ' ' + hh + ':' + min;
    return timestamp;
}

function submit_form() {
    
    var page_uri = encodeURI(window.location);

    // checkboxes
    var checkboxes = new Array();
    $('#rate-form input:checkbox').each(function(){
	if ($(this).is(':checked')) {
	    checkboxes.push('Y');
	} else {
	    checkboxes.push('N');
	}
    });  // end checkbox each function

    // checkboxes text
    var missing_info;
    if ($('textarea#missing-info-text').val().length !== 0) {
        missing_info = $('textarea#missing-info-text').val();
    } else {
        missing_info = null;
    }

    var incorrect_content;
    if ($('textarea#incorrect-content-text').val().length !== 0) {
        incorrect_content = $('textarea#incorrect-content-text').val();
    } else {
        incorrect_content = null;
    }

    // language
    var lang = $('#dropdown-menu option:selected').val(); 
    if (lang == "other-lang") {
        if ($('textarea#lang-text').val().length !== 0) {
            lang = $('textarea#lang-text').val();    
        } else {
            lang = null;
        }
    }

    // comment
    var feedback_comment;
    if ($('textarea#feedback-comment').val().length !== 0) {
        feedback_comment = $('textarea#feedback-comment').val();
    } else {
        feedback_comment = null;
    }

    $.ajax({
	type: "POST",
	dataType: 'json',
	url: 'https://apex.oracle.com/pls/apex/otn_rating/rating/submit/all/' + doc_user,
        success: function (data, s, xhr) {},
	data: {
	    address: page_uri,
	    checkbox1: checkboxes[0],
	    checkbox2: checkboxes[1],
	    checkbox3: checkboxes[2],
	    checkbox4: checkboxes[3],
	    checkbox5: checkboxes[4],
            language: lang,
            missing_info_text: missing_info,
            incorrect_content_text: incorrect_content,
            comment: feedback_comment,
	    timestamp: make_timestamp()				
	}
    }); //end ajax
}

function call_survey() {
    var html_lang = get_html_lang();
    var page_uri = encodeURI(window.location);
    var regex = page_uri.match("^http[s]?://(.*)");
    var came_from = regex[1];
    var survey_url = 'https://apex.oracle.com/pls/apex/f?p=30379:1:0::NO::P1_URL,P1_LANG_SEL:' + came_from + ',' + html_lang + ':&p_lang=' + html_lang; 
    window.open(survey_url, '_blank', 'scrollbars=yes, resizable=yes, width=800, height=800');
    remove_thank_dialog();
    remove_form_dialog();
}

function get_html_lang() {
    var html_lang = $('html').attr('lang');
    switch(html_lang) {
    case 'de-DE':
        html_lang = 'de';
        break;
    case 'fr-FR':
        html_lang = 'fr';
        break;
    case 'es-ES':
        html_lang = 'es';
        break;
    case 'it-IT':
        html_lang = 'it';
        break;
    case 'pt-BR':
        html_lang = 'pt-br';
        break;
    case 'ja-JP':
        html_lang = 'ja';
        break;
    case 'ko-KR':
        html_lang = 'ko';
        break;
    case 'zh-CN':
        html_lang = 'zh-cn';
        break;
    case 'zh-TW':
        html_lang = 'zh-tw';
        break;
    default:
        html_lang = 'en';
        break;
    }

    return html_lang;
}

function disable_starrating_button() {
    if ($('input:checkbox').length === $('input:checkbox').not(':checked').length) {
        $("#feedback-submit").attr('disabled','disabled');
    }
}

