var langList = null;
var baseURL = null;
var curLang = null;

function setBaseURL(url) {
  baseURL = url;
}

function setLang(lang) {
  curLang = lang;
}

function sendRequest(url, callback, postData) {
    var req = createXMLHTTPObject();
    if (!req) return;
    var method = (postData) ? "POST" : "GET";
    req.open(method,url,true);
    req.setRequestHeader('User-Agent', 'XMLHTTP/1.0');
    if (postData)
        req.setRequestHeader('Content-type',
            'application/x-www-form-urlencoded');
    req.onreadystatechange = function () {
        if (req.readyState != 4) return;
        if (req.status != 200 && req.status != 304) {
            return;
        }
        callback(req);
    }
    if (req.readyState == 4) return;
    req.send(postData);
}

var XMLHttpFactories = [
    function () {return new XMLHttpRequest()},
    function () {return new ActiveXObject("Msxml2.XMLHTTP")},
    function () {return new ActiveXObject("Msxml3.XMLHTTP")},
    function () {return new ActiveXObject("Microsoft.XMLHTTP")}
];

function createXMLHTTPObject() {
    var xmlhttp = false;
    for (var i=0;i<XMLHttpFactories.length;i++) {
        try {
            xmlhttp = XMLHttpFactories[i]();
        }
        catch (e) {
            continue;
        }
        break;
    }
    return xmlhttp;
}

function langListCallback(req) {
    langList = eval(req.responseText);

    if(langList == null) {
        return;
    }

    langDivObj = document.getElementById("langDiv");
    html = "<form class=\"lang_form\"><label for=\"lmenu\">Language:&nbsp;</label><select class=\"lang_field\" id=\"lmenu\" name=\"langmenu\" onchange=\"gotoLangPage(this.form)\">";
    head = lest = null;
    for (var i = 0; i < langList.length; i++) {
      if (langList[i].language == curLang) {
	head = "<option class=\"lang_entry\" value=\"" +
           langList[i].library + "\">" + langList[i].language + "</option>";
      } else {
        lest += "<option class=\"lang_entry\" value=\"" +
           langList[i].library + "\">" + langList[i].language + "</option>";
      }
    }
    html += head + lest + "</select></form>";
    langDivObj.innerHTML = html;
}

function getLangList(langURL) {
    sendRequest(langURL, langListCallback, null);
}

function gotoLangPage(form) {
    if(form != null) {
        document.location = baseURL + form.langmenu.options[form.langmenu.selectedIndex].value + "_01";
    }
}
