String.prototype.endsWith = function(str) {return (this.match(str+"$")==str)};

var initial = true;
var groupNum = -1;
var showNum = 0;
var SHOW_ALL_MESSAGE = "Show Detailed Library";
var HIDE_ALL_MESSAGE = "Hide Detailed Library";
var EXPAND_GRP_MESSAGE = "Expand details button";
var COLLAPSE_GRP_MESSAGE = "Collapse details button";

function countGroup() {
  if (groupNum > -1) {
    return groupNum;
  }
  groupNum = 0;
  var tables = document.getElementsByTagName('table');
  for (var i = 0; i < tables.length; i++) {
    var names = tables[i].className;
    if (names != null) {
      if (names.indexOf("GroupHead") != -1) {
	groupNum++;
      }
    }
  }
  return groupNum;
}

function showHideTable(num) {

  if (initial) {
    initial = false;
    if (document.getElementById('show-hide-all-link').innerHTML == HIDE_ALL_MESSAGE) {
      showNum = countGroup();
    }
  }

  var activeTable = document.getElementById(('table' + num));
  var activeToggle = document.getElementById(('toggle' +num));

  if (activeTable.style.display == "table" &&
      activeToggle.src.endsWith("graphics/minus.png")) {

    activeTable.style.display = "none";
    activeToggle.src = "graphics/plus.png";
    activeToggle.alt = EXPAND_GRP_MESSAGE;
    if (--showNum < 1) {
      document.getElementById('show-hide-all-link').innerHTML = SHOW_ALL_MESSAGE;
    }
  } else if (activeTable.style.display == "none" &&
	     activeToggle.src.endsWith("graphics/plus.png")) {

    activeTable.style.display = "table";
    activeToggle.src = "graphics/minus.png";
    activeToggle.alt = COLLAPSE_GRP_MESSAGE;
    var count = countGroup();
    if (++showNum == count) {
      document.getElementById('show-hide-all-link').innerHTML = HIDE_ALL_MESSAGE;
    }
  }
}


function showHideAll() {
  var count = countGroup();
  var showHide = document.getElementById('show-hide-all-link').innerHTML;
  var show = true;
  if (showHide == HIDE_ALL_MESSAGE) {
    show = false;
  }

  for(i = 1; i < (count + 1); i++) {
    if (show) {
      if (document.getElementById(('table' + i)).style.display == "none") {
	showHideTable(i);
      }
    } else {
      if (document.getElementById(('table' + i)).style.display == "table") {
	showHideTable(i);
      }
    }
  }

  if (show) {
    document.getElementById('show-hide-all-link').innerHTML = HIDE_ALL_MESSAGE;
    showNum = count;
  } else {
    document.getElementById('show-hide-all-link').innerHTML = SHOW_ALL_MESSAGE;
    showNum = 0;
  }
}
