var navBackground = "#A4C3DF", scrollBar = "auto";

/*
  Copyright 2006, 2013, Oracle and/or its affiliates. All rights reserved.
  Author: Robert Crews
  Version: 2013.1.1
*/

function addLoadEvent(func) {
  "use strict";
  var oldOnload = window.onload;
  if (typeof window.onload !== "function") {
    window.onload = func;
  } else {
    window.onload = function () { oldOnload(); func(); };
  }
}

function createCookie(name, value, days) {
  "use strict";
  var date, expires = "";
  if (days) {
    date = new Date();
    date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
    expires = "; expires=" + date.toGMTString();
  } else {
    expires = "";
  }
  document.cookie = name + "=" + value + expires + "; path=/";
}

function readCookie(name) {
  "use strict";
  var i = 0, c, nameEQ = name + "=", ca = document.cookie.split(";");
  for (i = 0; i < ca.length; i += 1) {
    c = ca[i];
    while (c.charAt(0) === " ") {
      c = c.substring(1, c.length);
    }
    if (c.indexOf(nameEQ) === 0) {
      return c.substring(nameEQ.length, c.length);
    }
  }
  return "";
}

function leftNav() {
  "use strict";
  if (!document.createElement) { return false; }
  if (!document.createTextNode) { return false; }
  if (!document.getElementById) { return false; }
  if (!document.getElementsByTagName) { return false; }
  if (!document.documentElement.appendChild) { return false; }
  if (!document.documentElement.childNodes) { return false; }
  if (!document.documentElement.style) { return false; }

  if (navigator.userAgent.match(/\bMobile\b/)) { return false; }
  try {
    if (window.location.href.match(/\/pls\//)) { return false; }
  } catch (e) {}

  var tahitiNav, tahitiNavFrame, showNav, hideNav, tahitiBody, tahitiBodyFrame,
    content, div, img, i = 0;

  document.body.style.padding = "0";
  document.body.style.border = "0";

  tahitiNav = document.createElement("div");
  tahitiNav.style.padding = "1ex 0.5em";

  tahitiNavFrame = document.createElement("div");
  tahitiNavFrame.style.top = "0";
  tahitiNavFrame.style.bottom = "0";

  showNav = document.createElement("a");

  if (!((window.ActiveXObject && !window.opera) && !window.XMLHttpRequest)) {
    showNav.href = "#";
    showNav.title = "Show Navigation";
    showNav.style.textDecoration = "none";
    showNav.style.background = "#A4C3DF";
    showNav.style.width = "0.25em";
    showNav.style.height = "84ex";
    showNav.style.top = "0";
    showNav.style.left = "0";
    showNav.style.position = "fixed";
    showNav.style.cursor = "pointer";
    showNav.style.display = "none";
  }

  hideNav = document.createElement("a");
  hideNav.href = "#";
  hideNav.style.textDecoration = "none";
  hideNav.style.color = "#039";
  hideNav.style.display = "block";
  hideNav.style.textAlign = "right";
  hideNav.style.cursor = "pointer";
  hideNav.appendChild(document.createTextNode("Hide Navigation"));

  function navVisible() {
    tahitiNavFrame.style.display = "block";
    document.body.style.marginLeft = "26%";
    showNav.style.display = "none";
    createCookie("ORA_TAHITI_NAV", "", -1);
  }

  function navHidden() {
    tahitiNavFrame.style.display = "none";
    document.body.style.marginLeft = "0.5em";
    showNav.style.display = "block";
    if (window.name !== "glossWindow" ||
        window.self === window.top) {
      createCookie("ORA_TAHITI_NAV", "hide");
    }
  }

  function navVisibleIe6() {
    tahitiNavFrame.style.display = "block";
    tahitiNavFrame.style.width = "25%";
    tahitiBodyFrame.style.left = "25%";
    tahitiBodyFrame.style.width = "75%";
    tahitiNavFrame.style.width = document.documentElement.clientWidth -
      document.documentElement.clientWidth * 0.75;
    tahitiNavFrame.style.height = document.documentElement.clientHeight;
    tahitiBodyFrame.style.width = document.documentElement.clientWidth -
      document.documentElement.clientWidth * 0.25;
    tahitiBodyFrame.style.height = document.documentElement.clientHeight;
    tahitiNav.style.width = document.documentElement.clientWidth -
      document.documentElement.clientWidth * 0.75 - 32;
    tahitiBody.style.width = document.documentElement.clientWidth -
      document.documentElement.clientWidth * 0.25 - 32;
    showNav.style.display = "none";
  }

  function navHiddenIe6() {
    var i = 0;
    tahitiNavFrame.style.display = "none";
    tahitiBodyFrame.style.left = "0";
    tahitiBodyFrame.style.width = document.documentElement.clientWidth;
    tahitiBodyFrame.style.height = document.documentElement.clientHeight;
    tahitiBody.style.width = document.documentElement.clientWidth - 32;
    content = document.getElementsByTagName("div");
    for (i = 0; i < content.length; i += 1) {
      if (content[i].className === "header") {
        content[i].parentNode.insertBefore(showNav, content[i]);
        break;
      }
    }
    showNav.style.display = "block";
  }

  if ((window.ActiveXObject && !window.opera) && !window.XMLHttpRequest) {
  // IE6
    document.documentElement.style.overflow = "hidden";
    document.body.style.margin = "0";
    document.body.style.overflow = "hidden";

    tahitiBody = tahitiNav.cloneNode(false);

    tahitiNavFrame.style.position = "absolute";

    tahitiBodyFrame = tahitiNavFrame.cloneNode(false);
    tahitiBodyFrame.style.overflow = "auto";

    tahitiNavFrame.style.left = "0";
    tahitiNavFrame.style.overflowX = "hidden";
    tahitiNavFrame.style.overflowY = scrollBar;
    tahitiNavFrame.style.background = navBackground;

    content = document.getElementsByTagName("div");
    div = [];
    for (i = 0; i < content.length; i += 1) {
      if (content[i].className === "header" ||
          content[i].className === "IND" ||
          content[i].className === "footer") {
        div.push(content[i]);
      }
    }
    for (i = 0; i < div.length; i += 1) { tahitiBody.appendChild(div[i]); }

    hideNav.onclick = function () {
      navHiddenIe6();
      createCookie("ORA_TAHITI_NAV", "hide");
      window.onresize = function () {
        navHiddenIe6();
        createCookie("ORA_TAHITI_NAV", "hide");
      };
      return false;
    };

    showNav.onclick = function () {
      navVisibleIe6();
      createCookie("ORA_TAHITI_NAV", "", -1);
      window.onresize = function () {
        navVisibleIe6();
        createCookie("ORA_TAHITI_NAV", "", -1);
      };
      return false;
    };

    navVisibleIe6();
    window.onresize = function () { navVisibleIe6(); };

    tahitiNavFrame.appendChild(tahitiNav);
    tahitiBodyFrame.appendChild(tahitiBody);
    document.body.appendChild(tahitiNavFrame);
    document.body.appendChild(tahitiBodyFrame);

    if (readCookie("ORA_TAHITI_NAV") === "hide" ||
        window.name === "glossWindow" ||
        window.self !== window.top) { navHiddenIe6(); }
    img = document.getElementsByTagName("img");
    for (i = 0; i < img.length; i += 1) { img[i].style.border = "0"; }
  } else {   // non IE6
    document.body.style.margin = "1ex 0.5em 1ex 26%";

    tahitiNavFrame.style.position = "fixed";
    tahitiNavFrame.style.left = "0";
    tahitiNavFrame.style.width = "25%";
    tahitiNavFrame.style.overflowX = "hidden";
    tahitiNavFrame.style.overflowY = scrollBar;
    tahitiNavFrame.style.background = navBackground;

    tahitiNavFrame.appendChild(tahitiNav);
    document.body.appendChild(tahitiNavFrame);

    hideNav.onclick = function () { navHidden(); return false; };
    showNav.onclick = function () { navVisible(); return false; };
    document.body.appendChild(showNav);

    if (readCookie("ORA_TAHITI_NAV") === "hide" ||
        window.name === "glossWindow" ||
        window.self !== window.top) { navHidden(); }
  }
  tahitiNav.appendChild(hideNav);

  function addThisPage() {
    var a, ul, d, p, lastItem, listItem, newList, thisPage, gloss_a,
      ga, g_li, gList, h1, i = 0, j = 0, autoId = 0, listStack = [],
      headings = [], glossterms = [], heading = document.createElement("p");

    heading.style.marginBottom = "0";
    heading.style.fontWeight = "bold";
    heading.style.borderBottom = "1px solid #999";
    heading.appendChild(document.createTextNode("This Page"));
    heading.style.cursor = "pointer";
    heading.onclick = function () {
      if (document.getElementById("tThisPage").style.display === "none") {
        document.getElementById("tThisPage").style.display = "block";
      } else {
        document.getElementById("tThisPage").style.display = "none";
      }
    };

    function getTextContent(e) {
      if (e.textContent) { return e.textContent; }
      if (e.innerText) { return e.innerText; }
    }

    function headingDifference(e1, e2) {
      return Math.abs(e1.nodeName.charAt(1) - e2.nodeName.charAt(1));
    }

    function copyContent(s, d) {
      var i = 0;
      if (!s.hasChildNodes()) { return null; }
      if (s.childNodes.length === 1 && s.childNodes[0].nodeName.match(/a/i)) {
        return copyContent(s.childNodes[0], d);
      }
      for (i = 0; i < s.childNodes.length; i += 1) {
        if (s.childNodes[i].className !== "secnum") {
          d.appendChild(s.childNodes[i].cloneNode(true));
        }
      }
    }

    function getHeadings(e) {
      var i = 0, c = e.childNodes;
      for (i = 0; i < c.length; i += 1) {
        if (c[i].nodeType === 1 && c[i].nodeName.match(/h[2-4]/i)) {
          if (!c[i].id) {
            c[i].id = "autoId" + autoId;
            autoId += 1;
          }
          headings.push(c[i]);
        } else if (c[i].hasChildNodes()) { getHeadings(c[i]); }
      }
    }
    getHeadings(document.documentElement);

    for (i = 0; i < headings.length; i += 1) {
      lastItem = listItem;

      a = document.createElement("a");
      a.href = "#" + headings[i].id;
      listItem = document.createElement("li");
      copyContent(headings[i], a);
      listItem.appendChild(a);

      if (!lastItem) {
        ul = document.createElement("ul");
        ul.style.margin = "0";
        ul.style.padding = "0 0 0 1.5em";
        ul.style.textIndent = "-0.25em";
        listStack.push(ul);
      } else if (headings[i].nodeName > headings[i - 1].nodeName) {
        d = headingDifference(headings[i], headings[i - 1]);

        if (d > 1) {
          for (j = 0; j < d; j += 1) {
            if (j) {
              newList = document.createElement("ul");
              newList.style.margin = "0";
              newList.style.padding = "0 0 0 1.5em";
              newList.style.textIndent = "-0.25em";
              listStack[listStack.length - 1].appendChild(newList);
              listStack.push(newList);
            } else {
              newList = document.createElement("ul");
              newList.style.margin = "0";
              newList.style.padding = "0 0 0 1.5em";
              newList.style.textIndent = "-0.25em";
              lastItem.appendChild(newList);
              listStack.push(newList);
            }
          }
        } else {
          newList = document.createElement("ul");
          newList.style.margin = "0";
          newList.style.padding = "0 0 0 1.5em";
          newList.style.textIndent = "-0.25em";
          lastItem.appendChild(newList);
          listStack.push(newList);
        }
      } else if (headings[i].nodeName < headings[i - 1].nodeName) {
        d = headingDifference(headings[i], headings[i - 1]);
        for (j = 0; j < d; j += 1) {
          listStack.pop();
        }
      }

      listStack[listStack.length - 1].appendChild(listItem);
    }

    thisPage = document.createElement("div");

    if (!listStack[0]) {
      p = document.getElementsByTagName("p");
      for (i = 0; i < p.length; i += 1) {
        if (p[i].className === "glossterm") {
          gloss_a = p[i].getElementsByTagName("a");
          for (j = 0; j < gloss_a.length; j += 1) {
            if (gloss_a[j].id) {
              ga = document.createElement("a");
              ga.href = "#" + gloss_a[j].id;
              ga.appendChild(document.createTextNode(getTextContent(p[i])));
              g_li = document.createElement("li");
              g_li.appendChild(ga);
              glossterms.push(g_li);
              break;
            }
          }
        }
      }
      if (glossterms.length > 0) {
        gList = document.createElement("ul");
        gList.style.margin = "0";
        gList.style.padding = "0 0 0 1.5em";
        gList.style.textIndent = "-0.25em";
        for (i = 0; i < glossterms.length; i += 1) {
          gList.appendChild(glossterms[i]);
        }
        listStack.push(gList);
      }
    }

    if (listStack[0]) {
      listStack[0].id = "tThisPage";
      thisPage.appendChild(heading);
      thisPage.appendChild(listStack[0]);
    }

    h1 = document.getElementsByTagName("h1");
    try {
      if (window.location.href.match(/\/toc\.htm(?:|#[\x20-\x7E]*)$/) &&
          (h1 && h1[0].className === "toc")) {
        return document.createElement("span");
      }
    } catch (e) {}
    return thisPage;
  }
  tahitiNav.appendChild(addThisPage());

  function addThisDocument() {
    var heading, a, metas, li1, ul, thisDocument, i = 0, title = "Contents";

    heading = document.createElement("p");
    heading.style.marginBottom = "0";
    heading.style.fontWeight = "bold";
    heading.style.borderBottom = "1px solid #999";
    heading.appendChild(document.createTextNode("This Document"));
    heading.style.cursor = "pointer";
    heading.onclick = function () {
      if (document.getElementById("tThisDocument").style.display === "none") {
        document.getElementById("tThisDocument").style.display = "block";
      } else {
        document.getElementById("tThisDocument").style.display = "none";
      }
    };

    a = document.createElement("a");
    a.href = "toc.htm#BEGIN";
    metas = document.getElementsByTagName("meta");
    for (i = 0; i < metas.length; i += 1) {
      if (metas[i].name === "doctitle" && metas[i].content) {
        title = metas[i].content;
      }
    }
    a.appendChild(document.createTextNode(title));

    li1 = document.createElement("li");
    li1.appendChild(a);

    ul = document.createElement("ul");
    ul.id = "tThisDocument";
    ul.style.margin = "0";
    ul.style.padding = "0 0 0 1.5em";
    ul.style.textIndent = "-0.25em";
    ul.appendChild(li1);

    thisDocument = document.createElement("div");
    thisDocument.appendChild(heading);
    thisDocument.appendChild(ul);

    return thisDocument;

  }
  tahitiNav.appendChild(addThisDocument());

}
addLoadEvent(leftNav);

function processToc() {
  "use strict";
  try {
    if (!window.location.href.match(/\/toc\.htm(?:|#[\x20-\x7E]*)$/)) {
      return false;
    }
  } catch (e1) {}

  var p, a, a1, a2, IND, img, preload, i = 0,
    iUrlStart = "../../nav/",
    h1 = document.getElementsByTagName("h1"),
    div = document.getElementsByTagName("div");

  if (!h1[0] || h1[0].className !== "toc") { return false; }

  preload = new Image();
  preload.src = iUrlStart + "images/blue_med_dark_down.gif";
  preload.alt = "Click to collapse";

  for (i = 0; i < div.length; i += 1) {
    if (div[i].className === "IND") { IND = div[i]; }
  }

  function nextUl(node) {
    while (node.nextSibling) {
      if (node.nextSibling.nodeName.match(/ul/i)) { return node.nextSibling; }
      node = node.nextSibling;
    }
  }

  function showNextUl(owner) {
    var ul = nextUl(owner.parentNode);
    ul.style.display = "block";
    owner.getElementsByTagName("img")[0].src =
      iUrlStart + "images/blue_med_dark_down.gif";
    owner.getElementsByTagName("img")[0].alt = "Click to collapse";
    owner.onclick = function () { hideNextUl(this); return false; };
  }

  function hideNextUl(owner) {
    var ul = nextUl(owner.parentNode);
    ul.style.display = "none";
    owner.getElementsByTagName("img")[0].src =
      iUrlStart + "images/blue_med_dark_side.gif";
    owner.getElementsByTagName("img")[0].alt = "Click to expand";
    owner.onclick = function () { showNextUl(this); return false; };
  }

  function expandAll() {
    var i = 0, a = IND.getElementsByTagName("a");
    for (i = 0; i < a.length; i += 1) {
      if (a[i].className === "tDiscTriangle") {
        showNextUl(a[i]);
      }
    }
    createCookie("ORA_TAHITI_TOC", "expand");
    return false;
  }

  function collapseAll() {
    var i = 0, a = IND.getElementsByTagName("a");
    for (i = 0; i < a.length; i += 1) {
      if (a[i].className === "tDiscTriangle") {
        hideNextUl(a[i]);
      }
    }
    createCookie("ORA_TAHITI_TOC", "", -1);
    return false;
  }

  function okShowTriangle(node) {
    while (node.nextSibling) {
      if (node.nextSibling.nodeName.match(/h2/i)) { return false; }
      if (node.nextSibling.nodeName.match(/ul/i)) { return true; }
      node = node.nextSibling;
    }
    return false;
  }

  function getTextContent(e) {
    if (e.textContent) { return e.textContent; }
    if (e.innerText) { return e.innerText; }
  }

  for (i = 0; i < IND.childNodes.length; i += 1) {
    if (IND.childNodes[i].nodeName.match(/^ul$/i)) {
      IND.childNodes[i].style.marginTop = "0";
      IND.childNodes[i].style.marginBottom = "1ex";
      IND.childNodes[i].style.display = "none";
    } else if (IND.childNodes[i].nodeName.match(/^h2$/i)) {
      if (IND.childNodes[i].className === "tocheader") {
        IND.childNodes[i].style.fontSize = "140%";
        IND.childNodes[i].style.marginTop = "0";
        IND.childNodes[i].style.marginBottom = "0.5ex";
        if (getTextContent(IND.childNodes[i]) &&
            getTextContent(IND.childNodes[i]).match(/Part\s+[IVXLCDM]+\s+/)) {
          IND.childNodes[i].style.textAlign = "center";
          IND.childNodes[i].style.marginTop = "1.7ex";
          IND.childNodes[i].style.borderTop = "2px solid #A4C3DF";
        } else {
          img = document.createElement("img");
          img.src = iUrlStart + "images/blue_med_dark_side.gif";
          img.alt = "Click to expand";
          a = document.createElement("a");
          a.href = "#";
          a.onclick = function () { showNextUl(this); return false; };
          a.onfocus = function () { window.status = ''; return true; };
          a.className = "tDiscTriangle";
          a.style.textDecoration = "none";
          a.appendChild(img);
          if (okShowTriangle(IND.childNodes[i])) {
            IND.childNodes[i].insertBefore(document.createTextNode(" "),
              IND.childNodes[i].firstChild);
            IND.childNodes[i].insertBefore(a, IND.childNodes[i].firstChild);
          }
        }
      }
    }
  }

  p = document.createElement("p");
  p.style.marginTop = "0";
  p.style.marginBottom = "0";
  p.style.textAlign = "right";
  a1 = document.createElement("a");
  a1.href = "#";
  a1.onfocus = function () { window.status = ''; return true; };
  a1.style.color = "#039";
  a1.style.textDecoration = "none";
  a1.onclick = expandAll;
  a2 = document.createElement("a");
  a2.href = "#";
  a2.onfocus = function () { window.status = ''; return true; };
  a2.style.color = "#039";
  a2.style.textDecoration = "none";
  a2.onclick = collapseAll;
  a1.appendChild(document.createTextNode("Expand All"));
  a2.appendChild(document.createTextNode("Collapse All"));
  p.appendChild(a1);
  p.appendChild(document.createTextNode(" \u00B7 "));
  p.appendChild(a2);
  document.getElementsByTagName("h1")[0].style.marginBottom = "0";
  document.getElementsByTagName("h1")[0].parentNode.insertBefore(p,
    document.getElementsByTagName("h1")[0].nextSibling);

  if (readCookie("ORA_TAHITI_TOC") === "expand") { expandAll(); }
}
addLoadEvent(processToc);

function processIndex() {
  "use strict";
  try {
    if (!window.location.href.match(/\/index\.htm(?:|#[\x20-\x7E]*)$/)) {
      return false;
    }
  } catch (e) {}

  var prefix, s, nav, i = 0, shortcut = [], lastPrefix = "",
    dd = document.getElementsByTagName("dd"),
    h2 = document.getElementsByTagName("h2");

  function getTextContent(e) {
    if (e.textContent) { return e.textContent; }
    if (e.innerText) { return e.innerText; }
  }

  for (i = 0; i < dd.length; i += 1) {
    if (dd[i].className === 'l1ix') {
      prefix = getTextContent(dd[i]).substring(0, 2).toUpperCase();
      if (prefix.match(/^([A-Z0-9]{2})/) && prefix !== lastPrefix) {
        dd[i].id = prefix;
        s = document.createElement("a");
        s.href = "#" + prefix;
        s.appendChild(document.createTextNode(prefix));
        shortcut.push(s);
        lastPrefix = prefix;
      }
    }
  }

  for (i = 0; i < h2.length; i += 1) {
    nav = document.createElement("div");
    nav.style.position = "relative";
    nav.style.top = "-1.5ex";
    nav.style.left = "1.5em";
    nav.style.width = "90%";
    while (shortcut[0] &&
        shortcut[0].toString().charAt(shortcut[0].toString().length - 2) ===
        getTextContent(h2[i])) {
      nav.appendChild(shortcut.shift());
      nav.appendChild(document.createTextNode("\u00A0 "));
    }
    h2[i].parentNode.insertBefore(nav, h2[i].nextSibling);
  }
}
addLoadEvent(processIndex);

function compactLists() {
  "use strict";
  var li, p, i = 0, j = 0, k = 0, collapsible = true, lists = [], clists = [],
    ul = document.getElementsByTagName("ul"),
    ol = document.getElementsByTagName("ol");

  for (i = 0; i < ul.length; i += 1) { lists.push(ul[i]); }
  for (i = 0; i < ol.length; i += 1) { lists.push(ol[i]); }

  function getTextContent(e) {
    if (e.textContent) { return e.textContent; }
    if (e.innerText) { return e.innerText; }
  }

  for (i = 0; i < lists.length; i += 1) {
    collapsible = true;
    clists = [];
    li = lists[i].getElementsByTagName("li");
    for (j = 0; j < li.length; j += 1) {
      p = li[j].getElementsByTagName("p");
      if (p.length > 1) { collapsible = false; }
      for (k = 0; k < p.length; k += 1) {
        if (getTextContent(p[k]).split(" ").length > 12) {
          collapsible = false;
        }
        clists.push(p[k]);
      }
    }
    if (collapsible) {
      for (j = 0; j < clists.length; j += 1) {
        clists[j].style.margin = "0";
      }
    }
  }
}
addLoadEvent(compactLists);

function positionAnchor() {
  "use strict";
  if (!window.ActiveXObject || window.opera) { return false; }

  var a, i = 0, location = [], anchor = "";

  try {
    if (window.location.href.match(/#([\x20-\x7E]+)$/)) { anchor = RegExp.$1; }
  } catch (e) {
    return;
  }

  function findPos(obj) {
    var curleft = 0, curtop = 0;
    if (obj.offsetParent) {
      do {
        curleft += obj.offsetLeft;
        curtop += obj.offsetTop;
      } while (obj = obj.offsetParent);
    }
    return [curleft, curtop];
  }

  if (document.getElementById(anchor)) {
    location = findPos(document.getElementById(anchor));
    window.scrollTo(0, location[1]);
  } else {
    a = document.getElementsByTagName("a");
    for (i = 0; i < anchor.length; i += 1) {
      if (a[i].className === anchor) {
        location = findPos(a[i]);
        window.scrollTo(0, location[1]);
      }
    }
  }
}
addLoadEvent(positionAnchor);
