var tAuthority = "www.oracle.com";
var tSchema = "";
var navBackground = "#A4C3DF";
var scrollBar = "auto";

/*
  Copyright 2006, 2014, Oracle and/or its affiliates. All rights reserved.
  Author: Robert Crews
  Version: 2014.03.04
*/

var linkcategories = {
    homepage           : "../../index.htm"
  };

var l10n = {
    show_navigation         : "Show Navigation",
    hide_navigation         : "Hide Navigation",
    search_button           : "Search",
    hide                    : "hide",
    show                    : "show",
    reference               : "Reference",
    home                    : "Home",
    master_index            : "Master Index",
    master_glossary         : "Master Glossary",
    master_book_list        : "Master Book List",
    main_categories         : "Categories",
    security                : "Security",
    contents                : "Contents",
    new_changed             : "New and changed documents",
    reader_comment          : "Reader Comment",
    subject                 : "Subject",
    from                    : "From",
    anonymous               : "Anonymous",
    or                      : " (or ",
    sign_in                 : "Sign In",
    comment_first_part      : "Comments, corrections, and suggestions are forwarded to authors every week.",
    comment_second_part     : "By submitting, you confirm you agree to the ",
    comment_third_part      : "terms and conditions",
    comment_fourth_part     : ". ",
    comment_fifth_part      : "Use the ",
    comment_fifth_part_otn  : "OTN forums",
    comment_sixth_part      : " for product questions. ",
    comment_seventh_part    : "For support or consulting, file a service request through ",
    comment_eighth_part     : "My Oracle Support",
    submit                  : "Submit",
    need_an_example         : "Need an example?",
    tell_us_more            : "Tell us more",
    click_to_expand         : "Click to expand",
    expand_all              : "Expand All",
    collapse_all            : "Collapse All"
  };

function addLoadEvent(func) {
  "use strict";
  var oldOnload = window.onload;
  if (typeof window.onload !== "function") {
    window.onload = func;
  } else {
    window.onload = function () { oldOnload(); func(); };
  }
}

function createCookie(name, value, days) {
  "use strict";
  var date, expires = "";
  if (days) {
    date = new Date();
    date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
    expires = "; expires=" + date.toGMTString();
  } else {
    expires = "";
  }
  document.cookie = name + "=" + value + expires + "; path=/";
}

function readCookie(name) {
  "use strict";
  var i = 0, c, nameEQ = name + "=", ca = document.cookie.split(";");
  for (i = 0; i < ca.length; i += 1) {
    c = ca[i];
    while (c.charAt(0) === " ") {
      c = c.substring(1, c.length);
    }
    if (c.indexOf(nameEQ) === 0) {
      return c.substring(nameEQ.length, c.length);
    }
  }
  return "";
}
// https://developer.mozilla.org/en-US/docs/JavaScript/Reference/Global_Objects/JSON#Browser_compatibility
if (!window.JSON) {
//  "use strict";
  window.JSON = {
    parse: function (sJSON) { return eval("(" + sJSON + ")"); }
  };
}

function leftNav() {
//  "use strict";
  if (!document.createElement) { return false; }
  if (!document.createTextNode) { return false; }
  if (!document.getElementById) { return false; }
  if (!document.getElementsByTagName) { return false; }
  if (!document.documentElement.appendChild) { return false; }
  if (!document.documentElement.childNodes) { return false; }
  if (!document.documentElement.style) { return false; }

  if (navigator.userAgent.match(/\bMobile\b/)) { return false; }
  try {
    if (window.location.href.match(/\/pls\//)) { return false; }
    if (window.location.href.match(/type=popup#/)) { return false; } // no nav for gloss pop up
    if (window != window.top) { return false; } // show the nav only if the window is not in a frame
  } catch (ignore) {}

  var tahitiNav, tahitiNavFrame, showNav, hideNav, tahitiBody, tahitiBodyFrame,
    content, div, imgCollection, iter = 0, gearImg;

  document.body.style.padding = "0";
  document.body.style.border = "0";

  tahitiNav = document.createElement("div");
  tahitiNav.style.padding = "1ex 0.5em";

  tahitiNavFrame = document.createElement("div");
  tahitiNavFrame.style.top = "0";
  tahitiNavFrame.style.bottom = "0";

  showNav = document.createElement("a");

  if (!((window.ActiveXObject && !window.opera) && !window.XMLHttpRequest)) {
    showNav.href = "#";
    showNav.title = l10n.show_navigation;
    showNav.style.textDecoration = "none";
    //showNav.style.background = "#A4C3DF";
    showNav.style.top = "10ex";
    showNav.style.left = "0";
    showNav.style.position = "fixed";
    showNav.style.cursor = "pointer";
    showNav.style.display = "none";
    showNav.style.opacity = "0.35";
    showNav.style.filter = "alpha(opacity=35)";
    showNav.style.marginLeft = "0%";
    showNav.style.width = "0";
    showNav.style.height = "20px";
    showNav.style.borderLeft = "21px solid " + navBackground;
    showNav.style.borderTop = "18px solid transparent";
    showNav.style.borderBottom = "20px solid transparent";

    gearImg = document.createElement("img");
    gearImg.width = "20";
    gearImg.height = "20";
    gearImg.src = "../../nav/images/gear.png";
    gearImg.alt = "View Navigation";
    gearImg.style.top = "12.45ex";
    gearImg.style.left = "0";
    gearImg.style.position = "fixed";
    gearImg.style.border = "1px solid transparent";
    showNav.appendChild(gearImg);
  }

  hideNav = document.createElement("a");
  hideNav.href = "#";
  hideNav.style.textDecoration = "none";
  hideNav.style.color = "#039";
  hideNav.style.display = "block";
  hideNav.style.textAlign = "right";
  hideNav.style.cursor = "pointer";
  hideNav.appendChild(document.createTextNode(l10n.hide_navigation));

  function navVisible() {
    tahitiNavFrame.style.display = "block";
    document.body.style.marginLeft = "26%";
    showNav.style.display = "none";
    createCookie("ORA_TAHITI_NAV", "", -1);
  }

  function navHidden() {
    tahitiNavFrame.style.display = "none";
    document.body.style.marginLeft = "0.5em";
    showNav.style.display = "block";
    if (window.name !== "glossWindow" ||
        window.self === window.top) {
      createCookie("ORA_TAHITI_NAV", "hide");
    }
  }

  function navVisibleIe6() {
    tahitiNavFrame.style.display = "block";
    tahitiNavFrame.style.width = "25%";
    tahitiBodyFrame.style.left = "25%";
    tahitiBodyFrame.style.width = "75%";
    tahitiNavFrame.style.width = document.documentElement.clientWidth -
      document.documentElement.clientWidth * 0.75;
    tahitiNavFrame.style.height = document.documentElement.clientHeight;
    tahitiBodyFrame.style.width = document.documentElement.clientWidth -
      document.documentElement.clientWidth * 0.25;
    tahitiBodyFrame.style.height = document.documentElement.clientHeight;
    tahitiNav.style.width = document.documentElement.clientWidth -
      document.documentElement.clientWidth * 0.75 - 32;
    tahitiBody.style.width = document.documentElement.clientWidth -
      document.documentElement.clientWidth * 0.25 - 32;
    showNav.style.display = "none";
  }

  function navHiddenIe6() {
    var i = 0;
    tahitiNavFrame.style.display = "none";
    tahitiBodyFrame.style.left = "0";
    tahitiBodyFrame.style.width = document.documentElement.clientWidth;
    tahitiBodyFrame.style.height = document.documentElement.clientHeight;
    tahitiBody.style.width = document.documentElement.clientWidth - 32;
    content = document.getElementsByTagName("div");
    for (i = 0; i < content.length; i += 1) {
      if (content[i].className === "header") {
        content[i].parentNode.insertBefore(showNav, content[i]);
        break;
      }
    }
    showNav.style.display = "block";
  }

  if ((window.ActiveXObject && !window.opera) && !window.XMLHttpRequest) {
  // IE6
    document.documentElement.style.overflow = "hidden";
    document.body.style.margin = "0";
    document.body.style.overflow = "hidden";

    tahitiBody = tahitiNav.cloneNode(false);

    tahitiNavFrame.style.position = "absolute";

    tahitiBodyFrame = tahitiNavFrame.cloneNode(false);
    tahitiBodyFrame.style.overflow = "auto";

    tahitiNavFrame.style.left = "0";
    tahitiNavFrame.style.overflowX = "hidden";
    tahitiNavFrame.style.overflowY = scrollBar;
    tahitiNavFrame.style.background = navBackground;

    content = document.getElementsByTagName("div");
    div = [];
    for (iter = 0; iter < content.length; iter += 1) {
      if (content[iter].className === "header" ||
          content[iter].className === "IND" ||
          content[iter].className === "footer") {
        div.push(content[iter]);
      }
    }
    for (iter = 0; iter < div.length; iter += 1) { tahitiBody.appendChild(div[iter]); }

    hideNav.onclick = function () {
      navHiddenIe6();
      createCookie("ORA_TAHITI_NAV", "hide");
      window.onresize = function () {
        navHiddenIe6();
        createCookie("ORA_TAHITI_NAV", "hide");
      };
      return false;
    };

    showNav.onclick = function () {
      navVisibleIe6();
      createCookie("ORA_TAHITI_NAV", "", -1);
      window.onresize = function () {
        navVisibleIe6();
        createCookie("ORA_TAHITI_NAV", "", -1);
      };
      return false;
    };

    navVisibleIe6();
    window.onresize = function () { navVisibleIe6(); };

    tahitiNavFrame.appendChild(tahitiNav);
    tahitiBodyFrame.appendChild(tahitiBody);
    document.body.appendChild(tahitiNavFrame);
    document.body.appendChild(tahitiBodyFrame);

    if (readCookie("ORA_TAHITI_NAV") === "hide" ||
        window.name === "glossWindow" ||
        window.self !== window.top) { navHiddenIe6(); }
    imgCollection = document.getElementsByTagName("img");
    for (iter = 0; iter < imgCollection.length; iter += 1) { imgCollection[iter].style.border = "0"; }
  } else {   // non IE6
    document.body.style.margin = "1ex 0.5em 1ex 26%";

    tahitiNavFrame.style.position = "fixed";
    tahitiNavFrame.style.left = "0";
    tahitiNavFrame.style.width = "25%";
    tahitiNavFrame.style.overflowX = "hidden";
    tahitiNavFrame.style.overflowY = scrollBar;
    tahitiNavFrame.style.background = navBackground;

    tahitiNavFrame.appendChild(tahitiNav);
    document.body.appendChild(tahitiNavFrame);

    hideNav.onclick = function () { navHidden(); return false; };
    showNav.onclick = function () { navVisible(); return false; };
    document.body.appendChild(showNav);

    if (readCookie("ORA_TAHITI_NAV") === "hide" ||
        window.name === "glossWindow" ||
        window.self !== window.top) { navHidden(); }
  }
  tahitiNav.appendChild(hideNav);

  function addSimpleSearchForm() {
    var searchRemark, searchField, searchFieldLabel, searchSubmit, simpleSearchForm;

    searchRemark = document.createElement("input");
    searchRemark.type = "hidden";
    searchRemark.name = "group";
    searchRemark.value = "Documentation";

    searchField = document.createElement("input");
    searchField.id = "k";
    searchField.type = "text";
    searchField.name = "q";

    searchFieldLabel = document.createElement("label");
    searchFieldLabel.htmlFor = "k";
    searchFieldLabel.style.display = "none";
    searchFieldLabel.appendChild(document.createTextNode(l10n.search_button));
    searchFieldLabel.style.position = "absolute";
    searchFieldLabel.style.left = "-10000px";
    searchFieldLabel.style.top = "auto";
    searchFieldLabel.style.width = "1px";
    searchFieldLabel.style.height = "1px";
    searchFieldLabel.style.overflow = "hidden";

    searchSubmit = document.createElement("input");
    searchSubmit.type = "submit";
    searchSubmit.value = l10n.search_button;

    simpleSearchForm = document.createElement("form");
    simpleSearchForm.action =
      "http://search.oracle.com/search/search";
    simpleSearchForm.onsubmit = function () {
      document.getElementById('k').value += ' url:/cd/E29350_01';
      return true;
    }
    simpleSearchForm.method = "get";
    simpleSearchForm.appendChild(searchRemark);
    simpleSearchForm.appendChild(searchField);
    simpleSearchForm.appendChild(searchFieldLabel);
    simpleSearchForm.appendChild(document.createTextNode(" "));
    simpleSearchForm.appendChild(searchSubmit);
    simpleSearchForm.appendChild(document.createElement("br"));

    return simpleSearchForm;
  }
  tahitiNav.appendChild(addSimpleSearchForm());

  function addQuickLookup() {
    var heading, label, labelHide, labelShow, p, quickLookup;

    label = document.createElement("span");
    label.id = "hQuickLookup";
    label.style.cssFloat = "right";
    label.style.styleFloat = "right";
    label.style.color = "#669";
    label.style.fontWeight = "normal";
    label.style.display = "none";
    if (navBackground === "white") {
      labelHide = document.createTextNode("");
      labelShow = document.createTextNode("");
    } else {
      labelHide = document.createTextNode(l10n.hide);
      labelShow = document.createTextNode(l10n.show);
    }
    label.appendChild(labelHide);

    heading = document.createElement("p");
    heading.appendChild(label);
    heading.style.marginBottom = "0";
    heading.style.fontWeight = "bold";
    heading.style.borderBottom = "1px solid #999";
    heading.appendChild(document.createTextNode(l10n.reference));

    heading.style.cursor = "pointer";
    heading.onmouseover = function () {
      document.getElementById("hQuickLookup").style.display = "inline";
    };
    heading.onmouseout = function () {
      document.getElementById("hQuickLookup").style.display = "none";
    };
    heading.onclick = function () {
      if (document.getElementById("tQuickLookup").style.display === "none") {
        document.getElementById("tQuickLookup").style.display = "block";
        document.getElementById("hQuickLookup").replaceChild(labelHide, labelShow);
      } else {
        document.getElementById("tQuickLookup").style.display = "none";
        document.getElementById("hQuickLookup").replaceChild(labelShow, labelHide);
      }
    };

    p = document.createElement("p");
    p.id = "tQuickLookup";
    p.style.marginTop = "0";

    function link(label, tProc) {
      var item = document.createElement("a");
      item.href = tProc;
      item.appendChild(document.createTextNode(label));
      if (p.childNodes.length > 0) {
        p.appendChild(document.createTextNode(" \u00B7 "));
      }
      p.appendChild(item);
    }

    link(l10n.home, linkcategories.homepage);

    quickLookup = document.createElement("div");
    if (!tSchema.match(/^as111/)) {
      quickLookup.appendChild(heading);
    }
    quickLookup.appendChild(p);

    return quickLookup;
  }
  tahitiNav.appendChild(addQuickLookup());

  function addMainCategories() {
    var heading, label, labelHide, labelShow, ul, mainCategories;

    label = document.createElement("span");
    label.id = "hMainCategories";
    label.style.cssFloat = "right";
    label.style.styleFloat = "right";
    label.style.color = "#669";
    label.style.fontWeight = "normal";
    label.style.display = "none";
    if (navBackground === "white") {
      labelHide = document.createTextNode("");
      labelShow = document.createTextNode("");
    } else {
      labelHide = document.createTextNode(l10n.hide);
      labelShow = document.createTextNode(l10n.show);
    }
    label.appendChild(labelHide);

    heading = document.createElement("p");
    heading.appendChild(label);
    heading.style.marginBottom = "0";
    heading.style.fontWeight = "bold";
    heading.style.borderBottom = "1px solid #999";
    if (tSchema === 'as1111' || tSchema === 'as111140' || tSchema === 'as111150'
        || tSchema === 'as111160' || tSchema === 'as111170') {
      heading.appendChild(document.createTextNode("Using Oracle Fusion Middleware"));
    } else {
      heading.appendChild(document.createTextNode(l10n.main_categories));
    }

    heading.style.cursor = "pointer";
    heading.onmouseover = function () {
      document.getElementById("hMainCategories").style.display = "inline";
    };
    heading.onmouseout = function () {
      document.getElementById("hMainCategories").style.display = "none";
    };
    heading.onclick = function () {
      if (document.getElementById("tMainCategories").style.display === "none") {
        document.getElementById("tMainCategories").style.display = "block";
        document.getElementById("hMainCategories").replaceChild(labelHide, labelShow);
      } else {
        document.getElementById("tMainCategories").style.display = "none";
        document.getElementById("hMainCategories").replaceChild(labelShow, labelHide);
      }
    };

    ul = document.createElement("ul");
    ul.id = "tMainCategories";
    ul.style.margin = "0";
    ul.style.padding = "0 0 0 1.5em";
    ul.style.textIndent = "-0.25em";

    function link(label, tProc) {
      var item = document.createElement("a"),
        itemLi = document.createElement("li");
      item.href = tProc;
      item.appendChild(document.createTextNode(label));
      itemLi.appendChild(item);
      ul.appendChild(itemLi);
    }

    link(l10n.security, "http://search.oracle.com/search/search?group=Documentation&q=Security+url:/cd/E29350_01");

    mainCategories = document.createElement("div");
    mainCategories.appendChild(heading);
    mainCategories.appendChild(ul);

    return mainCategories;
  }

  if (tSchema !== "jde898" && tSchema !== 'tt1121' &&
      !tSchema.match(/^as1112\d+/) && !tSchema.match(/^fmw1211\d+/) &&
      !tSchema.match(/^idm\d+/) && !tSchema.match(/^moshelp/)) {
    tahitiNav.appendChild(addMainCategories());
  }

  function addThisDocument() {
    var heading, label, labelHide, labelShow, a, li1, ul, thisDocument,
      img, elist = [], iUrlStart = "../../nav/images/", aHref, h1Elements,
      nav_cookie_name = "ORA_" + "E29350_01" + "_NAV", error404 = 0,
      isIE11 = !!navigator.userAgent.match(/Trident.*rv[ :]*11\./),
      oraCloudNav = readCookie(nav_cookie_name);
    label = document.createElement("span");
    label.id = "hThisDocument";
    label.style.cssFloat = "right";
    label.style.styleFloat = "right";
    label.style.color = "#669";
    label.style.fontWeight = "normal";
    label.style.display = "none";
    if (navBackground === "white") {
      labelHide = document.createTextNode("");
      labelShow = document.createTextNode("");
    } else {
      labelHide = document.createTextNode(l10n.hide);
      labelShow = document.createTextNode(l10n.show);
    }
    label.appendChild(labelHide);

    heading = document.createElement("p");
    heading.appendChild(label);
    heading.style.marginBottom = "0";
    heading.style.fontWeight = "bold";
    heading.style.borderBottom = "1px solid #999";
    heading.appendChild(document.createTextNode(l10n.contents));

    heading.style.cursor = "pointer";
    heading.onmouseover = function () {
      document.getElementById("hThisDocument").style.display = "inline";
    };
    heading.onmouseout = function () {
      document.getElementById("hThisDocument").style.display = "none";
    };
    heading.onclick = function () {
      if (document.getElementById("tThisDocument").style.display === "none") {
        document.getElementById("tThisDocument").style.display = "block";
        document.getElementById("hThisDocument").replaceChild(labelHide, labelShow);
      } else {
        document.getElementById("tThisDocument").style.display = "none";
        document.getElementById("hThisDocument").replaceChild(labelShow, labelHide);
      }
    };
    thisDocument = document.createElement("div");

    a = document.createElement("a");

    function getHttpObject() {
      var xhr = false;
      if (window.XMLHttpRequest) {
        xhr = new window.XMLHttpRequest();
      } else if (window.ActiveXObject) {
        try {
          xhr = new window.ActiveXObject("Msxml2.XMLHTTP");
        } catch (e1) {
          try {
            xhr = new window.ActiveXObject("Microsoft.XMLHTTP");
          } catch (e2) {
            xhr = false;
          }
        }
      }
      return xhr;
    }
    try {
      /*if (window.location.href.match(/\/toc\.htm(?:|#[ -~]*)$/)) {
        return document.createElement("span");
      }*/
      h1Elements = document.getElementsByTagName("h1");
      if (h1Elements[0] && h1Elements[0].className === "toc") {
        return document.createElement("span");
      }
    } catch (ignore) {}

  // cloud part
    function expandChild1(e) {
      e.onclick = function () { collapseChild(this); return false; };
      e.firstChild.src = iUrlStart + "ec_open.png";
      e.parentNode.getElementsByTagName("ul")[0].style.display = "block";
    }

    function expandChild(e) {
      if (oraCloudNav) {
        createCookie(nav_cookie_name,
          oraCloudNav + "," + e.parentNode.getElementsByTagName("ul")[0].id);
        oraCloudNav = readCookie(nav_cookie_name);
      } else {
        createCookie(nav_cookie_name,
          e.parentNode.getElementsByTagName("ul")[0].id);
        oraCloudNav = readCookie(nav_cookie_name);
      }
      expandChild1(e);
    }

    function collapseChild1(e) {
      var i = 0, hul,
        uls = e.parentNode.getElementsByTagName("ul"),
        imgs = e.parentNode.getElementsByTagName("img");
      e.onclick = function () { expandChild(this); return false; };
      for (i = 0; i < uls.length; i += 1) {
        oraCloudNav = oraCloudNav.replace(uls[i].id, "");
        oraCloudNav = oraCloudNav.replace(new RegExp(",+"), ",");
        oraCloudNav = oraCloudNav.replace(new RegExp("^,|,$"), "");
        if (oraCloudNav) {
          createCookie(nav_cookie_name, oraCloudNav);
          oraCloudNav = readCookie(nav_cookie_name);
        } else {
          createCookie(nav_cookie_name, "", -1);
          oraCloudNav = readCookie(nav_cookie_name);
        }
        uls[i].style.display = "none";
      }
      for (i = 0; i < imgs.length; i += 1) {
        hul = imgs[i].parentNode.parentNode.getElementsByTagName("ul");
        if (hul && hul.length > 0) {
          imgs[i].src = iUrlStart + "ec_close.png";
          imgs[i].parentNode.onclick = function () { expandChild(this); return false; };
        }
      }
    }

    function collapseChild2(e) {
      var i = 0, hul,
        uls = e.parentNode.getElementsByTagName("ul"),
        imgs = e.parentNode.getElementsByTagName("img");
      e.onclick = function () { expandChild(this); return false; };
      for (i = 0; i < uls.length; i += 1) {
        uls[i].style.display = "none";
      }
      for (i = 0; i < imgs.length; i += 1) {
        hul = imgs[i].parentNode.parentNode.getElementsByTagName("ul");
        if (hul && hul.length > 0) {
          imgs[i].src = iUrlStart + "ec_close.png";
          imgs[i].parentNode.onclick = function () { expandChild(this); return false; };
        }
      }
    }

    function collapseChild(e) {
      if (e.parentNode.getElementsByTagName("ul")[0] && e.parentNode.getElementsByTagName("ul")[0].id) {
        oraCloudNav =
          oraCloudNav.replace(e.parentNode.getElementsByTagName("ul")[0].id, "");
        oraCloudNav = oraCloudNav.replace(new RegExp(",+"), ",");
        oraCloudNav = oraCloudNav.replace(new RegExp("^,|,$"), "");
        if (oraCloudNav) {
          createCookie(nav_cookie_name, oraCloudNav);
          oraCloudNav = readCookie(nav_cookie_name);
        } else {
          createCookie(nav_cookie_name, "", -1);
          oraCloudNav = readCookie(nav_cookie_name);
        }
        collapseChild1(e);
      }
    }

    function showTopics() {
      var cExists = 1, j = 0, request = getHttpObject();

      function items(par, item, id) {
        if (item === undefined) { return; }
        var i = 0, ulH = document.createElement("ul"),
          li = document.createElement("li"),
          a1, a2, b = document.createElement("b"), nextID;
        if (item instanceof Array) {
          ulH.id = id;
          ulH.style.margin = "0";
          ulH.style.padding = "0 1px 0 14px";
          ulH.style.textIndent = "-14px";
          ulH.style.listStyle = "none";
          for (i = 0; i < item.length - 1; i += 1) {
            if (item[i].a !== undefined) {
              nextID = item[i].a;
            } else {
              nextID = "";
            }
            if (item[i]) {
              par.appendChild(items(ulH, item[i]), nextID);
            }
          }
        } else {
          if (item.c && item.c.length > 0) {
            img = document.createElement("img");
            a1 = document.createElement("a");
            a2 = document.createElement("a");
            img.src = iUrlStart + "ec_open.png";
            img.alt = "open";
            img.width = "14";
            img.height = "12";
            a1.appendChild(img);
            a1.href = "#";
            a1.onclick = function () { collapseChild(this); return false; };
            a2.href = item.h;
          } else {
            a1 = document.createElement("a");
            a1.style.marginLeft = "14px";
            a1.appendChild(document.createTextNode(item.t));
            a1.href = item.h;
            li.appendChild(a1);
          }
          if (item.c && item.c.length > 0) {
            a2.appendChild(document.createTextNode(item.t));
            li.appendChild(a1);
            if (item.h) {
              li.appendChild(a2);
            } else {
              b.appendChild(document.createTextNode(item.t));
              b.style.color = "#66a";
              li.appendChild(b);
            }
          }
          if (item.c && item.c.length > 0) {
            par.appendChild(items(li, item.c, item.a));
          } else {
            //img.src = iUrlStart + "ec_none.png";
            par.appendChild(li);
          }
        }
        return par;
      }

      function parseResponse_json(request) {
        var jso, ul1, ipr = 0, iIter;
        if (request.readyState === 4) {
          if (request.status === 200 || request.status === 304 || request.status === 0) {
            jso = window.JSON.parse(request.responseText);
            for (ipr = 0; ipr < jso.docs.length; ipr += 1) {
              if (jso.docs[ipr] !== undefined) {
                if (jso.docs[ipr].c.length > 1) {
                  img = document.createElement("img");
                  img.src = iUrlStart + "ec_open.png";
                  img.alt = "open";
                  img.width = "14";
                  img.height = "12";
                  a.appendChild(img);
                  a.href = jso.docs[ipr].h;
                  a.onclick = function () { collapseChild(this); return false; };
                  aHref = document.createElement("a");
                  aHref.href = jso.docs[ipr].h;
                  aHref.appendChild(document.createTextNode(jso.docs[ipr].t.replace('\xAE', '')));
                  li1 = document.createElement("li");
                  li1.appendChild(a);
                  li1.appendChild(aHref);
                  ul1 = document.createElement("ul");
                  ul1.style.margin = "0";
                  ul1.style.display = "block";
                  ul1.style.padding = "0 1px 0 14px";
                  ul1.style.textIndent = "-14px";
                  ul1.style.listStyle = "none";
                  ul1.id = jso.docs[ipr].a;
                  for (j = 0; j < jso.docs[ipr].c.length - 1; j += 1) {
                    items(ul1, jso.docs[ipr].c[j], "");
                  }
                  li1.appendChild(ul1);
                }
              }
            }
            ul = document.createElement("ul");
            ul.style.margin = "0";
            ul.style.padding = "0 1px 0 14px";
            ul.style.textIndent = "-14px";
            ul.style.listStyle = "none";
            ul.id = "tThisDocument";
            ul.appendChild(li1);
            thisDocument.appendChild(heading);
            thisDocument.appendChild(ul);
            if (!oraCloudNav) {
              cExists = 0;
            }
            for (ipr = 0; ipr < ul.childNodes.length; ipr += 1) {
              if (ul.childNodes[ipr].getElementsByTagName("ul").length > 0) {
                collapseChild2(ul.childNodes[ipr].firstChild);
                if (cExists === 0 && ipr !== (ul.childNodes.length - 1)) {
                  expandChild(ul.childNodes[ipr].firstChild);
                }
              }
              if (!oraCloudNav) {
                expandChild(ul.childNodes[ipr].firstChild);
              }
            }
            cExists = 0;
            if (oraCloudNav) {
              elist = oraCloudNav.split(",");
              for (iIter = 0; iIter < elist.length; iIter += 1) {
                if (document.getElementById(elist[iIter])) {
                  expandChild1(document.getElementById(elist[iIter]).parentNode.firstChild);
                  cExists += 1;
                }
              }
              if (cExists === 0) {
                for (iIter = 0; iIter < ul.childNodes.length; iIter += 1) {
                  expandChild(ul.childNodes[iIter].firstChild);
                }
              }
            }
          }
        }
        // Ensure in case of long list the highlight is reset.
        // Interestingly if there is no timeout the browser does not take to the correct anchor sometimes.
        if (typeof highlighter === 'function') {
          setTimeout(function () {highlighter(); }, 100);
        }
      }

      function resetData() {
        if (error404 === 1) {
          try {
            if (request) {
              request.onreadystatechange = function () {
                parseResponse_json(request);
              };
              request.open("GET", window.location.href.replace(/\/[\x20-\x2E\x30-\x7E]+$/,
                "/target.json"), true);
              request.send(null);
            }
          } catch (e) {
            thisDocument = document.createTextNode("");
          }
        }
      }
      if (navigator.appName !== "Microsoft Internet Explorer" && !isIE11) {
        try {
          if (request) {
            request.onreadystatechange = function () {   
              parseResponse_json(request);
            };
            request.open("GET", window.location.href.replace(/\/[\x20-\x2E\x30-\x7E]+$/,
              "/target.json"), true);
            request.send(null);
          }
        } catch (e) {
          thisDocument = document.createTextNode("");
        }
      } else {
        try {
          if (request) {
            request.onreadystatechange = function () {
              if (request.status === 404) {
                error404 = 1;
              }
              parseResponse_json(request);
              if (error404 === 1) {
                resetData();
              }
            };
            request.open("GET", window.location.href.replace(/\/[\x20-\x2E\x30-\x7E]+$/,
              "/target_small.json"), true);
            request.send(null);
          }
        } catch (e) {
          try {
            if (request) {
              request.onreadystatechange = function () {
                parseResponse_json(request);
              };
              request.open("GET", window.location.href.replace(/\/[\x20-\x2E\x30-\x7E]+$/,
                "/target.json"), true);
              if (error404 === 1) {
                error404 = 0;
              }
              request.send(null);
            }
          } catch (e1) {
            thisDocument = document.createTextNode("");
          }
        }
      }

      return thisDocument;
    }
    if (!tSchema.match(/^moshelp/)) {
      tahitiNav.appendChild(showTopics());
    }
    return thisDocument;

  }

  if (!tSchema.match(/^moshelp/)) {
    tahitiNav.appendChild(addThisDocument());
  }

  function addRss() {
    var rssIcon1, rssIcon2, html, pdf, rss,
      iUrlStart = "../../nav/";

    rssIcon1 = document.createElement("img");
    rssIcon1.src = iUrlStart + "images/feed-icon-14x14.png";
    rssIcon1.alt = "RSS Feed";

    rssIcon2 = rssIcon1.cloneNode(false);

    html = document.createElement("a");
    html.href = "http://" + tAuthority + "/pls/" + tSchema + "/new_html";
    html.appendChild(rssIcon1);
    html.appendChild(document.createTextNode(" HTML"));

    pdf = document.createElement("a");
    pdf.href = "http://" + tAuthority + "/pls/" + tSchema + "/new_pdf";
    pdf.appendChild(rssIcon2);
    pdf.appendChild(document.createTextNode(" PDF"));

    rss = document.createElement("div");
    rss.id = "tRss";
    rss.style.marginTop = "2ex";
    rss.style.padding = "1ex 0.5em";
    rss.style.border = "1px solid #999";
    rss.appendChild(document.createTextNode(l10n.new_changed+':'));
    rss.appendChild(document.createElement("br"));
    rss.appendChild(html);
    rss.appendChild(document.createTextNode(" "));
    rss.appendChild(pdf);

    return rss;
  }
  if (!tSchema.match(/^as\d+/) && !tSchema.match(/^fa\d+/) &&
      !tSchema.match(/^fmw\d+/) && !tSchema.match(/^jde[iaw]*\d+$/) &&
      !tSchema.match(/^oc\d+$/) && !tSchema.match(/^idm\d+$/) &&
      !tSchema.match(/^moshelp/)) {
    tahitiNav.appendChild(addRss());
  }
}
addLoadEvent(leftNav);

function showComments() {
  "use strict";
  if (!document.createElement) { return false; }
  if (!document.createTextNode) { return false; }
  if (!document.documentElement.appendChild) { return false; }
  if (!document.documentElement.insertBefore) { return false; }
  if (!document.documentElement.style) { return false; }

  var footer, divs, legend, userCommentsTitleLabel, userCommentsTitle,
    subject, From, postPublic, postPublicLabel, postAnonymous, p, p1,
    postAnonymousLabel, div2, userCommentsBodyLabel, userCommentsBody, hidden,
    a1, a2, a3, a4, submit, topictitle, fieldset, commentForm, publicRadio,
    signOn, signOnLink, i = 0, tPath = "", user = "";

  if (readCookie("ORA_UCM_INFO").match(/([\-.+\w]+@[\-.+\w]+)/)) {
    user = RegExp.$1;
  }

  try {
    if (window.location.href.match(
        /([\x20-\x2E\x30-\x7E]+\/[\x20-\x2E\x30-\x7E]+\/[\x20-\x2E\x30-\x7E]+)$/
      )) {
      tPath = RegExp.$1;
      if (tPath.match(/([\x20-\x7E]+)#[\x20-\x7E]+/)) {
        tPath = RegExp.$1;
      }
    }
  } catch (ignore) {}

  divs = document.getElementsByTagName("div");
  for (i = 0; i < divs.length; i += 1) {
    if (divs[i].className === "footer") { footer = divs[i]; }
  }
  if (!footer) { return false; } /* needs verification */

  legend = document.createElement("legend");
  legend.style.fontWeight = "bold";
  legend.appendChild(document.createTextNode(l10n.reader_comment));

  userCommentsTitleLabel = document.createElement("label");
  userCommentsTitleLabel.style.color = "#666";
  userCommentsTitleLabel.htmlFor = "userCommentsTitle";
  userCommentsTitleLabel.appendChild(document.createTextNode(l10n.subject));

  userCommentsTitle = document.createElement("input");
  userCommentsTitle.type = "text";
  userCommentsTitle.name = "title";
  userCommentsTitle.id = "userCommentsTitle";
  userCommentsTitle.size = "40";

  subject = document.createElement("p");
  subject.style.marginBottom = "0";
  subject.appendChild(userCommentsTitleLabel);
  subject.appendChild(document.createTextNode(" "));
  subject.appendChild(userCommentsTitle);

  From = document.createElement("label");
  From.style.color = "#666";
  From.appendChild(document.createTextNode(l10n.from));

  postPublic = document.createElement("input");
  postPublic.type = "radio";
  postPublic.name = "submitter";
  postPublic.value = user;
  postPublic.id = "postPublic";

  postPublicLabel = document.createElement("label");
  postPublicLabel.htmlFor = "postPublic";
  postPublicLabel.appendChild(document.createTextNode(user.toLowerCase()));

  postAnonymous = document.createElement("input");
  postAnonymous.type = "radio";
  postAnonymous.name = "submitter";
  postAnonymous.value = "";
  postAnonymous.id = "postAnonymous";

  postAnonymousLabel = document.createElement("label");
  postAnonymousLabel.htmlFor = "postAnonymous";
  postAnonymousLabel.appendChild(document.createTextNode(l10n.anonymous));

  div2 = document.createElement("p");
  div2.style.margin = "1ex 0 1ex 0";
  div2.appendChild(From);
  div2.appendChild(document.createTextNode(" \u00A0 \u00A0 "));
  publicRadio = document.createElement("span");
  publicRadio.appendChild(postPublic);
  publicRadio.appendChild(document.createTextNode(" "));
  publicRadio.appendChild(postPublicLabel);
  publicRadio.appendChild(document.createTextNode(" "));
  div2.appendChild(publicRadio);
  div2.appendChild(postAnonymous);
  div2.appendChild(document.createTextNode(" "));
  div2.appendChild(postAnonymousLabel);

  signOn = document.createElement("span");
  signOn.style.display = "none";
  signOn.appendChild(document.createTextNode(l10n.or));
  signOnLink = document.createElement("a");
  signOnLink.href = "http://www.oracle.com/webapps/redirect/signon?nexturl=" +
    window.location.href;
  signOnLink.appendChild(document.createTextNode(l10n.sign_in));
  signOn.appendChild(signOnLink);
  signOn.appendChild(document.createTextNode(")"));
  div2.appendChild(signOn);

  if (user === "") {
    publicRadio.style.display = "none";
    signOn.style.display = "inline";
    postAnonymous.defaultChecked = true;
//    postAnonymous.disabled = true;
  } else {
    postPublic.defaultChecked = true;
  }

  userCommentsBodyLabel = document.createElement("label");
  userCommentsBodyLabel.htmlFor = "userCommentsBody";
  userCommentsBodyLabel.appendChild(document.createTextNode("Comment body:"));
  userCommentsBodyLabel.style.display = "none";

  userCommentsBody = document.createElement("textarea");
  userCommentsBody.id = "userCommentsBody";
  userCommentsBody.rows = "10";
  userCommentsBody.cols = "80";
  userCommentsBody.name = "comment_text";

  hidden = document.createElement("input");
  hidden.type = "hidden";
  hidden.name = "path";
  if (tAuthority === "tahiti-stage.us.oracle.com") {
    hidden.value = window.location.href;
  } else {
//    hidden.value = tPath;
    hidden.value = window.location.href;
  }

  topictitle = document.createElement("input");
  topictitle.type = "hidden";
  topictitle.name = "topictitle";
  topictitle.value = document.title;

  p = document.createElement("p");
  p.style.color = "#333";
  p.style.marginTop = "1ex";
  p.appendChild(document.createTextNode(l10n.comment_first_part));
  p.appendChild(document.createTextNode(" " + l10n.comment_second_part));
  a1 = document.createElement("a");
  /*
  if (document.getElementsByTagName("html")[0].getAttribute("xml:lang")) {
    lang = document.getElementsByTagName("html")[0].getAttribute("xml:lang");
    lang = "en";
  } else if (document.getElementsByTagName("html")[0].lang) {
    lang = document.getElementsByTagName("html")[0].lang;
    lang = "en";
  } else {
    lang = "en";
  }
  */
  if (tAuthority === "tahiti-stage.us.oracle.com") {
    a1.href = "http://wd0338.oracle.com/archive/cd_ns/E23003_01/html/" + "en" +
      "/comment_disclaimer.htm";
  } else {
    a1.href = "http://docs.oracle.com/cd/E23003_01/html/" + "en" +
      "/comment_disclaimer.htm";
  }
  a1.appendChild(document.createTextNode(l10n.comment_third_part));
  p.appendChild(a1);
  p.appendChild(document.createTextNode(l10n.comment_fourth_part));
  p.appendChild(document.createTextNode(l10n.comment_fifth_part));
  a2 = document.createElement("a");
  a2.href = "https://community.oracle.com/";
  a2.appendChild(document.createTextNode(l10n.comment_fifth_part_otn));
  p.appendChild(a2);
  p.appendChild(document.createTextNode(l10n.comment_sixth_part));
  p.appendChild(document.createTextNode(
    l10n.comment_seventh_part
  ));
  a3 = document.createElement("a");
  a3.href = "https://support.oracle.com/";
  a3.appendChild(document.createTextNode(l10n.comment_eighth_part));
  p.appendChild(a3);
  p.appendChild(document.createTextNode("."));

  submit = document.createElement("input");
  submit.type = "submit";
  submit.value = l10n.submit;
  submit.style.display = "block";

  fieldset = document.createElement("fieldset");
  fieldset.style.marginTop = "4ex";
  fieldset.style.borderTop = "1px #666 solid";
  fieldset.style.borderRight = "none";
  fieldset.style.borderBottom = "none";
  fieldset.style.borderLeft = "none";
  fieldset.appendChild(legend);
  fieldset.appendChild(hidden);
  fieldset.appendChild(topictitle);
  fieldset.appendChild(subject);
  fieldset.appendChild(div2);
  fieldset.appendChild(userCommentsBody);
  fieldset.appendChild(p);
  fieldset.appendChild(submit);

  commentForm = document.createElement("form");
  commentForm.method = "post";
  if (tAuthority === "tahiti-stage.us.oracle.com") {
    commentForm.action = "http://tahiti-stage.us.oracle.com/pls/tahiti/comments_test";
  } else {
    commentForm.action = "http://www.oracle.com/pls/tahiti/comments_test";
  }

  if (tSchema.match(/^db\d+/)) {
    p1 = document.createElement("p");
    p1.style.marginTop = "4ex";
    p1.style.padding = "0.5ex 0.5em";
    p1.style.backgroundColor = "#eef";
    p1.style.border = "1px solid #ccc";
    p1.appendChild(document.createTextNode(l10n.need_an_example + " "));
    a4 = document.createElement("a");
    a4.href = "http://www.surveygizmo.com/s3/1224783/Oracle-Documentation-Survey";
    a4.appendChild(document.createTextNode(l10n.tell_us_more));
    p1.appendChild(a4);
    p1.appendChild(document.createTextNode("."));
    commentForm.appendChild(p1);
  }

  commentForm.appendChild(fieldset);

  footer.parentNode.insertBefore(commentForm, footer);
}
addLoadEvent(showComments);



function processToc() {
  "use strict";

  var p, a, a1, a2, IND, img, preload, i = 0,
    iUrlStart = "../../nav/",
    h1 = document.getElementsByTagName("h1"),
    div = document.getElementsByTagName("div");

  if (!h1[0] || h1[0].className !== "toc") { return false; }

  preload = new Image();
  preload.src = iUrlStart + "images/blue_med_dark_down.gif";
  preload.alt = "Click to collapse";

  for (i = 0; i < div.length; i += 1) {
    if (div[i].className === "IND") { IND = div[i]; }
  }

  function nextUl(node) {
    while (node.nextSibling) {
      if (node.nextSibling.nodeName.match(/ul/i)) { return node.nextSibling; }
      node = node.nextSibling;
    }
  }

  function showNextUl(owner) {
    var ul = nextUl(owner.parentNode);
    ul.style.display = "block";
    owner.getElementsByTagName("img")[0].src =
      iUrlStart + "images/blue_med_dark_down.gif";
    owner.getElementsByTagName("img")[0].alt = "Click to collapse";
    owner.onclick = function () { hideNextUl(this); return false; };
  }

  function hideNextUl(owner) {
    var ul = nextUl(owner.parentNode);
    ul.style.display = "none";
    owner.getElementsByTagName("img")[0].src =
      iUrlStart + "images/blue_med_dark_side.gif";
    owner.getElementsByTagName("img")[0].alt = l10n.click_to_expand;
    owner.onclick = function () { showNextUl(this); return false; };
  }

  function expandAll() {
    var iea = 0, aea = IND.getElementsByTagName("a");
    for (iea = 0; iea < aea.length; iea += 1) {
      if (aea[iea].className === "tDiscTriangle") {
        showNextUl(aea[iea]);
      }
    }
    createCookie("ORA_TAHITI_TOC", "expand");
    return false;
  }

  function collapseAll() {
    var ica = 0, aca = IND.getElementsByTagName("a");
    for (ica = 0; ica < aca.length; ica += 1) {
      if (aca[ica].className === "tDiscTriangle") {
        hideNextUl(aca[ica]);
      }
    }
    createCookie("ORA_TAHITI_TOC", "", -1);
    return false;
  }

  function okShowTriangle(node) {
    while (node.nextSibling) {
      if (node.nextSibling.nodeName.match(/h2/i)) { return false; }
      if (node.nextSibling.nodeName.match(/ul/i)) { return true; }
      node = node.nextSibling;
    }
    return false;
  }

  function getTextContent(e) {
    if (e.textContent) { return e.textContent; }
    if (e.innerText) { return e.innerText; }
  }

  for (i = 0; i < IND.childNodes.length; i += 1) {
    if (IND.childNodes[i].nodeName.match(/^ul$/i)) {
      IND.childNodes[i].style.marginTop = "0";
      IND.childNodes[i].style.marginBottom = "1ex";
      IND.childNodes[i].style.display = "none";
    } else if (IND.childNodes[i].nodeName.match(/^h2$/i)) {
      if (IND.childNodes[i].className === "tocheader") {
        IND.childNodes[i].style.fontSize = "140%";
        IND.childNodes[i].style.marginTop = "0";
        IND.childNodes[i].style.marginBottom = "0.5ex";
        if (getTextContent(IND.childNodes[i]) &&
            getTextContent(IND.childNodes[i]).match(/Part\s+[IVXLCDM]+\s+/)) {
          IND.childNodes[i].style.textAlign = "center";
          IND.childNodes[i].style.marginTop = "1.7ex";
          IND.childNodes[i].style.borderTop = "2px solid #A4C3DF";
        } else {
          img = document.createElement("img");
          img.src = iUrlStart + "images/blue_med_dark_side.gif";
          img.alt = "Click to expand";
          a = document.createElement("a");
          a.href = "#";
          a.onclick = function () { showNextUl(this); return false; };
          a.onfocus = function () { window.status = ''; return true; };
          a.className = "tDiscTriangle";
          a.style.textDecoration = "none";
          a.appendChild(img);
          if (okShowTriangle(IND.childNodes[i])) {
            IND.childNodes[i].insertBefore(document.createTextNode(" "),
              IND.childNodes[i].firstChild);
            IND.childNodes[i].insertBefore(a, IND.childNodes[i].firstChild);
          }
        }
      }
    }
  }

  p = document.createElement("p");
  p.style.marginTop = "0";
  p.style.marginBottom = "0";
  p.style.textAlign = "right";
  a1 = document.createElement("a");
  a1.href = "#";
  a1.onfocus = function () { window.status = ''; return true; };
  a1.style.color = "#039";
  a1.style.textDecoration = "none";
  a1.onclick = expandAll;
  a2 = document.createElement("a");
  a2.href = "#";
  a2.onfocus = function () { window.status = ''; return true; };
  a2.style.color = "#039";
  a2.style.textDecoration = "none";
  a2.onclick = collapseAll;
  a1.appendChild(document.createTextNode(l10n.expand_all));
  a2.appendChild(document.createTextNode(l10n.collapse_all));
  p.appendChild(a1);
  p.appendChild(document.createTextNode(" \u00B7 "));
  p.appendChild(a2);
  document.getElementsByTagName("h1")[0].style.marginBottom = "0";
  document.getElementsByTagName("h1")[0].parentNode.insertBefore(p,
    document.getElementsByTagName("h1")[0].nextSibling);

  if (readCookie("ORA_TAHITI_TOC") === "expand") { expandAll(); }
}
addLoadEvent(processToc);

function processIndex() {
  "use strict";
  try {
    if (!window.location.href.match(/\/index\.htm(?:|#[\x20-\x7E]*)$/)) {
      return false;
    }
  } catch (ignore) {}

  var prefix, s, nav, i = 0, shortcut = [], lastPrefix = "",
    dd = document.getElementsByTagName("dd"),
    h2 = document.getElementsByTagName("h2");

  function getTextContent(e) {
    if (e.textContent) { return e.textContent; }
    if (e.innerText) { return e.innerText; }
  }

  for (i = 0; i < dd.length; i += 1) {
    if (dd[i].className === 'l1ix') {
      prefix = getTextContent(dd[i]).substring(0, 2).toUpperCase();
      if (prefix.match(/^([A-Z0-9]{2})/) && prefix !== lastPrefix) {
        dd[i].id = prefix;
        s = document.createElement("a");
        s.href = "#" + prefix;
        s.appendChild(document.createTextNode(prefix));
        shortcut.push(s);
        lastPrefix = prefix;
      }
    }
  }

  for (i = 0; i < h2.length; i += 1) {
    nav = document.createElement("div");
    nav.style.position = "relative";
    nav.style.top = "-1.5ex";
    nav.style.left = "1.5em";
    nav.style.width = "90%";
    while (shortcut[0] &&
        shortcut[0].toString().charAt(shortcut[0].toString().length - 2) ===
        getTextContent(h2[i])) {
      nav.appendChild(shortcut.shift());
      nav.appendChild(document.createTextNode("\u00A0 "));
    }
    h2[i].parentNode.insertBefore(nav, h2[i].nextSibling);
  }
}
addLoadEvent(processIndex);

function createSupNoteLinks() {
  "use strict";
  if (!document.createElement) { return false; }
  if (!document.createTextNode) { return false; }
  if (!document.documentElement.replaceChild) { return false; }
  var find = /\b(\d{6,7}[.]\d)\b/gi;
  function replaceInText(text, find, replace) {
    var match, i = 0, matches = [];
    while ((match = find.exec(text.data)) !== null) {
      matches.push(match);
    }
    for (i = matches.length - 1; i >= 0; i -= 1) {
      match = matches[i];
      text.splitText(match.index);
      text.nextSibling.splitText(match[0].length);
      text.parentNode.replaceChild(replace(match), text.nextSibling);
    }
  }

  function replaceInElement(element, find, replace) {
    var i = 0;
    for (i = element.childNodes.length - 1; i >= 0; i -= 1) {
      if (element.childNodes[i].nodeType === 1) {
        if (!element.childNodes[i].nodeName.match(/^(?:style|script|h1)$/i) &&
            !(element.childNodes[i].nodeName.match(/^a$/i))) {
          replaceInElement(element.childNodes[i], find, replace);
        }
      } else if (element.childNodes[i].nodeType === 3) {
        replaceInText(element.childNodes[i], find, replace);
      }
    }
  }

  replaceInElement(document.body, find, function (match) {
    var link = document.createElement("a");
    link.href =
      "http://support.oracle.com/epmos/faces/DocumentDisplay?id=" + match[0];
    link.appendChild(document.createTextNode(match[0]));
    return link;
  });
}
addLoadEvent(createSupNoteLinks);

function compactLists() {
  "use strict";
  var li, p, i = 0, j = 0, k = 0, collapsible = true, lists = [], clists = [],
    ul = document.getElementsByTagName("ul"),
    ol = document.getElementsByTagName("ol");

  for (i = 0; i < ul.length; i += 1) { lists.push(ul[i]); }
  for (i = 0; i < ol.length; i += 1) { lists.push(ol[i]); }

  function getTextContent(e) {
    if (e.textContent) { return e.textContent; }
    if (e.innerText) { return e.innerText; }
  }

  for (i = 0; i < lists.length; i += 1) {
    collapsible = true;
    clists = [];
    li = lists[i].getElementsByTagName("li");
    for (j = 0; j < li.length; j += 1) {
      p = li[j].getElementsByTagName("p");
      if (p.length > 1) { collapsible = false; }
      for (k = 0; k < p.length; k += 1) {
        if (getTextContent(p[k]).split(" ").length > 12) {
          collapsible = false;
        }
        clists.push(p[k]);
      }
    }
    if (collapsible) {
      for (j = 0; j < clists.length; j += 1) {
        clists[j].style.margin = "0";
      }
    }
  }
}
addLoadEvent(compactLists);

function deviceWidth() {
  "use strict";
  if (!document.head) { return false; }
  var meta = document.createElement("meta");
  meta.name = "viewport";
  meta.content = "width=device-width,initial-scale=1.0";
  document.head.appendChild(meta);
}
addLoadEvent(deviceWidth);

function positionAnchor() {
  "use strict";
  if (!window.ActiveXObject || window.opera) { return false; }

  var a, i = 0, location = [], anchor = "";

  try {
    if (window.location.href.match(/#([\x20-\x7E]+)$/)) { anchor = RegExp.$1; }
  } catch (e) {
    return;
  }

  function findPos(obj) {
    var curleft = 0, curtop = 0;
    if (obj.offsetParent) {
      do {
        curleft += obj.offsetLeft;
        curtop += obj.offsetTop;
      } while (obj = obj.offsetParent);
    }
    return [curleft, curtop];
  }

  if (document.getElementById(anchor)) {
    location = findPos(document.getElementById(anchor));
    window.scrollTo(0, location[1]);
  } else {
    a = document.getElementsByTagName("a");
    for (i = 0; i < anchor.length; i += 1) {
      if (a[i].className === anchor) {
        location = findPos(a[i]);
        window.scrollTo(0, location[1]);
      }
    }
  }
}
addLoadEvent(positionAnchor);

function initializeHighlighter() {
  "use strict";
  window.lastVisibleId = '';
  window.lastVisibleElement = null;
  window.headingsToWorkOn = [];
  window.listsToWorkOn = [];
  window.listsValuesToWorkOn = [];
  window.onlyAnchors = [];
  window.parentsForHighlight = {};
  window.headingsRead = 0;
  window.listsRead = 0;
  window.maxSizeNoScroll = 30;
  window.lastVisitedElement = -1;
  window.highlightElement = false;
  window.PageLocationForElem = null;
  window.isAutoIDcase = false;
  window.whereami = window.location.href;
  window.whereami = window.whereami.replace(new RegExp("(.*)/"), "");
  window.pageName = window.whereami.replace(new RegExp("#(.*)"), "");
  window.pageName = window.pageName.replace(new RegExp("\\?(.*)"), "");
}
addLoadEvent(initializeHighlighter);

var resizeTimerId = null;
function doHighlight() {
  "use strict";
  if (resizeTimerId) {
    clearTimeout(resizeTimerId);
    resizeTimerId = null;
  }
  resizeTimerId = setTimeout(function () {
    highlighter();
  }, 200);
}

window.onscroll = doHighlight;

function highlighter() {
  "use strict";
  if (window.location.href.match(/#BEGIN$/)) {return; }
  var allVisible = [], allBoundariesVisible = [], checkCompleteWithId,
    isVisibleStarted = false, elementNumber, foundWhichIsVisible = false,
    testPresence, visibileElemInBoundary, isVisibleElem, readornot, checkValid, checkValidVIsible, wasValidFound, hIter, checkOnlyId;

  function unhighlight(elem) {
    if (!elem) {
      return true;
    }
    if ((window.ActiveXObject && !window.opera) && !window.XMLHttpRequest) {
      elem.style.setAttribute('cssText', "font-weight:normal;");
      elem.style.fontWeight = 'normal';
    } else {
      //elem.setAttribute('style', "font-weight:normal;");
      elem.style.fontWeight = 'normal';
    }
    return true;
  }

  function highlight(elem) {
    // Highlight the element itself first
    if (!elem) {
      return true;
    }
    if ((window.ActiveXObject && !window.opera) && !window.XMLHttpRequest) {
      elem.style.setAttribute('cssText', "font-weight:bold;");
      elem.style.fontWeight = 'bold';
    } else {
      elem.style.fontWeight = 'bold';
      //elem.setAttribute('style', "font-weight:bold;");
    }
    return true;
  }

  function manageAddressBarURL(elem) {
    if (elem && elem.href && (!window.PageLocationForElem || window.PageLocationForElem !== elem.href)) {
      window.PageLocationForElem = elem.href;
      window.PageLocationForElem = window.PageLocationForElem.replace(new RegExp("(.*)#"), '');
      var browserVal = navigator.userAgent.toLowerCase(), verticalScroll = document.body.scrollTop, horizontalScroll = document.body.scrollLeft;
      window.PageLocationForElem = '#' + window.PageLocationForElem;
      if (!window.PageLocationForElem.match(/^autoId/)) {
        // both are defined and it is not a auto generated id
        if (history.replaceState) {
          history.replaceState({"page": "Oracle Document"}, "Replace previous URL", window.PageLocationForElem);
        } else {
          //if (browserVal.indexOf("msie") > -1) {/* Nothing to set now */} 
          //else if (browserVal.indexOf("firefox") > -1) {/* Nothing to set now */} 
          if (browserVal.indexOf("chrome") > -1) {
            window.location.hash = window.PageLocationForElem;
            document.body.scrollTop = verticalScroll;
            document.body.scrollLeft = horizontalScroll;
          } else if (browserVal.indexOf("safari") > -1) {
            window.location.hash = window.PageLocationForElem;
            document.body.scrollTop = verticalScroll;
            document.body.scrollLeft = horizontalScroll;
          } else if (browserVal.indexOf("opera") > -1) {
            window.location.hash = window.PageLocationForElem;
            document.body.scrollTop = verticalScroll;
            document.body.scrollLeft = horizontalScroll;
          }
        }
      }
    }
    return true;
  }

  function getParents(e) {
    var linkedList = [], startParent, subE;
    if (e.nodeType === 1 && (e.nodeName.match(/a/i))) {
      startParent = e.parentNode.parentNode.parentNode;
      while ((startParent.nodeName.match(/li/i))) {
        subE = startParent.childNodes;
        if (subE.length > 0) {
          if (subE[0].nodeName.match(/a/i) && !subE[0].href.match(/#$/) && !subE[0].innerHTML.match(new RegExp("(.*) <img", 'g').ignoreCase)) {
            // Case of addthispage
            linkedList.push(subE[0]);
            startParent = subE[0].parentNode.parentNode.parentNode;
          } else if (subE.length > 0 && subE[1].nodeName.match(/a/i) && !subE[1].href.match(/#$/) && !subE[1].innerHTML.match(new RegExp("(.*) <img", 'g').ignoreCase)) {
            // Case of addthisdocument
            linkedList.push(subE[1]);
            startParent = subE[1].parentNode.parentNode.parentNode;
          } else {
            startParent = subE[0].parentNode.parentNode.parentNode;
          }
        } else {
          break;
        }
      }
    }
    return linkedList;
  }

  function highlightParents(elem) {
    var parentsArray, allParents, p;
    if (!elem) {
      return true;
    }
    if (!window.parentsForHighlight[elem.href]) {
      parentsArray = getParents(elem);
      if (parentsArray.length > 0) {
        window.parentsForHighlight[elem.href] = parentsArray;
      }
    }
    if (window.parentsForHighlight[elem.href]) {
      allParents = window.parentsForHighlight[elem.href];
      for (p = 0; p < allParents.length; p = p + 1) {
        if ((window.ActiveXObject && !window.opera) && !window.XMLHttpRequest) {
          allParents[p].style.setAttribute('cssText', "font-weight:bold;");
          allParents[p].style.fontWeight = 'bold';
        } else {
          allParents[p].setAttribute('style', "font-weight:bold;");
          allParents[p].style.fontWeight = 'bold';
        }
      }
    }
    return true;
  }

  function readHeadings(e) {
    if (window.headingsRead > 0) {
      return true;
    }
    window.headingsToWorkOn = [];
    var checkAllTags = e.getElementsByTagName('*'), checkAllTagsIter;
    checkAllTags = document.getElementsByTagName('*');
    for (checkAllTagsIter = 1; checkAllTagsIter < checkAllTags.length; checkAllTagsIter = checkAllTagsIter + 1) {
      if (checkAllTags[checkAllTagsIter].id && checkAllTags[checkAllTagsIter].id !== 'tThisPage'
            && checkAllTags[checkAllTagsIter].id !== 'tThisDocument') {
        if (window.isAutoIDcase && checkAllTags[checkAllTagsIter].id.match(/^autoId/) && checkAllTags[checkAllTagsIter].nodeName.match(/h[2-4]/i)) {
          window.headingsToWorkOn.push(checkAllTags[checkAllTagsIter]);
        } else if (!window.isAutoIDcase && window.onlyAnchors.indexOf(checkAllTags[checkAllTagsIter].id) > -1) {
          window.headingsToWorkOn.push(checkAllTags[checkAllTagsIter]);
        }
      }
    }
    return true;
  }

  function readLists(e) {
    if (window.listsRead > 0) {return true; }
    var allaelements, regex1, anc, allaelementsIter;
    window.listsToWorkOn = [];
    window.listsValuesToWorkOn = [];
    allaelements = e;
    if (document.getElementById('tThisPage')) {
      window.isAutoIDcase = true;
      // get all a elements
      window.highlightElement = true;
      allaelements = document.getElementById('tThisPage').getElementsByTagName("a");
      for (allaelementsIter = 0; allaelementsIter < allaelements.length; allaelementsIter += 1) {
        if (allaelements[allaelementsIter].href) {
          window.listsToWorkOn.push(allaelements[allaelementsIter]);
          window.listsValuesToWorkOn.push(allaelements[allaelementsIter].href.replace(new RegExp("(.*)/"), ""));
        }
      }
    } else if (document.getElementById('tThisDocument')) {
      // get all a elements
      window.highlightElement = true;
      allaelements = document.getElementById('tThisDocument').getElementsByTagName("a");
      for (allaelementsIter = 0; allaelementsIter < allaelements.length; allaelementsIter += 1) {
        if (allaelements[allaelementsIter].href && !allaelements[allaelementsIter].href.match(/#$/)) {
          regex1 = new RegExp('(.*)' + window.pageName + '(.*)', 'g');
          if (allaelements[allaelementsIter].href.match(regex1)) {
            anc = allaelements[allaelementsIter].href;
            anc = anc.replace(new RegExp("(.*)#"), "");
            if (window.onlyAnchors.indexOf(anc) < 0) {
              window.onlyAnchors.push(anc);
            }
            window.listsToWorkOn.push(allaelements[allaelementsIter]);
            window.listsValuesToWorkOn.push(allaelements[allaelementsIter].href.replace(new RegExp("(.*)/"), ""));
          }
        }
      }
    }
    return true;
  }

  function windowHeight() {
    // determine viewable height
    var elem = document.documentElement;
    if (!!window.innerWidth) { return window.innerHeight; }
    if (elem && !isNaN(elem.clientHeight)) { return elem.clientHeight; }
    return 0;
  }

  function windowWidth() {
    // determine viewable width
    var elem = document.documentElement;
    if (!isNaN(window.innerWidth)) { return window.innerWidth; }
    if (elem && !isNaN(elem.clientWidth)) { return elem.clientWidth; }
    return 0;
  }

  function vertical() {
    if (window.pageYOffset) { return window.pageYOffset; }
    return Math.max(document.documentElement.scrollTop, document.body.scrollTop);
  }

  function horizontal() {
    if (window.pageXOffset) { return window.pageXOffset; }
    return Math.max(document.documentElement.scrollLeft, document.body.scrollLeft);
  }

  function isElementVisible(element) {
    var width, top, left, windowInnerHeight, windowInnerWidth, windowYoffset, windowXoffset;
    width = element.offsetWidth;
    top = element.offsetTop;
    left = element.offsetLeft;
    while (element.offsetParent) {
      element = element.offsetParent;
      top += element.offsetTop;
      left += element.offsetLeft;
    }
    windowInnerHeight = windowHeight();
    windowInnerWidth = windowWidth();
    windowYoffset = vertical();
    windowXoffset = horizontal();
    return (
      (top + 5) > windowYoffset &&
      (width + left) > windowXoffset &&
      top < (windowInnerHeight + windowYoffset) &&
      left < (windowXoffset + windowInnerWidth)
    );
  }

  function isElementBoundaryVisible(element) {
    var width, top, left, windowInnerHeight, windowInnerWidth, windowYoffset, windowXoffset;
    width = element.offsetWidth;
    top = element.offsetTop;
    left = element.offsetLeft;
    while (element.offsetParent) {
      element = element.offsetParent;
      top += element.offsetTop;
      left += element.offsetLeft;
    }
    windowInnerHeight = windowHeight();
    windowInnerWidth = windowWidth();
    windowYoffset = vertical();
    windowXoffset = horizontal();
    return (
      top < windowYoffset &&
      (width + left) > windowXoffset &&
      top < (windowInnerHeight + windowYoffset) &&
      left < (windowXoffset + windowInnerWidth)
    );
  }

  function checkExistence(elem) {
    var checkOnlyIdVal, regex1, regex2, foundWhichIsVisibleH, elementNumberH;
    checkOnlyIdVal = elem.id;
    checkCompleteWithId = window.pageName + '#' + elem.id;
    regex1 = new RegExp(checkOnlyIdVal + '$', 'g');
    regex2 = new RegExp(checkCompleteWithId + '$', 'g');
    foundWhichIsVisibleH = false;
    elementNumberH = -1;
    for (hIter = 0; hIter < window.listsToWorkOn.length; hIter += 1) {
      if ((window.listsToWorkOn[hIter].href.match(regex1) || window.listsToWorkOn[hIter].href.match(regex2))) {
        foundWhichIsVisibleH = true;
        elementNumberH = hIter;
        break;
      }
      if (foundWhichIsVisibleH) {break; }
    }
    return elementNumberH;
  }

  readornot = readLists(document.documentElement);
  if (readornot && window.highlightElement) {window.listsRead = 1; }
  readornot = readHeadings(document.documentElement);
  if (readornot && window.highlightElement) {window.headingsRead = 1; }
  if (window.pageName.match(/index[.]htm/)) {
    return true;
  }
  for (hIter = 0; hIter < window.headingsToWorkOn.length; hIter += 1) {
    if (!window.headingsToWorkOn[hIter].id.match(/^BEGIN$/)) {
      isVisibleElem = isElementVisible(window.headingsToWorkOn[hIter]);
      if (isVisibleElem) {
        isVisibleStarted = true;
        allVisible.push(window.headingsToWorkOn[hIter]);
      }
      // if the elements are found as visible, we need to look till the elements stop being visible.
      if (isVisibleStarted && !isVisibleElem) {
        break;
      }
    }
  }
  // check if the user clicked something which cannot be highlighted as it was last that cannot be scrolled to
  // If more than one heading is visible, highlight the first one.
  // check what is applicable id from the li's a element list
  // where are we?
  if (!Array.prototype.indexOf) {
    for (checkValid = 0; checkValid < allVisible.length; checkValid = checkValid + 1) {
      foundWhichIsVisible = false;
      elementNumber = checkExistence(allVisible[checkValid]);
      if (elementNumber > -1) {
        window.lastVisibleElement = window.listsToWorkOn[elementNumber];
        window.lastVisibleId = window.listsToWorkOn[elementNumber].id;
        window.lastVisitedElement = elementNumber;
        foundWhichIsVisible = highlight(window.listsToWorkOn[elementNumber]);
      }
      if (foundWhichIsVisible) {break; }
    }
  } else {
    for (checkValid = 0; checkValid < allVisible.length; checkValid = checkValid + 1) {
      checkOnlyId = allVisible[checkValid].id;
      checkCompleteWithId = window.pageName + '#' + allVisible[checkValid].id;
      foundWhichIsVisible = false;
      testPresence = window.listsValuesToWorkOn.indexOf(checkCompleteWithId);
      if (testPresence > -1) {
        window.lastVisibleElement = window.listsToWorkOn[testPresence];
        window.lastVisibleId = window.listsToWorkOn[testPresence].id;
        window.lastVisitedElement = testPresence;
        foundWhichIsVisible = highlight(window.listsToWorkOn[testPresence]);
      } else {
        testPresence = window.listsValuesToWorkOn.indexOf(checkOnlyId);
        if (testPresence > -1) {
          window.lastVisibleElement = window.listsToWorkOn[testPresence];
          window.lastVisibleId = window.listsToWorkOn[testPresence].id;
          window.lastVisitedElement = testPresence;
          foundWhichIsVisible = highlight(window.listsToWorkOn[testPresence]);
        }
      }
      if (foundWhichIsVisible) {
        break;
      }
    }
  }
  if (!foundWhichIsVisible) {
    isVisibleStarted = false;
    for (hIter = 0; hIter < window.headingsToWorkOn.length; hIter += 1) {
      // allBoundariesVisible will store the actual elements that are visible and compared with the complete boundary.
      // This will help to identify cases when the section is long and user is scrolling and we need to identify
      // the start of the element from the bottom of the element or from top. From this array we will take the deepest element.
      isVisibleElem = isElementBoundaryVisible(window.headingsToWorkOn[hIter]);
      if (isVisibleElem) {
        isVisibleStarted = true;
        allBoundariesVisible.push(window.headingsToWorkOn[hIter]);
      }
      // if the elements are found as visible, we need to look till the elements stop being visible.
      if (isVisibleStarted && !isVisibleElem) {
        break;
      }
    }
    if (allBoundariesVisible.length > 0) {
      if (window.isAutoIDcase) {
        // addthispage
        for (checkValidVIsible = allBoundariesVisible.length - 1; checkValidVIsible > -1; checkValidVIsible = checkValidVIsible - 1) {
          if (allBoundariesVisible[checkValidVIsible].id.match(/autoId/)) {visibileElemInBoundary = allBoundariesVisible[checkValidVIsible]; break; }
        }
      } else {
          // addthisdocument
        for (checkValidVIsible = allBoundariesVisible.length - 1; checkValidVIsible > -1; checkValidVIsible = checkValidVIsible - 1) {
          wasValidFound = false;
          elementNumber = checkExistence(allBoundariesVisible[checkValidVIsible]);
          if (elementNumber > -1) {
            visibileElemInBoundary = allBoundariesVisible[checkValidVIsible];
            wasValidFound = true;
          }
          if (wasValidFound) {break; }
        }
      }
      if (!visibileElemInBoundary) {
        visibileElemInBoundary = allBoundariesVisible[allBoundariesVisible.length - 1];
      }
      elementNumber = checkExistence(visibileElemInBoundary);
      if (elementNumber > -1) {
        window.lastVisibleElement = window.listsToWorkOn[elementNumber];
        window.lastVisibleId = window.listsToWorkOn[elementNumber].id;
        window.lastVisitedElement = elementNumber;
        foundWhichIsVisible = highlight(window.listsToWorkOn[elementNumber]);
      }
      foundWhichIsVisible = highlight(window.listsToWorkOn[window.lastVisitedElement]);
    }
  }
  // May be the top of the page
  if (!foundWhichIsVisible) {
    unhighlight(window.lastVisibleElement);
  }
  // "Un"highlight all the did not match
  for (hIter = 0; hIter < window.listsToWorkOn.length; hIter += 1) {
    if (window.lastVisibleElement && window.listsToWorkOn[hIter].href !== window.lastVisibleElement.href) {
      unhighlight(window.listsToWorkOn[hIter]);
    }
  }
  // Highlight the parents
  highlightParents(window.lastVisibleElement);
  // change the browser URL if possible to the ID user is visiting.
  manageAddressBarURL(window.lastVisibleElement);
  return true;
}
