# [dcommon]

- [Overview](#Common web resources - images, js, css)
- [Setting Up a Development Environment](#setting-up-a-development-environment)
- [How to Test](#how-to-test)
- [How to Release](#how-to-release)

## Overview

Common web resources (images, js, css) used in OHC search and published to Stage and Prod via Website Publishing App.

### Important Links
|Type|URL|
|----|---|
|DocEng Sample Project: ALM/Git         |<https://alm.oraclecorp.com/doceng/#projects/dcommon/scm/dcommon.git/tree?revision=master>
#### Projects This Project Depends On
* [dcommon]


#### Projects That Depend On This Project
* [OHC Search]
* [Website Publishing]

####  Project Contacts
* Manager: [divya.venkataraman@oracle.com]
* Developer Lead: [shilendra.mahan@oracle.com.]
* Developer: [harshitha.salian@oracle.com]
* dcommon Release: [haribabu.balagani@oracle.com]
* Other Stakeholders: [shekar.j@oracle.com]

#### Setting Up a Development Environment

[Changes cannot be tested locally]

### how-to-test
1. UI changes to be tested in dev and other environments by directly accessing the file where the changes has been applied.

### how-to-release
1.  docs-uat-int 
	Feature branch to be created from uat-dev and MR to be raised to be merged to uat-dev branch.
	Login to docs-uat.us.oracle.com and go /tmp/dcommon_test/dcommon and run the following commands:
	git checkout uat-dev
	git pull
	Login to docs-uat-int.us.oracle.com using docsfpub account - ssh docsfpub@docs-uat-int.us.oracle.com and do the following:
	cd /scratch/doceng/svc/tomcat/webapps/ROOT/en/dcommon/
	NOTE: Your folders will differ slightly if you are not updating the search feature
	For global.js the folder location is /scratch/web/en/dcommon/js
	Enter the following command, using your global user ID instead of divvenka. E.g. mlindros. Do not forget the . on the end of the command. That is not a typo.
	sudo scp -r divvenka@docs-uat.us.oracle.com:/tmp/dcommon_test/dcommon/search .
2.  docs-uat
	Create a feature branch from uat branch
	Create MR from feature branch to merge with uat branch.
	Once merged, the GIT webhook will automatically update the dcommon in docs-uat/en/dcommon location.
	If the files did not get updated, then manually run
	http://jenkins-pdb.doceng-oci.oraclecorp.com/job/dcommon-uat/ [http://hudsonci.oraclecorp.com/hudson/doceng/job/dcommon-uat/] job for update dcommon in docs-uat/en/dcommon location.
3.  docs-uat-dev
	Create feature branch based out of dcommon-uat branch to perform the testing of changes in dev
	Login to docs-uat.us.oracle.com and go /tmp/dcommon_test/dcommon and run the following commands:
	git checkout feature/<BRANCHNAME>
	git pull
	Login to docs-uat-dev.us.oracle.com using docsfpub account - ssh docsfpub@docs-uat-dev.us.oracle.com and do the following:
	cd /scratch/doceng/svc/tomcat/webapps/ROOT/en/dcommon/
	NOTE: Your folders will differ slightly if you are not updating the search feature.
	For global.js the folder location is /scratch/web/en/dcommon/js
	Enter the following command, using your global user ID instead of divvenka. E.g. mlindros. Do not forget the . on the end of the command. That is not a typo.
	sudo scp -r divvenka@docs-uat.us.oracle.com:/tmp/dcommon_test/dcommon/search .
4.  docs-stage
	Create a feature branch from master branch
	Create MR from feature branch to merge with master branch.
	Once merged, the GIT webhook will automatically update the dcommon in docs-uat1/en/dcommon location.
	If the files did not get updated, then manually run http://jenkins-pdb.doceng-oci.oraclecorp.com/job/dcommon-master/ [http://hudsonci.oraclecorp.com/hudson/doceng/job/dcommon-master/] job for update dcommon in docs-uat1/en/dcommon location.
	After the changes are reflecting in docs-uat1, use PDB's website publishing (http://pdb.us.oracle.com/stage.jsp?top=en&Select=Start), select dcommon option alone and initiate the archiving process and wait until staging completes
5.	docs
	Click the final Archive button in the website publishing process started in the previous staging step.
6.  aplg branch of dcommon goes to http://pdb-stage.us.oracle.com/library/dcommon/ used in APLG library build.
### Release Management Wiki
DocEng provides documentation for release management of DocEng components:
```http
https://confluence.oraclecorp.com/confluence/pages/viewpage.action?pageId=1693947726
```

## To run the application as Docker

|This application doesn't have docker file|