<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html"></xsl:output>
<xsl:template match="/">
<html>
<head>
<title>Table of Contents</title>
<link rel="stylesheet" type="text/css" href="xmlTree.css"/>
<script type="text/javascript" src="xmlTree.js"></script>
</head>
<xsl:apply-templates/>
</html>
</xsl:template>

<xsl:template match="tree">
<body bgcolor="#ffffff">
<xsl:apply-templates/>
</body>
</xsl:template>

<xsl:template match="title">
<h1><xsl:value-of select="."/></h1>
</xsl:template>

<xsl:template match="branch">
	<span class="trigger">
	<xsl:attribute name="onClick">
	showBranch('<xsl:value-of select="@id"/>');
	</xsl:attribute>
	<img src="closed3.gif">
	<xsl:attribute name="id">I<xsl:value-of select="@id"/></xsl:attribute>
	</img>
	<xsl:apply-templates select="branchText" /> 
	<br/>
	</span>
	  
	<span class="branch">
	<xsl:attribute name="id">
	<xsl:value-of select="@id"/>
	</xsl:attribute>
	<xsl:apply-templates select="leaf|branch"/>
	</span>
  
</xsl:template>


<xsl:template match="leaf">
	-
	<a target="content">
	<xsl:attribute name="href" >
	<xsl:value-of select="link"/>
	</xsl:attribute>
	<xsl:attribute name="class" >
	leaf
	</xsl:attribute>
	<xsl:value-of select="leafText"/>
	</a>
	<br/>
</xsl:template>

<!-- Make a href out of the branchText node -->
<xsl:template match="branchText">
  <a target="content">
  <xsl:attribute name="href" >
  <xsl:value-of select="@link"/>
  </xsl:attribute>
  <xsl:attribute name="class" >
  leaf
  </xsl:attribute>
  <xsl:value-of select="."/>
  </a>
</xsl:template>

</xsl:stylesheet>
