<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text" indent="yes"/>
	<xsl:template match="TutorialPage">
<xsl:variable name="currTopic"><xsl:value-of select="@topicInt"/></xsl:variable>
		<xsl:text><![CDATA[
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">

<html>
<head>
	<title>]]></xsl:text><xsl:value-of select="Topic"/><xsl:text><![CDATA[</title>
	<link rel="stylesheet" type="text/css" href="../../master.css">		
<script language="JavaScript" src="../../strings.js"></script><script language="JavaScript" src="]]></xsl:text><xsl:value-of select="@baseDir"/><xsl:text><![CDATA[/tutorial/engine/actions.js"></script>
<script language="JavaScript" src="]]></xsl:text><xsl:value-of select="@baseDir"/><xsl:text><![CDATA[/tutorial/engine/actions3.js"></script>

<script language="JavaScript">
topicInt="]]></xsl:text><xsl:value-of select="$currTopic"/><xsl:text><![CDATA[";
titleString = "]]></xsl:text><xsl:value-of select="Topic"/><xsl:text><![CDATA[";
totalPagesThisTopic = "]]></xsl:text><xsl:value-of select="@totalThisLesson"/><xsl:text><![CDATA[";

// ************* do not edit the scripts below this line  *****************************/
var imgFilePath = "graphics/"+pageName+"_01.png";
preload(imgFilePath);
var str = pageName.split("_");
topicName = str[0];
thisTopicNumber = str[1];
setLocInfo(topicName,thisTopicNumber,totalPagesThisTopic);

function init() { 
  hide('loading'); 
  paint('dropShadow','screen','background','steps');
  swapBullet('01');
}
</script> 
</head>

<body onLoad="init();window.focus()">

<!-- the following block contains the text and icon links for steps in the page -->
<div id="steps" class="stepsMenu">
<!-- Do not edit table tags-->
<table width= "260">

<TR><td width="1%">&nbsp;</td><td width="98%" class="stepsMenuText">]]></xsl:text><xsl:value-of select="child::Intro"/><xsl:text><![CDATA[<br></td><td width="1%">&nbsp;</td></TR>]]></xsl:text>
<xsl:if test="child::Intro/child::*[name()='link']"><xsl:for-each select="child::Intro/child::*[name()='link']"><xsl:text><![CDATA[<tr><td width="1%">&nbsp;</td><td width="98%" class="stepsMenuText">]]></xsl:text><xsl:call-template name="linkTempl"/><xsl:text><![CDATA[</td><td width="1%">&nbsp;</td></tr>]]></xsl:text></xsl:for-each></xsl:if>
<xsl:text><![CDATA[
</table>

<!-- Do not edit table tags-->
<table width= "260">

]]></xsl:text>
	<xsl:for-each select="Text">
		<xsl:variable name="stepNum"><xsl:value-of select="@stepNum"/></xsl:variable>
<xsl:text><![CDATA[
<!-- the next block [<TR> to </TR>] creates a complete step. -->
<TR valign="top">
<td width="2%">&nbsp;</td>
<td width="15%"><A href="javascript:swapBullet(']]></xsl:text><xsl:value-of select="$stepNum"/><xsl:text><![CDATA[')"><img src="../../../../base/tutorial/images/bullet_unselected.gif" border="0" id="stepNum]]></xsl:text><xsl:value-of select="$stepNum"/><xsl:text><![CDATA[" name="stepNum]]></xsl:text><xsl:value-of select="$stepNum"/><xsl:text><![CDATA["></A></td><td class="stepsMenuText" width="80%"><A href="javascript:swapBullet(']]></xsl:text><xsl:value-of select="$stepNum"/><xsl:text><![CDATA[')">]]></xsl:text><xsl:value-of select="text()"/><xsl:text><![CDATA[</A><br>]]></xsl:text><xsl:for-each select="descendant-or-self::*[name()='link']"><xsl:call-template name="linkTempl"/></xsl:for-each>
<xsl:text><![CDATA[</td>
<!-- the next line is a spacer. Do not edit -->
<td width="3%">&nbsp;</td></TR>]]></xsl:text>

</xsl:for-each>
	
<xsl:text><![CDATA[
</table>
</div>


<div id="loading" class="loading">&nbsp;Loading&nbsp;<img src="../../../../base/tutorial/images/loading.gif" width=80 height=17 border=0 align="middle" alt="loading...">&nbsp;</div>


<div id="background" class="background"><img src="../../../../base/tutorial/images/background.gif" width=700 height=615 border=0 align="middle"></div>

<div id="screen" class="screenShot"><img src="../../../../base/tutorial/images/clear.gif" width="436" height="378" border ="0" id="scrn" name="scrn"></div>

<div id = "dropShadow" class="dropS"><img src="../../../../base/tutorial/images/drop_shadow_small.gif" width="700" height="413"></div>
<script language="JavaScript">document.write(getLocInfo());</script>
</body>
</html>]]></xsl:text>
	</xsl:template>
	
		<xsl:template name="linkTempl">
		<xsl:variable name="destination"><xsl:choose>
			<xsl:when test="@newWindow='true'"><xsl:choose><xsl:when test="@winH"><xsl:text><![CDATA[href="#" onclick="javascript:window.open(']]></xsl:text><xsl:value-of select="@url"/><xsl:text><![CDATA[','','toolbar = no,menubar=no,status=no,scrollbars =no,resizable=no,width=]]></xsl:text><xsl:value-of select="@winW"/><xsl:text><![CDATA[,height=]]></xsl:text><xsl:value-of select="@winH"/><xsl:text><![CDATA[,left=100,top=60')"  style="color:blue"]]></xsl:text></xsl:when><xsl:otherwise><xsl:text><![CDATA[href="#" onclick="javascript:window.open(']]></xsl:text><xsl:value-of select="@url"/><xsl:text><![CDATA[','','toolbar = yes,menubar=yes,status= yes,scrollbars = yes,resizable=yes,width=940,height=600,left=20,top=20')"  style="color:blue"]]></xsl:text></xsl:otherwise></xsl:choose><xsl:text>href="#" onclick="javascript:window.open('</xsl:text><xsl:value-of select="@url"/><xsl:text><![CDATA[','','toolbar = yes,menubar=yes,status= yes,scrollbars = yes,resizable=yes,width=940,height=600,left=20,top=20')"  style="color:blue"]]></xsl:text></xsl:when>
			<xsl:otherwise><xsl:text><![CDATA[href = "]]></xsl:text><xsl:value-of select="@url"/><xsl:text><![CDATA[" style="color:blue"]]></xsl:text></xsl:otherwise>
		</xsl:choose></xsl:variable>
	<xsl:text>&lt;a </xsl:text><xsl:value-of select="$destination"/><xsl:text>&gt;</xsl:text><xsl:value-of select="."/><xsl:text>&lt;/a&gt;&lt;br&gt;</xsl:text>
	</xsl:template>
</xsl:stylesheet>