/*
 * Copyright (c) 2014, 2015, Oracle and/or its affiliates. All rights reserved.
 *
 * Version 1.4
 */

var nr_stars = 5;
var rating = 0;
var left, doc_user, doc_rating, book, library, page_uri, i, j;
var close_window_timeout = 0;
var html_lang;
var otn_doc_url = "docs.oracle.com";
var otn_doc_protocol = location.protocol + "//";
var textarea_limit = 500;
var virtual_library = otn_doc_protocol + otn_doc_url + "/cd/E53097_01";
var disable_star_rating = function () {
    $("#rating-1").removeClass("star-empty").removeClass("star-full").addClass("star-disable");
    $("#rating-2").removeClass("star-empty").removeClass("star-full").addClass("star-disable");
    $("#rating-3").removeClass("star-empty").removeClass("star-full").addClass("star-disable");
    $("#rating-4").removeClass("star-empty").removeClass("star-full").addClass("star-disable");
    $("#rating-5").removeClass("star-empty").removeClass("star-full").addClass("star-disable")
};
var remove_thanks_dialog = function () {
    $("#arrow").addClass("hide-form").removeClass("show-form");
    $("#star-rating-form-thanks").addClass("hide-form").removeClass("show-form");
    $("#star-rating-form").addClass("hide-form").removeClass("show-form")
};
var remove_thanks_dialog_timeout = function () {
    close_window_timeout = setTimeout(function () {
        remove_thanks_dialog()
    }, 2000)
};
var show_feedback_questionaire = function (c) {
    clearTimeout(close_window_timeout);
    var k = $("#mkh_div_doctitle").text();
    $("#rating-document-title").replaceWith("<h3>" + k + "</h3>");
    $("#arrow").css("left", left + c);
    $("#arrow").addClass("show-form").removeClass("hide-form");
    var m = getCookie("ORA_OTN_FEEDBACK_FORM_CHKBX");
    if (m !== null) {
        var f = $.parseJSON(unescape(m));
        var b;
        for (i = 0; i < f.length; i++) {
            b = f[i].checked;
            $("input[type=checkbox]#" + b).prop("checked", true);
            enable_checkbox_textarea(b)
        }
        enable_starrating_button()
    }
    var d = getCookie("ORA_OTN_FEEDBACK_FORM_LANG");
    d = unescape(d);
    if (d !== null) {
        if (d.indexOf("other-lang") !== -1) {
            var g = d.split(":");
            $("#dropdown_menu").val(g[0]);
            $("textarea#lang_text").removeClass("hide-form").addClass("show-form");
            $("textarea#lang_text").prop("disabled", false);
            $("textarea#lang_text").val(g[1])
        } else {
            $("#dropdown_menu").val(d)
        }
        $("#dropdown_menu").prop("disabled", false);
        enable_starrating_button()
    }
    var l = getCookie("ORA_OTN_FEEDBACK_FORM_FIX_CMNT");
    if (l !== null) {
        $("#incorrect_content_text").prop("disabled", false);
        $("#incorrect_content_text").val(unescape(l));
        var e = $("#incorrect_content_text").val().length;
        $("#chc_fix_incorrect_chkbx").text(e + " of " + textarea_limit);
        $("#chc_fix_incorrect_chkbx").removeClass("hide-form").addClass("show-form");
        enable_starrating_button()
    }
    var h = getCookie("ORA_OTN_FEEDBACK_FORM_MISSING_CMNT");
    if (h !== null) {
        $("#missing_info_text").prop("disabled", false);
        $("#missing_info_text").val(unescape(h));
        var e = $("#missing_info_text").val().length;
        $("#chc_provide_missing_chkbx").text(e + " of " + textarea_limit);
        $("#chc_provide_missing_chkbx").removeClass("hide-form").addClass("show-form");
        enable_starrating_button()
    }
    var a = getCookie("ORA_OTN_FEEDBACK_FORM_OTHER_CMNT");
    if (a !== null) {
        $("#feedback_comment_text").prop("disabled", false);
        $("#feedback_comment_text").val(unescape(a));
        var e = $("#feedback_comment_text").val().length;
        $("#chc_feedback_comment_chkbx").text(e + " of " + textarea_limit);
        $("#chc_feedback_comment_chkbx").removeClass("hide-form").addClass("show-form");
        enable_starrating_button()
    }
    $("#star-rating-form").addClass("show-form").removeClass("hide-form")
};
var show_thanks_dialog = function (a) {
    $("#arrow").css("left", left + a);
    $("#arrow").addClass("show-form").removeClass("hide-form");
    $("#star-rating-form-thanks").addClass("show-form").removeClass("hide-form")
};
var remove_feedback_questionaire = function () {
    $("#arrow").addClass("hide-form").removeClass("show-form");
    $("#star-rating-form").addClass("hide-form").removeClass("show-form")
};
var send_feedback_form_data = function (a, c) {
    var b, d;
    $.ajax({type: "GET", url: virtual_library + "/json/rating-apex.json", contentType: "application/json", dataType: "jsonp", jsonpCallback: "ratingApexCallback", success: function (e) {
            b = e.apex.submit_all;
            d = b + doc_user;
            c.document_url = a;
            $.ajax({type: "POST", dataType: "json", url: d, data: JSON.parse(JSON.stringify(c))})
        }, error: function (f, g, e) {
            disable_star_rating();
            $("#star-rating").unbind("click");
            console.log("Error Message: " + g);
            console.log("HTTP Error: " + e)
        }})
};
var create_star_rating = function () {
    $("<div>", {"class": "star-rating-form-wrapper"}).appendTo(".star-rating-wrapper");
    $("<div>", {id: "rate-text-info", text: "Rate this document:"}).appendTo(".star-rating-wrapper");
    $("<div>", {id: "stars"}).appendTo(".star-rating-wrapper");
    $("<ul>", {id: "star-rating"}).appendTo(".star-rating-wrapper #stars");
    for (i = 1; i <= nr_stars; i += 1) {
        $("<li>", {id: "rating-" + i, "class": "star-empty"}).appendTo("#star-rating")
    }
    var a = "/json/" + html_lang + "/rating-stars.json";
    $.ajax({type: "GET", url: virtual_library + a, contentType: "application/json", dataType: "jsonp", jsonpCallback: "ratingStarsCallback", success: function (b) {
            var d, c;
            d = b.rate_text_info;
            $("#rate-text-info").text(d);
            c = b.stars;
            $("#rating-1").prop("title", c.rating_1);
            $("#rating-2").prop("title", c.rating_2);
            $("#rating-3").prop("title", c.rating_3);
            $("#rating-4").prop("title", c.rating_4);
            $("#rating-5").prop("title", c.rating_5)
        }, error: function (c, d, b) {
            disable_star_rating();
            $("#star-rating").unbind("click");
            console.log("Error Message: " + d);
            console.log("HTTP Error: " + b)
        }})
};
var create_feedback_form = function () {
    var d, c, v, s, f, b, n, r, u, p, e, q, m, h, a, o, g, t, k, l;
    $("<div>", {"class": "star-rating-form-envelope"}).appendTo(".star-rating-form-wrapper");
    $("<div>", {"class": "hide-form", id: "arrow"}).appendTo(".star-rating-form-envelope");
    d = virtual_library + "/graphics/arrow.png";
    $("<img>", {src: d, alt: ""}).appendTo("#arrow");
    $("<div>", {"class": "hide-form", id: "star-rating-form"}).appendTo(".star-rating-form-envelope");
    $("<div>", {"class": "hide-form", id: "star-rating-form-thanks"}).appendTo(".star-rating-form-envelope");
    $("<div>", {id: "close-cross"}).appendTo("#star-rating-form");
    $("<img>", {src: virtual_library + "/graphics/close.png", alt: ""}).appendTo("#close-cross");
    $("<div>", {id: "form-text"}).appendTo("#star-rating-form");
    c = "/json/" + html_lang + "/rating-questions.json";
    $.ajax({type: "GET", url: virtual_library + c, dataType: "jsonp", contentType: "application/json", jsonpCallback: "ratingQuestionsCallback", success: function (w) {
            v = "";
            $("#form-text").append("<h3 id='rating-document-title'>" + v + "</h3>");
            s = w.text;
            $("#form-text").append(s);
            f = "Javascript:submit_data('" + page_uri + "')";
            $("<form>", {id: "checkbox-form", onsubmit: f}).appendTo("#star-rating-form");
            b = w.checkboxes;
            n = b.length;
            r = w.languages;
            u = r.length;
            for (i = 0; i < n; i += 1) {
                p = b[i].checkbox_text;
                e = b[i].checkbox_id;
                q = b[i].select_id;
                m = b[i].textarea_id;
                h = b[i].placeholder;
                a = b[i].textarea_select_id;
                o = b[i].textarea_select_placeholder;
                $("<input>", {type: "checkbox", "class": "star-rating-checkbox", id: e, name: e, value: p}).appendTo("#checkbox-form");
                $("<label>", {"for": e, text: p}).appendTo("#checkbox-form");
                if (q !== 0) {
                    $("<select>", {"class": "star-rating-dropdown " + e, id: q, name: "languages", disabled: "disabled"}).appendTo("#checkbox-form");
                    for (j = 0; j < u; j += 1) {
                        g = r[j].lang_id;
                        t = r[j].lang_val;
                        $("<option>", {value: g, text: t}).appendTo("#dropdown_menu")
                    }
                    if (a !== 0) {
                        $("<textarea>", {"class": "hide-form star-rating-textarea hide-on-uncheck " + e, id: a, rows: "2", maxlength: textarea_limit, value: "", placeholder: o}).appendTo("#checkbox-form")
                    }
                }
                if (m !== 0) {
                    $("<textarea>", {"class": "star-rating-textarea " + e, id: m, rows: "2", maxlength: textarea_limit, disabled: "disabled", value: "", onkeyup: "count_characters(this)", placeholder: h}).appendTo("#checkbox-form");
                    $("<div>", {"class": "char-counter hide-form", id: "chc_" + e}).insertAfter("#" + m)
                }
            }
            $(".char-counter").append("0 of " + textarea_limit);
            $("<br>").insertAfter("#star-rating-form label");
            $("<br>").insertAfter("#dropdown_menu");
            k = w.submit_button;
            l = w.close_button;
            $("<input>", {"class": "star-rating-button", id: k.button_id, type: "submit", value: k.button_name}).appendTo("#checkbox-form");
            $("<input>", {id: l.button_id, "class": "star-rating-button", type: "button", value: l.button_name}).appendTo("#checkbox-form");
            $("<div>", {"class": "clear"}).appendTo("#star-rating-form");
            $("<div>", {id: "legal-notices"}).appendTo("#star-rating-form");
            $("<a>", {href: "http://www.oracle.com/us/legal/terms/index.html", text: "Terms of Use | "}).appendTo("#legal-notices");
            $("<a>", {href: "http://www.oracle.com/us/legal/privacy/index.html", text: "Your Privacy Rights"}).appendTo("#legal-notices");
            var x = w.thanks;
            $("#star-rating-form-thanks").append(x)
        }, error: function (x, y, w) {
            disable_star_rating();
            $("#star-rating").unbind("click");
            console.log("Error Message: " + y);
            console.log("HTTP Error: " + w)
        }})
};
var color_star = function (a) {
    switch (a) {
        case"rating-1":
            $("#rating-1").removeClass("star-empty").addClass("star-full");
            $("#rating-2").removeClass("star-full").addClass("star-empty");
            $("#rating-3").removeClass("star-full").addClass("star-empty");
            $("#rating-4").removeClass("star-full").addClass("star-empty");
            $("#rating-5").removeClass("star-full").addClass("star-empty");
            break;
        case"rating-2":
            $("#rating-1").removeClass("star-empty").addClass("star-full");
            $("#rating-2").removeClass("star-empty").addClass("star-full");
            $("#rating-3").removeClass("star-full").addClass("star-empty");
            $("#rating-4").removeClass("star-full").addClass("star-empty");
            $("#rating-5").removeClass("star-full").addClass("star-empty");
            break;
        case"rating-3":
            $("#rating-1").removeClass("star-empty").addClass("star-full");
            $("#rating-2").removeClass("star-empty").addClass("star-full");
            $("#rating-3").removeClass("star-empty").addClass("star-full");
            $("#rating-4").removeClass("star-full").addClass("star-empty");
            $("#rating-5").removeClass("star-full").addClass("star-empty");
            break;
        case"rating-4":
            $("#rating-1").removeClass("star-empty").addClass("star-full");
            $("#rating-2").removeClass("star-empty").addClass("star-full");
            $("#rating-3").removeClass("star-empty").addClass("star-full");
            $("#rating-4").removeClass("star-empty").addClass("star-full");
            $("#rating-5").removeClass("star-full").addClass("star-empty");
            break;
        case"rating-5":
            $("#rating-1").removeClass("star-empty").addClass("star-full");
            $("#rating-2").removeClass("star-empty").addClass("star-full");
            $("#rating-3").removeClass("star-empty").addClass("star-full");
            $("#rating-4").removeClass("star-empty").addClass("star-full");
            $("#rating-5").removeClass("star-empty").addClass("star-full");
            break;
        default:
            break
        }
};
var handlerIn = function () {
    $(this).prevAll("li").removeClass("star-empty").addClass("star-full");
    $(this).nextAll("li").removeClass("star-full").addClass("star-empty");
    $(this).removeClass("star-empty").addClass("star-full")
};
var handlerOut = function () {
    $(this).prevAll("li").removeClass("star-full").addClass("star-empty");
    $(this).nextAll("li").removeClass("star-full").addClass("star-empty");
    $(this).removeClass("star-full").addClass("star-empty");
    color_star("rating-" + rating)
};
var set_rating = function (a) {
    remove_thanks_dialog();
    color_star(a);
    switch (a) {
        case"rating-1":
            rating = 1;
            show_feedback_questionaire(0);
            disable_starrating_button();
            break;
        case"rating-2":
            rating = 2;
            show_feedback_questionaire(17);
            disable_starrating_button();
            break;
        case"rating-3":
            rating = 3;
            show_feedback_questionaire(34);
            disable_starrating_button();
            break;
        case"rating-4":
            rating = 4;
            show_thanks_dialog(51);
            remove_thanks_dialog_timeout();
            break;
        case"rating-5":
            rating = 5;
            show_thanks_dialog(68);
            remove_thanks_dialog_timeout();
            break;
        default:
            break
        }
};
var enable_starrating_button = function () {
    $("#feedback-submit").prop("disabled", false)
};
var disable_starrating_button = function () {
    if ($("input:checkbox").length === $("input:checkbox").not(":checked").length) {
        $("#feedback-submit").prop("disabled", true)
    }
};
var reset_questionaire_values = function () {
    $("#star-rating-form input:checkbox").prop("checked", false);
    $("#star-rating-form textarea").prop("disabled", true);
    $("#star-rating-form textarea").prop("value", "");
    $("#star-rating-form select").prop("disabled", true);
    $("#star-rating-form select").val("")
};
var enable_checkbox_textarea = function (a) {
    $("#star-rating-form ." + a).prop("disabled", true);
    $("#chc_" + a).removeClass("hide-form").addClass("show-form")
};
var disable_checkbox_textarea = function (a) {
    $("#star-rating-form ." + a).prop("disabled", true);
    $("#star-rating-form ." + a).prop("value", "");
    $("#chc_" + a).removeClass("show-form").addClass("hide-form");
    $("#chc_" + a).text("0 of " + textarea_limit)
};
var enable_dropdown_menu = function (a) {
    $("#star-rating-form ." + a).prop("disabled", false)
};
var disable_dropdown_menu = function (a) {
    $("#star-rating-form ." + a).prop("disabled", true);
    $("#star-rating-form ." + a).val("")
};
var setCookie = function (a, b) {
    document.cookie = escape(a) + "=" + escape(b)
};
var setCookie_user = function (a, c, b) {
    document.cookie = escape(a) + "=" + escape(c) + ";domain=" + b + ";path=/"
};
var setCookie_form = function (a) {
    jsonObj = [];
    $("#checkbox-form input[type=checkbox]:checked").each(function () {
        var c = $(this);
        var d = $(c).prop("id");
        chkbx_item = {};
        chkbx_item.checked = d;
        jsonObj.push(chkbx_item)
    });
    var b = JSON.stringify(jsonObj);
    document.cookie = escape(a) + "=" + escape(b);
    return false
};
var setCookie_lang = function (a) {
    var b;
    if ($("input[type=checkbox]#provide_l10n_chkbx").is(":checked") === true) {
        b = $("select.star-rating-dropdown").find(":selected").val();
        if (b === "other-lang") {
            b = "other-lang:" + $("#lang_text").val()
        }
        document.cookie = escape(a) + "=" + escape(b)
    }
    return false
};
var setCookie_fix_incorrect_cmnt = function (a) {
    var b;
    if ($("input[type=checkbox]#fix_incorrect_chkbx").is(":checked") === true) {
        b = $("#incorrect_content_text").val();
        document.cookie = escape(a) + "=" + escape(b)
    }
    return false
};
var setCookie_provide_missing_cmnt = function (a) {
    var b;
    if ($("input[type=checkbox]#provide_missing_chkbx").is(":checked") === true) {
        b = $("#missing_info_text").val();
        document.cookie = escape(a) + "=" + escape(b)
    }
    return false
};
var setCookie_other_cmnt = function (a) {
    var b;
    if ($("input[type=checkbox]#feedback_comment_chkbx").is(":checked") === true) {
        b = $("#feedback_comment_text").val();
        document.cookie = escape(a) + "=" + escape(b)
    }
    return false
};
var getCookie = function (a) {
    var c, b;
    b = document.cookie.match("(^|;) ?" + a + "=([^;]*)(;|$)");
    c = b ? b[2] : null;
    return c
};
var deleteCookie = function (a) {
    document.cookie = escape(a) + "=; expires=Thu, 01 Jan 1970 00:00:00 UTC"
};
var call_survey = function () {
    var e, d, b, c, a, f, g;
    e = encodeURI(window.location);
    d = e.match("^http[s]?://(.*)");
    b = d[1];
    f = get_book_partnr();
    g = get_library_partnr();
    $.ajax({type: "GET", url: virtual_library + "/json/rating-apex.json", contentType: "application/json", dataType: "jsonp", jsonpCallback: "ratingApexCallback", success: function (h) {
            c = h.apex.survey;
            a = c + ":1:0::NO:1:P1_LIB,P1_BOOK,P1_URL,P1_LANG_SEL:" + g + "," + f + "," + b + "," + html_lang + ":&p_lang=" + html_lang;
            window.open(a, "_blank", "scrollbars=yes, resizable=yes, width=800, height=800")
        }, error: function (k, l, h) {
            disable_star_rating();
            $("#star-rating").unbind("click");
            console.log("Error Message: " + l);
            console.log("HTTP Error: " + h)
        }})
};
var get_html_lang = function () {
    var a = $("meta[name='language']").prop("content") || $("html").prop("lang") || "en";
    switch (a.toLowerCase().replace(/_/g, "-")) {
        case"de":
            break;
        case"fr":
            break;
        case"es":
            break;
        case"it":
            break;
        case"pt-br":
            a = "pt-br";
            break;
        case"ja":
            break;
        case"ko":
            break;
        case"zh":
            a = "zh-cn";
            break;
        case"zh-tw":
            a = "zh-tw";
            break;
        default:
            a = "en";
            break
    }
    return a
};
var submit_data = function (a) {
    var c = {}, e, b, f, d;
    $("#checkbox-form input:checkbox").each(function () {
        e = this.id;
        if ($(this).is(":checked")) {
            c[e] = "Y"
        } else {
            c[e] = "N"
        }
    });
    $("#checkbox-form textarea").each(function () {
        f = this.id;
        if (f !== "lang_text") {
            b = $("#" + f).val();
            if (b.length === 0) {
                b = null
            }
            c[f] = b
        }
    });
    d = $("#checkbox-form select option:selected").val();
    if (d === "other-lang") {
        if ($("textarea#lang_text").val().length !== 0) {
            d = $("textarea#lang_text").val()
        } else {
            d = "not specified"
        }
    }
    c.required_lang = d;
    send_feedback_form_data(a, c)
};
var send_star_rating = function (f, d, a, b, c, e) {
    switch (f) {
        case 0:
            $.ajax({type: "POST", dataType: "json", url: d, success: function (g) {
                    doc_user = g.ouser_id;
                    doc_rating = e;
                    setCookie("ORA_OTN_FEEDBACK_DOC_RATING", e);
                    setCookie_user("ORA_OTN_FEEDBACK_DOC_USER", doc_user, "oracle.com")
                }, data: {document_url: a, library: b, book: c, original_star_count: e, star_count: e}});
            break;
        case 1:
            $.ajax({type: "POST", url: d, success: function () {
                    doc_rating = e;
                    setCookie("ORA_OTN_FEEDBACK_DOC_RATING", e)
                }, error: function (k, g, h) {
                    console.log("error: " + k.status + " " + h)
                }, data: {star_count: e, original_star_count: e, document_url: a, library: b, book: c}});
            break;
        case 2:
            $.ajax({type: "POST", url: d, success: function () {
                    doc_rating = e;
                    setCookie("ORA_OTN_FEEDBACK_DOC_RATING", e)
                }, data: {document_url: a, library: b, book: c, original_star_count: e, star_count: e}});
            break;
        default:
            break
        }
};
var is_online = function () {
    var a = navigator.onLine;
    return a
};
var is_IE9 = function () {
    var d = -1;
    var a;
    if (navigator.appName == "Microsoft Internet Explorer") {
        var b = navigator.userAgent;
        var c = new RegExp("MSIE ([0-9]{1,}[.0-9]{0,})");
        if (c.exec(b) != null) {
            d = parseFloat(RegExp.$1)
        }
        if (d < 10) {
            a = true
        } else {
            a = false
        }
    } else {
        a = false
    }
    return a
};
var remove_unsupported_message = function () {
    $("#star-rating-form-unsupported").remove();
    $("#star-rating-form-unsupported").removeClass("show-form").addClass("hide-form")
};
var show_unsupported_message = function () {
    remove_unsupported_message();
    $("<div>", {id: "star-rating-form-unsupported", "class": "hide-form"}).appendTo(".star-rating-form-wrapper");
    $("#star-rating-form-unsupported").append("Not Supported. You are running an unsupported browser.");
    $("#star-rating-form-unsupported").removeClass("hide-form").addClass("show-form");
    setTimeout(function () {
        remove_unsupported_message()
    }, 2500)
};
var count_characters = function (c) {
    var a = c.value.length;
    if (a > textarea_limit) {
        c.value = c.value.substring(0, textarea_limit)
    } else {
        var b = $(c).prop("id");
        var d = $("#" + b).next().prop("id");
        $("#" + d).text(a + " of " + textarea_limit)
    }
};
var get_book_partnr = function () {
    var b;
    var c = $("#partnumber").length;
    var a = $("meta[name=partnumber]").length;
    if (a !== 0) {
        b = $("meta[name=partnumber]").prop("content")
    } else {
        if (c !== 0) {
            b = $("#partnumber").text()
        } else {
            regex = page_uri.match(".*/([^/]+)/html/([^/]+).*");
            if (regex !== null) {
                b = regex[2]
            }
        }
    }
    if (b === null || b === "") {
        b = "undetermined or landing page"
    }
    return b
};
var get_library_partnr = function () {
    var c;
    var a = $("#librarynumber").length;
    var b = $("meta[name=librarynumber]").length;
    if (b !== 0) {
        c = $("meta[name=librarynumber]").prop("content") + "_01"
    } else {
        if (a !== 0) {
            c = $("#librarynumber").text() + "_01"
        } else {
            regex = page_uri.match(".*/([^/]+)/html/([^/]+).*");
            if (regex !== null) {
                c = regex[1]
            }
        }
    }
    if (c === null || c === "") {
        c = "something wrong - please contact developers"
    }
    return c
};
var is_jquery_compatible = function () {
    var a = $.fn.jquery.split(".");
    if (a[0] >= 1 && a[1] >= 9) {
        return true
    } else {
        return false
    }
};
$(document).ready(function () {
    $.support.cors = true;
    html_lang = get_html_lang();
    if (!is_jquery_compatible()) {
        create_star_rating();
        disable_star_rating();
        for (i = 1; i <= nr_stars; i += 1) {
            $("#star-rating").on("click", "#rating-" + i, function () {
                show_unsupported_message()
            })
        }
        return 0
    }
    var c, a, b, g, f, e, d;
    if (is_online() && !is_IE9()) {
        create_star_rating();
        create_feedback_form();
        doc_rating = getCookie("ORA_OTN_FEEDBACK_DOC_RATING");
        rating = doc_rating;
        doc_user = getCookie("ORA_OTN_FEEDBACK_DOC_USER");
        color_star("rating-" + doc_rating);
        page_uri = encodeURI(window.location);
        library = get_library_partnr();
        book = get_book_partnr();
        left = $("#arrow").css("left");
        if (left != null) {
            left = parseInt(left.substring(0, left.length - 2), 10)
        }
        $("#star-rating li").mouseenter(handlerIn);
        $("#star-rating li").mouseleave(handlerOut);
        $.ajax({type: "GET", url: virtual_library + "/json/rating-apex.json", contentType: "application/json", dataType: "jsonp", jsonpCallback: "ratingApexCallback", success: function (h) {
                c = h.apex.new_rating;
                a = h.apex.update;
                for (i = 1; i <= nr_stars; i += 1) {
                    $("#star-rating").on("click", "#rating-" + i, function () {
                        g = $(this).prop("id");
                        set_rating(g);
                        if (doc_user !== null) {
                            if (doc_rating !== null) {
                                b = a + doc_user;
                                send_star_rating(1, b, page_uri, library, book, rating)
                            } else {
                                b = c + doc_user;
                                send_star_rating(2, b, page_uri, library, book, rating)
                            }
                        } else {
                            send_star_rating(0, c, page_uri, library, book, rating)
                        }
                    })
                }
            }, error: function (k, l, h) {
                disable_star_rating();
                $("#star-rating").unbind("click");
                console.log("Error Message: " + l);
                console.log("HTTP Error: " + h)
            }});
        $("#star-rating-form").on("click", "#feedback-close-butt", function () {
            remove_feedback_questionaire();
            show_thanks_dialog();
            remove_thanks_dialog_timeout();
            reset_questionaire_values()
        });
        $(".star-rating-form-wrapper").on("click", "#close-cross", function () {
            remove_feedback_questionaire();
            show_thanks_dialog();
            remove_thanks_dialog_timeout();
            reset_questionaire_values()
        });
        $(".star-rating-form-wrapper").on("change", "input", function () {
            e = $("#star-rating-form :checkbox").length;
            d = $("#star-rating-form input:checked").length;
            if (e === (e - d)) {
                disable_starrating_button()
            }
            if ($("#" + this.id).is(":checked")) {
                enable_starrating_button();
                enable_checkbox_textarea(this.id);
                enable_dropdown_menu(this.id)
            } else {
                $(".hide-on-uncheck." + this.id).removeClass("show-form").addClass("hide-form");
                disable_checkbox_textarea(this.id);
                disable_dropdown_menu(this.id)
            }
        });
        $(".star-rating-form-wrapper").on("change", "select", function () {
            var h = $("#" + this.id + " option:selected").val();
            if (h === "other-lang") {
                $("#lang_text").removeClass("hide-form").addClass("show-form");
                enable_checkbox_textarea(this.id)
            } else {
                $("#lang_text").removeClass("show-form").addClass("hide-form");
                disable_checkbox_textarea(this.id)
            }
        });
        $(".star-rating-form-wrapper").on("submit", "#star-rating-form", function () {
            remove_feedback_questionaire();
            show_thanks_dialog();
            remove_thanks_dialog_timeout();
            deleteCookie("ORA_OTN_FEEDBACK_FORM_CHKBX");
            setCookie_form("ORA_OTN_FEEDBACK_FORM_CHKBX");
            deleteCookie("ORA_OTN_FEEDBACK_FORM_LANG");
            setCookie_lang("ORA_OTN_FEEDBACK_FORM_LANG");
            deleteCookie("ORA_OTN_FEEDBACK_FORM_FIX_CMNT");
            setCookie_fix_incorrect_cmnt("ORA_OTN_FEEDBACK_FORM_FIX_CMNT");
            deleteCookie("ORA_OTN_FEEDBACK_FORM_MISSING_CMNT");
            setCookie_provide_missing_cmnt("ORA_OTN_FEEDBACK_FORM_MISSING_CMNT");
            deleteCookie("ORA_OTN_FEEDBACK_FORM_OTHER_CMNT");
            setCookie_other_cmnt("ORA_OTN_FEEDBACK_FORM_OTHER_CMNT");
            return false
        })
    } else {
        if (is_online()) {
            create_star_rating();
            disable_star_rating();
            for (i = 1; i <= nr_stars; i += 1) {
                $("#star-rating").on("click", "#rating-" + i, function () {
                    show_unsupported_message()
                })
            }
        }
    }
});