/*
* PasswordIdentityAsserter.cs
*
* Copyright (c) 2000, 2010, Oracle and/or its affiliates. All rights reserved.
*
* Oracle is a registered trademarks of Oracle Corporation and/or its
* affiliates.
*
* This software is the confidential and proprietary information of Oracle
* Corporation. You shall not disclose such confidential and proprietary
* information and shall use it only in accordance with the terms of the
* license agreement you entered into with Oracle.
*
* This notice may not be removed or altered.
*/﻿using System;
using System.Collections.Generic;
using System.Security;
using System.Security.Principal;
using System.Text;
using Tangosol.Net.Security;

namespace security
{
    /// <summary>
    /// PasswordIdentityAsserter asserts that the security token contains the
    /// required password and then constructs a Principal based on a list of
    /// role names.
    /// </summary>
    public class PasswordIdentityAsserter : IIdentityAsserter
    {
        #region IIdentityAsserter interface

        /// <summary>
        /// Transforms identity <see cref="IIdentityAsserter.AssertIdentity"/>
        /// </summary>        
        public IPrincipal AssertIdentity(object oToken)
        {
            if (oToken is object[])
            {
                String  sPassword = Environment.GetEnvironmentVariable(
                                       "coherence.password") ?? "secret-password";
                object[] aoName   = oToken as object[];

                // first name must be password and must have a user name and
                // at least one role name
                if (((string) aoName[0]).Equals(sPassword) && aoName.Length > 2)
                {
                    string[] asRoleName = new string[aoName.Length - 2];

                    // password is first element and name is second, then roles
                    // so create an array of role names
                    for (int i = 2; i < aoName.Length; i++)
                    {
                        asRoleName[i - 2] = (string) aoName[i];
                    }
                    return new GenericPrincipal(
                        new GenericIdentity((string) aoName[1]), asRoleName);
                }
            }
            throw new SecurityException("Access denied");
        }

        #endregion
    }
}
