/*
* PasswordIdentityAsserter.hpp
*
* Copyright (c) 2000, 2010, Oracle and/or its affiliates. All rights reserved.
*
* Oracle is a registered trademarks of Oracle Corporation and/or its
* affiliates.
*
* This software is the confidential and proprietary information of Oracle
* Corporation. You shall not disclose such confidential and proprietary
* information and shall use it only in accordance with the terms of the
* license agreement you entered into with Oracle.
*
* This notice may not be removed or altered.
*/
#ifndef COH_EXAMPLES_PASSWORDIDENTITYASSERTER_HPP
#define COH_EXAMPLES_PASSWORDIDENTITYASSERTER_HPP

#include "coherence/lang.ns"

#include "coherence/security/IdentityAsserter.hpp"
#include "coherence/security/auth/Subject.hpp"

COH_OPEN_NAMESPACE2(coherence,examples)

using coherence::security::IdentityAsserter;
using coherence::security::auth::Subject;

/**
* PasswordIdentityAsserter asserts that the security token contains the
* required password and then constructs a Subject based on a list of
* Principal names.
*
* @author dag 2010.04.30
*/
class PasswordIdentityAsserter
    : public class_spec<PasswordIdentityAsserter,
        extends<Object>,
        implements<IdentityAsserter> >
    {
    friend class factory<PasswordIdentityAsserter>;

    // ----- IdentityAsserter interface ----------------------------------

    public:
        /**
        * {@inheritDoc}
        */
        virtual Subject::View assertIdentity(Object::View vToken) const;
    };

COH_CLOSE_NAMESPACE2

#endif //COH_EXAMPLES_PASSWORDIDENTITYASSERTER_HPP
