/*
* PasswordIdentityAsserter.cpp
*
* Copyright (c) 2000, 2010, Oracle and/or its affiliates. All rights reserved.
*
* Oracle is a registered trademarks of Oracle Corporation and/or its
* affiliates.
*
* This software is the confidential and proprietary information of Oracle
* Corporation. You shall not disclose such confidential and proprietary
* information and shall use it only in accordance with the terms of the
* license agreement you entered into with Oracle.
*
* This notice may not be removed or altered.
*/
#include "PasswordIdentityAsserter.hpp"

#include "coherence/security/GenericPrincipal.hpp"
#include "coherence/security/auth/GenericSubject.hpp"
#include "coherence/util/HashSet.hpp"
#include "coherence/util/Set.hpp"

COH_OPEN_NAMESPACE2(coherence,examples)

using coherence::security::GenericPrincipal;
using coherence::security::auth::GenericSubject;
using coherence::util::HashSet;
using coherence::util::Set;

COH_REGISTER_TYPED_CLASS(PasswordIdentityAsserter);

// ----- IdentityAsserter interface --------------------------------------

Subject::View PasswordIdentityAsserter::assertIdentity(Object::View vToken) const
    {
    if (instanceof<ObjectArray::View>(vToken))
        {
        String::View      vsPassword     =
                System::getProperty("coherence.password", "secret-password");
        Set::Handle       hSetPrincipals = HashSet::create();
        ObjectArray::View haoName        = cast<ObjectArray::View>(vToken);

        // first name must be password
        if (cast<String::View>(haoName[0])->equals(vsPassword))
            {
            for (size32_t i = 1, len = haoName->length; i < len; i++)
                {
                hSetPrincipals->add(GenericPrincipal::create(
                    cast<String::View>(haoName[i])));
                }
            return GenericSubject::create((Set::View) hSetPrincipals);
            }
        }
    COH_THROW(SecurityException::create("Access denied"));
    }

COH_CLOSE_NAMESPACE2
