/*
* ExtendReadWriteBackingMap.java
*
* Copyright 2001-2007 by Oracle. All rights reserved.
*
* Oracle is a registered trademarks of Oracle Corporation and/or its
* affiliates.
*
* This software is the confidential and proprietary information of Oracle
* Corporation. You shall not disclose such confidential and proprietary
* information and shall use it only in accordance with the terms of the
* license agreement you entered into with Oracle.
*
* This notice may not be removed or altered.
*/
package com.tangosol.examples.extend;


import com.tangosol.net.BackingMapManagerContext;

import com.tangosol.net.cache.CacheLoader;
import com.tangosol.net.cache.CacheStore;
import com.tangosol.net.cache.ReadWriteBackingMap;

import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ObservableMap;

import java.util.Collection;
import java.util.Map;


/**
* Trivial ReadWriteBackingMap extension that allows the internal map to be
* replicated on demand to a remote site via Coherence*Extend.
*
* @author jh  2007.09.05
*/
public class ExtendReadWriteBackingMap
        extends ReadWriteBackingMap
    {
    /**
    * {@inheritDoc}
    */
    public ExtendReadWriteBackingMap(BackingMapManagerContext ctxService,
            ObservableMap mapInternal, Map mapMisses, CacheLoader loader)
        {
        super(ctxService, mapInternal, mapMisses, loader);
        }

    /**
    * {@inheritDoc}
    */
    public ExtendReadWriteBackingMap(BackingMapManagerContext ctxService, ObservableMap mapInternal,
            Map mapMisses, CacheStore store, boolean fReadOnly, int cWriteBehindSeconds)
        {
        super(ctxService, mapInternal, mapMisses, store, fReadOnly,
                cWriteBehindSeconds);
        }

    /**
    * {@inheritDoc}
    */
    public ExtendReadWriteBackingMap(BackingMapManagerContext ctxService, ObservableMap mapInternal,
            Map mapMisses, CacheStore store, boolean fReadOnly,
            int cWriteBehindSeconds, double dflRefreshAheadFactor)
        {
        super(ctxService, mapInternal, mapMisses, store, fReadOnly,
                cWriteBehindSeconds, dflRefreshAheadFactor);
        }


    // ----- replication support --------------------------------------------

    /**
    * Replicate the contents of the internal map to the remote site via
    * Coherence*Extend.
    */
    public void replicate()
        {
        ConcurrentMap mapControl = getControlMap();
        mapControl.lock(ConcurrentMap.LOCK_ALL, -1L);
        try
            {
            CacheStore store = getCacheStore();
            if (store instanceof ExtendCacheStoreWrapper)
                {
                // NOTE: this could be done in batches, if so desired
                ((ExtendCacheStoreWrapper) store).storeAllInternal(getInternalCache());
                }
            }
        finally
            {
            mapControl.unlock(ConcurrentMap.LOCK_ALL);
            }
        }


    // ----- ExtendCacheStoreWrapper inner class ----------------------------

    /**
    * {@inheritDoc}
    */
    protected CacheStoreWrapper instantiateCacheStoreWrapper(CacheStore store)
        {
        return store == null ? null : new ExtendCacheStoreWrapper(store);
        }

    /**
    * CacheStoreWrapper subclass that overrides load() and loadAll() to be
    * no-ops. Subclasses are free to override these methods and/or store()
    * and storeAll() to implement read/write-through caching to an external
    * data store.
    */
    public class ExtendCacheStoreWrapper
            extends CacheStoreWrapper
        {
        // ----- Constructors ---------------------------------------------

        /**
        * {@inheritDoc}
        */
        public ExtendCacheStoreWrapper(CacheStore store)
            {
            super(store);
            }

        // ----- CacheStore interface -------------------------------------

        /**
        * {@inheritDoc}
        */
        public Object load(Object oKey)
            {
            return null;
            }

        /**
        * {@inheritDoc}
        */
        public Map loadAll(Collection colKeys)
            {
            return NullImplementation.getMap();
            }

        // ----- CacheStoreWrapper methods --------------------------------

        /**
        * {@inheritDoc}
        */
        protected void storeAllInternal(Map mapEntries)
            {
            super.storeAllInternal(mapEntries);
            }
        }
    }