<!--
| jmx_header.inc
|
| Copyright 2000-2006 by Tangosol, Inc.  All rights reserved.
|
| This software is the confidential and proprietary information of
| Tangosol, Inc.  You shall not disclose such confidential and pro-
| prietary information and shall use it only in accordance with the
| terms of the license agreement you entered into with Tangosol, Inc.
|
| Tangosol, Inc. makes no representations or warranties about the suit-
| ability of the software, either express or implied, including but not
| limited to the implied warranties of merchantability, fitness for a
| particular purpose, or non-infringement.  Tangosol, Inc. shall not be
| liable for any damages suffered by licensee as a result of using,
| modifying or distributing this software or its derivatives.
|
| Tangosol, Inc. is located at http://www.tangosol.com and can be
| contacted by e-mail at info@tangosol.com.
|
| This notice may not be removed or altered.
-->

<%@ page import="java.lang.reflect.Constructor,
                 java.util.Comparator,
                 javax.management.Attribute,
                 javax.management.MalformedObjectNameException,
                 javax.management.MBeanInfo,
                 javax.management.MBeanServer,
                 javax.management.MBeanServerFactory,
                 javax.management.ObjectName,
                 javax.management.MBeanAttributeInfo,
                 javax.servlet.jsp.JspException"%>

<%!
  /**
  * Page names.
  */
  public static final String PAGE_INDEX        = "index.jsp";
  public static final String PAGE_INFO         = "info.jsp";
  public static final String PAGE_HELP         = "help.jsp";

  /**
  * Parameter names.
  */
  public static final String PARAM_OBJECT_NAME = "object";
  public static final String PARAM_RESET       = "reset";
  public static final String PARAM_SET         = "set";

  /**
  * The default and Coherence JMX management domain names.
  */
  public static final String DOMAIN_DEFAULT    = "";
  public static final String DOMAIN            = "Coherence";

  /**
  * Return an MBeanServer for the default JMX management domain.
  *
  * @return the MBeanServer
  */
  public static MBeanServer getMBeanServer()
    {
    MBeanServer server = null;
    for (Iterator iter = MBeanServerFactory.findMBeanServer(null).iterator();
         iter.hasNext();)
      {
      server = (MBeanServer) iter.next();
      if (DOMAIN_DEFAULT.length() == 0 ||
          server.getDefaultDomain().equals(DOMAIN_DEFAULT))
        {
        break;
        }
      server = null;
      }
    if (server == null)
      {
      server = MBeanServerFactory.createMBeanServer(DOMAIN_DEFAULT);
      }

    return server;
    }

  /**
  * Create a new ObjectName instance with the given name. The returned
  * ObjectName is scoped to the Coherence management domain.
  *
  * @param sName the String representation of the ObjectName
  *
  * @return the new ObjectName
  *
  * @throws JspException on error creating the ObjectName
  */
  public static ObjectName createObjectName(String sName)
    throws JspException
    {
    try
      {
      return new ObjectName(DOMAIN + ':' + sName);
      }
    catch (MalformedObjectNameException e)
      {
      throw new JspException("Malformed JMX ObjectName", e);
      }
    }

  /**
  * Format the given MBean attribute name.
  *
  * @param sAttrName the MBean attribute name
  *
  * @return a formatted MBean attribute name
  */
  public static String formatAttributeName(String sAttrName)
    {
    StringBuffer sb     = new StringBuffer();
    boolean      fLower = false;

    for (int i = 0; i < sAttrName.length(); ++i)
      {
      char c = sAttrName.charAt(i);
      if (fLower && Character.isUpperCase(c))
        {
        fLower = false;
        sb.append("&nbsp;");
        }
      else
        {
        fLower = Character.isLowerCase(c);
        }
      sb.append(c);
      }

    return sb.toString();
    }

  /**
  * Return a URL string to the specified page.
  *
  * @param sPage    the destination page
  * @param objName  the ObjectName to pass to the page
  * @param response the HTTP response object
  *
  * @return the URL string
  */
  public static String createUrl(String sPage, ObjectName objName, HttpServletResponse response)
    {
    return createUrl(sPage, objName.getCanonicalKeyPropertyListString(), response);
    }

  /**
  * Return a URL string to the specified page.
  *
  * @param sPage    the destination page
  * @param sObjName the ObjectName parameter to pass to the page
  * @param response the HTTP response object
  *
  * @return the URL string
  */
  public static String createUrl(String sPage, String sObjName, HttpServletResponse response)
    {
    String sUrl = sObjName == null
        ? sPage
        : sPage + '?' + PARAM_OBJECT_NAME + '=' + sObjName;
    return response.encodeURL(sUrl);
    }

  /**
  * Convert the given object to a value compatible with the specified MBean
  * attribute and return a new Attribute that contains the converted value.
  *
  * @param sAttrName the name of the attribute
  * @param info      the MBeanInfo used to determine the attribute data type
  * @param oValue    the value to convert
  *
  * @return a new Attribute containing the converted value
  *
  * @throws Exception on error
  */
  public static Attribute createAttribute(String sAttrName, MBeanInfo info, Object oValue)
      throws Exception
    {
    Attribute attr  = null;
    Class     clazz = null;

    MBeanAttributeInfo[] aAttrInfo = info.getAttributes();
    for (int i = 0; i < aAttrInfo.length; ++i)
      {
      if (aAttrInfo[i].getName().equals(sAttrName))
        {
        clazz = Class.forName(aAttrInfo[i].getType());
        break;
        }
      }

    if (clazz != null)
      {
      Constructor constructor = clazz.getConstructor(new Class[]{oValue.getClass()});
      Object      oConverted  = constructor.newInstance(new Object[]{oValue});

      attr = new Attribute(sAttrName, oConverted);
      }

    return attr;
    }

  /**
  * Comparator implementation that compares ObjectName objects.
  * <br/>
  * The Comparator first compares a single property value from each of the
  * ObjectName objects. If the property values are equal, the cononical names of
  * the two ObjectName objects are compared.
  */
  private static class ObjectNameComparator implements Comparator
    {
    /**
    * Construct a new ObjectNameComparator that uses the given key to compare
    * ObjectName objects.
    *
    * @param sKey the key to use in the comparison
    */
    public ObjectNameComparator(String sKey)
      {
      this.sKey = sKey;
      }

    /**
    * Compare the two ObjectName instances.
    *
    * @param o1 the first ObjectName to compare
    * @param o2 the second ObjectName to compare
    *
    * @return a negative integer, zero, or a positive integer as the first
    *         argument is less than, equal to, or greater than the second.
    */
    public int compare(Object o1, Object o2)
      {
      ObjectName on1 = (ObjectName) o1;
      ObjectName on2 = (ObjectName) o2;

      String sProp1 = on1.getKeyProperty(sKey);
      String sProp2 = on2.getKeyProperty(sKey);

      int nResult = sProp1.compareTo(sProp2);
      if (nResult == 0)
        {
        nResult = on1.getCanonicalName().compareTo(on2.getCanonicalName());
        }

      return nResult;
      }

    /**
    * The key to use in the comparison.
    */
    private String sKey;
    }
%>

<html>
<title>Tangosol Coherence: JMX Demo</title>
<body>

<a href="http://www.tangosol.com/" target="_blank">
  <img src="images/Tangosol.gif" border="0" align="top" vspace="0" hspace="0"/>
</a>