<!--
| info.jsp
|
| Copyright 2000-2006 by Tangosol, Inc.  All rights reserved.
|
| This software is the confidential and proprietary information of
| Tangosol, Inc.  You shall not disclose such confidential and pro-
| prietary information and shall use it only in accordance with the
| terms of the license agreement you entered into with Tangosol, Inc.
|
| Tangosol, Inc. makes no representations or warranties about the suit-
| ability of the software, either express or implied, including but not
| limited to the implied warranties of merchantability, fitness for a
| particular purpose, or non-infringement.  Tangosol, Inc. shall not be
| liable for any damages suffered by licensee as a result of using,
| modifying or distributing this software or its derivatives.
|
| Tangosol, Inc. is located at http://www.tangosol.com and can be
| contacted by e-mail at info@tangosol.com.
|
| This notice may not be removed or altered.
-->

<%@ page import="javax.management.Attribute,
                 javax.management.MBeanAttributeInfo,
                 javax.management.MBeanInfo,
                 javax.management.MBeanServer,
                 javax.management.ObjectName,
                 java.util.Iterator,
                 java.util.Map"%>
<%@ page import="java.lang.reflect.Array"%>

<%@ include file="jmx_header.inc" %>

<%
  final String PAGE_THIS = PAGE_INFO;
  String       sObjName  = request.getParameter(PARAM_OBJECT_NAME);
  if (sObjName != null)
    {
    ObjectName           objName   = createObjectName(sObjName);
    MBeanServer          server    = getMBeanServer();
    MBeanInfo            info      = server.getMBeanInfo(objName);
    MBeanAttributeInfo[] aAttrInfo = info.getAttributes();
    String               sObjType  = objName.getKeyProperty("type");

    sObjType = sObjType.equalsIgnoreCase("Node") ? "Member" : sObjType;
%>
<br>
<center>
<h2><%= sObjType %> Information:</h2>
[ObjectName=<b><%= objName.getCanonicalName() %></b>]
<%
    // perform any updates, if necessary
    if (request.getParameter(PARAM_SET) != null)
      {
      for (Iterator iter = request.getParameterMap().entrySet().iterator(); iter.hasNext(); )
        {
        Map.Entry entry       = (Map.Entry) iter.next();
        String    sParamName  = (String) entry.getKey();
        String    sParamValue = ((String[]) entry.getValue())[0];

        if (!sParamName.equals(PARAM_OBJECT_NAME) &&
            !sParamName.equals(PARAM_RESET) &&
            !sParamName.equals(PARAM_SET))
          {
          try
            {
            Attribute attr = createAttribute(sParamName, info, sParamValue);
            server.setAttribute(objName, attr);
            }
          catch (Exception e)
            {
%>
<br/>
<font color="red">An error occured while updating attribute <%= sParamName %>: <%= e.toString() %></font>
<%
            e.printStackTrace();
            }
          }
        }
      }

    // reset statistics, if necessary
    if (request.getParameter(PARAM_RESET) != null)
      {
      try
        {
        server.invoke(objName, "resetStatistics", new Object[0], new String[0]);
        }
      catch (Exception e)
        {
%>
<br/>
<font color="red">An error occured while resetting statistics: <%= e.toString() %></font>
<%
        e.printStackTrace();
        }
      }
%>
<p/>
<form action="<%= response.encodeURL(PAGE_THIS) %>" method="post">
<input type="hidden" name="<%= PARAM_OBJECT_NAME %>" value="<%= sObjName %>"/>
<input type="hidden" name="<%= PARAM_SET %>" value="on"/>
<table border=3>
  <tr align="left">
    <td bgcolor="#C01020"><b><font color="white">Attribute:</font></b></td>
    <td bgcolor="#C01020"><b><font color="white">Value:</font></b></td>
    <td bgcolor="#C01020"><b><font color="white">New&nbsp;Value:</font></b></td>
  </tr>
<%
    // display all the target MBean Attributes, including the description, name,
    // and value; if the Attribute is writable, construct a form input
    for (int i = 0; i < aAttrInfo.length; ++i)
      {
      String sAttrDesc  = aAttrInfo[i].getDescription();
      String sAttrName  = aAttrInfo[i].getName();
      Object oAttrValue = server.getAttribute(objName, sAttrName);

      if (oAttrValue.getClass().isArray())
        {
        StringBuffer sb = new StringBuffer();
        for (int c = Array.getLength(oAttrValue), j = 0; j < c; ++j)
          {
          if (j > 0)
            {
            sb.append(", ");
            }
          sb.append(Array.get(oAttrValue, j));
          }
        
        oAttrValue = sb.toString();
        }
%>
  <tr align="left">
    <td>
      <a href="javascript:alert('<%= sAttrDesc %>');">
        <b><%= formatAttributeName(sAttrName) %>:</b>
      </a>
    </td>
    <td><%= oAttrValue %></td>
<%
      String sInput;
      if (aAttrInfo[i].isWritable())
        {
        sInput = "<input type=\"text\" name=\""
            + sAttrName
            + "\" value=\""
            + oAttrValue
            + "\"/>";
        }
      else if (sAttrName.equalsIgnoreCase("statistics"))
        {
        sInput = "Reset:&nbsp;<input type=\"checkbox\" name=\""
            + PARAM_RESET
            + "\"/>";
        }
      else
        {
        sInput = "&nbsp;";
        }
%>
    <td><%= sInput %></td>
  </tr>
<%
    }
  }
%>
  <tr align="left">
    <td>&nbsp;</td>
    <td>&nbsp;</td>
    <td><input type="submit" value="Submit"/></td>
  </tr>
</table>
</form>
</center>

<%@ include file="jmx_footer.inc" %>