<!--
| index.jsp
|
| Copyright 2000-2006 by Tangosol, Inc.  All rights reserved.
|
| This software is the confidential and proprietary information of
| Tangosol, Inc.  You shall not disclose such confidential and pro-
| prietary information and shall use it only in accordance with the
| terms of the license agreement you entered into with Tangosol, Inc.
|
| Tangosol, Inc. makes no representations or warranties about the suit-
| ability of the software, either express or implied, including but not
| limited to the implied warranties of merchantability, fitness for a
| particular purpose, or non-infringement.  Tangosol, Inc. shall not be
| liable for any damages suffered by licensee as a result of using,
| modifying or distributing this software or its derivatives.
|
| Tangosol, Inc. is located at http://www.tangosol.com and can be
| contacted by e-mail at info@tangosol.com.
|
| This notice may not be removed or altered.
-->

<%@ page import="javax.management.MBeanServer,
                 javax.management.ObjectName,
                 java.util.Collections,
                 java.util.HashMap,
                 java.util.Iterator,
                 java.util.LinkedList,
                 java.util.List,
                 java.util.Map"%>

<%@ include file="jmx_header.inc" %>

<br>
<center>
<h2>Cluster Information:</h2>
<table border=3>
  <tr align="left" bgcolor="#C01020">
    <td><b><font color="white">Cluster:</font></b></td>
  </tr>
<%
  final String PAGE_THIS  = PAGE_INDEX;
  MBeanServer  server     = getMBeanServer();

  // retrieve cluster information
  ObjectName objName      = createObjectName("type=Cluster");
  String     sClusterName = (String) server.getAttribute(objName, "ClusterName");
  int[]      aiMemberIds  = (int[]) server.getAttribute(objName, "MemberIds");

  if (sClusterName == null || sClusterName.length() == 0)
    {
    sClusterName = "Default";
    }

  StringBuffer sb = new StringBuffer(sClusterName).append("(MemberIds=");
  for (int i = 0; i < aiMemberIds.length; ++i)
    {
    if (i > 0)
      {
      sb.append(", ");
      }
    sb.append(aiMemberIds[i]);
    }
  sb.append(')');

  String sUrl = createUrl(PAGE_INFO, "type=Cluster", response);
%>
  <tr>
    <td>
      <a href="<%= sUrl %>"><%= sb %></a>
    </td>
  </tr>
</table>

<h2>Member Information:</h2>
<table border=3>
  <tr align="left" bgcolor="#C01020">
    <td><b><font color="white">Member ID:</font></b></td>
  </tr>

<%
  objName          = createObjectName("type=Node,*");
  List listMembers = new LinkedList(server.queryNames(objName, null));

  Collections.sort(listMembers, new ObjectNameComparator("nodeId"));
  for (Iterator iter = listMembers.iterator(); iter.hasNext(); )
    {
    String sMemberId = ((ObjectName) iter.next()).getKeyProperty("nodeId");
    sUrl = createUrl(PAGE_INFO, "type=Node,nodeId=" + sMemberId, response);
%>
  <tr>
    <td>
      <a href="<%= sUrl %>"><%= sMemberId %></a>
    </td>
  </tr>
<%
    }
%>
</table>

<h2>Service Information:</h2>
<table border=3>
  <tr align="left" bgcolor="#C01020">
    <td><b><font color="white">Service&nbsp;Name:</font></b></td>
    <td><b><font color="white">Member&nbsp;ID:</font></b></td>
  </tr>
<%
  // retrieve service information by populating a map that maps from a service
  // name to a list of ObjectName objects, one per member running the service
  objName         = createObjectName("type=Service,*");
  Map mapServices = new HashMap();

  for (Iterator iter = server.queryNames(objName, null).iterator(); iter.hasNext(); )
    {
    objName = (ObjectName) iter.next();

    String sServiceName = objName.getKeyProperty("name");
    List   listObjNames = (List) mapServices.get(sServiceName);

    if (listObjNames == null)
      {
      listObjNames = new LinkedList();
      mapServices.put(sServiceName, listObjNames);
      }

    listObjNames.add(objName);

    if (listObjNames.size() > 1)
      {
      Collections.sort(listObjNames, new ObjectNameComparator("nodeId"));
      }
    }

  // display all service information
  List listServices = new LinkedList(mapServices.keySet());

  Collections.sort(listServices);
  for (Iterator iter = listServices.iterator(); iter.hasNext(); )
    {
    String sServiceName = (String) iter.next();
    List   listObjNames = (List) mapServices.get(sServiceName);

    sb.setLength(0);
    for (Iterator iterObjNames = listObjNames.iterator(); iterObjNames.hasNext(); )
      {
      objName = (ObjectName) iterObjNames.next();

      sb.append("<a href=\"");
      sb.append(createUrl(PAGE_INFO, objName, response));
      sb.append("\">");
      sb.append(objName.getKeyProperty("nodeId"));
      sb.append("</a>");

      if (iterObjNames.hasNext())
        {
        sb.append(",&nbsp;");
        }
      }
%>
  <tr align="left">
    <td><%= sServiceName %></td>
    <td><%= sb %></td>
  </tr>
<%
    }
%>
</table>

<h2>Cache Information:</h2>
<table border=3>
  <tr align="left" bgcolor="#C01020">
    <td><b><font color="white">Cache&nbsp;Name:</font></b></td>
    <td><b><font color="white">Service&nbsp;Name:</font></b></td>
    <td><b><font color="white">Tier:</font></b></td>
    <td><b><font color="white">ClassLoader&nbsp;ID:</font></b></td>
    <td><b><font color="white">Member&nbsp;ID:</font></b></td>
  </tr>
<%
  // display all cache information
  objName         = createObjectName("type=Cache,*");
  List listCaches = new LinkedList(server.queryNames(objName, null));

  Collections.sort(listCaches, new ObjectNameComparator("name"));
  for (Iterator iter = listCaches.iterator(); iter.hasNext(); )
    {
    objName = (ObjectName) iter.next();

    String sLoader   = objName.getKeyProperty("loader");
    String sMemberId = objName.getKeyProperty("nodeId");
    String sTier     = objName.getKeyProperty("tier");

    sUrl    = createUrl(PAGE_INFO, objName, response);
    sLoader = sLoader == null ? "&nbsp;" : sLoader;
    sTier   = sTier   == null ? "&nbsp;" : sTier;

    String sRef = "<a href=\"" + sUrl + "\">" + sMemberId + "</a>";
%>
  <tr align="left">
    <td><%= objName.getKeyProperty("name") %></td>
    <td><%= objName.getKeyProperty("service") %></td>
    <td><%= sTier %></td>
    <td><%= sLoader %></td>
    <td><%= sRef %></td>
  </tr>
<%
      }
%>
</table>
</center>

<%@ include file="jmx_footer.inc" %>