/*
* Account.java
*
* Copyright 2001-2008 by Oracle. All rights reserved.
*
* Oracle is a registered trademarks of Oracle Corporation and/or its
* affiliates.
*
* This software is the confidential and proprietary information of Oracle
* Corporation. You shall not disclose such confidential and proprietary
* information and shall use it only in accordance with the terms of the
* license agreement you entered into with Oracle.
*
* This notice may not be removed or altered.
*/
package com.tangosol.examples.cppexample;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.util.ExternalizableHelper;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Account implements ExternalizableLite
    {

    public Account()
        {
        }

    public String getName()
        {
        return m_sName;
        }

    public void setName(String sName)
        {
        m_sName = sName;
        }

    public int getId()
        {
        return m_iId;
        }

    public void setId(int iId)
        {
        m_iId = iId;
        }

    public double getBalance()
        {
        return m_dBalance;
        }

    public void setBalance(double dBalance)
        {
        m_dBalance = dBalance;
        }


    public void readExternal(DataInput in) throws IOException
        {
        m_sName    = ExternalizableHelper.readSafeUTF(in);
        m_iId      = ExternalizableHelper.readInt(in);
        m_dBalance = in.readDouble();
        }

    public void writeExternal(DataOutput out) throws IOException
        {
        ExternalizableHelper.writeSafeUTF(out, m_sName);
        ExternalizableHelper.writeInt(out, m_iId);
        out.writeDouble(m_dBalance);
        }

    public String toString()
        {
        return "Account[name=" + m_sName + ", id=" + m_iId + ", balance=" + m_dBalance + "]";
        }

    String m_sName;
    int    m_iId;
    double m_dBalance;
    }
