/*
* utils.h
*
* Copyright 2001-2008 by Oracle. All rights reserved.
*
* Oracle is a registered trademarks of Oracle Corporation and/or its
* affiliates.
*
* This software is the confidential and proprietary information of Oracle
* Corporation. You shall not disclose such confidential and proprietary
* information and shall use it only in accordance with the terms of the
* license agreement you entered into with Oracle.
*
* This notice may not be removed or altered.
*/
#ifndef _UTILS_H_
#define _UTILS_H_

#include <jni.h>

/**
* Trivial JNI utilities
*/ 
class Utils {
public:
    /**
     * Return singleton JNIEnv pointer
     */
    static JNIEnv* getEnv() {
        return s_env;
    }
    
    static void ensureJVM(int argc, char* const argv[]);                                                          // start the JVM    
    static jclass ensureClass(const char* pszClassName);                                                          // obtain class reference
    static jmethodID ensureMethod(const jclass clazz, const char* pszMethodName, const char* pszSignature);       // obtain method id
    static jmethodID ensureStaticMethod(const jclass clazz, const char* pszMethodName, const char* pszSignature); // obtain static method id
    
private:
    static JavaVM* s_jvm;
    static JNIEnv* s_env;
};

#endif

