/*
* main.cpp
*
* Copyright 2001-2008 by Oracle. All rights reserved.
*
* Oracle is a registered trademarks of Oracle Corporation and/or its
* affiliates.
*
* This software is the confidential and proprietary information of Oracle
* Corporation. You shall not disclose such confidential and proprietary
* information and shall use it only in accordance with the terms of the
* license agreement you entered into with Oracle.
*
* This notice may not be removed or altered.
*/
#include <iostream>
#include <string.h>

#include "account.h"
#include "accountcache.h"
#include "utils.h"

/**
 * Account logging support
 */ 
std::ostream& operator<<(std::ostream& out, const Account& account) {
    out << "Account[name=" << account.getName() << ", id=" << account.getId() << ", balance=" << account.getBalance() << "]"; 
    return out;
}

/**
 * Test harness. Command line arguments are passed directly to the JVM
 */
int main (int argc, char * const argv[]) {

    Utils::ensureJVM(argc, argv);                   // Initialize JVM
    Cache* pCache = new AccountCache("test");       // Instantiate AccountCache
        
    //
    // Check for memory leaks (thus infinite loop)
    //
    while (true) {
        int  i;
        char sName[100];
        
        //
        // Populate the cache
        //   
        
        // test regular put()
        for (i = 1; i <= 100; i++) {
            sprintf(sName, "Account:%d", i);
            Account* pAccount    = new Account(sName, i, 100.01 + i);
            Account* pOldAccount = (Account*) pCache->put((void*)i, pAccount);
            if (pOldAccount != NULL) {
                delete pOldAccount;
            }
            delete pAccount;
        }
        
        std::cout << "Cache size: " << pCache->size() << std::endl;
        
        // test putBlind()
        for (; i <= 200; i++) {
            sprintf(sName, "Account:%d", i);
            Account* pAccount = new Account(sName, i, 100.01 + i);
            pCache->putBlind((void*)i, pAccount);
            delete pAccount;            
        }
        
        std::cout << "Cache size: " << pCache->size() << std::endl;
        
        //
        // Dump and modify cache content
        // also test lock/unlock
        //        
        for (i = -100; i <= 1000; i++) {
            Account* pAccount = (Account*) pCache->get((void*)i);
            if (pAccount != NULL) {
                std::cout << "Account from cache: " << pAccount[0] << std::endl;
                if (pCache->lock((void*)i, -1L)) {
                    pAccount->setBalance(pAccount->getBalance() * 2);
                    pCache->putBlind((void*)i, pAccount);
                    pCache->unlock((void*)i);
                } else {
                    std::cerr << "Failed to obtain lock" << std::endl;
                    exit(-1);
                }
                delete pAccount;
            }
        }
        
        //
        // Remove everything from the cache
        //
        for (i = -1000; i <= 1000; i++) {
            Account* pOldAccount = (Account*) pCache->remove((void*)i);
            if (pOldAccount != NULL) {
                std::cout << "Removed from cache: " << pOldAccount[0] << std::endl;
                delete pOldAccount;
            }
        }
        
        std::cout << "Cache size: " << pCache->size() << std::endl;
    }    
    
    return 0;
}
